# Generated by default/object.tt
package Paws::SecurityHub::AwsSecurityFindingIdentifier;
  use Moose;
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has ProductArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsSecurityFindingIdentifier

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsSecurityFindingIdentifier object:

  $service_obj->Method(Att1 => { Id => $value, ..., ProductArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsSecurityFindingIdentifier object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

Identifies a finding to update using C<BatchUpdateFindings>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Id => Str

The identifier of the finding that was specified by the finding
provider.


=head2 B<REQUIRED> ProductArn => Str

The ARN generated by Security Hub that uniquely identifies a product
that generates findings. This can be the ARN for a third-party product
that is integrated with Security Hub, or the ARN for a custom
integration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

