#!/usr/bin/env perl
#-*-perl-*-
#
#

## make this a module
package ISO::639::5;

# use 5.006;
use strict;
use warnings;

use utf8;
use open ':locale';
use Pod::Usage;
# use ISO::639::3;

=head1 NAME

ISO::639::5 - Language groups

=head1 VERSION

Version 0.01

=cut

our $VERSION      = '0.01';

use Exporter 'import';
our @EXPORT = qw(
    language_group
    language_parent
);
our %EXPORT_TAGS = ( all => \@EXPORT );


=head1 SYNOPSIS

    use ISO::639::5 qw/:all/;

=cut

our $LanguageGroup;
our $LanguageParent;

$LanguageGroup = {
  'sal' => [
    'cjh',
    'clm',
    'liw',
    'coo',
    'cow',
    'crd',
    'fla',
    'hur',
    'lil',
    'nok',
    'oka',
    'qun',
    'shs',
    'spo',
    'squ',
    'str',
    'thp'
  ],
  'fiu' => [
    'chm',
    'est',
    'fin',
    'fit',
    'fkv',
    'hun',
    'izh',
    'kca',
    'kkt',
    'krl',
    'kom',
    'liv',
    'mdf',
    'mns',
    'mrj',
    'myv',
    'ong',
    'smi',
    'udm',
    'vep',
    'vot',
    'vro'
  ],
  'omv' => [
    'aiw',
    'bcq',
    'bwo',
    'dim',
    'doz',
    'jnj',
    'mdx',
    'noz',
    'shx',
    'wal',
    'zwa'
  ],
  'dra' => [
    'brh',
    'gon',
    'iru',
    'kfa',
    'kfc',
    'kff',
    'kmj',
    'kan',
    'kru',
    'kru',
    'kxu',
    'kxv',
    'mjt',
    'mjv',
    'mal',
    'muv',
    'tam',
    'tcx',
    'tcy',
    'tel'
  ],
  'sgn' => [
    'csn',
    'fcs',
    'fsl',
    'ils',
    'isg',
    'rsl'
  ],
  'esx' => [
    'ale',
    'ipk',
    'iku',
    'kal',
    'ypk',
    'ysr'
  ],
  'tut' => [
    'nog',
    'trk',
    'tuw',
    'xgn'
  ],
  'cau' => [
    'ccn',
    'ccs'
  ],
  'cpf' => [
    'acf',
    'cks',
    'crs',
    'gcf',
    'gcr',
    'hat',
    'kmv',
    'loj',
    'mfe',
    'rcf'
  ],
  'pra' => [
    'pli',
    'san'
  ],
  'nic' => [
    'alv',
    'dmn',
    'eka',
    'kdo',
    'lam',
    'nqo',
    'nyo',
    'tog',
    'znd'
  ],
  'afa' => [
    'ber',
    'bxe',
    'cdc',
    'cop',
    'cus',
    'egy',
    'omv',
    'sem',
    'zwa'
  ],
  'ine' => [
    'aln',
    'anp',
    'bat',
    'cel',
    'cms',
    'gem',
    'grk',
    'hit',
    'hlu',
    'hye',
    'iir',
    'imy',
    'itc',
    'plq',
    'scx',
    'sdt',
    'sla',
    'sqi',
    'txb',
    'txh',
    'xcl',
    'xcr',
    'xdc',
    'xlc',
    'xld',
    'xlg',
    'xls',
    'xmk',
    'xpg',
    'xps',
    'xsd',
    'xto',
    'xve'
  ],
  'zhx' => [
    'cdo',
    'cjy',
    'cpx',
    'czh',
    'czo',
    'gan',
    'hak',
    'hsn',
    'ltc',
    'mnp',
    'nan',
    'och',
    'wuu',
    'wxa',
    'yue',
    'zho'
  ],
  'xgn' => [
    'bub',
    'dta',
    'kxs',
    'mhj',
    'mjg',
    'mon',
    'mvf',
    'peh',
    'sce',
    'xal',
    'xwo',
    'yuy'
  ],
  'bnt' => [
    'abb',
    'asa',
    'auh',
    'bas',
    'beb',
    'bem',
    'beq',
    'bez',
    'bip',
    'bja',
    'bkh',
    'bkw',
    'bng',
    'bni',
    'bqz',
    'brf',
    'btb',
    'bmv',
    'bvb',
    'bwt',
    'bxg',
    'cgg',
    'cjk',
    'cwe',
    'dav',
    'dez',
    'dma',
    'dua',
    'ebu',
    'eko',
    'eto',
    'ewo',
    'fan',
    'fip',
    'guz',
    'haq',
    'heh',
    'hke',
    'hoo',
    'her',
    'jmc',
    'kdx',
    'kck',
    'kcv',
    'kde',
    'kon',
    'kik',
    'kua',
    'kkj',
    'kmb',
    'koo',
    'koq',
    'kqn',
    'ksb',
    'ksf',
    'kws',
    'kzo',
    'lag',
    'lch',
    'lug',
    'lik',
    'lin',
    'lol',
    'loz',
    'lub',
    'lua',
    'lue',
    'lun',
    'luy',
    'lyn',
    'mbo',
    'mdw',
    'mnu',
    'mgh',
    'mhb',
    'mhw',
    'mye',
    'nba',
    'nde',
    'ndc',
    'ndo',
    'ngc',
    'ngl',
    'njx',
    'nmg',
    'nnb',
    'nbl',
    'nse',
    'nso',
    'nya',
    'nyf',
    'nym',
    'nyn',
    'pic',
    'run',
    'rng',
    'rof',
    'kin',
    'rwk',
    'rwm',
    'sbp',
    'seh',
    'shr',
    'sna',
    'snq',
    'urw',
    'ssw',
    'sot',
    'suk',
    'swa',
    'swb',
    'tll',
    'tsn',
    'toi',
    'tso',
    'tum',
    'umb',
    'ven',
    'vif',
    'vmk',
    'vun',
    'wdd',
    'wlc',
    'wni',
    'xho',
    'xog',
    'yao',
    'zdj',
    'zmw',
    'zul'
  ],
  'gem' => [
    'gme',
    'gmq',
    'gmw'
  ],
  'ngb' => [
    'sag'
  ],
  'gmq' => [
    'dan',
    'fao',
    'isl',
    'nob',
    'nno',
    'non',
    'nrn',
    'ovd',
    'rmg',
    'swe'
  ],
  'kar' => [
    'kvq'
  ],
  'mun' => [
    'hoc',
    'pcj',
    'sat',
    'unr'
  ],
  'ypk' => [
    'ems',
    'ess',
    'esu',
    'ynk'
  ],
  'jpx' => [
    'jpn'
  ],
  'myn' => [
    'acr',
    'agu',
    'caa',
    'cac',
    'cak',
    'ctu',
    'hus',
    'itz',
    'ixl',
    'jac',
    'kek',
    'kjb',
    'knj',
    'mam',
    'mhc',
    'mop',
    'poc',
    'poh',
    'quc',
    'qum',
    'quv',
    'toj',
    'ttc',
    'tzh',
    'tzj',
    'tzo',
    'usp',
    'yua'
  ],
  'poz' => [
    'aol',
    'bhp',
    'end',
    'hvn',
    'ivv',
    'kei',
    'kvh',
    'mqy',
    'nxe',
    'ple',
    'plf',
    'pqe',
    'pqw',
    'ski',
    'tao',
    'xbr',
    'xxk'
  ],
  'zle' => [
    'bel',
    'orv',
    'rus',
    'rue',
    'ukr'
  ],
  'ccn' => [
    'abk',
    'abq',
    'ady',
    'agx',
    'akv',
    'ani',
    'aqc',
    'ava',
    'bbl',
    'bdk',
    'bph',
    'che',
    'cji',
    'dar',
    'ddo',
    'gdo',
    'gin',
    'huz',
    'inh',
    'ykm',
    'kbd',
    'khv',
    'kjj',
    'kpt',
    'kry',
    'kva',
    'lbe',
    'lez',
    'rut',
    'tab',
    'tin',
    'tkr',
    'uby',
    'udi'
  ],
  'nah' => [
    'nci'
  ],
  'xsi' => [
    'asb',
    'bll',
    'cro',
    'dak',
    'hid',
    'iow',
    'ksk',
    'lkt',
    'mhq',
    'ofo',
    'oma',
    'osa',
    'qua',
    'sto',
    'tta',
    'win',
    'xwc'
  ],
  'urj' => [
    'fiu',
    'syd'
  ],
  'syd' => [
    'mtm',
    'nio',
    'sel',
    'xas',
    'yrk'
  ],
  'znd' => [
    'zne'
  ],
  'plf' => [
    'alo',
    'amv',
    'gap',
    'hbu',
    'kje',
    'lti',
    'mhs',
    'szn',
    'tet',
    'tlv',
    'txn',
    'wha'
  ],
  'son' => [
    'ddn',
    'dje',
    'kcy',
    'khq',
    'ses',
    'twq'
  ],
  'paa' => [
    'aau',
    'anz',
    'ddg',
    'gak',
    'kax',
    'kmo',
    'lvk',
    'mqt',
    'nas',
    'ngf',
    'pgu',
    'saj',
    'tcm',
    'tft',
    'tif',
    'tlb',
    'tqu',
    'waj',
    'wli',
    'yee',
    'zuh'
  ],
  'cdc' => [
    'anc',
    'ank',
    'bid',
    'daa',
    'hau',
    'hed',
    'lme',
    'maf',
    'mcn',
    'mmy',
    'mpz',
    'mse',
    'mug',
    'nnc',
    'nnn',
    'pip',
    'sor',
    'tmc',
    'zim',
    'zuy'
  ],
  'omq' => [
    'cco',
    'coz',
    'czn',
    'ixc',
    'maj',
    'maq',
    'miz',
    'mxb',
    'oto',
    'pbs',
    'pmq',
    'pmz',
    'tpc',
    'tpl',
    'tpx',
    'trs',
    'zap',
    'zaw',
    'ztq',
    'zty'
  ],
  'zlw' => [
    'ces',
    'csb',
    'czk',
    'pol',
    'pox',
    'slk',
    'szl',
    'wen'
  ],
  'sdv' => [
    'ach',
    'alz',
    'anu',
    'bfa',
    'ddd',
    'din',
    'enb',
    'eyo',
    'kdj',
    'keo',
    'kln',
    'kpz',
    'lky',
    'lot',
    'lpx',
    'luo',
    'mas',
    'mqu',
    'muz',
    'niq',
    'nsg',
    'nub',
    'nus',
    'saq',
    'sgc',
    'shk',
    'tec',
    'teo',
    'toq',
    'tuv',
    'tuy'
  ],
  'alv' => [
    'aba',
    'abi',
    'abr',
    'ado',
    'ada',
    'adj',
    'agq',
    'ajg',
    'aka',
    'anw',
    'atk',
    'avi',
    'ayb',
    'azo',
    'bad',
    'bai',
    'bax',
    'bba',
    'bce',
    'bci',
    'bda',
    'beh',
    'bfd',
    'bfl',
    'bgj',
    'bim',
    'bin',
    'bju',
    'bkc',
    'bkm',
    'blo',
    'bmq',
    'bnt',
    'bqj',
    'bsc',
    'cae',
    'cou',
    'cwt',
    'dag',
    'dij',
    'dop',
    'dur',
    'dyo',
    'ebr',
    'ewe',
    'efi',
    'fap',
    'ful',
    'fod',
    'fon',
    'ttb',
    'gba',
    'gej',
    'gjn',
    'gkn',
    'goy',
    'gur',
    'gux',
    'ibo',
    'ijo',
    'jab',
    'kbp',
    'kcj',
    'kdh',
    'keu',
    'kia',
    'kma',
    'knf',
    'kqs',
    'kro',
    'krx',
    'kss',
    'kzc',
    'kzr',
    'ldm',
    'lee',
    'lmp',
    'lob',
    'mdd',
    'mfq',
    'mfv',
    'mgo',
    'mlo',
    'mnh',
    'mor',
    'mos',
    'mql',
    'mua',
    'myk',
    'mzm',
    'mzv',
    'mzw',
    'naj',
    'ndv',
    'nfr',
    'nga',
    'ngb',
    'nie',
    'nku',
    'ntm',
    'nza',
    'nzi',
    'ogc',
    'oku',
    'otr',
    'ozm',
    'pbo',
    'pbp',
    'pil',
    'pny',
    'pug',
    'sav',
    'sev',
    'shz',
    'snf',
    'soy',
    'spp',
    'srr',
    'tbz',
    'kdh',
    'tfi',
    'tik',
    'tiv',
    'tkq',
    'tnr',
    'tui',
    'tuz',
    'urh',
    'wci',
    'wol',
    'wwa',
    'xsm',
    'xwe',
    'yav',
    'yky',
    'yor'
  ],
  'fox' => [
    'bnn',
    'bzg',
    'ckv',
    'dru',
    'fos',
    'pwn',
    'pyu',
    'ssf',
    'sxr',
    'tay',
    'trv',
    'tsu',
    'uun',
    'xnb',
    'xsy'
  ],
  'iro' => [
    'cay',
    'chr',
    'lre',
    'moh',
    'ntw',
    'one',
    'ons',
    'see',
    'sqn',
    'tus',
    'wya'
  ],
  'ath' => [
    'aht',
    'apa',
    'bcr',
    'bea',
    'caf',
    'chp',
    'clc',
    'crx',
    'den',
    'dgr',
    'gwi',
    'haa',
    'hup',
    'ing',
    'kkz',
    'koy',
    'kuu',
    'srs',
    'tau',
    'tcb',
    'tgx',
    'tht',
    'jic'
  ],
  'ccs' => [
    'kat',
    'lzz',
    'sva',
    'xmf'
  ],
  'ssa' => [
    'csu',
    'dzg',
    'fvr',
    'gly',
    'guk',
    'ikx',
    'kbl',
    'kie',
    'kmq',
    'kau',
    'lgn',
    'mde',
    'mls',
    'rou',
    'sdv',
    'son',
    'teu',
    'tuq',
    'udu',
    'wti',
    'xmr',
    'xom'
  ],
  'bat' => [
    'lit',
    'ltg',
    'lav',
    'ndf',
    'olt',
    'prg',
    'sgs',
    'svx',
    'sxl',
    'xcu',
    'xgl',
    'xsv',
    'xzm'
  ],
  'cel' => [
    'bre',
    'cym',
    'gle',
    'gla',
    'glv',
    'cor',
    'mga',
    'nrc',
    'obt',
    'owl',
    'sga',
    'wlm',
    'xbm',
    'xcb',
    'xce',
    'xga',
    'xpi'
  ],
  'dai' => [
    'bth',
    'lra',
    'sdo',
    'sne'
  ],
  'cus' => [
    'aar',
    'arv',
    'bej',
    'bji',
    'byn',
    'dal',
    'irk',
    'orm',
    'orc',
    'sid',
    'som',
    'ssn',
    'ssy'
  ],
  'phi' => [
    'akl',
    'bik',
    'blf',
    'bno',
    'bnq',
    'ceb',
    'cps',
    'fil',
    'gqr',
    'hil',
    'ibg',
    'ibl',
    'ify',
    'ilk',
    'ilo',
    'kak',
    'krj',
    'kyj',
    'kyk',
    'loc',
    'mdh',
    'mno',
    'mog',
    'mrw',
    'msb',
    'pag',
    'pmn',
    'rth',
    'sgd',
    'snl',
    'sxn',
    'tbl',
    'tdn',
    'kak',
    'tnt',
    'tnw',
    'tom',
    'txs',
    'war'
  ],
  'aql' => [
    'alg',
    'wiy',
    'yur'
  ],
  'auf' => [
    'aru',
    'cul',
    'dny',
    'pad',
    'swx'
  ],
  'awd' => [
    'aca',
    'ame',
    'apu',
    'bae',
    'brg',
    'ccc',
    'cui',
    'gob',
    'guc',
    'guh',
    'guo',
    'ign',
    'inp',
    'kpc',
    'mbn',
    'not',
    'pbg',
    'pib',
    'pio',
    'plu',
    'tae',
    'trn',
    'ycn'
  ],
  'tup' => [
    'eme',
    'grn',
    'gui',
    'guq',
    'gyr',
    'kay',
    'kgk',
    'kpn',
    'ktn',
    'kyr',
    'mpu',
    'myu',
    'nhd',
    'psm',
    'skf',
    'srq',
    'tpj',
    'tpr',
    'tpw',
    'twt',
    'wyr',
    'yrl'
  ],
  'aus' => [
    'bck',
    'dbl',
    'ddj',
    'gbu',
    'gni',
    'kdd',
    'kjn',
    'kld',
    'mep',
    'nha',
    'nuy',
    'pix',
    'pkn',
    'vma',
    'vmb',
    'wbp',
    'wmt',
    'xbp',
    'xrg',
    'yii',
    'yij'
  ],
  'zls' => [
    'bul',
    'bos',
    'chu',
    'hrv',
    'mkd',
    'slv',
    'srp'
  ],
  'map' => [
    'fox',
    'lcl',
    'lnd',
    'poz'
  ],
  'aav' => [
    'irr',
    'kdt',
    'mkh',
    'mun',
    'nyl',
    'sss',
    'tth'
  ],
  'azc' => [
    'chl',
    'com',
    'cup',
    'hch',
    'hop',
    'lui',
    'mfy',
    'mnr',
    'nah',
    'ntp',
    'ood',
    'opt',
    'pao',
    'par',
    'pia',
    'ppl',
    'ser',
    'shh',
    'stp',
    'tac',
    'tar',
    'tla',
    'tub',
    'var',
    'xaw',
    'xgf',
    'yaq'
  ],
  'khi' => [
    'hts',
    'ktz',
    'kwz',
    'naq',
    'nmn',
    'sad'
  ],
  'euq' => [
    'eus'
  ],
  'dmn' => [
    'bib',
    'bam',
    'bqc',
    'dnj',
    'dyu',
    'goa',
    'kax',
    'knk',
    'kno',
    'knu',
    'kpe',
    'lom',
    'man',
    'men',
    'mlq',
    'moa',
    'mwk',
    'rkm',
    'snk',
    'sus',
    'vai',
    'xkg',
    'yal'
  ],
  'hmx' => [
    'bje',
    'bpn',
    'buh',
    'bwn',
    'cqd',
    'hmd',
    'hml',
    'hmn',
    'hnj',
    'ium',
    'mji',
    'mmr',
    'mww',
    'pha',
    'pnu',
    'shx'
  ],
  'btk' => [
    'akb',
    'bbc',
    'btd',
    'btm',
    'bts',
    'btx',
    'btz'
  ],
  'tuw' => [
    'eve',
    'evn',
    'gld',
    'juc',
    'mnc',
    'neg',
    'oaa',
    'oac',
    'orh',
    'sjo',
    'ude',
    'ulc'
  ],
  'csu' => [
    'avu',
    'bdh',
    'bex',
    'bot',
    'kcm',
    'led',
    'mdi',
    'mdj',
    'mhi',
    'mwm',
    'myb',
    'niy',
    'sba'
  ],
  'cdd' => [
    'aac',
    'cad',
    'kii',
    'paw',
    'wic'
  ],
  'iir' => [
    'ask',
    'bsh',
    'inc',
    'ira',
    'prn',
    'wbk',
    'xvi'
  ],
  'inc' => [
    'asm',
    'awa',
    'bgc',
    'bhb',
    'bho',
    'bjj',
    'bkk',
    'ben',
    'bns',
    'bpy',
    'bra',
    'ccp',
    'ctg',
    'dml',
    'doi',
    'div',
    'emx',
    'guj',
    'gwc',
    'gwt',
    'hin',
    'hif',
    'hne',
    'khw',
    'kls',
    'kok',
    'kas',
    'lah',
    'mag',
    'mai',
    'mar',
    'mvy',
    'mwr',
    'nep',
    'ori',
    'pan',
    'phl',
    'pra',
    'raj',
    'rml',
    'rmq',
    'rmt',
    'rom',
    'scl',
    'snd',
    'sdg',
    'sin',
    'skr',
    'syl',
    'urd'
  ],
  'cmc' => [
    'ace',
    'cje',
    'cjm',
    'hro',
    'huq',
    'jra',
    'rad',
    'rog'
  ],
  'kro' => [
    'ald',
    'bsq',
    'dic',
    'grb',
    'gud',
    'gxx',
    'ney',
    'nwb',
    'wec'
  ],
  'aqa' => [
    'alc'
  ],
  'nub' => [
    'fia',
    'onw'
  ],
  'grk' => [
    'cpg',
    'ell',
    'gmy',
    'grc',
    'pnt',
    'tsd',
    'yej'
  ],
  'sit' => [
    'dzo',
    'ero',
    'grt',
    'hmr',
    'hni',
    'iii',
    'jkr',
    'kac',
    'kar',
    'lbj',
    'lus',
    'mni',
    'mya',
    'new',
    'njh',
    'njm',
    'nmy',
    'nwc',
    'nxq',
    'qvy',
    'sxg',
    'tbq',
    'tsj',
    'txg',
    'xsr',
    'zhx'
  ],
  'sem' => [
    'aao',
    'acw',
    'acy',
    'aeb',
    'afb',
    'aii',
    'ajt',
    'akk',
    'amh',
    'amw',
    'apc',
    'ara',
    'arc',
    'arq',
    'ary',
    'arz',
    'ayl',
    'gdq',
    'gez',
    'har',
    'heb',
    'jrb',
    'mey',
    'mlt',
    'phn',
    'snx',
    'shu',
    'smp',
    'sqr',
    'syc',
    'tir',
    'tig',
    'tmr',
    'uga',
    'xaa',
    'xeb',
    'xpu'
  ],
  'hok' => [
    'acv',
    'atw',
    'boi',
    'cid',
    'coc',
    'crz',
    'esq',
    'inz',
    'kju',
    'klb',
    'kyh',
    'mov',
    'mrc',
    'obi',
    'peb',
    'pef',
    'pej',
    'peq',
    'pmo',
    'poo',
    'ppi',
    'puy',
    'sei',
    'sht',
    'sln',
    'veo',
    'was',
    'ynn',
    'yuf',
    'yum'
  ],
  'gme' => [
    'got',
    'xvn'
  ],
  'art' => [
    'afh',
    'avk',
    'bzt',
    'dws',
    'epo',
    'ina',
    'ile',
    'igs',
    'ido',
    'jbo',
    'ldn',
    'lfn',
    'neu',
    'nov',
    'qya',
    'rmv',
    'sjn',
    'tlh',
    'tzl',
    'vol',
    'zbl'
  ],
  'tbq' => [
    'adx',
    'anm',
    'bod',
    'bqh',
    'brx',
    'duu',
    'ers',
    'gqi',
    'gro',
    'jya',
    'lhu',
    'lpo',
    'mxj',
    'njo',
    'nun',
    'trp',
    'twm'
  ],
  'apa' => [
    'apj',
    'apk',
    'apl',
    'apw',
    'nav'
  ],
  'ngf' => [
    'bjz',
    'ekg',
    'uhn'
  ],
  'wak' => [
    'dtd',
    'has',
    'hei',
    'kwk',
    'myh',
    'noc'
  ],
  'pqw' => [
    'abl',
    'abs',
    'abx',
    'ban',
    'bdg',
    'bdl',
    'bdr',
    'beg',
    'bew',
    'bjn',
    'bkz',
    'bsu',
    'btk',
    'buc',
    'bug',
    'cha',
    'cia',
    'cmc',
    'dai',
    'dbj',
    'drg',
    'dtr',
    'dun',
    'dup',
    'duq',
    'duw',
    'eno',
    'gay',
    'goq',
    'iba',
    'ind',
    'jav',
    'kaw',
    'kge',
    'kjc',
    'kjk',
    'kqr',
    'ktq',
    'kvr',
    'kxd',
    'kyi',
    'kys',
    'lbw',
    'lbx',
    'lce',
    'lcf',
    'ley',
    'liw',
    'ljp',
    'llk',
    'mad',
    'mak',
    'mdr',
    'mfa',
    'mfb',
    'mlg',
    'mhy',
    'min',
    'mkm',
    'mqn',
    'msa',
    'mtd',
    'mui',
    'mwv',
    'mxr',
    'myl',
    'mzq',
    'nia',
    'nij',
    'nrm',
    'otd',
    'pau',
    'pdo',
    'pel',
    'phi',
    'pku',
    'pse',
    'raz',
    'ree',
    'rej',
    'sas',
    'sda',
    'sjm',
    'skh',
    'slm',
    'sml',
    'smr',
    'smw',
    'snv',
    'ssb',
    'sse',
    'sun',
    'sya',
    'tdi',
    'dtp',
    'tdx',
    'tjg',
    'tkg',
    'tlk',
    'twy',
    'txy',
    'ulu',
    'vkl',
    'vko',
    'wow',
    'wru',
    'xkq',
    'xmv',
    'xmw',
    'xmz',
    'yka',
    'zbc',
    'zbe',
    'zbw'
  ],
  'bai' => [
    'bbj',
    'bko',
    'byv',
    'fmp',
    'jgo',
    'nla',
    'nnh',
    'nnz',
    'nwe',
    'xmg',
    'ybb'
  ],
  'oto' => [
    'otm'
  ],
  'mul' => [
    'aav',
    'afa',
    'aqa',
    'aql',
    'art',
    'auf',
    'aus',
    'awd',
    'azc',
    'cau',
    'cba',
    'cdd',
    'dra',
    'esx',
    'euq',
    'hmx',
    'hok',
    'ine',
    'iro',
    'jpx',
    'khi',
    'map',
    'myn',
    'nic',
    'omq',
    'paa',
    'sal',
    'sgn',
    'xsi',
    'sit',
    'ssa',
    'taw',
    'tup',
    'tut',
    'urj',
    'wak',
    'xnd'
  ],
  'roa' => [
    'arg',
    'ast',
    'cat',
    'cos',
    'cpf',
    'cpp',
    'dlm',
    'egl',
    'spa',
    'ext',
    'fax',
    'fra',
    'frc',
    'frm',
    'fro',
    'frp',
    'fvr',
    'glg',
    'ist',
    'ita',
    'lad',
    'lij',
    'lld',
    'lmo',
    'mwl',
    'mxi',
    'nap',
    'nrf',
    'oci',
    'osp',
    'pcd',
    'pms',
    'por',
    'rgn',
    'roh',
    'ron',
    'ruo',
    'rup',
    'ruq',
    'srd',
    'scn',
    'sdc',
    'sdn',
    'vec',
    'wln'
  ],
  'taw' => [
    'lao',
    'tha'
  ],
  'pqe' => [
    'agw',
    'ahb',
    'aia',
    'aie',
    'aji',
    'akr',
    'alm',
    'alu',
    'ane',
    'anx',
    'apb',
    'app',
    'apr',
    'asz',
    'aty',
    'aua',
    'aud',
    'aul',
    'auq',
    'aut',
    'baa',
    'bch',
    'bcm',
    'bcu',
    'bgt',
    'bhc',
    'bhw',
    'biq',
    'bjk',
    'blp',
    'blq',
    'bnk',
    'bnr',
    'bpa',
    'brr',
    'btr',
    'buk',
    'bvc',
    'bvd',
    'bwd',
    'bxa',
    'bxf',
    'bzh',
    'bzq',
    'cal',
    'cam',
    'chk',
    'crc',
    'ddi',
    'dgg',
    'dhv',
    'dob',
    'dor',
    'kzk',
    'erg',
    'erk',
    'etn',
    'faf',
    'far',
    'fij',
    'frt',
    'fud',
    'fut',
    'fwa',
    'gdd',
    'gei',
    'gfk',
    'gga',
    'ggt',
    'ghn',
    'gil',
    'kzk',
    'gmb',
    'goo',
    'gri',
    'grz',
    'gzn',
    'hah',
    'hao',
    'haw',
    'hiw',
    'hla',
    'hoa',
    'hrw',
    'iai',
    'irh',
    'jae',
    'jaj',
    'jaz',
    'kbm',
    'kdk',
    'khl',
    'kij',
    'kji',
    'kkk',
    'klv',
    'koa',
    'kos',
    'kpg',
    'kqw',
    'krf',
    'ksd',
    'ksg',
    'ktm',
    'kvc',
    'kwd',
    'kwf',
    'kxr',
    'kzk',
    'kzu',
    'lbb',
    'lbv',
    'lcm',
    'lek',
    'ler',
    'leu',
    'lga',
    'lgb',
    'lgk',
    'lgl',
    'lgr',
    'lgu',
    'lht',
    'lib',
    'lid',
    'lkn',
    'lle',
    'llf',
    'llp',
    'llu',
    'llx',
    'lmg',
    'lml',
    'lmu',
    'lmv',
    'loj',
    'los',
    'lpa',
    'lrv',
    'lrz',
    'lww',
    'mee',
    'mek',
    'met',
    'meu',
    'mft',
    'mgl',
    'mah',
    'mri',
    'mkj',
    'mkv',
    'mky',
    'mla',
    'mln',
    'mlu',
    'mlv',
    'mme',
    'mmg',
    'mmt',
    'mmw',
    'mmx',
    'mna',
    'mnv',
    'mox',
    'mpr',
    'mpy',
    'mqa',
    'mqm',
    'mrb',
    'mrl',
    'mrm',
    'mrn',
    'mrq',
    'mrv',
    'msq',
    'mte',
    'mtt',
    'mvo',
    'mwc',
    'mwh',
    'mwi',
    'mwo',
    'mxe',
    'nau',
    'nal',
    'ncc',
    'ncf',
    'ncn',
    'nee',
    'nem',
    'nqn',
    'nfl',
    'ngr',
    'niu',
    'nke',
    'nkr',
    'nlg',
    'nmb',
    'nmk',
    'nms',
    'nmt',
    'nnd',
    'npn',
    'nsn',
    'nss',
    'nsw',
    'nua',
    'nuw',
    'nwi',
    'olr',
    'omb',
    'onu',
    'ora',
    'pek',
    'pex',
    'pfa',
    'pgk',
    'pif',
    'piv',
    'piz',
    'pkg',
    'pma',
    'pme',
    'pmt',
    'pnh',
    'pon',
    'pop',
    'ppn',
    'pri',
    'pss',
    'psw',
    'ptp',
    'ptv',
    'puw',
    'pwg',
    'rai',
    'rak',
    'rap',
    'rar',
    'ray',
    'roe',
    'rri',
    'rro',
    'rug',
    'sax',
    'sbb',
    'sbc',
    'sbe',
    'sbh',
    'sgz',
    'sij',
    'sjr',
    'sku',
    'slz',
    'smo',
    'sns',
    'sob',
    'sol',
    'sov',
    'sps',
    'ssg',
    'stn',
    'stw',
    'swp',
    'szw',
    'tbc',
    'tbe',
    'tbf',
    'tbj',
    'tgc',
    'tgi',
    'tgp',
    'tgs',
    'tio',
    'tkl',
    'tkp',
    'tkw',
    'tlm',
    'tlr',
    'tlx',
    'tmb',
    'tmi',
    'tmy',
    'tnk',
    'tnl',
    'tnn',
    'tnp',
    'tnx',
    'ton',
    'tox',
    'tpv',
    'tpz',
    'tql',
    'tqp',
    'tsr',
    'ttu',
    'ttv',
    'tuc',
    'tva',
    'tvk',
    'tvl',
    'twp',
    'tah',
    'ubr',
    'uge',
    'uli',
    'upv',
    'urr',
    'urv',
    'utp',
    'uve',
    'uvl',
    'vao',
    'vmg',
    'vnk',
    'vnm',
    'vra',
    'vrs',
    'vrt',
    'wiv',
    'wls',
    'woe',
    'wuv',
    'wwo',
    'wyy',
    'xsi',
    'yap',
    'yly',
    'zgr'
  ],
  'ira' => [
    'ave',
    'bal',
    'bsg',
    'ckb',
    'fas',
    'glk',
    'hac',
    'haz',
    'isk',
    'jdt',
    'jpr',
    'kho',
    'kur',
    'lrc',
    'lsa',
    'mzn',
    'oru',
    'oss',
    'abw',
    'peo',
    'prc',
    'pus',
    'sgh',
    'sgl',
    'sgy',
    'siy',
    'smy',
    'sog',
    'sqo',
    'srh',
    'tgk',
    'tly',
    'ttt',
    'wbl',
    'xbc',
    'xco',
    'xpr',
    'xsc',
    'yai',
    'zum',
    'zza'
  ],
  'alg' => [
    'alq',
    'arp',
    'atj',
    'ats',
    'bla',
    'chy',
    'ciw',
    'cre',
    'del',
    'kic',
    'mez',
    'mia',
    'mic',
    'mjy',
    'moe',
    'nnt',
    'oji',
    'ojs',
    'ojw',
    'otw',
    'pim',
    'pot',
    'qyp',
    'sac',
    'sjw',
    'unm',
    'wam',
    'xlb',
    'xlo',
    'xnt',
    'xpq'
  ],
  'wen' => [
    'dsb',
    'hsb'
  ],
  'mkh' => [
    'bbh',
    'bgk',
    'blr',
    'caq',
    'cbn',
    'crv',
    'cwg',
    'huo',
    'jah',
    'jhi',
    'kha',
    'kjg',
    'khm',
    'lbn',
    'mhe',
    'mlf',
    'mml',
    'mnw',
    'mqt',
    'mra',
    'mtq',
    'ncb',
    'oyb',
    'ply',
    'prk',
    'prt',
    'rka',
    'scb',
    'sea',
    'sii',
    'tef',
    'tnz',
    'tpu',
    'tyh',
    'uuu',
    'vie',
    'vwa',
    'wbm',
    'xao',
    'xnh',
    'zng'
  ],
  'xnd' => [
    'ath',
    'eya',
    'hoi',
    'tfn',
    'tli'
  ],
  'gmw' => [
    'afr',
    'ang',
    'cim',
    'deu',
    'dum',
    'eng',
    'enm',
    'frk',
    'frr',
    'fry',
    'gct',
    'gmh',
    'gml',
    'goh',
    'gos',
    'gsw',
    'ksh',
    'ltz',
    'lim',
    'lng',
    'mhn',
    'nds',
    'nld',
    'odt',
    'ofs',
    'osx',
    'pdc',
    'pfl',
    'sco',
    'stq',
    'swg',
    'wae',
    'wep',
    'wym',
    'yec',
    'yid',
    'zea'
  ],
  'sla' => [
    'zle',
    'zls',
    'zlw'
  ],
  'cba' => [
    'bzd',
    'cbg',
    'chb',
    'kog',
    'mbp',
    'mot',
    'tuf'
  ],
  'cpp' => [
    'aoa',
    'cri',
    'fab',
    'kea',
    'mzs',
    'pap',
    'pov',
    'pre',
    'srm',
    'xmm'
  ],
  'trk' => [
    'aib',
    'alt',
    'aze',
    'azb',
    'bak',
    'chg',
    'cjs',
    'clw',
    'crh',
    'chv',
    'dlg',
    'gag',
    'ili',
    'jct',
    'kaa',
    'kdr',
    'kia',
    'kjh',
    'kaz',
    'klj',
    'kmz',
    'krc',
    'kum',
    'kir',
    'ota',
    'otk',
    'qwm',
    'qxq',
    'sah',
    'slr',
    'tuk',
    'tur',
    'tat',
    'tyv',
    'uig',
    'uzb',
    'uzs',
    'xpc',
    'ybe'
  ],
  'ber' => [
    'cnu',
    'grr',
    'jbe',
    'jbn',
    'kab',
    'mzb',
    'nxm',
    'oua',
    'rif',
    'sds',
    'shr',
    'shy',
    'siz',
    'taq',
    'thv',
    'tmh',
    'tzm',
    'zen',
    'zgh'
  ],
  'itc' => [
    'lat',
    'osc',
    'roa',
    'spx',
    'xfa',
    'xum'
  ],
  'swa' => [
    'swc'
  ],
  'smi' => [
    'sme',
    'sia',
    'sjd',
    'sje',
    'sjt',
    'sma',
    'smj',
    'smn',
    'sms'
  ]
};
$LanguageParent = {
  'dlm' => 'roa',
  'sla' => 'ine',
  'nds' => 'gmw',
  'rej' => 'pqw',
  'mzm' => 'alv',
  'gxx' => 'kro',
  'dsb' => 'wen',
  'hit' => 'ine',
  'del' => 'alg',
  'crc' => 'pqe',
  'hed' => 'cdc',
  'cqd' => 'hmx',
  'peb' => 'hok',
  'cay' => 'iro',
  'apl' => 'apa',
  'ktm' => 'pqe',
  'ulu' => 'pqw',
  'kqw' => 'pqe',
  'mtt' => 'pqe',
  'abl' => 'pqw',
  'ewe' => 'alv',
  'yrl' => 'tup',
  'raz' => 'pqw',
  'gme' => 'gem',
  'xkg' => 'dmn',
  'cla' => 'roa',
  'alu' => 'pqe',
  'odt' => 'gmw',
  'cat' => 'roa',
  'bmv' => 'bnt',
  'pbp' => 'alv',
  'rro' => 'pqe',
  'enb' => 'sdv',
  'osc' => 'itc',
  'rka' => 'mkh',
  'nie' => 'alv',
  'toi' => 'bnt',
  'kom' => 'fiu',
  'ttt' => 'ira',
  'euq' => 'mul',
  'krx' => 'alv',
  'mno' => 'phi',
  'gil' => 'pqe',
  'usp' => 'myn',
  'tgc' => 'pqe',
  'yum' => 'hok',
  'hsb' => 'wen',
  'non' => 'gmq',
  'ils' => 'sgn',
  'lkn' => 'pqe',
  'kok' => 'inc',
  'bin' => 'alv',
  'zza' => 'ira',
  'klj' => 'trk',
  'tzm' => 'ber',
  'tup' => 'mul',
  'jaz' => 'pqe',
  'pcd' => 'roa',
  'xvn' => 'gme',
  'gei' => 'pqe',
  'sat' => 'mun',
  'dgg' => 'pqe',
  'mot' => 'cba',
  'mhj' => 'xgn',
  'daa' => 'cdc',
  'lgl' => 'pqe',
  'xto' => 'ine',
  'lbj' => 'sit',
  'ath' => 'xnd',
  'oku' => 'alv',
  'cak' => 'myn',
  'ulc' => 'tuw',
  'nyo' => 'nic',
  'ara' => 'sem',
  'dim' => 'omv',
  'tyv' => 'trk',
  'tnp' => 'pqe',
  'kno' => 'dmn',
  'lrz' => 'pqe',
  'sia' => 'smi',
  'cwt' => 'alv',
  'cia' => 'pqw',
  'orv' => 'zle',
  'nah' => 'azc',
  'bns' => 'inc',
  'nep' => 'inc',
  'bul' => 'zls',
  'gld' => 'tuw',
  'btx' => 'btk',
  'alc' => 'aqa',
  'ckv' => 'fox',
  'cam' => 'pqe',
  'ynk' => 'ypk',
  'prg' => 'bat',
  'yuy' => 'xgn',
  'srr' => 'alv',
  'gbu' => 'aus',
  'mtm' => 'syd',
  'umb' => 'bnt',
  'jab' => 'alv',
  'amw' => 'sem',
  'gem' => 'ine',
  'nms' => 'pqe',
  'rue' => 'zle',
  'wmt' => 'aus',
  'abs' => 'pqw',
  'tom' => 'phi',
  'lao' => 'taw',
  'pss' => 'pqe',
  'cha' => 'pqw',
  'ddo' => 'ccn',
  'kzk' => 'pqe',
  'pbo' => 'alv',
  'koy' => 'ath',
  'haa' => 'ath',
  'kij' => 'pqe',
  'fon' => 'alv',
  'nga' => 'alv',
  'xum' => 'itc',
  'egy' => 'afa',
  'peq' => 'hok',
  'mnp' => 'zhx',
  'myv' => 'fiu',
  'xnt' => 'alg',
  'bla' => 'alg',
  'ikx' => 'ssa',
  'lue' => 'bnt',
  'kgk' => 'tup',
  'atj' => 'alg',
  'kzc' => 'alv',
  'nza' => 'alv',
  'wci' => 'alv',
  'los' => 'pqe',
  'oci' => 'roa',
  'tgi' => 'pqe',
  'xas' => 'syd',
  'hlu' => 'ine',
  'snd' => 'inc',
  'kax' => 'paa',
  'bai' => 'alv',
  'tae' => 'awd',
  'vmk' => 'bnt',
  'fsl' => 'sgn',
  'tnz' => 'mkh',
  'caf' => 'ath',
  'akb' => 'btk',
  'awa' => 'inc',
  'naj' => 'alv',
  'tuw' => 'tut',
  'mfe' => 'cpf',
  'aht' => 'ath',
  'acw' => 'sem',
  'dbl' => 'aus',
  'dic' => 'kro',
  'yal' => 'dmn',
  'nss' => 'pqe',
  'sac' => 'alg',
  'aii' => 'sem',
  'pix' => 'aus',
  'yur' => 'aql',
  'sus' => 'dmn',
  'tlh' => 'art',
  'snl' => 'phi',
  'sin' => 'inc',
  'ple' => 'poz',
  'alm' => 'pqe',
  'ttc' => 'myn',
  'tub' => 'azc',
  'cus' => 'afa',
  'pms' => 'roa',
  'pwg' => 'pqe',
  'tpv' => 'pqe',
  'hif' => 'inc',
  'tig' => 'sem',
  'cac' => 'myn',
  'cri' => 'cpp',
  'ldn' => 'art',
  'asb' => 'xsi',
  'bat' => 'ine',
  'brf' => 'bnt',
  'gyr' => 'tup',
  'dan' => 'gmq',
  'bam' => 'dmn',
  'new' => 'sit',
  'tuq' => 'ssa',
  'ado' => 'alv',
  'liv' => 'fiu',
  'swc' => 'swa',
  'mlg' => 'pqw',
  'mjv' => 'dra',
  'cul' => 'auf',
  'rap' => 'pqe',
  'alt' => 'trk',
  'sdv' => 'ssa',
  'dzg' => 'ssa',
  'uvl' => 'pqe',
  'tqp' => 'pqe',
  'kzu' => 'pqe',
  'tgk' => 'ira',
  'zle' => 'sla',
  'bwt' => 'bnt',
  'muz' => 'sdv',
  'bak' => 'trk',
  'zbw' => 'pqw',
  'sns' => 'pqe',
  'jrb' => 'sem',
  'peo' => 'ira',
  'tnw' => 'phi',
  'lww' => 'pqe',
  'pag' => 'phi',
  'mor' => 'alv',
  'brr' => 'pqe',
  'tuz' => 'alv',
  'ipk' => 'esx',
  'ina' => 'art',
  'hbs' => 'zls',
  'pon' => 'pqe',
  'mnw' => 'xgn',
  'zhx' => 'sit',
  'asz' => 'pqe',
  'fcs' => 'sgn',
  'lsa' => 'ira',
  'xal' => 'xgn',
  'yuf' => 'hok',
  'cau' => 'mul',
  'ayl' => 'sem',
  'uli' => 'pqe',
  'afa' => 'mul',
  'lol' => 'bnt',
  'qwm' => 'trk',
  'ong' => 'fiu',
  'eno' => 'pqw',
  'ttu' => 'pqe',
  'xmg' => 'bai',
  'dra' => 'mul',
  'sln' => 'hok',
  'njo' => 'tbq',
  'kzr' => 'alv',
  'srm' => 'cpp',
  'nya' => 'bnt',
  'npn' => 'pqe',
  'wam' => 'alg',
  'smy' => 'ira',
  'nal' => 'pqe',
  'var' => 'azc',
  'nnc' => 'cdc',
  'noz' => 'omv',
  'itc' => 'ine',
  'aka' => 'alv',
  'xsd' => 'ine',
  'smi' => 'fiu',
  'nfl' => 'pqe',
  'buh' => 'hmx',
  'pop' => 'pqe',
  'kji' => 'pqe',
  'kbm' => 'pqe',
  'zen' => 'ber',
  'keu' => 'alv',
  'oru' => 'ira',
  'bck' => 'aus',
  'ell' => 'grk',
  'tyu' => 'bnt',
  'wru' => 'pqw',
  'crv' => 'mkh',
  'svx' => 'bat',
  'uzs' => 'trk',
  'xbp' => 'aus',
  'nmg' => 'bnt',
  'wak' => 'mul',
  'jic' => 'ath',
  'sku' => 'pqe',
  'ebu' => 'bnt',
  'rog' => 'cmc',
  'bcm' => 'pqe',
  'mua' => 'alv',
  'tcx' => 'dra',
  'mqn' => 'pqw',
  'puy' => 'hok',
  'tec' => 'sdv',
  'rif' => 'ber',
  'csu' => 'ssa',
  'see' => 'iro',
  'mpy' => 'pqe',
  'asa' => 'bnt',
  'biq' => 'pqe',
  'bdr' => 'pqw',
  'myu' => 'tup',
  'bkk' => 'inc',
  'lik' => 'bnt',
  'ptp' => 'pqe',
  'ggt' => 'pqe',
  'bng' => 'bnt',
  'skr' => 'inc',
  'ebr' => 'alv',
  'aca' => 'awd',
  'pkg' => 'pqe',
  'inz' => 'hok',
  'rmq' => 'inc',
  'wha' => 'plf',
  'kvc' => 'pqe',
  'zum' => 'ira',
  'bqj' => 'alv',
  'fas' => 'ira',
  'hao' => 'pqe',
  'ane' => 'pqe',
  'tef' => 'mkh',
  'xcl' => 'ine',
  'bkm' => 'alv',
  'lim' => 'gmw',
  'lmp' => 'alv',
  'dbj' => 'pqw',
  'xeb' => 'sem',
  'emx' => 'inc',
  'aol' => 'poz',
  'alv' => 'nic',
  'ajg' => 'alv',
  'sdt' => 'ine',
  'mjt' => 'dra',
  'kjk' => 'pqw',
  'pnt' => 'grk',
  'orc' => 'cus',
  'led' => 'csu',
  'lit' => 'bat',
  'bci' => 'alv',
  'hrw' => 'pqe',
  'roh' => 'roa',
  'jra' => 'cmc',
  'dma' => 'bnt',
  'ssf' => 'fox',
  'bug' => 'pqw',
  'arp' => 'alg',
  'bib' => 'dmn',
  'nob' => 'gmq',
  'xrg' => 'aus',
  'hsn' => 'zhx',
  'ldp' => 'bnt',
  'bxf' => 'pqe',
  'zdj' => 'bnt',
  'teu' => 'ssa',
  'kvr' => 'pqw',
  'guq' => 'tup',
  'poo' => 'hok',
  'bje' => 'hmx',
  'vrt' => 'pqe',
  'mna' => 'pqe',
  'mvf' => 'xgn',
  'anx' => 'pqe',
  'heh' => 'bnt',
  'lmo' => 'roa',
  'glg' => 'roa',
  'pny' => 'alv',
  'rth' => 'phi',
  'bhw' => 'pqe',
  'lht' => 'pqe',
  'loj' => 'pqe',
  'mjy' => 'alg',
  'kpt' => 'ccn',
  'meu' => 'pqe',
  'xgn' => 'tut',
  'eme' => 'tup',
  'chp' => 'ath',
  'afb' => 'sem',
  'blq' => 'pqe',
  'ccc' => 'awd',
  'mji' => 'hmx',
  'llk' => 'pqw',
  'ats' => 'alg',
  'ntw' => 'iro',
  'mse' => 'cdc',
  'skf' => 'tup',
  'kyr' => 'tup',
  'bhb' => 'inc',
  'kqn' => 'bnt',
  'nas' => 'paa',
  'kua' => 'bnt',
  'zuy' => 'cdc',
  'guz' => 'bnt',
  'arz' => 'sem',
  'lra' => 'dai',
  'tvk' => 'pqe',
  'sxr' => 'fox',
  'bcr' => 'ath',
  'siz' => 'ber',
  'ons' => 'iro',
  'tet' => 'plf',
  'jhi' => 'mkh',
  'ada' => 'alv',
  'sbe' => 'pqe',
  'hro' => 'cmc',
  'mdx' => 'omv',
  'kld' => 'aus',
  'apj' => 'apa',
  'nnt' => 'alg',
  'got' => 'gme',
  'clw' => 'trk',
  'xga' => 'cel',
  'hmn' => 'hmx',
  'haq' => 'bnt',
  'mey' => 'sem',
  'pnu' => 'hmx',
  'tbf' => 'pqe',
  'myk' => 'alv',
  'dtd' => 'wak',
  'war' => 'phi',
  'pcj' => 'mun',
  'blp' => 'pqe',
  'dhv' => 'pqe',
  'arq' => 'sem',
  'orm' => 'cus',
  'fut' => 'pqe',
  'cmc' => 'pqw',
  'shz' => 'alv',
  'bho' => 'inc',
  'tpc' => 'omq',
  'bdk' => 'ccn',
  'ttv' => 'pqe',
  'dmn' => 'nic',
  'tnn' => 'pqe',
  'haz' => 'ira',
  'tbc' => 'pqe',
  'ztq' => 'omq',
  'mov' => 'hok',
  'sav' => 'alv',
  'bcu' => 'pqe',
  'mls' => 'ssa',
  'kjc' => 'pqw',
  'kek' => 'myn',
  'mme' => 'pqe',
  'lhu' => 'tbq',
  'smc' => 'cus',
  'aao' => 'sem',
  'llf' => 'pqe',
  'met' => 'pqe',
  'bsu' => 'pqw',
  'div' => 'inc',
  'tdx' => 'pqw',
  'kyi' => 'pqw',
  'hne' => 'inc',
  'kde' => 'bnt',
  'wln' => 'roa',
  'goy' => 'alv',
  'cje' => 'cmc',
  'spx' => 'itc',
  'lfn' => 'art',
  'ssy' => 'cus',
  'ddn' => 'son',
  'nuy' => 'aus',
  'khl' => 'pqe',
  'vai' => 'dmn',
  'slz' => 'pqe',
  'cdc' => 'afa',
  'blo' => 'alv',
  'smr' => 'pqw',
  'mek' => 'pqe',
  'bip' => 'bnt',
  'kls' => 'inc',
  'sdc' => 'roa',
  'ivv' => 'poz',
  'nsg' => 'sdv',
  'urw' => 'bnt',
  'llu' => 'pqe',
  'mde' => 'ssa',
  'ciw' => 'alg',
  'mhs' => 'plf',
  'ltg' => 'bat',
  'ybb' => 'bai',
  'ppn' => 'pqe',
  'mpu' => 'tup',
  'bkc' => 'alv',
  'pfl' => 'gmw',
  'poz' => 'map',
  'cpx' => 'zhx',
  'sje' => 'smi',
  'tpr' => 'tup',
  'mmx' => 'pqe',
  'pad' => 'auf',
  'ngb' => 'alv',
  'mqa' => 'pqe',
  'ski' => 'poz',
  'mun' => 'aav',
  'nba' => 'bnt',
  'hts' => 'khi',
  'woe' => 'pqe',
  'kdx' => 'bnt',
  'chb' => 'cba',
  'mpr' => 'pqe',
  'tpu' => 'mkh',
  'bhp' => 'poz',
  'haw' => 'pqe',
  'mvy' => 'inc',
  'kju' => 'hok',
  'zea' => 'gmw',
  'win' => 'xsi',
  'oac' => 'tuw',
  'bex' => 'csu',
  'kei' => 'poz',
  'ori' => 'inc',
  'mzv' => 'alv',
  'ntp' => 'azc',
  'bsc' => 'alv',
  'inp' => 'awd',
  'guo' => 'awd',
  'omv' => 'afa',
  'mxe' => 'pqe',
  'kyk' => 'phi',
  'tll' => 'bnt',
  'bqh' => 'tbq',
  'xpq' => 'alg',
  'kpc' => 'awd',
  'esx' => 'mul',
  'nyn' => 'bnt',
  'bas' => 'bnt',
  'kyh' => 'hok',
  'vie' => 'mkh',
  'gmw' => 'gem',
  'snk' => 'dmn',
  'mrw' => 'phi',
  'stp' => 'azc',
  'cba' => 'mul',
  'bdg' => 'pqw',
  'goh' => 'gmw',
  'spa' => 'roa',
  'tgs' => 'pqe',
  'ndf' => 'bat',
  'nnh' => 'bai',
  'btb' => 'bnt',
  'buc' => 'pqw',
  'gdq' => 'sem',
  'rou' => 'ssa',
  'bnr' => 'pqe',
  'sqr' => 'sem',
  'pmt' => 'pqe',
  'ude' => 'tuw',
  'ira' => 'iir',
  'oss' => 'ira',
  'gmb' => 'pqe',
  'lij' => 'roa',
  'mrb' => 'pqe',
  'mcn' => 'cdc',
  'mwo' => 'pqe',
  'ruq' => 'roa',
  'her' => 'bnt',
  'lre' => 'iro',
  'apu' => 'awd',
  'bzq' => 'pqe',
  'sba' => 'csu',
  'eka' => 'nic',
  'ero' => 'sit',
  'deu' => 'gmw',
  'hke' => 'bnt',
  'crs' => 'cpf',
  'ubr' => 'pqe',
  'qya' => 'art',
  'iir' => 'ine',
  'veo' => 'hok',
  'pio' => 'awd',
  'aqa' => 'mul',
  'cui' => 'awd',
  'czo' => 'zhx',
  'waj' => 'paa',
  'bxg' => 'bnt',
  'map' => 'mul',
  'tsn' => 'bnt',
  'apr' => 'pqe',
  'ssg' => 'pqe',
  'bwd' => 'pqe',
  'ndc' => 'bnt',
  'kvh' => 'poz',
  'bea' => 'ath',
  'bjn' => 'pqw',
  'avi' => 'alv',
  'uun' => 'fox',
  'ald' => 'kro',
  'abr' => 'alv',
  'lot' => 'sdv',
  'lti' => 'plf',
  'nci' => 'nah',
  'cop' => 'afa',
  'pku' => 'pqw',
  'squ' => 'sal',
  'srs' => 'ath',
  'oyb' => 'mkh',
  'ota' => 'trk',
  'wbp' => 'aus',
  'kma' => 'alv',
  'bad' => 'alv',
  'bfd' => 'alv',
  'orh' => 'tuw',
  'nav' => 'apa',
  'adx' => 'tbq',
  'sgz' => 'pqe',
  'yai' => 'ira',
  'mgl' => 'pqe',
  'lom' => 'dmn',
  'tao' => 'poz',
  'dyu' => 'dmn',
  'sto' => 'xsi',
  'btz' => 'btk',
  'lgu' => 'pqe',
  'pex' => 'pqe',
  'bdh' => 'csu',
  'ibl' => 'phi',
  'tyh' => 'mkh',
  'niq' => 'sdv',
  'luo' => 'sdv',
  'apc' => 'sem',
  'quc' => 'myn',
  'skh' => 'pqw',
  'jae' => 'pqe',
  'coo' => 'sal',
  'crd' => 'sal',
  'tpj' => 'tup',
  'myh' => 'wak',
  'gmq' => 'gem',
  'gan' => 'zhx',
  'rof' => 'bnt',
  'zho' => 'zhx',
  'lgr' => 'pqe',
  'mrq' => 'pqe',
  'izh' => 'fiu',
  'dua' => 'bnt',
  'pip' => 'cdc',
  'vep' => 'fiu',
  'ame' => 'awd',
  'avk' => 'art',
  'njx' => 'bnt',
  'twp' => 'pqe',
  'xsv' => 'bat',
  'smj' => 'smi',
  'bpn' => 'hmx',
  'bal' => 'ira',
  'suk' => 'bnt',
  'kjj' => 'ccn',
  'srd' => 'roa',
  'tbj' => 'pqe',
  'bfl' => 'alv',
  'sdg' => 'inc',
  'xnd' => 'mul',
  'mos' => 'alv',
  'ajt' => 'sem',
  'bnk' => 'pqe',
  'sas' => 'pqw',
  'ido' => 'art',
  'mlv' => 'pqe',
  'tdn' => 'phi',
  'byn' => 'cus',
  'mjg' => 'xgn',
  'twq' => 'son',
  'bpa' => 'pqe',
  'ncc' => 'pqe',
  'kca' => 'fiu',
  'gly' => 'ssa',
  'hbu' => 'plf',
  'khv' => 'ccn',
  'taw' => 'mul',
  'ltc' => 'zhx',
  'lub' => 'bnt',
  'tzl' => 'art',
  'egl' => 'roa',
  'dun' => 'pqw',
  'lbv' => 'pqe',
  'stw' => 'pqe',
  'tnx' => 'pqe',
  'ojw' => 'alg',
  'kaz' => 'trk',
  'tab' => 'ccn',
  'bba' => 'alv',
  'cow' => 'sal',
  'txn' => 'plf',
  'ncf' => 'pqe',
  'apk' => 'apa',
  'loc' => 'phi',
  'kro' => 'alv',
  'sxg' => 'sit',
  'ili' => 'trk',
  'trp' => 'tbq',
  'rom' => 'inc',
  'piz' => 'pqe',
  'cnu' => 'ber',
  'aji' => 'pqe',
  'mfb' => 'pqw',
  'kpg' => 'pqe',
  'hun' => 'fiu',
  'gdo' => 'ccn',
  'hmx' => 'mul',
  'bsg' => 'ira',
  'sob' => 'pqe',
  'psm' => 'tup',
  'sea' => 'mkh',
  'sjn' => 'art',
  'tlv' => 'plf',
  'yrk' => 'syd',
  'ruo' => 'roa',
  'qum' => 'myn',
  'tjg' => 'pqw',
  'kjh' => 'trk',
  'xmv' => 'pqw',
  'ace' => 'cmc',
  'abk' => 'ccn',
  'nmk' => 'pqe',
  'sqi' => 'ine',
  'sad' => 'khi',
  'bni' => 'bnt',
  'gsw' => 'gmw',
  'zuh' => 'paa',
  'mzs' => 'cpp',
  'zlw' => 'sla',
  'avu' => 'csu',
  'kab' => 'ber',
  'kyj' => 'phi',
  'glk' => 'ira',
  'zbe' => 'pqw',
  'hil' => 'phi',
  'plq' => 'ine',
  'ewo' => 'bnt',
  'ben' => 'inc',
  'bja' => 'bnt',
  'mww' => 'hmx',
  'xwc' => 'xsi',
  'nkr' => 'pqe',
  'vkl' => 'pqw',
  'snf' => 'alv',
  'sva' => 'ccs',
  'nmt' => 'pqe',
  'grn' => 'tup',
  'nee' => 'pqe',
  'kaw' => 'pqw',
  'maq' => 'omq',
  'thv' => 'ber',
  'bkh' => 'bnt',
  'wuv' => 'pqe',
  'aua' => 'pqe',
  'mfq' => 'alv',
  'cad' => 'cdd',
  'hei' => 'wak',
  'pnh' => 'pqe',
  'coz' => 'omq',
  'nxm' => 'ber',
  'fip' => 'bnt',
  'rup' => 'roa',
  'kjg' => 'mkh',
  'nku' => 'alv',
  'klv' => 'pqe',
  'cal' => 'pqe',
  'ilk' => 'phi',
  'kos' => 'pqe',
  'msa' => 'sal',
  'iii' => 'sit',
  'taq' => 'ber',
  'zng' => 'mkh',
  'mtd' => 'pqw',
  'bnt' => 'alv',
  'uby' => 'ccn',
  'lgk' => 'pqe',
  'wep' => 'gmw',
  'pug' => 'alv',
  'stq' => 'gmw',
  'bch' => 'pqe',
  'pdc' => 'gmw',
  'kwz' => 'khi',
  'pib' => 'awd',
  'hid' => 'xsi',
  'abi' => 'alv',
  'tiv' => 'alv',
  'sal' => 'mul',
  'buk' => 'pqe',
  'sya' => 'pqw',
  'szw' => 'pqe',
  'bsh' => 'iir',
  'nmy' => 'sit',
  'cbn' => 'mkh',
  'nio' => 'syd',
  'bqc' => 'dmn',
  'wdd' => 'bnt',
  'wni' => 'bnt',
  'run' => 'bnt',
  'fin' => 'fiu',
  'sbp' => 'bnt',
  'cpp' => 'roa',
  'nrm' => 'pqw',
  'bjz' => 'ngf',
  'sjo' => 'tuw',
  'bdl' => 'pqw',
  'kii' => 'cdd',
  'crh' => 'trk',
  'msq' => 'pqe',
  'kmo' => 'paa',
  'mlt' => 'sem',
  'oto' => 'omq',
  'alg' => 'aql',
  'wen' => 'zlw',
  'xcr' => 'ine',
  'tzj' => 'myn',
  'tli' => 'xnd',
  'nau' => 'pqe',
  'tly' => 'ira',
  'srh' => 'ira',
  'lua' => 'bnt',
  'hok' => 'mul',
  'xsr' => 'sit',
  'xxk' => 'poz',
  'ksb' => 'bnt',
  'spp' => 'alv',
  'mgh' => 'bnt',
  'tik' => 'alv',
  'dgr' => 'ath',
  'huo' => 'mkh',
  'fry' => 'gmw',
  'tkq' => 'alv',
  'nfr' => 'alv',
  'xcu' => 'bat',
  'scl' => 'inc',
  'tvl' => 'pqe',
  'kys' => 'pqw',
  'jpr' => 'ira',
  'glv' => 'cel',
  'azc' => 'mul',
  'khi' => 'mul',
  'anw' => 'alv',
  'gos' => 'gmw',
  'och' => 'zhx',
  'auq' => 'pqe',
  'xho' => 'bnt',
  'mfa' => 'pqw',
  'vmg' => 'pqe',
  'faf' => 'pqe',
  'frt' => 'pqe',
  'ceb' => 'phi',
  'ndv' => 'alv',
  'myl' => 'pqw',
  'prc' => 'ira',
  'nwc' => 'sit',
  'qyp' => 'alg',
  'fox' => 'map',
  'tlm' => 'pqe',
  'quv' => 'myn',
  'iro' => 'mul',
  'xmm' => 'cpp',
  'trn' => 'awd',
  'tcb' => 'ath',
  'ccs' => 'cau',
  'mhy' => 'pqw',
  'hup' => 'ath',
  'kik' => 'bnt',
  'gej' => 'alv',
  'pha' => 'hmx',
  'frm' => 'roa',
  'tel' => 'dra',
  'mhi' => 'csu',
  'spo' => 'sal',
  'tlk' => 'pqw',
  'xve' => 'ine',
  'uig' => 'trk',
  'ysr' => 'esx',
  'sss' => 'aav',
  'xmk' => 'ine',
  'kaa' => 'trk',
  'ibg' => 'phi',
  'nus' => 'sdv',
  'upv' => 'pqe',
  'ler' => 'pqe',
  'toj' => 'myn',
  'tht' => 'ath',
  'eko' => 'bnt',
  'kfa' => 'dra',
  'frk' => 'gmw',
  'hoi' => 'xnd',
  'fud' => 'pqe',
  'xlo' => 'alg',
  'doi' => 'inc',
  'saj' => 'paa',
  'kdo' => 'nic',
  'ful' => 'alv',
  'leu' => 'pqe',
  'cks' => 'cpf',
  'dij' => 'pqw',
  'nnd' => 'pqe',
  'kkz' => 'ath',
  'gro' => 'tbq',
  'anz' => 'paa',
  'far' => 'pqe',
  'pia' => 'azc',
  'xsc' => 'ira',
  'dup' => 'pqw',
  'lce' => 'pqw',
  'gux' => 'alv',
  'mrn' => 'pqe',
  'ine' => 'mul',
  'tkw' => 'pqe',
  'thy' => 'taw',
  'khm' => 'mkh',
  'sgn' => 'mul',
  'yee' => 'paa',
  'msb' => 'phi',
  'duq' => 'pqw',
  'nwi' => 'pqe',
  'wuu' => 'zhx',
  'dtr' => 'pqw',
  'sga' => 'cel',
  'sbb' => 'pqe',
  'gap' => 'plf',
  'xsm' => 'alv',
  'xmf' => 'ccs',
  'pri' => 'pqe',
  'kmz' => 'trk',
  'mra' => 'mkh',
  'cwg' => 'mkh',
  'lil' => 'sal',
  'xlb' => 'alg',
  'szn' => 'plf',
  'pus' => 'ira',
  'tmb' => 'pqe',
  'cms' => 'ine',
  'kbd' => 'ccn',
  'ven' => 'bnt',
  'sms' => 'smi',
  'czn' => 'omq',
  'swg' => 'gmw',
  'gkn' => 'alv',
  'tir' => 'sem',
  'zul' => 'bnt',
  'brh' => 'dra',
  'nha' => 'aus',
  'kog' => 'cba',
  'ley' => 'pqw',
  'huz' => 'ccn',
  'agu' => 'myn',
  'tso' => 'bnt',
  'sxl' => 'bat',
  'prt' => 'mkh',
  'cdd' => 'mul',
  'frc' => 'roa',
  'beb' => 'bnt',
  'moh' => 'iro',
  'shx' => 'omv',
  'dor' => 'pqe',
  'sah' => 'trk',
  'kmq' => 'ssa',
  'mmw' => 'pqe',
  'kan' => 'dra',
  'tth' => 'aav',
  'fla' => 'sal',
  'igs' => 'art',
  'phn' => 'sem',
  'kic' => 'alg',
  'nia' => 'pqw',
  'lid' => 'pqe',
  'kbl' => 'ssa',
  'mlf' => 'mkh',
  'wya' => 'iro',
  'lvk' => 'paa',
  'huq' => 'cmc',
  'bew' => 'pqw',
  'anp' => 'ine',
  'yky' => 'alv',
  'atk' => 'alv',
  'lme' => 'cdc',
  'wal' => 'omv',
  'dlg' => 'trk',
  'grb' => 'kro',
  'was' => 'hok',
  'brg' => 'awd',
  'xdc' => 'ine',
  'mdw' => 'bnt',
  'kir' => 'trk',
  'sjw' => 'alg',
  'nrf' => 'roa',
  'txb' => 'ine',
  'otw' => 'alg',
  'son' => 'ssa',
  'tif' => 'paa',
  'vnm' => 'pqe',
  'man' => 'dmn',
  'owl' => 'cel',
  'prk' => 'mkh',
  'pau' => 'pqw',
  'bvb' => 'bnt',
  'tog' => 'nic',
  'mic' => 'alg',
  'ybe' => 'trk',
  'xsi' => 'pqe',
  'frr' => 'gmw',
  'pox' => 'zlw',
  'xsy' => 'fox',
  'esq' => 'hok',
  'znd' => 'nic',
  'tlr' => 'pqe',
  'kmb' => 'bnt',
  'ofs' => 'gmw',
  'xmr' => 'ssa',
  'mlu' => 'pqe',
  'beq' => 'bnt',
  'vnk' => 'pqe',
  'lek' => 'pqe',
  'tzh' => 'myn',
  'che' => 'ccn',
  'tbl' => 'phi',
  'stn' => 'pqe',
  'vrs' => 'pqe',
  'snv' => 'pqw',
  'duw' => 'pqw',
  'onu' => 'pqe',
  'fqs' => 'ira',
  'hoc' => 'mun',
  'lun' => 'bnt',
  'xnh' => 'mkh',
  'ykm' => 'ccn',
  'sml' => 'pqw',
  'yav' => 'alv',
  'tkp' => 'pqe',
  'grz' => 'pqe',
  'nrc' => 'cel',
  'mhc' => 'myn',
  'fkv' => 'fiu',
  'mxb' => 'omq',
  'bez' => 'bnt',
  'nla' => 'bai',
  'lld' => 'roa',
  'tpl' => 'omq',
  'mog' => 'phi',
  'sag' => 'ngb',
  'wow' => 'pqw',
  'sds' => 'ber',
  'aty' => 'pqe',
  'fia' => 'nub',
  'par' => 'azc',
  'tfn' => 'xnd',
  'wlc' => 'bnt',
  'cro' => 'xsi',
  'xlg' => 'ine',
  'rwk' => 'bnt',
  'xwe' => 'alv',
  'knu' => 'dmn',
  'urv' => 'pqe',
  'smn' => 'smi',
  'saq' => 'sdv',
  'kcj' => 'alv',
  'kea' => 'cpp',
  'kjn' => 'aus',
  'ekg' => 'ngf',
  'gez' => 'sem',
  'ora' => 'pqe',
  'mdh' => 'phi',
  'ibo' => 'alv',
  'cpg' => 'grk',
  'cjh' => 'sal',
  'bbj' => 'bai',
  'kwd' => 'pqe',
  'bda' => 'alv',
  'cbg' => 'cba',
  'mgo' => 'alv',
  'rwm' => 'bnt',
  'enm' => 'gmw',
  'arv' => 'cus',
  'mqy' => 'poz',
  'caq' => 'mkh',
  'dav' => 'bnt',
  'txh' => 'ine',
  'zbc' => 'pqw',
  'acr' => 'myn',
  'njm' => 'sit',
  'tur' => 'trk',
  'mad' => 'pqw',
  'swb' => 'bnt',
  'mnc' => 'tuw',
  'ukr' => 'zle',
  'mzw' => 'alv',
  'mya' => 'sit',
  'beg' => 'pqw',
  'sol' => 'pqe',
  'ign' => 'awd',
  'mal' => 'dra',
  'evn' => 'tuw',
  'ray' => 'pqe',
  'chv' => 'trk',
  'kkj' => 'bnt',
  'zls' => 'sla',
  'pek' => 'pqe',
  'sne' => 'dai',
  'mtq' => 'mkh',
  'rai' => 'pqe',
  'xnb' => 'fox',
  'akr' => 'pqe',
  'mmg' => 'pqe',
  'bxa' => 'pqe',
  'mzb' => 'ber',
  'mqt' => 'paa',
  'udm' => 'fiu',
  'toq' => 'sdv',
  'kas' => 'inc',
  'tva' => 'pqe',
  'nqn' => 'pqe',
  'ssa' => 'mul',
  'ers' => 'tbq',
  'mbn' => 'awd',
  'omb' => 'pqe',
  'nua' => 'pqe',
  'kpn' => 'tup',
  'mzq' => 'pqw',
  'acf' => 'cpf',
  'kal' => 'esx',
  'bjj' => 'inc',
  'cos' => 'roa',
  'tuf' => 'cba',
  'lnd' => 'map',
  'goa' => 'dmn',
  'ita' => 'roa',
  'txg' => 'sit',
  'mqm' => 'pqe',
  'mwl' => 'roa',
  'kur' => 'ira',
  'pme' => 'pqe',
  'omq' => 'mul',
  'ktq' => 'pqw',
  'srp' => 'zls',
  'wic' => 'cdd',
  'pov' => 'cpp',
  'mkj' => 'pqe',
  'uve' => 'pqe',
  'sxn' => 'phi',
  'bwo' => 'omv',
  'neu' => 'art',
  'wbl' => 'ira',
  'irh' => 'pqe',
  'alo' => 'plf',
  'nse' => 'bnt',
  'fvr' => 'ssa',
  'eto' => 'bnt',
  'kws' => 'bnt',
  'tmh' => 'ber',
  'hiw' => 'pqe',
  'mnr' => 'azc',
  'tsj' => 'sit',
  'slv' => 'zls',
  'vwa' => 'mkh',
  'sbh' => 'pqe',
  'mas' => 'sdv',
  'hmr' => 'sit',
  'ijo' => 'alv',
  'phl' => 'inc',
  'ave' => 'ira',
  'yor' => 'alv',
  'koq' => 'bnt',
  'lin' => 'bnt',
  'udi' => 'ccn',
  'szl' => 'zlw',
  'tnr' => 'alv',
  'ptv' => 'pqe',
  'mnu' => 'bnt',
  'tuc' => 'pqe',
  'ttb' => 'alv',
  'olr' => 'pqe',
  'sdn' => 'roa',
  'nyf' => 'bnt',
  'rak' => 'pqe',
  'ktz' => 'khi',
  'kva' => 'ccn',
  'knf' => 'alv',
  'kdh' => 'alv',
  'tgp' => 'pqe',
  'beh' => 'alv',
  'isl' => 'gmq',
  'lmv' => 'pqe',
  'ady' => 'ccn',
  'dje' => 'son',
  'nke' => 'pqe',
  'kuu' => 'ath',
  'ojs' => 'alg',
  'snx' => 'sem',
  'osp' => 'roa',
  'lus' => 'sit',
  'pil' => 'alv',
  'oog' => 'fiu',
  'mkh' => 'aav',
  'tum' => 'bnt',
  'kzo' => 'bnt',
  'crz' => 'hok',
  'tnt' => 'phi',
  'vra' => 'pqe',
  'olt' => 'bat',
  'vko' => 'pqw',
  'pse' => 'pqw',
  'asm' => 'inc',
  'xom' => 'ssa',
  'gag' => 'trk',
  'lam' => 'nic',
  'sgl' => 'ira',
  'men' => 'dmn',
  'rri' => 'pqe',
  'sda' => 'pqw',
  'rus' => 'zle',
  'nov' => 'art',
  'tuk' => 'trk',
  'ksg' => 'pqe',
  'udu' => 'ssa',
  'gml' => 'gmw',
  'swp' => 'pqe',
  'rmv' => 'art',
  'mrl' => 'pqe',
  'dnj' => 'gmq',
  'bod' => 'tbq',
  'mni' => 'sit',
  'auh' => 'bnt',
  'yij' => 'aus',
  'ask' => 'iir',
  'roe' => 'pqe',
  'hrv' => 'zls',
  'ovd' => 'gmq',
  'kdj' => 'sdv',
  'hnj' => 'hmx',
  'aav' => 'mul',
  'nym' => 'bnt',
  'sgd' => 'phi',
  'kqr' => 'pqw',
  'jac' => 'myn',
  'ney' => 'kro',
  'ang' => 'gmw',
  'oaa' => 'tuw',
  'btd' => 'btk',
  'akk' => 'sem',
  'srq' => 'tup',
  'knk' => 'dmn',
  'gon' => 'dra',
  'nnn' => 'cdc',
  'bej' => 'cus',
  'wli' => 'paa',
  'nhd' => 'tup',
  'vmb' => 'aus',
  'nun' => 'tbq',
  'abx' => 'pqw',
  'ddi' => 'pqe',
  'ksh' => 'gmw',
  'wwa' => 'alv',
  'bph' => 'ccn',
  'mdj' => 'csu',
  'ssn' => 'cus',
  'lrc' => 'ira',
  'koo' => 'bnt',
  'ile' => 'art',
  'kmj' => 'dra',
  'scn' => 'roa',
  'xzm' => 'bat',
  'gdd' => 'pqe',
  'aib' => 'trk',
  'acy' => 'sem',
  'nld' => 'gmw',
  'tuy' => 'sdv',
  'alz' => 'sdv',
  'ccn' => 'cau',
  'trs' => 'omq',
  'tzo' => 'myn',
  'kum' => 'trk',
  'tui' => 'alv',
  'tqu' => 'paa',
  'nxe' => 'poz',
  'ppi' => 'hok',
  'bzd' => 'cba',
  'csn' => 'sgn',
  'myn' => 'mul',
  'pyu' => 'fox',
  'bbh' => 'mkh',
  'bos' => 'zls',
  'aiw' => 'omv',
  'mxj' => 'tbq',
  'gle' => 'cel',
  'nem' => 'pqe',
  'rar' => 'pqe',
  'mqu' => 'sdv',
  'mui' => 'pqw',
  'tkg' => 'pqw',
  'sgs' => 'bat',
  'wlm' => 'cel',
  'ahb' => 'pqe',
  'lat' => 'itc',
  'tnk' => 'pqe',
  'fil' => 'phi',
  'gga' => 'pqe',
  'seh' => 'bnt',
  'bts' => 'btk',
  'wiy' => 'aql',
  'alq' => 'alg',
  'mop' => 'myn',
  'ast' => 'roa',
  'eya' => 'xnd',
  'vif' => 'bnt',
  'hye' => 'ine',
  'pef' => 'hok',
  'sma' => 'smi',
  'ixl' => 'myn',
  'nde' => 'bnt',
  'krl' => 'fiu',
  'xgf' => 'azc',
  'gzn' => 'pqe',
  'tut' => 'mul',
  'lug' => 'bnt',
  'lib' => 'pqe',
  'kdd' => 'aus',
  'mrj' => 'fiu',
  'guk' => 'ssa',
  'lbx' => 'pqw',
  'arc' => 'sem',
  'goo' => 'pqe',
  'nno' => 'gmq',
  'mpz' => 'cdc',
  'lpx' => 'sdv',
  'ngf' => 'paa',
  'teo' => 'sdv',
  'xpu' => 'sem',
  'bkw' => 'bnt',
  'liw' => 'sal',
  'mon' => 'xgn',
  'ctg' => 'inc',
  'san' => 'pra',
  'rmt' => 'inc',
  'din' => 'sdv',
  'mwh' => 'pqe',
  'lkt' => 'xsi',
  'uge' => 'pqe',
  'ree' => 'pqw',
  'not' => 'awd',
  'pgk' => 'pqe',
  'tbq' => 'sit',
  'ynn' => 'hok',
  'por' => 'roa',
  'hin' => 'inc',
  'tpz' => 'pqe',
  'bel' => 'zle',
  'mhe' => 'mkh',
  'kxd' => 'pqw',
  'sog' => 'ira',
  'mag' => 'inc',
  'xpr' => 'ira',
  'ton' => 'pqe',
  'kuv' => 'ira',
  'vma' => 'aus',
  'jnj' => 'omv',
  'tlx' => 'pqe',
  'czh' => 'zhx',
  'lmu' => 'pqe',
  'jkr' => 'sit',
  'gni' => 'aus',
  'ccp' => 'inc',
  'slr' => 'trk',
  'ium' => 'hmx',
  'aql' => 'mul',
  'mml' => 'mkh',
  'txs' => 'phi',
  'lky' => 'sdv',
  'cjs' => 'trk',
  'ngc' => 'bnt',
  'nij' => 'pqw',
  'yid' => 'gmw',
  'tbz' => 'alv',
  'hac' => 'ira',
  'mnv' => 'pqe',
  'xbr' => 'poz',
  'xld' => 'ine',
  'hus' => 'myn',
  'xvi' => 'iir',
  'muv' => 'dra',
  'mvo' => 'pqe',
  'ood' => 'azc',
  'erg' => 'pqe',
  'keo' => 'sdv',
  'oka' => 'sal',
  'chr' => 'iro',
  'tah' => 'pqe',
  'iba' => 'pqw',
  'lcm' => 'pqe',
  'xbc' => 'ira',
  'aru' => 'auf',
  'gui' => 'tup',
  'ntm' => 'alv',
  'epo' => 'art',
  'ngr' => 'pqe',
  'har' => 'sem',
  'ess' => 'ypk',
  'xpc' => 'trk',
  'mzn' => 'ira',
  'bkz' => 'pqw',
  'poc' => 'myn',
  'wiv' => 'pqe',
  'bsq' => 'kro',
  'aia' => 'pqe',
  'ktn' => 'tup',
  'jdt' => 'ira',
  'shr' => 'bnt',
  'akv' => 'ccn',
  'clc' => 'ath',
  'bcq' => 'omv',
  'lbe' => 'ccn',
  'mga' => 'cel',
  'agx' => 'ccn',
  'tpw' => 'tup',
  'lav' => 'bat',
  'kxs' => 'xgn',
  'rcf' => 'cpf',
  'krj' => 'phi',
  'mdd' => 'alv',
  'wol' => 'alv',
  'sjd' => 'smi',
  'osa' => 'xsi',
  'cco' => 'omq',
  'bim' => 'alv',
  'kie' => 'ssa',
  'urr' => 'pqe',
  'otd' => 'pqw',
  'shu' => 'sem',
  'baa' => 'pqe',
  'puw' => 'pqe',
  'gba' => 'alv',
  'sps' => 'pqe',
  'bfa' => 'sdv',
  'kjb' => 'myn',
  'acv' => 'hok',
  'cps' => 'phi',
  'one' => 'iro',
  'mep' => 'aus',
  'tuv' => 'sdv',
  'nok' => 'sal',
  'smw' => 'pqw',
  'fij' => 'pqe',
  'bik' => 'phi',
  'kon' => 'bnt',
  'nzi' => 'alv',
  'chu' => 'zls',
  'soh' => 'alv',
  'isg' => 'sgn',
  'mah' => 'pqe',
  'kpz' => 'sdv',
  'dar' => 'ccn',
  'sco' => 'gmw',
  'lng' => 'gmw',
  'gqr' => 'phi',
  'hau' => 'cdc',
  'bvd' => 'pqe',
  'xls' => 'ine',
  'vao' => 'pqe',
  'gur' => 'alv',
  'kvq' => 'kar',
  'swa' => 'swa',
  'qxq' => 'trk',
  'chy' => 'alg',
  'cgg' => 'bnt',
  'mbo' => 'bnt',
  'lcf' => 'pqw',
  'nnz' => 'bai',
  'noc' => 'wak',
  'koa' => 'pqe',
  'nqo' => 'nic',
  'bgj' => 'alv',
  'bbl' => 'ccn',
  'rkm' => 'dmn',
  'wwo' => 'pqe',
  'itz' => 'myn',
  'rng' => 'bnt',
  'ems' => 'ypk',
  'hla' => 'pqe',
  'bmq' => 'alv',
  'pqw' => 'poz',
  'ban' => 'pqw',
  'jbe' => 'ber',
  'shy' => 'ber',
  'uhn' => 'ngf',
  'ckb' => 'ira',
  'sit' => 'mul',
  'yua' => 'myn',
  'art' => 'mul',
  'fax' => 'roa',
  'xbm' => 'cel',
  'ssb' => 'pqw',
  'jmc' => 'bnt',
  'sel' => 'syd',
  'pgu' => 'paa',
  'inc' => 'iir',
  'mez' => 'alg',
  'nub' => 'sdv',
  'oma' => 'xsi',
  'zty' => 'omq',
  'slm' => 'pqw',
  'goq' => 'pqw',
  'ksd' => 'pqe',
  'jav' => 'pqw',
  'scb' => 'mkh',
  'yec' => 'gmw',
  'bhc' => 'pqe',
  'hat' => 'cpf',
  'bzh' => 'pqe',
  'aac' => 'cdd',
  'ssw' => 'bnt',
  'smo' => 'pqe',
  'gqi' => 'tbq',
  'eyo' => 'sdv',
  'sii' => 'mkh',
  'siy' => 'ira',
  'aus' => 'mul',
  'blr' => 'mkh',
  'xce' => 'cel',
  'clm' => 'sal',
  'ary' => 'sem',
  'nuw' => 'pqe',
  'kbp' => 'alv',
  'amv' => 'plf',
  'sht' => 'hok',
  'maj' => 'omq',
  'slk' => 'zlw',
  'dai' => 'pqw',
  'myb' => 'csu',
  'cel' => 'ine',
  'csb' => 'zlw',
  'pot' => 'alg',
  'gjn' => 'alv',
  'cdo' => 'zhx',
  'sgh' => 'ira',
  'afr' => 'gmw',
  'vro' => 'fiu',
  'hak' => 'zhx',
  'aar' => 'cus',
  'ces' => 'zlw',
  'gmh' => 'gmw',
  'aul' => 'pqe',
  'chk' => 'pqe',
  'llp' => 'pqe',
  'syd' => 'urj',
  'shk' => 'sdv',
  'bko' => 'bai',
  'bra' => 'inc',
  'chm' => 'fiu',
  'ses' => 'son',
  'jpx' => 'mul',
  'nnb' => 'bnt',
  'lrv' => 'pqe',
  'mbp' => 'cba',
  'gob' => 'awd',
  'sdo' => 'dai',
  'bth' => 'dai',
  'etn' => 'pqe',
  'tkl' => 'pqe',
  'aln' => 'ine',
  'bzg' => 'fox',
  'ypk' => 'esx',
  'smp' => 'sem',
  'iow' => 'xsi',
  'pre' => 'cpp',
  'mkd' => 'zls',
  'kss' => 'alv',
  'moa' => 'dmn',
  'blf' => 'phi',
  'syl' => 'inc',
  'rug' => 'pqe',
  'ldm' => 'alv',
  'nlg' => 'pqe',
  'xpi' => 'cel',
  'nwe' => 'bai',
  'tta' => 'xsi',
  'lee' => 'alv',
  'wxa' => 'zhx',
  'zgr' => 'pqe',
  'aud' => 'pqe',
  'aau' => 'paa',
  'guc' => 'awd',
  'caa' => 'myn',
  'aze' => 'trk',
  'ofo' => 'xsi',
  'dru' => 'fox',
  'bwn' => 'hmx',
  'nor' => 'gmq',
  'vol' => 'art',
  'cim' => 'gmw',
  'jct' => 'trk',
  'tsd' => 'grk',
  'dak' => 'xsi',
  'sor' => 'cdc',
  'mar' => 'inc',
  'tau' => 'ath',
  'app' => 'pqe',
  'ctu' => 'myn',
  'pif' => 'pqe',
  'xpg' => 'ine',
  'trk' => 'tut',
  'ltz' => 'gmw',
  'yue' => 'zhx',
  'cwe' => 'bnt',
  'kin' => 'bnt',
  'mns' => 'fiu',
  'nyl' => 'aav',
  'lad' => 'roa',
  'ilo' => 'phi',
  'kac' => 'sit',
  'pmz' => 'omq',
  'efi' => 'alv',
  'wym' => 'gmw',
  'brx' => 'tbq',
  'kry' => 'ccn',
  'swe' => 'gmq',
  'ddd' => 'sdv',
  'kfc' => 'dra',
  'akl' => 'phi',
  'dyo' => 'alv',
  'mwc' => 'pqe',
  'kmv' => 'cpf',
  'urh' => 'alv',
  'cor' => 'cel',
  'tox' => 'pqe',
  'btk' => 'pqw',
  'mrm' => 'pqe',
  'byv' => 'bai',
  'mln' => 'pqe',
  'ndo' => 'bnt',
  'plu' => 'awd',
  'bzt' => 'art',
  'rut' => 'ccn',
  'fit' => 'fiu',
  'str' => 'sal',
  'wls' => 'pqe',
  'gcf' => 'cpf',
  'sax' => 'pqe',
  'mox' => 'pqe',
  'loz' => 'bnt',
  'shh' => 'azc',
  'pic' => 'bnt',
  'cou' => 'alv',
  'vec' => 'roa',
  'aoa' => 'cpp',
  'lbn' => 'mkh',
  'zmw' => 'bnt',
  'aeb' => 'sem',
  'tar' => 'azc',
  'ppl' => 'azc',
  'btm' => 'btk',
  'fwa' => 'pqe',
  'pmq' => 'omq',
  'pan' => 'inc',
  'hah' => 'pqe',
  'guj' => 'inc',
  'lmg' => 'pqe',
  'kff' => 'dra',
  'ruk' => 'ccn',
  'yka' => 'pqw',
  'bgc' => 'inc',
  'hmd' => 'hmx',
  'swx' => 'auf',
  'iku' => 'esx',
  'tus' => 'iro',
  'dml' => 'inc',
  'tnl' => 'pqe',
  'wyy' => 'pqe',
  'bre' => 'cel',
  'tac' => 'azc',
  'kln' => 'sdv',
  'boi' => 'hok',
  'plf' => 'poz',
  'nsw' => 'pqe',
  'zbl' => 'art',
  'mhn' => 'gmw',
  'niy' => 'csu',
  'mte' => 'pqe',
  'kxv' => 'dra',
  'ncb' => 'mkh',
  'nrn' => 'gmq',
  'snq' => 'bnt',
  'fmp' => 'bai',
  'kau' => 'ssa',
  'dag' => 'alv',
  'poh' => 'myn',
  'kwf' => 'pqe',
  'pbs' => 'omq',
  'arg' => 'roa',
  'pwn' => 'fox',
  'yaq' => 'azc',
  'imy' => 'ine',
  'maf' => 'cdc',
  'tin' => 'ccn',
  'yej' => 'grk',
  'bot' => 'csu',
  'cae' => 'alv',
  'kar' => 'sit',
  'chg' => 'trk',
  'lzz' => 'ccs',
  'coc' => 'hok',
  'min' => 'pqw',
  'mwr' => 'inc',
  'ndp' => 'bnt',
  'gmy' => 'grk',
  'pra' => 'inc',
  'gcr' => 'cpf',
  'mri' => 'pqe',
  'bno' => 'phi',
  'xaw' => 'azc',
  'bqz' => 'bnt',
  'sqo' => 'ira',
  'sgy' => 'ira',
  'moe' => 'alg',
  'ayb' => 'alv',
  'hml' => 'hmx',
  'lob' => 'alv',
  'tha' => 'taw',
  'kwk' => 'wak',
  'pel' => 'pqw',
  'zgh' => 'ber',
  'com' => 'azc',
  'apb' => 'pqe',
  'xgl' => 'bat',
  'krf' => 'pqe',
  'kat' => 'ccs',
  'nso' => 'bnt',
  'uga' => 'sem',
  'ale' => 'esx',
  'mak' => 'pqw',
  'prn' => 'iir',
  'abw' => 'ira',
  'opt' => 'azc',
  'crx' => 'ath',
  'wyr' => 'tup',
  'mia' => 'alg',
  'psw' => 'pqe',
  'pmo' => 'hok',
  'twy' => 'pqw',
  'ycn' => 'awd',
  'end' => 'poz',
  'apw' => 'apa',
  'gct' => 'gmw',
  'obt' => 'cel',
  'nmb' => 'pqe',
  'oua' => 'ber',
  'mkv' => 'pqe',
  'abb' => 'bnt',
  'som' => 'cus',
  'juc' => 'tuw',
  'mam' => 'myn',
  'osx' => 'gmw',
  'lch' => 'bnt',
  'mwi' => 'pqe',
  'zim' => 'cdc',
  'inh' => 'ccn',
  'fan' => 'bnt',
  'nxq' => 'sit',
  'hoa' => 'pqe',
  'kay' => 'tup',
  'yap' => 'pqe',
  'btr' => 'pqe',
  'ixc' => 'omq',
  'kge' => 'pqw',
  'tgx' => 'ath',
  'eus' => 'euq',
  'krc' => 'trk',
  'tam' => 'dra',
  'bax' => 'alv',
  'wec' => 'kro',
  'phi' => 'pqw',
  'niu' => 'pqe',
  'xao' => 'mkh',
  'afh' => 'art',
  'dta' => 'xgn',
  'ist' => 'roa',
  'heb' => 'sem',
  'twt' => 'tup',
  'obi' => 'hok',
  'bgk' => 'mkh',
  'tql' => 'pqe',
  'twm' => 'tbq',
  'sij' => 'pqe',
  'sgc' => 'sdv',
  'pim' => 'alg',
  'aie' => 'pqe',
  'cup' => 'azc',
  'zwa' => 'omv',
  'paa' => 'mul',
  'lgb' => 'pqe',
  'mfy' => 'azc',
  'mai' => 'inc',
  'mrc' => 'hok',
  'pfa' => 'pqe',
  'soy' => 'alv',
  'bnq' => 'phi',
  'jgo' => 'bai',
  'tat' => 'trk',
  'czk' => 'zlw',
  'urj' => 'mul',
  'dez' => 'bnt',
  'kcv' => 'bnt',
  'rmg' => 'gmq',
  'tft' => 'paa',
  'lpa' => 'pqe',
  'bgt' => 'pqe',
  'lyn' => 'bnt',
  'kha' => 'mkh',
  'cre' => 'alg',
  'ply' => 'mkh',
  'nog' => 'tut',
  'xwo' => 'xgn',
  'isk' => 'ira',
  'mla' => 'pqe',
  'bub' => 'xgn',
  'pli' => 'pra',
  'sot' => 'bnt',
  'wbk' => 'iir',
  'jpn' => 'jpx',
  'jya' => 'tbq',
  'mft' => 'pqe',
  'fra' => 'roa',
  'vun' => 'bnt',
  'mwk' => 'dmn',
  'sev' => 'alv',
  'abq' => 'ccn',
  'erk' => 'pqe',
  'kru' => 'dra',
  'drg' => 'pqw',
  'lui' => 'azc',
  'kak' => 'phi',
  'kqs' => 'alv',
  'luy' => 'bnt',
  'oji' => 'alg',
  'nan' => 'zhx',
  'tla' => 'azc',
  'ing' => 'ath',
  'mwm' => 'csu',
  'mql' => 'alv',
  'kia' => 'trk',
  'nic' => 'mul',
  'wbm' => 'mkh',
  'guh' => 'awd',
  'nbl' => 'bnt',
  'fiu' => 'urj',
  'bae' => 'awd',
  'jbn' => 'ber',
  'rad' => 'cmc',
  'tfi' => 'alv',
  'yao' => 'bnt',
  'pdo' => 'pqw',
  'tay' => 'fox',
  'adj' => 'alv',
  'mwv' => 'pqw',
  'aba' => 'alv',
  'pol' => 'zlw',
  'dob' => 'pqe',
  'shs' => 'sal',
  'ber' => 'afa',
  'gwi' => 'ath',
  'iru' => 'dra',
  'utp' => 'pqe',
  'aut' => 'pqe',
  'roa' => 'itc',
  'kxu' => 'dra',
  'nap' => 'roa',
  'anm' => 'tbq',
  'mug' => 'cdc',
  'grr' => 'ber',
  'fao' => 'gmq',
  'rsl' => 'sgn',
  'has' => 'wak',
  'agw' => 'pqe',
  'mmr' => 'hmx',
  'llx' => 'pqe',
  'bvc' => 'pqe',
  'sem' => 'afa',
  'ank' => 'cdc',
  'kdr' => 'trk',
  'kkk' => 'pqe',
  'apa' => 'ath',
  'unm' => 'alg',
  'qua' => 'xsi',
  'pej' => 'hok',
  'klb' => 'hok',
  'zaw' => 'omq',
  'tmr' => 'sem',
  'azo' => 'alv',
  'mnh' => 'alv',
  'gfk' => 'pqe',
  'mdf' => 'fiu',
  'gwt' => 'inc',
  'bce' => 'alv',
  'kcm' => 'csu',
  'tcy' => 'dra',
  'gak' => 'paa',
  'pmn' => 'phi',
  'xmz' => 'pqw',
  'ddg' => 'paa',
  'pbg' => 'awd',
  'mhb' => 'bnt',
  'kpe' => 'dmn',
  'tpx' => 'omq',
  'lag' => 'bnt',
  'mlq' => 'dmn',
  'bji' => 'cus',
  'piv' => 'pqe',
  'xog' => 'bnt',
  'ncn' => 'pqe',
  'kck' => 'bnt',
  'lml' => 'pqe',
  'irr' => 'aav',
  'wae' => 'gmw',
  'khq' => 'son',
  'sun' => 'pqw',
  'mhw' => 'bnt',
  'mky' => 'pqe',
  'nsn' => 'pqe',
  'esu' => 'ypk',
  'ksk' => 'xsi',
  'kxr' => 'pqe',
  'vot' => 'fiu',
  'paw' => 'cdd',
  'lle' => 'pqe',
  'eve' => 'tuw',
  'dws' => 'art',
  'fap' => 'alv',
  'lbw' => 'pqw',
  'rgn' => 'roa',
  'ify' => 'phi',
  'jbo' => 'art',
  'iai' => 'pqe',
  'cym' => 'cel',
  'sei' => 'hok',
  'lga' => 'pqe',
  'dal' => 'cus',
  'xlc' => 'ine',
  'lbb' => 'pqe',
  'doz' => 'omv',
  'tmc' => 'cdc',
  'mxr' => 'pqw',
  'miz' => 'omq',
  'ani' => 'ccn',
  'dur' => 'alv',
  'neg' => 'tuw',
  'sbc' => 'pqe',
  'raj' => 'inc',
  'mhq' => 'xsi',
  'khw' => 'inc',
  'gay' => 'pqw',
  'hur' => 'sal',
  'chl' => 'azc',
  'tbe' => 'pqe',
  'kje' => 'plf',
  'ext' => 'roa',
  'xmw' => 'pqw',
  'aqc' => 'ccn',
  'sid' => 'cus',
  'grc' => 'grk',
  'ngl' => 'bnt',
  'mfv' => 'alv',
  'sme' => 'smi',
  'ach' => 'sdv',
  'onw' => 'nub',
  'duu' => 'tbq',
  'mkm' => 'pqw',
  'sov' => 'pqe',
  'zne' => 'znd',
  'xco' => 'ira',
  'bjk' => 'pqe',
  'cpf' => 'roa',
  'gla' => 'cel',
  'kcy' => 'son',
  'kkt' => 'fiu',
  'tcm' => 'paa',
  'agq' => 'alv',
  'tlb' => 'paa',
  'otr' => 'alv',
  'urd' => 'inc',
  'cid' => 'hok',
  'xps' => 'ine',
  'sjr' => 'pqe',
  'lah' => 'inc',
  'bpy' => 'inc',
  'mdr' => 'pqw',
  'jaj' => 'pqe',
  'dop' => 'alv',
  'ljp' => 'pqw',
  'unr' => 'mun',
  'pao' => 'azc',
  'ozm' => 'alv',
  'ser' => 'azc',
  'tdi' => 'pqw',
  'knj' => 'myn',
  'atw' => 'hok',
  'pqe' => 'poz',
  'bll' => 'xsi',
  'dzo' => 'sit',
  'kdk' => 'pqe',
  'mxi' => 'roa',
  'mlo' => 'alv',
  'grk' => 'ine',
  'sjt' => 'smi',
  'bem' => 'bnt',
  'kho' => 'ira',
  'lpo' => 'tbq',
  'thp' => 'sal',
  'ogc' => 'alv',
  'gud' => 'kro',
  'anu' => 'sdv',
  'sce' => 'xgn',
  'bxe' => 'afa',
  'amh' => 'sem',
  'wti' => 'ssa',
  'txy' => 'pqw',
  'yly' => 'pqe',
  'cjy' => 'zhx',
  'lez' => 'ccn',
  'eng' => 'gmw',
  'sse' => 'pqw',
  'dtp' => 'pqw',
  'fod' => 'alv',
  'lgn' => 'ssa',
  'fro' => 'roa',
  'cji' => 'ccn',
  'jah' => 'mkh',
  'ddj' => 'aus',
  'irk' => 'cus',
  'gwc' => 'inc',
  'awd' => 'mul',
  'zap' => 'omq',
  'mye' => 'bnt',
  'auf' => 'mul',
  'mdi' => 'csu',
  'hop' => 'azc',
  'hvn' => 'poz',
  'syc' => 'sem',
  'xcb' => 'cel',
  'sna' => 'bnt',
  'fab' => 'cpp',
  'pkn' => 'aus',
  'gin' => 'ccn',
  'bnn' => 'fox',
  'sqn' => 'iro',
  'tkr' => 'ccn',
  'dum' => 'gmw',
  'uuu' => 'mkh',
  'bju' => 'alv',
  'ind' => 'pqw',
  'syr' => 'sem',
  'ava' => 'ccn',
  'rml' => 'inc',
  'mrv' => 'pqe',
  'hni' => 'sit',
  'peh' => 'xgn',
  'tsu' => 'fox',
  'pap' => 'cpp',
  'pma' => 'pqe',
  'gri' => 'pqe',
  'bbc' => 'btk',
  'mmy' => 'cdc',
  'uzb' => 'trk',
  'qun' => 'sal',
  'ghn' => 'pqe',
  'hch' => 'azc',
  'tsr' => 'pqe',
  'trv' => 'fox',
  'bid' => 'cdc',
  'nwb' => 'kro',
  'den' => 'ath',
  'xkq' => 'pqw',
  'anc' => 'cdc',
  'sjm' => 'pqw',
  'tio' => 'pqe',
  'ksf' => 'bnt',
  'tmi' => 'pqe',
  'otm' => 'oto',
  'yii' => 'aus',
  'hoo' => 'bnt',
  'cjk' => 'bnt',
  'tmy' => 'pqe',
  'dny' => 'auf',
  'est' => 'fiu',
  'fos' => 'fox',
  'grt' => 'sit',
  'lcl' => 'map',
  'mmt' => 'pqe',
  'azb' => 'trk',
  'ron' => 'roa',
  'qvy' => 'sit',
  'scx' => 'ine',
  'njh' => 'sit',
  'kdt' => 'aav',
  'cjm' => 'cmc',
  'frp' => 'roa',
  'xfa' => 'itc',
  'mee' => 'pqe',
  'otk' => 'trk',
  'naq' => 'khi',
  'nmn' => 'khi',
  'xaa' => 'sem'
};
#-*-perl-*-

=head1 SUBROUTINES

=head2 @langcodes = language_group( $groupcode )

Returns a list of language codes within the given language group.

=cut


sub language_group{
    if (exists $$LanguageGroup{$_[0]}){
	return @{$$LanguageGroup{$_[0]}};
    }
    print STDERR "unknown language group $_[0]\n";
    return ();
}


=head2 @parentcode = language_group( $langcode )

Returns the parent language code for the given language.

=cut


sub language_parent{
    if (exists $$LanguageParent{$_[0]}){
	return $$LanguageParent{$_[0]};
    }
    print STDERR "no parent found for '$_[0]'\n";
    return undef;
}


## don't need the functions below, just use ISO::639::3
##

# =head2 $name = language_group_name( $groupcode )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_language_name($_[0]);
# }


# =head2 $code = language_group_code( $groupname )

# Returns the name of the language group

# =cut


# sub language_group_name{
#     return ISO::639::3::get_iso639_3($_[0]);
# }



1;

