/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.model.graph;

import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.model.graph.DocNode;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;
import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocEdge
extends Edge
implements Cloneable {
    public static int MATCH_ONE = 0;
    public static int MATCH_N_TIL_FIRST = 1;
    public static int MATCH_N_TIL_LAST = 2;
    public static int MATCH_N_ANY = 3;
    protected int multipleMatch = MATCH_ONE;
    protected boolean removeFromInstance = false;
    public static Color DEFAULT_COLOR = Color.decode("#0000B0");
    public static Color MOUSE_OVER_COLOR = Color.pink;
    protected DocNode from;
    protected DocNode to;
    protected float weight;
    protected int repetitions = 1;
    public static int LENGTH_ANY = 10;
    public static int LENGTH_BLOCK = 11;
    public static int LENGTH_COLUMN = 12;
    public static int LENGTH_GREATER = 13;
    public static int REL_NONE = 0;
    public static int REL_LEFT_RIGHT = 1;
    public static int REL_RIGHT_LEFT = 2;
    public static float ALIGN_TOLERANCE = 3.0f;
    protected float matchMinLength = 0.0f;
    protected float matchMaxLength = 0.0f;
    protected int logicalLength = LENGTH_GREATER;
    protected int matchLength = LENGTH_ANY;
    protected boolean mAlignTopLeft = false;
    protected boolean mAlignCentre = false;
    protected boolean mAlignBottomRight = false;
    protected boolean crossesRulingLine = false;
    protected boolean matchCrossesRulingLine = false;
    protected int readingOrder = REL_NONE;
    protected boolean matchReadingOrder = false;
    protected int superiorInferior = REL_NONE;
    protected boolean matchSuperiorInferior = false;
    protected String relation;
    static final String ont = "http://www.dbai.tuwien.ac.at/staff/hassan/pdfwrap.owl#pdfwrap:";
    public static final String ADJ_LEFT = "http://www.dbai.tuwien.ac.at/staff/hassan/pdfwrap.owl#pdfwrap:adjLeft";
    public static final String ADJ_RIGHT = "http://www.dbai.tuwien.ac.at/staff/hassan/pdfwrap.owl#pdfwrap:adjRight";
    public static final String ADJ_ABOVE = "http://www.dbai.tuwien.ac.at/staff/hassan/pdfwrap.owl#pdfwrap:adjAbove";
    public static final String ADJ_BELOW = "http://www.dbai.tuwien.ac.at/staff/hassan/pdfwrap.owl#pdfwrap:adjBelow";

    public DocEdge(DocNode nodeFrom, DocNode nodeTo) {
        super((Node)nodeFrom, (Node)nodeTo, DEFAULT_LENGTH);
        this.weight = 1.0f;
        this.length = (int)Math.pow(this.weight, 0.85) + 10;
    }

    public DocEdge(DocNode nodeFrom, DocNode nodeTo, float weight) {
        super((Node)nodeFrom, (Node)nodeTo, DEFAULT_LENGTH);
        this.weight = weight;
        this.length = (int)Math.pow(weight, 0.85) + 10;
    }

    public DocEdge(DocNode nodeFrom, DocNode nodeTo, int repetitions) {
        super((Node)nodeFrom, (Node)nodeTo, DEFAULT_LENGTH);
        this.weight = 1.0f;
        this.repetitions = repetitions;
        this.length = (int)Math.pow(this.weight, 0.85) + 10;
    }

    public DocEdge(AdjacencyEdge ae, DocNode nodeFrom, DocNode nodeTo) {
        super((Node)nodeFrom, (Node)nodeTo, DEFAULT_LENGTH);
        this.from = nodeFrom;
        this.to = nodeTo;
        this.weight = 1.0f;
        this.length = (int)Math.pow(this.weight, 0.85) + 10;
        switch (ae.getDirection()) {
            case 0: {
                this.relation = ADJ_LEFT;
                this.weight = (int)Math.pow(ae.physicalLength(), 0.85) + 10;
                break;
            }
            case 1: {
                this.relation = ADJ_RIGHT;
                this.weight = (int)Math.pow(ae.physicalLength(), 0.85) + 10;
                break;
            }
            case 2: {
                this.relation = ADJ_ABOVE;
                this.weight = (int)Math.pow(ae.physicalLength(), 0.85) + 10;
                break;
            }
            case 3: {
                this.relation = ADJ_BELOW;
                this.weight = (int)Math.pow(ae.physicalLength(), 0.85) + 10;
            }
        }
    }

    public DocEdge(Element nodeElement, List<DocNode> nodes) {
        super(null, null);
        NodeList nl = nodeElement.getElementsByTagName("node-from");
        Element el = (Element)nl.item(0);
        NodeList textNL = el.getChildNodes();
        String val = textNL.item(0).getNodeValue().trim();
        int nodeFromHC = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("node-to");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        int nodeToHC = Integer.parseInt(val);
        for (DocNode n : nodes) {
            if (Integer.parseInt(n.getID()) == nodeFromHC) {
                this.from = n;
            }
            if (Integer.parseInt(n.getID()) != nodeToHC) continue;
            this.to = n;
        }
        nl = nodeElement.getElementsByTagName("relation");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        this.relation = val = textNL.item(0).getNodeValue().trim();
        nl = nodeElement.getElementsByTagName("weight");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.weight = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("remove-from-instance");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.removeFromInstance = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("multiple-match");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.multipleMatch = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("match-min-length");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchMinLength = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("match-max-length");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchMaxLength = Float.parseFloat(val);
        nl = nodeElement.getElementsByTagName("logical-length");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.logicalLength = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("match-length");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchLength = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("match-align-top-left");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.mAlignTopLeft = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("match-align-centre");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.mAlignCentre = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("match-align-bottom-right");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.mAlignBottomRight = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("crosses-ruling-line");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.crossesRulingLine = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("match-crosses-ruling-line");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchCrossesRulingLine = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("reading-order");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.readingOrder = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("match-reading-order");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchReadingOrder = Boolean.parseBoolean(val);
        nl = nodeElement.getElementsByTagName("superior-inferior");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.superiorInferior = Integer.parseInt(val);
        nl = nodeElement.getElementsByTagName("match-superior-inferior");
        el = (Element)nl.item(0);
        textNL = el.getChildNodes();
        val = textNL.item(0).getNodeValue().trim();
        this.matchSuperiorInferior = Boolean.parseBoolean(val);
    }

    public DocNode getFrom() {
        return this.from;
    }

    public void setFrom(DocNode from) {
        this.from = from;
    }

    public DocNode getTo() {
        return this.to;
    }

    public void setTo(DocNode to) {
        this.to = to;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        return "AttributedEdge: " + this.relation + "\n NodeFrom: " + this.from + "\nNodeTo: " + this.to + "\n";
    }

    public String getStringLabel() {
        return "Direction: " + this.relation + "     Length: " + this.weight;
    }

    public String toSBText() {
        return "ID: " + this.getID();
    }

    public int getLength() {
        if (this.removeFromInstance) {
            return (int)Math.pow(this.weight, 0.55);
        }
        return (int)Math.pow(this.weight, 0.85) + 10;
    }

    public static boolean isInverse(DocEdge e1, DocEdge e2) {
        if (e1.getRelation().equals(ADJ_LEFT)) {
            if (e2.getRelation().equals(ADJ_RIGHT)) {
                return true;
            }
            if (e1.getRelation().equals(ADJ_RIGHT)) {
                if (e2.getRelation().equals(ADJ_LEFT)) {
                    return true;
                }
                if (e1.getRelation().equals(ADJ_ABOVE)) {
                    if (e2.getRelation().equals(ADJ_BELOW)) {
                        return true;
                    }
                    if (e1.getRelation().equals(ADJ_BELOW) && e2.getRelation().equals(ADJ_ABOVE)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void addAsXMLEdge(Document resultDocument, Element parent) {
        Element newNodeElement = resultDocument.createElement("edge");
        this.setXMLEdgeAttributes(resultDocument, newNodeElement);
        parent.appendChild(newNodeElement);
    }

    public void setXMLEdgeAttributes(Document resultDocument, Element nodeElement) {
        Element newAttribElement = resultDocument.createElement("node-from");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.from.getID()));
        newAttribElement = resultDocument.createElement("node-to");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.to.getID()));
        newAttribElement = resultDocument.createElement("weight");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.weight)));
        newAttribElement = resultDocument.createElement("relation");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(this.relation.toString()));
        newAttribElement = resultDocument.createElement("remove-from-instance");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.removeFromInstance)));
        newAttribElement = resultDocument.createElement("multiple-match");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.multipleMatch)));
        newAttribElement = resultDocument.createElement("match-min-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.matchMinLength)));
        newAttribElement = resultDocument.createElement("match-max-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Float.toString(this.matchMaxLength)));
        newAttribElement = resultDocument.createElement("logical-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.logicalLength)));
        newAttribElement = resultDocument.createElement("match-length");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.matchLength)));
        newAttribElement = resultDocument.createElement("match-align-top-left");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.mAlignTopLeft)));
        newAttribElement = resultDocument.createElement("match-align-centre");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.mAlignCentre)));
        newAttribElement = resultDocument.createElement("match-align-bottom-right");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.mAlignBottomRight)));
        newAttribElement = resultDocument.createElement("crosses-ruling-line");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.crossesRulingLine)));
        newAttribElement = resultDocument.createElement("match-crosses-ruling-line");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchCrossesRulingLine)));
        newAttribElement = resultDocument.createElement("reading-order");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.readingOrder)));
        newAttribElement = resultDocument.createElement("match-reading-order");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchReadingOrder)));
        newAttribElement = resultDocument.createElement("superior-inferior");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Integer.toString(this.superiorInferior)));
        newAttribElement = resultDocument.createElement("match-superior-inferior");
        nodeElement.appendChild(newAttribElement);
        newAttribElement.appendChild(resultDocument.createTextNode(Boolean.toString(this.matchSuperiorInferior)));
    }

    public void clearWrapperEdits() {
        this.matchMinLength = 0.0f;
        this.matchMaxLength = 0.0f;
        this.matchLength = LENGTH_ANY;
        this.mAlignTopLeft = false;
        this.mAlignCentre = false;
        this.mAlignBottomRight = false;
        this.matchCrossesRulingLine = false;
        this.matchReadingOrder = false;
        this.matchSuperiorInferior = false;
        this.multipleMatch = MATCH_ONE;
        this.removeFromInstance = false;
    }

    public Color getColor() {
        Color c = new Color(127, 127, 127);
        if (this.relation.equals(ADJ_RIGHT)) {
            c = new Color(159, 159, 255);
        } else if (this.relation.equals(ADJ_BELOW)) {
            c = new Color(159, 255, 159);
        }
        return c;
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHints(Utils.hints);
        Color c = this.getColor();
        if (this.getMultipleMatch() != MATCH_ONE) {
            c = c.darker().darker();
        }
        if (this.isRemoveFromInstance()) {
            c = c.brighter();
        }
        if (tgPanel.getMouseOverN() == this.from || tgPanel.getMouseOverE() == this) {
            c = MOUSE_OVER_COLOR;
        }
        int x1 = (int)this.from.drawx;
        int y1 = (int)this.from.drawy;
        int x2 = (int)this.to.drawx;
        int y2 = (int)this.to.drawy;
        int arrowWidth = 3;
        int outlineWidth = 2;
        int backgroundWidth = arrowWidth + outlineWidth;
        if (this.intersects(tgPanel.getSize())) {
            int[] a2;
            double dist;
            int y3;
            int x3;
            if (this == tgPanel.getSelect()) {
                int[] a1;
                x3 = x1;
                y3 = y1;
                dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
                if (dist > 10.0) {
                    double adjustDistRatio = (dist - 10.0) / dist;
                    x3 = (int)((double)x1 + (double)(x2 - x1) * adjustDistRatio);
                    y3 = (int)((double)y1 + (double)(y2 - y1) * adjustDistRatio);
                }
                x3 = (int)((double)(x3 * 4 + x1) / 5.0);
                y3 = (int)((double)(y3 * 4 + y1) / 5.0);
                g.setColor(c.darker());
                if (x2 > x1 && y2 > y1 || x1 > x2 && y1 > y2) {
                    a1 = new int[]{x1 - backgroundWidth, x2 - 1, x2 + 1, x1 + backgroundWidth};
                    a2 = new int[]{y1 + backgroundWidth, y2 + 1, y2 - 1, y1 - backgroundWidth};
                    g.fillPolygon(a1, a2, 4);
                } else {
                    a1 = new int[]{x1 - backgroundWidth, x2 - 1, x2 + 1, x1 + backgroundWidth};
                    a2 = new int[]{y1 - backgroundWidth, y2 - 1, y2 + 1, y1 + backgroundWidth};
                    g.fillPolygon(a1, a2, 4);
                }
            }
            g.setColor(c);
            x3 = x1;
            y3 = y1;
            dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            if (dist > 10.0) {
                double adjustDistRatio = (dist - 10.0) / dist;
                x3 = (int)((double)x1 + (double)(x2 - x1) * adjustDistRatio);
                y3 = (int)((double)y1 + (double)(y2 - y1) * adjustDistRatio);
            }
            x3 = (int)((double)(x3 * 4 + x1) / 5.0);
            y3 = (int)((double)(y3 * 4 + y1) / 5.0);
            if (x2 > x1 && y2 > y1 || x1 > x2 && y1 > y2) {
                int[] a1 = new int[]{x1 - arrowWidth, x2, x1 + arrowWidth};
                a2 = new int[]{y1 + arrowWidth, y2, y1 - arrowWidth};
                g.fillPolygon(a1, a2, 3);
            } else {
                int[] a1 = new int[]{x1 - arrowWidth, x2, x1 + arrowWidth};
                a2 = new int[]{y1 - arrowWidth, y2, y1 + arrowWidth};
                g.fillPolygon(a1, a2, 3);
            }
        }
    }

    public static void paintLine(Graphics g, int x1, int y1, int x2, int y2, Color c) {
    }

    public boolean isAlignTopLeft() {
        if (this.relation.equals(ADJ_BELOW)) {
            return Utils.within(this.from.getSegX1(), this.to.getSegX1(), ALIGN_TOLERANCE);
        }
        if (this.relation.equals(ADJ_RIGHT)) {
            return Utils.within(this.from.getSegY1(), this.to.getSegY1(), ALIGN_TOLERANCE);
        }
        return false;
    }

    public boolean isAlignCentre() {
        if (this.relation.equals(ADJ_BELOW)) {
            return Utils.within(this.from.segXmid(), this.to.segXmid(), ALIGN_TOLERANCE);
        }
        if (this.relation.equals(ADJ_RIGHT)) {
            return Utils.within(this.from.segYmid(), this.to.segYmid(), ALIGN_TOLERANCE);
        }
        return false;
    }

    public boolean isAlignBottomRight() {
        if (this.relation.equals(ADJ_BELOW)) {
            return Utils.within(this.from.getSegX2(), this.to.getSegX2(), ALIGN_TOLERANCE);
        }
        if (this.relation.equals(ADJ_RIGHT)) {
            return Utils.within(this.from.getSegY2(), this.to.getSegY2(), ALIGN_TOLERANCE);
        }
        return false;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public int getMultipleMatch() {
        return this.multipleMatch;
    }

    public void setMultipleMatch(int multipleMatch) {
        this.multipleMatch = multipleMatch;
    }

    public boolean isRemoveFromInstance() {
        return this.removeFromInstance;
    }

    public void setRemoveFromInstance(boolean removeFromInstance) {
        this.removeFromInstance = removeFromInstance;
    }

    public float getMatchMinLength() {
        return this.matchMinLength;
    }

    public void setMatchMinLength(float matchMinLength) {
        this.matchMinLength = matchMinLength;
    }

    public float getMatchMaxLength() {
        return this.matchMaxLength;
    }

    public void setMatchMaxLength(float matchMaxLength) {
        this.matchMaxLength = matchMaxLength;
    }

    public int getLogicalLength() {
        return this.logicalLength;
    }

    public void setLogicalLength(int logicalLength) {
        this.logicalLength = logicalLength;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public void setMatchLength(int matchLength) {
        this.matchLength = matchLength;
    }

    public boolean isMAlignTopLeft() {
        return this.mAlignTopLeft;
    }

    public void setMAlignTopLeft(boolean mAlignTopLeft) {
        this.mAlignTopLeft = mAlignTopLeft;
    }

    public boolean isMAlignCentre() {
        return this.mAlignCentre;
    }

    public void setMAlignCentre(boolean mAlignCentre) {
        this.mAlignCentre = mAlignCentre;
    }

    public boolean isMAlignBottomRight() {
        return this.mAlignBottomRight;
    }

    public void setMAlignBottomRight(boolean mAlignBottomRight) {
        this.mAlignBottomRight = mAlignBottomRight;
    }

    public boolean isCrossesRulingLine() {
        return this.crossesRulingLine;
    }

    public void setCrossesRulingLine(boolean crossesRulingLine) {
        this.crossesRulingLine = crossesRulingLine;
    }

    public boolean isMatchCrossesRulingLine() {
        return this.matchCrossesRulingLine;
    }

    public void setMatchCrossesRulingLine(boolean matchCrossesRulingLine) {
        this.matchCrossesRulingLine = matchCrossesRulingLine;
    }

    public int getReadingOrder() {
        return this.readingOrder;
    }

    public void setReadingOrder(int readingOrder) {
        this.readingOrder = readingOrder;
    }

    public boolean isMatchReadingOrder() {
        return this.matchReadingOrder;
    }

    public void setMatchReadingOrder(boolean matchReadingOrder) {
        this.matchReadingOrder = matchReadingOrder;
    }

    public int getSuperiorInferior() {
        return this.superiorInferior;
    }

    public void setSuperiorInferior(int superiorInferior) {
        this.superiorInferior = superiorInferior;
    }

    public boolean isMatchSuperiorInferior() {
        return this.matchSuperiorInferior;
    }

    public void setMatchSuperiorInferior(boolean matchSuperiorInferior) {
        this.matchSuperiorInferior = matchSuperiorInferior;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }
}

