package Locales::DB::Territory::mgh;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::mgh::VERSION = '0.09';

$Locales::DB::Territory::mgh::cldr_version = '2.0';

%Locales::DB::Territory::mgh::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Uandora',
    'ae'  => "United\ Arab\ Emirates",
    'af'  => 'Ufugustani',
    'ag'  => "Antigua\ and\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Ualbania',
    'am'  => 'Armenia',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'Angola',
    'aq'  => 'Antarctica',
    'ar'  => 'Argentina',
    'as'  => "Usamoa\ ya\ Marekani",
    'at'  => 'Austria',
    'au'  => 'Australia',
    'aw'  => 'Aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Uazabajani',
    'ba'  => "Bosnia\ and\ Herzegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladesh',
    'be'  => 'Belgium',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgaria',
    'bh'  => 'Bahrain',
    'bi'  => 'Urundi',
    'bj'  => 'Ubelin',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brazil',
    'bs'  => 'Bahamas',
    'bt'  => 'Bhutan',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswana',
    'by'  => 'Belarus',
    'bz'  => 'Belize',
    'ca'  => 'Ukanada',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Congo\ \[DRC\]",
    'cf'  => "Central\ African\ Republic",
    'cg'  => 'Ukongo',
    'ch'  => 'Uswisi',
    'ci'  => 'Ukodiva',
    'ck'  => "Cook\ Islands",
    'cl'  => 'Uchile',
    'cm'  => 'Cameroon',
    'cn'  => 'Uchina',
    'co'  => 'Ukolombia',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Costa\ Rica",
    'cs'  => "Usiera\ Leoni",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Ukuba',
    'cv'  => "Cape\ Verde",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Ukuprosi',
    'cz'  => 'Ucheki',
    'dd'  => "East\ Germany",
    'de'  => 'Germany',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Ujibuti',
    'dk'  => 'Udenimaka',
    'dm'  => 'Udominika',
    'do'  => "Dominican\ Republic",
    'dz'  => 'Alujeria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Estonia',
    'eg'  => 'Umisiri',
    'eh'  => "Western\ Sahara",
    'er'  => 'Uriterea',
    'es'  => 'Uhispania',
    'et'  => 'Uhabeshi',
    'eu'  => "European\ Union",
    'fi'  => 'Ufini',
    'fj'  => 'Ufiji',
    'fk'  => "Falkland\ Islands\ \[Islas\ Malvinas\]",
    'fm'  => 'Micronesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Ufaransa',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Ugaboni',
    'gb'  => "United\ Kingdom",
    'gd'  => 'Ugrenada',
    'ge'  => 'Ujojia',
    'gf'  => "Ufaransa\ yo\ Gwaya",
    'gg'  => 'Guernsey',
    'gh'  => 'Ugana',
    'gi'  => 'Ujibralta',
    'gl'  => 'Ugrinlandi',
    'gm'  => 'Ugambia',
    'gn'  => 'Ugine',
    'gp'  => 'Ugwadelupe',
    'gq'  => "Equatorial\ Guinea",
    'gr'  => 'Greece',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Ugwatemala',
    'gu'  => 'Ugwam',
    'gw'  => 'Uginebisau',
    'gy'  => 'Uguyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Uhondurasi',
    'hr'  => 'Ukorasia',
    'ht'  => 'Uhaiti',
    'hu'  => 'Uhungaria',
    'ic'  => "Canary\ Islands",
    'id'  => 'Undonesia',
    'ie'  => 'Uayalandi',
    'il'  => 'Uisraeli',
    'im'  => "Isle\ of\ Man",
    'in'  => 'Uhindini',
    'io'  => "British\ Indian\ Ocean\ Territory",
    'iq'  => 'Wiraki',
    'ir'  => 'Iran',
    'is'  => 'Iceland',
    'it'  => 'Italia',
    'je'  => 'Jersey',
    'jm'  => 'Ujamaika',
    'jo'  => 'Uyordani',
    'jp'  => 'Ujapani',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Ukenya',
    'kg'  => 'Kyrgyzstan',
    'kh'  => 'Ukambodia',
    'ki'  => 'Kiribati',
    'km'  => 'Ukomoro',
    'kn'  => "Usantakitzi\ na\ Nevis",
    'kp'  => "Ukorea\ Kaskazini",
    'kr'  => "Ukorea\ Kusini",
    'kw'  => 'Kuwait',
    'ky'  => "Cayman\ Islands",
    'kz'  => 'Ukazakistani',
    'la'  => 'Laos',
    'lb'  => 'Ulebanoni',
    'lc'  => 'Usantalusia',
    'li'  => 'Ushenteni',
    'lk'  => 'Usirilanka',
    'lr'  => 'Uliberia',
    'ls'  => 'Ulesoto',
    'lt'  => 'Utwania',
    'lu'  => 'Usembaji',
    'lv'  => 'Ulativia',
    'ly'  => 'Ulibya',
    'ma'  => 'Morocco',
    'mc'  => 'Monaco',
    'md'  => 'Moldova',
    'me'  => 'Umantegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Ubukini',
    'mh'  => "Marshall\ Islands",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Umasedonia',
    'ml'  => 'Mali',
    'mm'  => "Myanmar\ \[Burma\]",
    'mn'  => 'Mongolia',
    'mo'  => 'Macau',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldives',
    'mw'  => 'Umalawi',
    'mx'  => 'Mexico',
    'my'  => 'Malaysia',
    'mz'  => 'Umozambiki',
    'na'  => 'Namibia',
    'nc'  => "New\ Caledonia",
    'ne'  => 'Unijeri',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'Unijeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'Netherlands',
    'no'  => 'Unorwe',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "New\ Zealand",
    'om'  => 'Uomani',
    'pa'  => 'Upanama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Uperuu',
    'pf'  => "Ufaransa\ yo\ Potina",
    'pg'  => 'Upapua',
    'ph'  => 'Ufilipino',
    'pk'  => 'Upakistani',
    'pl'  => 'Upolandi',
    'pm'  => "Usantapieri\ na\ Mikeloni",
    'pn'  => 'Upitkairni',
    'pr'  => 'Upwetoriko',
    'ps'  => "Palestinian\ Territories",
    'pt'  => 'Portugal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paragwai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Ukatari',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Uriyunioni',
    'ro'  => 'Uromania',
    'rs'  => 'Serbia',
    'ru'  => 'Russia',
    'rw'  => 'Urwanda',
    'sa'  => 'Usaudi',
    'sb'  => "Solomon\ Islands",
    'sc'  => 'Ushelisheli',
    'sd'  => 'Usudani',
    'se'  => 'Uswidi',
    'sg'  => 'Usingapoo',
    'sh'  => 'Usantahelena',
    'si'  => 'Uslovenia',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Uslovakia',
    'sl'  => "Sierra\ Leone",
    'sm'  => 'Usamarino',
    'sn'  => 'Usenegali',
    'so'  => 'Usomalia',
    'sr'  => 'Usurinamu',
    'st'  => "Usao\ Tome\ na\ Principe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => 'Usalavado',
    'sy'  => 'Usiria',
    'sz'  => 'Uswazi',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'Uchadi',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Utogo',
    'th'  => 'Utailandi',
    'tj'  => 'Ujikistani',
    'tk'  => 'Utokelau',
    'tl'  => "Utimo\ Mashariki",
    'tm'  => 'Uturukimenistani',
    'tn'  => 'Utunisia',
    'to'  => 'Utonga',
    'tr'  => 'Utuki',
    'tt'  => "Utrinidad\ na\ Tobago",
    'tv'  => 'Utuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Utanzania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'Umarekani',
    'uy'  => 'Uruguay',
    'uz'  => 'Uzbekistan',
    'va'  => 'Uvatikani',
    'vc'  => "Usantavisenti\ na\ Grenadini",
    'vd'  => "North\ Vietnam",
    've'  => 'Uvenezuela',
    'vg'  => "British\ Virgin\ Islands",
    'vi'  => "U\.S\.\ Virgin\ Islands",
    'vn'  => 'Uvietinamu',
    'vu'  => 'Uvanuatu',
    'wf'  => "Uwalis\ na\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Usamoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Uyemeni',
    'yt'  => 'Mayotte',
    'za'  => "Afrika\ du\ Sulu",
    'zm'  => 'Uzambia',
    'zw'  => 'Uzimbabwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::mgh::name_to_code = (
    'africa'                                    => '002',
    'afrikadusulu'                              => 'za',
    'alujeria'                                  => 'dz',
    'americas'                                  => '019',
    'angola'                                    => 'ao',
    'anguilla'                                  => 'ai',
    'antarctica'                                => 'aq',
    'antiguaandbarbuda'                         => 'ag',
    'argentina'                                 => 'ar',
    'armenia'                                   => 'am',
    'aruba'                                     => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australia'                                 => 'au',
    'australiaandnewzealand'                    => '053',
    'austria'                                   => 'at',
    'bahamas'                                   => 'bs',
    'bahrain'                                   => 'bh',
    'bangladesh'                                => 'bd',
    'barbados'                                  => 'bb',
    'belarus'                                   => 'by',
    'belgium'                                   => 'be',
    'belize'                                    => 'bz',
    'bermuda'                                   => 'bm',
    'bhutan'                                    => 'bt',
    'bolivia'                                   => 'bo',
    'bosniaandherzegovina'                      => 'ba',
    'botswana'                                  => 'bw',
    'bouvetisland'                              => 'bv',
    'brazil'                                    => 'br',
    'britishantarcticterritory'                 => 'bq',
    'britishindianoceanterritory'               => 'io',
    'britishvirginislands'                      => 'vg',
    'brunei'                                    => 'bn',
    'bulgaria'                                  => 'bg',
    'burkinafaso'                               => 'bf',
    'cameroon'                                  => 'cm',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'capeverde'                                 => 'cv',
    'caribbean'                                 => '029',
    'caymanislands'                             => 'ky',
    'centralafricanrepublic'                    => 'cf',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'christmasisland'                           => 'cx',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'congodrc'                                  => 'cd',
    'cookislands'                               => 'ck',
    'costarica'                                 => 'cr',
    'czechoslovakia'                            => 200,
    'diegogarcia'                               => 'dg',
    'dominicanrepublic'                         => 'do',
    'dronningmaudland'                          => 'nq',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'ecuador'                                   => 'ec',
    'equatorialguinea'                          => 'gq',
    'estonia'                                   => 'ee',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'falklandislandsislasmalvinas'              => 'fk',
    'faroeislands'                              => 'fo',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'germany'                                   => 'de',
    'greece'                                    => 'gr',
    'guernsey'                                  => 'gg',
    'heardislandandmcdonaldislands'             => 'hm',
    'hongkong'                                  => 'hk',
    'iceland'                                   => 'is',
    'iran'                                      => 'ir',
    'isleofman'                                 => 'im',
    'italia'                                    => 'it',
    'jersey'                                    => 'je',
    'johnstonisland'                            => 'jt',
    'kiribati'                                  => 'ki',
    'kuwait'                                    => 'kw',
    'kyrgyzstan'                                => 'kg',
    'laos'                                      => 'la',
    'latinamerica'                              => 419,
    'macau'                                     => 'mo',
    'malaysia'                                  => 'my',
    'maldives'                                  => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'marshallislands'                           => 'mh',
    'martinique'                                => 'mq',
    'mauritania'                                => 'mr',
    'mauritius'                                 => 'mu',
    'mayotte'                                   => 'yt',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'mexico'                                    => 'mx',
    'micronesia'                                => 'fm',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'moldova'                                   => 'md',
    'monaco'                                    => 'mc',
    'mongolia'                                  => 'mn',
    'montserrat'                                => 'ms',
    'morocco'                                   => 'ma',
    'myanmarburma'                              => 'mm',
    'namibia'                                   => 'na',
    'nauru'                                     => 'nr',
    'nepal'                                     => 'np',
    'netherlands'                               => 'nl',
    'netherlandsantilles'                       => 'an',
    'neutralzone'                               => 'nt',
    'newcaledonia'                              => 'nc',
    'newzealand'                                => 'nz',
    'nicaragua'                                 => 'ni',
    'niue'                                      => 'nu',
    'norfolkisland'                             => 'nf',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northernmarianaislands'                    => 'mp',
    'northvietnam'                              => 'vd',
    'oceania'                                   => '009',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'palau'                                     => 'pw',
    'palestinianterritories'                    => 'ps',
    'panamacanalzone'                           => 'pz',
    'paragwai'                                  => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'polynesia'                                 => '061',
    'portugal'                                  => 'pt',
    'russia'                                    => 'ru',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'serbia'                                    => 'rs',
    'sierraleone'                               => 'sl',
    'solomonislands'                            => 'sb',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'svalbardandjanmayen'                       => 'sj',
    'taiwan'                                    => 'tw',
    'tristandacunha'                            => 'ta',
    'turksandcaicosislands'                     => 'tc',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    "u\.s\.virginislands"                       => 'vi',
    'ualbania'                                  => 'al',
    'uandora'                                   => 'ad',
    'uayalandi'                                 => 'ie',
    'uazabajani'                                => 'az',
    'ubelin'                                    => 'bj',
    'ubukini'                                   => 'mg',
    'uchadi'                                    => 'td',
    'ucheki'                                    => 'cz',
    'uchile'                                    => 'cl',
    'uchina'                                    => 'cn',
    'udenimaka'                                 => 'dk',
    'udominika'                                 => 'dm',
    'ufaransa'                                  => 'fr',
    'ufaransayogwaya'                           => 'gf',
    'ufaransayopotina'                          => 'pf',
    'ufiji'                                     => 'fj',
    'ufilipino'                                 => 'ph',
    'ufini'                                     => 'fi',
    'ufugustani'                                => 'af',
    'ugaboni'                                   => 'ga',
    'ugambia'                                   => 'gm',
    'ugana'                                     => 'gh',
    'uganda'                                    => 'ug',
    'ugine'                                     => 'gn',
    'uginebisau'                                => 'gw',
    'ugrenada'                                  => 'gd',
    'ugrinlandi'                                => 'gl',
    'uguyana'                                   => 'gy',
    'ugwadelupe'                                => 'gp',
    'ugwam'                                     => 'gu',
    'ugwatemala'                                => 'gt',
    'uhabeshi'                                  => 'et',
    'uhaiti'                                    => 'ht',
    'uhindini'                                  => 'in',
    'uhispania'                                 => 'es',
    'uhondurasi'                                => 'hn',
    'uhungaria'                                 => 'hu',
    'uisraeli'                                  => 'il',
    'ujamaika'                                  => 'jm',
    'ujapani'                                   => 'jp',
    'ujibralta'                                 => 'gi',
    'ujibuti'                                   => 'dj',
    'ujikistani'                                => 'tj',
    'ujojia'                                    => 'ge',
    'ukambodia'                                 => 'kh',
    'ukanada'                                   => 'ca',
    'ukatari'                                   => 'qa',
    'ukazakistani'                              => 'kz',
    'ukenya'                                    => 'ke',
    'ukodiva'                                   => 'ci',
    'ukolombia'                                 => 'co',
    'ukomoro'                                   => 'km',
    'ukongo'                                    => 'cg',
    'ukorasia'                                  => 'hr',
    'ukoreakaskazini'                           => 'kp',
    'ukoreakusini'                              => 'kr',
    'ukraine'                                   => 'ua',
    'ukuba'                                     => 'cu',
    'ukuprosi'                                  => 'cy',
    'ulativia'                                  => 'lv',
    'ulebanoni'                                 => 'lb',
    'ulesoto'                                   => 'ls',
    'uliberia'                                  => 'lr',
    'ulibya'                                    => 'ly',
    'umalawi'                                   => 'mw',
    'umantegro'                                 => 'me',
    'umarekani'                                 => 'us',
    'umasedonia'                                => 'mk',
    'umisiri'                                   => 'eg',
    'umozambiki'                                => 'mz',
    'undonesia'                                 => 'id',
    'unijeri'                                   => 'ne',
    'unijeria'                                  => 'ng',
    'unionofsovietsocialistrepublics'           => 'su',
    'unitedarabemirates'                        => 'ae',
    'unitedkingdom'                             => 'gb',
    'unknownregion'                             => 'zz',
    'unorwe'                                    => 'no',
    'uomani'                                    => 'om',
    'upakistani'                                => 'pk',
    'upanama'                                   => 'pa',
    'upapua'                                    => 'pg',
    'uperuu'                                    => 'pe',
    'upitkairni'                                => 'pn',
    'upolandi'                                  => 'pl',
    'upwetoriko'                                => 'pr',
    'uriterea'                                  => 'er',
    'uriyunioni'                                => 're',
    'uromania'                                  => 'ro',
    'uruguay'                                   => 'uy',
    'urundi'                                    => 'bi',
    'urwanda'                                   => 'rw',
    'usalavado'                                 => 'sv',
    'usamarino'                                 => 'sm',
    'usamoa'                                    => 'ws',
    'usamoayamarekani'                          => 'as',
    'usantahelena'                              => 'sh',
    'usantakitzinanevis'                        => 'kn',
    'usantalusia'                               => 'lc',
    'usantapierinamikeloni'                     => 'pm',
    'usantavisentinagrenadini'                  => 'vc',
    'usaotomenaprincipe'                        => 'st',
    'usaudi'                                    => 'sa',
    'usembaji'                                  => 'lu',
    'usenegali'                                 => 'sn',
    'ushelisheli'                               => 'sc',
    'ushenteni'                                 => 'li',
    'usieraleoni'                               => 'cs',
    'usingapoo'                                 => 'sg',
    'usiria'                                    => 'sy',
    'usirilanka'                                => 'lk',
    'uslovakia'                                 => 'sk',
    'uslovenia'                                 => 'si',
    'usomalia'                                  => 'so',
    'usudani'                                   => 'sd',
    'usurinamu'                                 => 'sr',
    'uswazi'                                    => 'sz',
    'uswidi'                                    => 'se',
    'uswisi'                                    => 'ch',
    'utailandi'                                 => 'th',
    'utanzania'                                 => 'tz',
    'utimomashariki'                            => 'tl',
    'utogo'                                     => 'tg',
    'utokelau'                                  => 'tk',
    'utonga'                                    => 'to',
    'utrinidadnatobago'                         => 'tt',
    'utuki'                                     => 'tr',
    'utunisia'                                  => 'tn',
    'uturukimenistani'                          => 'tm',
    'utuvalu'                                   => 'tv',
    'utwania'                                   => 'lt',
    'uvanuatu'                                  => 'vu',
    'uvatikani'                                 => 'va',
    'uvenezuela'                                => 've',
    'uvietinamu'                                => 'vn',
    'uwalisnafutuna'                            => 'wf',
    'uyemeni'                                   => 'ye',
    'uyordani'                                  => 'jo',
    'uzambia'                                   => 'zm',
    'uzbekistan'                                => 'uz',
    'uzimbabwe'                                 => 'zw',
    'wakeisland'                                => 'wk',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'wiraki'                                    => 'iq',
    'world'                                     => '001',
    "\Ã\landislands"                         => 'ax',
);

1;

