package WordList::Phrase::ZH::Idiom::Wiktionary;

our $DATE = '2016-02-10'; # DATE
our $VERSION = '0.02'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("avg_word_len",4.44047619047619,"shortest_word_len",2,"num_words_contains_unicode",1008,"num_words_contains_nonword_chars",45,"num_words_contains_whitespace",0,"longest_word_len",14,"num_words",1008); # STATS

1;
# ABSTRACT: Chinese idioms (chengyu) from wiktionary.org

=pod

=encoding UTF-8

=head1 NAME

WordList::Phrase::ZH::Idiom::Wiktionary - Chinese idioms (chengyu) from wiktionary.org

=head1 VERSION

This document describes version 0.02 of WordList::Phrase::ZH::Idiom::Wiktionary (from Perl distribution WordList-Phrase-ZH-Idiom-Wiktionary), released on 2016-02-10.

=head1 SYNOPSIS

 use WordList::Phrase::ZH::Idiom::Wiktionary;

 my $wl = WordList::Phrase::ZH::Idiom::Wiktionary->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This module contains idioms from Wiktionary. Only simplified forms are included
here.

=head1 STATISTICS

 +----------------------------------+------------------+
 | key                              | value            |
 +----------------------------------+------------------+
 | avg_word_len                     | 4.44047619047619 |
 | longest_word_len                 | 14               |
 | num_words                        | 1008             |
 | num_words_contains_nonword_chars | 45               |
 | num_words_contains_unicode       | 1008             |
 | num_words_contains_whitespace    | 0                |
 | shortest_word_len                | 2                |
 +----------------------------------+------------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-Phrase-ZH-Idiom-Wiktionary>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-Phrase-ZH-Idiom-Wiktionary>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-Phrase-ZH-Idiom-Wiktionary>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<https://en.wiktionary.org/w/index.php?title=Category:Chinese_idioms>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一丝一毫
一丝不挂
一举两得
一亩三分地
一人之下，万人之上
一仍旧贯
一刀两断
一劳永逸
一塌糊涂
一孔之见
一字褒贬
一帆风顺
一席之地
一干二净
一成不变
一手交钱，一手交货
一手托两家
一把鼻涕一把泪
一无所知
一无是处
一日不见，如隔三秋
一朵鲜花插在牛粪上
一概而论
一模一样
一步一回头
一物克一物
一生受用不尽
一盏茶工夫
一石二鸟
一箭雙雕
一网打尽
一脚高一脚低
一見鍾情
一见倾心
一视同仁
一览无余
一览无遗
一蹴可几
一针见血
一阵青一阵白
一鸣惊人
万事如意
万古长青
万家灯火
万死不辞
万水千山
万象更新
三下五除二
三五成羣
三天打鱼两天晒网
三更灯火五更鸡
上穷碧落下黄泉
下海
下笔如有神
下笔如神
不为五斗米折腰
不二法门
不以为意
不修边幅
不分胜负
不到黄河心不死
不动声色
不可开交
不可思议
不可无一，不可有二
不可胜数
不可胜言
不可胜计
不在话下
不堪一击
不屑一顾
不形于色
不待蓍龟
不得其门而入
不成体统
不拘小节
不欢而散
不正之风
不死也半条命
不求有功，但求无过
不离不弃
不管怎样
不耻下问
不见不散
不解风情
不言不语
不计其数
不识庐山真面目
不负众望
不足为外人道
不足为虑
不遗余力
不问青红皂白
不食人间烟火
不鸣则已，一鸣惊人
不龟手药
东一句西一句
东奔西窜
东家长西家短
东施效颦
东逃西窜
两下
两下子
两害相权取其轻
丧家之犬
丧家之狗
临难苟免
为人处世
举世瞩目
举动荆棘
举手投足
义同生死
乌云密布
乌鲁木齐
乐在其中
乘虚而入
乘风破浪
乱七八糟
乱点鸳鸯谱
乾坤一掷
事不宜迟
事与愿违
于事无补
云屯
云屯雨集
五体投地
井井有条
交头接耳
交错纵横
亲冒矢石
人困马乏
人声鼎沸
人殊意异
人神共愤
人走茶凉
人间天上
人高马大
从天而降
从容不迫
以正视听
以牙还牙
以讹传讹
以身作则
众所周知
优柔寡断
伸手不见五指
位极人臣
低声下气
何去何从
何足挂齿
作如是观
你情我愿
佯输诈败
使出浑身解数
供不应求
侪囝饿死父
信口开河
信口開河
信口雌黄
俯仰无愧
倒悬之危
倒抽一口气
倒竖虎须
倚强欺弱
债台高筑
倾盆大雨
偷得浮生半日闲
偷目窃望
偷鸡摸狗
傍若无人
傲慢无礼
先天下之忧而忧后天下之乐而乐
先礼后兵
先见之明
光彩夺目
兜肚连肠
兢兢业业
入乡随俗
入境随俗
八九不离十
八仙过海，各显神通
八千里路云和月
共襄盛举
关公面前耍大刀
兴高采烈
兵临城下
兵強將盛
兵强将盛
兵微将寡
兵精将勇
兵荒马乱
兵败如山倒
养尊处优
冒烟突火
冢中枯骨
冬暖夏凉
决一死战
冷嘲热讽
冷眼旁观
凹凸有致
出尔反尔
出难题
刀枪不入
分忧共患
分憂共患
别具一格
别开生面
别有洞天
刮目相看
刻舟求剑
削足适履
前赴后继
前遮后拥
剑拔弩张
剩水残山
办事不牢
功亏一篑
动手动脚
助紂為虐
助纣为虐
势不可当
势均力敌
势如奔马
势如破竹
勇气百倍
勇而无谋
勤工俭学
包在……身上
化腐朽为神奇
化险为夷
十万八千里
十动然拒
千乘万骑
千军万马
千差万别
千恩万谢
千方百计
千言万语
千里之行，始于足下
千里姻缘一线牵
半斤八两
协力同心
卖友求荣
卖官鬻爵
南辕北辙
南郭处士
博学强记
卧薪尝胆
历尽艰辛
厚积薄发
厚颜无耻
又好笑，又好气
反唇相稽
反唇相譏
反唇相讥
发愤忘食
变化莫测
变本加厉
口干舌燥
口蜜腹剑
古往今来
只可意会，不可言传
只许州官放火，不许百姓点灯
叫天天不应，叫地地不灵
叫苦连天
可共患难
司马昭之心
吃里扒外
各怀一心
各显神通
各行各业
同仇敌忾
同仇敵愾
同归于尽
同心协力
同舟共济
名不见经传
名副其实
后继无人
否极泰来
含情脉脉
吹皱一池春水
呆头呆脑
周瑜打黄盖
呼风唤雨
和尚打伞，无法无天
和平共处
品学兼优
哪壶不开提哪壶
唇亡齿寒
唇若涂脂
唔经唔觉
唯利是图
喊声震天
喜怒不形于色
喜新厌旧
喝西北风
嗷嗷待哺
器宇轩昂
四两拨千斤
四平八稳
四面八方
回头是岸
因人而异
固执己见
国色天香
坐井观天
坚定不移
坚持不懈
坚贞不屈
声东击西
声名狼藉
夕阳西下
多劳多得
多历年所
多此一举
夜长梦多
大刀阔斧
大包大揽
大同小异
大处着眼，小处着手
大家闺秀
大开方便之门
大惊小怪
大意失荆州
大摇大摆
大放厥词
大有可为
大海捞针
大碌木
大红大紫
大门不出，二门不迈
天上人间
天下大乱
天下归心
天下本无事，庸人自扰之
天伦之乐
天壤之别
天外飞来一笔
天旋地转
天时地利人和
天机不可泄漏
天涯若比邻
天灵灵，地灵灵
天粟马角
天长地久
天高皇帝远
太岁头上动土
夫唱妇随
头昏眼花
夹缝中求生存
奇形怪状
奇文共赏
奇耻大辱
奇花异草
奇装异服
奋不顾身
女大十八变
好利忘义
好吃懒做
好心没好报
好戏还在后头
好气又好笑
好管闲事
好谋
好谋无断
好贤礼士
好高骛远
如入无人之境
如出一辙
如胶似漆
如雨骈集
如雷贯耳
姜太公钓鱼
娇生惯养
娓娓动听
孤力难为
孤陋寡闻
学以致用
宁缺毋滥
安家立业
安民恤众
完璧归赵
官样文章
实事求是
审美疲劳
家丑不可外扬
宾至如归
察言观色
寡不敌众
寸步不离
寸步难行
对牛弹琴
对答如流
寻根究底
将计就计
小题大作
小鸟依人
尸横遍野
尽心竭力
层出不穷
屋漏更遭连夜雨
山穷水尽
山重水复
岁寒三友
岁月不饶人
崇山峻岭
左冲右突
左拥右抱
左邻右舍
差强人意
己所不欲，勿施于人
幸灾乐祸
应天顺人
应弦而倒
庞然大物
废嫡立庶
开门七件事
异口同声
弃旧换新
弃暗投明
弄虚作假
引狼入室
引虎入羊羣
张三李四
弥天亘地
弥足珍贵
弱不禁风
弱水三千，只取一瓢饮
張冠李戴
强不知以为知
强弓硬弩
归根到底
当之无愧
当务之急
当饭吃
彼一时，此一时
彼众我寡
得不偿失
得寸进尺
得理不饶人
得过且过
循序渐进
德才兼备
德艺双馨
心宽体胖
心惊胆战
心惊胆跳
心猿意马
心生一计
心高气傲
志得意满
忧喜交集
怀才不遇
怒气填胸
思前想後
思来想去
恃宠而骄
恨不相逢未嫁时
恶名昭著
恶向胆边生
恶有恶报
悬梁刺股
悲欢岁月
悲欢离合
惊弓之鸟
惊惶失措
惊慌失措
惊某
惟命是听
惠风和畅
想方设法
感激不尽
愤愤不平
愿赌服输
成也萧何，败也萧何
成事不足，败事有余
成家立业
我不入地狱，谁入地狱
手头拮据
手无寸铁
才华横溢
打破砂锅问到底
打铁趁热
扬汤止沸
扮猪吃老虎
找不着北
承先启后
抑扬顿挫
投机倒把
折箭为誓
抛砖引玉
报仇雪恨
报雠雪恨
披发左衽
披肝沥胆
抱佛脚
抱头鼠窜
抽丝剥茧
招财进宝
招贤
招贤纳士
招降纳顺
拨云见日
拨开云雾见青天
择主而事
指天为誓
指手画脚
指鹿为马
按兵不动
按劳分配
振笔疾书
捅娄子
捕风捉影
损人不利己
换汤不换药
据我所知
据理力争
捷足先登
掎角之势
探头探脑
接二连三
推来推去
提笔忘字
插翅难飞
摇旗擂鼓
摘胆剜心
摸不着头脑
摸着石头过河
擎天驾海
支离破碎
攻其无备，出其不意
敢做敢当
敬賢禮士
敬贤礼士
敬酒不吃吃罚酒
斩将搴旗
斩草除根
斩钉截铁
断子绝孙
断章取义
旁若无人
无人之境
无何有之乡
无关大体
无可奉告
无奇不有
无家可归
无心插柳柳成荫
无所不为
无所不用其极
无所作为
无所遁形
无法无天
无用武之地
无精打彩
无精打采
无计可施
无论如何
无话不谈
日积月累
早知今日，何必当初
早闻道，夕死可矣
时不可失
旷世逸才
明目张胆
明知就里
明知故问
明镜高悬
昙花一现
星月交辉
春暖花开
暗暗自责
暗淡无光
暗箭伤人
暴尸于市
暴风骤雨
更待何时
曾经沧海难为水
月明如昼
月白风清
有一搭没一搭
有一顿，没一顿
有两下子
有勇无谋
有口无心
有情人终成眷属
有教无类
有话好说
朋比为奸
望风而靡
朝夕难保
朝气蓬勃
术业有专攻
朱门酒肉臭
杀一儆百
杀身成仁
杀鸡儆猴
杀鸡取卵
杀鸡吓猴
杀鸡给猴看
杀鸡警猴
杂乱无章
杞人忧天
束手待毙
束手无策
来无影去无踪
杯水车薪
杯盘狼藉
杯酒释兵权
林林总总
柴米油盐酱醋茶
标新立异
树功立业
桃园三结义
楚楚动人
横七竖八
横眉竖眼
横行无忌
欢天喜地
欣喜雀跃
欣欣向荣
此地无银三百两
步履维艰
死无葬身之地
死生有命，富贵在天
死而不亡者寿
死记硬背
殊途同归
残暴不仁
殺雞警猴
比手划脚
毛毛雨
毛遂自荐
毫不费力
气宇轩昂
气谊相投
水中捞月
水深火热
水陆毕陈
汉贼不两立
沉鱼落雁
没精打彩
没精打采
河东狮吼
泛泛而谈
波涛汹涌
泪下如雨
泪如泉涌
洋洋洒洒
洞房花烛夜
洪炉燎发
流离失所
浊酒粗食
海内一统
海内人望
海内存知己，天涯若比邻
涂炭
涕泗横流
深更半夜
深沟高垒
溃不成军
源源不绝
滔滔不绝
满腹经纶
满面春风
满面笑容
滥杀无辜
滥竽充数
潜移默化
火上浇油
灯红酒绿
燕颔虎须
爱不释手
爱莫能助
爱面子
物极必反
犄角之势
犬马之力
犬马之报
犹豫不决
狂风怒号
狐羣狗黨
狐群狗党
狗咬吕洞宾
狼吞虎咽
猫哭耗子假慈悲
班门弄斧
甜言蜜语
生儿育女
生动活泼
生是短暂死是永恒
生米煮成熟饭
由点到面
画虎不成反类犬
画蛇添足
画龙点睛
略无忌惮
略无禁惮
疏财仗义
登峰造极
白刀子进，红刀子出
白头偕老
白驹过隙
百口莫辩
百家争鸣
百废俱兴
百折不挠
百无一二
百花齐放
皇亲国戚
目不暇给
目不转睛
目不邪视
目中无人
眉来眼去
看怎么说
真才实学
眼不见为净
眼不见，心不烦
眼睛长在头顶上
眼花撩乱
睁眼说瞎话
瞎猫碰死耗子
知书达礼
知其不可而为
知命
知错能改
石破天惊
破涕为笑
破涕爲笑
破烂不堪
破綻
破镜重圆
碧眼童颜
碰钉子
礼尚往来
礼贤下士
神魂飘荡
神龙见首不见尾
祸在目前
秀色可餐
秋毫无犯
秋风扫落叶
稠人广坐
穷困潦倒
穷根究底
立竿见影
竖子不足与谋
童颜
童颜鹤发
竭尽全力
笨鸟先飞
箭在弦上，不得不发
粗枝大叶
粗茶淡饭
精打细算
紅白事
红光紫雾
红白事
红白喜事
红粉佳人
红透半边天
约法三章
纵横交错
纵横天下
终日不倦
经天纬地
经天纬地之才
经宿不归
绑赴市曹
结草衔环
绘声绘色
绝处逢生
绞尽脑汁
维妙维肖
罪不容诛
罪恶贯盈
羣魔亂舞
群情激愤
群魔乱舞
耀武扬威
老而不死是为贼
老鼠屎
耳熟能详
聚精会神
肆无忌惮
肉颤心惊
肌肤之亲
肚子里的蛔虫
肥头大耳
背信弃义
背水一战
背道而驰
胡说八道
胶柱鼓瑟
脑满肠肥
腾空而起
自以为得计
自以为是
自愧不如
自扫门前雪
自暴自弃
自有公论
自相残害
自相矛盾
自负盈亏
自顾自
舌灿莲花
舍近求远
艰苦奋斗
花好月圆
花心萝卜
苍翠欲滴
苛捐杂税
若无其事
莫报万一
莫敢谁何
获益匪浅
落花有意，流水无情
蒙在鼓里
虎体熊腰
虎体狼腰
虎体猿臂
虎入羊羣
虎无爪，鸟无翼
虚无缥缈
蟾宫折桂
蟾宮折桂
衣不解带
衣冠禽兽
衣锦还乡
衣食无缺
表里一致
袖手旁观
被发左衽
被髮左衽
装门面
要钱不要命
要风得风，要雨得雨
见利忘义
解铃还须系铃人
触景生情
触目惊心
言不尽意
記憶猶新
计将安出
误人子弟
说时迟，那时快
诸如此类
诸葛亮借东风
读书破万卷
谈婚论嫁
谈情说爱
谈笑自若
谋臣武将
豁然开朗
豹头猿臂
豹头环眼
貪官汙吏
贤妻良母
贤母良妻
败兵折将
贪多嚼不烂
贪官污吏
贪心不足
贯斗牛
赏功罚罪
赏心悦目
走来走去
趁热打铁
身在曹营心在汉
车同轨，书同文
轻于鸿毛
边都沾不上
过五关斩六将
迎头赶上
进退两难
进退维谷
进酒作乐
连……带……
连滚带爬
连轴转
适得其反
遗臭万年
遛鸟侠
遥遥领先
那壶不开提那壶
邯郸学步
郁郁不乐
郑人买履
郢书燕说
酒后吐真言
酒过数巡
里外不是人
里应外合
重于泰山
重于泰山，轻于鸿毛
重枣
重男轻女
重色轻友
量入为出
金刚不坏之身
金发碧眼
金枝玉叶
金碧辉煌
金蝉脱壳
金鼓齐鸣
鏡花水月
针头线脑
针锋相对
钿合金钗
铁证如山
铁面无私
铁骨铮铮
铤而走险
银河落九天
铺霜涌雪
锄强扶弱
锋不可当
长他人志气，灭自己威风
长吁短叹
长生不老
閃爍其辭
開門見山
门庭若市
门当户对
闪烁其词
闪烁其辞
闭门造车
问长问短
闷声不响
闻鸡起舞
阳春
阴盛阳衰
阿猫阿狗
随时随地
随机应变
难以启齿
雁杳鱼沉
雷厉风行
雷声大，雨点小
雷打不动
露齿而笑
青史传名
青天白日满地红
青梅竹马
青红皂白
面如重枣
面恶心善
面面相觑
韬光养晦
顶天立地
顺我者生，逆我者死
顾不得许多
顾全大局
顾名思义
顾左右而言他
颓墙坏壁
颠沛流离
風韻猶存
风华正茂
风和日丽
风流倜傥
风韵犹存
风餐露宿
风马牛不相及
飞沙走石
飞砂走石
飞走如风
食之无味，弃之可惜
食肉寝皮
飲水思源
饮水思源
饱餐一顿
驴唇不对马嘴
骨鲠在喉
高枕无忧
鬼也不上门
魂不附体
魂飞天外
魑魅魍魉
鱼死网破
鱼沉雁杳
鱼趁生，人趁茈
鸡同鸭讲
鸡毛当令箭
鸡犬不惊
鸡皮鹤发
鸡蛋里挑骨头
鸣金收军
鹏程万里
鹤发童颜
鹦鹉学舌
鹰击长空
黄鼠狼给鸡拜年
黑马
黯淡无光
鼎足之势
鼓洪炉燎毛发
鼻子不是鼻子脸不是脸
鼻子气歪了
齐心戮力
龙凤呈祥
龙盘虎踞
龙蟠虎踞
龙行虎步
龙骧虎步
