# Generated by default/object.tt
package Paws::Connect::QuickConnectSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has QuickConnectType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::QuickConnectSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::QuickConnectSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., QuickConnectType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::QuickConnectSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains summary information about a quick connect.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the quick connect.


=head2 Id => Str

The identifier for the quick connect.


=head2 Name => Str

The name of the quick connect.


=head2 QuickConnectType => Str

The type of quick connect. In the Amazon Connect console, when you
create a quick connect, you are prompted to assign one of the following
types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

