# Generated by default/object.tt
package Paws::CustomerProfiles::FlowDefinition;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has FlowName => (is => 'ro', isa => 'Str', required => 1);
  has KmsArn => (is => 'ro', isa => 'Str', required => 1);
  has SourceFlowConfig => (is => 'ro', isa => 'Paws::CustomerProfiles::SourceFlowConfig', required => 1);
  has Tasks => (is => 'ro', isa => 'ArrayRef[Paws::CustomerProfiles::Task]', required => 1);
  has TriggerConfig => (is => 'ro', isa => 'Paws::CustomerProfiles::TriggerConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CustomerProfiles::FlowDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CustomerProfiles::FlowDefinition object:

  $service_obj->Method(Att1 => { Description => $value, ..., TriggerConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CustomerProfiles::FlowDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

The configurations that control how Customer Profiles retrieves data
from the source, Amazon AppFlow. Customer Profiles uses this
information to create an AppFlow flow on behalf of customers.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the flow you want to create.


=head2 B<REQUIRED> FlowName => Str

The specified name of the flow. Use underscores (_) or hyphens (-)
only. Spaces are not allowed.


=head2 B<REQUIRED> KmsArn => Str

The Amazon Resource Name of the AWS Key Management Service (KMS) key
you provide for encryption.


=head2 B<REQUIRED> SourceFlowConfig => L<Paws::CustomerProfiles::SourceFlowConfig>

The configuration that controls how Customer Profiles retrieves data
from the source.


=head2 B<REQUIRED> Tasks => ArrayRef[L<Paws::CustomerProfiles::Task>]

A list of tasks that Customer Profiles performs while transferring the
data in the flow run.


=head2 B<REQUIRED> TriggerConfig => L<Paws::CustomerProfiles::TriggerConfig>

The trigger settings that determine how and when the flow runs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CustomerProfiles>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

