# Generated by default/object.tt
package Paws::CloudFormation::TypeVersionSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has TimeCreated => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');
  has TypeName => (is => 'ro', isa => 'Str');
  has VersionId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::TypeVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::TypeVersionSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VersionId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::TypeVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains summary information about a specific version of a
CloudFormation type.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the type version.


=head2 Description => Str

The description of the type version.


=head2 TimeCreated => Str

When the version was registered.


=head2 Type => Str

The kind of type.


=head2 TypeName => Str

The name of the type.


=head2 VersionId => Str

The ID of a specific version of the type. The version ID is the value
at the end of the Amazon Resource Name (ARN) assigned to the type
version when it is registered.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

