# Generated by default/object.tt
package Paws::ElasticBeanstalk::SearchFilter;
  use Moose;
  has Attribute => (is => 'ro', isa => 'Str');
  has Operator => (is => 'ro', isa => 'Str');
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElasticBeanstalk::SearchFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElasticBeanstalk::SearchFilter object:

  $service_obj->Method(Att1 => { Attribute => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElasticBeanstalk::SearchFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->Attribute

=head1 DESCRIPTION

Describes criteria to restrict a list of results.

For operators that apply a single value to the attribute, the filter is
evaluated as follows: C<Attribute Operator Values[1]>

Some operators, e.g. C<in>, can apply multiple values. In this case,
the filter is evaluated as a logical union (OR) of applications of the
operator to the attribute with each one of the values: C<(Attribute
Operator Values[1]) OR (Attribute Operator Values[2]) OR ...>

The valid values for attributes of C<SearchFilter> depend on the API
action. For valid values, see the reference page for the API action
you're calling that takes a C<SearchFilter> parameter.

=head1 ATTRIBUTES


=head2 Attribute => Str

The result attribute to which the filter values are applied. Valid
values vary by API action.


=head2 Operator => Str

The operator to apply to the C<Attribute> with each of the C<Values>.
Valid values vary by C<Attribute>.


=head2 Values => ArrayRef[Str|Undef]

The list of values applied to the C<Attribute> and C<Operator>
attributes. Number of values and valid values vary by C<Attribute>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElasticBeanstalk>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

