# Generated by default/object.tt
package Paws::GameLift::FleetUtilization;
  use Moose;
  has ActiveGameSessionCount => (is => 'ro', isa => 'Int');
  has ActiveServerProcessCount => (is => 'ro', isa => 'Int');
  has CurrentPlayerSessionCount => (is => 'ro', isa => 'Int');
  has FleetArn => (is => 'ro', isa => 'Str');
  has FleetId => (is => 'ro', isa => 'Str');
  has Location => (is => 'ro', isa => 'Str');
  has MaximumPlayerSessionCount => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::FleetUtilization

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::FleetUtilization object:

  $service_obj->Method(Att1 => { ActiveGameSessionCount => $value, ..., MaximumPlayerSessionCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::FleetUtilization object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveGameSessionCount

=head1 DESCRIPTION

Current resource utilization statistics in a specified fleet or
location. The location value might refer to a fleet's remote location
or its home Region.

B<Related actions>

DescribeFleetUtilization | DescribeFleetLocationUtilization

=head1 ATTRIBUTES


=head2 ActiveGameSessionCount => Int

The number of active game sessions that are currently being hosted
across all instances in the fleet location.


=head2 ActiveServerProcessCount => Int

The number of server processes in C<ACTIVE> status that are currently
running across all instances in the fleet location.


=head2 CurrentPlayerSessionCount => Int

The number of active player sessions that are currently being hosted
across all instances in the fleet location.


=head2 FleetArn => Str

The Amazon Resource Name (ARN
(https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
that is assigned to a GameLift fleet resource and uniquely identifies
it. ARNs are unique across all Regions. Format is
C<arn:aws:gamelift:E<lt>regionE<gt>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912>.


=head2 FleetId => Str

A unique identifier for the fleet associated with the location.


=head2 Location => Str

The fleet location for the fleet utilization information, expressed as
an AWS Region code, such as C<us-west-2>.


=head2 MaximumPlayerSessionCount => Int

The maximum number of players allowed across all game sessions that are
currently being hosted across all instances in the fleet location.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

