(function(){var mainRe=new RegExp("create-dialog\/([^\/]+)\/?([^\/]*)");Vue.component("convos-create-dialog",{mixins:[Convos.mixin.autocomplete],props:["user"],data:function(){return{connectionId:"",connection:null,errors:[],loaded:false,hasFocus:false,nRooms:0,rooms:[]};},computed:{autocompleteOptions:function(){var rooms=this.rooms;if(this.autocompleteValue){rooms=[{name:this.autocompleteValue,topic:"Click here to create/join custom dialog"}].concat(rooms);if(rooms.length==2){rooms[0]=rooms.splice(1,1,rooms[0])[0];}
else if(rooms.length>1&&rooms[0].name==rooms[1].name){rooms.shift();}}
return rooms;}},watch:{"autocompleteValue":function(v,o){this.refreshRooms();},"settings.main":function(v,o){if(v.match(mainRe))this.updateForm();}},methods:{autocompleted:function(option){this.join({name:option.name||option.value});},join:function(option){if(!option.name||!this.connection)return;this.connection.send("/join "+option.name);this.autocompleteValue="";},refreshRooms:function(){var self=this;if(this.tid)clearTimeout(this.tid);if(!this.connection)return;this.loaded=false;this.connection.rooms({match:this.autocompleteValue},function(err,res){if(!res.end)self.tid=setTimeout(self.refreshRooms,1500);if(err)return self.errors=err;self.errors=[];self.loaded=res.end;self.nRooms=res.n_rooms;self.rooms=res.rooms;});},setConnection:function(cid,old){if(!cid)return this.settings.main="#connection";setTimeout(function(){this.updateForm(cid);}.bind(this),500);},topic:function(str){str=str.rich({autoLink:false});if(!str)return"No topic.";if(str.length<200)return str;return str.substr(0,200).replace(/\S+$/,"")+"...";},updateForm:function(cid){var path=this.settings.main.match(mainRe);this.connectionId=cid?cid:path?path[1]:"";if(this.connectionId)this.connection=this.user.getConnection(this.connectionId);this.autocompleteValue=path?path[2]:"";this.errors=[];this.rooms=[];this.nRooms=0;this.refreshRooms();}},ready:function(){this.id=Materialize.guid();this.$els.input.focusOnDesktop();this.updateForm();},destroyed:function(){if(this.tid)clearTimeout(this.tid);},template:"<form @submit.prevent autocomplete=\"off\" class=\"convos-create-dialog\">\n    <div class=\"row\">\n      <div class=\"col s12\">\n        <h4>Join dialog</h4>\n        <p>\n          Enter the name of a dialog to either search for the known dialogs,\n          or to create a new chat room.\n        </p>\n      </div>\n    </div>\n    <div class=\"row\">\n      <md-select :value=\"connectionId\" @change=\"setConnection\" label=\"Select connection\">\n        <md-option :value=\"c.connection_id\" v-for=\"c in user.connections\">{{c.protocol}}-{{c.name}}</md-option>\n        <md-option value=\"\">Create new connection...</md-option>\n      </md-select>\n    </div>\n    <div class=\"row\">\n      <div class=\"input-field col s12\">\n        <input :disabled=\"errors.length ? true : false\" :id=\"id\" @blur=\"hasFocus=false\" @focus=\"hasFocus=true\" @keydown=\"keydown\" @keyup=\"keyup\" autocomplete=\"off\" class=\"validate\" debounce=\"200\" placeholder=\"#channel_name\" spellcheck=\"false\" type=\"text\" v-el:input v-model=\"autocompleteValue\">\n        <label :for=\"id\" class=\"active\">Dialog name</label>\n        <div class=\"alert\" v-if=\"errors.length\">\n          Could not load rooms from\n          <a v-link=\"connection.getDialog(&#39;&#39;).href()\">{{connection.connection_id}}</a>:\n          {{errors[0].message}}\n        </div>\n        <div :class=\"autocompleteOptions.length ? &#39;&#39; : &#39;hidden&#39;\" class=\"autocomplete\">\n          <a :class=\"optionClass($index)\" @click.prevent=\"join(room)\" class=\"title\" href=\"#join:{{room.name}}\" v-for=\"room in autocompleteOptions\">\n            <span class=\"badge\"><i class=\"material-icons\" v-if=\"room.n_users\">person</i>{{room.n_users || &quot;new&quot;}}</span>\n            <h6>{{room.name}}</h6>\n            <p v-html=\"topic(room.topic)\"></p>\n          </a>\n        </div>\n        <p v-if=\"loaded\"><small>Number of rooms: {{nRooms}}</small></p>\n        <p v-if=\"!loaded &amp;&amp; !errors.length\"><small>Loading rooms... ({{nRooms}})</small></p>\n      </div>\n    </div>\n  </form>\n"})})();