#!/usr/bin/perl
use warnings;
use strict;

use Test::More tests => 4;

use PDF::Builder::Basic::PDF::Filter::RunLengthDecode;

my $in = '--- Look at this test string. ---';
my $out = "\xfe-\x01 L\xffo\x16k at this test string. \xfe-";
my $filter = bless {}, 'PDF::Builder::Basic::PDF::Filter::RunLengthDecode';

is($filter->outfilt($in),
   $out,
   q{RunLengthDecode test string is encoded correctly});

is($filter->infilt($out),
   $in,
   q{RunLengthDecode test string is decoded correctly});


# Add the end-of-document marker
$out .= "\x80";

is($filter->outfilt($in, 1),
   $out,
   q{RunLengthDecode test string with EOD marker is encoded correctly});

is($filter->infilt($out),
   $in,
   q{RunLengthDecode test string with EOD marker is decoded correctly});

1;
