# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::UA;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230614174404;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            6[12][29]|
            (?:
              35|
              4[1378]|
              5[12457]|
              6[49]
            )2|
            (?:
              56|
              65
            )[24]|
            (?:
              3[1-46-8]|
              46
            )2[013-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[1-8]|
            4(?:
              [1367]|
              [45][6-9]|
              8[4-6]
            )|
            5(?:
              [1-5]|
              6(?:
                [015689]|
                3[02389]
              )|
              7[4-6]
            )|
            6(?:
              [12][3-7]|
              [459]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [3-7]|
            89|
            9[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[89]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'mobile' => '
          (?:
            39|
            50|
            6[36-8]|
            7[1-3]|
            9[1-9]
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(900[239]\\d{5,6})',
                'toll_free' => '800[1-8]\\d{5,6}',
                'voip' => '89[1-579]\\d{6}'
              };
my %areanames = ();
$areanames{uk} = {"3805237", "Петрове\,\ Кіровоград",
"3804736", "Канів\,\ Черкаси",
"3803852", "Ізяслав\,\ Хмельницький",
"3805362", "Хорол\,\ Полтава",
"3806436", "Лутугине\,\ Луганськ",
"3805258", "Мала\ Виска\,\ Кіровоград",
"3804859", "Велика\ Михайлівка\,\ Одеса",
"3805634", "Петриківка\,\ Дніпро",
"3804330", "Оратів\,\ Вінниця",
"3804140", "Народичі\,\ Житомир",
"3804742", "Катеринопіль\,\ Черкаси",
"380619", "Мелітополь\,\ Запорізька",
"3805350", "Котельва\,\ Полтава",
"3806245", "Горлівка\,\ Донецьк",
"3804654", "Щорс\,\ Чернігів",
"380561", "Дніпропетро́вськ\/Дніпро",
"3803264", "Буськ\,\ Львівська",
"3803131", "Мукачеве\,\ Закарпатська",
"3806442", "Алчевськ\,\ Луганськ",
"38037312", "Хотин\,\ Чернівці",
"3803255", "Радехів\,\ Львівська",
"3805756", "Краснокутськ\,\ Харків",
"3805665", "Марганець\,\ Дніпро",
"3805544", "Горностаївка\,\ Херсон",
"3804350", "Вапнярка\,\ Вінниця",
"3806274", "Артемівськ\/Сіверськ\,\ Донецьк",
"3805742", "Купʼянськ\,\ Харків",
"3805654", "Кринички\,\ Дніпро",
"3805238", "Онуфріївка\,\ Кіровоград",
"3804575", "Яготин\,\ Київ",
"3806456", "Троїцьке\,\ Луганськ",
"3805459", "Краснопілля\,\ Суми",
"3805257", "Бобринець\,\ Кіровоград",
"3803235", "Львів\/Львівська",
"3805692", "Дніпродзержинськ\,\ Дніпро",
"3804634", "Талалаївка\,\ Чернігів",
"3803432", "Верховина\,\ Івано\-Франківська",
"3806141", "Оріхів\,\ Запорізька",
"3804596", "Вишгород\/Димер\/Пірнове\,\ Київ",
"3803846", "Віньківці\,\ Хмельницький",
"3806156", "Велика\ Білозерка\,\ Запорізька",
"3803851", "Городок\/Сатанів\,\ Хмельницький",
"3804633", "Ічня\,\ Чернігів",
"3803730", "Вижниця\,\ Чернівці",
"3803479", "Тлумач\,\ Івано\-Франківська",
"3803146", "Міжгірʼя\,\ Закарпатська",
"3805361", "Лубни\,\ Полтава",
"3805538", "Асканія\-Нова\/Чаплинка\,\ Херсон",
"3805159", "Єланець\,\ Миколаїв",
"3806268", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3804741", "Шпола\,\ Черкаси",
"3804139", "Чуднів\,\ Житомир",
"3804349", "Піщанка\,\ Вінниця",
"380327", "Львів\/Львівська",
"3805653", "Вільногірськ\,\ Дніпро",
"3803132", "Рахів\,\ Закарпатська",
"3806441", "Перевальськ\,\ Луганськ",
"3803342", "Володимир\-Волинський\,\ Волинська",
"380564", "Кривий\ Ріг\,\ Дніпро",
"3805543", "Велика\ Лепетиха\,\ Херсон",
"3804866", "Балта\,\ Одеса",
"3806273", "Вугледар\,\ Донецьк",
"38065", "Крим",
"3805741", "Вовчанськ\,\ Харків",
"3803263", "Перемишляни\,\ Львівська",
"3805537", "Лазурне\/Скадовськ\,\ Херсон",
"3804653", "Борзна\,\ Чернігів",
"38036", "Рівне",
"3806136", "Веселе\,\ Запорізька",
"3806469", "Луганськ",
"3805691", "Магдалинівка\,\ Дніпро",
"3803555", "Монастириська\,\ Тернопіль",
"3805633", "Першотравенськ\,\ Дніпро",
"3806267", "Дружківка\,\ Донецьк",
"380649", "Луганськ",
"3804840", "Рені\,\ Одеса",
"3803431", "Галич\,\ Івано\-Франківська",
"3806474", "Попасна\,\ Луганськ",
"380568", "Дніпропетро́вськ\/Дніпро",
"3804566", "Тараща\,\ Київ",
"3806256", "Сніжне\,\ Донецьк",
"3804858", "Ширяєве\,\ Одеса",
"3803733", "Новоселиця\,\ Чернівці",
"3805259", "Ульянівка\,\ Кіровоград",
"3804572", "Козин\/Обухів\/Українка\,\ Київ",
"3805745", "Лозова\,\ Харків",
"3805457", "Велика\ Писарівка\,\ Суми",
"3805662", "Нікополь\,\ Дніпро",
"3803246", "Львів\/Львівська",
"3805540", "Нижні\ Сірогози\,\ Херсон",
"3806270", "Артемівськ\,\ Донецьк",
"3803435", "Рогатин\,\ Івано\-Франківська",
"38057", "Харків",
"3805650", "Софіївка\,\ Дніпро",
"3805443", "Білопілля\,\ Суми",
"3803551", "Теребовля\,\ Тернопіль",
"3803232", "Львів\/Львівська",
"38047", "Черкаси",
"3805354", "Гадяч\,\ Полтава",
"3805239", "Устинівка\,\ Кіровоград",
"3805365", "Глобине\,\ Полтава",
"3803260", "Моршин\,\ Львівська",
"3806236", "Ясинувата\,\ Донецьк",
"3805458", "Тростянець\,\ Суми",
"3803855", "Красилів\,\ Хмельницький",
"3804857", "Миколаївка\,\ Одеса",
"3803368", "Рожище\,\ Волинська",
"3803252", "Жовква\,\ Львівська",
"3806445", "Новоайдар\,\ Луганськ",
"3804843", "Вилкове\/Кілія\,\ Одеса",
"3806242", "Горлівка\,\ Донецьк",
"3805630", "Межова\,\ Дніпро",
"3803122", "Ужгород\,\ Закарпатська",
"3804334", "Гайсин\,\ Вінниця",
"3804144", "Баранівка\,\ Житомир",
"3804745", "Христинівка\,\ Черкаси",
"3803374", "Локачі\,\ Волинська",
"3804143", "Бердичів\,\ Житомир",
"3804333", "Калинівка\,\ Вінниця",
"3805347", "Чутове\,\ Полтава",
"3804844", "Татарбунари\,\ Одеса",
"3803478", "Косів\,\ Івано\-Франківська",
"3804571", "Васильків\/Глеваха\/Гребінки\/Калинівка\,\ Київ",
"3805158", "Баштанка\,\ Миколаїв",
"38061", "Запоріжжя\/Запорізька",
"3805539", "Гола\ Пристань\,\ Херсон",
"3805661", "Нікополь\,\ Дніпро",
"3803636", "Кузнецовськ\,\ Рівне",
"3806297", "Мангуш\/Ялта\,\ Донецьк",
"380320", "Львів\/Львівська",
"3804348", "Томашпіль\,\ Вінниця",
"3804138", "Ружин\,\ Житомир",
"3806145", "Гуляйполе\,\ Запорізька",
"3806269", "Олександрівка\,\ Донецьк",
"380629", "Маріуполь\,\ Донецьк",
"3806467", "Луганськ",
"3803552", "Чортків\,\ Тернопіль",
"3803231", "Городок\,\ Львівська",
"3805353", "Зіньків\,\ Полтава",
"3803656", "Дубно\,\ Рівне",
"3805348", "Комсомольськ\,\ Полтава",
"3803546", "Кременець\/Почаїв\,\ Тернопіль",
"3805444", "Глухів\,\ Суми",
"38033", "Волинська",
"3803477", "Долина\,\ Івано\-Франківська",
"3804353", "Теплик\,\ Вінниця",
"3806468", "Луганськ",
"3803251", "Сколе\/Славське\,\ Львівська",
"3803135", "Великий\ Березний\,\ Закарпатська",
"3803734", "Глибока\,\ Чернівці",
"3804347", "Літин\,\ Вінниця",
"3804137", "Попільня\,\ Житомир",
"3806241", "Горлівка\,\ Донецьк",
"3805240", "Компаніївка\,\ Кіровоград",
"380522", "Кропивницький\,\ Кіровоград",
"3806473", "Словʼяносербськ\,\ Луганськ",
"3806437", "Луганськ",
"3806239", "Красноармійськ\,\ Донецьк",
"3803134", "Солотвино\/Тячів\,\ Закарпатська",
"3806458", "Луганськ",
"3803344", "Нововолинськ\,\ Волинська",
"3803735", "Сторожинець\,\ Чернівці",
"38054", "Суми",
"3804737", "Золотоноша\,\ Черкаси",
"3805236", "Світловодськ\,\ Кіровоград",
"3803261", "Новий\ Роздол\,\ Львівська",
"3805743", "Ізюм\,\ Харків",
"3805167", "Нова\ Одеса\,\ Миколаїв",
"3804598", "Боярка\/Вишневе\,\ Київ",
"3803433", "Коломия\,\ Івано\-Франківська",
"380560", "Дніпропетро́вськ\/Дніпро",
"3805445", "Лебедин\,\ Суми",
"3805757", "Барвінкове\,\ Харків",
"3806175", "Василівка\/Дніпрорудне\,\ Запорізька",
"3805242", "Олександрівка\,\ Кіровоград",
"3805631", "Петропавлівка\,\ Дніпро",
"3805693", "Новомосковськ\,\ Дніпро",
"3803249", "Червоноград\,\ Львівська",
"3805256", "Новомиргород\,\ Кіровоград",
"3805363", "Решетилівка\,\ Полтава",
"3806438", "Луганськ",
"3804569", "Володарка\,\ Київ",
"38048", "Одеса",
"3806259", "Амвросіївка\,\ Донецьк",
"3804631", "Ніжин\,\ Чернігів",
"3803853", "Ярмолинці\,\ Хмельницький",
"3804738", "Драбів\,\ Черкаси",
"3806144", "Новомиколаївка\,\ Запорізька",
"3806457", "Луганськ",
"3806271", "Артемівськ\,\ Донецьк",
"3805758", "Богодухів\,\ Харків",
"3805168", "Березнегувате\,\ Миколаїв",
"3804845", "Арциз\,\ Одеса",
"3804597", "Буча\/Ворзель\/Гостомель\/Ірпінь\/Коцюбинське\,\ Київ",
"3806443", "Брянка\,\ Луганськ",
"3805651", "Дніпропетро́вськ\/Дніпро",
"3803847", "Нова\ Ушиця\,\ Хмельницький",
"3803550", "Збараж\,\ Тернопіль",
"38044", "м\.\ Київ",
"380328", "Львів\/Львівська",
"3806138", "Камʼянка\-Дніпровська\,\ Запорізька",
"3804335", "Тульчин\,\ Вінниця",
"3804145", "Володарськ\-Волинський\,\ Житомир",
"3804744", "Умань\,\ Черкаси",
"3806444", "Стаханов\,\ Луганськ",
"3803549", "Ланівці\,\ Тернопіль",
"3803262", "Львів\/Львівська",
"3803659", "Млинів\,\ Рівне",
"3803854", "Старокостянтинів\,\ Хмельницький",
"3803250", "Львів\/Львівська",
"3806143", "Вільнянськ\,\ Запорізька",
"3804867", "Кодима\,\ Одеса",
"3806240", "Горлівка\,\ Донецьк",
"3805241", "Новгородка\,\ Кіровоград",
"3805632", "Павлоград\,\ Дніпро",
"3805364", "Машівка\,\ Полтава",
"38041", "Житомир",
"3805355", "Миргород\,\ Полтава",
"380622", "Донецьк",
"3805536", "Каховка\,\ Херсон",
"3806137", "Приморськ\,\ Запорізька",
"3804570", "Згурівка\,\ Київ",
"3804632", "Бобровиця\,\ Чернігів",
"3805660", "Нікополь\,\ Дніпро",
"3804355", "Гнівань\/Тиврів\,\ Вінниця",
"3803434", "Ворохта\/Яремче\,\ Івано\-Франківська",
"38051", "Миколаїв",
"3803357", "Камінь\-Каширський\,\ Волинська",
"3806272", "Костянтинівка\,\ Донецьк",
"3804868", "Іллічівськ\,\ Одеса",
"3805744", "Красноград\,\ Харків",
"3805542", "Цюрупинськ\,\ Херсон",
"3803133", "Свалява\,\ Закарпатська",
"3805652", "Жовті\ Води\,\ Дніпро",
"3804646", "Десна\/Козелець\/Остер\,\ Чернігів",
"3806266", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3803230", "Пустомити\,\ Львівська",
"3804351", "Чечельник\,\ Вінниця",
"3805456", "Ямпіль\,\ Суми",
"3803247", "Трускавець\,\ Львівська",
"3803554", "Заліщики\,\ Тернопіль",
"3806459", "Луганськ",
"3804567", "Переяслав\-Хмельницький\,\ Київ",
"3806257", "Іловайськ\/Харцизьк\,\ Донецьк",
"3803372", "Іваничі\,\ Волинська",
"3806471", "Сватове\,\ Луганськ",
"380567", "Дніпропетро́вськ\/Дніпро",
"3803849", "Камʼянець\-Подільський\,\ Хмельницький",
"3806243", "Велика\ Новосілка\,\ Донецьк",
"380612", "Запоріжжя\,\ Запорізька",
"3803253", "Львів\/Львівська",
"3806140", "Чернігівка\,\ Запорізька",
"3803366", "Ратне\,\ Волинська",
"3806237", "Селидове\,\ Донецьк",
"3803248", "Борислав\/Східниця\,\ Львівська",
"3805663", "Синельникове\,\ Дніпро",
"3806439", "Луганськ",
"3804573", "Кагарлик\/Ржищів\,\ Київ",
"3804856", "Березівка\,\ Одеса",
"3803732", "Кельменці\,\ Чернівці",
"3806258", "Донецьк",
"38052", "Кіровоград",
"3804568", "Сквира\,\ Київ",
"3804331", "Брацлав\/Немирів\,\ Вінниця",
"3804141", "Новоград\-Волинський\,\ Житомир",
"3804739", "Чорнобай\,\ Черкаси",
"3805351", "Диканька\,\ Полтава",
"3805759", "Борова\,\ Харків",
"3803233", "Львів\/Львівська",
"380623", "Красноармійськ\/Макіївка\,\ Донецьк",
"3805442", "Путивль\,\ Суми",
"380332", "Луцьк\,\ Волинська",
"3805740", "Нова\ Водолага\,\ Харків",
"38055", "Херсон",
"3806139", "Енергодар\,\ Запорізька",
"3804352", "Бершадь\,\ Вінниця",
"3804635", "Батурин\/Бахмач\,\ Чернігів",
"3806296", "Новоазовськ\,\ Донецьк",
"380572", "Мерефа\/Харків\,\ Харків",
"3803637", "Демидівка\,\ Рівне",
"3803548", "Бережани\,\ Тернопіль",
"3805136", "Південноукраїнськ\,\ Миколаїв",
"3805346", "Карлівка\,\ Полтава",
"3803234", "Мостиська\,\ Львівська",
"3803658", "Дубровиця\,\ Рівне",
"3806472", "Станиця\ Луганськ\,\ Луганськ",
"380321", "Львів\/Львівська",
"3805690", "Царичанка\,\ Дніпро",
"3805655", "Дніпропетро́вськ\/Дніпро",
"3804574", "Миронівка\,\ Київ",
"3804841", "Ізмаїл\,\ Одеса",
"3805664", "Нікополь\,\ Дніпро",
"3805545", "Верхній\ Рогачик\,\ Херсон",
"3806466", "Біловодськ\,\ Луганськ",
"3806275", "Докучаєвськ\,\ Донецьк",
"3803430", "Городенка\,\ Івано\-Франківська",
"3803850", "Стара\ Синява\,\ Хмельницький",
"3803254", "Камʼянка\-Бузька\,\ Львівська",
"3803476", "Заболотів\/Снятин\,\ Івано\-Франківська",
"3803265", "Золочів\,\ Львівська",
"3805766", "Коломак\,\ Харків",
"3803657", "Костопіль\,\ Рівне",
"3806244", "Волноваха\,\ Донецьк",
"3804655", "Сосниця\,\ Чернігів",
"3805360", "Кременчук\,\ Полтава",
"3804332", "Браїлів\/Жмеринка\,\ Вінниця",
"3804142", "Коростень\,\ Житомир",
"3803547", "Козлів\/Козова\,\ Тернопіль",
"38045", "Київ",
"3805352", "Шишаки\,\ Полтава",
"3804740", "Ватутіне\/Звенигородка\,\ Черкаси",
"3805635", "Юрʼївка\,\ Дніпро",
"3806440", "Луганськ",
"380642", "Луганськ\/Олександрівськ\,\ Луганськ",
"3804136", "Андрушівка\,\ Житомир",
"3804346", "Погребище\,\ Вінниця",
"3806246", "Володарське\,\ Донецьк",
"3805764", "Золочів\,\ Харків",
"3804848", "Сарата\,\ Одеса",
"3803474", "Рожнятів\,\ Івано\-Франківська",
"3803363", "Турійськ\,\ Волинська",
"3805755", "Кегичівка\,\ Харків",
"3805447", "Конотоп\,\ Суми",
"3805154", "Очаків\,\ Миколаїв",
"3803256", "Новояворівськ\,\ Львівська",
"3804134", "Черняхів\,\ Житомир",
"3804344", "Шаргород\,\ Вінниця",
"3804735", "Корсунь\-Шевченківський\,\ Черкаси",
"380562", "Дніпропетровськ\,\ Дніпро",
"3803737", "Заставна\,\ Чернівці",
"3806232", "Макіївка\,\ Донецьк",
"3805453", "Кролевець\,\ Суми",
"3803541", "Борщів\,\ Тернопіль",
"3806435", "Краснодон\,\ Луганськ",
"3803651", "Корець\,\ Рівне",
"3803236", "Самбір\,\ Львівська",
"3806260", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805134", "Вознесенськ\,\ Миколаїв",
"3805344", "Нові\ Санжари\,\ Полтава",
"38034", "Івано\-Франківська",
"3803377", "Любомль\,\ Волинська",
"3806178", "Токмак\,\ Запорізька",
"3805448", "Ромни\,\ Суми",
"3803845", "Волочиськ\,\ Хмельницький",
"3804847", "Тарутине\,\ Одеса",
"3804595", "Бориспіль\,\ Київ",
"3806464", "Марківка\,\ Луганськ",
"3803242", "Львів\/Львівська",
"38038", "Хмельницький",
"3805666", "Нікополь\,\ Дніпро",
"3803738", "Путила\,\ Чернівці",
"3804853", "Лиманське\/Роздільна\,\ Одеса",
"3806455", "Первомайськ\,\ Луганськ",
"3804576", "Баришівка\/Березань\,\ Київ",
"3804562", "Рокитне\,\ Київ",
"3806252", "Єнакієве\,\ Донецьк",
"3805530", "Каланчак\,\ Херсон",
"3805357", "Оржиця\,\ Полтава",
"38031", "Закарпатська",
"3804854", "Іванівка\,\ Одеса",
"3805639", "Васильківка\,\ Дніпро",
"3806463", "Новопсков\,\ Луганськ",
"3804865", "Саврань\,\ Одеса",
"3804358", "Липовець\,\ Вінниця",
"3804659", "Семенівка\,\ Чернігів",
"3804337", "Могилів\-Подільський\,\ Вінниця",
"380620", "Донецьк",
"3804147", "Любар\,\ Житомир",
"3803542", "Підгайці\,\ Тернопіль",
"3803145", "Перечин\,\ Закарпатська",
"3803269", "Турка\,\ Львівська",
"3803652", "Здолбунів\,\ Рівне",
"380329", "Львів\/Львівська",
"3805343", "Кобеляки\,\ Полтава",
"3805133", "Криве\ Озеро\,\ Миколаїв",
"3806279", "Тельманове\,\ Донецьк",
"3805358", "Пирятин\,\ Полтава",
"3805549", "Нова\ Каховка\,\ Херсон",
"3805659", "Дніпропетро́вськ\/Дніпро",
"3805454", "Буринь\,\ Суми",
"3804133", "Малин\,\ Житомир",
"3804343", "Ладижин\/Тростянець\,\ Вінниця",
"3805153", "Березанка\,\ Миколаїв",
"3803241", "Миколаїв\,\ Львівська",
"3803632", "Зарічне\,\ Рівне",
"3805763", "Дергачі\,\ Харків",
"3803355", "Шацьк\,\ Волинська",
"3804561", "Богуслав\,\ Київ",
"3806251", "Донецьк",
"3805250", "Вільшанка\,\ Кіровоград",
"3804639", "Срібне\,\ Чернігів",
"380647", "Луганськ",
"3804338", "Хмільник\,\ Вінниця",
"3804148", "Овруч\,\ Житомир",
"3803379", "Горохів\,\ Волинська",
"3806460", "Луганськ",
"3803436", "Тисмениця\,\ Івано\-Франківська",
"3803842", "Нетішин\/Славута\,\ Хмельницький",
"3804849", "Білгород\-Дністровський\/Затока\/Сергіївка\,\ Одеса",
"3805534", "Генічеськ\,\ Херсон",
"3806264", "Краматорськ\,\ Донецьк",
"3805340", "Чорнухи\,\ Полтава",
"3806131", "Якимівка\,\ Запорізька",
"3806255", "Шахтарськ\,\ Донецьк",
"3804162", "Брусилів\,\ Житомир",
"3804565", "Фастів\,\ Київ",
"3804644", "Мена\,\ Чернігів",
"3805233", "Знамʼянка\,\ Кіровоград",
"3806452", "Сєвєродонецьк\,\ Луганськ",
"38069", "Севастополь",
"3803245", "Стрий\,\ Львівська",
"3805746", "Чугуїв\,\ Харків",
"3804130", "Коростишів\,\ Житомир",
"3804340", "Крижопіль\,\ Вінниця",
"3805752", "Великий\ Бурлук\,\ Харків",
"3804861", "Красні\ Окни\,\ Одеса",
"3806446", "Кіровськ\,\ Луганськ",
"3805162", "Снігурівка\,\ Миколаїв",
"3805449", "Шостка\,\ Суми",
"3804746", "Монастирище\,\ Черкаси",
"3805366", "Кременчук\,\ Полтава",
"3806432", "Красний\ Луч\,\ Луганськ",
"3803141", "Берегове\,\ Закарпатська",
"3805253", "Добровеличківка\,\ Кіровоград",
"3803739", "Сокиряни\,\ Чернівці",
"3803856", "Деражня\,\ Хмельницький",
"3804732", "Камʼянка\,\ Черкаси",
"3804591", "Іванків\,\ Київ",
"3805657", "Широке\,\ Дніпро",
"3803841", "Білогірʼя\,\ Хмельницький",
"3806277", "Добропілля\,\ Донецьк",
"3805547", "Білозерка\,\ Херсон",
"3805638", "Покровське\,\ Дніпро",
"3805254", "Гайворон\,\ Кіровоград",
"3806132", "Михайлівка\,\ Запорізька",
"3804161", "Лугини\,\ Житомир",
"3804658", "Новгород\-Сіверський\,\ Чернігів",
"3803268", "Львів\/Львівська",
"3806451", "Лисичанськ\,\ Луганськ",
"3803352", "Ковель\,\ Волинська",
"3803635", "Рокитне\,\ Рівне",
"3804637", "Прилуки\,\ Чернігів",
"3805548", "Новотроїцьке\,\ Херсон",
"3805359", "Гребінка\,\ Полтава",
"3805751", "Шевченкове\,\ Харків",
"3806278", "Марʼїнка\,\ Донецьк",
"3804862", "Котовськ\,\ Одеса",
"3805234", "Долинська\,\ Кіровоград",
"3805658", "Верхньодніпровськ\,\ Дніпро",
"3803136", "Воловець\,\ Закарпатська",
"3803346", "Стара\ Вижівка\,\ Волинська",
"3805161", "Первомайськ\,\ Миколаїв",
"38035", "Тернопіль",
"3804643", "Куликівка\,\ Чернігів",
"3803740", "Герца\,\ Чернівці",
"3806263", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805637", "Павлоград\,\ Дніпро",
"3804657", "Корюківка\,\ Чернігів",
"3805533", "Нововоронцовка\,\ Херсон",
"3803655", "Сарни\,\ Рівне",
"3806431", "Антрацит\,\ Луганськ",
"3803142", "Хуст\,\ Закарпатська",
"380640", "Луганськ",
"3804850", "Теплодар\,\ Одеса",
"3804149", "Ємільчине\,\ Житомир",
"3803267", "Львів\/Львівська",
"3804731", "Тальне\,\ Черкаси",
"3804860", "Фрунзівка\,\ Одеса",
"3804749", "Лисянка\,\ Черкаси",
"3804341", "Бар\,\ Вінниця",
"3804131", "Червоноармійськ\,\ Житомир",
"3805446", "Охтирка\,\ Суми",
"3806162", "Розівка\,\ Запорізька",
"3803257", "Сокаль\,\ Львівська",
"3806449", "Луганськ",
"3803544", "Бучач\,\ Тернопіль",
"3803654", "Острог\,\ Рівне",
"3806247", "Дзержинськ\,\ Донецьк",
"3803238", "Старий\ Самбір\,\ Львівська",
"380312", "Ужгород\/Чоп\,\ Закарпатська",
"3803859", "Чемерівці\,\ Хмельницький",
"3806253", "Старобешеве\,\ Донецьк",
"3804563", "Біла\ Церква\/Узин\,\ Київ",
"3804578", "Макарів\,\ Київ",
"3805235", "Олександрія\,\ Кіровоград",
"3803471", "Богородчани\,\ Івано\-Франківська",
"3805369", "Кременчук\,\ Полтава",
"3805761", "Зачепилівка\,\ Харків",
"3803736", "Кіцмань\,\ Чернівці",
"3804852", "Біляївка\,\ Одеса",
"3805668", "Томаківка\,\ Дніпро",
"3803243", "Львів\/Львівська",
"3805151", "Новий\ Буг\,\ Миколаїв",
"3803258", "Львів\/Львівська",
"3803634", "Володимирець\,\ Рівне",
"3806461", "Старобільськ\,\ Луганськ",
"3803362", "Любешів\,\ Волинська",
"3804846", "Болград\,\ Одеса",
"3803237", "Львів\/Львівська",
"3806248", "Горлівка\,\ Донецьк",
"3803376", "Маневичі\,\ Волинська",
"3805131", "Братське\,\ Миколаїв",
"3805341", "Семенівка\,\ Полтава",
"3805749", "Балаклія\,\ Харків",
"3805255", "Новоархангельськ\,\ Кіровоград",
"3805452", "Липова\ Долина\,\ Суми",
"3805667", "Орджонікідзе\,\ Дніпро",
"3804577", "Бородянка\/Клавдієво\-Тарасове\/Немішаєве\,\ Київ",
"3805750", "Дворічна\,\ Харків",
"3804342", "Козятин\,\ Вінниця",
"3804132", "Радомишль\,\ Житомир",
"3803741", "Новодністровськ\,\ Чернівці",
"3803558", "Шумське\,\ Тернопіль",
"3805356", "Лохвиця\,\ Полтава",
"3804146", "Дзержинськ\,\ Житомир",
"3804336", "Ямпіль\,\ Вінниця",
"3806430", "Луганськ",
"3803472", "Калуш\,\ Івано\-Франківська",
"3805762", "Сахновщина\,\ Харків",
"380621", "Донецьк",
"3804851", "Овідіополь\,\ Одеса",
"3803633", "Радивилів\,\ Рівне",
"3804730", "Чигирин\,\ Черкаси",
"3805152", "Доманівка\,\ Миколаїв",
"3803244", "Дрогобич\,\ Львівська",
"3803840", "Шепетівка\,\ Хмельницький",
"3806462", "Білокуракине\,\ Луганськ",
"380648", "Луганськ",
"3806254", "Торез\,\ Донецьк",
"3804564", "Ставище\,\ Київ",
"3804645", "Городня\,\ Чернігів",
"3803557", "Гусятин\,\ Тернопіль",
"3806265", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805132", "Арбузинка\,\ Миколаїв",
"3805342", "Козельщина\,\ Полтава",
"3803653", "Березне\,\ Рівне",
"3805535", "Високопілля\,\ Херсон",
"38046", "Чернігів",
"3803543", "Підволочиськ\,\ Тернопіль",
"3806450", "Луганськ",
"3805451", "Середина\-Буда\,\ Суми",
"3804356", "Муровані\ Курилівці\,\ Вінниця",
"3804748", "Маньківка\,\ Черкаси",
"3806261", "Красний\ Лиман\,\ Донецьк",
"3804641", "Ріпки\,\ Чернігів",
"3803437", "Болехів\,\ Івано\-Франківська",
"3805163", "Веселинове\,\ Миколаїв",
"3806448", "Луганськ",
"3803239", "Жидачів\,\ Львівська",
"3805753", "Валки\,\ Харків",
"3803365", "Ківерці\/Цумань\,\ Волинська",
"3804733", "Сміла\,\ Черкаси",
"3803858", "Дунаївці\,\ Хмельницький",
"3805455", "Недригайлів\,\ Суми",
"3805747", "Зміїв\,\ Харків",
"3805252", "Голованівськ\,\ Кіровоград",
"3805368", "Кременчук\,\ Полтава",
"380569", "Дніпродзержинськ\/Новомосковськ\,\ Дніпро",
"3806433", "Ровеньки\,\ Луганськ",
"3804579", "Славутич\,\ Київ",
"3805531", "Іванівка\,\ Херсон",
"3805669", "Солоне\,\ Дніпро",
"3803259", "Яворів\,\ Львівська",
"3804747", "Жашків\,\ Черкаси",
"3803144", "Іршава\,\ Закарпатська",
"3806249", "Дебальцеве\,\ Донецьк",
"3806165", "Пологи\,\ Запорізька",
"3803843", "Полонне\,\ Хмельницький",
"3806447", "Луганськ",
"3803438", "Бурштин\,\ Івано\-Франківська",
"3805748", "Первомайський\,\ Харків",
"3804864", "Любашівка\,\ Одеса",
"3806453", "Рубіжне\,\ Луганськ",
"3804855", "Комінтернівське\,\ Одеса",
"3803857", "Летичів\/Меджибіж\,\ Хмельницький",
"38037", "Чернівці",
"3803540", "Зборів\,\ Тернопіль",
"3805367", "Кременчук\,\ Полтава",
"3803650", "Гоща\,\ Рівне",
"38053", "Полтава",
"3806262", "Святогірськ\/Словʼянськ\,\ Донецьк",
"3804642", "Носівка\,\ Чернігів",
"3806147", "Куйбишеве\,\ Запорізька",
"380628", "Донецьк",
"3806454", "Кремінна\,\ Луганськ",
"3805656", "Апостолове\,\ Дніпро",
"3804863", "Ананьїв\,\ Одеса",
"3806276", "Артемівськ\,\ Донецьк",
"3806465", "Мілове\,\ Луганськ",
"3805546", "Берислав\,\ Херсон",
"3803240", "Львів\/Львівська",
"3803844", "Теофіполь\,\ Хмельницький",
"3804594", "Бровари\/Калита\,\ Київ",
"3806153", "Бердянськ\,\ Запорізька",
"3804636", "Варва\,\ Чернігів",
"380322", "Брюховичі\/Львів\,\ Львівська",
"3806250", "Кіровське\,\ Донецьк",
"3805251", "Новоукраїнка\,\ Кіровоград",
"3804560", "Тетіїв\,\ Київ",
"3803143", "Виноградів\,\ Закарпатська",
"3805532", "Велика\ Олександрівка\,\ Херсон",
"3805135", "Врадіївка\,\ Миколаїв",
"3805345", "Велика\ Багачка\,\ Полтава",
"3805636", "Тернівка\,\ Дніпро",
"3806434", "Свердловськ\,\ Луганськ",
"3804135", "Олевськ\,\ Житомир",
"3804345", "Іллінці\,\ Вінниця",
"3804734", "Городище\,\ Черкаси",
"3805754", "Близнюки\,\ Харків",
"38043", "Вінниця",
"3805765", "Печеніги\,\ Харків",
"3805164", "Казанка\,\ Миколаїв",
"3803475", "Делятин\/Надвірна\,\ Івано\-Франківська",
"3803266", "Броди\,\ Львівська",
"3804656", "Короп\,\ Чернігів",
"380641", "Луганськ",
"3806133", "Приазовське\,\ Запорізька",};
$areanames{en} = {"3806462", "Belokurakine\,\ Luhansk",
"3803840", "Shepetovka\,\ Khmelnytskyi",
"3803244", "Drogobych\,\ Lviv",
"3806265", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803557", "Gusyatin\,\ Ternopil",
"3804645", "Gorodnya\,\ Chernihiv",
"3804564", "Stavyshche\,\ Kyiv",
"380648", "Luhansk",
"3806254", "Torez\,\ Donetsk",
"3803543", "Podvolochisk\,\ Ternopil",
"38046", "Chernihiv",
"3803653", "Berezne\,\ Rivne",
"3805535", "Vysokoplylya\,\ Kherson",
"3805342", "Kozelshchina\,\ Poltava",
"3805132", "Arbuzinka\,\ Mykolayiv",
"3804356", "Murovani\ Kurylivtsi\,\ Vinnytsia",
"3805451", "Mid\-Buda\,\ Sumy",
"3806450", "Luhansk",
"3804132", "Radomyshl\,\ Zhytomyr",
"3804342", "Kozatin\,\ Vinnytsia",
"3805750", "Two\ years\ old\,\ Kharkiv",
"3805356", "Lokhvytsia\,\ Poltava",
"3803558", "Shumsk\,\ Ternopil",
"3803741", "Novodnistrovsk\,\ Chernivtsi",
"3806430", "Luhansk",
"3804336", "Yampil\,\ Vinnytsia",
"3804146", "Dzerzhinsk\,\ Zhytomyr",
"3805152", "Domanivka\,\ Mykolayiv",
"3804730", "Chigirin\,\ Cherkasy",
"3803633", "Radivilov\,\ Rivne",
"3804851", "Ovidiopol\,\ Odesa",
"3805762", "Sakhnovshchyna\,\ Kharkiv",
"380621", "Donetsk",
"3803472", "Kalush\,\ Ivano\-Frankivsk",
"3804846", "Bolgrad\,\ Odesa",
"3803362", "Lubeshiv\,\ Volyn",
"3806461", "Starobilsk\,\ Luhansk",
"3803634", "Volodymyrets\,\ Rivne",
"3803258", "Lviv",
"3803376", "Manevichi\,\ Volyn",
"3806248", "Gorlovka\,\ Donetsk",
"3803237", "Lviv",
"3805255", "Novorangels\'k\,\ Kirovohrad",
"3805749", "Balaklia\,\ Kharkiv",
"3805131", "Bratsk\,\ Mykolayiv",
"3805341", "Semenivka\,\ Poltava",
"3804577", "Borodyanka\/Klavdievo\-Tarasovo\/Nemishaive\,\ Kyiv",
"3805667", "Ordzhonikidze\,\ Dnipro",
"3805452", "Lipova\ Dolina\,\ Sumy",
"3803257", "Sokal\,\ Lviv",
"3806162", "Rozvku\,\ Zaporizhzhia",
"3805446", "Tomatoes\,\ Sumy",
"3804131", "Chervonoarmiysk\,\ Zhytomyr",
"3804341", "Bar\,\ Vinnytsia",
"3804860", "Frunzivka\,\ Odesa",
"3804749", "Lysyanka\,\ Cherkasy",
"3803238", "Old\ Sambir\,\ Lviv",
"3803654", "Ostrog\,\ Rivne",
"3806247", "Dzerzhinsk\,\ Donetsk",
"3803544", "Buchach\,\ Ternopil",
"3806449", "Luhansk",
"3804563", "Belaya\ Tserkov\/Uzin\,\ Kyiv",
"3806253", "Starobesheve\,\ Donetsk",
"3803859", "Chemerivtsi\,\ Khmelnytskyi",
"380312", "Uzhgorod\/Chop\,\ Zakarpattia",
"3805151", "Novy\ Buh\,\ Mykolayiv",
"3805668", "Tomakivka\,\ Dnipro",
"3803243", "Lviv",
"3804852", "Belyaevka\,\ Odesa",
"3803736", "Kitsman\,\ Chernivtsi",
"3805761", "Zachepilivka\,\ Kharkiv",
"3805369", "Kremenchug\,\ Poltava",
"3804578", "Makarov\,\ Kyiv",
"3803471", "Bogorodchany\,\ Ivano\-Frankivsk",
"3805235", "Alexandria\,\ Kirovohrad",
"3806434", "Sverdlovsk\,\ Luhansk",
"3805636", "Ternivka\,\ Dnipro",
"3804734", "Chernigov\ region",
"3804345", "Illintsi\,\ Vinnytsia",
"3804135", "Olevsk\,\ Zhytomyr",
"3803266", "Brody\,\ Lviv",
"3803475", "Delyatin\/Nadvirna\,\ Ivano\-Frankivsk",
"3805164", "Kazanka\,\ Mykolayiv",
"3805765", "Pechenegi\,\ Kharkiv",
"38043", "Vinnytsia",
"3805754", "Gemini\,\ Kharkiv",
"3806133", "Priazovskoe\,\ Zaporizhzhia",
"380641", "Luhansk",
"3804656", "Carp\,\ Chernihiv",
"3804642", "Sedimentary\,\ Chernihiv",
"3806262", "Svyatogorsk\/Slavyansk\,\ Donetsk",
"38053", "Poltava",
"3805546", "Berislav\,\ Kherson",
"3806465", "Milow\,\ Luhansk",
"3806276", "Artemivsk\,\ Donetsk",
"3804863", "Ananev\,\ Odesa",
"3805656", "Apostolove\,\ Dnipro",
"3806454", "Kremenna\,\ Luhansk",
"380628", "Donetsk",
"3806147", "Kuybyshev\,\ Zaporizhzhia",
"380322", "Bryukhovichi\/Lviv\,\ Lviv",
"3804636", "Varva\,\ Chernihiv",
"3806153", "Berdyansk\,\ Zaporizhzhia",
"3804594", "Brovary\/Kalita\,\ Kyiv",
"3803844", "Theophyll\,\ Khmelnytskyi",
"3803240", "Lviv",
"3805345", "Big\ Bagachka\,\ Poltava",
"3805135", "Vradievka\,\ Mykolayiv",
"3805532", "Great\ Aleksandrovka\,\ Kherson",
"3803143", "Vinogradov\,\ Zakarpattia",
"3804560", "Tetiev\,\ Kyiv",
"3806250", "Kirovske\,\ Donetsk",
"3805251", "Novoukrainka\,\ Kirovohrad",
"3803144", "Irshava\,\ Zakarpattia",
"3804747", "Zhashkiv\,\ Cherkasy",
"3803259", "Yavoriv\,\ Lviv",
"3803438", "Burshtyn\,\ Ivano\-Frankivsk",
"3806447", "Luhansk",
"3803843", "Polonne\,\ Khmelnytskyi",
"3806165", "Childbirth\,\ Zaporizhzhia",
"3806249", "Debaltsevo\,\ Donetsk",
"3803857", "Letychiv\/Medzhybizh\,\ Khmelnytskyi",
"3804855", "Kominternovskoe\,\ Odesa",
"3806453", "Rubizhne\,\ Luhansk",
"3804864", "Lyubashevka\,\ Odesa",
"3805748", "Pervomaysk\,\ Kharkiv",
"3803650", "Goshcha\,\ Rivne",
"3805367", "Kremenchug\,\ Poltava",
"3803540", "Meeting\,\ Ternopil",
"38037", "Chernivtsi",
"3804641", "Rivers\,\ Chernihiv",
"3806261", "Krasny\ Liman\,\ Donetsk",
"3804748", "Mankivka\,\ Cherkasy",
"3805753", "Valki\,\ Kharkiv",
"3803365", "Kivertsi\/Tsuman\,\ Volyn",
"3803239", "Zhidachiv\,\ Lviv",
"3806448", "Luhansk",
"3803437", "Bolechov\,\ Ivano\-Frankivsk",
"3805163", "Veselinove\,\ Mykolayiv",
"3805455", "Nedrigailov\,\ Sumy",
"3805747", "Snakes\,\ Kharkiv",
"3803858", "Dunaevtsi\,\ Khmelnytskyi",
"3804733", "Smila\,\ Cherkasy",
"3805669", "Salt\,\ Dnipro",
"3805531", "Ivanivka\,\ Kherson",
"3806433", "Rovenky\,\ Luhansk",
"3804579", "Slavutych\,\ Kyiv",
"3805368", "Kremenchug\,\ Poltava",
"380569", "Dneprodzerzhinsk\/Novomoskovsk\,\ Dnipro",
"3805252", "Golovanovsk\,\ Kirovohrad",
"3805659", "Dnipropetrovsk\/Dnipro",
"3805549", "New\ Kakhovka\,\ Kherson",
"3805358", "Pyriatyn\,\ Poltava",
"3806279", "Telmanov\,\ Donetsk",
"3804133", "Malin\,\ Zhytomyr",
"3804343", "Ladyzhin\/Trostyanets\,\ Vinnytsia",
"3805454", "Burin\,\ Sumy",
"3805763", "Carriers\,\ Kharkiv",
"3803355", "Shatsk\,\ Volyn",
"3803632", "Zarechnaya\,\ Rivne",
"3803241", "Nikolaev\,\ Lviv",
"3805153", "Berezanka\,\ Mykolayiv",
"3804148", "Ovruch\,\ Zhytomyr",
"3804338", "Khmilnyk\,\ Vinnytsia",
"380647", "Luhansk",
"3804639", "Silver\,\ Chernihiv",
"3806251", "Donetsk",
"3805250", "Vilshanka\,\ Kirovohrad",
"3804561", "Boguslav\,\ Kyiv",
"3805357", "Orzhitsa\,\ Poltava",
"38031", "Zakarpattia",
"3804865", "Savran\,\ Odesa",
"3806463", "Novopskov\,\ Luhansk",
"3805639", "Vasylkivka\,\ Dnipro",
"3804854", "Ivanivka\,\ Odesa",
"3804659", "Semenivka\,\ Chernihiv",
"3804358", "Lipovets\,\ Vinnytsia",
"380329", "Lviv",
"3805343", "Kobelyaky\,\ Poltava",
"3805133", "Creve\ Lake\,\ Mykolayiv",
"3803652", "Zdolbunov\,\ Rivne",
"3803269", "Turka\,\ Lviv",
"3803145", "Perechyn\,\ Zakarpattia",
"3803542", "Pidhaytsi\,\ Ternopil",
"380620", "Donetsk",
"3804337", "Mogilev\-Podolsky\,\ Vinnytsia",
"3804147", "Lyubar\,\ Zhytomyr",
"3806178", "Tokmak\,\ Zaporizhzhia",
"3803377", "Lyuboml\,\ Volyn",
"38034", "Ivano\-Frankivsk",
"3805344", "New\ Sanzhary\,\ Poltava",
"3805134", "Voznesensk\,\ Mykolayiv",
"3806260", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803236", "Sambir\,\ Lviv",
"3804847", "Tarutino\,\ Odesa",
"3804595", "Borispol\,\ Kyiv",
"3803845", "Volochysk\,\ Khmelnytskyi",
"3805448", "Romny\,\ Sumy",
"3804576", "Baryshevka\/Berezan\,\ Kyiv",
"3806455", "Pervomaisk\,\ Luhansk",
"3803738", "Putila\,\ Chernivtsi",
"3804853", "Limanske\/Rozdilna\,\ Odesa",
"3805666", "Nikopol\,\ Dnipro",
"38038", "Khmelnytskyi",
"3803242", "Lviv",
"3806464", "Markovka\,\ Luhansk",
"3805530", "Kalanchak\,\ Kherson",
"3806252", "Yenakievo\,\ Donetsk",
"3804562", "Rokitne\,\ Kyiv",
"3806246", "Volodarske\,\ Donetsk",
"3803256", "Novoyavorivsk\,\ Lviv",
"3805154", "Ochakiv\,\ Mykolayiv",
"3805755", "Kegichivka\,\ Kharkiv",
"3803363", "Turiysk\,\ Volyn",
"3805447", "Konotop\,\ Sumy",
"3803474", "Rozhnyatov\,\ Ivano\-Frankivsk",
"3804848", "Saratov\,\ Odesa",
"3805764", "Zolochiv\,\ Kharkiv",
"3805453", "Krolevets\,\ Sumy",
"3806232", "Makeevka\,\ Donetsk",
"3803737", "Zastavna\,\ Chernivtsi",
"380562", "Dnipropetrovsk\/Dnipro",
"3804735", "Korsun\-Shevchenkivsky\,\ Cherkasy",
"3804134", "Chernyakhov\,\ Zhytomyr",
"3804344", "Shargorod\,\ Vinnytsia",
"3803651", "Korets\,\ Rivne",
"3806435", "Krasnodon\,\ Luhansk",
"3803541", "Borschiv\,\ Ternopil",
"3803136", "Volovets\,\ Zakarpattia",
"3803346", "Old\ Vyzhivka\,\ Volyn",
"3805161", "Pervomaysk\,\ Mykolayiv",
"3805658", "Verhnedneprovsk\,\ Dnipro",
"3805234", "Dolinska\,\ Kirovohrad",
"3806278", "Marinka\,\ Donetsk",
"3804862", "Kotovsk\,\ Odesa",
"3805751", "Shevchenkovo\,\ Kharkiv",
"3805359", "Hrebinka\,\ Poltava",
"3805548", "Novotroitsk\,\ Kherson",
"3805637", "Pavlograd\,\ Dnipro",
"3806263", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803740", "Hertz\,\ Chernivtsi",
"3804643", "Kulikivka\,\ Chernihiv",
"38035", "Ternopil",
"3803142", "Hust\,\ Zakarpattia",
"3806431", "Anthracite\,\ Luhansk",
"3803655", "Sarny\,\ Rivne",
"3805533", "Novovorontsovka\,\ Kherson",
"3804657", "Koryukivka\,\ Chernihiv",
"3804731", "Talne\,\ Cherkasy",
"3803267", "Lviv",
"3804149", "Emilchine\,\ Zhytomyr",
"3804850", "Teplodar\,\ Odesa",
"380640", "Luhansk",
"3805547", "Belozerka\,\ Kherson",
"3806277", "Dobropolia\,\ Donetsk",
"3805657", "Broad\,\ Dnipro",
"3803841", "Belogorsk\,\ Khmelnytskyi",
"3804591", "Ivankiv\,\ Kyiv",
"3805254", "Haivoron\,\ Kirovohrad",
"3805638", "Pokrovskoe\,\ Dnipro",
"3804658", "Novgorod\-Seversky\,\ Chernihiv",
"3804161", "Luginy\,\ Zhytomyr",
"3806132", "Mikhailivka\,\ Zaporizhzhia",
"3804637", "Priluki\,\ Chernihiv",
"3803635", "Rokitne\,\ Rivne",
"3806451", "Lisichansk\,\ Luhansk",
"3803352", "Kovel\,\ Volyn",
"3803268", "Lviv",
"3806446", "Kirovsk\,\ Luhansk",
"3805162", "Snigurovka\,\ Mykolayiv",
"3804861", "Red\ Windows\,\ Odesa",
"3805752", "Great\ Burluk\,\ Kharkiv",
"3804130", "Korostyshiv\,\ Zhytomyr",
"3804340", "Kryzhopil\,\ Vinnytsia",
"3804746", "Monastyrysche\,\ Cherkasy",
"3805449", "Shostka\,\ Sumy",
"3803739", "Sokyryany\,\ Chernivtsi",
"3805253", "Dobrovelichkovka\,\ Kirovohrad",
"3803141", "Berehove\,\ Zakarpattia",
"3806432", "Krasnyi\ Luch\,\ Luhansk",
"3805366", "Kremenchug\,\ Poltava",
"3804732", "Kamyanets\,\ Cherkasy",
"3803856", "Derazhnya\,\ Khmelnytskyi",
"3803842", "Netishyn\/Slavuta\,\ Khmelnytskyi",
"3803436", "Tysmenytsia\,\ Ivano\-Frankivsk",
"3806460", "Luhansk",
"3803379", "Gorokhov\,\ Volyn",
"3805534", "Genichesk\,\ Kherson",
"3804849", "Belgorod\-Dniester\/Zatoka\/Sergievka\,\ Odesa",
"3804644", "Mena\,\ Chernihiv",
"3804565", "Fastov\,\ Kyiv",
"3806255", "Shakhtarsk\,\ Donetsk",
"3804162", "Brusilov\,\ Zhytomyr",
"3805340", "Chornukhi\,\ Poltava",
"3806131", "Yakimivka\,\ Zaporizhzhia",
"3806264", "Kramatorsk\,\ Donetsk",
"3805746", "Chuguev\,\ Kharkiv",
"3803245", "Stryi\,\ Lviv",
"38069", "Sevastopol\ city",
"3806452", "Severodonetsk\,\ Luhansk",
"3805233", "Znamenka\,\ Kirovohrad",
"3806137", "Primorsk\,\ Zaporizhzhia",
"3805536", "Kakhovka\,\ Kherson",
"38051", "Mykolayiv",
"3803357", "Kamin\-Kashirsky\,\ Volyn",
"3803434", "Vorokhta\/Yaremche\,\ Ivano\-Frankivsk",
"3804355", "Hnivan\/Tyvriv\,\ Vinnytsia",
"3805660", "Nikopol\,\ Dnipro",
"3804632", "Bobrovitsa\,\ Chernihiv",
"3804570", "Zgurovka\,\ Kyiv",
"3805652", "Yellow\ Waters\,\ Dnipro",
"3803133", "Svalyava\,\ Zakarpattia",
"3805542", "Tsyurupinsk\,\ Kherson",
"3805744", "Krasnograd\,\ Kharkiv",
"3804868", "Illichivsk\,\ Odesa",
"3806272", "Kostiantynivka\,\ Donetsk",
"3803230", "Pustomyty\,\ Lviv",
"3806266", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3804646", "Desna\/Kozelets\/Oster\,\ Chernihiv",
"3804744", "Uman\,\ Cherkasy",
"3804335", "Tulchin\,\ Vinnytsia",
"3804145", "Volodarsk\-Volynsky\,\ Zhytomyr",
"380328", "Lviv",
"3806138", "Kamyanets\'\-Dniprovs\'ka\,\ Zaporizhzhia",
"3803659", "Mlyniv\,\ Rivne",
"3803262", "Lviv",
"3803549", "Lanovtsi\,\ Ternopil",
"3806444", "Stakhanov\,\ Luhansk",
"3804867", "Kodima\,\ Odesa",
"3806143", "Vilnyansk\,\ Zaporizhzhia",
"3803854", "Starokostiantyniv\,\ Khmelnytskyi",
"3803250", "Lviv",
"3805355", "Mirgorod\,\ Poltava",
"380622", "Donetsk",
"38041", "Zhytomyr",
"3805364", "Mashivka\,\ Poltava",
"3805632", "Pavlograd\,\ Dnipro",
"3806240", "Gorlovka\,\ Donetsk",
"3805241", "Novgorodka\,\ Kirovohrad",
"3806438", "Luhansk",
"3805363", "Reshetilivka\,\ Poltava",
"3805256", "Novomirgorod\,\ Kirovohrad",
"3803249", "Chervonograd\,\ Lviv",
"3806457", "Luhansk",
"3806144", "Novomikolaevka\,\ Zaporizhzhia",
"3804738", "Drabiv\,\ Cherkasy",
"3803853", "Yarmolintsy\,\ Khmelnytskyi",
"3804631", "Nizhyn\,\ Chernihiv",
"3806259", "Amvrosievka\,\ Donetsk",
"38048", "Odesa",
"3804569", "Volodarka\,\ Kyiv",
"3803847", "New\ Ushitsa\,\ Khmelnytskyi",
"3805651", "Dnipropetrovsk\/Dnipro",
"3806443", "Bryanka\,\ Luhansk",
"3805168", "Bereznegovate\,\ Mykolayiv",
"3804597", "Bucha\/Vorzel\/Gostomel\/Irpen\/Kotsyubinskoe\,\ Kyiv",
"3804845", "Artsis\,\ Odesa",
"3805758", "Bogodukhiv\,\ Kharkiv",
"3806271", "Artemivsk\,\ Donetsk",
"38044", "Kyiv\ city",
"3803550", "Zbarazh\,\ Ternopil",
"3806239", "Krasnoarmeysk\,\ Donetsk",
"3806437", "Luhansk",
"3805743", "Izyum\,\ Kharkiv",
"3805236", "Svetlovodsk\,\ Kirovohrad",
"3804737", "Zolotonosha\,\ Cherkasy",
"3803261", "Novy\ Rozdol\,\ Lviv",
"3803735", "Storozhynets\,\ Chernivtsi",
"38054", "Sumy",
"3803344", "Novovolynsk\,\ Volyn",
"3806458", "Luhansk",
"3803134", "Solotvyno\/Tyachiv\,\ Zakarpattia",
"3805445", "Lebedin\,\ Sumy",
"3805757", "Barvinkov\,\ Kharkiv",
"380560", "Dnipropetrovsk\/Dnipro",
"3805167", "New\ Odesa\,\ Mykolayiv",
"3804598", "Boyarka\/Vishnevoe\,\ Kyiv",
"3803433", "Kolomyia\,\ Ivano\-Frankivsk",
"3805631", "Petropavlovka\,\ Dnipro",
"3805693", "Novomoskovsk\,\ Dnipro",
"3805242", "Aleksandrovka\,\ Kirovohrad",
"3806175", "Vasilivka\/Dneprorudne\,\ Zaporizhzhia",
"3805766", "Kolomak\,\ Kharkiv",
"3803476", "Zabolotov\/Sniatyn\,\ Ivano\-Frankivsk",
"3803265", "Zolochiv\,\ Lviv",
"3803254", "Kamyanka\-Buzka\,\ Lviv",
"3803850", "Old\ Sinyava\,\ Khmelnytskyi",
"3803547", "Kozlov\/Kozova\,\ Ternopil",
"3804142", "Korosten\,\ Zhytomyr",
"3804332", "Brailiv\/Zhmerinka\,\ Vinnytsia",
"3805360", "Kremenchug\,\ Poltava",
"3804655", "Sosnitsa\,\ Chernihiv",
"3806244", "Volnovaha\,\ Donetsk",
"3803657", "Kostopil\,\ Rivne",
"3805635", "Yurievka\,\ Dnipro",
"3804740", "Vatutina\/Zvenigorodka\,\ Cherkasy",
"3805352", "Shishaki\,\ Poltava",
"38045", "Kyiv",
"380642", "Luhansk\/Oleksandrivsk\,\ Luhansk",
"3804346", "Pogrebishche\,\ Vinnytsia",
"3804136", "Andrushivka\,\ Zhytomyr",
"3806440", "Luhansk",
"3803637", "Demidivka\,\ Rivne",
"3806296", "Novoazovsk\,\ Donetsk",
"380572", "Merefa\/Kharkiv\,\ Kharkiv",
"3804635", "Baturin\/Bahmach\,\ Chernihiv",
"3804352", "Bershad\,\ Vinnytsia",
"38055", "Kherson",
"3806139", "Energodar\,\ Zaporizhzhia",
"3805740", "New\ Waterlog\,\ Kharkiv",
"3803658", "Dubrovitsa\,\ Rivne",
"3803234", "Mostyska\,\ Lviv",
"3805136", "Yuzhnoukrainsk\,\ Mykolayiv",
"3805346", "Karlovka\,\ Poltava",
"3803548", "Berezhany\,\ Ternopil",
"3805690", "Tsarichanka\,\ Dnipro",
"380321", "Lviv",
"3806472", "Stanitsa\ Luhansk\,\ Luhansk",
"3803430", "Gorodenka\,\ Ivano\-Frankivsk",
"3806466", "Belovodsk\,\ Luhansk",
"3806275", "Dokuchaevsk\,\ Donetsk",
"3805545", "Upper\ Rogachik\,\ Kherson",
"3805664", "Nikopol\,\ Dnipro",
"3804841", "Izmail\,\ Odesa",
"3804574", "Myronivka\,\ Kyiv",
"3805655", "Dnipropetrovsk\/Dnipro",
"3803732", "Kelmentsi\,\ Chernivtsi",
"3804856", "Berezivka\,\ Odesa",
"3806439", "Luhansk",
"3804573", "Kagarlyk\/Rzhyshchiv\,\ Kyiv",
"3803248", "Boryslav\/Skhidnytsya\,\ Lviv",
"3805663", "Sinelnikovo\,\ Dnipro",
"3806237", "Selidus\,\ Donetsk",
"3804739", "Chernobyl\,\ Cherkasy",
"3804141", "Novograd\-Volynsky\,\ Zhytomyr",
"3804331", "Bratslav\/Nemyriv\,\ Vinnytsia",
"3804568", "Skvyra\,\ Kyiv",
"38052", "Kirovohrad",
"3806258", "Donetsk",
"3803233", "Lviv",
"3805759", "Borova\,\ Kharkiv",
"3805351", "Dikanka\,\ Poltava",
"380332", "Lutsk\,\ Volyn",
"3805442", "Putivl\,\ Sumy",
"380623", "Krasnoarmeysk\/Makeyevka\,\ Donetsk",
"3803247", "Truskavets\,\ Lviv",
"3805456", "Yampil\,\ Sumy",
"3804351", "Chechelnyk\,\ Vinnytsia",
"3806257", "Ilovajsk\/Khartsyzsk\,\ Donetsk",
"3804567", "Pereyaslav\-Khmelnitsky\,\ Kyiv",
"3806459", "Luhansk",
"3803554", "Zalishchiki\,\ Ternopil",
"3806243", "Great\ Novosilka\,\ Donetsk",
"3803849", "Kamyanets\-Podilskyi\,\ Khmelnytskyi",
"380567", "Dnipropetrovsk\/Dnipro",
"3806471", "Swatov\,\ Luhansk",
"3803372", "Ivanychi\,\ Volyn",
"3803366", "Ratne\,\ Volyn",
"3806140", "Chernigovka\,\ Zaporizhzhia",
"3803253", "Lviv",
"380612", "Zaporozhye\,\ Zaporizhzhia",
"3803263", "Peremyshlyany\,\ Lviv",
"3805741", "Vovchansk\,\ Kharkiv",
"38065", "Crimea",
"3806136", "Веселе\,\ Zaporizhzhia",
"38036", "Rivne",
"3804653", "Borzna\,\ Chernihiv",
"3805537", "Lazurne\/Skadovsk\,\ Kherson",
"3806267", "Druzhkovka\,\ Donetsk",
"380649", "Luhansk",
"3805691", "Magdalenivka\,\ Dnipro",
"3805633", "Pershotravensk\,\ Dnipro",
"3803555", "Monastery\,\ Ternopil",
"3806469", "Luhansk",
"3803431", "Halych\,\ Ivano\-Frankivsk",
"3804840", "Reni\,\ Odesa",
"3803730", "Vyzhnytsia\,\ Chernivtsi",
"3804633", "Ichnya\,\ Chernihiv",
"3803851", "Gorodok\/Sataniv\,\ Khmelnytskyi",
"3806156", "Big\ Belozerka\,\ Zaporizhzhia",
"3805159", "Elanets\,\ Mykolayiv",
"3805538", "Askania\-Nova\/Chaplinka\,\ Kherson",
"3805361", "Lubny\,\ Poltava",
"3803146", "Mizhhirya\,\ Zakarpattia",
"3803479", "Tlumach\,\ Ivano\-Frankivsk",
"380327", "Lviv",
"3804349", "Pishchanka\,\ Vinnytsia",
"3804139", "Chudniv\,\ Zhytomyr",
"3804741", "Shpola\,\ Cherkasy",
"3806268", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3806273", "Vugledar\,\ Donetsk",
"3804866", "Balta\,\ Odesa",
"3805543", "Great\ Lipetyha\,\ Kherson",
"380564", "Krivoy\ Rog\,\ Dnipro",
"3803132", "Rakhiv\,\ Zakarpattia",
"3806441", "Perevalsk\,\ Luhansk",
"3803342", "Volodymyr\-Volynsky\,\ Volyn",
"3805653", "Volnogirsk\,\ Dnipro",
"3806456", "Trinity\ Church\,\ Luhansk",
"3804575", "Yagotin\,\ Kyiv",
"3805238", "Onufryevka\,\ Kirovohrad",
"3805654", "Krynychky\,\ Dnipro",
"3805742", "Kupyansk\,\ Kharkiv",
"3806274", "Artemivsk\/Siversk\,\ Donetsk",
"3805544", "Gornostaevka\,\ Kherson",
"3804350", "Vapnarka\,\ Vinnytsia",
"3805665", "Manganese\,\ Dnipro",
"3805257", "Bobrinets\,\ Kirovohrad",
"3805459", "Krasnopolye\,\ Sumy",
"3805692", "Dneprodzerzhinsk\,\ Dnipro",
"3803235", "Lviv",
"3803846", "Vinkivtsi\,\ Khmelnytskyi",
"3804596", "Vyshgorod\/Dimer\/Pirnove\,\ Kyiv",
"3806141", "Orychiv\,\ Zaporizhzhia",
"3803432", "Verkhovyna\,\ Ivano\-Frankivsk",
"3804634", "Talalayevka\,\ Chernihiv",
"3803852", "Iziaslav\,\ Khmelnytskyi",
"3805237", "Petrov\,\ Kirovohrad",
"3804736", "Kaniv\,\ Cherkasy",
"3804330", "Oratov\,\ Vinnytsia",
"3804140", "Natives\,\ Zhytomyr",
"3805634", "Petrykivka\,\ Dnipro",
"3804859", "Velikaya\ Mikhailovka\,\ Odesa",
"3805258", "Malaya\ Vyska\,\ Kirovohrad",
"3805362", "Khorol\,\ Poltava",
"3806436", "Lutugin\,\ Luhansk",
"380561", "Dnipropetrovsk\/Dnipro",
"3804654", "Shchors\,\ Chernihiv",
"3806245", "Gorlovka\,\ Donetsk",
"3805350", "Kotelva\,\ Poltava",
"380619", "Melitopol\,\ Zaporizhzhia",
"3804742", "Katerinopil\,\ Cherkasy",
"3805756", "Krasnokutsk\,\ Kharkiv",
"3803255", "Radehiv\,\ Lviv",
"38037312", "Khotin\,\ Chernivtsi",
"3803131", "Mukacheve\,\ Zakarpattia",
"3806442", "Alchevsk\,\ Luhansk",
"3803264", "Busk\,\ Lviv",
"3803546", "Kremenets\/Pochayiv\,\ Ternopil",
"3805348", "Komsomolsk\,\ Poltava",
"3803656", "Dubno\,\ Rivne",
"3804353", "Teplik\,\ Vinnytsia",
"3803477", "Valley\,\ Ivano\-Frankivsk",
"38033", "Volyn",
"3805444", "Glukhov\,\ Sumy",
"3804137", "Popilnya\,\ Zhytomyr",
"3804347", "Litin\,\ Vinnytsia",
"3803734", "Deep\,\ Chernivtsi",
"3803135", "Great\ Berezny\,\ Zakarpattia",
"3803251", "Skole\/Slavske\,\ Lviv",
"3806468", "Luhansk",
"3806473", "Slavyanoserbsk\,\ Luhansk",
"380522", "Kropyvnytskyi\,\ Kirovohrad",
"3806241", "Gorlovka\,\ Donetsk",
"3805240", "Kompaniyivka\,\ Kirovohrad",
"3805347", "Chutovoye\,\ Poltava",
"3804143", "Berdychiv\,\ Zhytomyr",
"3804333", "Kalinovka\,\ Vinnytsia",
"3803374", "Lokachi\,\ Volyn",
"3806297", "Mangosh\/Yalta\,\ Donetsk",
"3803636", "Kuznetsovsk\,\ Rivne",
"3805661", "Nikopol\,\ Dnipro",
"38061", "Zaporizhzhia",
"3805539", "Gola\ Prystan\,\ Kherson",
"3805158", "Bashtanka\,\ Mykolayiv",
"3804571", "Vasilkov\/Glevaha\/Grebinky\/Kalinovka\,\ Kyiv",
"3803478", "Kosiv\,\ Ivano\-Frankivsk",
"3804844", "Tatarbunary\,\ Odesa",
"3806467", "Luhansk",
"380629", "Mariupol\,\ Donetsk",
"3806269", "Aleksandrovka\,\ Donetsk",
"3806145", "Gulyaypole\,\ Zaporizhzhia",
"3804348", "Tomashpil\,\ Vinnytsia",
"3804138", "Ruzhin\,\ Zhytomyr",
"380320", "Lviv",
"3805353", "Zinkiv\,\ Poltava",
"3803231", "Gorodok\,\ Lviv",
"3803552", "Chortkiv\,\ Ternopil",
"3805365", "Globin\,\ Poltava",
"3805239", "Ustinovka\,\ Kirovohrad",
"3805354", "Gadyach\,\ Poltava",
"38047", "Cherkasy",
"3804857", "Nikolaevka\,\ Odesa",
"3803855", "Krasilov\,\ Khmelnytskyi",
"3805458", "Trostyanets\,\ Sumy",
"3803260", "Morshin\,\ Lviv",
"3806236", "Yasinovata\,\ Donetsk",
"3804843", "Wilkow\/Kielia\,\ Odesa",
"3806445", "Novoyadar\,\ Luhansk",
"3803252", "Zhovkva\,\ Lviv",
"3803368", "Rozhysche\,\ Volyn",
"3804745", "Khrystynivka\,\ Cherkasy",
"3804144", "Baranivka\,\ Zhytomyr",
"3804334", "Haysin\,\ Vinnytsia",
"3803122", "Uzhhorod\,\ Zakarpattia",
"3805630", "Mezhova\,\ Dnipro",
"3806242", "Gorlovka\,\ Donetsk",
"3806256", "Snizhne\,\ Donetsk",
"3804566", "Tarashcha\,\ Kyiv",
"380568", "Dnipropetrovsk\/Dnipro",
"3806474", "Popasna\,\ Luhansk",
"3803246", "Lviv",
"3805662", "Nikopol\,\ Dnipro",
"3805457", "Great\ Pisarivka\,\ Sumy",
"3805745", "Lozova\,\ Kharkiv",
"3804572", "Kozin\/Obukhiv\/Ukrainka\,\ Kyiv",
"3805259", "Ulyanovka\,\ Kirovohrad",
"3804858", "Shiryaevoe\,\ Odesa",
"3803733", "Novoselytsia\,\ Chernivtsi",
"3805443", "Belopoly\,\ Sumy",
"3805650", "Sofiyivka\,\ Dnipro",
"3803435", "Rohatyn\,\ Ivano\-Frankivsk",
"3806270", "Artemivsk\,\ Donetsk",
"38057", "Kharkiv",
"3805540", "Lower\ Sirogozy\,\ Kherson",
"3803232", "Lviv",
"3803551", "Terebovlya\,\ Ternopil",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+380|\D)//g;
      my $self = bless({ country_code => '380', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '380', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;