# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153525;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          336(?:
            [013-9]\\d|
            2[013-9]
          )\\d{5}|
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15-7]|
              6[0-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          336(?:
            [013-9]\\d|
            2[013-9]
          )\\d{5}|
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15-7]|
              6[0-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{ru} = {"771336", "Хромтауский\ р\-н",
"771341", "Хобдинский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"7424", "Сахалинская\ обл\.",
"771438", "Амангельдинский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"77132", "Актобе\/Актюбинск",
"772545", "Икан",
"772330", "Зыряновский\ р\-н",
"771834", "Успенский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"7493", "Ивановская\ обл\.",
"772935", "Каракиянский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"771230", "Атырауская\ область",
"772342", "Катон\-Карагайский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"771037", "Актогайский\ р\-н",
"771145", "Каратобинский\ р\-н",
"77222", "Семипалатинск",
"771337", "Алгинский\ р\-н",
"7395", "Иркутская\ обл\.",
"771434", "Денисовский\ р\-н",
"7872", "Республика\ Дагестан",
"77125", "Атырауская\ область",
"77102", "Жезказган",
"772237", "Аязог",
"7394", "Республика\ Тыва",
"7426", "Еврейская\ автономная\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"7842", "Ульяновская\ обл\.",
"7851", "Астраханская\ обл\.",
"771041", "Актау\,\ Жезказган",
"771638", "Аккольский\ р\-н",
"771651", "Целиноградский\ р\-н",
"771036", "Балхаш",
"771838", "Майский\ р\-он",
"771539", "Кызылжарский\ р\-н",
"772531", "Аксукент",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771146", "Акжаикский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"77106", "Сатпаев",
"7865", "Ставропольский\ край",
"771440", "Амангельдинский\ р\-н",
"771131", "Зеленовский\ р\-н",
"772546", "Шолаккорган",
"77272983", "Каскелен",
"772757", "Акший",
"7834", "Республика\ Мордовия",
"771532", "Аккайынский\ р\-н",
"7472", "Белгородская\ обл\.",
"772348", "Кокпектинский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"7302", "Забайкальский\ край",
"7482", "Тверская\ обл\.",
"77292", "Актау",
"772431", "Жалагашский\ р\-н",
"772132", "Нуринский\ р\-н",
"771543", "Есильский\ р\-н",
"771540", "Уалихановский\ р\-н",
"771335", "Шалкарский\ р\-н",
"771035", "Улытауский\ р\-н",
"7811", "Псковская\ обл\.",
"771147", "Акжаикский\ р\-н",
"772770", "Жамбылский\ р\-н",
"772831", "Панфиловский\ р\-н",
"772773", "Балхашский\ р\-н",
"7866", "Республика\ Кабардино\-Балкарская",
"772937", "Каракиянский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"772547", "Ленгер",
"7712302", "Тенгизшевройл",
"7381", "Омская\ обл\.",
"7879", "Ставропольский\ край",
"771639", "Енбекшилдерский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771643", "Атбасарский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"771832", "Иртышский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"7352", "Курганская\ обл\.",
"771840", "Баянаульский\ р\-н",
"771843", "Майский\ р\-н",
"771632", "Зерендинский\ р\-н",
"7341", "Республика\ Удмуртская",
"7496", "г\.\ Москва",
"771437", "Камыстинский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"77182", "Павлодар",
"7841", "Пензенская\ обл\.",
"772833", "Алакольский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"77245", "Кызылординская\ область",
"772830", "Алакольский\ р\-н",
"772771", "Карасайский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"77162", "Кокшетау",
"772752", "Илийский\ р\-н",
"7498", "Московская\ обл\.",
"772842", "Кербулакский\ р\-н",
"740", "Калининградская\ обл\.",
"772633", "Жамбылский\ р\-н",
"771038", "Сыры\-Шаган",
"771641", "Астраханский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"771836", "Щербактинский\ р\-н",
"7871", "Республика\ Чеченская",
"772759", "Алматинская\ область",
"771841", "Актогайский\ р\-н",
"772137", "Сарань",
"7427", "Чукотский\ АО",
"771636", "Щучинский\ р\-н",
"772345", "Жарминский\ р\-н",
"772530", "Темирлановка",
"772932", "Бейнеуский\ р\-н",
"772533", "Туркестан",
"772251", "Курчатов",
"771142", "Акжаикский\ р\-н",
"77152", "Петропавловск",
"771436", "Тарановский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"771130", "Зеленовский\ р\-н",
"77187", "Экибастуз",
"7423", "Приморский\ край",
"771133", "Бурлинский\ р\-н",
"7495", "Московская\ обл\.",
"7390", "Республика\ Хакасия",
"77212", "Караганда",
"772542", "Асыката",
"77142", "Костанай",
"771837", "Аксуский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"77274", "Карасайский\ р\-н",
"771149", "Акжаикский\ р\-н",
"772433", "Аральский\ р\-н",
"771637", "Коргалжынский\ р\-н",
"7494", "Костромская\ обл\.",
"771034", "Улытауский\ р\-н",
"771541", "Мамлютский\ р\-н",
"772934", "Жанаозен",
"77213", "Темиртау",
"7860", "Херсонская\ область",
"771144", "Казталовский\ р\-н",
"771635", "Жаксынский\ р\-н",
"7351", "Челябинская\ обл\.",
"771039", "Приозерск",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772544", "Шаульдер",
"7342", "Пермский\ край",
"7812", "г\.\ Санкт\-Петербург",
"771043", "Жайрем\ \(поселок\)",
"771040", "Жайрем\ \(ГОК\)",
"771032", "Каражал",
"7382", "Томская\ обл\.",
"772347", "Жарминский\ р\-н",
"772644", "Таласский\ р\-н",
"7820", "Вологодская\ обл\.",
"7471", "Курская\ обл\.",
"7481", "Смоленская\ обл\.",
"7301", "Республика\ Бурятия",
"771332", "Уилский\ р\-н",
"772548", "Шаян",
"771343", "Иргизский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"771340", "Хобдинский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771453", "Аулиекольский\ р\-н",
"7833", "Кировская\ обл\.",
"772153", "Абайский\ р\-н",
"77149", "Костанай",
"771339", "Айтекебийский\ р\-н",
"772331", "Глубоковский\ р\-н",
"772239", "Урджарский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"771231", "Исатайский\ р\-н",
"771435", "Житикаринский\ р\-н",
"7863", "Ростовская\ обл\.",
"7873", "Республика\ Ингушетия",
"771033", "Шетский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"7391", "Красноярский\ край",
"7717", "Астана",
"771237", "Жылыойский\ р\-н",
"772337", "Серебрянск",
"77272", "Алма\-Ата",
"77135", "Актюбинская\ область",
"771042", "Акой",
"771134", "Сырымский\ р\-н",
"771645", "Степногорск",
"7843", "Республика\ Татарстан",
"772838", "Коксуский\ р\-н",
"7855", "Республика\ Татарстан",
"7416", "Амурская\ обл\.",
"771845", "Павлодар",
"772534", "Жетысай",
"772638", "Шуский\ р\-н",
"771236", "Махамбетский\ р\-н",
"771349", "Шалкарский\ р\-н",
"7847", "Республика\ Калмыкия",
"772341", "Катон\-Карагайский\ р\-н",
"771459", "Костанайская\ область",
"772438", "Казалинский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"772336", "Риддер",
"733622", "Байконыр",
"772725", "Отеген\-Батыр",
"772538", "имени\ Турара\ Рыскулова",
"772230", "Урджарский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7415", "Камчатский\ край",
"772634", "Жанатас",
"771452", "Карасуский\ р\-н",
"7877", "Республика\ Адыгея",
"77122", "Атырау",
"772159", "Карагандинская\ область",
"77232", "Усть\-Каменогорск",
"771138", "Казталовский\ р\-н",
"7856", "Донецкая\ Народная\ Республика",
"771333", "Мугалжарский\ р\-н",
"7421", "Хабаровский\ край",
"771545", "Жамбылский\ р\-н",
"771330", "Хромтауский\ р\-н",
"7492", "Владимирская\ обл\.",
"772834", "Каратальский\ р\-н",
"771547", "Жамбылский\ р\-н",
"7815", "Мурманская\ обл\.",
"771631", "Шортандинский\ р\-н",
"7487", "Тульская\ обл\.",
"772639", "Сарысуский\ р\-н",
"77279", "Алматы",
"7821", "Республика\ Коми",
"772154", "Бухар\-Жырауский\ р\-н",
"772147", "Каркаралинский\ р\-н",
"771646", "Буландинский\ р\-н",
"772839", "Саркандский\ р\-н",
"771831", "Железинский\ р\-н",
"7385", "Алтайский\ край",
"772843", "Лепсы",
"772840", "Кербулакский\ р\-н",
"7814", "Республика\ Карелия",
"772632", "Меркенский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772643", "Шуский\ р\-н",
"7345", "Тюменская\ обл\.",
"772776", "Енбекшиказахский\ р\-н",
"772832", "Аксуский\ р\-н",
"772257", "Шульбинск",
"7353", "Оренбургская\ обл\.",
"77273", "Алма\-Ата",
"772131", "Абайский\ р\-н",
"77145834", "Красногорск",
"771139", "Таскалинский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771546", "Акжарский\ р\-н",
"7818", "Архангельская\ обл\.",
"7831", "Нижегородская\ обл\.",
"771531", "Магжана\ Жумабаева\ р\-н",
"7388", "Республика\ Алтай",
"7861", "Краснодарский\ край",
"772539", "Казыгурт",
"7816", "Новгородская\ обл\.",
"771647", "Есильский\ р\-н",
"772432", "Шиелийский\ р\-н",
"772146", "Каркаралинск",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771132", "Теректинский\ р\-н",
"7483", "Брянская\ обл\.",
"771446", "Узункольский\ р\-н",
"772540", "Арыс",
"7499", "г\.\ Москва",
"772335", "Зыряновск",
"7473", "Воронежская\ обл\.",
"772543", "Аксумбе",
"736", "Республика\ Крым",
"772256", "Алгабас",
"772532", "Абая",
"771348", "Шалкарский\ р\-н",
"771235", "Макатский\ р\-н",
"772777", "Райымбекский\ р\-н",
"771140", "Бокейординский\ р\-н",
"771431", "Рудный",
"771143", "Теректинский\ р\-н",
"771458", "Костанайская\ область",
"772439", "Аральский\ р\-н",
"7413", "Магаданская\ обл\.",
"771449", "Тарановский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"7848", "Самарская\ обл\.",
"772338", "Уланский\ р\-н",
"77112", "Уральск",
"771542", "Уалихановский\ р\-н",
"771533", "Айыртауский\ р\-н",
"771345", "Байганинский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"771455", "Костанайский\ р\-н",
"7846", "Самарская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"77252", "Шымкент",
"7491", "Рязанская\ обл\.",
"771136", "Акжаикский\ р\-н",
"772637", "Байзакский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"771442", "Федоровский\ р\-н",
"7869", "г\.\ Севастополь",
"7857", "Луга́нская\ Наро́дная\ Респу́блика",
"772541", "Мырзакент",
"772837", "Алакольский\ р\-н",
"772252", "Абайский\ р\-н",
"772536", "Кентау",
"77242", "Кызылорда",
"772931", "Мангистауский\ р\-н",
"77185", "Шалдай",
"772149", "Осакаровский\ р\-н",
"771433", "Лисаковск",
"771141", "Жангалинский\ р\-н",
"771430", "Аркалык",
"771234", "Индерский\ р\-н",
"7845", "Саратовская\ обл\.",
"771842", "Майский\ р\-он",
"77262", "Тараз",
"77224", "Эмельтау",
"771633", "Ерейментауский\ р\-н",
"771630", "Боровое",
"77282", "Талдыкорган",
"772437", "Кармакшинский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"772334", "Уланский\ р\-н",
"771833", "Качирский\ р\-н",
"772779", "Райымбекский\ р\-н",
"772841", "Аксуский\ р\-н",
"7844", "Волгоградская\ обл\.",
"772636", "Кордай",
"771137", "Чингирлауский\ р\-н",
"771649", "Жаксынский\ р\-н",
"77272956", "Талгар",
"772641", "Таласский\ р\-н",
"772772", "Капчагай",
"772537", "Сарыагаш",
"772836", "Ескельдинский\ р\-н",
"771844", "Иртышский\ р\-н",
"772340", "Зайсанский\ р\-н",
"771232", "Атырауская\ область",
"772535", "Шардара",
"7475", "Тамбовская\ обл\.",
"7817", "Вологодская\ обл\.",
"772343", "Курчумский\ р\-н",
"772148", "Осакаровский\ р\-н",
"7485", "Ярославская\ обл\.",
"771135", "Жанибекский\ р\-н",
"772156", "Шахтинск",
"771644", "Аршалынский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"7712303", "Тензиз",
"771239", "Макатский\ р\-н",
"771346", "Темирский\ р\-н",
"7484", "Калужская\ обл\.",
"772435", "Жанакорганский\ р\-н",
"7474", "Липецкая\ обл\.",
"771456", "Качар",
"771448", "Карасуский\ р\-н",
"7862", "Краснодарский\ край",
"771331", "Мартукский\ р\-н",
"772774", "Талгарский\ р\-н",
"7347", "Республика\ Башкортостан",
"772339", "Курчумский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771031", "Шетский\ р\-н",
"771544", "Жамбылский\ р\-н",
"772835", "Текели",
"7343", "Свердловская\ обл",
"7486", "Орловская\ обл\.",
"772635", "Жуалынский\ р\-н",
"772144", "Нуринский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"771444", "Узункольский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"7813", "Ленинградская\ обл\.",
"772778", "Уйгурский\ р\-н",
"7383", "Новосибирская\ обл\.",};
$areanames{en} = {"7395", "Irkutsk",
"771434", "Denisovka",
"7872", "Republic\ of\ Daghestan",
"771337", "Alga",
"772237", "Ayagoz",
"77102", "Zhezkazgan",
"77125", "Atyrau\ Region",
"7851", "Astrakhan",
"771041", "Aktau\,\ Zhezkazgan",
"771638", "Akkol",
"771651", "Kabanbai\ Batyr",
"7394", "Republic\ of\ Tuva",
"7426", "Jewish\ Autonomous\ Region",
"7842", "Ulyanovsk",
"771534", "Sergeyevka",
"771838", "Koktobe",
"771036", "Balkhash",
"771336", "Khromtau",
"771438", "Amangeldy",
"771451", "Sarykol",
"771341", "Khobda",
"772236", "Beskaragai",
"7424", "Sakhalin\ Region",
"772330", "Zyryanovsky\ District",
"772545", "Ikan",
"771834", "Uspenka",
"772333", "Samarskoye",
"7411", "Republic\ of\ Sakha",
"77132", "Aktobe\/Kargalinskoye",
"772138", "Gabidena\ Mustafina",
"77222", "Semey",
"771145", "Karatobe\ District",
"771037", "Aktogai",
"772935", "Zhetybai",
"772342", "Katon\-Karagai",
"771230", "Atyrau\ Region",
"771538", "Beskol",
"771233", "Ganyushkino",
"772831", "Zharkent",
"772770", "Uzynagash",
"772773", "Bakanas",
"7866", "Kabardino\-Balkarian\ Republic",
"771839", "Akku",
"772937", "Kuryk",
"771147", "Akzhaiksky\ District",
"771035", "Ulytau",
"7811", "Pskov",
"7381", "Omsk",
"7712302", "Tengizshevroil",
"771639", "Stepnyak",
"7879", "Mineranye\ Vody",
"772631", "Kulan",
"7836", "Republic\ of\ Marij\ El",
"772547", "Lenger",
"771832", "Irtyshsk",
"771643", "Atbasar",
"771640", "Balkashino",
"771632", "Zerenda",
"7341", "Udmurtian\ Republic",
"772344", "Akzhar",
"7352", "Kurgan",
"771840", "Bayanaul",
"771843", "Maisky\ District",
"7835", "Chuvashi\ Republic",
"771146", "Akzhaiksky\ District",
"771539", "Beskol",
"772531", "Aksukent",
"772546", "Sholakkorgan",
"77272983", "Kaskelen",
"772757", "Akshi",
"771443", "Borovskoi",
"77106", "Satpaev",
"771440", "Amangeldy",
"7865", "Stavropol\ territory",
"771131", "Darinskoye",
"771439", "Torgai",
"7482", "Tver",
"7302", "Chita",
"772431", "Zhalagash",
"77292", "Aktau",
"7834", "Republic\ of\ Mordovia",
"772348", "Kokpekty",
"7472", "Belgorod",
"771532", "Smirnovo",
"771543", "Yavlenka",
"771335", "Shalkar",
"771540", "Kishkenekol",
"772132", "Nurinsky\ District",
"77152", "Petropavlovsk",
"771142", "Taipak",
"771436", "Taranovskoye",
"772530", "Temirlanovka",
"772345", "Shar",
"772932", "Beineu",
"772533", "Turkestan",
"772251", "Kurchatov",
"7390", "Republic\ of\ Khakassia",
"7495", "Moscow",
"772542", "Asykata",
"77212", "Karaganda",
"771441", "Karabalyk",
"77187", "Ekibastuz",
"771130", "Peremetnoye",
"7423", "Primorie\ territory",
"771133", "Aksai",
"77274", "Karassaisky\ District",
"772433", "Aralsk",
"771149", "Zelenovsky\ District",
"77142", "Kostanai",
"771837", "Aksu",
"771536", "Taiynsha",
"771541", "Mamlutka",
"771637", "Korgalzhyn",
"7494", "Kostroma",
"771034", "Zhezdy",
"772833", "Usharal",
"77245", "Kyzylorda\ Region",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772771", "Kaskelen",
"772830", "Alakolsky\ District",
"771334", "Emba",
"7496", "Moscow",
"772642", "Moiynkum",
"771437", "Kamysty",
"77182", "Pavlodar",
"7841", "Penza",
"740", "Kaliningrad",
"772633", "Asa",
"77162", "Kokshetau\/Krasni\ Yar",
"772752", "Otegen\ Batyra",
"7498", "Moscow",
"772842", "Kogaly",
"771537", "Timiryazevo",
"771836", "Sharbakty",
"7871", "Chechen\ Republic",
"771038", "Shashubai",
"771641", "Astrakhanka",
"772137", "Saran",
"7427", "Chukotka\ Autonomous\ District",
"771636", "Shuchinsk",
"772759", "Almaty\ Region",
"771841", "Aktogai",
"7301", "Republic\ of\ Buryatia",
"7481", "Smolensk",
"772548", "Shayan",
"771332", "Uil",
"772644", "Karatau",
"7820", "Cherepovets",
"7471", "Kursk",
"771453", "Auliekol",
"771343", "Irgiz",
"772938", "Fort\ Shevchenko",
"771535", "Novoishimski",
"771340", "Khobdinsky\ District",
"77149", "Kostanai",
"771339", "Komsomolskoye",
"772331", "Glubokoye",
"7833", "Kirov",
"772153", "Topar",
"771435", "Zhitikara",
"7863", "Rostov",
"772346", "Aksuat",
"772239", "Makanchi",
"771231", "Akkystau",
"771144", "Kaztalovka",
"771635", "Zhaksy",
"772934", "Zhanaozen",
"77213", "Aktau\/Temirtau",
"7860", "Kherson\ Region",
"772544", "Shaulder",
"7342", "Perm",
"771039", "Priozersk",
"7351", "Chelyabinsk",
"7867", "Republic\ of\ North\ Ossetia",
"771043", "Zhairem",
"771040", "Zhairem\ \(GOK\)",
"7812", "St\ Petersburg",
"7382", "Tomsk",
"772347", "Kalbatau",
"771032", "Karazhal",
"772438", "Aiteke\ bi",
"771459", "Kostanai\ Region",
"771349", "Shalkarsky\ District",
"771236", "Makhambet",
"772341", "Ulken\ Naryn",
"7847", "Republic\ of\ Kalmykia",
"772336", "Ridder",
"733622", "Baikonur",
"772725", "Otegen\ Batyra",
"771445", "Ubaganskoye",
"7415", "Kamchatka\ Region",
"772634", "Zhanatas",
"771452", "Karasu",
"77122", "Atyrau",
"7877", "Republic\ of\ Adygeya",
"771342", "Badamsha",
"772230", "Urdzhar",
"772538", "Turara\ Ryskulova",
"771333", "Kandyagash",
"7421", "Khabarovsk\ Territory",
"771330", "Khromtau\ District",
"771545", "Zhambylsky\ District",
"772834", "Ushtobe",
"7492", "Vladimir",
"77232", "Ust\-Kamenogorsk",
"772159", "Karaganda\ Region",
"771138", "Zhalpaktal",
"7856", "Donetsk\ People\'s\ Republic",
"772775", "Esik",
"7391", "Krasnoyarsk\ Territory",
"771237", "Kulsary",
"7717", "Astana",
"7873", "Ingushi\ Republic",
"771033", "Agadyr",
"771030", "Atasu",
"77272", "Almaty",
"77135", "Aktobe\ Region",
"771042", "Zharyk",
"772337", "Serebryansk",
"7843", "Republic\ of\ Tatarstan",
"772838", "Balpyk\ bi",
"7855", "Naberezhnye\ Chelny",
"771134", "Zhympity",
"771645", "Stepnogorsk",
"772638", "Tole\ bi",
"771845", "Pavlodar\ Area",
"7416", "Amur\ Region",
"772534", "Zhetysai",
"772353", "Novaya\ Shulba",
"771546", "Talshik",
"7831", "Nizhni\ Novgorod",
"7818", "Arkhangelsk",
"772131", "Abai",
"77273", "Almaty",
"771139", "Taskala",
"77145834", "Krasnogorsk",
"772432", "Shiyeli",
"771647", "Esil",
"7816", "Veliky\ Novgorod",
"772146", "Karkaralinsk",
"771531", "Bulayevo",
"7861", "Krasnodar\ Territory",
"7388", "Republic\ of\ Altai",
"772539", "Kazygurt",
"7499", "Moscow",
"772335", "Zyryanovsk",
"7473", "Voronezh",
"772540", "Arys",
"772543", "Aqsumbe",
"736", "Simferopol",
"7346", "Surgut",
"771132", "Fyodorovka",
"7483", "Bryansk",
"771446", "Uzunkolsky\ District",
"771140", "Saikhin",
"771431", "Rudny",
"771458", "Kostanai\ Region",
"772439", "Aralsky\ District",
"771143", "Akzhaik",
"771235", "Dossor",
"771348", "Shalkarsky\ District",
"772532", "Abai",
"772256", "Kainar",
"772777", "Kegen",
"771631", "Shortandy",
"7487", "Tula",
"772639", "Saudakent",
"7815", "Murmansk",
"771547", "Zhambylsky\ District",
"772839", "Sarkand",
"771831", "Zhelezinka",
"7385", "Altai\ Territory",
"772147", "Egindybulak",
"772154", "Botakara",
"7821", "Komi\ Republic",
"77279", "Almaty",
"771646", "Makinsk",
"772632", "Merke",
"771447", "Karabalyksky\ District",
"771454", "Karamendy",
"7814", "Republic\ of\ Karelia",
"772843", "Lepsy",
"772840", "Saryozek",
"7345", "Tyumen",
"772776", "Shelek",
"772832", "Zhansugurov",
"772257", "Shulbinsk",
"7353", "Orenburg",
"772640", "Moiynkumsky\ District",
"7384", "Kemerovo",
"772643", "Shu",
"77224", "Barshatas",
"771633", "Ereimentau",
"771630", "Burabay",
"7845", "Saratov",
"771234", "Indernborski",
"771842", "Koktobe",
"77262", "Taraz",
"772334", "Tavricheskoye",
"771833", "Terenkol",
"772779", "Narynkol",
"77282", "Taldykorgan",
"771642", "Egendykol",
"772437", "Zhosaly",
"772636", "Kordai",
"7844", "Volgograd",
"771137", "Chingirlau",
"772841", "Kapal",
"772772", "Kapchagai",
"772537", "Saryagash",
"772836", "Karabulak",
"771649", "Zhaksynsky\ District",
"77272956", "Talgar",
"772641", "Akkol",
"772351", "Borodulikha",
"7848", "Tolyatti",
"771542", "Kishkenekol",
"772338", "Bozanbai\/Molodezhnyi",
"77112", "Uralsk",
"7413", "Magadan",
"771449", "Taranovskoye",
"772436", "Terenozek",
"771455", "Zatobolsk",
"7846", "Samara",
"77252", "Shymkent",
"7491", "Ryazan",
"771533", "Saumalkol",
"771238", "Miyaly",
"771345", "Karauylkeldy",
"7857", "Luhansk\ People\'s\ Republic",
"772541", "Myrzakent",
"771136", "Chapayev",
"771442", "Fyodorovka",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772637", "Sarykemer",
"7869", "Sevastopol",
"77185", "Shaldai",
"771433", "Lisakovsk",
"772149", "Osakarovka",
"771141", "Zhangala",
"771430", "Arkalyk",
"772837", "Kabanbai",
"772536", "Kentau",
"772252", "Karaul",
"772931", "Shetpe",
"77242", "Kyzylorda",
"771544", "Presnovka",
"772835", "Tekeli",
"771648", "Derzhavinsk",
"771031", "Aksu\-Ayuly",
"772635", "Bauyrzhan\ Mamyshuly",
"772144", "Kiyevka",
"7343", "Ekaterinburg",
"7486", "Orel",
"7813", "Leningrad\ region",
"771347", "Aitekebisky\ District",
"772778", "Chundzha",
"771444", "Uzunkol",
"771457", "Dzhangildinsky\ District",
"7383", "Novosibirsk",
"772148", "Molodezhnoye",
"7485", "Yaroslavl",
"771844", "Irtyshsky\ District",
"772535", "Shardara",
"7475", "Tambov",
"771232", "Atyrau\ Region",
"772340", "Zaisan",
"7817", "Vologda",
"772343", "Terekty",
"772332", "Shemonaikha",
"772156", "Shakhtinsk",
"771135", "Zhanibek",
"771644", "Arshaly",
"771456", "Kachar",
"772435", "Zhanakorgan",
"7474", "Lipetsk",
"7712303", "Tengizs",
"771346", "Shubarkuduk",
"771239", "Makat",
"7484", "Kaluga",
"771331", "Martuk",
"772774", "Talgar",
"772339", "Kurchum",
"7347", "Republic\ of\ Bashkortostan",
"771448", "Oktyabrskoye",
"7862", "Sochi",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '336' => [
                          'Asia/Yekaterinburg'
                        ],
               '33622' => [
                            'Asia/Almaty'
                          ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '856' => [
                          'Europe/Moscow'
                        ],
               '857' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;