/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNode;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLSerializer;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.xml.XmlUtil;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsxClass(browsers={@WebBrowser(value=BrowserName.IE)})
public class XSLProcessor
extends MSXMLScriptable {
    private XMLDOMNode style_;
    private XMLDOMNode input_;
    private Object output_;
    private Map<String, Object> parameters_ = new HashMap<String, Object>();

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setInput(XMLDOMNode input) {
        this.input_ = input;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public XMLDOMNode getInput() {
        return this.input_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setOutput(Object output) {
        this.output_ = output;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getOutput() {
        return this.output_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void addParameter(String baseName, Object parameter, Object namespaceURI) {
        String nsString = namespaceURI instanceof String ? (String)namespaceURI : null;
        this.parameters_.put(this.getQualifiedName(nsString, baseName), parameter);
    }

    private String getQualifiedName(String namespaceURI, String localName) {
        String qualifiedName = namespaceURI != null && !namespaceURI.isEmpty() && !"null".equals(namespaceURI) ? '{' + namespaceURI + '}' + localName : localName;
        return qualifiedName;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void transform() {
        XMLDOMNode input = this.input_;
        SgmlPage page = ((DomNode)input.getDomNodeOrDie()).getPage();
        if (this.output_ == null || !(this.output_ instanceof XMLDOMNode)) {
            DomDocumentFragment fragment = page.createDomDocumentFragment();
            XMLDOMDocumentFragment node = new XMLDOMDocumentFragment();
            node.setParentScope(this.getParentScope());
            node.setPrototype(this.getPrototype(node.getClass()));
            node.setDomNode(fragment);
            this.output_ = fragment.getScriptObject();
        }
        this.transform(this.input_, (DomNode)((XMLDOMNode)this.output_).getDomNodeOrDie());
        XMLSerializer serializer = new XMLSerializer(false);
        StringBuilder output = new StringBuilder();
        for (DomNode child : ((DomNode)((XMLDOMNode)this.output_).getDomNodeOrDie()).getChildren()) {
            if (child instanceof DomText) {
                if (!StringUtils.isNotBlank((CharSequence)((DomText)child).getData())) continue;
                output.append(((DomText)child).getData());
                continue;
            }
            String serializedString = serializer.serializeToString((XMLDOMNode)child.getScriptObject());
            output.append(serializedString.substring(0, serializedString.length() - 2));
        }
        this.output_ = output.toString();
    }

    private Object transform(XMLDOMNode source) {
        try {
            DOMSource xmlSource = new DOMSource((Node)source.getDomNodeOrDie());
            DOMSource xsltSource = new DOMSource((Node)this.style_.getDomNodeOrDie());
            Document containerDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element containerElement = containerDocument.createElement("container");
            containerDocument.appendChild(containerElement);
            DOMResult result = new DOMResult(containerElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            for (Map.Entry<String, Object> entry : this.parameters_.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.transform(xmlSource, result);
            Node transformedNode = result.getNode();
            if (transformedNode.getFirstChild().getNodeType() == 1) {
                return transformedNode;
            }
            xmlSource = new DOMSource((Node)source.getDomNodeOrDie());
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(xmlSource, streamResult);
            return writer.toString();
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Exception: " + e));
        }
    }

    private void transform(XMLDOMNode source, DomNode parent) {
        Object result = this.transform(source);
        if (result instanceof Node) {
            SgmlPage parentPage = parent.getPage();
            NodeList children = ((Node)result).getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XmlUtil.appendChild(parentPage, parent, children.item(i), false);
            }
        } else {
            DomText text = new DomText(parent.getPage(), (String)result);
            parent.appendChild(text);
        }
    }

    public void importStylesheet(XMLDOMNode style) {
        this.style_ = style;
    }
}

