/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.w3c.dom.Node;

@JsxClass
public class NodeList
extends SimpleScriptable
implements Function,
org.w3c.dom.NodeList {
    private boolean avoidObjectDetection_ = false;
    private String description_;
    private boolean attributeChangeSensitive_ = true;
    private List<Object> cachedElements_;
    private boolean listenerRegistered_;

    public NodeList() {
    }

    private NodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public NodeList(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        this(parentScope.getScriptObject());
        this.setDomNode(parentScope, false);
        this.description_ = description;
        this.attributeChangeSensitive_ = attributeChangeSensitive;
    }

    protected NodeList(DomNode parentScope, List<?> initialElements) {
        this(parentScope.getScriptObject());
        this.cachedElements_ = new ArrayList(initialElements);
    }

    public static NodeList emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new NodeList((ScriptableObject)window){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        return this.nullIfNotFound(this.getIt(args[0]));
    }

    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        NodeList array = (NodeList)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    @Override
    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        Object oldDomNode = this.getDomNodeOrNull();
        super.setDomNode(domNode, assignScriptObject);
        if (oldDomNode != domNode) {
            this.listenerRegistered_ = false;
        }
    }

    public List<Object> getElements() {
        List<Object> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            this.cachedElements_ = cachedElements = this.computeElements();
            if (!this.listenerRegistered_) {
                DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
                Object domNode = this.getDomNodeOrNull();
                if (domNode != null) {
                    ((DomNode)domNode).addDomChangeListener(listener);
                    if (this.attributeChangeSensitive_) {
                        if (domNode instanceof HtmlElement) {
                            ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                        } else if (domNode instanceof HtmlPage) {
                            ((HtmlPage)domNode).addHtmlAttributeChangeListener(listener);
                        }
                    }
                    this.listenerRegistered_ = true;
                }
            }
        }
        return cachedElements;
    }

    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        Object domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            boolean commentIncluded;
            boolean bl = commentIncluded = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_COMMENT_IS_ELEMENT) && node instanceof DomComment;
            if (!(node instanceof DomElement) && !commentIncluded || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        Object domNode = this.getDomNodeOrNull();
        return ((DomNode)domNode).getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            NodeList collection = new NodeList((DomNode)this.getDomNodeOrDie(), (List<?>)matchingElements);
            collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
            return collection;
        }
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        Object domNode = this.getDomNodeOrNull();
        NodeList collection = new NodeList((DomNode)domNode, (List<?>)matchingElements);
        collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        return collection;
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return this.getElements().size();
    }

    @JsxFunction
    public final Object item(Object index) {
        return this.nullIfNotFound(this.getIt(index));
    }

    private Object nullIfNotFound(Object object) {
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof NodeList) {
            NodeList otherArray = (NodeList)other;
            Object domNode = this.getDomNodeOrNull();
            Object domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && ((Object)this.getElements()).equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getElements().size();
    }

    public boolean has(String name, Scriptable start) {
        if (this.isPrototype()) {
            return super.has(name, start);
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (NumberFormatException e) {
            if ("length".equals(name)) {
                return true;
            }
            if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_49)) {
                JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
                for (String functionName : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                    if (!name.equals(functionName)) continue;
                    return true;
                }
                return false;
            }
            return this.getWithPreemption(name) != NOT_FOUND;
        }
    }

    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_50)) {
            idList.add("length");
            this.addElementIds(idList, elements);
        } else {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).functionKeys()) {
                idList.add(name);
            }
        }
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof NodeList);
    }

    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.getElements().get(index);
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    @Override
    public String getClassName() {
        return "NodeList";
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private transient WeakReference<NodeList> nodeList_;

        private DomHtmlAttributeChangeListenerImpl(NodeList nodeList) {
            this.nodeList_ = new WeakReference<NodeList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            NodeList nodes = (NodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            NodeList nodes = (NodeList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            EffectOnCache effectOnCache = nodes.getEffectOnCache(event);
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            NodeList nodes = (NodeList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

