/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.om.StructuredQName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageFeature {
    public static final int ALWAYS = 0;
    public static final int NEVER = 1;
    public static final int OPTIONAL = 2;
    public static final StructuredQName ALL_OPTIONAL_FEATURES = new StructuredQName("", "http://www.w3.org/2012/xquery", "all-optional-features");
    public static final LanguageFeature TYPED_DATA = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "typed-data"), null, 2);
    public static final LanguageFeature TYPED_DATA_SCHEMAS = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "typed-data-schemas"), TYPED_DATA, 2);
    public static final LanguageFeature TYPED_DATA_ALL_OPTIONAL_FEATURES = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "typed-data-all-optional-features"), TYPED_DATA, 2);
    public static final LanguageFeature STATIC_TYPING = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "static-typing"), null, 1);
    public static final LanguageFeature STATIC_TYPING_ALL_OPTIONAL_FEATURES = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "static-typing-all-optional-features"), STATIC_TYPING, 1);
    public static final LanguageFeature SERIALIZATION = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "serialization"), null, 0);
    public static final LanguageFeature SERIALIZATION_ALL_OPTIONAL_FEATURES = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "serialization-all-optional-features"), SERIALIZATION, 0);
    public static final LanguageFeature MODULE = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "module"), null, 2);
    public static final LanguageFeature MODULE_ALL_OPTIONAL_FEATURES = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "module-all-optional-features"), MODULE, 2);
    public static final LanguageFeature HIGHER_ORDER_FUNCTION = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "higher-order-function"), null, 0);
    public static final LanguageFeature HIGHER_ORDER_FUNCTION_ALL_OPTIONAL_FEATURES = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "higher-order-function-all-optional-features"), HIGHER_ORDER_FUNCTION, 0);
    public static final LanguageFeature ALL_EXTENSIONS = new LanguageFeature(new StructuredQName("", "http://www.w3.org/2012/xquery", "all-extensions"), null, 2);
    private static Map<StructuredQName, LanguageFeature> features = new HashMap<StructuredQName, LanguageFeature>();
    private StructuredQName name;
    private LanguageFeature parent;
    private int availability;
    private Set<LanguageFeature> children = new HashSet<LanguageFeature>();

    private static void add(LanguageFeature f) {
        features.put(f.getName(), f);
    }

    public static Collection<LanguageFeature> getAllOptionalFeatures() {
        return features.values();
    }

    public LanguageFeature(StructuredQName name, LanguageFeature parent, int availability) {
        this.name = name;
        if (parent != null) {
            this.parent = parent;
            parent.children.add(this);
        }
        this.availability = availability;
    }

    public StructuredQName getName() {
        return this.name;
    }

    public LanguageFeature getParent() {
        return this.parent;
    }

    public Set<LanguageFeature> getChildren() {
        return this.children;
    }

    public int getAvailability() {
        return this.availability;
    }

    public static LanguageFeature getFeature(StructuredQName name) {
        return features.get(name);
    }

    static {
        LanguageFeature.add(TYPED_DATA);
        LanguageFeature.add(TYPED_DATA_SCHEMAS);
        LanguageFeature.add(TYPED_DATA_ALL_OPTIONAL_FEATURES);
        LanguageFeature.add(STATIC_TYPING);
        LanguageFeature.add(STATIC_TYPING_ALL_OPTIONAL_FEATURES);
        LanguageFeature.add(SERIALIZATION);
        LanguageFeature.add(SERIALIZATION_ALL_OPTIONAL_FEATURES);
        LanguageFeature.add(MODULE);
        LanguageFeature.add(MODULE_ALL_OPTIONAL_FEATURES);
        LanguageFeature.add(HIGHER_ORDER_FUNCTION);
        LanguageFeature.add(HIGHER_ORDER_FUNCTION_ALL_OPTIONAL_FEATURES);
    }
}

