/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLIterate;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLOnCompletion
extends StyleElement {
    private Expression select;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo sib;
        StyleElement parent = (StyleElement)this.getParent();
        if (!(parent instanceof XSLIterate)) {
            this.compileError("xsl:on-completion is not allowed as a child of " + parent.getDisplayName(), "XTSE0010");
        }
        AxisIterator sibs = this.iterateAxis((byte)11, NodeKindTest.ELEMENT);
        while ((sib = sibs.next()) != null) {
            if (sib instanceof XSLFallback || sib instanceof XSLLocalParam) continue;
            this.compileWarning("The rules for xsl:iterate have changed (see W3C bug 24179): xsl:on-completion must now be the first child of xsl:iterate after the xsl:param elements", "XTSE0010");
        }
        if (this.select != null && this.iterateAxis((byte)3).next() != null) {
            this.compileError("An xsl:on-completion element with a select attribute must be empty", "XTSE3125");
        }
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.select == null) {
            return this.compileSequenceConstructor(exec, decl, true);
        }
        return this.select;
    }
}

