
/* This is subset of the prototypes found in Leptonica's allheaders.h
 *
 * This file is automatically generated by tool/build-inline.
 */

extern PIX * pixBackgroundNormSimple ( PIX *pixs, PIX *pixim, PIX *pixg );
extern PIX * pixBackgroundNorm ( PIX *pixs, PIX *pixim, PIX *pixg, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, l_int32 bgval, l_int32 smoothx, l_int32 smoothy );
extern PIX * pixBackgroundNormMorph ( PIX *pixs, PIX *pixim, l_int32 reduction, l_int32 size, l_int32 bgval );
extern l_int32 pixBackgroundNormGrayArray ( PIX *pixs, PIX *pixim, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, l_int32 bgval, l_int32 smoothx, l_int32 smoothy, PIX **ppixd );
extern l_int32 pixBackgroundNormRGBArrays ( PIX *pixs, PIX *pixim, PIX *pixg, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, l_int32 bgval, l_int32 smoothx, l_int32 smoothy, PIX **ppixr, PIX **ppixg, PIX **ppixb );
extern l_int32 pixBackgroundNormGrayArrayMorph ( PIX *pixs, PIX *pixim, l_int32 reduction, l_int32 size, l_int32 bgval, PIX **ppixd );
extern l_int32 pixBackgroundNormRGBArraysMorph ( PIX *pixs, PIX *pixim, l_int32 reduction, l_int32 size, l_int32 bgval, PIX **ppixr, PIX **ppixg, PIX **ppixb );
extern l_int32 pixGetBackgroundGrayMap ( PIX *pixs, PIX *pixim, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, PIX **ppixd );
extern l_int32 pixGetBackgroundRGBMap ( PIX *pixs, PIX *pixim, PIX *pixg, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, PIX **ppixmr, PIX **ppixmg, PIX **ppixmb );
extern l_int32 pixGetBackgroundGrayMapMorph ( PIX *pixs, PIX *pixim, l_int32 reduction, l_int32 size, PIX **ppixm );
extern l_int32 pixGetBackgroundRGBMapMorph ( PIX *pixs, PIX *pixim, l_int32 reduction, l_int32 size, PIX **ppixmr, PIX **ppixmg, PIX **ppixmb );
extern l_int32 pixFillMapHoles ( PIX *pix, l_int32 nx, l_int32 ny, l_int32 filltype );
extern PIX * pixExtendByReplication ( PIX *pixs, l_int32 addw, l_int32 addh );
extern l_int32 pixSmoothConnectedRegions ( PIX *pixs, PIX *pixm, l_int32 factor );
extern PIX * pixGetInvBackgroundMap ( PIX *pixs, l_int32 bgval, l_int32 smoothx, l_int32 smoothy );
extern PIX * pixApplyInvBackgroundGrayMap ( PIX *pixs, PIX *pixm, l_int32 sx, l_int32 sy );
extern PIX * pixApplyInvBackgroundRGBMap ( PIX *pixs, PIX *pixmr, PIX *pixmg, PIX *pixmb, l_int32 sx, l_int32 sy );
extern PIX * pixApplyVariableGrayMap ( PIX *pixs, PIX *pixg, l_int32 target );
extern PIX * pixGlobalNormRGB ( PIX *pixd, PIX *pixs, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 mapval );
extern PIX * pixGlobalNormNoSatRGB ( PIX *pixd, PIX *pixs, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 factor, l_float32 rank );
extern l_int32 pixThresholdSpreadNorm ( PIX *pixs, l_int32 filtertype, l_int32 edgethresh, l_int32 smoothx, l_int32 smoothy, l_float32 gamma, l_int32 minval, l_int32 maxval, l_int32 targetthresh, PIX **ppixth, PIX **ppixb, PIX **ppixd );
extern PIX * pixBackgroundNormFlex ( PIX *pixs, l_int32 sx, l_int32 sy, l_int32 smoothx, l_int32 smoothy, l_int32 delta );
extern PIX * pixContrastNorm ( PIX *pixd, PIX *pixs, l_int32 sx, l_int32 sy, l_int32 mindiff, l_int32 smoothx, l_int32 smoothy );
extern l_int32 pixMinMaxTiles ( PIX *pixs, l_int32 sx, l_int32 sy, l_int32 mindiff, l_int32 smoothx, l_int32 smoothy, PIX **ppixmin, PIX **ppixmax );
extern l_int32 pixSetLowContrast ( PIX *pixs1, PIX *pixs2, l_int32 mindiff );
extern PIX * pixLinearTRCTiled ( PIX *pixd, PIX *pixs, l_int32 sx, l_int32 sy, PIX *pixmin, PIX *pixmax );
extern PIX * pixAffineSampledPta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixAffineSampled ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixAffinePta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixAffine ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixAffinePtaColor ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint32 colorval );
extern PIX * pixAffineColor ( PIX *pixs, l_float32 *vc, l_uint32 colorval );
extern PIX * pixAffinePtaGray ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint8 grayval );
extern PIX * pixAffineGray ( PIX *pixs, l_float32 *vc, l_uint8 grayval );
extern PIX * pixAffinePtaWithAlpha ( PIX *pixs, PTA *ptad, PTA *ptas, PIX *pixg, l_float32 fract, l_int32 border );
extern l_int32 getAffineXformCoeffs ( PTA *ptas, PTA *ptad, l_float32 **pvc );
extern l_int32 affineInvertXform ( l_float32 *vc, l_float32 **pvci );
extern l_int32 affineXformSampledPt ( l_float32 *vc, l_int32 x, l_int32 y, l_int32 *pxp, l_int32 *pyp );
extern l_int32 affineXformPt ( l_float32 *vc, l_int32 x, l_int32 y, l_float32 *pxp, l_float32 *pyp );
extern l_int32 linearInterpolatePixelColor ( l_uint32 *datas, l_int32 wpls, l_int32 w, l_int32 h, l_float32 x, l_float32 y, l_uint32 colorval, l_uint32 *pval );
extern l_int32 linearInterpolatePixelGray ( l_uint32 *datas, l_int32 wpls, l_int32 w, l_int32 h, l_float32 x, l_float32 y, l_int32 grayval, l_int32 *pval );
extern l_int32 gaussjordan ( l_float32 **a, l_float32 *b, l_int32 n );
extern PIX * pixAffineSequential ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 bw, l_int32 bh );
extern l_float32 * createMatrix2dTranslate ( l_float32 transx, l_float32 transy );
extern l_float32 * createMatrix2dScale ( l_float32 scalex, l_float32 scaley );
extern l_float32 * createMatrix2dRotate ( l_float32 xc, l_float32 yc, l_float32 angle );
extern PTA * ptaTranslate ( PTA *ptas, l_float32 transx, l_float32 transy );
extern PTA * ptaScale ( PTA *ptas, l_float32 scalex, l_float32 scaley );
extern PTA * ptaRotate ( PTA *ptas, l_float32 xc, l_float32 yc, l_float32 angle );
extern BOXA * boxaTranslate ( BOXA *boxas, l_float32 transx, l_float32 transy );
extern BOXA * boxaScale ( BOXA *boxas, l_float32 scalex, l_float32 scaley );
extern BOXA * boxaRotate ( BOXA *boxas, l_float32 xc, l_float32 yc, l_float32 angle );
extern PTA * ptaAffineTransform ( PTA *ptas, l_float32 *mat );
extern BOXA * boxaAffineTransform ( BOXA *boxas, l_float32 *mat );
extern l_int32 l_productMatVec ( l_float32 *mat, l_float32 *vecs, l_float32 *vecd, l_int32 size );
extern l_int32 l_productMat2 ( l_float32 *mat1, l_float32 *mat2, l_float32 *matd, l_int32 size );
extern l_int32 l_productMat3 ( l_float32 *mat1, l_float32 *mat2, l_float32 *mat3, l_float32 *matd, l_int32 size );
extern l_int32 l_productMat4 ( l_float32 *mat1, l_float32 *mat2, l_float32 *mat3, l_float32 *mat4, l_float32 *matd, l_int32 size );
extern l_int32 l_getDataBit ( void *line, l_int32 n );
extern void l_setDataBit ( void *line, l_int32 n );
extern void l_clearDataBit ( void *line, l_int32 n );
extern void l_setDataBitVal ( void *line, l_int32 n, l_int32 val );
extern l_int32 l_getDataDibit ( void *line, l_int32 n );
extern void l_setDataDibit ( void *line, l_int32 n, l_int32 val );
extern void l_clearDataDibit ( void *line, l_int32 n );
extern l_int32 l_getDataQbit ( void *line, l_int32 n );
extern void l_setDataQbit ( void *line, l_int32 n, l_int32 val );
extern void l_clearDataQbit ( void *line, l_int32 n );
extern l_int32 l_getDataByte ( void *line, l_int32 n );
extern void l_setDataByte ( void *line, l_int32 n, l_int32 val );
extern l_int32 l_getDataTwoBytes ( void *line, l_int32 n );
extern void l_setDataTwoBytes ( void *line, l_int32 n, l_int32 val );
extern l_int32 l_getDataFourBytes ( void *line, l_int32 n );
extern void l_setDataFourBytes ( void *line, l_int32 n, l_int32 val );
extern char * barcodeDispatchDecoder ( char *barstr, l_int32 format, l_int32 debugflag );
extern l_int32 barcodeFormatIsSupported ( l_int32 format );
extern NUMA * pixFindBaselines ( PIX *pixs, PTA **ppta, l_int32 debug );
extern PIX * pixDeskewLocal ( PIX *pixs, l_int32 nslices, l_int32 redsweep, l_int32 redsearch, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta );
extern l_int32 pixGetLocalSkewTransform ( PIX *pixs, l_int32 nslices, l_int32 redsweep, l_int32 redsearch, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta, PTA **pptas, PTA **pptad );
extern NUMA * pixGetLocalSkewAngles ( PIX *pixs, l_int32 nslices, l_int32 redsweep, l_int32 redsearch, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta, l_float32 *pa, l_float32 *pb );
extern BBUFFER * bbufferCreate ( l_uint8 *indata, l_int32 nalloc );
extern void bbufferDestroy ( BBUFFER **pbb );
extern l_uint8 * bbufferDestroyAndSaveData ( BBUFFER **pbb, size_t *pnbytes );
extern l_int32 bbufferRead ( BBUFFER *bb, l_uint8 *src, l_int32 nbytes );
extern l_int32 bbufferReadStream ( BBUFFER *bb, FILE *fp, l_int32 nbytes );
extern l_int32 bbufferExtendArray ( BBUFFER *bb, l_int32 nbytes );
extern l_int32 bbufferWrite ( BBUFFER *bb, l_uint8 *dest, size_t nbytes, size_t *pnout );
extern l_int32 bbufferWriteStream ( BBUFFER *bb, FILE *fp, size_t nbytes, size_t *pnout );
extern l_int32 bbufferBytesToWrite ( BBUFFER *bb, size_t *pnbytes );
extern PIX * pixBilateral ( PIX *pixs, l_float32 spatial_stdev, l_float32 range_stdev, l_int32 ncomps, l_int32 reduction );
extern PIX * pixBilateralGray ( PIX *pixs, l_float32 spatial_stdev, l_float32 range_stdev, l_int32 ncomps, l_int32 reduction );
extern PIX * pixBilateralExact ( PIX *pixs, L_KERNEL *spatial_kel, L_KERNEL *range_kel );
extern PIX * pixBilateralGrayExact ( PIX *pixs, L_KERNEL *spatial_kel, L_KERNEL *range_kel );
extern PIX* pixBlockBilateralExact ( PIX *pixs, l_float32 spatial_stdev, l_float32 range_stdev );
extern L_KERNEL * makeRangeKernel ( l_float32 range_stdev );
extern PIX * pixBilinearSampledPta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixBilinearSampled ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixBilinearPta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixBilinear ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixBilinearPtaColor ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint32 colorval );
extern PIX * pixBilinearColor ( PIX *pixs, l_float32 *vc, l_uint32 colorval );
extern PIX * pixBilinearPtaGray ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint8 grayval );
extern PIX * pixBilinearGray ( PIX *pixs, l_float32 *vc, l_uint8 grayval );
extern PIX * pixBilinearPtaWithAlpha ( PIX *pixs, PTA *ptad, PTA *ptas, PIX *pixg, l_float32 fract, l_int32 border );
extern l_int32 getBilinearXformCoeffs ( PTA *ptas, PTA *ptad, l_float32 **pvc );
extern l_int32 bilinearXformSampledPt ( l_float32 *vc, l_int32 x, l_int32 y, l_int32 *pxp, l_int32 *pyp );
extern l_int32 bilinearXformPt ( l_float32 *vc, l_int32 x, l_int32 y, l_float32 *pxp, l_float32 *pyp );
extern l_int32 pixOtsuAdaptiveThreshold ( PIX *pixs, l_int32 sx, l_int32 sy, l_int32 smoothx, l_int32 smoothy, l_float32 scorefract, PIX **ppixth, PIX **ppixd );
extern PIX * pixOtsuThreshOnBackgroundNorm ( PIX *pixs, PIX *pixim, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, l_int32 bgval, l_int32 smoothx, l_int32 smoothy, l_float32 scorefract, l_int32 *pthresh );
extern PIX * pixMaskedThreshOnBackgroundNorm ( PIX *pixs, PIX *pixim, l_int32 sx, l_int32 sy, l_int32 thresh, l_int32 mincount, l_int32 smoothx, l_int32 smoothy, l_float32 scorefract, l_int32 *pthresh );
extern l_int32 pixSauvolaBinarizeTiled ( PIX *pixs, l_int32 whsize, l_float32 factor, l_int32 nx, l_int32 ny, PIX **ppixth, PIX **ppixd );
extern l_int32 pixSauvolaBinarize ( PIX *pixs, l_int32 whsize, l_float32 factor, l_int32 addborder, PIX **ppixm, PIX **ppixsd, PIX **ppixth, PIX **ppixd );
extern PIX * pixSauvolaGetThreshold ( PIX *pixm, PIX *pixms, l_float32 factor, PIX **ppixsd );
extern PIX * pixApplyLocalThreshold ( PIX *pixs, PIX *pixth, l_int32 redfactor );
extern l_int32 pixThresholdByConnComp ( PIX *pixs, PIX *pixm, l_int32 start, l_int32 end, l_int32 incr, l_float32 thresh48, l_float32 threshdiff, l_int32 *pglobthresh, PIX **ppixd, l_int32 debugflag );
extern PIX * pixExpandBinaryReplicate ( PIX *pixs, l_int32 factor );
extern PIX * pixExpandBinaryPower2 ( PIX *pixs, l_int32 factor );
extern PIX * pixReduceBinary2 ( PIX *pixs, l_uint8 *intab );
extern PIX * pixReduceRankBinaryCascade ( PIX *pixs, l_int32 level1, l_int32 level2, l_int32 level3, l_int32 level4 );
extern PIX * pixReduceRankBinary2 ( PIX *pixs, l_int32 level, l_uint8 *intab );
extern l_uint8 * makeSubsampleTab2x ( void );
extern PIX * pixBlend ( PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract );
extern PIX * pixBlendMask ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract, l_int32 type );
extern PIX * pixBlendGray ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract, l_int32 type, l_int32 transparent, l_uint32 transpix );
extern PIX * pixBlendGrayInverse ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract );
extern PIX * pixBlendColor ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract, l_int32 transparent, l_uint32 transpix );
extern PIX * pixBlendColorByChannel ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 rfract, l_float32 gfract, l_float32 bfract, l_int32 transparent, l_uint32 transpix );
extern PIX * pixBlendGrayAdapt ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract, l_int32 shift );
extern PIX * pixFadeWithGray ( PIX *pixs, PIX *pixb, l_float32 factor, l_int32 type );
extern PIX * pixBlendHardLight ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 x, l_int32 y, l_float32 fract );
extern l_int32 pixBlendCmap ( PIX *pixs, PIX *pixb, l_int32 x, l_int32 y, l_int32 sindex );
extern PIX * pixBlendWithGrayMask ( PIX *pixs1, PIX *pixs2, PIX *pixg, l_int32 x, l_int32 y );
extern PIX * pixBlendBackgroundToColor ( PIX *pixd, PIX *pixs, BOX *box, l_uint32 color, l_float32 gamma, l_int32 minval, l_int32 maxval );
extern PIX * pixMultiplyByColor ( PIX *pixd, PIX *pixs, BOX *box, l_uint32 color );
extern PIX * pixAlphaBlendUniform ( PIX *pixs, l_uint32 color );
extern PIX * pixAddAlphaToBlend ( PIX *pixs, l_float32 fract, l_int32 invert );
extern PIX * pixSetAlphaOverWhite ( PIX *pixs );
extern L_BMF * bmfCreate ( const char *dir, l_int32 size );
extern void bmfDestroy ( L_BMF **pbmf );
extern PIX * bmfGetPix ( L_BMF *bmf, char chr );
extern l_int32 bmfGetWidth ( L_BMF *bmf, char chr, l_int32 *pw );
extern l_int32 bmfGetBaseline ( L_BMF *bmf, char chr, l_int32 *pbaseline );
extern PIXA * pixaGetFont ( const char *dir, l_int32 size, l_int32 *pbl0, l_int32 *pbl1, l_int32 *pbl2 );
extern l_int32 pixaSaveFont ( const char *indir, const char *outdir, l_int32 size );
extern PIXA * pixaGenerateFont ( const char *dir, l_int32 size, l_int32 *pbl0, l_int32 *pbl1, l_int32 *pbl2 );
extern PIX * pixReadStreamBmp ( FILE *fp );
extern l_int32 pixWriteStreamBmp ( FILE *fp, PIX *pix );
extern PIX * pixReadMemBmp ( const l_uint8 *cdata, size_t size );
extern l_int32 pixWriteMemBmp ( l_uint8 **pdata, size_t *psize, PIX *pix );
extern BOX * boxCreate ( l_int32 x, l_int32 y, l_int32 w, l_int32 h );
extern BOX * boxCreateValid ( l_int32 x, l_int32 y, l_int32 w, l_int32 h );
extern BOX * boxCopy ( BOX *box );
extern BOX * boxClone ( BOX *box );
extern void boxDestroy ( BOX **pbox );
extern l_int32 boxGetGeometry ( BOX *box, l_int32 *px, l_int32 *py, l_int32 *pw, l_int32 *ph );
extern l_int32 boxSetGeometry ( BOX *box, l_int32 x, l_int32 y, l_int32 w, l_int32 h );
extern l_int32 boxGetSideLocation ( BOX *box, l_int32 side, l_int32 *ploc );
extern l_int32 boxGetRefcount ( BOX *box );
extern l_int32 boxChangeRefcount ( BOX *box, l_int32 delta );
extern l_int32 boxIsValid ( BOX *box, l_int32 *pvalid );
extern BOXA * boxaCreate ( l_int32 n );
extern BOXA * boxaCopy ( BOXA *boxa, l_int32 copyflag );
extern void boxaDestroy ( BOXA **pboxa );
extern l_int32 boxaAddBox ( BOXA *boxa, BOX *box, l_int32 copyflag );
extern l_int32 boxaExtendArray ( BOXA *boxa );
extern l_int32 boxaExtendArrayToSize ( BOXA *boxa, l_int32 size );
extern l_int32 boxaGetCount ( BOXA *boxa );
extern l_int32 boxaGetValidCount ( BOXA *boxa );
extern BOX * boxaGetBox ( BOXA *boxa, l_int32 index, l_int32 accessflag );
extern BOX * boxaGetValidBox ( BOXA *boxa, l_int32 index, l_int32 accessflag );
extern l_int32 boxaGetBoxGeometry ( BOXA *boxa, l_int32 index, l_int32 *px, l_int32 *py, l_int32 *pw, l_int32 *ph );
extern l_int32 boxaIsFull ( BOXA *boxa, l_int32 *pfull );
extern l_int32 boxaReplaceBox ( BOXA *boxa, l_int32 index, BOX *box );
extern l_int32 boxaInsertBox ( BOXA *boxa, l_int32 index, BOX *box );
extern l_int32 boxaRemoveBox ( BOXA *boxa, l_int32 index );
extern l_int32 boxaRemoveBoxAndSave ( BOXA *boxa, l_int32 index, BOX **pbox );
extern BOXA * boxaSaveValid ( BOXA *boxas, l_int32 copyflag );
extern l_int32 boxaInitFull ( BOXA *boxa, BOX *box );
extern l_int32 boxaClear ( BOXA *boxa );
extern BOXAA * boxaaCreate ( l_int32 n );
extern BOXAA * boxaaCopy ( BOXAA *baas, l_int32 copyflag );
extern void boxaaDestroy ( BOXAA **pbaa );
extern l_int32 boxaaAddBoxa ( BOXAA *baa, BOXA *ba, l_int32 copyflag );
extern l_int32 boxaaExtendArray ( BOXAA *baa );
extern l_int32 boxaaExtendArrayToSize ( BOXAA *baa, l_int32 size );
extern l_int32 boxaaGetCount ( BOXAA *baa );
extern l_int32 boxaaGetBoxCount ( BOXAA *baa );
extern BOXA * boxaaGetBoxa ( BOXAA *baa, l_int32 index, l_int32 accessflag );
extern BOX * boxaaGetBox ( BOXAA *baa, l_int32 iboxa, l_int32 ibox, l_int32 accessflag );
extern l_int32 boxaaInitFull ( BOXAA *baa, BOXA *boxa );
extern l_int32 boxaaExtendWithInit ( BOXAA *baa, l_int32 maxindex, BOXA *boxa );
extern l_int32 boxaaReplaceBoxa ( BOXAA *baa, l_int32 index, BOXA *boxa );
extern l_int32 boxaaInsertBoxa ( BOXAA *baa, l_int32 index, BOXA *boxa );
extern l_int32 boxaaRemoveBoxa ( BOXAA *baa, l_int32 index );
extern l_int32 boxaaAddBox ( BOXAA *baa, l_int32 index, BOX *box, l_int32 accessflag );
extern BOXAA * boxaaReadFromFiles ( const char *dirname, const char *substr, l_int32 first, l_int32 nfiles );
extern BOXAA * boxaaRead ( const char *filename );
extern BOXAA * boxaaReadStream ( FILE *fp );
extern l_int32 boxaaWrite ( const char *filename, BOXAA *baa );
extern l_int32 boxaaWriteStream ( FILE *fp, BOXAA *baa );
extern BOXA * boxaRead ( const char *filename );
extern BOXA * boxaReadStream ( FILE *fp );
extern BOXA * boxaReadMem ( const l_uint8 *data, size_t size );
extern l_int32 boxaWrite ( const char *filename, BOXA *boxa );
extern l_int32 boxaWriteStream ( FILE *fp, BOXA *boxa );
extern l_int32 boxaWriteMem ( l_uint8 **pdata, size_t *psize, BOXA *boxa );
extern l_int32 boxPrintStreamInfo ( FILE *fp, BOX *box );
extern l_int32 boxContains ( BOX *box1, BOX *box2, l_int32 *presult );
extern l_int32 boxIntersects ( BOX *box1, BOX *box2, l_int32 *presult );
extern BOXA * boxaContainedInBox ( BOXA *boxas, BOX *box );
extern BOXA * boxaIntersectsBox ( BOXA *boxas, BOX *box );
extern BOXA * boxaClipToBox ( BOXA *boxas, BOX *box );
extern BOXA * boxaCombineOverlaps ( BOXA *boxas );
extern BOX * boxOverlapRegion ( BOX *box1, BOX *box2 );
extern BOX * boxBoundingRegion ( BOX *box1, BOX *box2 );
extern l_int32 boxOverlapFraction ( BOX *box1, BOX *box2, l_float32 *pfract );
extern l_int32 boxOverlapArea ( BOX *box1, BOX *box2, l_int32 *parea );
extern BOXA * boxaHandleOverlaps ( BOXA *boxas, l_int32 op, l_int32 range, l_float32 min_overlap, l_float32 max_ratio, NUMA **pnamap );
extern l_int32 boxSeparationDistance ( BOX *box1, BOX *box2, l_int32 *ph_sep, l_int32 *pv_sep );
extern l_int32 boxContainsPt ( BOX *box, l_float32 x, l_float32 y, l_int32 *pcontains );
extern BOX * boxaGetNearestToPt ( BOXA *boxa, l_int32 x, l_int32 y );
extern l_int32 boxGetCenter ( BOX *box, l_float32 *pcx, l_float32 *pcy );
extern l_int32 boxIntersectByLine ( BOX *box, l_int32 x, l_int32 y, l_float32 slope, l_int32 *px1, l_int32 *py1, l_int32 *px2, l_int32 *py2, l_int32 *pn );
extern BOX * boxClipToRectangle ( BOX *box, l_int32 wi, l_int32 hi );
extern l_int32 boxClipToRectangleParams ( BOX *box, l_int32 w, l_int32 h, l_int32 *pxstart, l_int32 *pystart, l_int32 *pxend, l_int32 *pyend, l_int32 *pbw, l_int32 *pbh );
extern BOX * boxRelocateOneSide ( BOX *boxd, BOX *boxs, l_int32 loc, l_int32 sideflag );
extern BOX * boxAdjustSides ( BOX *boxd, BOX *boxs, l_int32 delleft, l_int32 delright, l_int32 deltop, l_int32 delbot );
extern BOXA * boxaSetSide ( BOXA *boxad, BOXA *boxas, l_int32 side, l_int32 val, l_int32 thresh );
extern BOXA * boxaAdjustWidthToTarget ( BOXA *boxad, BOXA *boxas, l_int32 sides, l_int32 target, l_int32 thresh );
extern BOXA * boxaAdjustHeightToTarget ( BOXA *boxad, BOXA *boxas, l_int32 sides, l_int32 target, l_int32 thresh );
extern l_int32 boxEqual ( BOX *box1, BOX *box2, l_int32 *psame );
extern l_int32 boxaEqual ( BOXA *boxa1, BOXA *boxa2, l_int32 maxdist, NUMA **pnaindex, l_int32 *psame );
extern l_int32 boxSimilar ( BOX *box1, BOX *box2, l_int32 leftdiff, l_int32 rightdiff, l_int32 topdiff, l_int32 botdiff, l_int32 *psimilar );
extern l_int32 boxaSimilar ( BOXA *boxa1, BOXA *boxa2, l_int32 leftdiff, l_int32 rightdiff, l_int32 topdiff, l_int32 botdiff, l_int32 debugflag, l_int32 *psimilar );
extern l_int32 boxaJoin ( BOXA *boxad, BOXA *boxas, l_int32 istart, l_int32 iend );
extern l_int32 boxaaJoin ( BOXAA *baad, BOXAA *baas, l_int32 istart, l_int32 iend );
extern l_int32 boxaSplitEvenOdd ( BOXA *boxa, l_int32 fillflag, BOXA **pboxae, BOXA **pboxao );
extern BOXA * boxaMergeEvenOdd ( BOXA *boxae, BOXA *boxao, l_int32 fillflag );
extern BOXA * boxaTransform ( BOXA *boxas, l_int32 shiftx, l_int32 shifty, l_float32 scalex, l_float32 scaley );
extern BOX * boxTransform ( BOX *box, l_int32 shiftx, l_int32 shifty, l_float32 scalex, l_float32 scaley );
extern BOXA * boxaTransformOrdered ( BOXA *boxas, l_int32 shiftx, l_int32 shifty, l_float32 scalex, l_float32 scaley, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 order );
extern BOX * boxTransformOrdered ( BOX *boxs, l_int32 shiftx, l_int32 shifty, l_float32 scalex, l_float32 scaley, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 order );
extern BOXA * boxaRotateOrth ( BOXA *boxas, l_int32 w, l_int32 h, l_int32 rotation );
extern BOX * boxRotateOrth ( BOX *box, l_int32 w, l_int32 h, l_int32 rotation );
extern BOXA * boxaSort ( BOXA *boxas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex );
extern BOXA * boxaBinSort ( BOXA *boxas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex );
extern BOXA * boxaSortByIndex ( BOXA *boxas, NUMA *naindex );
extern BOXAA * boxaSort2d ( BOXA *boxas, NUMAA **pnaad, l_int32 delta1, l_int32 delta2, l_int32 minh1 );
extern BOXAA * boxaSort2dByIndex ( BOXA *boxas, NUMAA *naa );
extern l_int32 boxaExtractAsNuma ( BOXA *boxa, NUMA **pnax, NUMA **pnay, NUMA **pnaw, NUMA **pnah, l_int32 keepinvalid );
extern l_int32 boxaExtractAsPta ( BOXA *boxa, PTA **pptal, PTA **pptat, PTA **pptar, PTA **pptab, l_int32 keepinvalid );
extern BOX * boxaGetRankSize ( BOXA *boxa, l_float32 fract );
extern BOX * boxaGetMedian ( BOXA *boxa );
extern l_int32 boxaGetAverageSize ( BOXA *boxa, l_float32 *pw, l_float32 *ph );
extern l_int32 boxaaGetExtent ( BOXAA *baa, l_int32 *pw, l_int32 *ph, BOX **pbox, BOXA **pboxa );
extern BOXA * boxaaFlattenToBoxa ( BOXAA *baa, NUMA **pnaindex, l_int32 copyflag );
extern BOXA * boxaaFlattenAligned ( BOXAA *baa, l_int32 num, BOX *fillerbox, l_int32 copyflag );
extern BOXAA * boxaEncapsulateAligned ( BOXA *boxa, l_int32 num, l_int32 copyflag );
extern l_int32 boxaaAlignBox ( BOXAA *baa, BOX *box, l_int32 delta, l_int32 *pindex );
extern PIX * pixMaskConnComp ( PIX *pixs, l_int32 connectivity, BOXA **pboxa );
extern PIX * pixMaskBoxa ( PIX *pixd, PIX *pixs, BOXA *boxa, l_int32 op );
extern PIX * pixPaintBoxa ( PIX *pixs, BOXA *boxa, l_uint32 val );
extern PIX * pixSetBlackOrWhiteBoxa ( PIX *pixs, BOXA *boxa, l_int32 op );
extern PIX * pixPaintBoxaRandom ( PIX *pixs, BOXA *boxa );
extern PIX * pixBlendBoxaRandom ( PIX *pixs, BOXA *boxa, l_float32 fract );
extern PIX * pixDrawBoxa ( PIX *pixs, BOXA *boxa, l_int32 width, l_uint32 val );
extern PIX * pixDrawBoxaRandom ( PIX *pixs, BOXA *boxa, l_int32 width );
extern PIX * boxaaDisplay ( BOXAA *baa, l_int32 linewba, l_int32 linewb, l_uint32 colorba, l_uint32 colorb, l_int32 w, l_int32 h );
extern BOXA * pixSplitIntoBoxa ( PIX *pixs, l_int32 minsum, l_int32 skipdist, l_int32 delta, l_int32 maxbg, l_int32 maxcomps, l_int32 remainder );
extern BOXA * pixSplitComponentIntoBoxa ( PIX *pix, BOX *box, l_int32 minsum, l_int32 skipdist, l_int32 delta, l_int32 maxbg, l_int32 maxcomps, l_int32 remainder );
extern BOXA * makeMosaicStrips ( l_int32 w, l_int32 h, l_int32 direction, l_int32 size );
extern l_int32 boxaCompareRegions ( BOXA *boxa1, BOXA *boxa2, l_int32 areathresh, l_int32 *pnsame, l_float32 *pdiffarea, l_float32 *pdiffxor, PIX **ppixdb );
extern BOXA * boxaSelectRange ( BOXA *boxas, l_int32 first, l_int32 last, l_int32 copyflag );
extern BOXAA * boxaaSelectRange ( BOXAA *baas, l_int32 first, l_int32 last, l_int32 copyflag );
extern BOXA * boxaSelectBySize ( BOXA *boxas, l_int32 width, l_int32 height, l_int32 type, l_int32 relation, l_int32 *pchanged );
extern NUMA * boxaMakeSizeIndicator ( BOXA *boxa, l_int32 width, l_int32 height, l_int32 type, l_int32 relation );
extern BOXA * boxaSelectByArea ( BOXA *boxas, l_int32 area, l_int32 relation, l_int32 *pchanged );
extern NUMA * boxaMakeAreaIndicator ( BOXA *boxa, l_int32 area, l_int32 relation );
extern BOXA * boxaSelectWithIndicator ( BOXA *boxas, NUMA *na, l_int32 *pchanged );
extern BOXA * boxaPermutePseudorandom ( BOXA *boxas );
extern BOXA * boxaPermuteRandom ( BOXA *boxad, BOXA *boxas );
extern l_int32 boxaSwapBoxes ( BOXA *boxa, l_int32 i, l_int32 j );
extern PTA * boxaConvertToPta ( BOXA *boxa, l_int32 ncorners );
extern BOXA * ptaConvertToBoxa ( PTA *pta, l_int32 ncorners );
extern BOXA * boxaSmoothSequence ( BOXA *boxas, l_float32 factor, l_int32 subflag, l_int32 maxdiff, l_int32 debug );
extern BOXA * boxaLinearFit ( BOXA *boxas, l_float32 factor, l_int32 debug );
extern BOXA * boxaModifyWithBoxa ( BOXA *boxas, BOXA *boxam, l_int32 subflag, l_int32 maxdiff );
extern BOXA * boxaConstrainSize ( BOXA *boxas, l_int32 width, l_int32 widthflag, l_int32 height, l_int32 heightflag );
extern BOXA * boxaReconcileEvenOddHeight ( BOXA *boxas, l_int32 sides, l_int32 delh, l_int32 op, l_float32 factor );
extern l_int32 boxaPlotSides ( BOXA *boxa, const char *plotname, NUMA **pnal, NUMA **pnat, NUMA **pnar, NUMA **pnab, l_int32 outformat );
extern l_int32 boxaGetExtent ( BOXA *boxa, l_int32 *pw, l_int32 *ph, BOX **pbox );
extern l_int32 boxaGetCoverage ( BOXA *boxa, l_int32 wc, l_int32 hc, l_int32 exactflag, l_float32 *pfract );
extern l_int32 boxaaSizeRange ( BOXAA *baa, l_int32 *pminw, l_int32 *pminh, l_int32 *pmaxw, l_int32 *pmaxh );
extern l_int32 boxaSizeRange ( BOXA *boxa, l_int32 *pminw, l_int32 *pminh, l_int32 *pmaxw, l_int32 *pmaxh );
extern l_int32 boxaLocationRange ( BOXA *boxa, l_int32 *pminx, l_int32 *pminy, l_int32 *pmaxx, l_int32 *pmaxy );
extern l_int32 boxaGetArea ( BOXA *boxa, l_int32 *parea );
extern PIX * boxaDisplayTiled ( BOXA *boxas, PIXA *pixa, l_int32 maxwidth, l_int32 linewidth, l_float32 scalefactor, l_int32 background, l_int32 spacing, l_int32 border, const char *fontdir );
extern L_BYTEA * l_byteaCreate ( size_t nbytes );
extern L_BYTEA * l_byteaInitFromMem ( l_uint8 *data, size_t size );
extern L_BYTEA * l_byteaInitFromFile ( const char *fname );
extern L_BYTEA * l_byteaInitFromStream ( FILE *fp );
extern L_BYTEA * l_byteaCopy ( L_BYTEA *bas, l_int32 copyflag );
extern void l_byteaDestroy ( L_BYTEA **pba );
extern size_t l_byteaGetSize ( L_BYTEA *ba );
extern l_uint8 * l_byteaGetData ( L_BYTEA *ba, size_t *psize );
extern l_uint8 * l_byteaCopyData ( L_BYTEA *ba, size_t *psize );
extern l_int32 l_byteaAppendData ( L_BYTEA *ba, l_uint8 *newdata, size_t newbytes );
extern l_int32 l_byteaAppendString ( L_BYTEA *ba, char *str );
extern l_int32 l_byteaJoin ( L_BYTEA *ba1, L_BYTEA **pba2 );
extern l_int32 l_byteaSplit ( L_BYTEA *ba1, size_t splitloc, L_BYTEA **pba2 );
extern l_int32 l_byteaFindEachSequence ( L_BYTEA *ba, l_uint8 *sequence, l_int32 seqlen, L_DNA **pda );
extern l_int32 l_byteaWrite ( const char *fname, L_BYTEA *ba, size_t startloc, size_t endloc );
extern l_int32 l_byteaWriteStream ( FILE *fp, L_BYTEA *ba, size_t startloc, size_t endloc );
extern CCBORDA * ccbaCreate ( PIX *pixs, l_int32 n );
extern void ccbaDestroy ( CCBORDA **pccba );
extern CCBORD * ccbCreate ( PIX *pixs );
extern void ccbDestroy ( CCBORD **pccb );
extern l_int32 ccbaAddCcb ( CCBORDA *ccba, CCBORD *ccb );
extern l_int32 ccbaGetCount ( CCBORDA *ccba );
extern CCBORD * ccbaGetCcb ( CCBORDA *ccba, l_int32 index );
extern CCBORDA * pixGetAllCCBorders ( PIX *pixs );
extern CCBORD * pixGetCCBorders ( PIX *pixs, BOX *box );
extern PTAA * pixGetOuterBordersPtaa ( PIX *pixs );
extern PTA * pixGetOuterBorderPta ( PIX *pixs, BOX *box );
extern l_int32 pixGetOuterBorder ( CCBORD *ccb, PIX *pixs, BOX *box );
extern l_int32 pixGetHoleBorder ( CCBORD *ccb, PIX *pixs, BOX *box, l_int32 xs, l_int32 ys );
extern l_int32 findNextBorderPixel ( l_int32 w, l_int32 h, l_uint32 *data, l_int32 wpl, l_int32 px, l_int32 py, l_int32 *pqpos, l_int32 *pnpx, l_int32 *pnpy );
extern void locateOutsideSeedPixel ( l_int32 fpx, l_int32 fpy, l_int32 spx, l_int32 spy, l_int32 *pxs, l_int32 *pys );
extern l_int32 ccbaGenerateGlobalLocs ( CCBORDA *ccba );
extern l_int32 ccbaGenerateStepChains ( CCBORDA *ccba );
extern l_int32 ccbaStepChainsToPixCoords ( CCBORDA *ccba, l_int32 coordtype );
extern l_int32 ccbaGenerateSPGlobalLocs ( CCBORDA *ccba, l_int32 ptsflag );
extern l_int32 ccbaGenerateSinglePath ( CCBORDA *ccba );
extern PTA * getCutPathForHole ( PIX *pix, PTA *pta, BOX *boxinner, l_int32 *pdir, l_int32 *plen );
extern PIX * ccbaDisplayBorder ( CCBORDA *ccba );
extern PIX * ccbaDisplaySPBorder ( CCBORDA *ccba );
extern PIX * ccbaDisplayImage1 ( CCBORDA *ccba );
extern PIX * ccbaDisplayImage2 ( CCBORDA *ccba );
extern l_int32 ccbaWrite ( const char *filename, CCBORDA *ccba );
extern l_int32 ccbaWriteStream ( FILE *fp, CCBORDA *ccba );
extern CCBORDA * ccbaRead ( const char *filename );
extern CCBORDA * ccbaReadStream ( FILE *fp );
extern l_int32 ccbaWriteSVG ( const char *filename, CCBORDA *ccba );
extern char * ccbaWriteSVGString ( const char *filename, CCBORDA *ccba );
extern PIX * pixThin ( PIX *pixs, l_int32 type, l_int32 connectivity, l_int32 maxiters );
extern PIX * pixThinGeneral ( PIX *pixs, l_int32 type, SELA *sela, l_int32 maxiters );
extern PIX * pixThinExamples ( PIX *pixs, l_int32 type, l_int32 index, l_int32 maxiters, const char *selfile );
extern l_int32 jbCorrelation ( const char *dirin, l_float32 thresh, l_float32 weight, l_int32 components, const char *rootname, l_int32 firstpage, l_int32 npages, l_int32 renderflag );
extern l_int32 jbRankHaus ( const char *dirin, l_int32 size, l_float32 rank, l_int32 components, const char *rootname, l_int32 firstpage, l_int32 npages, l_int32 renderflag );
extern JBCLASSER * jbWordsInTextlines ( const char *dirin, l_int32 reduction, l_int32 maxwidth, l_int32 maxheight, l_float32 thresh, l_float32 weight, NUMA **pnatl, l_int32 firstpage, l_int32 npages );
extern l_int32 pixGetWordsInTextlines ( PIX *pixs, l_int32 reduction, l_int32 minwidth, l_int32 minheight, l_int32 maxwidth, l_int32 maxheight, BOXA **pboxad, PIXA **ppixad, NUMA **pnai );
extern l_int32 pixGetWordBoxesInTextlines ( PIX *pixs, l_int32 reduction, l_int32 minwidth, l_int32 minheight, l_int32 maxwidth, l_int32 maxheight, BOXA **pboxad, NUMA **pnai );
extern NUMAA * boxaExtractSortedPattern ( BOXA *boxa, NUMA *na );
extern l_int32 numaaCompareImagesByBoxes ( NUMAA *naa1, NUMAA *naa2, l_int32 nperline, l_int32 nreq, l_int32 maxshiftx, l_int32 maxshifty, l_int32 delx, l_int32 dely, l_int32 *psame, l_int32 debugflag );
extern l_int32 pixColorContent ( PIX *pixs, l_int32 rwhite, l_int32 gwhite, l_int32 bwhite, l_int32 mingray, PIX **ppixr, PIX **ppixg, PIX **ppixb );
extern PIX * pixColorMagnitude ( PIX *pixs, l_int32 rwhite, l_int32 gwhite, l_int32 bwhite, l_int32 type );
extern PIX * pixMaskOverColorPixels ( PIX *pixs, l_int32 threshdiff, l_int32 mindist );
extern l_int32 pixColorFraction ( PIX *pixs, l_int32 darkthresh, l_int32 lightthresh, l_int32 diffthresh, l_int32 factor, l_float32 *ppixfract, l_float32 *pcolorfract );
extern l_int32 pixNumSignificantGrayColors ( PIX *pixs, l_int32 darkthresh, l_int32 lightthresh, l_float32 minfract, l_int32 factor, l_int32 *pncolors );
extern l_int32 pixColorsForQuantization ( PIX *pixs, l_int32 thresh, l_int32 *pncolors, l_int32 *piscolor, l_int32 debug );
extern l_int32 pixNumColors ( PIX *pixs, l_int32 factor, l_int32 *pncolors );
extern l_int32 pixGetMostPopulatedColors ( PIX *pixs, l_int32 sigbits, l_int32 factor, l_int32 ncolors, l_uint32 **parray, PIXCMAP **pcmap );
extern PIX * pixSimpleColorQuantize ( PIX *pixs, l_int32 sigbits, l_int32 factor, l_int32 ncolors );
extern NUMA * pixGetRGBHistogram ( PIX *pixs, l_int32 sigbits, l_int32 factor );
extern l_int32 makeRGBIndexTables ( l_uint32 **prtab, l_uint32 **pgtab, l_uint32 **pbtab, l_int32 sigbits );
extern l_int32 getRGBFromIndex ( l_uint32 index, l_int32 sigbits, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern l_int32 pixHasHighlightRed ( PIX *pixs, l_int32 factor, l_float32 fract, l_float32 fthresh, l_int32 *phasred, l_float32 *pratio, PIX **ppixdb );
extern PIX * pixColorGrayRegions ( PIX *pixs, BOXA *boxa, l_int32 type, l_int32 thresh, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixColorGray ( PIX *pixs, BOX *box, l_int32 type, l_int32 thresh, l_int32 rval, l_int32 gval, l_int32 bval );
extern PIX * pixSnapColor ( PIX *pixd, PIX *pixs, l_uint32 srcval, l_uint32 dstval, l_int32 diff );
extern PIX * pixSnapColorCmap ( PIX *pixd, PIX *pixs, l_uint32 srcval, l_uint32 dstval, l_int32 diff );
extern PIX * pixLinearMapToTargetColor ( PIX *pixd, PIX *pixs, l_uint32 srcval, l_uint32 dstval );
extern l_int32 pixelLinearMapToTargetColor ( l_uint32 scolor, l_uint32 srcmap, l_uint32 dstmap, l_uint32 *pdcolor );
extern PIX * pixShiftByComponent ( PIX *pixd, PIX *pixs, l_uint32 srcval, l_uint32 dstval );
extern l_int32 pixelShiftByComponent ( l_int32 rval, l_int32 gval, l_int32 bval, l_uint32 srcval, l_uint32 dstval, l_uint32 *ppixel );
extern l_int32 pixelFractionalShift ( l_int32 rval, l_int32 gval, l_int32 bval, l_float32 fraction, l_uint32 *ppixel );
extern PIXCMAP * pixcmapCreate ( l_int32 depth );
extern PIXCMAP * pixcmapCreateRandom ( l_int32 depth, l_int32 hasblack, l_int32 haswhite );
extern PIXCMAP * pixcmapCreateLinear ( l_int32 d, l_int32 nlevels );
extern PIXCMAP * pixcmapCopy ( PIXCMAP *cmaps );
extern void pixcmapDestroy ( PIXCMAP **pcmap );
extern l_int32 pixcmapAddColor ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixcmapAddRGBA ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 aval );
extern l_int32 pixcmapAddNewColor ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pindex );
extern l_int32 pixcmapAddNearestColor ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pindex );
extern l_int32 pixcmapUsableColor ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pusable );
extern l_int32 pixcmapAddBlackOrWhite ( PIXCMAP *cmap, l_int32 color, l_int32 *pindex );
extern l_int32 pixcmapSetBlackAndWhite ( PIXCMAP *cmap, l_int32 setblack, l_int32 setwhite );
extern l_int32 pixcmapGetCount ( PIXCMAP *cmap );
extern l_int32 pixcmapGetFreeCount ( PIXCMAP *cmap );
extern l_int32 pixcmapGetDepth ( PIXCMAP *cmap );
extern l_int32 pixcmapGetMinDepth ( PIXCMAP *cmap, l_int32 *pmindepth );
extern l_int32 pixcmapClear ( PIXCMAP *cmap );
extern l_int32 pixcmapGetColor ( PIXCMAP *cmap, l_int32 index, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern l_int32 pixcmapGetColor32 ( PIXCMAP *cmap, l_int32 index, l_uint32 *pval32 );
extern l_int32 pixcmapGetRGBA ( PIXCMAP *cmap, l_int32 index, l_int32 *prval, l_int32 *pgval, l_int32 *pbval, l_int32 *paval );
extern l_int32 pixcmapGetRGBA32 ( PIXCMAP *cmap, l_int32 index, l_uint32 *pval32 );
extern l_int32 pixcmapResetColor ( PIXCMAP *cmap, l_int32 index, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixcmapGetIndex ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pindex );
extern l_int32 pixcmapHasColor ( PIXCMAP *cmap, l_int32 *pcolor );
extern l_int32 pixcmapIsOpaque ( PIXCMAP *cmap, l_int32 *popaque );
extern l_int32 pixcmapCountGrayColors ( PIXCMAP *cmap, l_int32 *pngray );
extern l_int32 pixcmapGetRankIntensity ( PIXCMAP *cmap, l_float32 rankval, l_int32 *pindex );
extern l_int32 pixcmapGetNearestIndex ( PIXCMAP *cmap, l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pindex );
extern l_int32 pixcmapGetNearestGrayIndex ( PIXCMAP *cmap, l_int32 val, l_int32 *pindex );
extern l_int32 pixcmapGetComponentRange ( PIXCMAP *cmap, l_int32 color, l_int32 *pminval, l_int32 *pmaxval );
extern l_int32 pixcmapGetExtremeValue ( PIXCMAP *cmap, l_int32 type, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern PIXCMAP * pixcmapGrayToColor ( l_uint32 color );
extern PIXCMAP * pixcmapColorToGray ( PIXCMAP *cmaps, l_float32 rwt, l_float32 gwt, l_float32 bwt );
extern PIXCMAP * pixcmapReadStream ( FILE *fp );
extern l_int32 pixcmapWriteStream ( FILE *fp, PIXCMAP *cmap );
extern l_int32 pixcmapToArrays ( PIXCMAP *cmap, l_int32 **prmap, l_int32 **pgmap, l_int32 **pbmap, l_int32 **pamap );
extern l_int32 pixcmapToRGBTable ( PIXCMAP *cmap, l_uint32 **ptab, l_int32 *pncolors );
extern l_int32 pixcmapSerializeToMemory ( PIXCMAP *cmap, l_int32 cpc, l_int32 *pncolors, l_uint8 **pdata );
extern PIXCMAP * pixcmapDeserializeFromMemory ( l_uint8 *data, l_int32 cpc, l_int32 ncolors );
extern char * pixcmapConvertToHex ( l_uint8 *data, l_int32 ncolors );
extern l_int32 pixcmapGammaTRC ( PIXCMAP *cmap, l_float32 gamma, l_int32 minval, l_int32 maxval );
extern l_int32 pixcmapContrastTRC ( PIXCMAP *cmap, l_float32 factor );
extern l_int32 pixcmapShiftIntensity ( PIXCMAP *cmap, l_float32 fraction );
extern l_int32 pixcmapShiftByComponent ( PIXCMAP *cmap, l_uint32 srcval, l_uint32 dstval );
extern PIX * pixColorMorph ( PIX *pixs, l_int32 type, l_int32 hsize, l_int32 vsize );
extern PIX * pixOctreeColorQuant ( PIX *pixs, l_int32 colors, l_int32 ditherflag );
extern PIX * pixOctreeColorQuantGeneral ( PIX *pixs, l_int32 colors, l_int32 ditherflag, l_float32 validthresh, l_float32 colorthresh );
extern l_int32 makeRGBToIndexTables ( l_uint32 **prtab, l_uint32 **pgtab, l_uint32 **pbtab, l_int32 cqlevels );
extern void getOctcubeIndexFromRGB ( l_int32 rval, l_int32 gval, l_int32 bval, l_uint32 *rtab, l_uint32 *gtab, l_uint32 *btab, l_uint32 *pindex );
extern PIX * pixOctreeQuantByPopulation ( PIX *pixs, l_int32 level, l_int32 ditherflag );
extern PIX * pixOctreeQuantNumColors ( PIX *pixs, l_int32 maxcolors, l_int32 subsample );
extern PIX * pixOctcubeQuantMixedWithGray ( PIX *pixs, l_int32 depth, l_int32 graylevels, l_int32 delta );
extern PIX * pixFixedOctcubeQuant256 ( PIX *pixs, l_int32 ditherflag );
extern PIX * pixFewColorsOctcubeQuant1 ( PIX *pixs, l_int32 level );
extern PIX * pixFewColorsOctcubeQuant2 ( PIX *pixs, l_int32 level, NUMA *na, l_int32 ncolors, l_int32 *pnerrors );
extern PIX * pixFewColorsOctcubeQuantMixed ( PIX *pixs, l_int32 level, l_int32 darkthresh, l_int32 lightthresh, l_int32 diffthresh, l_float32 minfract, l_int32 maxspan );
extern PIX * pixFixedOctcubeQuantGenRGB ( PIX *pixs, l_int32 level );
extern PIX * pixQuantFromCmap ( PIX *pixs, PIXCMAP *cmap, l_int32 mindepth, l_int32 level, l_int32 metric );
extern PIX * pixOctcubeQuantFromCmap ( PIX *pixs, PIXCMAP *cmap, l_int32 mindepth, l_int32 level, l_int32 metric );
extern PIX * pixOctcubeQuantFromCmapLUT ( PIX *pixs, PIXCMAP *cmap, l_int32 mindepth, l_int32 *cmaptab, l_uint32 *rtab, l_uint32 *gtab, l_uint32 *btab );
extern NUMA * pixOctcubeHistogram ( PIX *pixs, l_int32 level, l_int32 *pncolors );
extern l_int32 * pixcmapToOctcubeLUT ( PIXCMAP *cmap, l_int32 level, l_int32 metric );
extern l_int32 pixRemoveUnusedColors ( PIX *pixs );
extern l_int32 pixNumberOccupiedOctcubes ( PIX *pix, l_int32 level, l_int32 mincount, l_float32 minfract, l_int32 *pncolors );
extern PIX * pixMedianCutQuant ( PIX *pixs, l_int32 ditherflag );
extern PIX * pixMedianCutQuantGeneral ( PIX *pixs, l_int32 ditherflag, l_int32 outdepth, l_int32 maxcolors, l_int32 sigbits, l_int32 maxsub, l_int32 checkbw );
extern PIX * pixMedianCutQuantMixed ( PIX *pixs, l_int32 ncolor, l_int32 ngray, l_int32 darkthresh, l_int32 lightthresh, l_int32 diffthresh );
extern PIX * pixFewColorsMedianCutQuantMixed ( PIX *pixs, l_int32 ncolor, l_int32 ngray, l_int32 maxncolors, l_int32 darkthresh, l_int32 lightthresh, l_int32 diffthresh );
extern l_int32 * pixMedianCutHisto ( PIX *pixs, l_int32 sigbits, l_int32 subsample );
extern PIX * pixColorSegment ( PIX *pixs, l_int32 maxdist, l_int32 maxcolors, l_int32 selsize, l_int32 finalcolors );
extern PIX * pixColorSegmentCluster ( PIX *pixs, l_int32 maxdist, l_int32 maxcolors );
extern l_int32 pixAssignToNearestColor ( PIX *pixd, PIX *pixs, PIX *pixm, l_int32 level, l_int32 *countarray );
extern l_int32 pixColorSegmentClean ( PIX *pixs, l_int32 selsize, l_int32 *countarray );
extern l_int32 pixColorSegmentRemoveColors ( PIX *pixd, PIX *pixs, l_int32 finalcolors );
extern PIX * pixConvertRGBToHSV ( PIX *pixd, PIX *pixs );
extern PIX * pixConvertHSVToRGB ( PIX *pixd, PIX *pixs );
extern l_int32 convertRGBToHSV ( l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *phval, l_int32 *psval, l_int32 *pvval );
extern l_int32 convertHSVToRGB ( l_int32 hval, l_int32 sval, l_int32 vval, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern l_int32 pixcmapConvertRGBToHSV ( PIXCMAP *cmap );
extern l_int32 pixcmapConvertHSVToRGB ( PIXCMAP *cmap );
extern PIX * pixConvertRGBToHue ( PIX *pixs );
extern PIX * pixConvertRGBToSaturation ( PIX *pixs );
extern PIX * pixConvertRGBToValue ( PIX *pixs );
extern PIX * pixMakeRangeMaskHS ( PIX *pixs, l_int32 huecenter, l_int32 huehw, l_int32 satcenter, l_int32 sathw, l_int32 regionflag );
extern PIX * pixMakeRangeMaskHV ( PIX *pixs, l_int32 huecenter, l_int32 huehw, l_int32 valcenter, l_int32 valhw, l_int32 regionflag );
extern PIX * pixMakeRangeMaskSV ( PIX *pixs, l_int32 satcenter, l_int32 sathw, l_int32 valcenter, l_int32 valhw, l_int32 regionflag );
extern PIX * pixMakeHistoHS ( PIX *pixs, l_int32 factor, NUMA **pnahue, NUMA **pnasat );
extern PIX * pixMakeHistoHV ( PIX *pixs, l_int32 factor, NUMA **pnahue, NUMA **pnaval );
extern PIX * pixMakeHistoSV ( PIX *pixs, l_int32 factor, NUMA **pnasat, NUMA **pnaval );
extern l_int32 pixFindHistoPeaksHSV ( PIX *pixs, l_int32 type, l_int32 width, l_int32 height, l_int32 npeaks, l_float32 erasefactor, PTA **ppta, NUMA **pnatot, PIXA **ppixa );
extern PIX * displayHSVColorRange ( l_int32 hval, l_int32 sval, l_int32 vval, l_int32 huehw, l_int32 sathw, l_int32 nsamp, l_int32 factor );
extern PIX * pixConvertRGBToYUV ( PIX *pixd, PIX *pixs );
extern PIX * pixConvertYUVToRGB ( PIX *pixd, PIX *pixs );
extern l_int32 convertRGBToYUV ( l_int32 rval, l_int32 gval, l_int32 bval, l_int32 *pyval, l_int32 *puval, l_int32 *pvval );
extern l_int32 convertYUVToRGB ( l_int32 yval, l_int32 uval, l_int32 vval, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern l_int32 pixcmapConvertRGBToYUV ( PIXCMAP *cmap );
extern l_int32 pixcmapConvertYUVToRGB ( PIXCMAP *cmap );
extern l_int32 pixEqual ( PIX *pix1, PIX *pix2, l_int32 *psame );
extern l_int32 pixEqualWithAlpha ( PIX *pix1, PIX *pix2, l_int32 use_alpha, l_int32 *psame );
extern l_int32 pixEqualWithCmap ( PIX *pix1, PIX *pix2, l_int32 *psame );
extern l_int32 pixUsesCmapColor ( PIX *pixs, l_int32 *pcolor );
extern l_int32 pixCorrelationBinary ( PIX *pix1, PIX *pix2, l_float32 *pval );
extern PIX * pixDisplayDiffBinary ( PIX *pix1, PIX *pix2 );
extern l_int32 pixCompareBinary ( PIX *pix1, PIX *pix2, l_int32 comptype, l_float32 *pfract, PIX **ppixdiff );
extern l_int32 pixCompareGrayOrRGB ( PIX *pix1, PIX *pix2, l_int32 comptype, l_int32 plottype, l_int32 *psame, l_float32 *pdiff, l_float32 *prmsdiff, PIX **ppixdiff );
extern l_int32 pixCompareGray ( PIX *pix1, PIX *pix2, l_int32 comptype, l_int32 plottype, l_int32 *psame, l_float32 *pdiff, l_float32 *prmsdiff, PIX **ppixdiff );
extern l_int32 pixCompareRGB ( PIX *pix1, PIX *pix2, l_int32 comptype, l_int32 plottype, l_int32 *psame, l_float32 *pdiff, l_float32 *prmsdiff, PIX **ppixdiff );
extern l_int32 pixCompareTiled ( PIX *pix1, PIX *pix2, l_int32 sx, l_int32 sy, l_int32 type, PIX **ppixdiff );
extern NUMA * pixCompareRankDifference ( PIX *pix1, PIX *pix2, l_int32 factor );
extern l_int32 pixTestForSimilarity ( PIX *pix1, PIX *pix2, l_int32 factor, l_int32 mindiff, l_float32 maxfract, l_float32 maxave, l_int32 *psimilar, l_int32 printstats );
extern l_int32 pixGetDifferenceStats ( PIX *pix1, PIX *pix2, l_int32 factor, l_int32 mindiff, l_float32 *pfractdiff, l_float32 *pavediff, l_int32 printstats );
extern NUMA * pixGetDifferenceHistogram ( PIX *pix1, PIX *pix2, l_int32 factor );
extern l_int32 pixGetPerceptualDiff ( PIX *pixs1, PIX *pixs2, l_int32 sampling, l_int32 dilation, l_int32 mindiff, l_float32 *pfract, PIX **ppixdiff1, PIX **ppixdiff2 );
extern l_int32 pixGetPSNR ( PIX *pix1, PIX *pix2, l_int32 factor, l_float32 *ppsnr );
extern l_int32 pixCompareWithTranslation ( PIX *pix1, PIX *pix2, l_int32 thresh, l_int32 *pdelx, l_int32 *pdely, l_float32 *pscore, l_int32 debugflag );
extern l_int32 pixBestCorrelation ( PIX *pix1, PIX *pix2, l_int32 area1, l_int32 area2, l_int32 etransx, l_int32 etransy, l_int32 maxshift, l_int32 *tab8, l_int32 *pdelx, l_int32 *pdely, l_float32 *pscore, l_int32 debugflag );
extern BOXA * pixConnComp ( PIX *pixs, PIXA **ppixa, l_int32 connectivity );
extern BOXA * pixConnCompPixa ( PIX *pixs, PIXA **ppixa, l_int32 connectivity );
extern BOXA * pixConnCompBB ( PIX *pixs, l_int32 connectivity );
extern l_int32 pixCountConnComp ( PIX *pixs, l_int32 connectivity, l_int32 *pcount );
extern l_int32 nextOnPixelInRaster ( PIX *pixs, l_int32 xstart, l_int32 ystart, l_int32 *px, l_int32 *py );
extern l_int32 nextOnPixelInRasterLow ( l_uint32 *data, l_int32 w, l_int32 h, l_int32 wpl, l_int32 xstart, l_int32 ystart, l_int32 *px, l_int32 *py );
extern BOX * pixSeedfillBB ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y, l_int32 connectivity );
extern BOX * pixSeedfill4BB ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y );
extern BOX * pixSeedfill8BB ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y );
extern l_int32 pixSeedfill ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y, l_int32 connectivity );
extern l_int32 pixSeedfill4 ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y );
extern l_int32 pixSeedfill8 ( PIX *pixs, L_STACK *stack, l_int32 x, l_int32 y );
extern l_int32 convertFilesTo1bpp ( const char *dirin, const char *substr, l_int32 upscaling, l_int32 thresh, l_int32 firstpage, l_int32 npages, const char *dirout, l_int32 outformat );
extern PIX * pixBlockconv ( PIX *pix, l_int32 wc, l_int32 hc );
extern PIX * pixBlockconvGray ( PIX *pixs, PIX *pixacc, l_int32 wc, l_int32 hc );
extern PIX * pixBlockconvAccum ( PIX *pixs );
extern PIX * pixBlockconvGrayUnnormalized ( PIX *pixs, l_int32 wc, l_int32 hc );
extern PIX * pixBlockconvTiled ( PIX *pix, l_int32 wc, l_int32 hc, l_int32 nx, l_int32 ny );
extern PIX * pixBlockconvGrayTile ( PIX *pixs, PIX *pixacc, l_int32 wc, l_int32 hc );
extern l_int32 pixWindowedStats ( PIX *pixs, l_int32 wc, l_int32 hc, l_int32 hasborder, PIX **ppixm, PIX **ppixms, FPIX **pfpixv, FPIX **pfpixrv );
extern PIX * pixWindowedMean ( PIX *pixs, l_int32 wc, l_int32 hc, l_int32 hasborder, l_int32 normflag );
extern PIX * pixWindowedMeanSquare ( PIX *pixs, l_int32 wc, l_int32 hc, l_int32 hasborder );
extern l_int32 pixWindowedVariance ( PIX *pixm, PIX *pixms, FPIX **pfpixv, FPIX **pfpixrv );
extern DPIX * pixMeanSquareAccum ( PIX *pixs );
extern PIX * pixBlockrank ( PIX *pixs, PIX *pixacc, l_int32 wc, l_int32 hc, l_float32 rank );
extern PIX * pixBlocksum ( PIX *pixs, PIX *pixacc, l_int32 wc, l_int32 hc );
extern PIX * pixCensusTransform ( PIX *pixs, l_int32 halfsize, PIX *pixacc );
extern PIX * pixConvolve ( PIX *pixs, L_KERNEL *kel, l_int32 outdepth, l_int32 normflag );
extern PIX * pixConvolveSep ( PIX *pixs, L_KERNEL *kelx, L_KERNEL *kely, l_int32 outdepth, l_int32 normflag );
extern PIX * pixConvolveRGB ( PIX *pixs, L_KERNEL *kel );
extern PIX * pixConvolveRGBSep ( PIX *pixs, L_KERNEL *kelx, L_KERNEL *kely );
extern FPIX * fpixConvolve ( FPIX *fpixs, L_KERNEL *kel, l_int32 normflag );
extern FPIX * fpixConvolveSep ( FPIX *fpixs, L_KERNEL *kelx, L_KERNEL *kely, l_int32 normflag );
extern PIX * pixConvolveWithBias ( PIX *pixs, L_KERNEL *kel1, L_KERNEL *kel2, l_int32 force8, l_int32 *pbias );
extern void l_setConvolveSampling ( l_int32 xfact, l_int32 yfact );
extern PIX * pixAddGaussianNoise ( PIX *pixs, l_float32 stdev );
extern l_float32 gaussDistribSampling (  );
extern void blockconvLow ( l_uint32 *data, l_int32 w, l_int32 h, l_int32 wpl, l_uint32 *dataa, l_int32 wpla, l_int32 wc, l_int32 hc );
extern void blockconvAccumLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 d, l_int32 wpls );
extern void blocksumLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpl, l_uint32 *dataa, l_int32 wpla, l_int32 wc, l_int32 hc );
extern l_int32 pixCorrelationScore ( PIX *pix1, PIX *pix2, l_int32 area1, l_int32 area2, l_float32 delx, l_float32 dely, l_int32 maxdiffw, l_int32 maxdiffh, l_int32 *tab, l_float32 *pscore );
extern l_int32 pixCorrelationScoreThresholded ( PIX *pix1, PIX *pix2, l_int32 area1, l_int32 area2, l_float32 delx, l_float32 dely, l_int32 maxdiffw, l_int32 maxdiffh, l_int32 *tab, l_int32 *downcount, l_float32 score_threshold );
extern l_int32 pixCorrelationScoreSimple ( PIX *pix1, PIX *pix2, l_int32 area1, l_int32 area2, l_float32 delx, l_float32 dely, l_int32 maxdiffw, l_int32 maxdiffh, l_int32 *tab, l_float32 *pscore );
extern l_int32 pixCorrelationScoreShifted ( PIX *pix1, PIX *pix2, l_int32 area1, l_int32 area2, l_int32 delx, l_int32 dely, l_int32 *tab, l_float32 *pscore );
extern L_DEWARP * dewarpCreate ( PIX *pixs, l_int32 pageno );
extern L_DEWARP * dewarpCreateRef ( l_int32 pageno, l_int32 refpage );
extern void dewarpDestroy ( L_DEWARP **pdew );
extern L_DEWARPA * dewarpaCreate ( l_int32 nptrs, l_int32 sampling, l_int32 redfactor, l_int32 minlines, l_int32 maxdist );
extern L_DEWARPA * dewarpaCreateFromPixacomp ( PIXAC *pixac, l_int32 useboth, l_int32 sampling, l_int32 minlines, l_int32 maxdist );
extern void dewarpaDestroy ( L_DEWARPA **pdewa );
extern l_int32 dewarpaDestroyDewarp ( L_DEWARPA *dewa, l_int32 pageno );
extern l_int32 dewarpaInsertDewarp ( L_DEWARPA *dewa, L_DEWARP *dew );
extern L_DEWARP * dewarpaGetDewarp ( L_DEWARPA *dewa, l_int32 index );
extern l_int32 dewarpaSetCurvatures ( L_DEWARPA *dewa, l_int32 max_linecurv, l_int32 min_diff_linecurv, l_int32 max_diff_linecurv, l_int32 max_edgecurv, l_int32 max_diff_edgecurv, l_int32 max_edgeslope );
extern l_int32 dewarpaUseBothArrays ( L_DEWARPA *dewa, l_int32 useboth );
extern l_int32 dewarpaSetMaxDistance ( L_DEWARPA *dewa, l_int32 maxdist );
extern L_DEWARP * dewarpRead ( const char *filename );
extern L_DEWARP * dewarpReadStream ( FILE *fp );
extern l_int32 dewarpWrite ( const char *filename, L_DEWARP *dew );
extern l_int32 dewarpWriteStream ( FILE *fp, L_DEWARP *dew );
extern L_DEWARPA * dewarpaRead ( const char *filename );
extern L_DEWARPA * dewarpaReadStream ( FILE *fp );
extern l_int32 dewarpaWrite ( const char *filename, L_DEWARPA *dewa );
extern l_int32 dewarpaWriteStream ( FILE *fp, L_DEWARPA *dewa );
extern l_int32 dewarpBuildPageModel ( L_DEWARP *dew, const char *debugfile );
extern l_int32 dewarpFindVertDisparity ( L_DEWARP *dew, PTAA *ptaa, l_int32 rotflag );
extern l_int32 dewarpFindHorizDisparity ( L_DEWARP *dew, PTAA *ptaa );
extern PTAA * dewarpGetTextlineCenters ( PIX *pixs, l_int32 debugflag );
extern PTAA * dewarpRemoveShortLines ( PIX *pixs, PTAA *ptaas, l_float32 fract, l_int32 debugflag );
extern l_int32 dewarpBuildLineModel ( L_DEWARP *dew, l_int32 opensize, const char *debugfile );
extern l_int32 dewarpaModelStatus ( L_DEWARPA *dewa, l_int32 pageno, l_int32 *pvsuccess, l_int32 *phsuccess );
extern l_int32 dewarpaApplyDisparity ( L_DEWARPA *dewa, l_int32 pageno, PIX *pixs, l_int32 grayin, l_int32 x, l_int32 y, PIX **ppixd, const char *debugfile );
extern l_int32 dewarpMinimize ( L_DEWARP *dew );
extern l_int32 dewarpPopulateFullRes ( L_DEWARP *dew, PIX *pix, l_int32 x, l_int32 y );
extern l_int32 dewarpSinglePage ( PIX *pixs, l_int32 thresh, l_int32 adaptive, l_int32 use_both, PIX **ppixd, L_DEWARPA **pdewa, l_int32 debug );
extern l_int32 dewarpaListPages ( L_DEWARPA *dewa );
extern l_int32 dewarpaSetValidModels ( L_DEWARPA *dewa, l_int32 notests, l_int32 debug );
extern l_int32 dewarpaInsertRefModels ( L_DEWARPA *dewa, l_int32 notests, l_int32 debug );
extern l_int32 dewarpaStripRefModels ( L_DEWARPA *dewa );
extern l_int32 dewarpaRestoreModels ( L_DEWARPA *dewa );
extern l_int32 dewarpaInfo ( FILE *fp, L_DEWARPA *dewa );
extern l_int32 dewarpaModelStats ( L_DEWARPA *dewa, l_int32 *pnnone, l_int32 *pnvsuccess, l_int32 *pnvvalid, l_int32 *pnhsuccess, l_int32 *pnhvalid, l_int32 *pnref );
extern l_int32 dewarpaShowArrays ( L_DEWARPA *dewa, l_float32 scalefact, l_int32 first, l_int32 last, const char *fontdir );
extern l_int32 dewarpDebug ( L_DEWARP *dew, const char *subdir, l_int32 index );
extern l_int32 dewarpShowResults ( L_DEWARPA *dewa, SARRAY *sa, BOXA *boxa, l_int32 firstpage, l_int32 lastpage, const char *fontdir, const char *pdfout );
extern L_DNA * l_dnaCreate ( l_int32 n );
extern L_DNA * l_dnaCreateFromIArray ( l_int32 *iarray, l_int32 size );
extern L_DNA * l_dnaCreateFromDArray ( l_float64 *darray, l_int32 size, l_int32 copyflag );
extern L_DNA * l_dnaMakeSequence ( l_float64 startval, l_float64 increment, l_int32 size );
extern void l_dnaDestroy ( L_DNA **pda );
extern L_DNA * l_dnaCopy ( L_DNA *da );
extern L_DNA * l_dnaClone ( L_DNA *da );
extern l_int32 l_dnaEmpty ( L_DNA *da );
extern l_int32 l_dnaAddNumber ( L_DNA *da, l_float64 val );
extern l_int32 l_dnaInsertNumber ( L_DNA *da, l_int32 index, l_float64 val );
extern l_int32 l_dnaRemoveNumber ( L_DNA *da, l_int32 index );
extern l_int32 l_dnaReplaceNumber ( L_DNA *da, l_int32 index, l_float64 val );
extern l_int32 l_dnaGetCount ( L_DNA *da );
extern l_int32 l_dnaSetCount ( L_DNA *da, l_int32 newcount );
extern l_int32 l_dnaGetDValue ( L_DNA *da, l_int32 index, l_float64 *pval );
extern l_int32 l_dnaGetIValue ( L_DNA *da, l_int32 index, l_int32 *pival );
extern l_int32 l_dnaSetValue ( L_DNA *da, l_int32 index, l_float64 val );
extern l_int32 l_dnaShiftValue ( L_DNA *da, l_int32 index, l_float64 diff );
extern l_int32 * l_dnaGetIArray ( L_DNA *da );
extern l_float64 * l_dnaGetDArray ( L_DNA *da, l_int32 copyflag );
extern l_int32 l_dnaGetRefcount ( L_DNA *da );
extern l_int32 l_dnaChangeRefcount ( L_DNA *da, l_int32 delta );
extern l_int32 l_dnaGetParameters ( L_DNA *da, l_float64 *pstartx, l_float64 *pdelx );
extern l_int32 l_dnaSetParameters ( L_DNA *da, l_float64 startx, l_float64 delx );
extern l_int32 l_dnaCopyParameters ( L_DNA *dad, L_DNA *das );
extern L_DNA * l_dnaRead ( const char *filename );
extern L_DNA * l_dnaReadStream ( FILE *fp );
extern l_int32 l_dnaWrite ( const char *filename, L_DNA *da );
extern l_int32 l_dnaWriteStream ( FILE *fp, L_DNA *da );
extern L_DNAA * l_dnaaCreate ( l_int32 n );
extern void l_dnaaDestroy ( L_DNAA **pdaa );
extern l_int32 l_dnaaAddDna ( L_DNAA *daa, L_DNA *da, l_int32 copyflag );
extern l_int32 l_dnaaGetCount ( L_DNAA *daa );
extern l_int32 l_dnaaGetDnaCount ( L_DNAA *daa, l_int32 index );
extern l_int32 l_dnaaGetNumberCount ( L_DNAA *daa );
extern L_DNA * l_dnaaGetDna ( L_DNAA *daa, l_int32 index, l_int32 accessflag );
extern l_int32 l_dnaaReplaceDna ( L_DNAA *daa, l_int32 index, L_DNA *da );
extern l_int32 l_dnaaGetValue ( L_DNAA *daa, l_int32 i, l_int32 j, l_float64 *pval );
extern l_int32 l_dnaaAddNumber ( L_DNAA *daa, l_int32 index, l_float64 val );
extern L_DNAA * l_dnaaRead ( const char *filename );
extern L_DNAA * l_dnaaReadStream ( FILE *fp );
extern l_int32 l_dnaaWrite ( const char *filename, L_DNAA *daa );
extern l_int32 l_dnaaWriteStream ( FILE *fp, L_DNAA *daa );
extern L_DNA * l_dnaMakeDelta ( L_DNA *das );
extern NUMA * l_dnaConvertToNuma ( L_DNA *da );
extern L_DNA * numaConvertToDna ( NUMA *na );
extern l_int32 l_dnaJoin ( L_DNA *dad, L_DNA *das, l_int32 istart, l_int32 iend );
extern PIX * pixMorphDwa_2 ( PIX *pixd, PIX *pixs, l_int32 operation, char *selname );
extern PIX * pixFMorphopGen_2 ( PIX *pixd, PIX *pixs, l_int32 operation, char *selname );
extern l_int32 fmorphopgen_low_2 ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 index );
extern PIX * pixSobelEdgeFilter ( PIX *pixs, l_int32 orientflag );
extern PIX * pixTwoSidedEdgeFilter ( PIX *pixs, l_int32 orientflag );
extern l_int32 pixMeasureEdgeSmoothness ( PIX *pixs, l_int32 side, l_int32 minjump, l_int32 minreversal, l_float32 *pjpl, l_float32 *pjspl, l_float32 *prpl, const char *debugfile );
extern NUMA * pixGetEdgeProfile ( PIX *pixs, l_int32 side, const char *debugfile );
extern l_int32 pixGetLastOffPixelInRun ( PIX *pixs, l_int32 x, l_int32 y, l_int32 direction, l_int32 *ploc );
extern l_int32 pixGetLastOnPixelInRun ( PIX *pixs, l_int32 x, l_int32 y, l_int32 direction, l_int32 *ploc );
extern PIX * pixGammaTRC ( PIX *pixd, PIX *pixs, l_float32 gamma, l_int32 minval, l_int32 maxval );
extern PIX * pixGammaTRCMasked ( PIX *pixd, PIX *pixs, PIX *pixm, l_float32 gamma, l_int32 minval, l_int32 maxval );
extern PIX * pixGammaTRCWithAlpha ( PIX *pixd, PIX *pixs, l_float32 gamma, l_int32 minval, l_int32 maxval );
extern NUMA * numaGammaTRC ( l_float32 gamma, l_int32 minval, l_int32 maxval );
extern PIX * pixContrastTRC ( PIX *pixd, PIX *pixs, l_float32 factor );
extern PIX * pixContrastTRCMasked ( PIX *pixd, PIX *pixs, PIX *pixm, l_float32 factor );
extern NUMA * numaContrastTRC ( l_float32 factor );
extern PIX * pixEqualizeTRC ( PIX *pixd, PIX *pixs, l_float32 fract, l_int32 factor );
extern NUMA * numaEqualizeTRC ( PIX *pix, l_float32 fract, l_int32 factor );
extern l_int32 pixTRCMap ( PIX *pixs, PIX *pixm, NUMA *na );
extern PIX * pixUnsharpMasking ( PIX *pixs, l_int32 halfwidth, l_float32 fract );
extern PIX * pixUnsharpMaskingGray ( PIX *pixs, l_int32 halfwidth, l_float32 fract );
extern PIX * pixUnsharpMaskingFast ( PIX *pixs, l_int32 halfwidth, l_float32 fract, l_int32 direction );
extern PIX * pixUnsharpMaskingGrayFast ( PIX *pixs, l_int32 halfwidth, l_float32 fract, l_int32 direction );
extern PIX * pixUnsharpMaskingGray1D ( PIX *pixs, l_int32 halfwidth, l_float32 fract, l_int32 direction );
extern PIX * pixUnsharpMaskingGray2D ( PIX *pixs, l_int32 halfwidth, l_float32 fract );
extern PIX * pixModifyHue ( PIX *pixd, PIX *pixs, l_float32 fract );
extern PIX * pixModifySaturation ( PIX *pixd, PIX *pixs, l_float32 fract );
extern l_int32 pixMeasureSaturation ( PIX *pixs, l_int32 factor, l_float32 *psat );
extern PIX * pixModifyBrightness ( PIX *pixd, PIX *pixs, l_float32 fract );
extern PIX * pixColorShiftRGB ( PIX *pixs, l_float32 rfract, l_float32 gfract, l_float32 bfract );
extern PIX * pixMultConstantColor ( PIX *pixs, l_float32 rfact, l_float32 gfact, l_float32 bfact );
extern PIX * pixMultMatrixColor ( PIX *pixs, L_KERNEL *kel );
extern PIX * pixHalfEdgeByBandpass ( PIX *pixs, l_int32 sm1h, l_int32 sm1v, l_int32 sm2h, l_int32 sm2v );
extern l_int32 fhmtautogen ( SELA *sela, l_int32 fileindex, const char *filename );
extern l_int32 fhmtautogen1 ( SELA *sela, l_int32 fileindex, const char *filename );
extern l_int32 fhmtautogen2 ( SELA *sela, l_int32 fileindex, const char *filename );
extern PIX * pixHMTDwa_1 ( PIX *pixd, PIX *pixs, char *selname );
extern PIX * pixFHMTGen_1 ( PIX *pixd, PIX *pixs, char *selname );
extern l_int32 fhmtgen_low_1 ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 index );
extern l_int32 pixItalicWords ( PIX *pixs, BOXA *boxaw, PIX *pixw, BOXA **pboxa, l_int32 debugflag );
extern l_int32 pixOrientDetect ( PIX *pixs, l_float32 *pupconf, l_float32 *pleftconf, l_int32 mincount, l_int32 debug );
extern l_int32 makeOrientDecision ( l_float32 upconf, l_float32 leftconf, l_float32 minupconf, l_float32 minratio, l_int32 *porient, l_int32 debug );
extern l_int32 pixUpDownDetect ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 debug );
extern l_int32 pixUpDownDetectGeneral ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 npixels, l_int32 debug );
extern l_int32 pixOrientDetectDwa ( PIX *pixs, l_float32 *pupconf, l_float32 *pleftconf, l_int32 mincount, l_int32 debug );
extern l_int32 pixUpDownDetectDwa ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 debug );
extern l_int32 pixUpDownDetectGeneralDwa ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 npixels, l_int32 debug );
extern l_int32 pixMirrorDetect ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 debug );
extern l_int32 pixMirrorDetectDwa ( PIX *pixs, l_float32 *pconf, l_int32 mincount, l_int32 debug );
extern PIX * pixFlipFHMTGen ( PIX *pixd, PIX *pixs, char *selname );
extern l_int32 fmorphautogen ( SELA *sela, l_int32 fileindex, const char *filename );
extern l_int32 fmorphautogen1 ( SELA *sela, l_int32 fileindex, const char *filename );
extern l_int32 fmorphautogen2 ( SELA *sela, l_int32 fileindex, const char *filename );
extern PIX * pixMorphDwa_1 ( PIX *pixd, PIX *pixs, l_int32 operation, char *selname );
extern PIX * pixFMorphopGen_1 ( PIX *pixd, PIX *pixs, l_int32 operation, char *selname );
extern l_int32 fmorphopgen_low_1 ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 index );
extern FPIX * fpixCreate ( l_int32 width, l_int32 height );
extern FPIX * fpixCreateTemplate ( FPIX *fpixs );
extern FPIX * fpixClone ( FPIX *fpix );
extern FPIX * fpixCopy ( FPIX *fpixd, FPIX *fpixs );
extern l_int32 fpixResizeImageData ( FPIX *fpixd, FPIX *fpixs );
extern void fpixDestroy ( FPIX **pfpix );
extern l_int32 fpixGetDimensions ( FPIX *fpix, l_int32 *pw, l_int32 *ph );
extern l_int32 fpixSetDimensions ( FPIX *fpix, l_int32 w, l_int32 h );
extern l_int32 fpixGetWpl ( FPIX *fpix );
extern l_int32 fpixSetWpl ( FPIX *fpix, l_int32 wpl );
extern l_int32 fpixGetRefcount ( FPIX *fpix );
extern l_int32 fpixChangeRefcount ( FPIX *fpix, l_int32 delta );
extern l_int32 fpixGetResolution ( FPIX *fpix, l_int32 *pxres, l_int32 *pyres );
extern l_int32 fpixSetResolution ( FPIX *fpix, l_int32 xres, l_int32 yres );
extern l_int32 fpixCopyResolution ( FPIX *fpixd, FPIX *fpixs );
extern l_float32 * fpixGetData ( FPIX *fpix );
extern l_int32 fpixSetData ( FPIX *fpix, l_float32 *data );
extern l_int32 fpixGetPixel ( FPIX *fpix, l_int32 x, l_int32 y, l_float32 *pval );
extern l_int32 fpixSetPixel ( FPIX *fpix, l_int32 x, l_int32 y, l_float32 val );
extern FPIXA * fpixaCreate ( l_int32 n );
extern FPIXA * fpixaCopy ( FPIXA *fpixa, l_int32 copyflag );
extern void fpixaDestroy ( FPIXA **pfpixa );
extern l_int32 fpixaAddFPix ( FPIXA *fpixa, FPIX *fpix, l_int32 copyflag );
extern l_int32 fpixaGetCount ( FPIXA *fpixa );
extern l_int32 fpixaChangeRefcount ( FPIXA *fpixa, l_int32 delta );
extern FPIX * fpixaGetFPix ( FPIXA *fpixa, l_int32 index, l_int32 accesstype );
extern l_int32 fpixaGetFPixDimensions ( FPIXA *fpixa, l_int32 index, l_int32 *pw, l_int32 *ph );
extern l_int32 fpixaGetPixel ( FPIXA *fpixa, l_int32 index, l_int32 x, l_int32 y, l_float32 *pval );
extern l_int32 fpixaSetPixel ( FPIXA *fpixa, l_int32 index, l_int32 x, l_int32 y, l_float32 val );
extern DPIX * dpixCreate ( l_int32 width, l_int32 height );
extern DPIX * dpixCreateTemplate ( DPIX *dpixs );
extern DPIX * dpixClone ( DPIX *dpix );
extern DPIX * dpixCopy ( DPIX *dpixd, DPIX *dpixs );
extern l_int32 dpixResizeImageData ( DPIX *dpixd, DPIX *dpixs );
extern void dpixDestroy ( DPIX **pdpix );
extern l_int32 dpixGetDimensions ( DPIX *dpix, l_int32 *pw, l_int32 *ph );
extern l_int32 dpixSetDimensions ( DPIX *dpix, l_int32 w, l_int32 h );
extern l_int32 dpixGetWpl ( DPIX *dpix );
extern l_int32 dpixSetWpl ( DPIX *dpix, l_int32 wpl );
extern l_int32 dpixGetRefcount ( DPIX *dpix );
extern l_int32 dpixChangeRefcount ( DPIX *dpix, l_int32 delta );
extern l_int32 dpixGetResolution ( DPIX *dpix, l_int32 *pxres, l_int32 *pyres );
extern l_int32 dpixSetResolution ( DPIX *dpix, l_int32 xres, l_int32 yres );
extern l_int32 dpixCopyResolution ( DPIX *dpixd, DPIX *dpixs );
extern l_float64 * dpixGetData ( DPIX *dpix );
extern l_int32 dpixSetData ( DPIX *dpix, l_float64 *data );
extern l_int32 dpixGetPixel ( DPIX *dpix, l_int32 x, l_int32 y, l_float64 *pval );
extern l_int32 dpixSetPixel ( DPIX *dpix, l_int32 x, l_int32 y, l_float64 val );
extern FPIX * fpixRead ( const char *filename );
extern FPIX * fpixReadStream ( FILE *fp );
extern l_int32 fpixWrite ( const char *filename, FPIX *fpix );
extern l_int32 fpixWriteStream ( FILE *fp, FPIX *fpix );
extern FPIX * fpixEndianByteSwap ( FPIX *fpixd, FPIX *fpixs );
extern DPIX * dpixRead ( const char *filename );
extern DPIX * dpixReadStream ( FILE *fp );
extern l_int32 dpixWrite ( const char *filename, DPIX *dpix );
extern l_int32 dpixWriteStream ( FILE *fp, DPIX *dpix );
extern DPIX * dpixEndianByteSwap ( DPIX *dpixd, DPIX *dpixs );
extern l_int32 fpixPrintStream ( FILE *fp, FPIX *fpix, l_int32 factor );
extern FPIX * pixConvertToFPix ( PIX *pixs, l_int32 ncomps );
extern DPIX * pixConvertToDPix ( PIX *pixs, l_int32 ncomps );
extern PIX * fpixConvertToPix ( FPIX *fpixs, l_int32 outdepth, l_int32 negvals, l_int32 errorflag );
extern PIX * fpixDisplayMaxDynamicRange ( FPIX *fpixs );
extern DPIX * fpixConvertToDPix ( FPIX *fpix );
extern PIX * dpixConvertToPix ( DPIX *dpixs, l_int32 outdepth, l_int32 negvals, l_int32 errorflag );
extern FPIX * dpixConvertToFPix ( DPIX *dpix );
extern l_int32 fpixGetMin ( FPIX *fpix, l_float32 *pminval, l_int32 *pxminloc, l_int32 *pyminloc );
extern l_int32 fpixGetMax ( FPIX *fpix, l_float32 *pmaxval, l_int32 *pxmaxloc, l_int32 *pymaxloc );
extern l_int32 dpixGetMin ( DPIX *dpix, l_float64 *pminval, l_int32 *pxminloc, l_int32 *pyminloc );
extern l_int32 dpixGetMax ( DPIX *dpix, l_float64 *pmaxval, l_int32 *pxmaxloc, l_int32 *pymaxloc );
extern FPIX * fpixScaleByInteger ( FPIX *fpixs, l_int32 factor );
extern DPIX * dpixScaleByInteger ( DPIX *dpixs, l_int32 factor );
extern FPIX * fpixLinearCombination ( FPIX *fpixd, FPIX *fpixs1, FPIX *fpixs2, l_float32 a, l_float32 b );
extern l_int32 fpixAddMultConstant ( FPIX *fpix, l_float32 addc, l_float32 multc );
extern DPIX * dpixLinearCombination ( DPIX *dpixd, DPIX *dpixs1, DPIX *dpixs2, l_float32 a, l_float32 b );
extern l_int32 dpixAddMultConstant ( DPIX *dpix, l_float64 addc, l_float64 multc );
extern l_int32 fpixSetAllArbitrary ( FPIX *fpix, l_float32 inval );
extern l_int32 dpixSetAllArbitrary ( DPIX *dpix, l_float64 inval );
extern FPIX * fpixAddBorder ( FPIX *fpixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern FPIX * fpixRemoveBorder ( FPIX *fpixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern FPIX * fpixAddMirroredBorder ( FPIX *fpixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern FPIX * fpixAddContinuedBorder ( FPIX *fpixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern FPIX * fpixAddSlopeBorder ( FPIX *fpixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern l_int32 fpixRasterop ( FPIX *fpixd, l_int32 dx, l_int32 dy, l_int32 dw, l_int32 dh, FPIX *fpixs, l_int32 sx, l_int32 sy );
extern FPIX * fpixRotateOrth ( FPIX *fpixs, l_int32 quads );
extern FPIX * fpixRotate180 ( FPIX *fpixd, FPIX *fpixs );
extern FPIX * fpixRotate90 ( FPIX *fpixs, l_int32 direction );
extern FPIX * fpixFlipLR ( FPIX *fpixd, FPIX *fpixs );
extern FPIX * fpixFlipTB ( FPIX *fpixd, FPIX *fpixs );
extern FPIX * fpixAffinePta ( FPIX *fpixs, PTA *ptad, PTA *ptas, l_int32 border, l_float32 inval );
extern FPIX * fpixAffine ( FPIX *fpixs, l_float32 *vc, l_float32 inval );
extern FPIX * fpixProjectivePta ( FPIX *fpixs, PTA *ptad, PTA *ptas, l_int32 border, l_float32 inval );
extern FPIX * fpixProjective ( FPIX *fpixs, l_float32 *vc, l_float32 inval );
extern l_int32 linearInterpolatePixelFloat ( l_float32 *datas, l_int32 w, l_int32 h, l_float32 x, l_float32 y, l_float32 inval, l_float32 *pval );
extern PIX * fpixThresholdToPix ( FPIX *fpix, l_float32 thresh );
extern FPIX * pixComponentFunction ( PIX *pix, l_float32 rnum, l_float32 gnum, l_float32 bnum, l_float32 rdenom, l_float32 gdenom, l_float32 bdenom );
extern PIX * pixReadStreamGif ( FILE *fp );
extern l_int32 pixWriteStreamGif ( FILE *fp, PIX *pix );
extern PIX * pixReadMemGif ( const l_uint8 *cdata, size_t size );
extern l_int32 pixWriteMemGif ( l_uint8 **pdata, size_t *psize, PIX *pix );
extern GPLOT * gplotCreate ( const char *rootname, l_int32 outformat, const char *title, const char *xlabel, const char *ylabel );
extern void gplotDestroy ( GPLOT **pgplot );
extern l_int32 gplotAddPlot ( GPLOT *gplot, NUMA *nax, NUMA *nay, l_int32 plotstyle, const char *plottitle );
extern l_int32 gplotSetScaling ( GPLOT *gplot, l_int32 scaling );
extern l_int32 gplotMakeOutput ( GPLOT *gplot );
extern l_int32 gplotGenCommandFile ( GPLOT *gplot );
extern l_int32 gplotGenDataFiles ( GPLOT *gplot );
extern l_int32 gplotSimple1 ( NUMA *na, l_int32 outformat, const char *outroot, const char *title );
extern l_int32 gplotSimple2 ( NUMA *na1, NUMA *na2, l_int32 outformat, const char *outroot, const char *title );
extern l_int32 gplotSimpleN ( NUMAA *naa, l_int32 outformat, const char *outroot, const char *title );
extern l_int32 gplotSimpleXY1 ( NUMA *nax, NUMA *nay, l_int32 outformat, const char *outroot, const char *title );
extern l_int32 gplotSimpleXY2 ( NUMA *nax, NUMA *nay1, NUMA *nay2, l_int32 outformat, const char *outroot, const char *title );
extern l_int32 gplotSimpleXYN ( NUMA *nax, NUMAA *naay, l_int32 outformat, const char *outroot, const char *title );
extern GPLOT * gplotRead ( const char *filename );
extern l_int32 gplotWrite ( const char *filename, GPLOT *gplot );
extern PTA * generatePtaLine ( l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2 );
extern PTA * generatePtaWideLine ( l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 width );
extern PTA * generatePtaBox ( BOX *box, l_int32 width );
extern PTA * generatePtaBoxa ( BOXA *boxa, l_int32 width, l_int32 removedups );
extern PTA * generatePtaHashBox ( BOX *box, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline );
extern PTA * generatePtaHashBoxa ( BOXA *boxa, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 removedups );
extern PTAA * generatePtaaBoxa ( BOXA *boxa );
extern PTAA * generatePtaaHashBoxa ( BOXA *boxa, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline );
extern PTA * generatePtaPolyline ( PTA *ptas, l_int32 width, l_int32 closeflag, l_int32 removedups );
extern PTA * convertPtaLineTo4cc ( PTA *ptas );
extern PTA * generatePtaFilledCircle ( l_int32 radius );
extern PTA * generatePtaFilledSquare ( l_int32 side );
extern PTA * generatePtaLineFromPt ( l_int32 x, l_int32 y, l_float64 length, l_float64 radang );
extern l_int32 locatePtRadially ( l_int32 xr, l_int32 yr, l_float64 dist, l_float64 radang, l_float64 *px, l_float64 *py );
extern l_int32 pixRenderPlotFromNuma ( PIX **ppix, NUMA *na, l_int32 plotloc, l_int32 linewidth, l_int32 max, l_uint32 color );
extern PTA * makePlotPtaFromNuma ( NUMA *na, l_int32 size, l_int32 plotloc, l_int32 linewidth, l_int32 max );
extern l_int32 pixRenderPlotFromNumaGen ( PIX **ppix, NUMA *na, l_int32 orient, l_int32 linewidth, l_int32 refpos, l_int32 max, l_int32 drawref, l_uint32 color );
extern PTA * makePlotPtaFromNumaGen ( NUMA *na, l_int32 orient, l_int32 linewidth, l_int32 refpos, l_int32 max, l_int32 drawref );
extern l_int32 pixRenderPta ( PIX *pix, PTA *pta, l_int32 op );
extern l_int32 pixRenderPtaArb ( PIX *pix, PTA *pta, l_uint8 rval, l_uint8 gval, l_uint8 bval );
extern l_int32 pixRenderPtaBlend ( PIX *pix, PTA *pta, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_float32 fract );
extern l_int32 pixRenderLine ( PIX *pix, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 width, l_int32 op );
extern l_int32 pixRenderLineArb ( PIX *pix, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval );
extern l_int32 pixRenderLineBlend ( PIX *pix, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_float32 fract );
extern l_int32 pixRenderBox ( PIX *pix, BOX *box, l_int32 width, l_int32 op );
extern l_int32 pixRenderBoxArb ( PIX *pix, BOX *box, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval );
extern l_int32 pixRenderBoxBlend ( PIX *pix, BOX *box, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_float32 fract );
extern l_int32 pixRenderBoxa ( PIX *pix, BOXA *boxa, l_int32 width, l_int32 op );
extern l_int32 pixRenderBoxaArb ( PIX *pix, BOXA *boxa, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval );
extern l_int32 pixRenderBoxaBlend ( PIX *pix, BOXA *boxa, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_float32 fract, l_int32 removedups );
extern l_int32 pixRenderHashBox ( PIX *pix, BOX *box, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 op );
extern l_int32 pixRenderHashBoxArb ( PIX *pix, BOX *box, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixRenderHashBoxBlend ( PIX *pix, BOX *box, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 rval, l_int32 gval, l_int32 bval, l_float32 fract );
extern l_int32 pixRenderHashBoxa ( PIX *pix, BOXA *boxa, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 op );
extern l_int32 pixRenderHashBoxaArb ( PIX *pix, BOXA *boxa, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixRenderHashBoxaBlend ( PIX *pix, BOXA *boxa, l_int32 spacing, l_int32 width, l_int32 orient, l_int32 outline, l_int32 rval, l_int32 gval, l_int32 bval, l_float32 fract );
extern l_int32 pixRenderPolyline ( PIX *pix, PTA *ptas, l_int32 width, l_int32 op, l_int32 closeflag );
extern l_int32 pixRenderPolylineArb ( PIX *pix, PTA *ptas, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_int32 closeflag );
extern l_int32 pixRenderPolylineBlend ( PIX *pix, PTA *ptas, l_int32 width, l_uint8 rval, l_uint8 gval, l_uint8 bval, l_float32 fract, l_int32 closeflag, l_int32 removedups );
extern PIX * pixRenderRandomCmapPtaa ( PIX *pix, PTAA *ptaa, l_int32 polyflag, l_int32 width, l_int32 closeflag );
extern PIX * pixRenderPolygon ( PTA *ptas, l_int32 width, l_int32 *pxmin, l_int32 *pymin );
extern PIX * pixFillPolygon ( PIX *pixs, PTA *pta, l_int32 xmin, l_int32 ymin );
extern PIX * pixRenderContours ( PIX *pixs, l_int32 startval, l_int32 incr, l_int32 outdepth );
extern PIX * fpixAutoRenderContours ( FPIX *fpix, l_int32 ncontours );
extern PIX * fpixRenderContours ( FPIX *fpixs, l_float32 incr, l_float32 proxim );
extern PIX * pixErodeGray ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixDilateGray ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenGray ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseGray ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeGray3 ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixDilateGray3 ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenGray3 ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseGray3 ( PIX *pixs, l_int32 hsize, l_int32 vsize );
extern void dilateGrayLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 size, l_int32 direction, l_uint8 *buffer, l_uint8 *maxarray );
extern void erodeGrayLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 size, l_int32 direction, l_uint8 *buffer, l_uint8 *minarray );
extern PIX * pixDitherToBinary ( PIX *pixs );
extern PIX * pixDitherToBinarySpec ( PIX *pixs, l_int32 lowerclip, l_int32 upperclip );
extern PIX * pixThresholdToBinary ( PIX *pixs, l_int32 thresh );
extern PIX * pixVarThresholdToBinary ( PIX *pixs, PIX *pixg );
extern PIX * pixAdaptThresholdToBinary ( PIX *pixs, PIX *pixm, l_float32 gamma );
extern PIX * pixAdaptThresholdToBinaryGen ( PIX *pixs, PIX *pixm, l_float32 gamma, l_int32 blackval, l_int32 whiteval, l_int32 thresh );
extern PIX * pixDitherToBinaryLUT ( PIX *pixs, l_int32 lowerclip, l_int32 upperclip );
extern PIX * pixGenerateMaskByValue ( PIX *pixs, l_int32 val, l_int32 usecmap );
extern PIX * pixGenerateMaskByBand ( PIX *pixs, l_int32 lower, l_int32 upper, l_int32 inband, l_int32 usecmap );
extern PIX * pixDitherTo2bpp ( PIX *pixs, l_int32 cmapflag );
extern PIX * pixDitherTo2bppSpec ( PIX *pixs, l_int32 lowerclip, l_int32 upperclip, l_int32 cmapflag );
extern PIX * pixThresholdTo2bpp ( PIX *pixs, l_int32 nlevels, l_int32 cmapflag );
extern PIX * pixThresholdTo4bpp ( PIX *pixs, l_int32 nlevels, l_int32 cmapflag );
extern PIX * pixThresholdOn8bpp ( PIX *pixs, l_int32 nlevels, l_int32 cmapflag );
extern PIX * pixThresholdGrayArb ( PIX *pixs, const char *edgevals, l_int32 outdepth, l_int32 use_average, l_int32 setblack, l_int32 setwhite );
extern l_int32 * makeGrayQuantIndexTable ( l_int32 nlevels );
extern l_int32 * makeGrayQuantTargetTable ( l_int32 nlevels, l_int32 depth );
extern l_int32 makeGrayQuantTableArb ( NUMA *na, l_int32 outdepth, l_int32 **ptab, PIXCMAP **pcmap );
extern l_int32 makeGrayQuantColormapArb ( PIX *pixs, l_int32 *tab, l_int32 outdepth, PIXCMAP **pcmap );
extern PIX * pixGenerateMaskByBand32 ( PIX *pixs, l_uint32 refval, l_int32 delm, l_int32 delp, l_float32 fractm, l_float32 fractp );
extern PIX * pixGenerateMaskByDiscr32 ( PIX *pixs, l_uint32 refval1, l_uint32 refval2, l_int32 distflag );
extern PIX * pixGrayQuantFromHisto ( PIX *pixd, PIX *pixs, PIX *pixm, l_float32 minfract, l_int32 maxsize );
extern PIX * pixGrayQuantFromCmap ( PIX *pixs, PIXCMAP *cmap, l_int32 mindepth );
extern void ditherToBinaryLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 lowerclip, l_int32 upperclip );
extern void ditherToBinaryLineLow ( l_uint32 *lined, l_int32 w, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 lowerclip, l_int32 upperclip, l_int32 lastlineflag );
extern void thresholdToBinaryLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 d, l_int32 wpls, l_int32 thresh );
extern void thresholdToBinaryLineLow ( l_uint32 *lined, l_int32 w, l_uint32 *lines, l_int32 d, l_int32 thresh );
extern void ditherToBinaryLUTLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 *tabval, l_int32 *tab38, l_int32 *tab14 );
extern void ditherToBinaryLineLUTLow ( l_uint32 *lined, l_int32 w, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 *tabval, l_int32 *tab38, l_int32 *tab14, l_int32 lastlineflag );
extern l_int32 make8To1DitherTables ( l_int32 **ptabval, l_int32 **ptab38, l_int32 **ptab14, l_int32 lowerclip, l_int32 upperclip );
extern void ditherTo2bppLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 *tabval, l_int32 *tab38, l_int32 *tab14 );
extern void ditherTo2bppLineLow ( l_uint32 *lined, l_int32 w, l_uint32 *bufs1, l_uint32 *bufs2, l_int32 *tabval, l_int32 *tab38, l_int32 *tab14, l_int32 lastlineflag );
extern l_int32 make8To2DitherTables ( l_int32 **ptabval, l_int32 **ptab38, l_int32 **ptab14, l_int32 cliptoblack, l_int32 cliptowhite );
extern void thresholdTo2bppLow ( l_uint32 *datad, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 *tab );
extern void thresholdTo4bppLow ( l_uint32 *datad, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 *tab );
extern L_HEAP * lheapCreate ( l_int32 nalloc, l_int32 direction );
extern void lheapDestroy ( L_HEAP **plh, l_int32 freeflag );
extern l_int32 lheapAdd ( L_HEAP *lh, void *item );
extern void * lheapRemove ( L_HEAP *lh );
extern l_int32 lheapGetCount ( L_HEAP *lh );
extern l_int32 lheapSwapUp ( L_HEAP *lh, l_int32 index );
extern l_int32 lheapSwapDown ( L_HEAP *lh );
extern l_int32 lheapSort ( L_HEAP *lh );
extern l_int32 lheapSortStrictOrder ( L_HEAP *lh );
extern l_int32 lheapPrint ( FILE *fp, L_HEAP *lh );
extern JBCLASSER * jbRankHausInit ( l_int32 components, l_int32 maxwidth, l_int32 maxheight, l_int32 size, l_float32 rank );
extern JBCLASSER * jbCorrelationInit ( l_int32 components, l_int32 maxwidth, l_int32 maxheight, l_float32 thresh, l_float32 weightfactor );
extern JBCLASSER * jbCorrelationInitWithoutComponents ( l_int32 components, l_int32 maxwidth, l_int32 maxheight, l_float32 thresh, l_float32 weightfactor );
extern l_int32 jbAddPages ( JBCLASSER *classer, SARRAY *safiles );
extern l_int32 jbAddPage ( JBCLASSER *classer, PIX *pixs );
extern l_int32 jbAddPageComponents ( JBCLASSER *classer, PIX *pixs, BOXA *boxas, PIXA *pixas );
extern l_int32 jbClassifyRankHaus ( JBCLASSER *classer, BOXA *boxa, PIXA *pixas );
extern l_int32 pixHaustest ( PIX *pix1, PIX *pix2, PIX *pix3, PIX *pix4, l_float32 delx, l_float32 dely, l_int32 maxdiffw, l_int32 maxdiffh );
extern l_int32 pixRankHaustest ( PIX *pix1, PIX *pix2, PIX *pix3, PIX *pix4, l_float32 delx, l_float32 dely, l_int32 maxdiffw, l_int32 maxdiffh, l_int32 area1, l_int32 area3, l_float32 rank, l_int32 *tab8 );
extern l_int32 jbClassifyCorrelation ( JBCLASSER *classer, BOXA *boxa, PIXA *pixas );
extern l_int32 jbGetComponents ( PIX *pixs, l_int32 components, l_int32 maxwidth, l_int32 maxheight, BOXA **pboxad, PIXA **ppixad );
extern l_int32 pixWordMaskByDilation ( PIX *pixs, l_int32 maxdil, PIX **ppixm, l_int32 *psize );
extern l_int32 pixWordBoxesByDilation ( PIX *pixs, l_int32 maxdil, l_int32 minwidth, l_int32 minheight, l_int32 maxwidth, l_int32 maxheight, BOXA **pboxa, l_int32 *psize );
extern PIXA * jbAccumulateComposites ( PIXAA *pixaa, NUMA **pna, PTA **pptat );
extern PIXA * jbTemplatesFromComposites ( PIXA *pixac, NUMA *na );
extern JBCLASSER * jbClasserCreate ( l_int32 method, l_int32 components );
extern void jbClasserDestroy ( JBCLASSER **pclasser );
extern JBDATA * jbDataSave ( JBCLASSER *classer );
extern void jbDataDestroy ( JBDATA **pdata );
extern l_int32 jbDataWrite ( const char *rootout, JBDATA *jbdata );
extern JBDATA * jbDataRead ( const char *rootname );
extern PIXA * jbDataRender ( JBDATA *data, l_int32 debugflag );
extern l_int32 jbGetULCorners ( JBCLASSER *classer, PIX *pixs, BOXA *boxa );
extern l_int32 jbGetLLCorners ( JBCLASSER *classer );
extern l_int32 readHeaderJp2k ( const char *filename, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp );
extern l_int32 freadHeaderJp2k ( FILE *fp, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp );
extern l_int32 readHeaderMemJp2k ( const l_uint8 *data, size_t size, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp );
extern l_int32 fgetJp2kResolution ( FILE *fp, l_int32 *pxres, l_int32 *pyres );
extern PIX * pixReadJp2k ( const char *filename, l_uint32 reduction, BOX *box, l_int32 hint );
extern PIX * pixReadStreamJp2k ( FILE *fp, l_uint32 reduction, BOX *box, l_int32 hint );
extern l_int32 pixWriteJp2k ( const char *filename, PIX *pix, l_int32 quality, l_int32 nlevels, l_int32 hint );
extern l_int32 pixWriteStreamJp2k ( FILE *fp, PIX *pix, l_int32 quality, l_int32 nlevels, l_int32 hint );
extern PIX * pixReadMemJp2k ( const l_uint8 *data, size_t size, l_uint32 reduction, BOX *box, l_int32 hint );
extern l_int32 pixWriteMemJp2k ( l_uint8 **pdata, size_t *psize, PIX *pix, l_int32 quality, l_int32 nlevels, l_int32 hint );
extern PIX * pixReadJpeg ( const char *filename, l_int32 cmflag, l_int32 reduction, l_int32 *pnwarn, l_int32 hint );
extern PIX * pixReadStreamJpeg ( FILE *fp, l_int32 cmflag, l_int32 reduction, l_int32 *pnwarn, l_int32 hint );
extern l_int32 readHeaderJpeg ( const char *filename, l_int32 *pw, l_int32 *ph, l_int32 *pspp, l_int32 *pycck, l_int32 *pcmyk );
extern l_int32 freadHeaderJpeg ( FILE *fp, l_int32 *pw, l_int32 *ph, l_int32 *pspp, l_int32 *pycck, l_int32 *pcmyk );
extern l_int32 fgetJpegResolution ( FILE *fp, l_int32 *pxres, l_int32 *pyres );
extern l_int32 fgetJpegComment ( FILE *fp, l_uint8 **pcomment );
extern l_int32 pixWriteJpeg ( const char *filename, PIX *pix, l_int32 quality, l_int32 progressive );
extern l_int32 pixWriteStreamJpeg ( FILE *fp, PIX *pixs, l_int32 quality, l_int32 progressive );
extern PIX * pixReadMemJpeg ( const l_uint8 *data, size_t size, l_int32 cmflag, l_int32 reduction, l_int32 *pnwarn, l_int32 hint );
extern l_int32 readHeaderMemJpeg ( const l_uint8 *data, size_t size, l_int32 *pw, l_int32 *ph, l_int32 *pspp, l_int32 *pycck, l_int32 *pcmyk );
extern l_int32 pixWriteMemJpeg ( l_uint8 **pdata, size_t *psize, PIX *pix, l_int32 quality, l_int32 progressive );
extern l_int32 pixSetChromaSampling ( PIX *pix, l_int32 sampling );
extern L_KERNEL * kernelCreate ( l_int32 height, l_int32 width );
extern void kernelDestroy ( L_KERNEL **pkel );
extern L_KERNEL * kernelCopy ( L_KERNEL *kels );
extern l_int32 kernelGetElement ( L_KERNEL *kel, l_int32 row, l_int32 col, l_float32 *pval );
extern l_int32 kernelSetElement ( L_KERNEL *kel, l_int32 row, l_int32 col, l_float32 val );
extern l_int32 kernelGetParameters ( L_KERNEL *kel, l_int32 *psy, l_int32 *psx, l_int32 *pcy, l_int32 *pcx );
extern l_int32 kernelSetOrigin ( L_KERNEL *kel, l_int32 cy, l_int32 cx );
extern l_int32 kernelGetSum ( L_KERNEL *kel, l_float32 *psum );
extern l_int32 kernelGetMinMax ( L_KERNEL *kel, l_float32 *pmin, l_float32 *pmax );
extern L_KERNEL * kernelNormalize ( L_KERNEL *kels, l_float32 normsum );
extern L_KERNEL * kernelInvert ( L_KERNEL *kels );
extern l_float32 ** create2dFloatArray ( l_int32 sy, l_int32 sx );
extern L_KERNEL * kernelRead ( const char *fname );
extern L_KERNEL * kernelReadStream ( FILE *fp );
extern l_int32 kernelWrite ( const char *fname, L_KERNEL *kel );
extern l_int32 kernelWriteStream ( FILE *fp, L_KERNEL *kel );
extern L_KERNEL * kernelCreateFromString ( l_int32 h, l_int32 w, l_int32 cy, l_int32 cx, const char *kdata );
extern L_KERNEL * kernelCreateFromFile ( const char *filename );
extern L_KERNEL * kernelCreateFromPix ( PIX *pix, l_int32 cy, l_int32 cx );
extern PIX * kernelDisplayInPix ( L_KERNEL *kel, l_int32 size, l_int32 gthick );
extern NUMA * parseStringForNumbers ( const char *str, const char *seps );
extern L_KERNEL * makeFlatKernel ( l_int32 height, l_int32 width, l_int32 cy, l_int32 cx );
extern L_KERNEL * makeGaussianKernel ( l_int32 halfheight, l_int32 halfwidth, l_float32 stdev, l_float32 max );
extern l_int32 makeGaussianKernelSep ( l_int32 halfheight, l_int32 halfwidth, l_float32 stdev, l_float32 max, L_KERNEL **pkelx, L_KERNEL **pkely );
extern L_KERNEL * makeDoGKernel ( l_int32 halfheight, l_int32 halfwidth, l_float32 stdev, l_float32 ratio );
extern char * getImagelibVersions (  );
extern void listDestroy ( DLLIST **phead );
extern l_int32 listAddToHead ( DLLIST **phead, void *data );
extern l_int32 listAddToTail ( DLLIST **phead, DLLIST **ptail, void *data );
extern l_int32 listInsertBefore ( DLLIST **phead, DLLIST *elem, void *data );
extern l_int32 listInsertAfter ( DLLIST **phead, DLLIST *elem, void *data );
extern void * listRemoveElement ( DLLIST **phead, DLLIST *elem );
extern void * listRemoveFromHead ( DLLIST **phead );
extern void * listRemoveFromTail ( DLLIST **phead, DLLIST **ptail );
extern DLLIST * listFindElement ( DLLIST *head, void *data );
extern DLLIST * listFindTail ( DLLIST *head );
extern l_int32 listGetCount ( DLLIST *head );
extern l_int32 listReverse ( DLLIST **phead );
extern l_int32 listJoin ( DLLIST **phead1, DLLIST **phead2 );
extern PIX * generateBinaryMaze ( l_int32 w, l_int32 h, l_int32 xi, l_int32 yi, l_float32 wallps, l_float32 ranis );
extern PTA * pixSearchBinaryMaze ( PIX *pixs, l_int32 xi, l_int32 yi, l_int32 xf, l_int32 yf, PIX **ppixd );
extern PTA * pixSearchGrayMaze ( PIX *pixs, l_int32 xi, l_int32 yi, l_int32 xf, l_int32 yf, PIX **ppixd );
extern l_int32 pixFindLargestRectangle ( PIX *pixs, l_int32 polarity, BOX **pbox, const char *debugfile );
extern PIX * pixDilate ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixErode ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixHMT ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixOpen ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixClose ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixCloseSafe ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixOpenGeneralized ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixCloseGeneralized ( PIX *pixd, PIX *pixs, SEL *sel );
extern PIX * pixDilateBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseSafeBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern l_int32 selectComposableSels ( l_int32 size, l_int32 direction, SEL **psel1, SEL **psel2 );
extern l_int32 selectComposableSizes ( l_int32 size, l_int32 *pfactor1, l_int32 *pfactor2 );
extern PIX * pixDilateCompBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeCompBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenCompBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseCompBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseSafeCompBrick ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern void resetMorphBoundaryCondition ( l_int32 bc );
extern l_uint32 getMorphBorderPixelColor ( l_int32 type, l_int32 depth );
extern PIX * pixExtractBoundary ( PIX *pixs, l_int32 type );
extern PIX * pixMorphSequenceMasked ( PIX *pixs, PIX *pixm, const char *sequence, l_int32 dispsep );
extern PIX * pixMorphSequenceByComponent ( PIX *pixs, const char *sequence, l_int32 connectivity, l_int32 minw, l_int32 minh, BOXA **pboxa );
extern PIXA * pixaMorphSequenceByComponent ( PIXA *pixas, const char *sequence, l_int32 minw, l_int32 minh );
extern PIX * pixMorphSequenceByRegion ( PIX *pixs, PIX *pixm, const char *sequence, l_int32 connectivity, l_int32 minw, l_int32 minh, BOXA **pboxa );
extern PIXA * pixaMorphSequenceByRegion ( PIX *pixs, PIXA *pixam, const char *sequence, l_int32 minw, l_int32 minh );
extern PIX * pixUnionOfMorphOps ( PIX *pixs, SELA *sela, l_int32 type );
extern PIX * pixIntersectionOfMorphOps ( PIX *pixs, SELA *sela, l_int32 type );
extern PIX * pixSelectiveConnCompFill ( PIX *pixs, l_int32 connectivity, l_int32 minw, l_int32 minh );
extern l_int32 pixRemoveMatchedPattern ( PIX *pixs, PIX *pixp, PIX *pixe, l_int32 x0, l_int32 y0, l_int32 dsize );
extern PIX * pixDisplayMatchedPattern ( PIX *pixs, PIX *pixp, PIX *pixe, l_int32 x0, l_int32 y0, l_uint32 color, l_float32 scale, l_int32 nlevels );
extern PIX * pixSeedfillMorph ( PIX *pixs, PIX *pixm, l_int32 maxiters, l_int32 connectivity );
extern NUMA * pixRunHistogramMorph ( PIX *pixs, l_int32 runtype, l_int32 direction, l_int32 maxsize );
extern PIX * pixTophat ( PIX *pixs, l_int32 hsize, l_int32 vsize, l_int32 type );
extern PIX * pixHDome ( PIX *pixs, l_int32 height, l_int32 connectivity );
extern PIX * pixFastTophat ( PIX *pixs, l_int32 xsize, l_int32 ysize, l_int32 type );
extern PIX * pixMorphGradient ( PIX *pixs, l_int32 hsize, l_int32 vsize, l_int32 smoothing );
extern PTA * pixaCentroids ( PIXA *pixa );
extern l_int32 pixCentroid ( PIX *pix, l_int32 *centtab, l_int32 *sumtab, l_float32 *pxave, l_float32 *pyave );
extern PIX * pixDilateBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixDilateCompBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeCompBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenCompBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseCompBrickDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixDilateCompBrickExtendDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixErodeCompBrickExtendDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixOpenCompBrickExtendDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern PIX * pixCloseCompBrickExtendDwa ( PIX *pixd, PIX *pixs, l_int32 hsize, l_int32 vsize );
extern l_int32 getExtendedCompositeParameters ( l_int32 size, l_int32 *pn, l_int32 *pextra, l_int32 *pactualsize );
extern PIX * pixMorphSequence ( PIX *pixs, const char *sequence, l_int32 dispsep );
extern PIX * pixMorphCompSequence ( PIX *pixs, const char *sequence, l_int32 dispsep );
extern PIX * pixMorphSequenceDwa ( PIX *pixs, const char *sequence, l_int32 dispsep );
extern PIX * pixMorphCompSequenceDwa ( PIX *pixs, const char *sequence, l_int32 dispsep );
extern l_int32 morphSequenceVerify ( SARRAY *sa );
extern PIX * pixGrayMorphSequence ( PIX *pixs, const char *sequence, l_int32 dispsep, l_int32 dispy );
extern PIX * pixColorMorphSequence ( PIX *pixs, const char *sequence, l_int32 dispsep, l_int32 dispy );
extern NUMA * numaCreate ( l_int32 n );
extern NUMA * numaCreateFromIArray ( l_int32 *iarray, l_int32 size );
extern NUMA * numaCreateFromFArray ( l_float32 *farray, l_int32 size, l_int32 copyflag );
extern void numaDestroy ( NUMA **pna );
extern NUMA * numaCopy ( NUMA *na );
extern NUMA * numaClone ( NUMA *na );
extern l_int32 numaEmpty ( NUMA *na );
extern l_int32 numaAddNumber ( NUMA *na, l_float32 val );
extern l_int32 numaInsertNumber ( NUMA *na, l_int32 index, l_float32 val );
extern l_int32 numaRemoveNumber ( NUMA *na, l_int32 index );
extern l_int32 numaReplaceNumber ( NUMA *na, l_int32 index, l_float32 val );
extern l_int32 numaGetCount ( NUMA *na );
extern l_int32 numaSetCount ( NUMA *na, l_int32 newcount );
extern l_int32 numaGetFValue ( NUMA *na, l_int32 index, l_float32 *pval );
extern l_int32 numaGetIValue ( NUMA *na, l_int32 index, l_int32 *pival );
extern l_int32 numaSetValue ( NUMA *na, l_int32 index, l_float32 val );
extern l_int32 numaShiftValue ( NUMA *na, l_int32 index, l_float32 diff );
extern l_int32 * numaGetIArray ( NUMA *na );
extern l_float32 * numaGetFArray ( NUMA *na, l_int32 copyflag );
extern l_int32 numaGetRefcount ( NUMA *na );
extern l_int32 numaChangeRefcount ( NUMA *na, l_int32 delta );
extern l_int32 numaGetParameters ( NUMA *na, l_float32 *pstartx, l_float32 *pdelx );
extern l_int32 numaSetParameters ( NUMA *na, l_float32 startx, l_float32 delx );
extern l_int32 numaCopyParameters ( NUMA *nad, NUMA *nas );
extern SARRAY * numaConvertToSarray ( NUMA *na, l_int32 size1, l_int32 size2, l_int32 addzeros, l_int32 type );
extern NUMA * numaRead ( const char *filename );
extern NUMA * numaReadStream ( FILE *fp );
extern l_int32 numaWrite ( const char *filename, NUMA *na );
extern l_int32 numaWriteStream ( FILE *fp, NUMA *na );
extern NUMAA * numaaCreate ( l_int32 n );
extern NUMAA * numaaCreateFull ( l_int32 ntop, l_int32 n );
extern l_int32 numaaTruncate ( NUMAA *naa );
extern void numaaDestroy ( NUMAA **pnaa );
extern l_int32 numaaAddNuma ( NUMAA *naa, NUMA *na, l_int32 copyflag );
extern l_int32 numaaExtendArray ( NUMAA *naa );
extern l_int32 numaaGetCount ( NUMAA *naa );
extern l_int32 numaaGetNumaCount ( NUMAA *naa, l_int32 index );
extern l_int32 numaaGetNumberCount ( NUMAA *naa );
extern NUMA ** numaaGetPtrArray ( NUMAA *naa );
extern NUMA * numaaGetNuma ( NUMAA *naa, l_int32 index, l_int32 accessflag );
extern l_int32 numaaReplaceNuma ( NUMAA *naa, l_int32 index, NUMA *na );
extern l_int32 numaaGetValue ( NUMAA *naa, l_int32 i, l_int32 j, l_float32 *pfval, l_int32 *pival );
extern l_int32 numaaAddNumber ( NUMAA *naa, l_int32 index, l_float32 val );
extern NUMAA * numaaRead ( const char *filename );
extern NUMAA * numaaReadStream ( FILE *fp );
extern l_int32 numaaWrite ( const char *filename, NUMAA *naa );
extern l_int32 numaaWriteStream ( FILE *fp, NUMAA *naa );
extern NUMA2D * numa2dCreate ( l_int32 nrows, l_int32 ncols, l_int32 initsize );
extern void numa2dDestroy ( NUMA2D **pna2d );
extern l_int32 numa2dAddNumber ( NUMA2D *na2d, l_int32 row, l_int32 col, l_float32 val );
extern l_int32 numa2dGetCount ( NUMA2D *na2d, l_int32 row, l_int32 col );
extern NUMA * numa2dGetNuma ( NUMA2D *na2d, l_int32 row, l_int32 col );
extern l_int32 numa2dGetFValue ( NUMA2D *na2d, l_int32 row, l_int32 col, l_int32 index, l_float32 *pval );
extern l_int32 numa2dGetIValue ( NUMA2D *na2d, l_int32 row, l_int32 col, l_int32 index, l_int32 *pval );
extern NUMAHASH * numaHashCreate ( l_int32 nbuckets, l_int32 initsize );
extern void numaHashDestroy ( NUMAHASH **pnahash );
extern NUMA * numaHashGetNuma ( NUMAHASH *nahash, l_uint32 key );
extern l_int32 numaHashAdd ( NUMAHASH *nahash, l_uint32 key, l_float32 value );
extern NUMA * numaArithOp ( NUMA *nad, NUMA *na1, NUMA *na2, l_int32 op );
extern NUMA * numaLogicalOp ( NUMA *nad, NUMA *na1, NUMA *na2, l_int32 op );
extern NUMA * numaInvert ( NUMA *nad, NUMA *nas );
extern l_int32 numaSimilar ( NUMA *na1, NUMA *na2, l_float32 maxdiff, l_int32 *psimilar );
extern l_int32 numaAddToNumber ( NUMA *na, l_int32 index, l_float32 val );
extern l_int32 numaGetMin ( NUMA *na, l_float32 *pminval, l_int32 *piminloc );
extern l_int32 numaGetMax ( NUMA *na, l_float32 *pmaxval, l_int32 *pimaxloc );
extern l_int32 numaGetSum ( NUMA *na, l_float32 *psum );
extern NUMA * numaGetPartialSums ( NUMA *na );
extern l_int32 numaGetSumOnInterval ( NUMA *na, l_int32 first, l_int32 last, l_float32 *psum );
extern l_int32 numaHasOnlyIntegers ( NUMA *na, l_int32 maxsamples, l_int32 *pallints );
extern NUMA * numaSubsample ( NUMA *nas, l_int32 subfactor );
extern NUMA * numaMakeDelta ( NUMA *nas );
extern NUMA * numaMakeSequence ( l_float32 startval, l_float32 increment, l_int32 size );
extern NUMA * numaMakeConstant ( l_float32 val, l_int32 size );
extern NUMA * numaMakeAbsValue ( NUMA *nad, NUMA *nas );
extern NUMA * numaAddBorder ( NUMA *nas, l_int32 left, l_int32 right, l_float32 val );
extern NUMA * numaAddSpecifiedBorder ( NUMA *nas, l_int32 left, l_int32 right, l_int32 type );
extern NUMA * numaRemoveBorder ( NUMA *nas, l_int32 left, l_int32 right );
extern l_int32 numaGetNonzeroRange ( NUMA *na, l_float32 eps, l_int32 *pfirst, l_int32 *plast );
extern l_int32 numaGetCountRelativeToZero ( NUMA *na, l_int32 type, l_int32 *pcount );
extern NUMA * numaClipToInterval ( NUMA *nas, l_int32 first, l_int32 last );
extern NUMA * numaMakeThresholdIndicator ( NUMA *nas, l_float32 thresh, l_int32 type );
extern NUMA * numaUniformSampling ( NUMA *nas, l_int32 nsamp );
extern NUMA * numaReverse ( NUMA *nad, NUMA *nas );
extern NUMA * numaLowPassIntervals ( NUMA *nas, l_float32 thresh, l_float32 maxn );
extern NUMA * numaThresholdEdges ( NUMA *nas, l_float32 thresh1, l_float32 thresh2, l_float32 maxn );
extern l_int32 numaGetSpanValues ( NUMA *na, l_int32 span, l_int32 *pstart, l_int32 *pend );
extern l_int32 numaGetEdgeValues ( NUMA *na, l_int32 edge, l_int32 *pstart, l_int32 *pend, l_int32 *psign );
extern l_int32 numaInterpolateEqxVal ( l_float32 startx, l_float32 deltax, NUMA *nay, l_int32 type, l_float32 xval, l_float32 *pyval );
extern l_int32 numaInterpolateArbxVal ( NUMA *nax, NUMA *nay, l_int32 type, l_float32 xval, l_float32 *pyval );
extern l_int32 numaInterpolateEqxInterval ( l_float32 startx, l_float32 deltax, NUMA *nasy, l_int32 type, l_float32 x0, l_float32 x1, l_int32 npts, NUMA **pnax, NUMA **pnay );
extern l_int32 numaInterpolateArbxInterval ( NUMA *nax, NUMA *nay, l_int32 type, l_float32 x0, l_float32 x1, l_int32 npts, NUMA **pnadx, NUMA **pnady );
extern l_int32 numaFitMax ( NUMA *na, l_float32 *pmaxval, NUMA *naloc, l_float32 *pmaxloc );
extern l_int32 numaDifferentiateInterval ( NUMA *nax, NUMA *nay, l_float32 x0, l_float32 x1, l_int32 npts, NUMA **pnadx, NUMA **pnady );
extern l_int32 numaIntegrateInterval ( NUMA *nax, NUMA *nay, l_float32 x0, l_float32 x1, l_int32 npts, l_float32 *psum );
extern l_int32 numaSortGeneral ( NUMA *na, NUMA **pnasort, NUMA **pnaindex, NUMA **pnainvert, l_int32 sortorder, l_int32 sorttype );
extern NUMA * numaSortAutoSelect ( NUMA *nas, l_int32 sortorder );
extern NUMA * numaSortIndexAutoSelect ( NUMA *nas, l_int32 sortorder );
extern l_int32 numaChooseSortType ( NUMA *nas );
extern NUMA * numaSort ( NUMA *naout, NUMA *nain, l_int32 sortorder );
extern NUMA * numaBinSort ( NUMA *nas, l_int32 sortorder );
extern NUMA * numaGetSortIndex ( NUMA *na, l_int32 sortorder );
extern NUMA * numaGetBinSortIndex ( NUMA *nas, l_int32 sortorder );
extern NUMA * numaSortByIndex ( NUMA *nas, NUMA *naindex );
extern l_int32 numaIsSorted ( NUMA *nas, l_int32 sortorder, l_int32 *psorted );
extern l_int32 numaSortPair ( NUMA *nax, NUMA *nay, l_int32 sortorder, NUMA **pnasx, NUMA **pnasy );
extern NUMA * numaInvertMap ( NUMA *nas );
extern NUMA * numaPseudorandomSequence ( l_int32 size, l_int32 seed );
extern NUMA * numaRandomPermutation ( NUMA *nas, l_int32 seed );
extern l_int32 numaGetRankValue ( NUMA *na, l_float32 fract, NUMA *nasort, l_int32 usebins, l_float32 *pval );
extern l_int32 numaGetMedian ( NUMA *na, l_float32 *pval );
extern l_int32 numaGetBinnedMedian ( NUMA *na, l_int32 *pval );
extern l_int32 numaGetMode ( NUMA *na, l_float32 *pval, l_int32 *pcount );
extern l_int32 numaGetMedianVariation ( NUMA *na, l_float32 *pmedval, l_float32 *pmedvar );
extern l_int32 numaJoin ( NUMA *nad, NUMA *nas, l_int32 istart, l_int32 iend );
extern l_int32 numaaJoin ( NUMAA *naad, NUMAA *naas, l_int32 istart, l_int32 iend );
extern NUMA * numaaFlattenToNuma ( NUMAA *naa );
extern NUMA * numaErode ( NUMA *nas, l_int32 size );
extern NUMA * numaDilate ( NUMA *nas, l_int32 size );
extern NUMA * numaOpen ( NUMA *nas, l_int32 size );
extern NUMA * numaClose ( NUMA *nas, l_int32 size );
extern NUMA * numaTransform ( NUMA *nas, l_float32 shift, l_float32 scale );
extern l_int32 numaWindowedStats ( NUMA *nas, l_int32 wc, NUMA **pnam, NUMA **pnams, NUMA **pnav, NUMA **pnarv );
extern NUMA * numaWindowedMean ( NUMA *nas, l_int32 wc );
extern NUMA * numaWindowedMeanSquare ( NUMA *nas, l_int32 wc );
extern l_int32 numaWindowedVariance ( NUMA *nam, NUMA *nams, NUMA **pnav, NUMA **pnarv );
extern NUMA * numaConvertToInt ( NUMA *nas );
extern NUMA * numaMakeHistogram ( NUMA *na, l_int32 maxbins, l_int32 *pbinsize, l_int32 *pbinstart );
extern NUMA * numaMakeHistogramAuto ( NUMA *na, l_int32 maxbins );
extern NUMA * numaMakeHistogramClipped ( NUMA *na, l_float32 binsize, l_float32 maxsize );
extern NUMA * numaRebinHistogram ( NUMA *nas, l_int32 newsize );
extern NUMA * numaNormalizeHistogram ( NUMA *nas, l_float32 tsum );
extern l_int32 numaGetStatsUsingHistogram ( NUMA *na, l_int32 maxbins, l_float32 *pmin, l_float32 *pmax, l_float32 *pmean, l_float32 *pvariance, l_float32 *pmedian, l_float32 rank, l_float32 *prval, NUMA **phisto );
extern l_int32 numaGetHistogramStats ( NUMA *nahisto, l_float32 startx, l_float32 deltax, l_float32 *pxmean, l_float32 *pxmedian, l_float32 *pxmode, l_float32 *pxvariance );
extern l_int32 numaGetHistogramStatsOnInterval ( NUMA *nahisto, l_float32 startx, l_float32 deltax, l_int32 ifirst, l_int32 ilast, l_float32 *pxmean, l_float32 *pxmedian, l_float32 *pxmode, l_float32 *pxvariance );
extern l_int32 numaMakeRankFromHistogram ( l_float32 startx, l_float32 deltax, NUMA *nasy, l_int32 npts, NUMA **pnax, NUMA **pnay );
extern l_int32 numaHistogramGetRankFromVal ( NUMA *na, l_float32 rval, l_float32 *prank );
extern l_int32 numaHistogramGetValFromRank ( NUMA *na, l_float32 rank, l_float32 *prval );
extern l_int32 numaDiscretizeRankAndIntensity ( NUMA *na, l_int32 nbins, NUMA **pnarbin, NUMA **pnam, NUMA **pnar, NUMA **pnabb );
extern l_int32 numaGetRankBinValues ( NUMA *na, l_int32 nbins, NUMA **pnarbin, NUMA **pnam );
extern l_int32 numaSplitDistribution ( NUMA *na, l_float32 scorefract, l_int32 *psplitindex, l_float32 *pave1, l_float32 *pave2, l_float32 *pnum1, l_float32 *pnum2, NUMA **pnascore );
extern l_int32 numaEarthMoverDistance ( NUMA *na1, NUMA *na2, l_float32 *pdist );
extern NUMA * numaFindPeaks ( NUMA *nas, l_int32 nmax, l_float32 fract1, l_float32 fract2 );
extern NUMA * numaFindExtrema ( NUMA *nas, l_float32 delta );
extern l_int32 numaCountReversals ( NUMA *nas, l_float32 minreversal, l_int32 *pnr, l_float32 *pnrpl );
extern l_int32 numaSelectCrossingThreshold ( NUMA *nax, NUMA *nay, l_float32 estthresh, l_float32 *pbestthresh );
extern NUMA * numaCrossingsByThreshold ( NUMA *nax, NUMA *nay, l_float32 thresh );
extern NUMA * numaCrossingsByPeaks ( NUMA *nax, NUMA *nay, l_float32 delta );
extern l_int32 numaEvalBestHaarParameters ( NUMA *nas, l_float32 relweight, l_int32 nwidth, l_int32 nshift, l_float32 minwidth, l_float32 maxwidth, l_float32 *pbestwidth, l_float32 *pbestshift, l_float32 *pbestscore );
extern l_int32 numaEvalHaarSum ( NUMA *nas, l_float32 width, l_float32 shift, l_float32 relweight, l_float32 *pscore );
extern l_int32 pixGetRegionsBinary ( PIX *pixs, PIX **ppixhm, PIX **ppixtm, PIX **ppixtb, l_int32 debug );
extern PIX * pixGenHalftoneMask ( PIX *pixs, PIX **ppixtext, l_int32 *phtfound, l_int32 debug );
extern PIX * pixGenTextlineMask ( PIX *pixs, PIX **ppixvws, l_int32 *ptlfound, l_int32 debug );
extern PIX * pixGenTextblockMask ( PIX *pixs, PIX *pixvws, l_int32 debug );
extern BOX * pixFindPageForeground ( PIX *pixs, l_int32 threshold, l_int32 mindist, l_int32 erasedist, l_int32 pagenum, l_int32 showmorph, l_int32 display, const char *pdfdir );
extern l_int32 pixSplitIntoCharacters ( PIX *pixs, l_int32 minw, l_int32 minh, BOXA **pboxa, PIXA **ppixa, PIX **ppixdebug );
extern BOXA * pixSplitComponentWithProfile ( PIX *pixs, l_int32 delta, l_int32 mindel, PIX **ppixdebug );
extern l_int32 pixSetSelectCmap ( PIX *pixs, BOX *box, l_int32 sindex, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixColorGrayRegionsCmap ( PIX *pixs, BOXA *boxa, l_int32 type, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixColorGrayCmap ( PIX *pixs, BOX *box, l_int32 type, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 addColorizedGrayToCmap ( PIXCMAP *cmap, l_int32 type, l_int32 rval, l_int32 gval, l_int32 bval, NUMA **pna );
extern l_int32 pixSetSelectMaskedCmap ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 sindex, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixSetMaskedCmap ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 rval, l_int32 gval, l_int32 bval );
extern char * parseForProtos ( const char *filein, const char *prestring );
extern BOXA * boxaGetWhiteblocks ( BOXA *boxas, BOX *box, l_int32 sortflag, l_int32 maxboxes, l_float32 maxoverlap, l_int32 maxperim, l_float32 fract, l_int32 maxpops );
extern BOXA * boxaPruneSortedOnOverlap ( BOXA *boxas, l_float32 maxoverlap );
extern l_int32 convertFilesToPdf ( const char *dirname, const char *substr, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, const char *fileout );
extern l_int32 saConvertFilesToPdf ( SARRAY *sa, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, const char *fileout );
extern l_int32 saConvertFilesToPdfData ( SARRAY *sa, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 selectDefaultPdfEncoding ( PIX *pix, l_int32 *ptype );
extern l_int32 convertUnscaledFilesToPdf ( const char *dirname, const char *substr, const char *title, const char *fileout );
extern l_int32 saConvertUnscaledFilesToPdf ( SARRAY *sa, const char *title, const char *fileout );
extern l_int32 saConvertUnscaledFilesToPdfData ( SARRAY *sa, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 convertUnscaledToPdfData ( const char *fname, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 pixaConvertToPdf ( PIXA *pixa, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, const char *fileout );
extern l_int32 pixaConvertToPdfData ( PIXA *pixa, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 convertToPdf ( const char *filein, l_int32 type, l_int32 quality, const char *fileout, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 convertImageDataToPdf ( l_uint8 *imdata, size_t size, l_int32 type, l_int32 quality, const char *fileout, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 convertToPdfData ( const char *filein, l_int32 type, l_int32 quality, l_uint8 **pdata, size_t *pnbytes, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 convertImageDataToPdfData ( l_uint8 *imdata, size_t size, l_int32 type, l_int32 quality, l_uint8 **pdata, size_t *pnbytes, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 pixConvertToPdf ( PIX *pix, l_int32 type, l_int32 quality, const char *fileout, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 pixWriteStreamPdf ( FILE *fp, PIX *pix, l_int32 res, const char *title );
extern l_int32 pixWriteMemPdf ( l_uint8 **pdata, size_t *pnbytes, PIX *pix, l_int32 res, const char *title );
extern l_int32 convertSegmentedFilesToPdf ( const char *dirname, const char *substr, l_int32 res, l_int32 type, l_int32 thresh, BOXAA *baa, l_int32 quality, l_float32 scalefactor, const char *title, const char *fileout );
extern BOXAA * convertNumberedMasksToBoxaa ( const char *dirname, const char *substr, l_int32 numpre, l_int32 numpost );
extern l_int32 convertToPdfSegmented ( const char *filein, l_int32 res, l_int32 type, l_int32 thresh, BOXA *boxa, l_int32 quality, l_float32 scalefactor, const char *title, const char *fileout );
extern l_int32 pixConvertToPdfSegmented ( PIX *pixs, l_int32 res, l_int32 type, l_int32 thresh, BOXA *boxa, l_int32 quality, l_float32 scalefactor, const char *title, const char *fileout );
extern l_int32 convertToPdfDataSegmented ( const char *filein, l_int32 res, l_int32 type, l_int32 thresh, BOXA *boxa, l_int32 quality, l_float32 scalefactor, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 pixConvertToPdfDataSegmented ( PIX *pixs, l_int32 res, l_int32 type, l_int32 thresh, BOXA *boxa, l_int32 quality, l_float32 scalefactor, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 concatenatePdf ( const char *dirname, const char *substr, const char *fileout );
extern l_int32 saConcatenatePdf ( SARRAY *sa, const char *fileout );
extern l_int32 ptraConcatenatePdf ( L_PTRA *pa, const char *fileout );
extern l_int32 concatenatePdfToData ( const char *dirname, const char *substr, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 saConcatenatePdfToData ( SARRAY *sa, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 pixConvertToPdfData ( PIX *pix, l_int32 type, l_int32 quality, l_uint8 **pdata, size_t *pnbytes, l_int32 x, l_int32 y, l_int32 res, const char *title, L_PDF_DATA **plpd, l_int32 position );
extern l_int32 ptraConcatenatePdfToData ( L_PTRA *pa_data, SARRAY *sa, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 l_generateCIDataForPdf ( const char *fname, PIX *pix, l_int32 quality, L_COMP_DATA **pcid );
extern L_COMP_DATA * l_generateFlateDataPdf ( const char *fname );
extern L_COMP_DATA * l_generateJpegData ( const char *fname, l_int32 ascii85flag );
extern l_int32 l_generateCIData ( const char *fname, l_int32 type, l_int32 quality, l_int32 ascii85, L_COMP_DATA **pcid );
extern l_int32 pixGenerateCIData ( PIX *pixs, l_int32 type, l_int32 quality, l_int32 ascii85, L_COMP_DATA **pcid );
extern L_COMP_DATA * l_generateFlateData ( const char *fname, l_int32 ascii85flag );
extern L_COMP_DATA * l_generateG4Data ( const char *fname, l_int32 ascii85flag );
extern l_int32 cidConvertToPdfData ( L_COMP_DATA *cid, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern void l_CIDataDestroy ( L_COMP_DATA **pcid );
extern void l_pdfSetG4ImageMask ( l_int32 flag );
extern void l_pdfSetDateAndVersion ( l_int32 flag );
extern void setPixMemoryManager ( void * (  ( *allocator ) ( size_t ) ), void  (  ( *deallocator ) ( void * ) ) );
extern PIX * pixCreate ( l_int32 width, l_int32 height, l_int32 depth );
extern PIX * pixCreateNoInit ( l_int32 width, l_int32 height, l_int32 depth );
extern PIX * pixCreateTemplate ( PIX *pixs );
extern PIX * pixCreateTemplateNoInit ( PIX *pixs );
extern PIX * pixCreateHeader ( l_int32 width, l_int32 height, l_int32 depth );
extern PIX * pixClone ( PIX *pixs );
extern void pixDestroy ( PIX **ppix );
extern PIX * pixCopy ( PIX *pixd, PIX *pixs );
extern l_int32 pixResizeImageData ( PIX *pixd, PIX *pixs );
extern l_int32 pixCopyColormap ( PIX *pixd, PIX *pixs );
extern l_int32 pixSizesEqual ( PIX *pix1, PIX *pix2 );
extern l_int32 pixTransferAllData ( PIX *pixd, PIX **ppixs, l_int32 copytext, l_int32 copyformat );
extern l_int32 pixSwapAndDestroy ( PIX **ppixd, PIX **ppixs );
extern l_int32 pixGetWidth ( PIX *pix );
extern l_int32 pixSetWidth ( PIX *pix, l_int32 width );
extern l_int32 pixGetHeight ( PIX *pix );
extern l_int32 pixSetHeight ( PIX *pix, l_int32 height );
extern l_int32 pixGetDepth ( PIX *pix );
extern l_int32 pixSetDepth ( PIX *pix, l_int32 depth );
extern l_int32 pixGetDimensions ( PIX *pix, l_int32 *pw, l_int32 *ph, l_int32 *pd );
extern l_int32 pixSetDimensions ( PIX *pix, l_int32 w, l_int32 h, l_int32 d );
extern l_int32 pixCopyDimensions ( PIX *pixd, PIX *pixs );
extern l_int32 pixGetSpp ( PIX *pix );
extern l_int32 pixSetSpp ( PIX *pix, l_int32 spp );
extern l_int32 pixCopySpp ( PIX *pixd, PIX *pixs );
extern l_int32 pixGetWpl ( PIX *pix );
extern l_int32 pixSetWpl ( PIX *pix, l_int32 wpl );
extern l_int32 pixGetRefcount ( PIX *pix );
extern l_int32 pixChangeRefcount ( PIX *pix, l_int32 delta );
extern l_int32 pixGetXRes ( PIX *pix );
extern l_int32 pixSetXRes ( PIX *pix, l_int32 res );
extern l_int32 pixGetYRes ( PIX *pix );
extern l_int32 pixSetYRes ( PIX *pix, l_int32 res );
extern l_int32 pixGetResolution ( PIX *pix, l_int32 *pxres, l_int32 *pyres );
extern l_int32 pixSetResolution ( PIX *pix, l_int32 xres, l_int32 yres );
extern l_int32 pixCopyResolution ( PIX *pixd, PIX *pixs );
extern l_int32 pixScaleResolution ( PIX *pix, l_float32 xscale, l_float32 yscale );
extern l_int32 pixGetInputFormat ( PIX *pix );
extern l_int32 pixSetInputFormat ( PIX *pix, l_int32 informat );
extern l_int32 pixCopyInputFormat ( PIX *pixd, PIX *pixs );
extern char * pixGetText ( PIX *pix );
extern l_int32 pixSetText ( PIX *pix, const char *textstring );
extern l_int32 pixAddText ( PIX *pix, const char *textstring );
extern l_int32 pixCopyText ( PIX *pixd, PIX *pixs );
extern PIXCMAP * pixGetColormap ( PIX *pix );
extern l_int32 pixSetColormap ( PIX *pix, PIXCMAP *colormap );
extern l_int32 pixDestroyColormap ( PIX *pix );
extern l_uint32 * pixGetData ( PIX *pix );
extern l_int32 pixSetData ( PIX *pix, l_uint32 *data );
extern l_uint32 * pixExtractData ( PIX *pixs );
extern l_int32 pixFreeData ( PIX *pix );
extern void ** pixGetLinePtrs ( PIX *pix, l_int32 *psize );
extern l_int32 pixPrintStreamInfo ( FILE *fp, PIX *pix, const char *text );
extern l_int32 pixGetPixel ( PIX *pix, l_int32 x, l_int32 y, l_uint32 *pval );
extern l_int32 pixSetPixel ( PIX *pix, l_int32 x, l_int32 y, l_uint32 val );
extern l_int32 pixGetRGBPixel ( PIX *pix, l_int32 x, l_int32 y, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern l_int32 pixSetRGBPixel ( PIX *pix, l_int32 x, l_int32 y, l_int32 rval, l_int32 gval, l_int32 bval );
extern l_int32 pixGetRandomPixel ( PIX *pix, l_uint32 *pval, l_int32 *px, l_int32 *py );
extern l_int32 pixClearPixel ( PIX *pix, l_int32 x, l_int32 y );
extern l_int32 pixFlipPixel ( PIX *pix, l_int32 x, l_int32 y );
extern void setPixelLow ( l_uint32 *line, l_int32 x, l_int32 depth, l_uint32 val );
extern l_int32 pixGetBlackOrWhiteVal ( PIX *pixs, l_int32 op, l_uint32 *pval );
extern l_int32 pixClearAll ( PIX *pix );
extern l_int32 pixSetAll ( PIX *pix );
extern l_int32 pixSetAllGray ( PIX *pix, l_int32 grayval );
extern l_int32 pixSetAllArbitrary ( PIX *pix, l_uint32 val );
extern l_int32 pixSetBlackOrWhite ( PIX *pixs, l_int32 op );
extern l_int32 pixSetComponentArbitrary ( PIX *pix, l_int32 comp, l_int32 val );
extern l_int32 pixClearInRect ( PIX *pix, BOX *box );
extern l_int32 pixSetInRect ( PIX *pix, BOX *box );
extern l_int32 pixSetInRectArbitrary ( PIX *pix, BOX *box, l_uint32 val );
extern l_int32 pixBlendInRect ( PIX *pixs, BOX *box, l_uint32 val, l_float32 fract );
extern l_int32 pixSetPadBits ( PIX *pix, l_int32 val );
extern l_int32 pixSetPadBitsBand ( PIX *pix, l_int32 by, l_int32 bh, l_int32 val );
extern l_int32 pixSetOrClearBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot, l_int32 op );
extern l_int32 pixSetBorderVal ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot, l_uint32 val );
extern l_int32 pixSetBorderRingVal ( PIX *pixs, l_int32 dist, l_uint32 val );
extern l_int32 pixSetMirroredBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixCopyBorder ( PIX *pixd, PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixAddBorder ( PIX *pixs, l_int32 npix, l_uint32 val );
extern PIX * pixAddBlackOrWhiteBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot, l_int32 op );
extern PIX * pixAddBorderGeneral ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot, l_uint32 val );
extern PIX * pixRemoveBorder ( PIX *pixs, l_int32 npix );
extern PIX * pixRemoveBorderGeneral ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixRemoveBorderToSize ( PIX *pixs, l_int32 wd, l_int32 hd );
extern PIX * pixAddMirroredBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixAddRepeatedBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixAddMixedBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern PIX * pixAddContinuedBorder ( PIX *pixs, l_int32 left, l_int32 right, l_int32 top, l_int32 bot );
extern l_int32 pixShiftAndTransferAlpha ( PIX *pixd, PIX *pixs, l_float32 shiftx, l_float32 shifty );
extern PIX * pixDisplayLayersRGBA ( PIX *pixs, l_uint32 val, l_int32 maxw );
extern PIX * pixCreateRGBImage ( PIX *pixr, PIX *pixg, PIX *pixb );
extern PIX * pixGetRGBComponent ( PIX *pixs, l_int32 comp );
extern l_int32 pixSetRGBComponent ( PIX *pixd, PIX *pixs, l_int32 comp );
extern PIX * pixGetRGBComponentCmap ( PIX *pixs, l_int32 comp );
extern l_int32 pixCopyRGBComponent ( PIX *pixd, PIX *pixs, l_int32 comp );
extern l_int32 composeRGBPixel ( l_int32 rval, l_int32 gval, l_int32 bval, l_uint32 *ppixel );
extern l_int32 composeRGBAPixel ( l_int32 rval, l_int32 gval, l_int32 bval, l_int32 aval, l_uint32 *ppixel );
extern void extractRGBValues ( l_uint32 pixel, l_int32 *prval, l_int32 *pgval, l_int32 *pbval );
extern void extractRGBAValues ( l_uint32 pixel, l_int32 *prval, l_int32 *pgval, l_int32 *pbval, l_int32 *paval );
extern l_int32 extractMinMaxComponent ( l_uint32 pixel, l_int32 type );
extern l_int32 pixGetRGBLine ( PIX *pixs, l_int32 row, l_uint8 *bufr, l_uint8 *bufg, l_uint8 *bufb );
extern PIX * pixEndianByteSwapNew ( PIX *pixs );
extern l_int32 pixEndianByteSwap ( PIX *pixs );
extern l_int32 lineEndianByteSwap ( l_uint32 *datad, l_uint32 *datas, l_int32 wpl );
extern PIX * pixEndianTwoByteSwapNew ( PIX *pixs );
extern l_int32 pixEndianTwoByteSwap ( PIX *pixs );
extern l_int32 pixGetRasterData ( PIX *pixs, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 pixAlphaIsOpaque ( PIX *pix, l_int32 *popaque );
extern l_uint8 ** pixSetupByteProcessing ( PIX *pix, l_int32 *pw, l_int32 *ph );
extern l_int32 pixCleanupByteProcessing ( PIX *pix, l_uint8 **lineptrs );
extern void l_setAlphaMaskBorder ( l_float32 val1, l_float32 val2 );
extern l_int32 pixSetMasked ( PIX *pixd, PIX *pixm, l_uint32 val );
extern l_int32 pixSetMaskedGeneral ( PIX *pixd, PIX *pixm, l_uint32 val, l_int32 x, l_int32 y );
extern l_int32 pixCombineMasked ( PIX *pixd, PIX *pixs, PIX *pixm );
extern l_int32 pixCombineMaskedGeneral ( PIX *pixd, PIX *pixs, PIX *pixm, l_int32 x, l_int32 y );
extern l_int32 pixPaintThroughMask ( PIX *pixd, PIX *pixm, l_int32 x, l_int32 y, l_uint32 val );
extern l_int32 pixPaintSelfThroughMask ( PIX *pixd, PIX *pixm, l_int32 x, l_int32 y, l_int32 tilesize, l_int32 searchdir );
extern PIX * pixMakeMaskFromLUT ( PIX *pixs, l_int32 *tab );
extern PIX * pixSetUnderTransparency ( PIX *pixs, l_uint32 val, l_int32 debug );
extern PIX * pixInvert ( PIX *pixd, PIX *pixs );
extern PIX * pixOr ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern PIX * pixAnd ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern PIX * pixXor ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern PIX * pixSubtract ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern l_int32 pixZero ( PIX *pix, l_int32 *pempty );
extern l_int32 pixForegroundFraction ( PIX *pix, l_float32 *pfract );
extern NUMA * pixaCountPixels ( PIXA *pixa );
extern l_int32 pixCountPixels ( PIX *pix, l_int32 *pcount, l_int32 *tab8 );
extern NUMA * pixCountByRow ( PIX *pix, BOX *box );
extern NUMA * pixCountByColumn ( PIX *pix, BOX *box );
extern NUMA * pixCountPixelsByRow ( PIX *pix, l_int32 *tab8 );
extern NUMA * pixCountPixelsByColumn ( PIX *pix );
extern l_int32 pixCountPixelsInRow ( PIX *pix, l_int32 row, l_int32 *pcount, l_int32 *tab8 );
extern NUMA * pixGetMomentByColumn ( PIX *pix, l_int32 order );
extern l_int32 pixThresholdPixelSum ( PIX *pix, l_int32 thresh, l_int32 *pabove, l_int32 *tab8 );
extern l_int32 * makePixelSumTab8 ( void );
extern l_int32 * makePixelCentroidTab8 ( void );
extern NUMA * pixAverageByRow ( PIX *pix, BOX *box, l_int32 type );
extern NUMA * pixAverageByColumn ( PIX *pix, BOX *box, l_int32 type );
extern l_int32 pixAverageInRect ( PIX *pix, BOX *box, l_float32 *pave );
extern NUMA * pixVarianceByRow ( PIX *pix, BOX *box );
extern NUMA * pixVarianceByColumn ( PIX *pix, BOX *box );
extern l_int32 pixVarianceInRect ( PIX *pix, BOX *box, l_float32 *prootvar );
extern NUMA * pixAbsDiffByRow ( PIX *pix, BOX *box );
extern NUMA * pixAbsDiffByColumn ( PIX *pix, BOX *box );
extern l_int32 pixAbsDiffInRect ( PIX *pix, BOX *box, l_int32 dir, l_float32 *pabsdiff );
extern l_int32 pixAbsDiffOnLine ( PIX *pix, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_float32 *pabsdiff );
extern l_int32 pixCountArbInRect ( PIX *pixs, BOX *box, l_int32 val, l_int32 factor, l_int32 *pcount );
extern PIX * pixMirroredTiling ( PIX *pixs, l_int32 w, l_int32 h );
extern NUMA * pixGetGrayHistogram ( PIX *pixs, l_int32 factor );
extern NUMA * pixGetGrayHistogramMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor );
extern NUMA * pixGetGrayHistogramInRect ( PIX *pixs, BOX *box, l_int32 factor );
extern l_int32 pixGetColorHistogram ( PIX *pixs, l_int32 factor, NUMA **pnar, NUMA **pnag, NUMA **pnab );
extern l_int32 pixGetColorHistogramMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor, NUMA **pnar, NUMA **pnag, NUMA **pnab );
extern NUMA * pixGetCmapHistogram ( PIX *pixs, l_int32 factor );
extern NUMA * pixGetCmapHistogramMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor );
extern NUMA * pixGetCmapHistogramInRect ( PIX *pixs, BOX *box, l_int32 factor );
extern l_int32 pixGetRankValue ( PIX *pixs, l_int32 factor, l_float32 rank, l_uint32 *pvalue );
extern l_int32 pixGetRankValueMaskedRGB ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor, l_float32 rank, l_float32 *prval, l_float32 *pgval, l_float32 *pbval );
extern l_int32 pixGetRankValueMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor, l_float32 rank, l_float32 *pval, NUMA **pna );
extern l_int32 pixGetAverageValue ( PIX *pixs, l_int32 factor, l_int32 type, l_uint32 *pvalue );
extern l_int32 pixGetAverageMaskedRGB ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor, l_int32 type, l_float32 *prval, l_float32 *pgval, l_float32 *pbval );
extern l_int32 pixGetAverageMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_int32 factor, l_int32 type, l_float32 *pval );
extern l_int32 pixGetAverageTiledRGB ( PIX *pixs, l_int32 sx, l_int32 sy, l_int32 type, PIX **ppixr, PIX **ppixg, PIX **ppixb );
extern PIX * pixGetAverageTiled ( PIX *pixs, l_int32 sx, l_int32 sy, l_int32 type );
extern l_int32 pixRowStats ( PIX *pixs, BOX *box, NUMA **pnamean, NUMA **pnamedian, NUMA **pnamode, NUMA **pnamodecount, NUMA **pnavar, NUMA **pnarootvar );
extern l_int32 pixColumnStats ( PIX *pixs, BOX *box, NUMA **pnamean, NUMA **pnamedian, NUMA **pnamode, NUMA **pnamodecount, NUMA **pnavar, NUMA **pnarootvar );
extern l_int32 pixGetComponentRange ( PIX *pixs, l_int32 factor, l_int32 color, l_int32 *pminval, l_int32 *pmaxval );
extern l_int32 pixGetExtremeValue ( PIX *pixs, l_int32 factor, l_int32 type, l_int32 *prval, l_int32 *pgval, l_int32 *pbval, l_int32 *pgrayval );
extern l_int32 pixGetMaxValueInRect ( PIX *pixs, BOX *box, l_uint32 *pmaxval, l_int32 *pxmax, l_int32 *pymax );
extern l_int32 pixGetBinnedComponentRange ( PIX *pixs, l_int32 nbins, l_int32 factor, l_int32 color, l_int32 *pminval, l_int32 *pmaxval, l_uint32 **pcarray, const char *fontdir );
extern l_int32 pixGetRankColorArray ( PIX *pixs, l_int32 nbins, l_int32 type, l_int32 factor, l_uint32 **pcarray, l_int32 debugflag, const char *fontdir );
extern l_int32 pixGetBinnedColor ( PIX *pixs, PIX *pixg, l_int32 factor, l_int32 nbins, NUMA *nalut, l_uint32 **pcarray, l_int32 debugflag );
extern PIX * pixDisplayColorArray ( l_uint32 *carray, l_int32 ncolors, l_int32 side, l_int32 ncols, const char *fontdir );
extern PIX * pixRankBinByStrip ( PIX *pixs, l_int32 direction, l_int32 size, l_int32 nbins, l_int32 type );
extern PIX * pixaGetAlignedStats ( PIXA *pixa, l_int32 type, l_int32 nbins, l_int32 thresh );
extern l_int32 pixaExtractColumnFromEachPix ( PIXA *pixa, l_int32 col, PIX *pixd );
extern l_int32 pixGetRowStats ( PIX *pixs, l_int32 type, l_int32 nbins, l_int32 thresh, l_float32 *colvect );
extern l_int32 pixGetColumnStats ( PIX *pixs, l_int32 type, l_int32 nbins, l_int32 thresh, l_float32 *rowvect );
extern l_int32 pixSetPixelColumn ( PIX *pix, l_int32 col, l_float32 *colvect );
extern l_int32 pixThresholdForFgBg ( PIX *pixs, l_int32 factor, l_int32 thresh, l_int32 *pfgval, l_int32 *pbgval );
extern l_int32 pixSplitDistributionFgBg ( PIX *pixs, l_float32 scorefract, l_int32 factor, l_int32 *pthresh, l_int32 *pfgval, l_int32 *pbgval, l_int32 debugflag );
extern l_int32 pixaFindDimensions ( PIXA *pixa, NUMA **pnaw, NUMA **pnah );
extern l_int32 pixFindAreaPerimRatio ( PIX *pixs, l_int32 *tab, l_float32 *pfract );
extern NUMA * pixaFindPerimToAreaRatio ( PIXA *pixa );
extern l_int32 pixFindPerimToAreaRatio ( PIX *pixs, l_int32 *tab, l_float32 *pfract );
extern NUMA * pixaFindPerimSizeRatio ( PIXA *pixa );
extern l_int32 pixFindPerimSizeRatio ( PIX *pixs, l_int32 *tab, l_float32 *pratio );
extern NUMA * pixaFindAreaFraction ( PIXA *pixa );
extern l_int32 pixFindAreaFraction ( PIX *pixs, l_int32 *tab, l_float32 *pfract );
extern NUMA * pixaFindAreaFractionMasked ( PIXA *pixa, PIX *pixm, l_int32 debug );
extern l_int32 pixFindAreaFractionMasked ( PIX *pixs, BOX *box, PIX *pixm, l_int32 *tab, l_float32 *pfract );
extern NUMA * pixaFindWidthHeightRatio ( PIXA *pixa );
extern NUMA * pixaFindWidthHeightProduct ( PIXA *pixa );
extern l_int32 pixFindOverlapFraction ( PIX *pixs1, PIX *pixs2, l_int32 x2, l_int32 y2, l_int32 *tab, l_float32 *pratio, l_int32 *pnoverlap );
extern BOXA * pixFindRectangleComps ( PIX *pixs, l_int32 dist, l_int32 minw, l_int32 minh );
extern l_int32 pixConformsToRectangle ( PIX *pixs, BOX *box, l_int32 dist, l_int32 *pconforms );
extern PIXA * pixClipRectangles ( PIX *pixs, BOXA *boxa );
extern PIX * pixClipRectangle ( PIX *pixs, BOX *box, BOX **pboxc );
extern PIX * pixClipMasked ( PIX *pixs, PIX *pixm, l_int32 x, l_int32 y, l_uint32 outval );
extern l_int32 pixCropToMatch ( PIX *pixs1, PIX *pixs2, PIX **ppixd1, PIX **ppixd2 );
extern PIX * pixCropToSize ( PIX *pixs, l_int32 w, l_int32 h );
extern PIX * pixResizeToMatch ( PIX *pixs, PIX *pixt, l_int32 w, l_int32 h );
extern l_int32 pixClipToForeground ( PIX *pixs, PIX **ppixd, BOX **pbox );
extern l_int32 pixTestClipToForeground ( PIX *pixs, l_int32 *pcanclip );
extern l_int32 pixClipBoxToForeground ( PIX *pixs, BOX *boxs, PIX **ppixd, BOX **pboxd );
extern l_int32 pixScanForForeground ( PIX *pixs, BOX *box, l_int32 scanflag, l_int32 *ploc );
extern l_int32 pixClipBoxToEdges ( PIX *pixs, BOX *boxs, l_int32 lowthresh, l_int32 highthresh, l_int32 maxwidth, l_int32 factor, PIX **ppixd, BOX **pboxd );
extern l_int32 pixScanForEdge ( PIX *pixs, BOX *box, l_int32 lowthresh, l_int32 highthresh, l_int32 maxwidth, l_int32 factor, l_int32 scanflag, l_int32 *ploc );
extern NUMA * pixExtractOnLine ( PIX *pixs, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 factor );
extern l_float32 pixAverageOnLine ( PIX *pixs, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 factor );
extern NUMA * pixAverageIntensityProfile ( PIX *pixs, l_float32 fract, l_int32 dir, l_int32 first, l_int32 last, l_int32 factor1, l_int32 factor2 );
extern NUMA * pixReversalProfile ( PIX *pixs, l_float32 fract, l_int32 dir, l_int32 first, l_int32 last, l_int32 minreversal, l_int32 factor1, l_int32 factor2 );
extern l_int32 pixWindowedVarianceOnLine ( PIX *pixs, l_int32 dir, l_int32 loc, l_int32 c1, l_int32 c2, l_int32 size, NUMA **pnad );
extern l_int32 pixMinMaxNearLine ( PIX *pixs, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2, l_int32 dist, l_int32 direction, NUMA **pnamin, NUMA **pnamax, l_float32 *pminave, l_float32 *pmaxave );
extern PIX * pixRankRowTransform ( PIX *pixs );
extern PIX * pixRankColumnTransform ( PIX *pixs );
extern PIXA * pixaCreate ( l_int32 n );
extern PIXA * pixaCreateFromPix ( PIX *pixs, l_int32 n, l_int32 cellw, l_int32 cellh );
extern PIXA * pixaCreateFromBoxa ( PIX *pixs, BOXA *boxa, l_int32 *pcropwarn );
extern PIXA * pixaSplitPix ( PIX *pixs, l_int32 nx, l_int32 ny, l_int32 borderwidth, l_uint32 bordercolor );
extern void pixaDestroy ( PIXA **ppixa );
extern PIXA * pixaCopy ( PIXA *pixa, l_int32 copyflag );
extern l_int32 pixaAddPix ( PIXA *pixa, PIX *pix, l_int32 copyflag );
extern l_int32 pixaAddBox ( PIXA *pixa, BOX *box, l_int32 copyflag );
extern l_int32 pixaExtendArrayToSize ( PIXA *pixa, l_int32 size );
extern l_int32 pixaGetCount ( PIXA *pixa );
extern l_int32 pixaChangeRefcount ( PIXA *pixa, l_int32 delta );
extern PIX * pixaGetPix ( PIXA *pixa, l_int32 index, l_int32 accesstype );
extern l_int32 pixaGetPixDimensions ( PIXA *pixa, l_int32 index, l_int32 *pw, l_int32 *ph, l_int32 *pd );
extern BOXA * pixaGetBoxa ( PIXA *pixa, l_int32 accesstype );
extern l_int32 pixaGetBoxaCount ( PIXA *pixa );
extern BOX * pixaGetBox ( PIXA *pixa, l_int32 index, l_int32 accesstype );
extern l_int32 pixaGetBoxGeometry ( PIXA *pixa, l_int32 index, l_int32 *px, l_int32 *py, l_int32 *pw, l_int32 *ph );
extern l_int32 pixaSetBoxa ( PIXA *pixa, BOXA *boxa, l_int32 accesstype );
extern PIX ** pixaGetPixArray ( PIXA *pixa );
extern l_int32 pixaVerifyDepth ( PIXA *pixa, l_int32 *pmaxdepth );
extern l_int32 pixaIsFull ( PIXA *pixa, l_int32 *pfullpa, l_int32 *pfullba );
extern l_int32 pixaCountText ( PIXA *pixa, l_int32 *pntext );
extern void *** pixaGetLinePtrs ( PIXA *pixa, l_int32 *psize );
extern l_int32 pixaReplacePix ( PIXA *pixa, l_int32 index, PIX *pix, BOX *box );
extern l_int32 pixaInsertPix ( PIXA *pixa, l_int32 index, PIX *pixs, BOX *box );
extern l_int32 pixaRemovePix ( PIXA *pixa, l_int32 index );
extern l_int32 pixaRemovePixAndSave ( PIXA *pixa, l_int32 index, PIX **ppix, BOX **pbox );
extern l_int32 pixaInitFull ( PIXA *pixa, PIX *pix, BOX *box );
extern l_int32 pixaClear ( PIXA *pixa );
extern l_int32 pixaJoin ( PIXA *pixad, PIXA *pixas, l_int32 istart, l_int32 iend );
extern l_int32 pixaaJoin ( PIXAA *paad, PIXAA *paas, l_int32 istart, l_int32 iend );
extern PIXAA * pixaaCreate ( l_int32 n );
extern PIXAA * pixaaCreateFromPixa ( PIXA *pixa, l_int32 n, l_int32 type, l_int32 copyflag );
extern void pixaaDestroy ( PIXAA **ppaa );
extern l_int32 pixaaAddPixa ( PIXAA *paa, PIXA *pixa, l_int32 copyflag );
extern l_int32 pixaaExtendArray ( PIXAA *paa );
extern l_int32 pixaaAddPix ( PIXAA *paa, l_int32 index, PIX *pix, BOX *box, l_int32 copyflag );
extern l_int32 pixaaAddBox ( PIXAA *paa, BOX *box, l_int32 copyflag );
extern l_int32 pixaaGetCount ( PIXAA *paa, NUMA **pna );
extern PIXA * pixaaGetPixa ( PIXAA *paa, l_int32 index, l_int32 accesstype );
extern BOXA * pixaaGetBoxa ( PIXAA *paa, l_int32 accesstype );
extern PIX * pixaaGetPix ( PIXAA *paa, l_int32 index, l_int32 ipix, l_int32 accessflag );
extern l_int32 pixaaVerifyDepth ( PIXAA *paa, l_int32 *pmaxdepth );
extern l_int32 pixaaIsFull ( PIXAA *paa, l_int32 *pfull );
extern l_int32 pixaaInitFull ( PIXAA *paa, PIXA *pixa );
extern l_int32 pixaaReplacePixa ( PIXAA *paa, l_int32 index, PIXA *pixa );
extern l_int32 pixaaClear ( PIXAA *paa );
extern l_int32 pixaaTruncate ( PIXAA *paa );
extern PIXA * pixaRead ( const char *filename );
extern PIXA * pixaReadStream ( FILE *fp );
extern l_int32 pixaWrite ( const char *filename, PIXA *pixa );
extern l_int32 pixaWriteStream ( FILE *fp, PIXA *pixa );
extern PIXAA * pixaaReadFromFiles ( const char *dirname, const char *substr, l_int32 first, l_int32 nfiles );
extern PIXAA * pixaaRead ( const char *filename );
extern PIXAA * pixaaReadStream ( FILE *fp );
extern l_int32 pixaaWrite ( const char *filename, PIXAA *paa );
extern l_int32 pixaaWriteStream ( FILE *fp, PIXAA *paa );
extern PIXACC * pixaccCreate ( l_int32 w, l_int32 h, l_int32 negflag );
extern PIXACC * pixaccCreateFromPix ( PIX *pix, l_int32 negflag );
extern void pixaccDestroy ( PIXACC **ppixacc );
extern PIX * pixaccFinal ( PIXACC *pixacc, l_int32 outdepth );
extern PIX * pixaccGetPix ( PIXACC *pixacc );
extern l_int32 pixaccGetOffset ( PIXACC *pixacc );
extern l_int32 pixaccAdd ( PIXACC *pixacc, PIX *pix );
extern l_int32 pixaccSubtract ( PIXACC *pixacc, PIX *pix );
extern l_int32 pixaccMultConst ( PIXACC *pixacc, l_float32 factor );
extern l_int32 pixaccMultConstAccumulate ( PIXACC *pixacc, PIX *pix, l_float32 factor );
extern PIX * pixSelectBySize ( PIX *pixs, l_int32 width, l_int32 height, l_int32 connectivity, l_int32 type, l_int32 relation, l_int32 *pchanged );
extern PIXA * pixaSelectBySize ( PIXA *pixas, l_int32 width, l_int32 height, l_int32 type, l_int32 relation, l_int32 *pchanged );
extern NUMA * pixaMakeSizeIndicator ( PIXA *pixa, l_int32 width, l_int32 height, l_int32 type, l_int32 relation );
extern PIX * pixSelectByPerimToAreaRatio ( PIX *pixs, l_float32 thresh, l_int32 connectivity, l_int32 type, l_int32 *pchanged );
extern PIXA * pixaSelectByPerimToAreaRatio ( PIXA *pixas, l_float32 thresh, l_int32 type, l_int32 *pchanged );
extern PIX * pixSelectByPerimSizeRatio ( PIX *pixs, l_float32 thresh, l_int32 connectivity, l_int32 type, l_int32 *pchanged );
extern PIXA * pixaSelectByPerimSizeRatio ( PIXA *pixas, l_float32 thresh, l_int32 type, l_int32 *pchanged );
extern PIX * pixSelectByAreaFraction ( PIX *pixs, l_float32 thresh, l_int32 connectivity, l_int32 type, l_int32 *pchanged );
extern PIXA * pixaSelectByAreaFraction ( PIXA *pixas, l_float32 thresh, l_int32 type, l_int32 *pchanged );
extern PIX * pixSelectByWidthHeightRatio ( PIX *pixs, l_float32 thresh, l_int32 connectivity, l_int32 type, l_int32 *pchanged );
extern PIXA * pixaSelectByWidthHeightRatio ( PIXA *pixas, l_float32 thresh, l_int32 type, l_int32 *pchanged );
extern PIXA * pixaSelectWithIndicator ( PIXA *pixas, NUMA *na, l_int32 *pchanged );
extern l_int32 pixRemoveWithIndicator ( PIX *pixs, PIXA *pixa, NUMA *na );
extern l_int32 pixAddWithIndicator ( PIX *pixs, PIXA *pixa, NUMA *na );
extern PIX * pixaRenderComponent ( PIX *pixs, PIXA *pixa, l_int32 index );
extern PIXA * pixaSort ( PIXA *pixas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex, l_int32 copyflag );
extern PIXA * pixaBinSort ( PIXA *pixas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex, l_int32 copyflag );
extern PIXA * pixaSortByIndex ( PIXA *pixas, NUMA *naindex, l_int32 copyflag );
extern PIXAA * pixaSort2dByIndex ( PIXA *pixas, NUMAA *naa, l_int32 copyflag );
extern PIXA * pixaSelectRange ( PIXA *pixas, l_int32 first, l_int32 last, l_int32 copyflag );
extern PIXAA * pixaaSelectRange ( PIXAA *paas, l_int32 first, l_int32 last, l_int32 copyflag );
extern PIXAA * pixaaScaleToSize ( PIXAA *paas, l_int32 wd, l_int32 hd );
extern PIXAA * pixaaScaleToSizeVar ( PIXAA *paas, NUMA *nawd, NUMA *nahd );
extern PIXA * pixaScaleToSize ( PIXA *pixas, l_int32 wd, l_int32 hd );
extern PIXA * pixaAddBorderGeneral ( PIXA *pixad, PIXA *pixas, l_int32 left, l_int32 right, l_int32 top, l_int32 bot, l_uint32 val );
extern PIXA * pixaaFlattenToPixa ( PIXAA *paa, NUMA **pnaindex, l_int32 copyflag );
extern l_int32 pixaaSizeRange ( PIXAA *paa, l_int32 *pminw, l_int32 *pminh, l_int32 *pmaxw, l_int32 *pmaxh );
extern l_int32 pixaSizeRange ( PIXA *pixa, l_int32 *pminw, l_int32 *pminh, l_int32 *pmaxw, l_int32 *pmaxh );
extern PIXA * pixaClipToPix ( PIXA *pixas, PIX *pixs );
extern l_int32 pixaGetRenderingDepth ( PIXA *pixa, l_int32 *pdepth );
extern l_int32 pixaHasColor ( PIXA *pixa, l_int32 *phascolor );
extern l_int32 pixaAnyColormaps ( PIXA *pixa, l_int32 *phascmap );
extern l_int32 pixaGetDepthInfo ( PIXA *pixa, l_int32 *pmaxdepth, l_int32 *psame );
extern PIXA * pixaConvertToSameDepth ( PIXA *pixas );
extern l_int32 pixaEqual ( PIXA *pixa1, PIXA *pixa2, l_int32 maxdist, NUMA **pnaindex, l_int32 *psame );
extern PIX * pixaDisplay ( PIXA *pixa, l_int32 w, l_int32 h );
extern PIX * pixaDisplayOnColor ( PIXA *pixa, l_int32 w, l_int32 h, l_uint32 bgcolor );
extern PIX * pixaDisplayRandomCmap ( PIXA *pixa, l_int32 w, l_int32 h );
extern PIX * pixaDisplayLinearly ( PIXA *pixas, l_int32 direction, l_float32 scalefactor, l_int32 background, l_int32 spacing, l_int32 border, BOXA **pboxa );
extern PIX * pixaDisplayOnLattice ( PIXA *pixa, l_int32 cellw, l_int32 cellh, l_int32 *pncols, BOXA **pboxa );
extern PIX * pixaDisplayUnsplit ( PIXA *pixa, l_int32 nx, l_int32 ny, l_int32 borderwidth, l_uint32 bordercolor );
extern PIX * pixaDisplayTiled ( PIXA *pixa, l_int32 maxwidth, l_int32 background, l_int32 spacing );
extern PIX * pixaDisplayTiledInRows ( PIXA *pixa, l_int32 outdepth, l_int32 maxwidth, l_float32 scalefactor, l_int32 background, l_int32 spacing, l_int32 border );
extern PIX * pixaDisplayTiledAndScaled ( PIXA *pixa, l_int32 outdepth, l_int32 tilewidth, l_int32 ncols, l_int32 background, l_int32 spacing, l_int32 border );
extern PIX * pixaaDisplay ( PIXAA *paa, l_int32 w, l_int32 h );
extern PIX * pixaaDisplayByPixa ( PIXAA *paa, l_int32 xspace, l_int32 yspace, l_int32 maxw );
extern PIXA * pixaaDisplayTiledAndScaled ( PIXAA *paa, l_int32 outdepth, l_int32 tilewidth, l_int32 ncols, l_int32 background, l_int32 spacing, l_int32 border );
extern PIXA * pixaConvertTo1 ( PIXA *pixas, l_int32 thresh );
extern PIXA * pixaConvertTo8 ( PIXA *pixas, l_int32 cmapflag );
extern PIXA * pixaConvertTo8Color ( PIXA *pixas, l_int32 dither );
extern PIXA * pixaConvertTo32 ( PIXA *pixas );
extern l_int32 convertToNUpFiles ( const char *dir, const char *substr, l_int32 nx, l_int32 ny, l_int32 tw, l_int32 spacing, l_int32 border, const char *fontdir, const char *outdir );
extern PIXA * convertToNUpPixa ( const char *dir, const char *substr, l_int32 nx, l_int32 ny, l_int32 tw, l_int32 spacing, l_int32 border, const char *fontdir );
extern l_int32 pmsCreate ( size_t minsize, size_t smallest, NUMA *numalloc, const char *logfile );
extern void pmsDestroy (  );
extern void * pmsCustomAlloc ( size_t nbytes );
extern void pmsCustomDealloc ( void *data );
extern void * pmsGetAlloc ( size_t nbytes );
extern l_int32 pmsGetLevelForAlloc ( size_t nbytes, l_int32 *plevel );
extern l_int32 pmsGetLevelForDealloc ( void *data, l_int32 *plevel );
extern void pmsLogInfo (  );
extern l_int32 pixAddConstantGray ( PIX *pixs, l_int32 val );
extern l_int32 pixMultConstantGray ( PIX *pixs, l_float32 val );
extern PIX * pixAddGray ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern PIX * pixSubtractGray ( PIX *pixd, PIX *pixs1, PIX *pixs2 );
extern PIX * pixThresholdToValue ( PIX *pixd, PIX *pixs, l_int32 threshval, l_int32 setval );
extern PIX * pixInitAccumulate ( l_int32 w, l_int32 h, l_uint32 offset );
extern PIX * pixFinalAccumulate ( PIX *pixs, l_uint32 offset, l_int32 depth );
extern PIX * pixFinalAccumulateThreshold ( PIX *pixs, l_uint32 offset, l_uint32 threshold );
extern l_int32 pixAccumulate ( PIX *pixd, PIX *pixs, l_int32 op );
extern l_int32 pixMultConstAccumulate ( PIX *pixs, l_float32 factor, l_uint32 offset );
extern PIX * pixAbsDifference ( PIX *pixs1, PIX *pixs2 );
extern PIX * pixAddRGB ( PIX *pixs1, PIX *pixs2 );
extern PIX * pixMinOrMax ( PIX *pixd, PIX *pixs1, PIX *pixs2, l_int32 type );
extern PIX * pixMaxDynamicRange ( PIX *pixs, l_int32 type );
extern l_float32 * makeLogBase2Tab ( void );
extern l_float32 getLogBase2 ( l_int32 val, l_float32 *logtab );
extern PIXC * pixcompCreateFromPix ( PIX *pix, l_int32 comptype );
extern PIXC * pixcompCreateFromString ( l_uint8 *data, size_t size, l_int32 copyflag );
extern PIXC * pixcompCreateFromFile ( const char *filename, l_int32 comptype );
extern void pixcompDestroy ( PIXC **ppixc );
extern l_int32 pixcompGetDimensions ( PIXC *pixc, l_int32 *pw, l_int32 *ph, l_int32 *pd );
extern l_int32 pixcompDetermineFormat ( l_int32 comptype, l_int32 d, l_int32 cmapflag, l_int32 *pformat );
extern PIX * pixCreateFromPixcomp ( PIXC *pixc );
extern PIXAC * pixacompCreate ( l_int32 n );
extern PIXAC * pixacompCreateWithInit ( l_int32 n, l_int32 offset, PIX *pix, l_int32 comptype );
extern PIXAC * pixacompCreateFromPixa ( PIXA *pixa, l_int32 comptype, l_int32 accesstype );
extern PIXAC * pixacompCreateFromFiles ( const char *dirname, const char *substr, l_int32 comptype );
extern PIXAC * pixacompCreateFromSA ( SARRAY *sa, l_int32 comptype );
extern void pixacompDestroy ( PIXAC **ppixac );
extern l_int32 pixacompAddPix ( PIXAC *pixac, PIX *pix, l_int32 comptype );
extern l_int32 pixacompAddPixcomp ( PIXAC *pixac, PIXC *pixc );
extern l_int32 pixacompReplacePix ( PIXAC *pixac, l_int32 index, PIX *pix, l_int32 comptype );
extern l_int32 pixacompReplacePixcomp ( PIXAC *pixac, l_int32 index, PIXC *pixc );
extern l_int32 pixacompAddBox ( PIXAC *pixac, BOX *box, l_int32 copyflag );
extern l_int32 pixacompGetCount ( PIXAC *pixac );
extern PIXC * pixacompGetPixcomp ( PIXAC *pixac, l_int32 index );
extern PIX * pixacompGetPix ( PIXAC *pixac, l_int32 index );
extern l_int32 pixacompGetPixDimensions ( PIXAC *pixac, l_int32 index, l_int32 *pw, l_int32 *ph, l_int32 *pd );
extern BOXA * pixacompGetBoxa ( PIXAC *pixac, l_int32 accesstype );
extern l_int32 pixacompGetBoxaCount ( PIXAC *pixac );
extern BOX * pixacompGetBox ( PIXAC *pixac, l_int32 index, l_int32 accesstype );
extern l_int32 pixacompGetBoxGeometry ( PIXAC *pixac, l_int32 index, l_int32 *px, l_int32 *py, l_int32 *pw, l_int32 *ph );
extern l_int32 pixacompGetOffset ( PIXAC *pixac );
extern l_int32 pixacompSetOffset ( PIXAC *pixac, l_int32 offset );
extern PIXA * pixaCreateFromPixacomp ( PIXAC *pixac, l_int32 accesstype );
extern PIXAC * pixacompRead ( const char *filename );
extern PIXAC * pixacompReadStream ( FILE *fp );
extern l_int32 pixacompWrite ( const char *filename, PIXAC *pixac );
extern l_int32 pixacompWriteStream ( FILE *fp, PIXAC *pixac );
extern l_int32 pixacompConvertToPdf ( PIXAC *pixac, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, const char *fileout );
extern l_int32 pixacompConvertToPdfData ( PIXAC *pixac, l_int32 res, l_float32 scalefactor, l_int32 type, l_int32 quality, const char *title, l_uint8 **pdata, size_t *pnbytes );
extern l_int32 pixacompWriteStreamInfo ( FILE *fp, PIXAC *pixac, const char *text );
extern l_int32 pixcompWriteStreamInfo ( FILE *fp, PIXC *pixc, const char *text );
extern PIX * pixacompDisplayTiledAndScaled ( PIXAC *pixac, l_int32 outdepth, l_int32 tilewidth, l_int32 ncols, l_int32 background, l_int32 spacing, l_int32 border );
extern PIX * pixThreshold8 ( PIX *pixs, l_int32 d, l_int32 nlevels, l_int32 cmapflag );
extern PIX * pixRemoveColormapGeneral ( PIX *pixs, l_int32 type, l_int32 ifnocmap );
extern PIX * pixRemoveColormap ( PIX *pixs, l_int32 type );
extern l_int32 pixAddGrayColormap8 ( PIX *pixs );
extern PIX * pixAddMinimalGrayColormap8 ( PIX *pixs );
extern PIX * pixConvertRGBToLuminance ( PIX *pixs );
extern PIX * pixConvertRGBToGray ( PIX *pixs, l_float32 rwt, l_float32 gwt, l_float32 bwt );
extern PIX * pixConvertRGBToGrayFast ( PIX *pixs );
extern PIX * pixConvertRGBToGrayMinMax ( PIX *pixs, l_int32 type );
extern PIX * pixConvertRGBToGraySatBoost ( PIX *pixs, l_int32 refval );
extern PIX * pixConvertGrayToColormap ( PIX *pixs );
extern PIX * pixConvertGrayToColormap8 ( PIX *pixs, l_int32 mindepth );
extern PIX * pixColorizeGray ( PIX *pixs, l_uint32 color, l_int32 cmapflag );
extern PIX * pixConvertRGBToColormap ( PIX *pixs, l_int32 ditherflag );
extern l_int32 pixQuantizeIfFewColors ( PIX *pixs, l_int32 maxcolors, l_int32 mingraycolors, l_int32 octlevel, PIX **ppixd );
extern PIX * pixConvert16To8 ( PIX *pixs, l_int32 type );
extern PIX * pixConvertGrayToFalseColor ( PIX *pixs, l_float32 gamma );
extern PIX * pixUnpackBinary ( PIX *pixs, l_int32 depth, l_int32 invert );
extern PIX * pixConvert1To16 ( PIX *pixd, PIX *pixs, l_uint16 val0, l_uint16 val1 );
extern PIX * pixConvert1To32 ( PIX *pixd, PIX *pixs, l_uint32 val0, l_uint32 val1 );
extern PIX * pixConvert1To2Cmap ( PIX *pixs );
extern PIX * pixConvert1To2 ( PIX *pixd, PIX *pixs, l_int32 val0, l_int32 val1 );
extern PIX * pixConvert1To4Cmap ( PIX *pixs );
extern PIX * pixConvert1To4 ( PIX *pixd, PIX *pixs, l_int32 val0, l_int32 val1 );
extern PIX * pixConvert1To8 ( PIX *pixd, PIX *pixs, l_uint8 val0, l_uint8 val1 );
extern PIX * pixConvert2To8 ( PIX *pixs, l_uint8 val0, l_uint8 val1, l_uint8 val2, l_uint8 val3, l_int32 cmapflag );
extern PIX * pixConvert4To8 ( PIX *pixs, l_int32 cmapflag );
extern PIX * pixConvert8To16 ( PIX *pixs, l_int32 leftshift );
extern PIX * pixConvertTo1 ( PIX *pixs, l_int32 threshold );
extern PIX * pixConvertTo1BySampling ( PIX *pixs, l_int32 factor, l_int32 threshold );
extern PIX * pixConvertTo8 ( PIX *pixs, l_int32 cmapflag );
extern PIX * pixConvertTo8BySampling ( PIX *pixs, l_int32 factor, l_int32 cmapflag );
extern PIX * pixConvertTo8Color ( PIX *pixs, l_int32 dither );
extern PIX * pixConvertTo16 ( PIX *pixs );
extern PIX * pixConvertTo32 ( PIX *pixs );
extern PIX * pixConvertTo32BySampling ( PIX *pixs, l_int32 factor );
extern PIX * pixConvert8To32 ( PIX *pixs );
extern PIX * pixConvertTo8Or32 ( PIX *pixs, l_int32 copyflag, l_int32 warnflag );
extern PIX * pixConvert24To32 ( PIX *pixs );
extern PIX * pixConvert32To24 ( PIX *pixs );
extern PIX * pixRemoveAlpha ( PIX *pixs );
extern PIX * pixAddAlphaTo1bpp ( PIX *pixd, PIX *pixs );
extern PIX * pixConvertLossless ( PIX *pixs, l_int32 d );
extern PIX * pixConvertForPSWrap ( PIX *pixs );
extern PIX * pixConvertToSubpixelRGB ( PIX *pixs, l_float32 scalex, l_float32 scaley, l_int32 order );
extern PIX * pixConvertGrayToSubpixelRGB ( PIX *pixs, l_float32 scalex, l_float32 scaley, l_int32 order );
extern PIX * pixConvertColorToSubpixelRGB ( PIX *pixs, l_float32 scalex, l_float32 scaley, l_int32 order );
extern PIX * pixConnCompTransform ( PIX *pixs, l_int32 connect, l_int32 depth );
extern PIX * pixConnCompAreaTransform ( PIX *pixs, l_int32 connect );
extern PIX * pixLocToColorTransform ( PIX *pixs );
extern PIXTILING * pixTilingCreate ( PIX *pixs, l_int32 nx, l_int32 ny, l_int32 w, l_int32 h, l_int32 xoverlap, l_int32 yoverlap );
extern void pixTilingDestroy ( PIXTILING **ppt );
extern l_int32 pixTilingGetCount ( PIXTILING *pt, l_int32 *pnx, l_int32 *pny );
extern l_int32 pixTilingGetSize ( PIXTILING *pt, l_int32 *pw, l_int32 *ph );
extern PIX * pixTilingGetTile ( PIXTILING *pt, l_int32 i, l_int32 j );
extern l_int32 pixTilingNoStripOnPaint ( PIXTILING *pt );
extern l_int32 pixTilingPaintTile ( PIX *pixd, l_int32 i, l_int32 j, PIX *pixs, PIXTILING *pt );
extern PIX * pixReadStreamPng ( FILE *fp );
extern l_int32 readHeaderPng ( const char *filename, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 freadHeaderPng ( FILE *fp, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 readHeaderMemPng ( const l_uint8 *data, size_t size, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 fgetPngResolution ( FILE *fp, l_int32 *pxres, l_int32 *pyres );
extern l_int32 isPngInterlaced ( const char *filename, l_int32 *pinterlaced );
extern l_int32 pixWritePng ( const char *filename, PIX *pix, l_float32 gamma );
extern l_int32 pixWriteStreamPng ( FILE *fp, PIX *pix, l_float32 gamma );
extern l_int32 pixSetZlibCompression ( PIX *pix, l_int32 compval );
extern void l_pngSetReadStrip16To8 ( l_int32 flag );
extern PIX * pixReadMemPng ( const l_uint8 *cdata, size_t size );
extern l_int32 pixWriteMemPng ( l_uint8 **pdata, size_t *psize, PIX *pix, l_float32 gamma );
extern PIX * pixReadStreamPnm ( FILE *fp );
extern l_int32 readHeaderPnm ( const char *filename, l_int32 *pw, l_int32 *ph, l_int32 *pd, l_int32 *ptype, l_int32 *pbps, l_int32 *pspp );
extern l_int32 freadHeaderPnm ( FILE *fp, l_int32 *pw, l_int32 *ph, l_int32 *pd, l_int32 *ptype, l_int32 *pbps, l_int32 *pspp );
extern l_int32 pixWriteStreamPnm ( FILE *fp, PIX *pix );
extern l_int32 pixWriteStreamAsciiPnm ( FILE *fp, PIX *pix );
extern PIX * pixReadMemPnm ( const l_uint8 *cdata, size_t size );
extern l_int32 readHeaderMemPnm ( const l_uint8 *cdata, size_t size, l_int32 *pw, l_int32 *ph, l_int32 *pd, l_int32 *ptype, l_int32 *pbps, l_int32 *pspp );
extern l_int32 pixWriteMemPnm ( l_uint8 **pdata, size_t *psize, PIX *pix );
extern PIX * pixProjectiveSampledPta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixProjectiveSampled ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixProjectivePta ( PIX *pixs, PTA *ptad, PTA *ptas, l_int32 incolor );
extern PIX * pixProjective ( PIX *pixs, l_float32 *vc, l_int32 incolor );
extern PIX * pixProjectivePtaColor ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint32 colorval );
extern PIX * pixProjectiveColor ( PIX *pixs, l_float32 *vc, l_uint32 colorval );
extern PIX * pixProjectivePtaGray ( PIX *pixs, PTA *ptad, PTA *ptas, l_uint8 grayval );
extern PIX * pixProjectiveGray ( PIX *pixs, l_float32 *vc, l_uint8 grayval );
extern PIX * pixProjectivePtaWithAlpha ( PIX *pixs, PTA *ptad, PTA *ptas, PIX *pixg, l_float32 fract, l_int32 border );
extern l_int32 getProjectiveXformCoeffs ( PTA *ptas, PTA *ptad, l_float32 **pvc );
extern l_int32 projectiveXformSampledPt ( l_float32 *vc, l_int32 x, l_int32 y, l_int32 *pxp, l_int32 *pyp );
extern l_int32 projectiveXformPt ( l_float32 *vc, l_int32 x, l_int32 y, l_float32 *pxp, l_float32 *pyp );
extern l_int32 convertFilesToPS ( const char *dirin, const char *substr, l_int32 res, const char *fileout );
extern l_int32 sarrayConvertFilesToPS ( SARRAY *sa, l_int32 res, const char *fileout );
extern l_int32 convertFilesFittedToPS ( const char *dirin, const char *substr, l_float32 xpts, l_float32 ypts, const char *fileout );
extern l_int32 sarrayConvertFilesFittedToPS ( SARRAY *sa, l_float32 xpts, l_float32 ypts, const char *fileout );
extern l_int32 writeImageCompressedToPSFile ( const char *filein, const char *fileout, l_int32 res, l_int32 *pfirstfile, l_int32 *pindex );
extern l_int32 convertSegmentedPagesToPS ( const char *pagedir, const char *pagestr, l_int32 page_numpre, const char *maskdir, const char *maskstr, l_int32 mask_numpre, l_int32 numpost, l_int32 maxnum, l_float32 textscale, l_float32 imagescale, l_int32 threshold, const char *fileout );
extern l_int32 pixWriteSegmentedPageToPS ( PIX *pixs, PIX *pixm, l_float32 textscale, l_float32 imagescale, l_int32 threshold, l_int32 pageno, const char *fileout );
extern l_int32 pixWriteMixedToPS ( PIX *pixb, PIX *pixc, l_float32 scale, l_int32 pageno, const char *fileout );
extern l_int32 convertToPSEmbed ( const char *filein, const char *fileout, l_int32 level );
extern l_int32 pixaWriteCompressedToPS ( PIXA *pixa, const char *fileout, l_int32 res, l_int32 level );
extern l_int32 pixWritePSEmbed ( const char *filein, const char *fileout );
extern l_int32 pixWriteStreamPS ( FILE *fp, PIX *pix, BOX *box, l_int32 res, l_float32 scale );
extern char * pixWriteStringPS ( PIX *pixs, BOX *box, l_int32 res, l_float32 scale );
extern char * generateUncompressedPS ( char *hexdata, l_int32 w, l_int32 h, l_int32 d, l_int32 psbpl, l_int32 bps, l_float32 xpt, l_float32 ypt, l_float32 wpt, l_float32 hpt, l_int32 boxflag );
extern void getScaledParametersPS ( BOX *box, l_int32 wpix, l_int32 hpix, l_int32 res, l_float32 scale, l_float32 *pxpt, l_float32 *pypt, l_float32 *pwpt, l_float32 *phpt );
extern void convertByteToHexAscii ( l_uint8 byteval, char *pnib1, char *pnib2 );
extern l_int32 convertJpegToPSEmbed ( const char *filein, const char *fileout );
extern l_int32 convertJpegToPS ( const char *filein, const char *fileout, const char *operation, l_int32 x, l_int32 y, l_int32 res, l_float32 scale, l_int32 pageno, l_int32 endpage );
extern char * generateJpegPS ( const char *filein, L_COMP_DATA *cid, l_float32 xpt, l_float32 ypt, l_float32 wpt, l_float32 hpt, l_int32 pageno, l_int32 endpage );
extern l_int32 convertG4ToPSEmbed ( const char *filein, const char *fileout );
extern l_int32 convertG4ToPS ( const char *filein, const char *fileout, const char *operation, l_int32 x, l_int32 y, l_int32 res, l_float32 scale, l_int32 pageno, l_int32 maskflag, l_int32 endpage );
extern char * generateG4PS ( const char *filein, L_COMP_DATA *cid, l_float32 xpt, l_float32 ypt, l_float32 wpt, l_float32 hpt, l_int32 maskflag, l_int32 pageno, l_int32 endpage );
extern l_int32 convertTiffMultipageToPS ( const char *filein, const char *fileout, const char *tempfile, l_float32 fillfract );
extern l_int32 convertFlateToPSEmbed ( const char *filein, const char *fileout );
extern l_int32 convertFlateToPS ( const char *filein, const char *fileout, const char *operation, l_int32 x, l_int32 y, l_int32 res, l_float32 scale, l_int32 pageno, l_int32 endpage );
extern char * generateFlatePS ( const char *filein, L_COMP_DATA *cid, l_float32 xpt, l_float32 ypt, l_float32 wpt, l_float32 hpt, l_int32 pageno, l_int32 endpage );
extern l_int32 pixWriteMemPS ( l_uint8 **pdata, size_t *psize, PIX *pix, BOX *box, l_int32 res, l_float32 scale );
extern l_int32 getResLetterPage ( l_int32 w, l_int32 h, l_float32 fillfract );
extern l_int32 getResA4Page ( l_int32 w, l_int32 h, l_float32 fillfract );
extern char * encodeAscii85 ( l_uint8 *inarray, l_int32 insize, l_int32 *poutsize );
extern l_uint8 * decodeAscii85 ( char *ina, l_int32 insize, l_int32 *poutsize );
extern void l_psWriteBoundingBox ( l_int32 flag );
extern PTA * ptaCreate ( l_int32 n );
extern PTA * ptaCreateFromNuma ( NUMA *nax, NUMA *nay );
extern void ptaDestroy ( PTA **ppta );
extern PTA * ptaCopy ( PTA *pta );
extern PTA * ptaCopyRange ( PTA *ptas, l_int32 istart, l_int32 iend );
extern PTA * ptaClone ( PTA *pta );
extern l_int32 ptaEmpty ( PTA *pta );
extern l_int32 ptaAddPt ( PTA *pta, l_float32 x, l_float32 y );
extern l_int32 ptaInsertPt ( PTA *pta, l_int32 index, l_int32 x, l_int32 y );
extern l_int32 ptaRemovePt ( PTA *pta, l_int32 index );
extern l_int32 ptaGetRefcount ( PTA *pta );
extern l_int32 ptaChangeRefcount ( PTA *pta, l_int32 delta );
extern l_int32 ptaGetCount ( PTA *pta );
extern l_int32 ptaGetPt ( PTA *pta, l_int32 index, l_float32 *px, l_float32 *py );
extern l_int32 ptaGetIPt ( PTA *pta, l_int32 index, l_int32 *px, l_int32 *py );
extern l_int32 ptaSetPt ( PTA *pta, l_int32 index, l_float32 x, l_float32 y );
extern l_int32 ptaGetArrays ( PTA *pta, NUMA **pnax, NUMA **pnay );
extern PTA * ptaRead ( const char *filename );
extern PTA * ptaReadStream ( FILE *fp );
extern l_int32 ptaWrite ( const char *filename, PTA *pta, l_int32 type );
extern l_int32 ptaWriteStream ( FILE *fp, PTA *pta, l_int32 type );
extern PTAA * ptaaCreate ( l_int32 n );
extern void ptaaDestroy ( PTAA **pptaa );
extern l_int32 ptaaAddPta ( PTAA *ptaa, PTA *pta, l_int32 copyflag );
extern l_int32 ptaaGetCount ( PTAA *ptaa );
extern PTA * ptaaGetPta ( PTAA *ptaa, l_int32 index, l_int32 accessflag );
extern l_int32 ptaaGetPt ( PTAA *ptaa, l_int32 ipta, l_int32 jpt, l_float32 *px, l_float32 *py );
extern l_int32 ptaaInitFull ( PTAA *ptaa, PTA *pta );
extern l_int32 ptaaReplacePta ( PTAA *ptaa, l_int32 index, PTA *pta );
extern l_int32 ptaaAddPt ( PTAA *ptaa, l_int32 ipta, l_float32 x, l_float32 y );
extern l_int32 ptaaTruncate ( PTAA *ptaa );
extern PTAA * ptaaRead ( const char *filename );
extern PTAA * ptaaReadStream ( FILE *fp );
extern l_int32 ptaaWrite ( const char *filename, PTAA *ptaa, l_int32 type );
extern l_int32 ptaaWriteStream ( FILE *fp, PTAA *ptaa, l_int32 type );
extern PTA * ptaSubsample ( PTA *ptas, l_int32 subfactor );
extern l_int32 ptaJoin ( PTA *ptad, PTA *ptas, l_int32 istart, l_int32 iend );
extern l_int32 ptaaJoin ( PTAA *ptaad, PTAA *ptaas, l_int32 istart, l_int32 iend );
extern PTA * ptaReverse ( PTA *ptas, l_int32 type );
extern PTA * ptaTranspose ( PTA *ptas );
extern PTA * ptaCyclicPerm ( PTA *ptas, l_int32 xs, l_int32 ys );
extern PTA * ptaSort ( PTA *ptas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex );
extern l_int32 ptaGetSortIndex ( PTA *ptas, l_int32 sorttype, l_int32 sortorder, NUMA **pnaindex );
extern PTA * ptaSortByIndex ( PTA *ptas, NUMA *naindex );
extern PTA * ptaRemoveDuplicates ( PTA *ptas, l_uint32 factor );
extern PTAA * ptaaSortByIndex ( PTAA *ptaas, NUMA *naindex );
extern BOX * ptaGetBoundingRegion ( PTA *pta );
extern l_int32 ptaGetRange ( PTA *pta, l_float32 *pminx, l_float32 *pmaxx, l_float32 *pminy, l_float32 *pmaxy );
extern PTA * ptaGetInsideBox ( PTA *ptas, BOX *box );
extern PTA * pixFindCornerPixels ( PIX *pixs );
extern l_int32 ptaContainsPt ( PTA *pta, l_int32 x, l_int32 y );
extern l_int32 ptaTestIntersection ( PTA *pta1, PTA *pta2 );
extern PTA * ptaTransform ( PTA *ptas, l_int32 shiftx, l_int32 shifty, l_float32 scalex, l_float32 scaley );
extern l_int32 ptaPtInsidePolygon ( PTA *pta, l_float32 x, l_float32 y, l_int32 *pinside );
extern l_float32 l_angleBetweenVectors ( l_float32 x1, l_float32 y1, l_float32 x2, l_float32 y2 );
extern l_int32 ptaGetLinearLSF ( PTA *pta, l_float32 *pa, l_float32 *pb, NUMA **pnafit );
extern l_int32 ptaGetQuadraticLSF ( PTA *pta, l_float32 *pa, l_float32 *pb, l_float32 *pc, NUMA **pnafit );
extern l_int32 ptaGetCubicLSF ( PTA *pta, l_float32 *pa, l_float32 *pb, l_float32 *pc, l_float32 *pd, NUMA **pnafit );
extern l_int32 ptaGetQuarticLSF ( PTA *pta, l_float32 *pa, l_float32 *pb, l_float32 *pc, l_float32 *pd, l_float32 *pe, NUMA **pnafit );
extern l_int32 ptaNoisyLinearLSF ( PTA *pta, l_float32 factor, PTA **pptad, l_float32 *pa, l_float32 *pb, l_float32 *pmederr, NUMA **pnafit );
extern l_int32 ptaNoisyQuadraticLSF ( PTA *pta, l_float32 factor, PTA **pptad, l_float32 *pa, l_float32 *pb, l_float32 *pc, l_float32 *pmederr, NUMA **pnafit );
extern l_int32 applyLinearFit ( l_float32 a, l_float32 b, l_float32 x, l_float32 *py );
extern l_int32 applyQuadraticFit ( l_float32 a, l_float32 b, l_float32 c, l_float32 x, l_float32 *py );
extern l_int32 applyCubicFit ( l_float32 a, l_float32 b, l_float32 c, l_float32 d, l_float32 x, l_float32 *py );
extern l_int32 applyQuarticFit ( l_float32 a, l_float32 b, l_float32 c, l_float32 d, l_float32 e, l_float32 x, l_float32 *py );
extern l_int32 pixPlotAlongPta ( PIX *pixs, PTA *pta, l_int32 outformat, const char *title );
extern PTA * ptaGetPixelsFromPix ( PIX *pixs, BOX *box );
extern PIX * pixGenerateFromPta ( PTA *pta, l_int32 w, l_int32 h );
extern PTA * ptaGetBoundaryPixels ( PIX *pixs, l_int32 type );
extern PTAA * ptaaGetBoundaryPixels ( PIX *pixs, l_int32 type, l_int32 connectivity, BOXA **pboxa, PIXA **ppixa );
extern PIX * pixDisplayPta ( PIX *pixd, PIX *pixs, PTA *pta );
extern PIX * pixDisplayPtaaPattern ( PIX *pixd, PIX *pixs, PTAA *ptaa, PIX *pixp, l_int32 cx, l_int32 cy );
extern PIX * pixDisplayPtaPattern ( PIX *pixd, PIX *pixs, PTA *pta, PIX *pixp, l_int32 cx, l_int32 cy, l_uint32 color );
extern PTA * ptaReplicatePattern ( PTA *ptas, PIX *pixp, PTA *ptap, l_int32 cx, l_int32 cy, l_int32 w, l_int32 h );
extern PIX * pixDisplayPtaa ( PIX *pixs, PTAA *ptaa );
extern L_PTRA * ptraCreate ( l_int32 n );
extern void ptraDestroy ( L_PTRA **ppa, l_int32 freeflag, l_int32 warnflag );
extern l_int32 ptraAdd ( L_PTRA *pa, void *item );
extern l_int32 ptraInsert ( L_PTRA *pa, l_int32 index, void *item, l_int32 shiftflag );
extern void * ptraRemove ( L_PTRA *pa, l_int32 index, l_int32 flag );
extern void * ptraRemoveLast ( L_PTRA *pa );
extern void * ptraReplace ( L_PTRA *pa, l_int32 index, void *item, l_int32 freeflag );
extern l_int32 ptraSwap ( L_PTRA *pa, l_int32 index1, l_int32 index2 );
extern l_int32 ptraCompactArray ( L_PTRA *pa );
extern l_int32 ptraReverse ( L_PTRA *pa );
extern l_int32 ptraJoin ( L_PTRA *pa1, L_PTRA *pa2 );
extern l_int32 ptraGetMaxIndex ( L_PTRA *pa, l_int32 *pmaxindex );
extern l_int32 ptraGetActualCount ( L_PTRA *pa, l_int32 *pcount );
extern void * ptraGetPtrToItem ( L_PTRA *pa, l_int32 index );
extern L_PTRAA * ptraaCreate ( l_int32 n );
extern void ptraaDestroy ( L_PTRAA **ppaa, l_int32 freeflag, l_int32 warnflag );
extern l_int32 ptraaGetSize ( L_PTRAA *paa, l_int32 *psize );
extern l_int32 ptraaInsertPtra ( L_PTRAA *paa, l_int32 index, L_PTRA *pa );
extern L_PTRA * ptraaGetPtra ( L_PTRAA *paa, l_int32 index, l_int32 accessflag );
extern L_PTRA * ptraaFlattenToPtra ( L_PTRAA *paa );
extern l_int32 pixQuadtreeMean ( PIX *pixs, l_int32 nlevels, PIX *pix_ma, FPIXA **pfpixa );
extern l_int32 pixQuadtreeVariance ( PIX *pixs, l_int32 nlevels, PIX *pix_ma, DPIX *dpix_msa, FPIXA **pfpixa_v, FPIXA **pfpixa_rv );
extern l_int32 pixMeanInRectangle ( PIX *pixs, BOX *box, PIX *pixma, l_float32 *pval );
extern l_int32 pixVarianceInRectangle ( PIX *pixs, BOX *box, PIX *pix_ma, DPIX *dpix_msa, l_float32 *pvar, l_float32 *prvar );
extern BOXAA * boxaaQuadtreeRegions ( l_int32 w, l_int32 h, l_int32 nlevels );
extern l_int32 quadtreeGetParent ( FPIXA *fpixa, l_int32 level, l_int32 x, l_int32 y, l_float32 *pval );
extern l_int32 quadtreeGetChildren ( FPIXA *fpixa, l_int32 level, l_int32 x, l_int32 y, l_float32 *pval00, l_float32 *pval10, l_float32 *pval01, l_float32 *pval11 );
extern l_int32 quadtreeMaxLevels ( l_int32 w, l_int32 h );
extern PIX * fpixaDisplayQuadtree ( FPIXA *fpixa, l_int32 factor, const char *fontdir );
extern L_QUEUE * lqueueCreate ( l_int32 nalloc );
extern void lqueueDestroy ( L_QUEUE **plq, l_int32 freeflag );
extern l_int32 lqueueAdd ( L_QUEUE *lq, void *item );
extern void * lqueueRemove ( L_QUEUE *lq );
extern l_int32 lqueueGetCount ( L_QUEUE *lq );
extern l_int32 lqueuePrint ( FILE *fp, L_QUEUE *lq );
extern PIX * pixRankFilter ( PIX *pixs, l_int32 wf, l_int32 hf, l_float32 rank );
extern PIX * pixRankFilterRGB ( PIX *pixs, l_int32 wf, l_int32 hf, l_float32 rank );
extern PIX * pixRankFilterGray ( PIX *pixs, l_int32 wf, l_int32 hf, l_float32 rank );
extern PIX * pixMedianFilter ( PIX *pixs, l_int32 wf, l_int32 hf );
extern PIX * pixRankFilterWithScaling ( PIX *pixs, l_int32 wf, l_int32 hf, l_float32 rank, l_float32 scalefactor );
extern SARRAY * pixProcessBarcodes ( PIX *pixs, l_int32 format, l_int32 method, SARRAY **psaw, l_int32 debugflag );
extern PIXA * pixExtractBarcodes ( PIX *pixs, l_int32 debugflag );
extern SARRAY * pixReadBarcodes ( PIXA *pixa, l_int32 format, l_int32 method, SARRAY **psaw, l_int32 debugflag );
extern NUMA * pixReadBarcodeWidths ( PIX *pixs, l_int32 method, l_int32 debugflag );
extern BOXA * pixLocateBarcodes ( PIX *pixs, l_int32 thresh, PIX **ppixb, PIX **ppixm );
extern PIX * pixDeskewBarcode ( PIX *pixs, PIX *pixb, BOX *box, l_int32 margin, l_int32 threshold, l_float32 *pangle, l_float32 *pconf );
extern NUMA * pixExtractBarcodeWidths1 ( PIX *pixs, l_float32 thresh, l_float32 binfract, NUMA **pnaehist, NUMA **pnaohist, l_int32 debugflag );
extern NUMA * pixExtractBarcodeWidths2 ( PIX *pixs, l_float32 thresh, l_float32 *pwidth, NUMA **pnac, l_int32 debugflag );
extern NUMA * pixExtractBarcodeCrossings ( PIX *pixs, l_float32 thresh, l_int32 debugflag );
extern NUMA * numaQuantizeCrossingsByWidth ( NUMA *nas, l_float32 binfract, NUMA **pnaehist, NUMA **pnaohist, l_int32 debugflag );
extern NUMA * numaQuantizeCrossingsByWindow ( NUMA *nas, l_float32 ratio, l_float32 *pwidth, l_float32 *pfirstloc, NUMA **pnac, l_int32 debugflag );
extern PIXA * pixaReadFiles ( const char *dirname, const char *substr );
extern PIXA * pixaReadFilesSA ( SARRAY *sa );
extern PIX * pixRead ( const char *filename );
extern PIX * pixReadWithHint ( const char *filename, l_int32 hint );
extern PIX * pixReadIndexed ( SARRAY *sa, l_int32 index );
extern PIX * pixReadStream ( FILE *fp, l_int32 hint );
extern l_int32 pixReadHeader ( const char *filename, l_int32 *pformat, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 findFileFormat ( const char *filename, l_int32 *pformat );
extern l_int32 findFileFormatStream ( FILE *fp, l_int32 *pformat );
extern l_int32 findFileFormatBuffer ( const l_uint8 *buf, l_int32 *pformat );
extern l_int32 fileFormatIsTiff ( FILE *fp );
extern PIX * pixReadMem ( const l_uint8 *data, size_t size );
extern l_int32 pixReadHeaderMem ( const l_uint8 *data, size_t size, l_int32 *pformat, l_int32 *pw, l_int32 *ph, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 ioFormatTest ( const char *filename );
extern L_RECOGA * recogaCreateFromRecog ( L_RECOG *recog );
extern L_RECOGA * recogaCreateFromPixaa ( PIXAA *paa, l_int32 scalew, l_int32 scaleh, l_int32 templ_type, l_int32 threshold, l_int32 maxyshift, const char *fontdir );
extern L_RECOGA * recogaCreate ( l_int32 n );
extern void recogaDestroy ( L_RECOGA **precoga );
extern l_int32 recogaAddRecog ( L_RECOGA *recoga, L_RECOG *recog );
extern l_int32 recogReplaceInRecoga ( L_RECOG **precog1, L_RECOG *recog2 );
extern L_RECOG * recogaGetRecog ( L_RECOGA *recoga, l_int32 index );
extern l_int32 recogaGetCount ( L_RECOGA *recoga );
extern l_int32 recogGetCount ( L_RECOG *recog );
extern l_int32 recogGetIndex ( L_RECOG *recog, l_int32 *pindex );
extern L_RECOGA * recogGetParent ( L_RECOG *recog );
extern l_int32 recogSetBootflag ( L_RECOG *recog );
extern L_RECOG * recogCreateFromRecog ( L_RECOG *recs, l_int32 scalew, l_int32 scaleh, l_int32 templ_type, l_int32 threshold, l_int32 maxyshift, const char *fontdir );
extern L_RECOG * recogCreateFromPixa ( PIXA *pixa, l_int32 scalew, l_int32 scaleh, l_int32 templ_type, l_int32 threshold, l_int32 maxyshift, const char *fontdir );
extern L_RECOG * recogCreate ( l_int32 scalew, l_int32 scaleh, l_int32 templ_type, l_int32 threshold, l_int32 maxyshift, const char *fontdir );
extern void recogDestroy ( L_RECOG **precog );
extern l_int32 recogAppend ( L_RECOG *recog1, L_RECOG *recog2 );
extern l_int32 recogGetClassIndex ( L_RECOG *recog, l_int32 val, char *text, l_int32 *pindex );
extern l_int32 recogStringToIndex ( L_RECOG *recog, char *text, l_int32 *pindex );
extern l_int32 l_convertCharstrToInt ( const char *str, l_int32 *pval );
extern L_RECOGA * recogaRead ( const char *filename );
extern L_RECOGA * recogaReadStream ( FILE *fp );
extern l_int32 recogaWrite ( const char *filename, L_RECOGA *recoga );
extern l_int32 recogaWriteStream ( FILE *fp, L_RECOGA *recoga, const char *filename );
extern l_int32 recogaWritePixaa ( const char *filename, L_RECOGA *recoga );
extern L_RECOG * recogRead ( const char *filename );
extern L_RECOG * recogReadStream ( FILE *fp );
extern l_int32 recogWrite ( const char *filename, L_RECOG *recog );
extern l_int32 recogWriteStream ( FILE *fp, L_RECOG *recog, const char *filename );
extern l_int32 recogWritePixa ( const char *filename, L_RECOG *recog );
extern l_int32 recogDecode ( L_RECOG *recog, PIX *pixs, l_int32 nlevels, PIX **ppixdb );
extern l_int32 recogMakeDecodingArrays ( L_RECOG *recog, PIX *pixs, l_int32 debug );
extern l_int32 recogRunViterbi ( L_RECOG *recog, PIX **ppixdb );
extern l_int32 recogCreateDid ( L_RECOG *recog, PIX *pixs );
extern l_int32 recogDestroyDid ( L_RECOG *recog );
extern l_int32 recogDidExists ( L_RECOG *recog );
extern L_RDID * recogGetDid ( L_RECOG *recog );
extern l_int32 recogSetChannelParams ( L_RECOG *recog, l_int32 nlevels );
extern l_int32 recogaIdentifyMultiple ( L_RECOGA *recoga, PIX *pixs, l_int32 nitems, l_int32 minw, l_int32 minh, BOXA **pboxa, PIXA **ppixa, PIX **ppixdb, l_int32 debugsplit );
extern l_int32 recogSplitIntoCharacters ( L_RECOG *recog, PIX *pixs, l_int32 minw, l_int32 minh, BOXA **pboxa, PIXA **ppixa, NUMA **pnaid, l_int32 debug );
extern l_int32 recogCorrelationBestRow ( L_RECOG *recog, PIX *pixs, BOXA **pboxa, NUMA **pnascore, NUMA **pnaindex, SARRAY **psachar, l_int32 debug );
extern l_int32 recogaIdentifyPixa ( L_RECOGA *recoga, PIXA *pixa, NUMA *naid, PIX **ppixdb );
extern l_int32 recogIdentifyPixa ( L_RECOG *recog, PIXA *pixa, NUMA *naid, PIX **ppixdb );
extern l_int32 recogIdentifyPix ( L_RECOG *recog, PIX *pixs, PIX **ppixdb );
extern l_int32 recogSkipIdentify ( L_RECOG *recog );
extern void rchaDestroy ( L_RCHA **prcha );
extern void rchDestroy ( L_RCH **prch );
extern l_int32 rchaExtract ( L_RCHA *rcha, NUMA **pnaindex, NUMA **pnascore, SARRAY **psatext, NUMA **pnasample, NUMA **pnaxloc, NUMA **pnayloc, NUMA **pnawidth );
extern PIX * recogProcessToIdentify ( L_RECOG *recog, PIX *pixs, l_int32 pad );
extern PIX * recogPreSplittingFilter ( L_RECOG *recog, PIX *pixs, l_float32 maxasp, l_float32 minaf, l_float32 maxaf, l_int32 debug );
extern l_int32 recogSplittingFilter ( L_RECOG *recog, PIX *pixs, l_float32 maxasp, l_float32 minaf, l_float32 maxaf, l_int32 *premove, l_int32 debug );
extern SARRAY * recogaExtractNumbers ( L_RECOGA *recoga, BOXA *boxas, l_float32 scorethresh, l_int32 spacethresh, BOXAA **pbaa, NUMAA **pnaa );
extern l_int32 recogSetTemplateType ( L_RECOG *recog, l_int32 templ_type );
extern l_int32 recogSetScaling ( L_RECOG *recog, l_int32 scalew, l_int32 scaleh );
extern l_int32 recogTrainLabelled ( L_RECOG *recog, PIX *pixs, BOX *box, char *text, l_int32 multflag, l_int32 debug );
extern l_int32 recogProcessMultLabelled ( L_RECOG *recog, PIX *pixs, BOX *box, char *text, PIXA **ppixa, l_int32 debug );
extern l_int32 recogProcessSingleLabelled ( L_RECOG *recog, PIX *pixs, BOX *box, char *text, PIXA **ppixa );
extern l_int32 recogAddSamples ( L_RECOG *recog, PIXA *pixa, l_int32 classindex, l_int32 debug );
extern PIX * recogScaleCharacter ( L_RECOG *recog, PIX *pixs );
extern l_int32 recogAverageSamples ( L_RECOG *recog, l_int32 debug );
extern l_int32 pixaAccumulateSamples ( PIXA *pixa, PTA *pta, PIX **ppixd, l_float32 *px, l_float32 *py );
extern l_int32 recogTrainingFinished ( L_RECOG *recog, l_int32 debug );
extern l_int32 recogRemoveOutliers ( L_RECOG *recog, l_float32 targetscore, l_float32 minfract, l_int32 debug );
extern l_int32 recogaTrainingDone ( L_RECOGA *recoga, l_int32 *pdone );
extern l_int32 recogaFinishAveraging ( L_RECOGA *recoga );
extern l_int32 recogTrainUnlabelled ( L_RECOG *recog, L_RECOG *recogboot, PIX *pixs, BOX *box, l_int32 singlechar, l_float32 minscore, l_int32 debug );
extern l_int32 recogPadTrainingSet ( L_RECOG **precog, l_int32 debug );
extern l_int32 recogBestCorrelForPadding ( L_RECOG *recog, L_RECOGA *recoga, NUMA **pnaset, NUMA **pnaindex, NUMA **pnascore, NUMA **pnasum, PIXA **ppixadb );
extern l_int32 recogCorrelAverages ( L_RECOG *recog1, L_RECOG *recog2, NUMA **pnaindex, NUMA **pnascore, PIXA **ppixadb );
extern l_int32 recogSetPadParams ( L_RECOG *recog, const char *bootdir, const char *bootpattern, const char *bootpath, l_int32 type, l_int32 min_nopad, l_int32 max_afterpad );
extern l_int32 recogaShowContent ( FILE *fp, L_RECOGA *recoga, l_int32 display );
extern l_int32 recogShowContent ( FILE *fp, L_RECOG *recog, l_int32 display );
extern l_int32 recogDebugAverages ( L_RECOG *recog, l_int32 debug );
extern l_int32 recogShowAverageTemplates ( L_RECOG *recog );
extern l_int32 recogShowMatchesInRange ( L_RECOG *recog, PIXA *pixa, l_float32 minscore, l_float32 maxscore, l_int32 display );
extern PIX * recogShowMatch ( L_RECOG *recog, PIX *pix1, PIX *pix2, BOX *box, l_int32 index, l_float32 score );
extern l_int32 recogMakeBmf ( L_RECOG *recog, const char *fontdir, l_int32 size );
extern l_int32 regTestCleanup ( L_REGPARAMS *rp );
extern l_int32 regTestCompareValues ( L_REGPARAMS *rp, l_float32 val1, l_float32 val2, l_float32 delta );
extern l_int32 regTestCompareStrings ( L_REGPARAMS *rp, l_uint8 *string1, size_t bytes1, l_uint8 *string2, size_t bytes2 );
extern l_int32 regTestComparePix ( L_REGPARAMS *rp, PIX *pix1, PIX *pix2 );
extern l_int32 regTestCompareSimilarPix ( L_REGPARAMS *rp, PIX *pix1, PIX *pix2, l_int32 mindiff, l_float32 maxfract, l_int32 printstats );
extern l_int32 regTestCheckFile ( L_REGPARAMS *rp, const char *localname );
extern l_int32 regTestCompareFiles ( L_REGPARAMS *rp, l_int32 index1, l_int32 index2 );
extern l_int32 regTestWritePixAndCheck ( L_REGPARAMS *rp, PIX *pix, l_int32 format );
extern l_int32 pixRasterop ( PIX *pixd, l_int32 dx, l_int32 dy, l_int32 dw, l_int32 dh, l_int32 op, PIX *pixs, l_int32 sx, l_int32 sy );
extern l_int32 pixRasteropVip ( PIX *pixd, l_int32 bx, l_int32 bw, l_int32 vshift, l_int32 incolor );
extern l_int32 pixRasteropHip ( PIX *pixd, l_int32 by, l_int32 bh, l_int32 hshift, l_int32 incolor );
extern PIX * pixTranslate ( PIX *pixd, PIX *pixs, l_int32 hshift, l_int32 vshift, l_int32 incolor );
extern l_int32 pixRasteropIP ( PIX *pixd, l_int32 hshift, l_int32 vshift, l_int32 incolor );
extern l_int32 pixRasteropFullImage ( PIX *pixd, PIX *pixs, l_int32 op );
extern void rasteropVipLow ( l_uint32 *data, l_int32 pixw, l_int32 pixh, l_int32 depth, l_int32 wpl, l_int32 x, l_int32 w, l_int32 shift );
extern void rasteropHipLow ( l_uint32 *data, l_int32 pixh, l_int32 depth, l_int32 wpl, l_int32 y, l_int32 h, l_int32 shift );
extern void shiftDataHorizontalLow ( l_uint32 *datad, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 shift );
extern void rasteropUniLow ( l_uint32 *datad, l_int32 dpixw, l_int32 dpixh, l_int32 depth, l_int32 dwpl, l_int32 dx, l_int32 dy, l_int32 dw, l_int32 dh, l_int32 op );
extern void rasteropLow ( l_uint32 *datad, l_int32 dpixw, l_int32 dpixh, l_int32 depth, l_int32 dwpl, l_int32 dx, l_int32 dy, l_int32 dw, l_int32 dh, l_int32 op, l_uint32 *datas, l_int32 spixw, l_int32 spixh, l_int32 swpl, l_int32 sx, l_int32 sy );
extern PIX * pixRotate ( PIX *pixs, l_float32 angle, l_int32 type, l_int32 incolor, l_int32 width, l_int32 height );
extern PIX * pixEmbedForRotation ( PIX *pixs, l_float32 angle, l_int32 incolor, l_int32 width, l_int32 height );
extern PIX * pixRotateBySampling ( PIX *pixs, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 incolor );
extern PIX * pixRotateBinaryNice ( PIX *pixs, l_float32 angle, l_int32 incolor );
extern PIX * pixRotateWithAlpha ( PIX *pixs, l_float32 angle, PIX *pixg, l_float32 fract );
extern PIX * pixRotateAM ( PIX *pixs, l_float32 angle, l_int32 incolor );
extern PIX * pixRotateAMColor ( PIX *pixs, l_float32 angle, l_uint32 colorval );
extern PIX * pixRotateAMGray ( PIX *pixs, l_float32 angle, l_uint8 grayval );
extern PIX * pixRotateAMCorner ( PIX *pixs, l_float32 angle, l_int32 incolor );
extern PIX * pixRotateAMColorCorner ( PIX *pixs, l_float32 angle, l_uint32 fillval );
extern PIX * pixRotateAMGrayCorner ( PIX *pixs, l_float32 angle, l_uint8 grayval );
extern PIX * pixRotateAMColorFast ( PIX *pixs, l_float32 angle, l_uint32 colorval );
extern void rotateAMColorLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 angle, l_uint32 colorval );
extern void rotateAMGrayLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 angle, l_uint8 grayval );
extern void rotateAMColorCornerLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 angle, l_uint32 colorval );
extern void rotateAMGrayCornerLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 angle, l_uint8 grayval );
extern void rotateAMColorFastLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 angle, l_uint32 colorval );
extern PIX * pixRotateOrth ( PIX *pixs, l_int32 quads );
extern PIX * pixRotate180 ( PIX *pixd, PIX *pixs );
extern PIX * pixRotate90 ( PIX *pixs, l_int32 direction );
extern PIX * pixFlipLR ( PIX *pixd, PIX *pixs );
extern PIX * pixFlipTB ( PIX *pixd, PIX *pixs );
extern PIX * pixRotateShear ( PIX *pixs, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 incolor );
extern PIX * pixRotate2Shear ( PIX *pixs, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 incolor );
extern PIX * pixRotate3Shear ( PIX *pixs, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 incolor );
extern l_int32 pixRotateShearIP ( PIX *pixs, l_int32 xcen, l_int32 ycen, l_float32 angle, l_int32 incolor );
extern PIX * pixRotateShearCenter ( PIX *pixs, l_float32 angle, l_int32 incolor );
extern l_int32 pixRotateShearCenterIP ( PIX *pixs, l_float32 angle, l_int32 incolor );
extern PIX * pixStrokeWidthTransform ( PIX *pixs, l_int32 color, l_int32 depth, l_int32 nangles );
extern PIX * pixRunlengthTransform ( PIX *pixs, l_int32 color, l_int32 direction, l_int32 depth );
extern l_int32 pixFindHorizontalRuns ( PIX *pix, l_int32 y, l_int32 *xstart, l_int32 *xend, l_int32 *pn );
extern l_int32 pixFindVerticalRuns ( PIX *pix, l_int32 x, l_int32 *ystart, l_int32 *yend, l_int32 *pn );
extern NUMA * pixFindMaxRuns ( PIX *pix, l_int32 direction, NUMA **pnastart );
extern l_int32 pixFindMaxHorizontalRunOnLine ( PIX *pix, l_int32 y, l_int32 *pxstart, l_int32 *psize );
extern l_int32 pixFindMaxVerticalRunOnLine ( PIX *pix, l_int32 x, l_int32 *pystart, l_int32 *psize );
extern l_int32 runlengthMembershipOnLine ( l_int32 *buffer, l_int32 size, l_int32 depth, l_int32 *start, l_int32 *end, l_int32 n );
extern l_int32 * makeMSBitLocTab ( l_int32 bitval );
extern SARRAY * sarrayCreate ( l_int32 n );
extern SARRAY * sarrayCreateInitialized ( l_int32 n, char *initstr );
extern SARRAY * sarrayCreateWordsFromString ( const char *string );
extern SARRAY * sarrayCreateLinesFromString ( char *string, l_int32 blankflag );
extern void sarrayDestroy ( SARRAY **psa );
extern SARRAY * sarrayCopy ( SARRAY *sa );
extern SARRAY * sarrayClone ( SARRAY *sa );
extern l_int32 sarrayAddString ( SARRAY *sa, char *string, l_int32 copyflag );
extern char * sarrayRemoveString ( SARRAY *sa, l_int32 index );
extern l_int32 sarrayReplaceString ( SARRAY *sa, l_int32 index, char *newstr, l_int32 copyflag );
extern l_int32 sarrayClear ( SARRAY *sa );
extern l_int32 sarrayGetCount ( SARRAY *sa );
extern char * sarrayGetString ( SARRAY *sa, l_int32 index, l_int32 copyflag );
extern l_int32 sarrayGetRefcount ( SARRAY *sa );
extern l_int32 sarrayChangeRefcount ( SARRAY *sa, l_int32 delta );
extern char * sarrayToString ( SARRAY *sa, l_int32 addnlflag );
extern char * sarrayToStringRange ( SARRAY *sa, l_int32 first, l_int32 nstrings, l_int32 addnlflag );
extern l_int32 sarrayConcatenate ( SARRAY *sa1, SARRAY *sa2 );
extern l_int32 sarrayAppendRange ( SARRAY *sa1, SARRAY *sa2, l_int32 start, l_int32 end );
extern l_int32 sarrayPadToSameSize ( SARRAY *sa1, SARRAY *sa2, char *padstring );
extern SARRAY * sarrayConvertWordsToLines ( SARRAY *sa, l_int32 linesize );
extern l_int32 sarraySplitString ( SARRAY *sa, const char *str, const char *separators );
extern SARRAY * sarraySelectBySubstring ( SARRAY *sain, const char *substr );
extern SARRAY * sarraySelectByRange ( SARRAY *sain, l_int32 first, l_int32 last );
extern l_int32 sarrayParseRange ( SARRAY *sa, l_int32 start, l_int32 *pactualstart, l_int32 *pend, l_int32 *pnewstart, const char *substr, l_int32 loc );
extern SARRAY * sarraySort ( SARRAY *saout, SARRAY *sain, l_int32 sortorder );
extern SARRAY * sarraySortByIndex ( SARRAY *sain, NUMA *naindex );
extern l_int32 stringCompareLexical ( const char *str1, const char *str2 );
extern SARRAY * sarrayRead ( const char *filename );
extern SARRAY * sarrayReadStream ( FILE *fp );
extern l_int32 sarrayWrite ( const char *filename, SARRAY *sa );
extern l_int32 sarrayWriteStream ( FILE *fp, SARRAY *sa );
extern l_int32 sarrayAppend ( const char *filename, SARRAY *sa );
extern SARRAY * getNumberedPathnamesInDirectory ( const char *dirname, const char *substr, l_int32 numpre, l_int32 numpost, l_int32 maxnum );
extern SARRAY * getSortedPathnamesInDirectory ( const char *dirname, const char *substr, l_int32 first, l_int32 nfiles );
extern SARRAY * convertSortedToNumberedPathnames ( SARRAY *sa, l_int32 numpre, l_int32 numpost, l_int32 maxnum );
extern SARRAY * getFilenamesInDirectory ( const char *dirname );
extern PIX * pixScale ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleToSize ( PIX *pixs, l_int32 wd, l_int32 hd );
extern PIX * pixScaleGeneral ( PIX *pixs, l_float32 scalex, l_float32 scaley, l_float32 sharpfract, l_int32 sharpwidth );
extern PIX * pixScaleLI ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleColorLI ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleColor2xLI ( PIX *pixs );
extern PIX * pixScaleColor4xLI ( PIX *pixs );
extern PIX * pixScaleGrayLI ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleGray2xLI ( PIX *pixs );
extern PIX * pixScaleGray4xLI ( PIX *pixs );
extern PIX * pixScaleBySampling ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleBySamplingToSize ( PIX *pixs, l_int32 wd, l_int32 hd );
extern PIX * pixScaleByIntSampling ( PIX *pixs, l_int32 factor );
extern PIX * pixScaleRGBToGrayFast ( PIX *pixs, l_int32 factor, l_int32 color );
extern PIX * pixScaleRGBToBinaryFast ( PIX *pixs, l_int32 factor, l_int32 thresh );
extern PIX * pixScaleGrayToBinaryFast ( PIX *pixs, l_int32 factor, l_int32 thresh );
extern PIX * pixScaleSmooth ( PIX *pix, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleRGBToGray2 ( PIX *pixs, l_float32 rwt, l_float32 gwt, l_float32 bwt );
extern PIX * pixScaleAreaMap ( PIX *pix, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleAreaMap2 ( PIX *pix );
extern PIX * pixScaleBinary ( PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleToGray ( PIX *pixs, l_float32 scalefactor );
extern PIX * pixScaleToGrayFast ( PIX *pixs, l_float32 scalefactor );
extern PIX * pixScaleToGray2 ( PIX *pixs );
extern PIX * pixScaleToGray3 ( PIX *pixs );
extern PIX * pixScaleToGray4 ( PIX *pixs );
extern PIX * pixScaleToGray6 ( PIX *pixs );
extern PIX * pixScaleToGray8 ( PIX *pixs );
extern PIX * pixScaleToGray16 ( PIX *pixs );
extern PIX * pixScaleToGrayMipmap ( PIX *pixs, l_float32 scalefactor );
extern PIX * pixScaleMipmap ( PIX *pixs1, PIX *pixs2, l_float32 scale );
extern PIX * pixExpandReplicate ( PIX *pixs, l_int32 factor );
extern PIX * pixScaleGray2xLIThresh ( PIX *pixs, l_int32 thresh );
extern PIX * pixScaleGray2xLIDither ( PIX *pixs );
extern PIX * pixScaleGray4xLIThresh ( PIX *pixs, l_int32 thresh );
extern PIX * pixScaleGray4xLIDither ( PIX *pixs );
extern PIX * pixScaleGrayMinMax ( PIX *pixs, l_int32 xfact, l_int32 yfact, l_int32 type );
extern PIX * pixScaleGrayMinMax2 ( PIX *pixs, l_int32 type );
extern PIX * pixScaleGrayRankCascade ( PIX *pixs, l_int32 level1, l_int32 level2, l_int32 level3, l_int32 level4 );
extern PIX * pixScaleGrayRank2 ( PIX *pixs, l_int32 rank );
extern l_int32 pixScaleAndTransferAlpha ( PIX *pixd, PIX *pixs, l_float32 scalex, l_float32 scaley );
extern PIX * pixScaleWithAlpha ( PIX *pixs, l_float32 scalex, l_float32 scaley, PIX *pixg, l_float32 fract );
extern void scaleColorLILow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleGrayLILow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleColor2xLILow ( l_uint32 *datad, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleColor2xLILineLow ( l_uint32 *lined, l_int32 wpld, l_uint32 *lines, l_int32 ws, l_int32 wpls, l_int32 lastlineflag );
extern void scaleGray2xLILow ( l_uint32 *datad, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleGray2xLILineLow ( l_uint32 *lined, l_int32 wpld, l_uint32 *lines, l_int32 ws, l_int32 wpls, l_int32 lastlineflag );
extern void scaleGray4xLILow ( l_uint32 *datad, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleGray4xLILineLow ( l_uint32 *lined, l_int32 wpld, l_uint32 *lines, l_int32 ws, l_int32 wpls, l_int32 lastlineflag );
extern l_int32 scaleBySamplingLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 d, l_int32 wpls );
extern l_int32 scaleSmoothLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 d, l_int32 wpls, l_int32 size );
extern void scaleRGBToGray2Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_float32 rwt, l_float32 gwt, l_float32 bwt );
extern void scaleColorAreaMapLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleGrayAreaMapLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleAreaMapLow2 ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 d, l_int32 wpls );
extern l_int32 scaleBinaryLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 ws, l_int32 hs, l_int32 wpls );
extern void scaleToGray2Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *sumtab, l_uint8 *valtab );
extern l_uint32 * makeSumTabSG2 ( void );
extern l_uint8 * makeValTabSG2 ( void );
extern void scaleToGray3Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *sumtab, l_uint8 *valtab );
extern l_uint32 * makeSumTabSG3 ( void );
extern l_uint8 * makeValTabSG3 ( void );
extern void scaleToGray4Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_uint32 *sumtab, l_uint8 *valtab );
extern l_uint32 * makeSumTabSG4 ( void );
extern l_uint8 * makeValTabSG4 ( void );
extern void scaleToGray6Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 *tab8, l_uint8 *valtab );
extern l_uint8 * makeValTabSG6 ( void );
extern void scaleToGray8Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 *tab8, l_uint8 *valtab );
extern l_uint8 * makeValTabSG8 ( void );
extern void scaleToGray16Low ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas, l_int32 wpls, l_int32 *tab8 );
extern l_int32 scaleMipmapLow ( l_uint32 *datad, l_int32 wd, l_int32 hd, l_int32 wpld, l_uint32 *datas1, l_int32 wpls1, l_uint32 *datas2, l_int32 wpls2, l_float32 red );
extern PIX * pixSeedfillBinary ( PIX *pixd, PIX *pixs, PIX *pixm, l_int32 connectivity );
extern PIX * pixSeedfillBinaryRestricted ( PIX *pixd, PIX *pixs, PIX *pixm, l_int32 connectivity, l_int32 xmax, l_int32 ymax );
extern PIX * pixHolesByFilling ( PIX *pixs, l_int32 connectivity );
extern PIX * pixFillClosedBorders ( PIX *pixs, l_int32 connectivity );
extern PIX * pixExtractBorderConnComps ( PIX *pixs, l_int32 connectivity );
extern PIX * pixRemoveBorderConnComps ( PIX *pixs, l_int32 connectivity );
extern PIX * pixFillBgFromBorder ( PIX *pixs, l_int32 connectivity );
extern PIX * pixFillHolesToBoundingRect ( PIX *pixs, l_int32 minsize, l_float32 maxhfract, l_float32 minfgfract );
extern l_int32 pixSeedfillGray ( PIX *pixs, PIX *pixm, l_int32 connectivity );
extern l_int32 pixSeedfillGrayInv ( PIX *pixs, PIX *pixm, l_int32 connectivity );
extern l_int32 pixSeedfillGraySimple ( PIX *pixs, PIX *pixm, l_int32 connectivity );
extern l_int32 pixSeedfillGrayInvSimple ( PIX *pixs, PIX *pixm, l_int32 connectivity );
extern PIX * pixSeedfillGrayBasin ( PIX *pixb, PIX *pixm, l_int32 delta, l_int32 connectivity );
extern PIX * pixDistanceFunction ( PIX *pixs, l_int32 connectivity, l_int32 outdepth, l_int32 boundcond );
extern PIX * pixSeedspread ( PIX *pixs, l_int32 connectivity );
extern l_int32 pixLocalExtrema ( PIX *pixs, l_int32 maxmin, l_int32 minmax, PIX **ppixmin, PIX **ppixmax );
extern l_int32 pixSelectedLocalExtrema ( PIX *pixs, l_int32 mindist, PIX **ppixmin, PIX **ppixmax );
extern PIX * pixFindEqualValues ( PIX *pixs1, PIX *pixs2 );
extern l_int32 pixSelectMinInConnComp ( PIX *pixs, PIX *pixm, PTA **ppta, NUMA **pnav );
extern PIX * pixRemoveSeededComponents ( PIX *pixd, PIX *pixs, PIX *pixm, l_int32 connectivity, l_int32 bordersize );
extern void seedfillBinaryLow ( l_uint32 *datas, l_int32 hs, l_int32 wpls, l_uint32 *datam, l_int32 hm, l_int32 wplm, l_int32 connectivity );
extern void seedfillGrayLow ( l_uint32 *datas, l_int32 w, l_int32 h, l_int32 wpls, l_uint32 *datam, l_int32 wplm, l_int32 connectivity );
extern void seedfillGrayInvLow ( l_uint32 *datas, l_int32 w, l_int32 h, l_int32 wpls, l_uint32 *datam, l_int32 wplm, l_int32 connectivity );
extern void seedfillGrayLowSimple ( l_uint32 *datas, l_int32 w, l_int32 h, l_int32 wpls, l_uint32 *datam, l_int32 wplm, l_int32 connectivity );
extern void seedfillGrayInvLowSimple ( l_uint32 *datas, l_int32 w, l_int32 h, l_int32 wpls, l_uint32 *datam, l_int32 wplm, l_int32 connectivity );
extern void distanceFunctionLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 d, l_int32 wpld, l_int32 connectivity );
extern void seedspreadLow ( l_uint32 *datad, l_int32 w, l_int32 h, l_int32 wpld, l_uint32 *datat, l_int32 wplt, l_int32 connectivity );
extern SELA * selaCreate ( l_int32 n );
extern void selaDestroy ( SELA **psela );
extern SEL * selCreate ( l_int32 height, l_int32 width, const char *name );
extern void selDestroy ( SEL **psel );
extern SEL * selCopy ( SEL *sel );
extern SEL * selCreateBrick ( l_int32 h, l_int32 w, l_int32 cy, l_int32 cx, l_int32 type );
extern SEL * selCreateComb ( l_int32 factor1, l_int32 factor2, l_int32 direction );
extern l_int32 ** create2dIntArray ( l_int32 sy, l_int32 sx );
extern l_int32 selaAddSel ( SELA *sela, SEL *sel, const char *selname, l_int32 copyflag );
extern l_int32 selaGetCount ( SELA *sela );
extern SEL * selaGetSel ( SELA *sela, l_int32 i );
extern char * selGetName ( SEL *sel );
extern l_int32 selSetName ( SEL *sel, const char *name );
extern l_int32 selaFindSelByName ( SELA *sela, const char *name, l_int32 *pindex, SEL **psel );
extern l_int32 selGetElement ( SEL *sel, l_int32 row, l_int32 col, l_int32 *ptype );
extern l_int32 selSetElement ( SEL *sel, l_int32 row, l_int32 col, l_int32 type );
extern l_int32 selGetParameters ( SEL *sel, l_int32 *psy, l_int32 *psx, l_int32 *pcy, l_int32 *pcx );
extern l_int32 selSetOrigin ( SEL *sel, l_int32 cy, l_int32 cx );
extern l_int32 selGetTypeAtOrigin ( SEL *sel, l_int32 *ptype );
extern char * selaGetBrickName ( SELA *sela, l_int32 hsize, l_int32 vsize );
extern char * selaGetCombName ( SELA *sela, l_int32 size, l_int32 direction );
extern SARRAY * selaGetSelnames ( SELA *sela );
extern l_int32 selFindMaxTranslations ( SEL *sel, l_int32 *pxp, l_int32 *pyp, l_int32 *pxn, l_int32 *pyn );
extern SEL * selRotateOrth ( SEL *sel, l_int32 quads );
extern SELA * selaRead ( const char *fname );
extern SELA * selaReadStream ( FILE *fp );
extern SEL * selRead ( const char *fname );
extern SEL * selReadStream ( FILE *fp );
extern l_int32 selaWrite ( const char *fname, SELA *sela );
extern l_int32 selaWriteStream ( FILE *fp, SELA *sela );
extern l_int32 selWrite ( const char *fname, SEL *sel );
extern l_int32 selWriteStream ( FILE *fp, SEL *sel );
extern SEL * selCreateFromString ( const char *text, l_int32 h, l_int32 w, const char *name );
extern char * selPrintToString ( SEL *sel );
extern SELA * selaCreateFromFile ( const char *filename );
extern SEL * selCreateFromPta ( PTA *pta, l_int32 cy, l_int32 cx, const char *name );
extern SEL * selCreateFromPix ( PIX *pix, l_int32 cy, l_int32 cx, const char *name );
extern SEL * selReadFromColorImage ( const char *pathname );
extern SEL * selCreateFromColorPix ( PIX *pixs, char *selname );
extern PIX * selDisplayInPix ( SEL *sel, l_int32 size, l_int32 gthick );
extern PIX * selaDisplayInPix ( SELA *sela, l_int32 size, l_int32 gthick, l_int32 spacing, l_int32 ncols );
extern SELA * selaAddBasic ( SELA *sela );
extern SELA * selaAddHitMiss ( SELA *sela );
extern SELA * selaAddDwaLinear ( SELA *sela );
extern SELA * selaAddDwaCombs ( SELA *sela );
extern SELA * selaAddCrossJunctions ( SELA *sela, l_float32 hlsize, l_float32 mdist, l_int32 norient, l_int32 debugflag );
extern SELA * selaAddTJunctions ( SELA *sela, l_float32 hlsize, l_float32 mdist, l_int32 norient, l_int32 debugflag );
extern SEL * pixGenerateSelWithRuns ( PIX *pixs, l_int32 nhlines, l_int32 nvlines, l_int32 distance, l_int32 minlength, l_int32 toppix, l_int32 botpix, l_int32 leftpix, l_int32 rightpix, PIX **ppixe );
extern SEL * pixGenerateSelRandom ( PIX *pixs, l_float32 hitfract, l_float32 missfract, l_int32 distance, l_int32 toppix, l_int32 botpix, l_int32 leftpix, l_int32 rightpix, PIX **ppixe );
extern SEL * pixGenerateSelBoundary ( PIX *pixs, l_int32 hitdist, l_int32 missdist, l_int32 hitskip, l_int32 missskip, l_int32 topflag, l_int32 botflag, l_int32 leftflag, l_int32 rightflag, PIX **ppixe );
extern NUMA * pixGetRunCentersOnLine ( PIX *pixs, l_int32 x, l_int32 y, l_int32 minlength );
extern NUMA * pixGetRunsOnLine ( PIX *pixs, l_int32 x1, l_int32 y1, l_int32 x2, l_int32 y2 );
extern PTA * pixSubsampleBoundaryPixels ( PIX *pixs, l_int32 skip );
extern l_int32 adjacentOnPixelInRaster ( PIX *pixs, l_int32 x, l_int32 y, l_int32 *pxa, l_int32 *pya );
extern PIX * pixDisplayHitMissSel ( PIX *pixs, SEL *sel, l_int32 scalefactor, l_uint32 hitcolor, l_uint32 misscolor );
extern PIX * pixHShear ( PIX *pixd, PIX *pixs, l_int32 yloc, l_float32 radang, l_int32 incolor );
extern PIX * pixVShear ( PIX *pixd, PIX *pixs, l_int32 xloc, l_float32 radang, l_int32 incolor );
extern PIX * pixHShearCorner ( PIX *pixd, PIX *pixs, l_float32 radang, l_int32 incolor );
extern PIX * pixVShearCorner ( PIX *pixd, PIX *pixs, l_float32 radang, l_int32 incolor );
extern PIX * pixHShearCenter ( PIX *pixd, PIX *pixs, l_float32 radang, l_int32 incolor );
extern PIX * pixVShearCenter ( PIX *pixd, PIX *pixs, l_float32 radang, l_int32 incolor );
extern l_int32 pixHShearIP ( PIX *pixs, l_int32 yloc, l_float32 radang, l_int32 incolor );
extern l_int32 pixVShearIP ( PIX *pixs, l_int32 xloc, l_float32 radang, l_int32 incolor );
extern PIX * pixHShearLI ( PIX *pixs, l_int32 yloc, l_float32 radang, l_int32 incolor );
extern PIX * pixVShearLI ( PIX *pixs, l_int32 xloc, l_float32 radang, l_int32 incolor );
extern PIX * pixDeskew ( PIX *pixs, l_int32 redsearch );
extern PIX * pixFindSkewAndDeskew ( PIX *pixs, l_int32 redsearch, l_float32 *pangle, l_float32 *pconf );
extern PIX * pixDeskewGeneral ( PIX *pixs, l_int32 redsweep, l_float32 sweeprange, l_float32 sweepdelta, l_int32 redsearch, l_int32 thresh, l_float32 *pangle, l_float32 *pconf );
extern l_int32 pixFindSkew ( PIX *pixs, l_float32 *pangle, l_float32 *pconf );
extern l_int32 pixFindSkewSweep ( PIX *pixs, l_float32 *pangle, l_int32 reduction, l_float32 sweeprange, l_float32 sweepdelta );
extern l_int32 pixFindSkewSweepAndSearch ( PIX *pixs, l_float32 *pangle, l_float32 *pconf, l_int32 redsweep, l_int32 redsearch, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta );
extern l_int32 pixFindSkewSweepAndSearchScore ( PIX *pixs, l_float32 *pangle, l_float32 *pconf, l_float32 *pendscore, l_int32 redsweep, l_int32 redsearch, l_float32 sweepcenter, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta );
extern l_int32 pixFindSkewSweepAndSearchScorePivot ( PIX *pixs, l_float32 *pangle, l_float32 *pconf, l_float32 *pendscore, l_int32 redsweep, l_int32 redsearch, l_float32 sweepcenter, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta, l_int32 pivot );
extern l_int32 pixFindSkewOrthogonalRange ( PIX *pixs, l_float32 *pangle, l_float32 *pconf, l_int32 redsweep, l_int32 redsearch, l_float32 sweeprange, l_float32 sweepdelta, l_float32 minbsdelta, l_float32 confprior );
extern l_int32 pixFindDifferentialSquareSum ( PIX *pixs, l_float32 *psum );
extern l_int32 pixFindNormalizedSquareSum ( PIX *pixs, l_float32 *phratio, l_float32 *pvratio, l_float32 *pfract );
extern PIX * pixReadStreamSpix ( FILE *fp );
extern l_int32 readHeaderSpix ( const char *filename, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 freadHeaderSpix ( FILE *fp, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 sreadHeaderSpix ( const l_uint32 *data, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *piscmap );
extern l_int32 pixWriteStreamSpix ( FILE *fp, PIX *pix );
extern PIX * pixReadMemSpix ( const l_uint8 *data, size_t size );
extern l_int32 pixWriteMemSpix ( l_uint8 **pdata, size_t *psize, PIX *pix );
extern l_int32 pixSerializeToMemory ( PIX *pixs, l_uint32 **pdata, size_t *pnbytes );
extern PIX * pixDeserializeFromMemory ( const l_uint32 *data, size_t nbytes );
extern L_STACK * lstackCreate ( l_int32 nalloc );
extern void lstackDestroy ( L_STACK **plstack, l_int32 freeflag );
extern l_int32 lstackAdd ( L_STACK *lstack, void *item );
extern void * lstackRemove ( L_STACK *lstack );
extern l_int32 lstackGetCount ( L_STACK *lstack );
extern l_int32 lstackPrint ( FILE *fp, L_STACK *lstack );
extern l_int32 * sudokuReadFile ( const char *filename );
extern l_int32 * sudokuReadString ( const char *str );
extern L_SUDOKU * sudokuCreate ( l_int32 *array );
extern void sudokuDestroy ( L_SUDOKU **psud );
extern l_int32 sudokuSolve ( L_SUDOKU *sud );
extern l_int32 sudokuTestUniqueness ( l_int32 *array, l_int32 *punique );
extern L_SUDOKU * sudokuGenerate ( l_int32 *array, l_int32 seed, l_int32 minelems, l_int32 maxtries );
extern l_int32 sudokuOutput ( L_SUDOKU *sud, l_int32 arraytype );
extern PIX * pixAddSingleTextblock ( PIX *pixs, L_BMF *bmf, const char *textstr, l_uint32 val, l_int32 location, l_int32 *poverflow );
extern PIX * pixAddSingleTextline ( PIX *pixs, L_BMF *bmf, const char *textstr, l_uint32 val, l_int32 location );
extern l_int32 pixSetTextblock ( PIX *pixs, L_BMF *bmf, const char *textstr, l_uint32 val, l_int32 x0, l_int32 y0, l_int32 wtext, l_int32 firstindent, l_int32 *poverflow );
extern l_int32 pixSetTextline ( PIX *pixs, L_BMF *bmf, const char *textstr, l_uint32 val, l_int32 x0, l_int32 y0, l_int32 *pwidth, l_int32 *poverflow );
extern PIXA * pixaAddTextNumber ( PIXA *pixas, L_BMF *bmf, NUMA *na, l_uint32 val, l_int32 location );
extern PIXA * pixaAddTextline ( PIXA *pixas, L_BMF *bmf, SARRAY *sa, l_uint32 val, l_int32 location );
extern SARRAY * bmfGetLineStrings ( L_BMF *bmf, const char *textstr, l_int32 maxw, l_int32 firstindent, l_int32 *ph );
extern NUMA * bmfGetWordWidths ( L_BMF *bmf, const char *textstr, SARRAY *sa );
extern l_int32 bmfGetStringWidth ( L_BMF *bmf, const char *textstr, l_int32 *pw );
extern SARRAY * splitStringToParagraphs ( char *textstr, l_int32 splitflag );
extern PIX * pixReadTiff ( const char *filename, l_int32 n );
extern PIX * pixReadStreamTiff ( FILE *fp, l_int32 n );
extern l_int32 pixWriteTiff ( const char *filename, PIX *pix, l_int32 comptype, const char *modestring );
extern l_int32 pixWriteTiffCustom ( const char *filename, PIX *pix, l_int32 comptype, const char *modestring, NUMA *natags, SARRAY *savals, SARRAY *satypes, NUMA *nasizes );
extern l_int32 pixWriteStreamTiff ( FILE *fp, PIX *pix, l_int32 comptype );
extern PIXA * pixaReadMultipageTiff ( const char *filename );
extern l_int32 writeMultipageTiff ( const char *dirin, const char *substr, const char *fileout );
extern l_int32 writeMultipageTiffSA ( SARRAY *sa, const char *fileout );
extern l_int32 fprintTiffInfo ( FILE *fpout, const char *tiffile );
extern l_int32 tiffGetCount ( FILE *fp, l_int32 *pn );
extern l_int32 getTiffResolution ( FILE *fp, l_int32 *pxres, l_int32 *pyres );
extern l_int32 readHeaderTiff ( const char *filename, l_int32 n, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *pres, l_int32 *pcmap, l_int32 *pformat );
extern l_int32 freadHeaderTiff ( FILE *fp, l_int32 n, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *pres, l_int32 *pcmap, l_int32 *pformat );
extern l_int32 readHeaderMemTiff ( const l_uint8 *cdata, size_t size, l_int32 n, l_int32 *pwidth, l_int32 *pheight, l_int32 *pbps, l_int32 *pspp, l_int32 *pres, l_int32 *pcmap, l_int32 *pformat );
extern l_int32 findTiffCompression ( FILE *fp, l_int32 *pcomptype );
extern l_int32 extractG4DataFromFile ( const char *filein, l_uint8 **pdata, size_t *pnbytes, l_int32 *pw, l_int32 *ph, l_int32 *pminisblack );
extern PIX * pixReadMemTiff ( const l_uint8 *cdata, size_t size, l_int32 n );
extern l_int32 pixWriteMemTiff ( l_uint8 **pdata, size_t *psize, PIX *pix, l_int32 comptype );
extern l_int32 pixWriteMemTiffCustom ( l_uint8 **pdata, size_t *psize, PIX *pix, l_int32 comptype, NUMA *natags, SARRAY *savals, SARRAY *satypes, NUMA *nasizes );
extern l_int32 setMsgSeverity ( l_int32 newsev );
extern l_int32 returnErrorInt ( const char *msg, const char *procname, l_int32 ival );
extern l_float32 returnErrorFloat ( const char *msg, const char *procname, l_float32 fval );
extern void * returnErrorPtr ( const char *msg, const char *procname, void *pval );
extern char * stringNew ( const char *src );
extern l_int32 stringCopy ( char *dest, const char *src, l_int32 n );
extern l_int32 stringLength ( const char *src, size_t size );
extern l_int32 stringCat ( char *dest, size_t size, const char *src );
extern char * stringConcatNew ( const char *first, ... );
extern char * stringJoin ( const char *src1, const char *src2 );
extern char * stringReverse ( const char *src );
extern char * stringRemoveChars ( const char *src, const char *remchars );
extern l_int32 stringFindSubstr ( const char *src, const char *sub, l_int32 *ploc );
extern char * stringReplaceSubstr ( const char *src, const char *sub1, const char *sub2, l_int32 *pfound, l_int32 *ploc );
extern char * stringReplaceEachSubstr ( const char *src, const char *sub1, const char *sub2, l_int32 *pcount );
extern L_DNA * arrayFindEachSequence ( const l_uint8 *data, size_t datalen, const l_uint8 *sequence, size_t seqlen );
extern l_int32 arrayFindSequence ( const l_uint8 *data, size_t datalen, const l_uint8 *sequence, size_t seqlen, l_int32 *poffset, l_int32 *pfound );
extern void * reallocNew ( void **pindata, l_int32 oldsize, l_int32 newsize );
extern l_uint8 * l_binaryRead ( const char *filename, size_t *pnbytes );
extern l_uint8 * l_binaryReadStream ( FILE *fp, size_t *pnbytes );
extern l_uint8 * l_binaryReadSelect ( const char *filename, size_t start, size_t nbytes, size_t *pnread );
extern l_uint8 * l_binaryReadSelectStream ( FILE *fp, size_t start, size_t nbytes, size_t *pnread );
extern l_int32 l_binaryWrite ( const char *filename, const char *operation, void *data, size_t nbytes );
extern size_t nbytesInFile ( const char *filename );
extern size_t fnbytesInFile ( FILE *fp );
extern l_uint8 * l_binaryCopy ( l_uint8 *datas, size_t size );
extern l_int32 fileCopy ( const char *srcfile, const char *newfile );
extern l_int32 fileConcatenate ( const char *srcfile, const char *destfile );
extern l_int32 fileAppendString ( const char *filename, const char *str );
extern l_int32 filesAreIdentical ( const char *fname1, const char *fname2, l_int32 *psame );
extern l_uint16 convertOnLittleEnd16 ( l_uint16 shortin );
extern l_uint16 convertOnBigEnd16 ( l_uint16 shortin );
extern l_uint32 convertOnLittleEnd32 ( l_uint32 wordin );
extern l_uint32 convertOnBigEnd32 ( l_uint32 wordin );
extern FILE * fopenReadStream ( const char *filename );
extern FILE * fopenWriteStream ( const char *filename, const char *modestring );
extern FILE * lept_fopen ( const char *filename, const char *mode );
extern l_int32 lept_fclose ( FILE *fp );
extern void * lept_calloc ( size_t nmemb, size_t size );
extern void lept_free ( void *ptr );
extern l_int32 lept_mkdir ( const char *subdir );
extern l_int32 lept_rmdir ( const char *subdir );
extern void lept_direxists ( const char *dir, l_int32 *pexists );
extern l_int32 lept_rm_match ( const char *subdir, const char *substr );
extern l_int32 lept_rm ( const char *subdir, const char *tail );
extern l_int32 lept_rmfile ( const char *filepath );
extern char * pathJoin ( const char *dir, const char *fname );
extern char * appendSubdirectory ( const char *dir, const char *subdir );
extern l_int32 convertSepCharsInPath ( char *path, l_int32 type );
extern char * genPathname ( const char *dir, const char *fname );
extern l_int32 makeTempDirname ( char *result, size_t nbytes, const char *subdir );
extern l_int32 modifyTrailingSlash ( char *path, size_t nbytes, l_int32 flag );
extern char * genTempFilename ( const char *dir, const char *tail, l_int32 usetime, l_int32 usepid );
extern l_int32 extractNumberFromFilename ( const char *fname, l_int32 numpre, l_int32 numpost );
extern l_int32 fileCorruptByDeletion ( const char *filein, l_float32 loc, l_float32 size, const char *fileout );
extern l_int32 fileCorruptByMutation ( const char *filein, l_float32 loc, l_float32 size, const char *fileout );
extern l_int32 genRandomIntegerInRange ( l_int32 range, l_int32 seed, l_int32 *pval );
extern l_int32 lept_roundftoi ( l_float32 fval );
extern l_uint32 convertBinaryToGrayCode ( l_uint32 val );
extern l_uint32 convertGrayCodeToBinary ( l_uint32 val );
extern char * getLeptonicaVersion (  );
extern void startTimer ( void );
extern l_float32 stopTimer ( void );
extern L_TIMER startTimerNested ( void );
extern l_float32 stopTimerNested ( L_TIMER rusage_start );
extern void l_getCurrentTime ( l_int32 *sec, l_int32 *usec );
extern char * l_getFormattedDate (  );
extern l_int32 pixHtmlViewer ( const char *dirin, const char *dirout, const char *rootname, l_int32 thumbwidth, l_int32 viewwidth, l_int32 copyorig );
extern PIX * pixSimpleCaptcha ( PIX *pixs, l_int32 border, l_int32 nterms, l_uint32 seed, l_uint32 color, l_int32 cmapflag );
extern PIX * pixRandomHarmonicWarp ( PIX *pixs, l_float32 xmag, l_float32 ymag, l_float32 xfreq, l_float32 yfreq, l_int32 nx, l_int32 ny, l_uint32 seed, l_int32 grayval );
extern PIX * pixWarpStereoscopic ( PIX *pixs, l_int32 zbend, l_int32 zshiftt, l_int32 zshiftb, l_int32 ybendt, l_int32 ybendb, l_int32 redleft );
extern PIX * pixStretchHorizontal ( PIX *pixs, l_int32 dir, l_int32 type, l_int32 hmax, l_int32 operation, l_int32 incolor );
extern PIX * pixStretchHorizontalSampled ( PIX *pixs, l_int32 dir, l_int32 type, l_int32 hmax, l_int32 incolor );
extern PIX * pixStretchHorizontalLI ( PIX *pixs, l_int32 dir, l_int32 type, l_int32 hmax, l_int32 incolor );
extern PIX * pixQuadraticVShear ( PIX *pixs, l_int32 dir, l_int32 vmaxt, l_int32 vmaxb, l_int32 operation, l_int32 incolor );
extern PIX * pixQuadraticVShearSampled ( PIX *pixs, l_int32 dir, l_int32 vmaxt, l_int32 vmaxb, l_int32 incolor );
extern PIX * pixQuadraticVShearLI ( PIX *pixs, l_int32 dir, l_int32 vmaxt, l_int32 vmaxb, l_int32 incolor );
extern PIX * pixStereoFromPair ( PIX *pix1, PIX *pix2, l_float32 rwt, l_float32 gwt, l_float32 bwt );
extern L_WSHED * wshedCreate ( PIX *pixs, PIX *pixm, l_int32 mindepth, l_int32 debugflag );
extern void wshedDestroy ( L_WSHED **pwshed );
extern l_int32 wshedApply ( L_WSHED *wshed );
extern l_int32 wshedBasins ( L_WSHED *wshed, PIXA **ppixa, NUMA **pnalevels );
extern PIX * wshedRenderFill ( L_WSHED *wshed );
extern PIX * wshedRenderColors ( L_WSHED *wshed );
extern PIX * pixReadStreamWebP ( FILE *fp );
extern PIX * pixReadMemWebP ( const l_uint8 *filedata, size_t filesize );
extern l_int32 readHeaderWebP ( const char *filename, l_int32 *pw, l_int32 *ph, l_int32 *pspp );
extern l_int32 readHeaderMemWebP ( const l_uint8 *data, size_t size, l_int32 *pw, l_int32 *ph, l_int32 *pspp );
extern l_int32 pixWriteWebP ( const char *filename, PIX *pixs, l_int32 quality, l_int32 lossless );
extern l_int32 pixWriteStreamWebP ( FILE *fp, PIX *pixs, l_int32 quality, l_int32 lossless );
extern l_int32 pixWriteMemWebP ( l_uint8 **pencdata, size_t *pencsize, PIX *pixs, l_int32 quality, l_int32 lossless );
extern l_int32 pixaWriteFiles ( const char *rootname, PIXA *pixa, l_int32 format );
extern l_int32 pixWrite ( const char *filename, PIX *pix, l_int32 format );
extern l_int32 pixWriteStream ( FILE *fp, PIX *pix, l_int32 format );
extern l_int32 pixWriteImpliedFormat ( const char *filename, PIX *pix, l_int32 quality, l_int32 progressive );
extern l_int32 pixChooseOutputFormat ( PIX *pix );
extern l_int32 getImpliedFileFormat ( const char *filename );
extern const char * getFormatExtension ( l_int32 format );
extern l_int32 pixWriteMem ( l_uint8 **pdata, size_t *psize, PIX *pix, l_int32 format );
extern l_int32 pixDisplay ( PIX *pixs, l_int32 x, l_int32 y );
extern l_int32 pixDisplayWithTitle ( PIX *pixs, l_int32 x, l_int32 y, const char *title, l_int32 dispflag );
extern l_int32 pixDisplayMultiple ( const char *filepattern );
extern l_int32 pixDisplayWrite ( PIX *pixs, l_int32 reduction );
extern l_int32 pixDisplayWriteFormat ( PIX *pixs, l_int32 reduction, l_int32 format );
extern l_int32 pixSaveTiled ( PIX *pixs, PIXA *pixa, l_float32 scalefactor, l_int32 newrow, l_int32 space, l_int32 dp );
extern l_int32 pixSaveTiledOutline ( PIX *pixs, PIXA *pixa, l_float32 scalefactor, l_int32 newrow, l_int32 space, l_int32 linewidth, l_int32 dp );
extern l_int32 pixSaveTiledWithText ( PIX *pixs, PIXA *pixa, l_int32 outwidth, l_int32 newrow, l_int32 space, l_int32 linewidth, L_BMF *bmf, const char *textstr, l_uint32 val, l_int32 location );
extern void l_chooseDisplayProg ( l_int32 selection );
extern l_uint8 * zlibCompress ( l_uint8 *datain, size_t nin, size_t *pnout );
extern l_uint8 * zlibUncompress ( l_uint8 *datain, size_t nin, size_t *pnout );
