# Generated by default/object.tt
package Paws::XRay::InsightsConfiguration;
  use Moose;
  has InsightsEnabled => (is => 'ro', isa => 'Bool');
  has NotificationsEnabled => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::XRay::InsightsConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::XRay::InsightsConfiguration object:

  $service_obj->Method(Att1 => { InsightsEnabled => $value, ..., NotificationsEnabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::XRay::InsightsConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->InsightsEnabled

=head1 DESCRIPTION

The structure containing configurations related to insights.

=head1 ATTRIBUTES


=head2 InsightsEnabled => Bool

Set the InsightsEnabled value to true to enable insights or false to
disable insights.


=head2 NotificationsEnabled => Bool

Set the NotificationsEnabled value to true to enable insights
notifications. Notifications can only be enabled on a group with
InsightsEnabled set to true.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::XRay>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

