# Generated by default/object.tt
package Paws::PerformanceInsights::DimensionKeyDetail;
  use Moose;
  has Dimension => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::PerformanceInsights::DimensionKeyDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::PerformanceInsights::DimensionKeyDetail object:

  $service_obj->Method(Att1 => { Dimension => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::PerformanceInsights::DimensionKeyDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->Dimension

=head1 DESCRIPTION

An object that describes the details for a specified dimension.

=head1 ATTRIBUTES


=head2 Dimension => Str

The full name of the dimension. The full name includes the group name
and key name. The only valid value is C<db.sql.statement>.


=head2 Status => Str

The status of the dimension detail data. Possible values include the
following:

=over

=item *

C<AVAILABLE> - The dimension detail data is ready to be retrieved.

=item *

C<PROCESSING> - The dimension detail data isn't ready to be retrieved
because more processing time is required. If the requested detail data
for C<db.sql.statement> has the status C<PROCESSING>, Performance
Insights returns the truncated query.

=item *

C<UNAVAILABLE> - The dimension detail data could not be collected
successfully.

=back



=head2 Value => Str

The value of the dimension detail data. For the C<db.sql.statement>
dimension, this value is either the full or truncated SQL query,
depending on the return status.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::PerformanceInsights>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

