#!/usr/bin/perl -w
#
# Jan 2016  M.Eckardt, imunixx GmbH			<Matthias.Eckardt@imunixx.de>
# SDG
############################################################################
use strict;
use Script::Toolbox qw(:all);
use Script::Toolbox::TableO;
############################################################################
my $O = {
    'file' => { 'mod' => '=s', 'desc' => 'Get a file name.', 'mand' => 1, 'default'	=> '/bin/cat', },
};
############################################################################
############ generate prototypes with the following line ###################
# :r! echo $(grep '^sub' queue_blocking.pl | sed -e 's/$/;/') | fold -s -80
############################################################################
############################################################################
#$SIG{'INT'} = 'sigExit';
#$SIG{'HUP'} = 'sigExit';
#$SIG{'QUIT'}= 'sigExit';
#$SIG{'TERM'}= 'sigExit';
############################################################################
#------------------------------------------------------------------------------
# Signal handler.
#------------------------------------------------------------------------------
#sub sigExit($)
#{
#    my ($sig) = @_;
#    Exit( 1, "program aborted by signal SIG$sig." );
#}



#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
sub main
{
	my ($self) = @_;
    my $o = Script::Toolbox->new( $O );

    my $m = Script::Toolbox::Util::Menues->new({'SubMenue1'=>[{'label'=>'test','value'=>10}]});
       $m->addMenue({'MainMenue'=>[{'label'=>'test1', 'value'=>10,'readOnly'=>1},
                                   {'label'=>'test2', 'value'=>20,},
                                   {'label'=>'test3', 'value'=>30,},
                                   {'label'=>'Untermenue 1','jump'=>'SubMenue1'}
                                  ]});
       $m->setAutoHeader();
    my $r = $m->run('MainMenue',-1);

    printf "\n%s\n", '-' x 20;
    my $v = $m->getMatching('MainMenue','test','label','value');
    printf "Values of Labels /test/  : %s\n", join ' ', @{$v};
    my $v = $m->getMatching('MainMenue','(1|3)','number','value');
    printf "Values of Numbers /(1|3)/: %s\n", join ' ', @{$v};
    my $v = $m->getMatching('MainMenue','\d+','value','label');
    printf "Labels of Values /\d+/   : %s\n", join ' ', @{$v};
    printf "\n%s\n", '-' x 20;

#    my $t = Table([ 'Util-Table',
#                    [ '--H1--',  '--H2--', '--H3--'],
#                    [ '11:11:11',  33.456, 'cc  '  ],
#                    [ '12:23:00', 2222222, 3       ],
#                    [ '11:11', 222, 3333333333333333 ]]);
#    print join "\n", @{$t};
#
#       $t = $o->Table([ 'Util-Table as Script::Toolbox Object',
#                    [ '--H1--',  '--H2--', '--H3--'],
#                    [ '11:11:11',  33.456, 'cc  '  ],
#                    [ '12:23:00', 2222222, 3       ],
#                    [ '11:11', 222, 3333333333333333 ]]);
#    print join "\n", @{$t};
#
#    my $T = Script::Toolbox::TableO->new([ 'TableO',
#                         [ '--H1--',  '--H2--', '--H3--'],
#                         [ '11:11:11',  33.456, 'cc  '  ],
#                         [ '12:23:00', 2222222, 3       ],
#                         [ '11:11', 222, 3333333333333333 ]]);
#    print $T->asString("\n\n");
#	return;
}
main();

############################################################################
1;
__END__
