# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193635;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{ru} = {"7844", "Волгоградская\ обл\.",
"7483", "Брянская\ обл\.",
"7345", "Тюменская\ обл\.",
"771147", "Акжаикский\ р\-н",
"7353", "Оренбургская\ обл\.",
"771639", "Енбекшилдерский\ р\-н",
"7347", "Республика\ Башкортостан",
"77162", "Кокшетау",
"771633", "Ерейментауский\ р\-н",
"7352", "Курганская\ обл\.",
"7482", "Тверская\ обл\.",
"7869", "г\.\ Севастополь",
"77292", "Актау",
"771142", "Акжаикский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"771839", "Лебяжинский\ р\-н",
"772439", "Аральский\ р\-н",
"77122", "Атырау",
"772251", "Курчатов",
"771540", "Уалихановский\ р\-н",
"772159", "Карагандинская\ область",
"771233", "Курмангазинский\ р\-н",
"7382", "Томская\ обл\.",
"772543", "Аксумбе",
"772230", "Урджарский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"772433", "Аральский\ р\-н",
"771833", "Качирский\ р\-н",
"772774", "Талгарский\ р\-н",
"7388", "Республика\ Алтай",
"771131", "Зеленовский\ р\-н",
"771430", "Аркалык",
"772830", "Алакольский\ р\-н",
"771239", "Макатский\ р\-н",
"772153", "Абайский\ р\-н",
"77182", "Павлодар",
"77242", "Кызылорда",
"771451", "Сарыкольский\ р\-н",
"77272956", "Талгар",
"7383", "Новосибирская\ обл\.",
"772330", "Зыряновский\ р\-н",
"77274", "Карасайский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"771456", "Качар",
"771448", "Карасуский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"7475", "Тамбовская\ обл\.",
"772351", "Бородулихинский\ р\-н",
"77132", "Актобе\/Актюбинск",
"771136", "Акжаикский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"772256", "Алгабас",
"7879", "Ставропольский\ край",
"7486", "Орловская\ обл\.",
"771544", "Жамбылский\ р\-н",
"7424", "Сахалинская\ обл\.",
"7351", "Челябинская\ обл\.",
"771842", "Майский\ р\-он",
"771347", "Айтекебийский\ р\-н",
"7712303", "Тензиз",
"7481", "Смоленская\ обл\.",
"772532", "Абая",
"772931", "Мангистауский\ р\-н",
"772770", "Жамбылский\ р\-н",
"771434", "Денисовский\ р\-н",
"771636", "Щучинский\ р\-н",
"772834", "Каратальский\ р\-н",
"772537", "Сарыагаш",
"771631", "Шортандинский\ р\-н",
"772334", "Уланский\ р\-н",
"771034", "Улытауский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7413", "Магаданская\ обл\.",
"7395", "Иркутская\ обл\.",
"77279", "Алматы",
"771642", "Егиндыкольский\ р\-н",
"771236", "Махамбетский\ р\-н",
"772546", "Шолаккорган",
"7416", "Амурская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771836", "Щербактинский\ р\-н",
"772634", "Жанатас",
"740", "Калининградская\ обл\.",
"772148", "Осакаровский\ р\-н",
"772156", "Шахтинск",
"7495", "Московская\ обл\.",
"771331", "Мартукский\ р\-н",
"772345", "Жарминский\ р\-н",
"77112", "Уральск",
"771336", "Хромтауский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"771831", "Железинский\ р\-н",
"772431", "Жалагашский\ р\-н",
"771445", "Алтынсаринский\ р\-н",
"7381", "Омская\ обл\.",
"771133", "Бурлинский\ р\-н",
"771231", "Исатайский\ р\-н",
"771647", "Есильский\ р\-н",
"772541", "Мырзакент",
"771535", "Габита\ Мусрепова\ р\-н",
"771459", "Костанайская\ область",
"736", "Республика\ Крым",
"771139", "Таскалинский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"772339", "Курчумский\ р\-н",
"771039", "Приозерск",
"77102", "Жезказган",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"7863", "Ростовская\ обл\.",
"77232", "Усть\-Каменогорск",
"772333", "Кокпектинский\ р\-н",
"771330", "Хромтауский\ р\-н",
"771033", "Шетский\ р\-н",
"77142", "Костанай",
"77282", "Талдыкорган",
"772239", "Урджарский\ р\-н",
"772131", "Абайский\ р\-н",
"771145", "Каратобинский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772833", "Алакольский\ р\-н",
"771433", "Лисаковск",
"771348", "Шалкарский\ р\-н",
"771543", "Есильский\ р\-н",
"7846", "Самарская\ обл\.",
"771230", "Атырауская\ область",
"772540", "Арыс",
"7862", "Краснодарский\ край",
"77222", "Семипалатинск",
"771439", "Джангильдинский\ р\-н",
"772839", "Саркандский\ р\-н",
"7421", "Хабаровский\ край",
"7873", "Республика\ Ингушетия",
"7855", "Республика\ Татарстан",
"772752", "Илийский\ р\-н",
"7843", "Республика\ Татарстан",
"7484", "Калужская\ обл\.",
"771648", "Жаркаинский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772771", "Карасайский\ р\-н",
"771134", "Сырымский\ р\-н",
"772633", "Жамбылский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"771630", "Боровое",
"7842", "Ульяновская\ обл\.",
"771651", "Целиноградский\ р\-н",
"7872", "Республика\ Дагестан",
"7866", "Республика\ Кабардино\-Балкарская",
"77262", "Тараз",
"772639", "Сарысуский\ р\-н",
"7878", "Республика\ Карачаево\-Черкесская",
"772147", "Каркаралинский\ р\-н",
"772757", "Акший",
"7848", "Самарская\ обл\.",
"771541", "Мамлютский\ р\-н",
"772535", "Шардара",
"7817", "Вологодская\ обл\.",
"77135", "Актюбинская\ область",
"772934", "Жанаозен",
"771130", "Зеленовский\ р\-н",
"771431", "Рудный",
"772831", "Панфиловский\ р\-н",
"771845", "Павлодар",
"772336", "Риддер",
"7815", "Мурманская\ обл\.",
"7861", "Краснодарский\ край",
"77212", "Караганда",
"771036", "Балхаш",
"77245", "Кызылординская\ область",
"77185", "Шалдай",
"771345", "Байганинский\ р\-н",
"772331", "Глубоковский\ р\-н",
"771031", "Шетский\ р\-н",
"772725", "Отеген\-Батыр",
"77213", "Темиртау",
"7712302", "Тенгизшевройл",
"772836", "Ескельдинский\ р\-н",
"771436", "Тарановский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"771546", "Акжарский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"77125", "Атырауская\ область",
"7841", "Пензенская\ обл\.",
"771447", "Карабалыкский\ р\-н",
"771042", "Акой",
"7871", "Республика\ Чеченская",
"7423", "Приморский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772631", "Турара\ Рыскулова\ р\-н",
"771645", "Степногорск",
"771537", "Тимирязевский\ р\-н",
"772636", "Кордай",
"771834", "Успенский\ р\-н",
"772773", "Балхашский\ р\-н",
"771532", "Аккайынский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"772347", "Жарминский\ р\-н",
"772779", "Райымбекский\ р\-н",
"771442", "Федоровский\ р\-н",
"772842", "Кербулакский\ р\-н",
"771234", "Индерский\ р\-н",
"772544", "Шаульдер",
"771149", "Акжаикский\ р\-н",
"7818", "Архангельская\ обл\.",
"771545", "Жамбылский\ р\-н",
"772531", "Аксукент",
"771637", "Коргалжынский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771143", "Теректинский\ р\-н",
"771841", "Актогайский\ р\-н",
"772835", "Текели",
"771435", "Житикаринский\ р\-н",
"771346", "Темирский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"772335", "Зыряновск",
"771341", "Хобдинский\ р\-н",
"772138", "Бухар\-Жырауский\ р\-н",
"771035", "Улытауский\ р\-н",
"77145834", "Красногорск",
"772644", "Таласский\ р\-н",
"772536", "Кентау",
"7820", "Вологодская\ обл\.",
"772937", "Каракиянский\ р\-н",
"7813", "Ленинградская\ обл\.",
"7831", "Нижегородская\ обл\.",
"771632", "Зерендинский\ р\-н",
"7494", "Костромская\ обл\.",
"772437", "Кармакшинский\ р\-н",
"771837", "Аксуский\ р\-н",
"7499", "г\.\ Москва",
"771332", "Уилский\ р\-н",
"7816", "Новгородская\ обл\.",
"772778", "Уйгурский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"772635", "Жуалынский\ р\-н",
"772547", "Ленгер",
"771641", "Астраханский\ р\-н",
"7394", "Республика\ Тыва",
"771237", "Жылыойский\ р\-н",
"771444", "Узункольский\ р\-н",
"771646", "Буландинский\ р\-н",
"771232", "Атырауская\ область",
"7851", "Астраханская\ обл\.",
"772542", "Асыката",
"7390", "Республика\ Хакасия",
"771337", "Алгинский\ р\-н",
"7427", "Чукотский\ АО",
"771832", "Иртышский\ р\-н",
"772432", "Шиелийский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"7717", "Астана",
"7474", "Липецкая\ обл\.",
"771349", "Шалкарский\ р\-н",
"771146", "Акжаикский\ р\-н",
"7349", "Ямало\-Ненецкий\ АО",
"771040", "Жайрем\ \(ГОК\)",
"771343", "Иргизский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772838", "Коксуский\ р\-н",
"77273", "Алма\-Ата",
"772340", "Зайсанский\ р\-н",
"772539", "Казыгурт",
"771141", "Жангалинский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"772840", "Кербулакский\ р\-н",
"77272", "Алма\-Ата",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771038", "Сыры\-Шаган",
"772338", "Уланский\ р\-н",
"771843", "Майский\ р\-н",
"772533", "Туркестан",
"7865", "Ставропольский\ край",
"7833", "Кировская\ обл\.",
"7811", "Псковская\ обл\.",
"77252", "Шымкент",
"7836", "Республика\ Марий\ Эл",
"771132", "Теректинский\ р\-н",
"771452", "Карасуский\ р\-н",
"772252", "Абайский\ р\-н",
"772638", "Шуский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"772144", "Нуринский\ р\-н",
"7845", "Саратовская\ обл\.",
"771643", "Атбасарский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"772257", "Шульбинск",
"771649", "Жаксынский\ р\-н",
"771457", "Джангильдинский\ р\-н",
"7847", "Республика\ Калмыкия",
"771137", "Чингирлауский\ р\-н",
"7877", "Республика\ Адыгея",
"772534", "Жетысай",
"772832", "Аксуский\ р\-н",
"771037", "Актогайский\ р\-н",
"7496", "г\.\ Москва",
"772337", "Серебрянск",
"771542", "Уалихановский\ р\-н",
"772935", "Каракиянский\ р\-н",
"771844", "Иртышский\ р\-н",
"7415", "Камчатский\ край",
"772237", "Аязог",
"7341", "Республика\ Удмуртская",
"772641", "Таласский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771547", "Жамбылский\ р\-н",
"77187", "Экибастуз",
"7301", "Республика\ Бурятия",
"772332", "Шемонаихинский\ р\-н",
"771032", "Каражал",
"77149", "Костанай",
"772837", "Алакольский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7498", "Московская\ обл\.",
"7471", "Курская\ обл\.",
"772632", "Меркенский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"771644", "Аршалынский\ р\-н",
"771446", "Узункольский\ р\-н",
"771458", "Костанайская\ область",
"733", "Байконыр",
"771041", "Актау\,\ Жезказган",
"771138", "Казталовский\ р\-н",
"7492", "Владимирская\ обл\.",
"771335", "Шалкарский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"772435", "Жанакорганский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"771140", "Бокейординский\ р\-н",
"772841", "Аксуский\ р\-н",
"771235", "Макатский\ р\-н",
"772545", "Икан",
"771531", "Магжана\ Жумабаева\ р\-н",
"772637", "Байзакский\ р\-н",
"7493", "Ивановская\ обл\.",
"7814", "Республика\ Карелия",
"772149", "Осакаровский\ р\-н",
"772759", "Алматинская\ область",
"7342", "Пермский\ край",
"772137", "Сарань",
"77106", "Сатпаев",
"772938", "Тупкараганский\ р\-н",
"7302", "Забайкальский\ край",
"771640", "Сандыктауский\ р\-н",
"7391", "Красноярский\ край",
"772643", "Шуский\ р\-н",
"771144", "Казталовский\ р\-н",
"771638", "Аккольский\ р\-н",
"7343", "Свердловская\ обл",
"7485", "Ярославская\ обл\.",
"7487", "Тульская\ обл\.",
"772132", "Нуринский\ р\-н",
"77272983", "Каскелен",
"771449", "Тарановский\ р\-н",
"7821", "Республика\ Коми",
"77152", "Петропавловск",
"7473", "Воронежская\ обл\.",
"772530", "Темирлановка",
"7385", "Алтайский\ край",
"772772", "Капчагай",
"771533", "Айыртауский\ р\-н",
"772843", "Лепсы",
"771443", "Мендыкаринский\ р\-н",
"771840", "Баянаульский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771135", "Жанибекский\ р\-н",
"771455", "Костанайский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"771340", "Хобдинский\ р\-н",
"771838", "Майский\ р\-он",
"772343", "Курчумский\ р\-н",
"772438", "Казалинский\ р\-н",
"772146", "Каркаралинск",
"7472", "Белгородская\ обл\.",
"77224", "Эмельтау",
"772777", "Райымбекский\ р\-н",
"7834", "Республика\ Мордовия",
"772548", "Шаян",
"7491", "Рязанская\ обл\.",
"771238", "Кзылкогинский\ р\-н",};
$areanames{en} = {"7712303", "Tengizs",
"7481", "Smolensk",
"771347", "Aitekebisky\ District",
"7351", "Chelyabinsk",
"771544", "Presnovka",
"7424", "Sakhalin\ Region",
"771842", "Koktobe",
"772532", "Abai",
"771434", "Denisovka",
"772834", "Ushtobe",
"771636", "Shuchinsk",
"772931", "Shetpe",
"772770", "Uzynagash",
"772334", "Tavricheskoye",
"771034", "Zhezdy",
"771631", "Shortandy",
"772537", "Saryagash",
"7395", "Irkutsk",
"77279", "Almaty",
"771342", "Badamsha",
"7413", "Magadan",
"771642", "Egendykol",
"771236", "Makhambet",
"772546", "Sholakkorgan",
"7416", "Amur\ Region",
"772148", "Molodezhnoye",
"772156", "Shakhtinsk",
"7495", "Moscow",
"771331", "Martuk",
"772345", "Shar",
"772353", "Novaya\ Shulba",
"772436", "Terenozek",
"772634", "Zhanatas",
"771836", "Sharbakty",
"740", "Kaliningrad",
"7381", "Omsk",
"771831", "Zhelezinka",
"771445", "Ubaganskoye",
"772431", "Zhalagash",
"771133", "Aksai",
"77112", "Uralsk",
"771453", "Auliekol",
"771336", "Khromtau",
"736", "Simferopol",
"771139", "Taskala",
"771231", "Akkystau",
"772541", "Myrzakent",
"771647", "Esil",
"771459", "Kostanai\ Region",
"771535", "Novoishimski",
"7353", "Orenburg",
"771639", "Stepnyak",
"7844", "Volgograd",
"7345", "Tyumen",
"771147", "Akzhaiksky\ District",
"7483", "Bryansk",
"771633", "Ereimentau",
"77162", "Kokshetau\/Krasni\ Yar",
"7347", "Republic\ of\ Bashkortostan",
"7482", "Tver",
"7869", "Sevastopol",
"77292", "Aktau",
"7352", "Kurgan",
"771142", "Taipak",
"7411", "Republic\ of\ Sakha",
"771233", "Ganyushkino",
"772159", "Karaganda\ Region",
"771540", "Kishkenekol",
"772230", "Urdzhar",
"772543", "Aqsumbe",
"7382", "Tomsk",
"771839", "Akku",
"772439", "Aralsky\ District",
"772251", "Kurchatov",
"77122", "Atyrau",
"771239", "Makat",
"772153", "Topar",
"77182", "Pavlodar",
"77242", "Kyzylorda",
"771451", "Sarykol",
"772433", "Aralsk",
"772348", "Kokpekty",
"771833", "Terenkol",
"771430", "Arkalyk",
"771131", "Darinskoye",
"772830", "Alakolsky\ District",
"772774", "Talgar",
"7388", "Republic\ of\ Altai",
"7475", "Tambov",
"772351", "Borodulikha",
"77132", "Aktobe\/Kargalinskoye",
"771136", "Chapayev",
"77274", "Karassaisky\ District",
"772330", "Zyryanovsky\ District",
"77272956", "Talgar",
"7383", "Novosibirsk",
"771030", "Atasu",
"771448", "Oktyabrskoye",
"771456", "Kachar",
"771333", "Kandyagash",
"771538", "Beskol",
"7486", "Orel",
"7879", "Mineranye\ Vody",
"772256", "Kainar",
"771339", "Komsomolskoye",
"7817", "Vologda",
"771541", "Mamlutka",
"772535", "Shardara",
"772336", "Ridder",
"771036", "Balkhash",
"7861", "Krasnodar\ Territory",
"77212", "Karaganda",
"7815", "Murmansk",
"771130", "Peremetnoye",
"771431", "Rudny",
"771845", "Pavlodar\ Area",
"772831", "Zharkent",
"77135", "Aktobe\ Region",
"772934", "Zhanaozen",
"77213", "Aktau\/Temirtau",
"772725", "Otegen\ Batyra",
"772836", "Karabulak",
"7712302", "Tengizshevroil",
"771436", "Taranovskoye",
"771345", "Karauylkeldy",
"772331", "Glubokoye",
"77245", "Kyzylorda\ Region",
"77185", "Shaldai",
"771031", "Aksu\-Ayuly",
"77125", "Atyrau\ Region",
"7426", "Jewish\ Autonomous\ Region",
"771546", "Talshik",
"772236", "Beskaragai",
"772642", "Moiynkum",
"7871", "Chechen\ Republic",
"7423", "Primorie\ territory",
"771042", "Zharyk",
"772342", "Katon\-Karagai",
"7841", "Penza",
"771447", "Karabalyksky\ District",
"771537", "Timiryazevo",
"772631", "Kulan",
"771645", "Stepnogorsk",
"771334", "Emba",
"772154", "Botakara",
"772636", "Kordai",
"771834", "Uspenka",
"771532", "Smirnovo",
"772773", "Bakanas",
"771442", "Fyodorovka",
"771234", "Indernborski",
"772842", "Kogaly",
"772544", "Shaulder",
"772347", "Kalbatau",
"772779", "Narynkol",
"772339", "Kurchum",
"771039", "Priozersk",
"772538", "Turara\ Ryskulova",
"772333", "Samarskoye",
"771033", "Agadyr",
"771330", "Khromtau\ District",
"77102", "Zhezkazgan",
"77232", "Ust\-Kamenogorsk",
"7863", "Rostov",
"7835", "Chuvashi\ Republic",
"7384", "Kemerovo",
"771145", "Karatobe\ District",
"772131", "Abai",
"772833", "Usharal",
"771433", "Lisakovsk",
"771348", "Shalkarsky\ District",
"77142", "Kostanai",
"77282", "Taldykorgan",
"772239", "Makanchi",
"7862", "Sochi",
"77222", "Semey",
"771439", "Torgai",
"772839", "Sarkand",
"7846", "Samara",
"771543", "Yavlenka",
"771230", "Atyrau\ Region",
"772540", "Arys",
"7843", "Republic\ of\ Tatarstan",
"7484", "Kaluga",
"7421", "Khabarovsk\ Territory",
"7873", "Ingushi\ Republic",
"7855", "Naberezhnye\ Chelny",
"772752", "Otegen\ Batyra",
"771134", "Zhympity",
"772771", "Kaskelen",
"771648", "Derzhavinsk",
"771454", "Karamendy",
"7872", "Republic\ of\ Daghestan",
"7866", "Kabardino\-Balkarian\ Republic",
"771651", "Kabanbai\ Batyr",
"77262", "Taraz",
"772633", "Asa",
"771630", "Burabay",
"7842", "Ulyanovsk",
"772776", "Shelek",
"772757", "Akshi",
"772147", "Egindybulak",
"7848", "Tolyatti",
"772639", "Saudakent",
"7878", "Karachayevo\-Cherkessian\ Republic",
"7474", "Lipetsk",
"771349", "Shalkarsky\ District",
"7717", "Astana",
"771343", "Irgiz",
"771438", "Amangeldy",
"772838", "Balpyk\ bi",
"771040", "Zhairem\ \(GOK\)",
"77273", "Almaty",
"772340", "Zaisan",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"771146", "Akzhaiksky\ District",
"7867", "Republic\ of\ North\ Ossetia",
"771038", "Shashubai",
"77272", "Almaty",
"771141", "Zhangala",
"771440", "Amangeldy",
"772840", "Saryozek",
"772338", "Bozanbai\/Molodezhnyi",
"771843", "Maisky\ District",
"772539", "Kazygurt",
"7865", "Stavropol\ territory",
"7833", "Kirov",
"7811", "Pskov",
"77252", "Shymkent",
"772533", "Turkestan",
"771452", "Karasu",
"7836", "Republic\ of\ Marij\ El",
"771132", "Fyodorovka",
"772144", "Kiyevka",
"772775", "Esik",
"772638", "Tole\ bi",
"772252", "Karaul",
"772257", "Shulbinsk",
"771643", "Atbasar",
"7845", "Saratov",
"772640", "Moiynkumsky\ District",
"771137", "Chingirlau",
"7877", "Republic\ of\ Adygeya",
"771457", "Dzhangildinsky\ District",
"771649", "Zhaksynsky\ District",
"7847", "Republic\ of\ Kalmykia",
"771637", "Korgalzhyn",
"772531", "Aksukent",
"771545", "Zhambylsky\ District",
"772932", "Beineu",
"771149", "Zelenovsky\ District",
"7818", "Arkhangelsk",
"7812", "St\ Petersburg",
"771346", "Shubarkuduk",
"771143", "Akzhaik",
"771841", "Aktogai",
"772835", "Tekeli",
"771435", "Zhitikara",
"77145834", "Krasnogorsk",
"772644", "Karatau",
"771341", "Khobda",
"772335", "Zyryanovsk",
"771035", "Ulytau",
"772138", "Gabidena\ Mustafina",
"7494", "Kostroma",
"7820", "Cherepovets",
"772937", "Kuryk",
"772536", "Kentau",
"7831", "Nizhni\ Novgorod",
"7813", "Leningrad\ region",
"771632", "Zerenda",
"7499", "Moscow",
"7816", "Veliky\ Novgorod",
"771332", "Uil",
"772437", "Zhosaly",
"771837", "Aksu",
"772547", "Lenger",
"772635", "Bauyrzhan\ Mamyshuly",
"771641", "Astrakhanka",
"7394", "Republic\ of\ Tuva",
"771237", "Kulsary",
"772778", "Chundzha",
"772344", "Akzhar",
"7390", "Republic\ of\ Khakassia",
"771444", "Uzunkol",
"771232", "Atyrau\ Region",
"771646", "Makinsk",
"772542", "Asykata",
"7851", "Astrakhan",
"771832", "Irtyshsk",
"772432", "Shiyeli",
"771534", "Sergeyevka",
"771337", "Alga",
"7427", "Chukotka\ Autonomous\ District",
"77106", "Satpaev",
"7342", "Perm",
"772137", "Saran",
"771640", "Balkashino",
"7391", "Krasnoyarsk\ Territory",
"772643", "Shu",
"772938", "Fort\ Shevchenko",
"7302", "Chita",
"771638", "Akkol",
"7485", "Yaroslavl",
"7343", "Ekaterinburg",
"771144", "Kaztalovka",
"7487", "Tula",
"772132", "Nurinsky\ District",
"77272983", "Kaskelen",
"7385", "Altai\ Territory",
"772530", "Temirlanovka",
"771533", "Saumalkol",
"772772", "Kapchagai",
"7821", "Komi\ Republic",
"771449", "Taranovskoye",
"77152", "Petropavlovsk",
"7473", "Voronezh",
"771455", "Zatobolsk",
"771539", "Beskol",
"772843", "Lepsy",
"771443", "Borovskoi",
"771840", "Bayanaul",
"7346", "Surgut",
"771135", "Zhanibek",
"772146", "Karkaralinsk",
"7472", "Belgorod",
"771340", "Khobdinsky\ District",
"771043", "Zhairem",
"771838", "Koktobe",
"772343", "Terekty",
"772438", "Aiteke\ bi",
"772548", "Shayan",
"7491", "Ryazan",
"771238", "Miyaly",
"77224", "Barshatas",
"772777", "Kegen",
"7834", "Republic\ of\ Mordovia",
"771037", "Aktogai",
"7496", "Moscow",
"772337", "Serebryansk",
"772534", "Zhetysai",
"772832", "Zhansugurov",
"771542", "Kishkenekol",
"771844", "Irtyshsky\ District",
"7415", "Kamchatka\ Region",
"772935", "Zhetybai",
"77187", "Ekibastuz",
"772237", "Ayagoz",
"7341", "Udmurtian\ Republic",
"771547", "Zhambylsky\ District",
"771635", "Zhaksy",
"772641", "Akkol",
"772837", "Kabanbai",
"771437", "Kamysty",
"772332", "Shemonaikha",
"7301", "Republic\ of\ Buryatia",
"771032", "Karazhal",
"77149", "Kostanai",
"7471", "Kursk",
"772632", "Merke",
"771536", "Taiynsha",
"7498", "Moscow",
"771138", "Zhalpaktal",
"7492", "Vladimir",
"771041", "Aktau\,\ Zhezkazgan",
"772341", "Ulken\ Naryn",
"771335", "Shalkar",
"733", "Baikonur",
"771644", "Arshaly",
"771458", "Kostanai\ Region",
"771446", "Uzunkolsky\ District",
"772435", "Zhanakorgan",
"771140", "Saikhin",
"771441", "Karabalyk",
"772841", "Kapal",
"772346", "Aksuat",
"772759", "Almaty\ Region",
"772149", "Osakarovka",
"7814", "Republic\ of\ Karelia",
"771235", "Dossor",
"772637", "Sarykemer",
"771531", "Bulayevo",
"772545", "Ikan",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;