use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('Hades::Macro::FH');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 9;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	ok( $obj = Hades::Macro::FH->new(), q{$obj = Hades::Macro::FH->new()} );
	isa_ok( $obj, 'Hades::Macro::FH' );
	ok( $obj = Hades::Macro::FH->new( {} ),
		q{$obj = Hades::Macro::FH->new({})}
	);
	ok( $obj = Hades::Macro::FH->new(), q{$obj = Hades::Macro::FH->new()} );
	is_deeply( $obj->macro,
		[qw/open_write open_read close_file read_file write_file/],
		q{$obj->macro} );
	ok( $obj = Hades::Macro::FH->new( { macro => ['test'] } ),
		q{$obj = Hades::Macro::FH->new({ macro => ['test'] })}
	);
	eval { $obj = Hades::Macro::FH->new( { macro => {} } ) };
	like(
		$@,
		qr/invalid|type|constraint|greater|atleast/,
		q{$obj = Hades::Macro::FH->new({ macro => {} })}
	);
	eval { $obj = Hades::Macro::FH->new( { macro => 'algea' } ) };
	like(
		$@,
		qr/invalid|type|constraint|greater|atleast/,
		q{$obj = Hades::Macro::FH->new({ macro => 'algea' })}
	);
};
subtest 'macro' => sub {
	plan tests => 6;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'macro' );
	is_deeply( $obj->macro( ['test'] ), ['test'], q{$obj->macro(['test'])} );
	eval { $obj->macro( {} ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->macro({})} );
	eval { $obj->macro('penthos') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->macro('penthos')} );
	is_deeply( $obj->macro, ['test'], q{$obj->macro} );
};
subtest 'open_write' => sub {
	plan tests => 10;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'open_write' );
	eval { $obj->open_write( [], 'limos', 'aporia', 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write([], 'limos', 'aporia', 'curae')}
	);
	eval { $obj->open_write( 'phobos', 'limos', 'aporia', 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write('phobos', 'limos', 'aporia', 'curae')}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), [], 'aporia', 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), [], 'aporia', 'curae')}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), \1, 'aporia', 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), \1, 'aporia', 'curae')}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), 'limos', [], 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), 'limos', [], 'curae')}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), 'limos', \1, 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), 'limos', \1, 'curae')}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), 'limos', 'aporia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), 'limos', 'aporia', [])}
	);
	eval { $obj->open_write( bless( {}, 'Test' ), 'limos', 'aporia', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_write(bless({}, 'Test'), 'limos', 'aporia', \1)}
	);
};
subtest 'open_read' => sub {
	plan tests => 10;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'open_read' );
	eval { $obj->open_read( [], 'geras', 'limos', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read([], 'geras', 'limos', 'limos')}
	);
	eval { $obj->open_read( 'thanatos', 'geras', 'limos', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read('thanatos', 'geras', 'limos', 'limos')}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), [], 'limos', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), [], 'limos', 'limos')}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), \1, 'limos', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), \1, 'limos', 'limos')}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), 'geras', [], 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), 'geras', [], 'limos')}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), 'geras', \1, 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), 'geras', \1, 'limos')}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), 'geras', 'limos', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), 'geras', 'limos', [])}
	);
	eval { $obj->open_read( bless( {}, 'Test' ), 'geras', 'limos', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->open_read(bless({}, 'Test'), 'geras', 'limos', \1)}
	);
};
subtest 'close_file' => sub {
	plan tests => 8;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'close_file' );
	eval { $obj->close_file( [], 'aporia', 'geras' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file([], 'aporia', 'geras')}
	);
	eval { $obj->close_file( 'penthos', 'aporia', 'geras' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file('penthos', 'aporia', 'geras')}
	);
	eval { $obj->close_file( bless( {}, 'Test' ), [], 'geras' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file(bless({}, 'Test'), [], 'geras')}
	);
	eval { $obj->close_file( bless( {}, 'Test' ), \1, 'geras' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file(bless({}, 'Test'), \1, 'geras')}
	);
	eval { $obj->close_file( bless( {}, 'Test' ), 'aporia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file(bless({}, 'Test'), 'aporia', [])}
	);
	eval { $obj->close_file( bless( {}, 'Test' ), 'aporia', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->close_file(bless({}, 'Test'), 'aporia', \1)}
	);
};
subtest 'read_file' => sub {
	plan tests => 10;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'read_file' );
	eval { $obj->read_file( [], 'penthos', 'nosoi', 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file([], 'penthos', 'nosoi', 'gaudia')}
	);
	eval { $obj->read_file( 'algea', 'penthos', 'nosoi', 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file('algea', 'penthos', 'nosoi', 'gaudia')}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), [], 'nosoi', 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), [], 'nosoi', 'gaudia')}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), \1, 'nosoi', 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), \1, 'nosoi', 'gaudia')}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), 'penthos', [], 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), 'penthos', [], 'gaudia')}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), 'penthos', \1, 'gaudia' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), 'penthos', \1, 'gaudia')}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), 'penthos', 'nosoi', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), 'penthos', 'nosoi', [])}
	);
	eval { $obj->read_file( bless( {}, 'Test' ), 'penthos', 'nosoi', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->read_file(bless({}, 'Test'), 'penthos', 'nosoi', \1)}
	);
};
subtest 'write_file' => sub {
	plan tests => 12;
	ok( my $obj = Hades::Macro::FH->new( {} ),
		q{my $obj = Hades::Macro::FH->new({})}
	);
	can_ok( $obj, 'write_file' );
	eval { $obj->write_file( [], 'gaudia', 'aporia', 'curae', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file([], 'gaudia', 'aporia', 'curae', 'nosoi')}
	);
	eval { $obj->write_file( 'limos', 'gaudia', 'aporia', 'curae', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file('limos', 'gaudia', 'aporia', 'curae', 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			[], 'aporia', 'curae', 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), [], 'aporia', 'curae', 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			\1, 'aporia', 'curae', 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), \1, 'aporia', 'curae', 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', [], 'curae', 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', [], 'curae', 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', \1, 'curae', 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', \1, 'curae', 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', 'aporia', [], 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', 'aporia', [], 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', 'aporia', \1, 'nosoi' );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', 'aporia', \1, 'nosoi')}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', 'aporia', 'curae', [] );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', 'aporia', 'curae', [])}
	);
	eval {
		$obj->write_file( bless( {}, 'Test' ),
			'gaudia', 'aporia', 'curae', \1 );
	};
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->write_file(bless({}, 'Test'), 'gaudia', 'aporia', 'curae', \1)}
	);
};
done_testing();
