# -*- Perl -*-
#
# slide rule support for Perl, specific to my Pickett Model N 3P-ES
# pocket slide rule, insofar as that is possible on a digital device and
# only to the extent that I have done here

package Math::SlideRule::PickettPocket;

use 5.010000;

use Moo;
use namespace::clean;
use Scalar::Util qw/looks_like_number/;

extends 'Math::SlideRule';

our $VERSION = '1.11';

########################################################################
#
# ATTRIBUTES

# built by the gena/genc scripts present in the distribution of
# this module
has A => (
    is      => 'ro',
    default => sub {
        {   dist => [
                0,                    "0.0246926125903714",
                "0.048790164169432",  "0.0723206615796261",
                "0.0953101798043249", "0.117783035656383",
                "0.139761942375159",  "0.161268147596122",
                "0.182321556793955",  "0.20294084399669",
                "0.22314355131421",   "0.242946178610389",
                "0.262364264467491",  "0.281412459438185",
                "0.300104592450338",  "0.318453731118535",
                "0.336472236621213",  "0.354171813720614",
                "0.371563556432483",  "0.388657989791783",
                "0.405465108108164",  "0.421994410059375",
                "0.438254930931155",  "0.454255272277596",
                "0.470003629245736",  "0.485507815781701",
                "0.500775287912489",  "0.51581316527703",
                "0.53062825106217",   "0.545227050483323",
                "0.559615787935423",  "0.573800422927379",
                "0.587786664902119",  "0.601579987034455",
                "0.615185639090233",  "0.628608659422374",
                "0.641853886172395",  "0.654925967739748",
                "0.667829372575656",  "0.680568398353085",
                "0.693147180559945",  "0.705569700558503",
                "0.717839793150317",  "0.729961153682662",
                "0.741937344729377",  "0.75377180237638",
                "0.765467842139572",  "0.777028664540647",
                "0.78845736036427",   "0.799756915618204",
                "0.810930216216329",  "0.821980052402914",
                "0.832909122935104",  "0.84372003903932",
                "0.854415328156068",  "0.864997437486605",
                "0.8754687373539",    "0.885831524389446",
                "0.896088024556636",  "0.906240396020654",
                "0.916290731874155",  "0.926241062727323",
                "0.936093359170335",  "0.945849534115699",
                "0.955511445027436",  "0.965080896043587",
                "0.974559639998131",  "0.98394938034797",
                "0.993251773010283",  "1.00246842811521",
                "1.01160091167848",   "1.0206507471984",
                "1.02961941718116",   "1.0385083645984",
                "1.04731899428056",   "1.05605267424931",
                "1.06471073699243",   "1.07329448068382",
                "1.08180517035173",   "1.09024403899759",
                "1.09861228866811",   "1.11514159061932",
                "1.1314021114911",    "1.1447298858494",
                "1.14740245283754",   "1.16315080980568",
                "1.17865499634165",   "1.19392246847243",
                "1.20896034583698",   "1.22377543162212",
                "1.23837423104327",   "1.25276296849537",
                "1.26694760348732",   "1.28093384546206",
                "1.2947271675944",    "1.30833281965018",
                "1.32175583998232",   "1.33500106673234",
                "1.34807314829969",   "1.3609765531356",
                "1.37371557891303",   "1.38629436111989",
                "1.39871688111845",   "1.41098697371026",
                "1.42310833424261",   "1.43508452528932",
                "1.44691898293633",   "1.45861502269952",
                "1.47017584510059",   "1.48160454092422",
                "1.49290409617815",   "1.50407739677627",
                "1.51512723296286",   "1.52605630349505",
                "1.53686721959926",   "1.54756250871601",
                "1.55814461804655",   "1.56861591791385",
                "1.57897870494939",   "1.58923520511658",
                "1.5993875765806",    "1.6094379124341",
                "1.61938824328727",   "1.62924053973028",
                "1.63899671467564",   "1.64865862558738",
                "1.65822807660353",   "1.66770682055808",
                "1.67709656090792",   "1.68639895357023",
                "1.69561560867515",   "1.70474809223843",
                "1.71379792775834",   "1.7227665977411",
                "1.73165554515835",   "1.7404661748405",
                "1.74919985480926",   "1.75785791755237",
                "1.76644166124377",   "1.77495235091167",
                "1.78339121955754",   "1.79175946922805",
                "1.80828877117927",   "1.82454929205105",
                "1.84054963339749",   "1.85629799036563",
                "1.87180217690159",   "1.88706964903238",
                "1.90210752639692",   "1.91692261218206",
                "1.93152141160321",   "1.94591014905531",
                "1.96009478404727",   "1.97408102602201",
                "1.98787434815435",   "2.00148000021012",
                "2.01490302054226",   "2.02814824729229",
                "2.04122032885964",   "2.05412373369555",
                "2.06686275947298",   "2.07944154167984",
                "2.09186406167839",   "2.10413415427021",
                "2.11625551480255",   "2.12823170584927",
                "2.14006616349627",   "2.15176220325946",
                "2.16332302566054",   "2.17475172148416",
                "2.18605127673809",   "2.19722457733622",
                "2.2082744135228",    "2.21920348405499",
                "2.23001440015921",   "2.24070968927596",
                "2.2512917986065",    "2.26176309847379",
                "2.27212588550934",   "2.28238238567653",
                "2.29253475714054",   "2.30258509299405",
                "2.30508197319263",   "2.30757263450508",
                "2.31005710783275",   "2.31253542384721",
                "2.3150076129926",    "2.3174737054878",
                "2.31993373132866",   "2.32238772029023",
                "2.32483570192887",   "2.32727770558442",
                "2.3297137603823",    "2.33214389523559",
                "2.3345681388471",    "2.33698651971138",
                "2.33939906611676",   "2.34180580614733",
                "2.34420676768487",   "2.34660197841082",
                "2.3489914658082",    "2.35137525716348",
                "2.35375337956845",   "2.35612585992208",
                "2.35849272493234",   "2.36085400111802",
                "2.36320971481048",   "2.36555989215543",
                "2.36790455911469",   "2.37024374146786",
                "2.37257746481408",   "2.37490575457367",
                "2.37722863598981",   "2.37954613413017",
                "2.38185827388855",   "2.38416507998647",
                "2.38646657697475",   "2.3887627892351",
                "2.39105374098165",   "2.39333945626251",
                "2.39561995896123",   "2.39789527279837",
                "2.40016542133291",   "2.40243042796376",
                "2.4046903159312",    "2.40694510831829",
                "2.4091948280523",    "2.41143949790613",
                "2.41367914049963",   "2.41591377830105",
                "2.41814343362832",   "2.42036812865043",
                "2.42258788538874",   "2.42480272571829",
                "2.4270126713691",    "2.42921774392741",
                "2.43141796483701",   "2.43361335540045",
                "2.43580393678027",   "2.43798973000025",
                "2.44017075594661",   "2.4423470353692",
                "2.44451858888271",   "2.4466854369678",
                "2.4488475999723",    "2.45100509811232",
                "2.45315795147342",   "2.45530618001171",
                "2.45744980355496",   "2.45958884180371",
                "2.46172331433234",   "2.46385324059017",
                "2.46597863990248",   "2.46809953147162",
                "2.470215934378",     "2.47232786758114",
                "2.47443534992071",   "2.47653840011748",
                "2.4786370367744",    "2.48073127837752",
                "2.48282114329698",   "2.484906649788",
                "2.48698781599182",   "2.48906465993666",
                "2.49113719953864",   "2.4932054526027",
                "2.49526943682355",   "2.49732916978656",
                "2.49938466896865",   "2.50143595173921",
                "2.50348303536094",   "2.50552593699074",
                "2.50756467368058",   "2.50959926237837",
                "2.51162971992875",   "2.51365606307399",
                "2.51567830845475",   "2.51769647261099",
                "2.51971057198269",   "2.52172062291072",
                "2.52372664163758",   "2.52572864430826",
                "2.52772664697093",   "2.52972066557779",
                "2.5317107159858",    "2.53369681395743",
                "2.53567897516142",   "2.53765721517353",
                "2.53963154947725",   "2.54160199346455",
                "2.54356856243659",   "2.54553127160443",
                "2.54749013608977",   "2.54944517092557",
                "2.55139639105683",   "2.55334381134123",
                "2.5552874465498",    "2.55722731136763",
                "2.55916342039449",   "2.56109578814555",
                "2.56302442905195",   "2.56494935746154",
                "2.56687058763943",   "2.5687881337687",
                "2.57070200995099",   "2.57261223020711",
                "2.57451880847769",   "2.57642175862377",
                "2.57832109442743",   "2.58021682959233",
                "2.58210897774436",   "2.58399755243223",
                "2.585882567128",     "2.58776403522771",
                "2.58964197005191",   "2.59151638484626",
                "2.59338729278207",   "2.59525470695687",
                "2.59711864039493",   "2.59897910604785",
                "2.60083611679506",   "2.60268968544438",
                "2.60453982473255",   "2.60638654732571",
                "2.60822986582",      "2.61006979274201",
                "2.61190634054931",   "2.61373952163097",
                "2.61556934830804",   "2.61739583283408",
                "2.61921898739559",   "2.62103882411258",
                "2.62285535503898",   "2.62466859216316",
                "2.6264785474084",    "2.62828523263335",
                "2.6300886596325",    "2.63188884013665",
                "2.63368578581335",   "2.63547950826737",
                "2.63727001904116",   "2.63905732961526",
                "2.64084145140876",   "2.64262239577975",
                "2.64440017402575",   "2.64617479738412",
                "2.6479462770325",    "2.64971462408925",
                "2.65147984961382",   "2.65324196460721",
                "2.65500098001239",   "2.65675690671466",
                "2.65850975554207",   "2.66025953726586",
                "2.6620062626008",    "2.66374994220563",
                "2.66549058668341",   "2.66722820658195",
                "2.66896281239416",   "2.67069441455844",
                "2.67242302345906",   "2.67414864942653",
                "2.67587130273798",   "2.6775909936175",
                "2.67930773223656",   "2.68102152871429",
                "2.68273239311792",   "2.68444033546308",
                "2.68614536571416",   "2.68784749378469",
                "2.68954672953765",   "2.69124308278583",
                "2.69293656329216",   "2.69462718077007",
                "2.69631494488379",   "2.69799986524871",
                "2.69968195143169",   "2.70136121295141",
                "2.70303765927867",   "2.7047112998367",
                "2.70638214400151",   "2.70805020110221",
                "2.70971548042127",   "2.71137799119488",
                "2.71303774261325",   "2.71469474382088",
                "2.71634900391691",   "2.71800053195538",
                "2.71964933694556",   "2.72129542785223",
                "2.72293881359596",   "2.72457950305342",
                "2.72621750505766",   "2.72785282839839",
                "2.72948548182227",   "2.73111547403321",
                "2.73274281369258",   "2.73436750941958",
                "2.73598956979145",   "2.73760900334375",
                "2.73922581857066",   "2.7408400239252",
                "2.74245162781954",   "2.74406063862524",
                "2.74566706467352",   "2.74727091425549",
                "2.74887219562247",   "2.75047091698616",
                "2.75206708651898",   "2.75366071235426",
                "2.7552518025865",    "2.75684036527164",
                "2.75842640842728",   "2.76000994003292",
                "2.76159096803024",   "2.76316950032329",
                "2.76474554477876",   "2.76631910922619",
                "2.76789020145823",   "2.76945882923085",
                "2.7710250002636",    "2.77258872223978",
                "2.77415000280673",   "2.77570884957602",
                "2.77726527012368",   "2.77881927199042",
                "2.78037086268184",   "2.78192004966867",
                "2.78346684038696",   "2.78501124223834",
                "2.78655326259015",   "2.78809290877575",
                "2.78963018809463",   "2.79116510781272",
                "2.79269767516249",   "2.79422789734326",
                "2.79575578152132",   "2.79728133483015",
                "2.79880456437067",   "2.80032547721138",
                "2.80184408038857",   "2.80336038090653",
                "2.80487438573775",   "2.80638610182307",
                "2.80789553607193",   "2.8094026953625",
                "2.81090758654192",   "2.81241021642645",
                "2.81391059180169",   "2.81540871942271",
                "2.81690460601429",   "2.81839825827108",
                "2.81988968285775",   "2.82137888640921",
                "2.82286587553079",   "2.82435065679837",
                "2.82583323675859",   "2.82731362192903",
                "2.82879181879834",   "2.83026783382646",
                "2.83174167344476",   "2.83321334405622",
                "2.83468285203558",   "2.83615020372953",
                "2.83761540545685",   "2.83907846350861",
                "2.84053938414829",   "2.84199817361195",
                "2.84345483810841",   "2.84490938381941",
                "2.84636181689972",   "2.84781214347737",
                "2.84926036965373",   "2.85070650150373",
                "2.85215054507597",   "2.85359250639287",
                "2.85503239145086",   "2.85647020622048",
                "2.85790595664659",   "2.85933964864844",
                "2.86077128811987",   "2.86220088092947",
                "2.86362843292065",   "2.86505394991188",
                "2.86647743769673",   "2.86789890204411",
                "2.86931834869833",   "2.87073578337931",
                "2.87215121178264",   "2.87356463957978",
                "2.87497607241819",   "2.87638551592142",
                "2.8777929756893",    "2.87919845729804",
                "2.88060196630036",   "2.88200350822565",
                "2.88340308858007",   "2.88480071284671",
                "2.88619638648568",   "2.88759011493429",
                "2.88898190360711",   "2.89037175789616",
                "2.89175968317101",   "2.89314568477889",
                "2.89452976804483",   "2.89591193827178",
                "2.89729220074074",   "2.89867056071086",
                "2.90004702341958",   "2.90142159408275",
                "2.90279427789472",   "2.9041650800285",
                "2.90553400563584",   "2.90690105984738",
                "2.90826624777272",   "2.90962957450058",
                "2.9109910450989",    "2.91235066461494",
                "2.9137084380754",    "2.91506437048654",
                "2.91641846683427",   "2.91777073208428",
                "2.91912117118215",   "2.92046978905344",
                "2.92181659060382",   "2.92316158071916",
                "2.92450476426562",   "2.92584614608982",
                "2.92718573101888",   "2.92852352386054",
                "2.92985952940328",   "2.93119375241642",
                "2.9325261976502",    "2.9338568698359",
                "2.93518577368596",   "2.93651291389402",
                "2.93783829513509",   "2.9391619220656",
                "2.94048379932351",   "2.94180393152844",
                "2.94312232328169",   "2.94443897916644",
                "2.94575390374775",   "2.94706710157271",
                "2.94837857717052",   "2.94968833505258",
                "2.9509963797126",    "2.95230271562665",
                "2.95360734725332",   "2.95491027903374",
                "2.95621151539171",   "2.95751106073379",
                "2.95880891944939",   "2.96010509591084",
                "2.96139959447349",   "2.96269241947579",
                "2.96398357523941",   "2.96527306606928",
                "2.96656089625371",   "2.96784707006446",
                "2.96913159175681",   "2.9704144655697",
                "2.97169569572575",   "2.97297528643137",
                "2.97425324187687",   "2.97552956623647",
                "2.97680426366847",   "2.97807733831527",
                "2.97934879430347",   "2.98061863574394",
                "2.98188686673194",   "2.98315349134713",
                "2.98441851365372",   "2.98568193770049",
                "2.98694376752091",   "2.9882040071332",
                "2.9894626605404",    "2.99071973173045",
                "2.99197522467628",   "2.99322914333587",
                "2.99448149165234",   "2.99573227355399",
                "2.99698149295442",   "2.99822915375258",
                "2.99947525983283",   "3.00071981506503",
                "3.00196282330463",   "3.00320428839269",
                "3.00444421415601",   "3.00568260440716",
                "3.00691946294456",   "3.00815479355255",
                "3.00938860000148",   "3.01062088604774",
                "3.01185165543387",   "3.0130809118886",
                "3.01430865912693",   "3.01553490085017",
                "3.01675964074607",   "3.01798288248881",
                "3.01920462973913",   "3.02042488614436",
                "3.02164365533849",   "3.02286094094224",
                "3.02407674656313",   "3.02529107579554",
                "3.02650393222074",   "3.02771531940704",
                "3.02892524090975",   "3.03013370027132",
                "3.03134070102136",   "3.03254624667671",
                "3.03375034074151",   "3.03495298670727",
                "3.03615418805291",   "3.03735394824481",
                "3.03855227073692",   "3.03974915897077",
                "3.04094461637554",   "3.04213864636815",
                "3.04333125235327",   "3.04452243772342",
                "3.04571220585901",   "3.04690056012839",
                "3.04808750388792",   "3.04927304048202",
                "3.05045717324324",   "3.05163990549229",
                "3.05282124053812",   "3.05400118167797",
                "3.05517973219741",   "3.05635689537043",
                "3.05753267445944",   "3.05870707271538",
                "3.05988009337774",   "3.06105173967463",
                "3.06222201482282",   "3.06339092202781",
                "3.06455846448384",   "3.06572464537403",
                "3.06688946787032",   "3.06805293513362",
                "3.06921505031379",   "3.07037581654976",
                "3.07153523696949",   "3.07269331469012",
                "3.07385005281794",   "3.0750054544485",
                "3.07615952266661",   "3.07731226054641",
                "3.07846367115146",   "3.07961375753469",
                "3.08076252273857",   "3.08190996979504",
                "3.08305610172567",   "3.0842009215416",
                "3.08534443224368",   "3.08648663682246",
                "3.08762753825825",   "3.08876713952118",
                "3.08990544357124",   "3.09104245335832",
                "3.09217817182224",   "3.09331260189286",
                "3.09444574649002",   "3.09557760852371",
                "3.09670819089399",   "3.09783749649114",
                "3.09896552819564",   "3.10009228887823",
                "3.10121778139997",   "3.10234200861225",
                "3.10346497335687",   "3.10458667846607",
                "3.10570712676256",   "3.10682632105958",
                "3.10794426416092",   "3.10906095886099",
                "3.11017640794486",   "3.11129061418826",
                "3.11240358035768",   "3.11351530921037",
                "3.1146258034944",    "3.11573506594869",
                "3.11684309930305",   "3.11794990627824",
                "3.11905548958599",   "3.12015985192904",
                "3.1212629960012",    "3.12236492448736",
                "3.12346564006354",   "3.12456514539696",
                "3.12566344314602",   "3.1267605359604",
                "3.12785642648103",   "3.12895111734021",
                "3.13004461116159",   "3.13113691056019",
                "3.13222801814253",   "3.13331793650655",
                "3.13440666824175",   "3.13549421592915",
                "3.13658058214137",   "3.13766576944266",
                "3.13874978038892",   "3.13983261752775",
                "3.14091428339849",   "3.14199478053224",
                "3.14307411145192",   "3.14415227867226",
                "3.1452292846999",    "3.14630513203337",
                "3.14737982316313",   "3.14845336057165",
                "3.14952574673341",   "3.15059698411491",
                "3.15166707517475",   "3.15273602236366",
                "3.15380382812449",   "3.15487049489229",
                "3.15593602509433",   "3.15700042115011",
                "3.15806368547144",   "3.15912582046243",
                "3.16018682851952",   "3.16124671203156",
                "3.16230547337981",   "3.16336311493794",
                "3.16441963907214",   "3.16547504814109",
                "3.16652934449599",   "3.16758253048065",
                "3.16863460843145",   "3.16968558067743",
                "3.17073544954027",   "3.17178421733435",
                "3.17283188636679",   "3.17387845893747",
                "3.17492393733902",   "3.17596832385692",
                "3.1770116207695",    "3.17805383034795",
                "3.17909495485636",   "3.18013499655177",
                "3.18117395768419",   "3.18221184049661",
                "3.18324864722505",   "3.18428438009858",
                "3.18531904133936",   "3.18635263316264",
                "3.18738515777683",   "3.18841661738349",
                "3.18944701417739",   "3.1904763503465",
                "3.19150462807207",   "3.1925318495286",
                "3.19355801688391",   "3.19458313229916",
                "3.19560719792885",   "3.19663021592088",
                "3.19765218841657",   "3.19867311755068",
                "3.19969300545143",   "3.20071185424053",
                "3.20172966603323",   "3.20274644293832",
                "3.20376218705815",   "3.2047769004887",
                "3.20579058531955",   "3.20680324363393",
                "3.20781487750878",   "3.2088254890147",
                "3.20983508021605",   "3.21084365317094",
                "3.21185120993124",   "3.21285775254264",
                "3.21386328304466",   "3.21486780347066",
                "3.2158713158479",    "3.21687382219753",
                "3.21787532453462",   "3.2188758248682",
                "3.21987532520128",   "3.22087382753087",
                "3.221871333848",     "3.22286784613774",
                "3.22386336637924",   "3.22485789654575",
                "3.22585143860463",   "3.22684399451738",
                "3.22783556623967",   "3.22882615572137",
                "3.22981576490653",   "3.23080439573347",
                "3.23179205013475",   "3.23277873003719",
                "3.23376443736195",   "3.23474917402449",
                "3.23573294193462",   "3.23671574299653",
                "3.23769757910879",   "3.23867845216438",
                "3.23965836405073",   "3.24063731664971",
                "3.24161531183769",   "3.24259235148552",
                "3.24356843745857",   "3.24454357161678",
                "3.24551775581462",   "3.24649099190117",
                "3.24746328172011",   "3.24843462710975",
                "3.24940502990302",   "3.25037449192757",
                "3.2513430150057",    "3.25231060095444",
                "3.25327725158553",   "3.25424296870549",
                "3.25520775411559",   "3.2561716096119",
                "3.25713453698529",   "3.25809653802148",
                "3.25905761450103",   "3.26001776819938",
                "3.26097700088684",   "3.26193531432865",
                "3.26289271028498",   "3.26384919051093",
                "3.2648047567566",    "3.26575941076705",
                "3.26671315428236",   "3.26766598903763",
                "3.26861791676301",   "3.26956893918372",
                "3.27051905802004",   "3.27146827498737",
                "3.27241659179623",   "3.27336401015227",
                "3.2743105317563",    "3.27525615830431",
                "3.27620089148747",   "3.27714473299218",
                "3.27808768450005",   "3.27902974768795",
                "3.27997092422801",   "3.28091121578765",
                "3.28185062402959",   "3.28278915061185",
                "3.28372679718782",   "3.2846635654062",
                "3.28559945691111",   "3.28653447334202",
                "3.28746861633381",   "3.28840188751681",
                "3.28933428851676",   "3.29026582095487",
                "3.29119648644783",   "3.29212628660779",
                "3.29305522304245",   "3.29398329735501",
                "3.2949105111442",    "3.29583686600433",
                "3.29676236352527",   "3.29768700529249",
                "3.29861079288705",   "3.29953372788566",
                "3.30045581186062",   "3.30137704637994",
                "3.30229743300727",   "3.30321697330195",
                "3.30413566881902",   "3.30505352110925",
                "3.30597053171913",   "3.30688670219091",
                "3.3078020340626",    "3.30871652886799",
                "3.30963018813666",   "3.31054301339402",
                "3.31145500616129",   "3.31236616795554",
                "3.31327650028968",   "3.31418600467253",
                "3.31509468260874",   "3.31600253559892",
                "3.31690956513957",   "3.3178157727231",
                "3.31872115983792",   "3.31962572796834",
                "3.3205294785947",    "3.32143241319329",
                "3.32233453323643",   "3.32323584019244",
                "3.32413633552569",   "3.32503602069659",
                "3.32593489716161",   "3.32683296637329",
                "3.32773022978028",   "3.32862668882732",
                "3.32952234495526",   "3.33041719960111",
                "3.33131125419799",   "3.3322045101752",
                "3.33309696895822",   "3.33398863196871",
                "3.33487950062451",   "3.3357695763397",
                "3.33665886052458",   "3.3375473545857",
                "3.33843505992584",   "3.33932197794407",
                "3.34020811003573",   "3.34109345759245",
                "3.34197802200218",   "3.34286180464919",
                "3.34374480691407",   "3.34462703017376",
                "3.34550847580157",   "3.34638914516716",
                "3.3472690396366",    "3.34814816057234",
                "3.34902650933325",   "3.3499040872746",
                "3.35078089574814",   "3.35165693610202",
                "3.35253220968087",   "3.35340671782581",
                "3.3542804618744",    "3.35515344316075",
                "3.35602566301543",   "3.35689712276558",
                "3.35776782373482",   "3.35863776724336",
                "3.35950695460795",   "3.3603753871419",
                "3.36124306615512",   "3.36210999295411",
                "3.36297616884196",   "3.36384159511839",
                "3.36470627307974",   "3.365570204019",
                "3.36643338922582",   "3.36729582998647",
                "3.36815752758396",   "3.36901848329792",
                "3.36987869840473",   "3.37073817417745",
                "3.37159691188586",   "3.3724549127965",
                "3.37331217817262",   "3.37416870927424",
                "3.37502450735813",   "3.37587957367787",
                "3.37673390948378",   "3.37758751602302",
                "3.37844039453954",   "3.37929254627411",
                "3.38014397246432",   "3.38099467434464",
                "3.38184465314634",   "3.3826939100976",
                "3.38354244642343",   "3.38439026334577",
                "3.38523736208343",   "3.38608374385211",
                "3.38692940986445",   "3.38777436133001",
                "3.3886185994553",    "3.38946212544373",
                "3.39030494049573",   "3.39114704580865",
                "3.39198844257685",   "3.39282913199164",
                "3.39366911524136",   "3.39450839351136",
                "3.39534696798398",   "3.39618483983861",
                "3.39702201025167",   "3.39785848039664",
                "3.39869425144404",   "3.39952932456146",
                "3.40036370091358",   "3.40119738166216",
                "3.40286266098122",   "3.40452517175483",
                "3.40618492317319",   "3.40784192438082",
                "3.40949618447685",   "3.41114771251532",
                "3.41279651750551",   "3.41444260841218",
                "3.41608599415591",   "3.41772668361337",
                "3.4193646856176",    "3.42100000895834",
                "3.42263266238222",   "3.42426265459315",
                "3.42588999425253",   "3.42751468997953",
                "3.4291367503514",    "3.4307561839037",
                "3.4323729991306",    "3.43398720448515",
                "3.43559880837949",   "3.43720781918519",
                "3.43881424523346",   "3.44041809481544",
                "3.44201937618241",   "3.44361809754611",
                "3.44521426707893",   "3.44680789291421",
                "3.44839898314645",   "3.44998754583159",
                "3.45157358898722",   "3.45315712059287",
                "3.45473814859019",   "3.45631668088323",
                "3.4578927253387",    "3.45946628978613",
                "3.46103738201817",   "3.4626060097908",
                "3.46417218082354",   "3.46573590279973",
                "3.46729718336668",   "3.46885603013597",
                "3.47041245068363",   "3.47196645255036",
                "3.47351804324178",   "3.47506723022861",
                "3.47661402094691",   "3.47815842279828",
                "3.4797004431501",    "3.48124008933569",
                "3.48277736865458",   "3.48431228837266",
                "3.48584485572244",   "3.48737507790321",
                "3.48890296208126",   "3.4904285153901",
                "3.49195174493062",   "3.49347265777133",
                "3.49499126094852",   "3.49650756146648",
                "3.4980215662977",    "3.49953328238302",
                "3.50104271663187",   "3.50254987592244",
                "3.50405476710186",   "3.5055573969864",
                "3.50705777236163",   "3.50855589998265",
                "3.51005178657424",   "3.51154543883102",
                "3.51303686341769",   "3.51452606696916",
                "3.51601305609074",   "3.51749783735832",
                "3.51898041731854",   "3.52046080248897",
                "3.52193899935828",   "3.5234150143864",
                "3.52488885400471",   "3.52636052461616",
                "3.52783003259552",   "3.52929738428947",
                "3.5307625860168",    "3.53222564406856",
                "3.53368656470823",   "3.53514535417189",
                "3.53660201866836",   "3.53805656437935",
                "3.53950899745967",   "3.54095932403731",
                "3.54240755021368",   "3.54385368206368",
                "3.54529772563591",   "3.54673968695281",
                "3.5481795720108",    "3.54961738678043",
                "3.55105313720653",   "3.55248682920838",
                "3.55391846867982",   "3.55534806148941",
                "3.5567756134806",    "3.55820113047182",
                "3.55962461825667",   "3.56104608260405",
                "3.56246552925828",   "3.56388296393925",
                "3.56529839234258",   "3.56671182013973",
                "3.56812325297814",   "3.56953269648137",
                "3.57094015624925",   "3.57234563785798",
                "3.57374914686031",   "3.57515068878559",
                "3.57655026914002",   "3.57794789340665",
                "3.57934356704563",   "3.58073729549423",
                "3.58212908416706",   "3.58351893845611",
                "3.58490686373096",   "3.58629286533884",
                "3.58767694860477",   "3.58905911883173",
                "3.59043938130068",   "3.5918177412708",
                "3.59319420397953",   "3.5945687746427",
                "3.59594145845467",   "3.59731226058845",
                "3.59868118619579",   "3.60004824040732",
                "3.60141342833266",   "3.60277675506052",
                "3.60413822565885",   "3.60549784517489",
                "3.60685561863535",   "3.60821155104648",
                "3.60956564739421",   "3.61091791264422",
                "3.6122683517421",    "3.61361696961339",
                "3.61496377116377",   "3.6163087612791",
                "3.61765194482557",   "3.61899332664977",
                "3.62033291157883",   "3.62167070442049",
                "3.62300670996323",   "3.62434093297637",
                "3.62567337821014",   "3.62700405039585",
                "3.6283329542459",    "3.62966009445396",
                "3.63098547569503",   "3.63230910262554",
                "3.63363097988346",   "3.63495111208838",
                "3.63626950384164",   "3.63758615972639",
                "3.63890108430769",   "3.64021428213266",
                "3.64152575773047",   "3.64283551561253",
                "3.64414356027254",   "3.6454498961866",
                "3.64675452781327",   "3.64805745959368",
                "3.64935869595165",   "3.65065824129374",
                "3.65195610000934",   "3.65325227647079",
                "3.65454677503343",   "3.65583960003574",
                "3.65713075579936",   "3.65842024662923",
                "3.65970807681366",   "3.6609942506244",
                "3.66227877231676",   "3.66356164612965",
                "3.66484287628569",   "3.66612246699132",
                "3.66740042243681",   "3.66867674679642",
                "3.66995144422842",   "3.67122451887522",
                "3.67249597486341",   "3.67376581630389",
                "3.67503404729188",   "3.67630067190708",
                "3.67756569421366",   "3.67882911826043",
                "3.68009094808086",   "3.68135118769314",
                "3.68260984110034",   "3.68386691229039",
                "3.68512240523622",   "3.68637632389582",
                "3.68762867221228",   "3.68887945411394",
                "3.69012867351437",   "3.69137633431252",
                "3.69262244039277",   "3.69386699562498",
                "3.69511000386457",   "3.69635146895264",
                "3.69759139471596",   "3.6988297849671",
                "3.7000666435045",    "3.70130197411249",
                "3.70253578056142",   "3.70376806660769",
                "3.70499883599382",   "3.70622809244855",
                "3.70745583968687",   "3.70868208141012",
                "3.70990682130601",   "3.71113006304876",
                "3.71235181029908",   "3.71357206670431",
                "3.71479083589844",   "3.71600812150219",
                "3.71722392712308",   "3.71843825635548",
                "3.71965111278069",   "3.72086249996699",
                "3.7220724214697",    "3.72328088083127",
                "3.7244878815813",    "3.72569342723665",
                "3.72689752130146",   "3.72810016726722",
                "3.72930136861285",   "3.73050112880476",
                "3.73169945129686",   "3.73289633953071",
                "3.73409179693548",   "3.73528582692809",
                "3.73647843291322",   "3.73766961828337",
                "3.73885938641896",   "3.74004774068834",
                "3.74123468444786",   "3.74242022104197",
                "3.74360435380318",   "3.74478708605223",
                "3.74596842109806",   "3.74714836223791",
                "3.74832691275736",   "3.74950407593037",
                "3.75067985501938",   "3.75185425327532",
                "3.75302727393769",   "3.75419892023458",
                "3.75536919538277",   "3.75653810258775",
                "3.75770564504379",   "3.75887182593397",
                "3.76003664843026",   "3.76120011569356",
                "3.76236223087374",   "3.7635229971097",
                "3.76468241752944",   "3.76584049525006",
                "3.76699723337789",   "3.76815263500844",
                "3.76930670322655",   "3.77045944110636",
                "3.7716108517114",    "3.77276093809464",
                "3.77390970329851",   "3.77505715035499",
                "3.77620328228561",   "3.77734810210154",
                "3.77849161280362",   "3.7796338173824",
                "3.78077471881819",   "3.78191432008113",
                "3.78305262413119",   "3.78418963391826",
                "3.78532535238219",   "3.7864597824528",
                "3.78759292704997",   "3.78872478908365",
                "3.78985537145394",   "3.79098467705109",
                "3.79211270875559",   "3.79323946943818",
                "3.79436496195991",   "3.79548918917219",
                "3.79661215391682",   "3.79773385902602",
                "3.79885430732251",   "3.79997350161952",
                "3.80109144472086",   "3.80220813942094",
                "3.80332358850481",   "3.80443779474821",
                "3.80555076091763",   "3.80666248977032",
                "3.80777298405435",   "3.80888224650863",
                "3.80999027986299",   "3.81109708683819",
                "3.81220267014594",   "3.81330703248899",
                "3.81441017656115",   "3.8155121050473",
                "3.81661282062349",   "3.8177123259569",
                "3.81881062370597",   "3.81990771652034",
                "3.82100360704098",   "3.82209829790016",
                "3.82319179172153",   "3.82428409112014",
                "3.82537519870247",   "3.8264651170665",
                "3.8275538488017",    "3.8286413964891",
                "3.82972776270132",   "3.8308129500026",
                "3.83189696094886",   "3.83297979808769",
                "3.83406146395843",   "3.83514196109219",
                "3.83622129201186",   "3.83729945923221",
                "3.83837646525985",   "3.83945231259331",
                "3.84052700372308",   "3.8416005411316",
                "3.84267292729335",   "3.84374416467485",
                "3.8448142557347",    "3.8458832029236",
                "3.84695100868443",   "3.84801767545223",
                "3.84908320565427",   "3.85014760171006",
                "3.85121086603139",   "3.85227300102237",
                "3.85333400907947",   "3.85439389259151",
                "3.85545265393975",   "3.85651029549789",
                "3.85756681963209",   "3.85862222870103",
                "3.85967652505594",   "3.8607297110406",
                "3.8617817889914",    "3.86283276123737",
                "3.86388263010021",   "3.8649313978943",
                "3.86597906692674",   "3.86702563949741",
                "3.86807111789896",   "3.86911550441687",
                "3.87015880132945",   "3.87120101090789",
                "3.8722421354163",    "3.87328217711172",
                "3.87432113824413",   "3.87535902105655",
                "3.87639582778499",   "3.87743156065853",
                "3.8784662218993",    "3.87949981372259",
                "3.88053233833678",   "3.88156379794344",
                "3.88259419473733",   "3.88362353090645",
                "3.88465180863201",   "3.88567903008854",
                "3.88670519744386",   "3.8877303128591",
                "3.88875437848879",   "3.88977739648083",
                "3.89079936897652",   "3.89182029811063",
                "3.89284018601137",   "3.89385903480047",
                "3.89487684659318",   "3.89589362349826",
                "3.8969093676181",    "3.89792408104864",
                "3.89893776587949",   "3.89995042419388",
                "3.90096205806872",   "3.90197266957464",
                "3.902982260776",     "3.90399083373088",
                "3.90499839049118",   "3.90600493310258",
                "3.9070104636046",    "3.90801498403061",
                "3.90901849640785",   "3.91002100275747",
                "3.91102250509456",   "3.91202300542815",
                "3.91302250576123",   "3.91402100809082",
                "3.91501851440794",   "3.91601502669768",
                "3.91701054693918",   "3.91800507710569",
                "3.91899861916457",   "3.91999117507732",
                "3.92098274679962",   "3.92197333628131",
                "3.92296294546648",   "3.92395157629342",
                "3.92493923069469",   "3.92592591059714",
                "3.9269116179219",    "3.92789635458444",
                "3.92888012249457",   "3.92986292355648",
                "3.93084475966873",   "3.93182563272433",
                "3.93280554461067",   "3.93378449720966",
                "3.93476249239764",   "3.93573953204546",
                "3.93671561801852",   "3.93769075217672",
                "3.93866493637457",   "3.93963817246112",
                "3.94061046228006",   "3.94158180766969",
                "3.94255221046297",   "3.94352167248752",
                "3.94449019556565",   "3.94545778151438",
                "3.94642443214548",   "3.94739014926544",
                "3.94835493467554",   "3.94931879017184",
                "3.95028171754524",   "3.95124371858143",
                "3.95220479506098",   "3.95316494875932",
                "3.95412418144678",   "3.95508249488859",
                "3.95603989084492",   "3.95699637107088",
                "3.95795193731655",   "3.958906591327",
                "3.95986033484231",   "3.96081316959758",
                "3.96176509732296",   "3.96271611974366",
                "3.96366623857998",   "3.96461545554732",
                "3.96556377235618",   "3.96651119071222",
                "3.96745771231625",   "3.96840333886425",
                "3.96934807204742",   "3.97029191355212",
                "3.97123486505999",   "3.97217692824789",
                "3.97311810478796",   "3.9740583963476",
                "3.97499780458953",   "3.9759363311718",
                "3.97687397774776",   "3.97781074596615",
                "3.97874663747105",   "3.97968165390196",
                "3.98061579689376",   "3.98154906807676",
                "3.98248146907671",   "3.98341300151482",
                "3.98434366700777",   "3.98527346716774",
                "3.9862024036024",    "3.98713047791495",
                "3.98805769170414",   "3.98898404656427",
                "3.98990954408522",   "3.99083418585244",
                "3.991757973447",     "3.9926809084456",
                "3.99360299242057",   "3.99452422693989",
                "3.99544461356722",   "3.9963641538619",
                "3.99728284937897",   "3.9982007016692",
                "3.99911771227908",   "4.00003388275086",
                "4.00094921462255",   "4.00186370942794",
                "4.00277736869661",   "4.00369019395397",
                "4.00460218672124",   "4.00551334851549",
                "4.00642368084963",   "4.00733318523247",
                "4.00824186316869",   "4.00914971615887",
                "4.01005674569951",   "4.01096295328305",
                "4.01186834039786",   "4.01277290852829",
                "4.01367665915465",   "4.01457959375324",
                "4.01548171379638",   "4.01638302075239",
                "4.01728351608564",   "4.01818320125654",
                "4.01908207772155",   "4.01998014693324",
                "4.02087741034023",   "4.02177386938726",
                "4.02266952551521",   "4.02356438016105",
                "4.02445843475793",   "4.02535169073515",
                "4.02624414951817",   "4.02713581252865",
                "4.02802668118445",   "4.02891675689965",
                "4.02980604108453",   "4.03069453514564",
                "4.03158224048579",   "4.03246915850401",
                "4.03335529059567",   "4.0342406381524",
                "4.03512520256213",   "4.03600898520914",
                "4.03689198747402",   "4.03777421073371",
                "4.03865565636151",   "4.03953632572711",
                "4.04041622019655",   "4.04129534113228",
                "4.04217368989319",   "4.04305126783455",
                "4.04392807630808",   "4.04480411666196",
                "4.04567939024082",   "4.04655389838575",
                "4.04742764243435",   "4.04830062372069",
                "4.04917284357538",   "4.05004430332552",
                "4.05091500429476",   "4.0517849478033",
                "4.05265413516789",   "4.05352256770185",
                "4.05439024671507",   "4.05525717351405",
                "4.0561233494019",    "4.05698877567833",
                "4.05785345363969",   "4.05871738457895",
                "4.05958056978576",   "4.06044301054642",
                "4.0613047081439",    "4.06216566385787",
                "4.06302587896467",   "4.06388535473739",
                "4.06474409244581",   "4.06560209335645",
                "4.06645935873256",   "4.06731588983418",
                "4.06817168791808",   "4.06902675423781",
                "4.06988109004373",   "4.07073469658297",
                "4.07158757509948",   "4.07243972683405",
                "4.07329115302427",   "4.07414185490458",
                "4.07499183370629",   "4.07584109065754",
                "4.07668962698338",   "4.07753744390572",
                "4.07838454264337",   "4.07923092441205",
                "4.0800765904244",    "4.08092154188996",
                "4.08176578001524",   "4.08260930600368",
                "4.08345212105568",   "4.0842942263686",
                "4.08513562313679",   "4.08597631255158",
                "4.08681629580131",   "4.0876555740713",
                "4.08849414854393",   "4.08933202039856",
                "4.09016919081162",   "4.09100566095659",
                "4.09184143200398",   "4.0926765051214",
                "4.09351088147352",   "4.0943445622221",
                "4.09600984154116",   "4.09767235231478",
                "4.09933210373314",   "4.10098910494077",
                "4.1026433650368",    "4.10429489307527",
                "4.10594369806545",   "4.10758978897212",
                "4.10923317471585",   "4.11087386417331",
                "4.11251186617755",   "4.11414718951828",
                "4.11577984294217",   "4.1174098351531",
                "4.11903717481247",   "4.12066187053947",
                "4.12228393091134",   "4.12390336446365",
                "4.12552017969055",   "4.12713438504509",
                "4.12874598893943",   "4.13035499974513",
                "4.13196142579341",   "4.13356527537538",
                "4.13516655674236",   "4.13676527810605",
                "4.13836144763888",   "4.13995507347415",
                "4.1415461637064",    "4.14313472639153",
                "4.14472076954717",   "4.14630430115281",
                "4.14788532915013",   "4.14946386144318",
                "4.15103990589865",   "4.15261347034608",
                "4.15418456257812",   "4.15575319035074",
                "4.15731936138349",   "4.15888308335967",
                "4.16044436392662",   "4.16200321069592",
                "4.16355963124357",   "4.16511363311031",
                "4.16666522380173",   "4.16821441078856",
                "4.16976120150686",   "4.17130560335823",
                "4.17284762371004",   "4.17438726989564",
                "4.17592454921452",   "4.17745946893261",
                "4.17899203628239",   "4.18052225846315",
                "4.18205014264121",   "4.18357569595004",
                "4.18509892549057",   "4.18661983833127",
                "4.18813844150846",   "4.18965474202643",
                "4.19116874685764",   "4.19268046294296",
                "4.19418989719182",   "4.19569705648239",
                "4.19720194766181",   "4.19870457754634",
                "4.20020495292158",   "4.2017030805426",
                "4.20319896713418",   "4.20469261939097",
                "4.20618404397764",   "4.2076732475291",
                "4.20916023665068",   "4.21064501791826",
                "4.21212759787848",   "4.21360798304892",
                "4.21508617991823",   "4.21656219494635",
                "4.21803603456465",   "4.21950770517611",
                "4.22097721315547",   "4.22244456484942",
                "4.22390976657674",   "4.22537282462851",
                "4.22683374526818",   "4.22829253473184",
                "4.2297491992283",    "4.2312037449393",
                "4.23265617801961",   "4.23410650459726",
                "4.23555473077362",   "4.23700086262362",
                "4.23844490619586",   "4.23988686751276",
                "4.24132675257075",   "4.24276456734037",
                "4.24420031776648",   "4.24563400976833",
                "4.24706564923976",   "4.24849524204936",
                "4.24992279404054",   "4.25134831103177",
                "4.25277179881662",   "4.254193263164",
                "4.25561270981822",   "4.2570301444992",
                "4.25844557290253",   "4.25985900069967",
                "4.26127043353808",   "4.26267987704132",
                "4.26408733680919",   "4.26549281841793",
                "4.26689632742025",   "4.26829786934554",
                "4.26969744969996",   "4.2710950739666",
                "4.27249074760558",   "4.27388447605418",
                "4.275276264727",     "4.27666611901606",
                "4.2780540442909",    "4.27944004589878",
                "4.28082412916472",   "4.28220629939167",
                "4.28358656186063",   "4.28496492183075",
                "4.28634138453947",   "4.28771595520264",
                "4.28908863901461",   "4.29045944114839",
                "4.29182836675573",   "4.29319542096727",
                "4.29456060889261",   "4.29592393562047",
                "4.29728540621879",   "4.29864502573483",
                "4.30000279919529",   "4.30135873160643",
                "4.30271282795416",   "4.30406509320417",
                "4.30541553230204",   "4.30676415017333",
                "4.30811095172371",   "4.30945594183905",
                "4.31079912538551",   "4.31214050720972",
                "4.31348009213877",   "4.31481788498043",
                "4.31615389052317",   "4.31748811353631",
                "4.31882055877009",   "4.32015123095579",
                "4.32148013480585",   "4.32280727501391",
                "4.32413265625498",   "4.32545628318549",
                "4.3267781604434",    "4.32809829264833",
                "4.32941668440158",   "4.33073334028633",
                "4.33204826486764",   "4.3333614626926",
                "4.33467293829041",   "4.33598269617247",
                "4.33729074083249",   "4.33859707674655",
                "4.33990170837321",   "4.34120464015363",
                "4.3425058765116",    "4.34380542185368",
                "4.34510328056928",   "4.34639945703073",
                "4.34769395559338",   "4.34898678059568",
                "4.3502779363593",    "4.35156742718917",
                "4.3528552573736",    "4.35414143118435",
                "4.3554259528767",    "4.35670882668959",
                "4.35799005684564",   "4.35926964755127",
                "4.36054760299676",   "4.36182392735636",
                "4.36309862478836",   "4.36437169943516",
                "4.36564315542336",   "4.36691299686383",
                "4.36818122785183",   "4.36944785246702",
                "4.37071287477361",   "4.37197629882038",
                "4.3732381286408",    "4.37449836825309",
                "4.37575702166029",   "4.37701409285034",
                "4.37826958579617",   "4.37952350445576",
                "4.38077585277223",   "4.38202663467388",
                "4.38327585407431",   "4.38452351487247",
                "4.38576962095272",   "4.38701417618492",
                "4.38825718442452",   "4.38949864951258",
                "4.3907385752759",    "4.39197696552705",
                "4.39321382406445",   "4.39444915467244",
                "4.39568296112137",   "4.39691524716763",
                "4.39814601655377",   "4.39937527300849",
                "4.40060302024682",   "4.40182926197006",
                "4.40305400186596",   "4.4042772436087",
                "4.40549899085902",   "4.40671924726425",
                "4.40793801645838",   "4.40915530206213",
                "4.41037110768302",   "4.41158543691543",
                "4.41279829334063",   "4.41400968052693",
                "4.41521960202965",   "4.41642806139121",
                "4.41763506214125",   "4.4188406077966",
                "4.4200447018614",    "4.42124734782716",
                "4.4224485491728",    "4.4236483093647",
                "4.42484663185681",   "4.42604352009066",
                "4.42723897749543",   "4.42843300748804",
                "4.42962561347316",   "4.43081679884331",
                "4.4320065669789",    "4.43319492124828",
                "4.43438186500781",   "4.43556740160191",
                "4.43675153436313",   "4.43793426661218",
                "4.43911560165801",   "4.44029554279786",
                "4.4414740933173",    "4.44265125649032",
                "4.44382703557933",   "4.44500143383527",
                "4.44617445449763",   "4.44734610079452",
                "4.44851637594271",   "4.4496852831477",
                "4.45085282560373",   "4.45201900649392",
                "4.45318382899021",   "4.45434729625351",
                "4.45550941143368",   "4.45667017766965",
                "4.45782959808938",   "4.45898767581001",
                "4.46014441393783",   "4.46129981556839",
                "4.4624538837865",    "4.4636066216663",
                "4.46475803227135",   "4.46590811865458",
                "4.46705688385846",   "4.46820433091493",
                "4.46935046284556",   "4.47049528266149",
                "4.47163879336357",   "4.47278099794235",
                "4.47392189937814",   "4.47506150064107",
                "4.47619980469113",   "4.47733681447821",
                "4.47847253294213",   "4.47960696301275",
                "4.48074010760991",   "4.4818719696436",
                "4.48300255201388",   "4.48413185761104",
                "4.48525988931553",   "4.48638664999812",
                "4.48751214251986",   "4.48863636973214",
                "4.48975933447676",   "4.49088103958596",
                "4.49200148788245",   "4.49312068217947",
                "4.49423862528081",   "4.49535531998088",
                "4.49647076906475",   "4.49758497530815",
                "4.49869794147757",   "4.49980967033027",
                "4.50092016461429",   "4.50202942706858",
                "4.50313746042294",   "4.50424426739813",
                "4.50534985070588",   "4.50645421304893",
                "4.50755735712109",   "4.50865928560725",
                "4.50976000118343",   "4.51085950651685",
                "4.51195780426591",   "4.51305489708029",
                "4.51415078760092",   "4.5152454784601",
                "4.51633897228148",   "4.51743127168008",
                "4.51852237926242",   "4.51961229762644",
                "4.52070102936164",   "4.52178857704904",
                "4.52287494326126",   "4.52396013056255",
                "4.52504414150881",   "4.52612697864764",
                "4.52720864451838",   "4.52828914165213",
                "4.52936847257181",   "4.53044663979215",
                "4.53152364581979",   "4.53259949315326",
                "4.53367418428302",   "4.53474772169155",
                "4.5358201078533",    "4.5368913452348",
                "4.53796143629464",   "4.53903038348355",
                "4.54009818924438",   "4.54116485601218",
                "4.54223038621422",   "4.54329478227",
                "4.54435804659133",   "4.54542018158232",
                "4.54648118963941",   "4.54754107315146",
                "4.5485998344997",    "4.54965747605783",
                "4.55071400019203",   "4.55176940926098",
                "4.55282370561588",   "4.55387689160054",
                "4.55492896955134",   "4.55597994179732",
                "4.55702981066016",   "4.55807857845424",
                "4.55912624748668",   "4.56017282005736",
                "4.56121829845891",   "4.56226268497682",
                "4.56330598188939",   "4.56434819146784",
                "4.56538931597625",   "4.56642935767166",
                "4.56746831880408",   "4.5685062016165",
                "4.56954300834494",   "4.57057874121847",
                "4.57161340245925",   "4.57264699428253",
                "4.57367951889672",   "4.57471097850338",
                "4.57574137529728",   "4.57677071146639",
                "4.57779898919196",   "4.57882621064849",
                "4.5798523780038",    "4.58087749341905",
                "4.58190155904874",   "4.58292457704077",
                "4.58394654953646",   "4.58496747867057",
                "4.58598736657132",   "4.58700621536042",
                "4.58802402715312",   "4.58904080405821",
                "4.59005654817804",   "4.59107126160859",
                "4.59208494643944",   "4.59309760475382",
                "4.59410923862867",   "4.59511985013459",
                "4.59612944133594",   "4.59713801429083",
                "4.59814557105113",   "4.59915211366253",
                "4.60015764416455",   "4.60116216459055",
                "4.60216567696779",   "4.60316818331742",
                "4.60416968565451",   "4.60517018598809",
            ],
            value => [
                "1.0",    "1.025", "1.05",   "1.075", "1.1",    "1.125",
                "1.15",   "1.175", "1.2",    "1.225", "1.25",   "1.275",
                "1.3",    "1.325", "1.35",   "1.375", "1.4",    "1.425",
                "1.45",   "1.475", "1.5",    "1.525", "1.55",   "1.575",
                "1.6",    "1.625", "1.65",   "1.675", "1.7",    "1.725",
                "1.75",   "1.775", "1.8",    "1.825", "1.85",   "1.875",
                "1.9",    "1.925", "1.95",   "1.975", "2.0",    "2.025",
                "2.05",   "2.075", "2.1",    "2.125", "2.15",   "2.175",
                "2.2",    "2.225", "2.25",   "2.275", "2.3",    "2.325",
                "2.35",   "2.375", "2.4",    "2.425", "2.45",   "2.475",
                "2.5",    "2.525", "2.55",   "2.575", "2.6",    "2.625",
                "2.65",   "2.675", "2.7",    "2.725", "2.75",   "2.775",
                "2.8",    "2.825", "2.85",   "2.875", "2.9",    "2.925",
                "2.95",   "2.975", "3.0",    "3.05",  "3.1",    "3.141593",
                "3.15",   "3.2",   "3.25",   "3.3",   "3.35",   "3.4",
                "3.45",   "3.5",   "3.55",   "3.6",   "3.65",   "3.7",
                "3.75",   "3.8",   "3.85",   "3.9",   "3.95",   "4.0",
                "4.05",   "4.1",   "4.15",   "4.2",   "4.25",   "4.3",
                "4.35",   "4.4",   "4.45",   "4.5",   "4.55",   "4.6",
                "4.65",   "4.7",   "4.75",   "4.8",   "4.85",   "4.9",
                "4.95",   "5.0",   "5.05",   "5.1",   "5.15",   "5.2",
                "5.25",   "5.3",   "5.35",   "5.4",   "5.45",   "5.5",
                "5.55",   "5.6",   "5.65",   "5.7",   "5.75",   "5.8",
                "5.85",   "5.9",   "5.95",   "6.0",   "6.1",    "6.2",
                "6.3",    "6.4",   "6.5",    "6.6",   "6.7",    "6.8",
                "6.9",    "7.0",   "7.1",    "7.2",   "7.3",    "7.4",
                "7.5",    "7.6",   "7.7",    "7.8",   "7.9",    "8.0",
                "8.1",    "8.2",   "8.3",    "8.4",   "8.5",    "8.6",
                "8.7",    "8.8",   "8.9",    "9.0",   "9.1",    "9.2",
                "9.3",    "9.4",   "9.5",    "9.6",   "9.7",    "9.8",
                "9.9",    "10.0",  "10.025", "10.05", "10.075", "10.1",
                "10.125", "10.15", "10.175", "10.2",  "10.225", "10.25",
                "10.275", "10.3",  "10.325", "10.35", "10.375", "10.4",
                "10.425", "10.45", "10.475", "10.5",  "10.525", "10.55",
                "10.575", "10.6",  "10.625", "10.65", "10.675", "10.7",
                "10.725", "10.75", "10.775", "10.8",  "10.825", "10.85",
                "10.875", "10.9",  "10.925", "10.95", "10.975", "11.0",
                "11.025", "11.05", "11.075", "11.1",  "11.125", "11.15",
                "11.175", "11.2",  "11.225", "11.25", "11.275", "11.3",
                "11.325", "11.35", "11.375", "11.4",  "11.425", "11.45",
                "11.475", "11.5",  "11.525", "11.55", "11.575", "11.6",
                "11.625", "11.65", "11.675", "11.7",  "11.725", "11.75",
                "11.775", "11.8",  "11.825", "11.85", "11.875", "11.9",
                "11.925", "11.95", "11.975", "12.0",  "12.025", "12.05",
                "12.075", "12.1",  "12.125", "12.15", "12.175", "12.2",
                "12.225", "12.25", "12.275", "12.3",  "12.325", "12.35",
                "12.375", "12.4",  "12.425", "12.45", "12.475", "12.5",
                "12.525", "12.55", "12.575", "12.6",  "12.625", "12.65",
                "12.675", "12.7",  "12.725", "12.75", "12.775", "12.8",
                "12.825", "12.85", "12.875", "12.9",  "12.925", "12.95",
                "12.975", "13.0",  "13.025", "13.05", "13.075", "13.1",
                "13.125", "13.15", "13.175", "13.2",  "13.225", "13.25",
                "13.275", "13.3",  "13.325", "13.35", "13.375", "13.4",
                "13.425", "13.45", "13.475", "13.5",  "13.525", "13.55",
                "13.575", "13.6",  "13.625", "13.65", "13.675", "13.7",
                "13.725", "13.75", "13.775", "13.8",  "13.825", "13.85",
                "13.875", "13.9",  "13.925", "13.95", "13.975", "14.0",
                "14.025", "14.05", "14.075", "14.1",  "14.125", "14.15",
                "14.175", "14.2",  "14.225", "14.25", "14.275", "14.3",
                "14.325", "14.35", "14.375", "14.4",  "14.425", "14.45",
                "14.475", "14.5",  "14.525", "14.55", "14.575", "14.6",
                "14.625", "14.65", "14.675", "14.7",  "14.725", "14.75",
                "14.775", "14.8",  "14.825", "14.85", "14.875", "14.9",
                "14.925", "14.95", "14.975", "15.0",  "15.025", "15.05",
                "15.075", "15.1",  "15.125", "15.15", "15.175", "15.2",
                "15.225", "15.25", "15.275", "15.3",  "15.325", "15.35",
                "15.375", "15.4",  "15.425", "15.45", "15.475", "15.5",
                "15.525", "15.55", "15.575", "15.6",  "15.625", "15.65",
                "15.675", "15.7",  "15.725", "15.75", "15.775", "15.8",
                "15.825", "15.85", "15.875", "15.9",  "15.925", "15.95",
                "15.975", "16.0",  "16.025", "16.05", "16.075", "16.1",
                "16.125", "16.15", "16.175", "16.2",  "16.225", "16.25",
                "16.275", "16.3",  "16.325", "16.35", "16.375", "16.4",
                "16.425", "16.45", "16.475", "16.5",  "16.525", "16.55",
                "16.575", "16.6",  "16.625", "16.65", "16.675", "16.7",
                "16.725", "16.75", "16.775", "16.8",  "16.825", "16.85",
                "16.875", "16.9",  "16.925", "16.95", "16.975", "17.0",
                "17.025", "17.05", "17.075", "17.1",  "17.125", "17.15",
                "17.175", "17.2",  "17.225", "17.25", "17.275", "17.3",
                "17.325", "17.35", "17.375", "17.4",  "17.425", "17.45",
                "17.475", "17.5",  "17.525", "17.55", "17.575", "17.6",
                "17.625", "17.65", "17.675", "17.7",  "17.725", "17.75",
                "17.775", "17.8",  "17.825", "17.85", "17.875", "17.9",
                "17.925", "17.95", "17.975", "18.0",  "18.025", "18.05",
                "18.075", "18.1",  "18.125", "18.15", "18.175", "18.2",
                "18.225", "18.25", "18.275", "18.3",  "18.325", "18.35",
                "18.375", "18.4",  "18.425", "18.45", "18.475", "18.5",
                "18.525", "18.55", "18.575", "18.6",  "18.625", "18.65",
                "18.675", "18.7",  "18.725", "18.75", "18.775", "18.8",
                "18.825", "18.85", "18.875", "18.9",  "18.925", "18.95",
                "18.975", "19.0",  "19.025", "19.05", "19.075", "19.1",
                "19.125", "19.15", "19.175", "19.2",  "19.225", "19.25",
                "19.275", "19.3",  "19.325", "19.35", "19.375", "19.4",
                "19.425", "19.45", "19.475", "19.5",  "19.525", "19.55",
                "19.575", "19.6",  "19.625", "19.65", "19.675", "19.7",
                "19.725", "19.75", "19.775", "19.8",  "19.825", "19.85",
                "19.875", "19.9",  "19.925", "19.95", "19.975", "20.0",
                "20.025", "20.05", "20.075", "20.1",  "20.125", "20.15",
                "20.175", "20.2",  "20.225", "20.25", "20.275", "20.3",
                "20.325", "20.35", "20.375", "20.4",  "20.425", "20.45",
                "20.475", "20.5",  "20.525", "20.55", "20.575", "20.6",
                "20.625", "20.65", "20.675", "20.7",  "20.725", "20.75",
                "20.775", "20.8",  "20.825", "20.85", "20.875", "20.9",
                "20.925", "20.95", "20.975", "21.0",  "21.025", "21.05",
                "21.075", "21.1",  "21.125", "21.15", "21.175", "21.2",
                "21.225", "21.25", "21.275", "21.3",  "21.325", "21.35",
                "21.375", "21.4",  "21.425", "21.45", "21.475", "21.5",
                "21.525", "21.55", "21.575", "21.6",  "21.625", "21.65",
                "21.675", "21.7",  "21.725", "21.75", "21.775", "21.8",
                "21.825", "21.85", "21.875", "21.9",  "21.925", "21.95",
                "21.975", "22.0",  "22.025", "22.05", "22.075", "22.1",
                "22.125", "22.15", "22.175", "22.2",  "22.225", "22.25",
                "22.275", "22.3",  "22.325", "22.35", "22.375", "22.4",
                "22.425", "22.45", "22.475", "22.5",  "22.525", "22.55",
                "22.575", "22.6",  "22.625", "22.65", "22.675", "22.7",
                "22.725", "22.75", "22.775", "22.8",  "22.825", "22.85",
                "22.875", "22.9",  "22.925", "22.95", "22.975", "23.0",
                "23.025", "23.05", "23.075", "23.1",  "23.125", "23.15",
                "23.175", "23.2",  "23.225", "23.25", "23.275", "23.3",
                "23.325", "23.35", "23.375", "23.4",  "23.425", "23.45",
                "23.475", "23.5",  "23.525", "23.55", "23.575", "23.6",
                "23.625", "23.65", "23.675", "23.7",  "23.725", "23.75",
                "23.775", "23.8",  "23.825", "23.85", "23.875", "23.9",
                "23.925", "23.95", "23.975", "24.0",  "24.025", "24.05",
                "24.075", "24.1",  "24.125", "24.15", "24.175", "24.2",
                "24.225", "24.25", "24.275", "24.3",  "24.325", "24.35",
                "24.375", "24.4",  "24.425", "24.45", "24.475", "24.5",
                "24.525", "24.55", "24.575", "24.6",  "24.625", "24.65",
                "24.675", "24.7",  "24.725", "24.75", "24.775", "24.8",
                "24.825", "24.85", "24.875", "24.9",  "24.925", "24.95",
                "24.975", "25.0",  "25.025", "25.05", "25.075", "25.1",
                "25.125", "25.15", "25.175", "25.2",  "25.225", "25.25",
                "25.275", "25.3",  "25.325", "25.35", "25.375", "25.4",
                "25.425", "25.45", "25.475", "25.5",  "25.525", "25.55",
                "25.575", "25.6",  "25.625", "25.65", "25.675", "25.7",
                "25.725", "25.75", "25.775", "25.8",  "25.825", "25.85",
                "25.875", "25.9",  "25.925", "25.95", "25.975", "26.0",
                "26.025", "26.05", "26.075", "26.1",  "26.125", "26.15",
                "26.175", "26.2",  "26.225", "26.25", "26.275", "26.3",
                "26.325", "26.35", "26.375", "26.4",  "26.425", "26.45",
                "26.475", "26.5",  "26.525", "26.55", "26.575", "26.6",
                "26.625", "26.65", "26.675", "26.7",  "26.725", "26.75",
                "26.775", "26.8",  "26.825", "26.85", "26.875", "26.9",
                "26.925", "26.95", "26.975", "27.0",  "27.025", "27.05",
                "27.075", "27.1",  "27.125", "27.15", "27.175", "27.2",
                "27.225", "27.25", "27.275", "27.3",  "27.325", "27.35",
                "27.375", "27.4",  "27.425", "27.45", "27.475", "27.5",
                "27.525", "27.55", "27.575", "27.6",  "27.625", "27.65",
                "27.675", "27.7",  "27.725", "27.75", "27.775", "27.8",
                "27.825", "27.85", "27.875", "27.9",  "27.925", "27.95",
                "27.975", "28.0",  "28.025", "28.05", "28.075", "28.1",
                "28.125", "28.15", "28.175", "28.2",  "28.225", "28.25",
                "28.275", "28.3",  "28.325", "28.35", "28.375", "28.4",
                "28.425", "28.45", "28.475", "28.5",  "28.525", "28.55",
                "28.575", "28.6",  "28.625", "28.65", "28.675", "28.7",
                "28.725", "28.75", "28.775", "28.8",  "28.825", "28.85",
                "28.875", "28.9",  "28.925", "28.95", "28.975", "29.0",
                "29.025", "29.05", "29.075", "29.1",  "29.125", "29.15",
                "29.175", "29.2",  "29.225", "29.25", "29.275", "29.3",
                "29.325", "29.35", "29.375", "29.4",  "29.425", "29.45",
                "29.475", "29.5",  "29.525", "29.55", "29.575", "29.6",
                "29.625", "29.65", "29.675", "29.7",  "29.725", "29.75",
                "29.775", "29.8",  "29.825", "29.85", "29.875", "29.9",
                "29.925", "29.95", "29.975", "30.0",  "30.05",  "30.1",
                "30.15",  "30.2",  "30.25",  "30.3",  "30.35",  "30.4",
                "30.45",  "30.5",  "30.55",  "30.6",  "30.65",  "30.7",
                "30.75",  "30.8",  "30.85",  "30.9",  "30.95",  "31.0",
                "31.05",  "31.1",  "31.15",  "31.2",  "31.25",  "31.3",
                "31.35",  "31.4",  "31.45",  "31.5",  "31.55",  "31.6",
                "31.65",  "31.7",  "31.75",  "31.8",  "31.85",  "31.9",
                "31.95",  "32.0",  "32.05",  "32.1",  "32.15",  "32.2",
                "32.25",  "32.3",  "32.35",  "32.4",  "32.45",  "32.5",
                "32.55",  "32.6",  "32.65",  "32.7",  "32.75",  "32.8",
                "32.85",  "32.9",  "32.95",  "33.0",  "33.05",  "33.1",
                "33.15",  "33.2",  "33.25",  "33.3",  "33.35",  "33.4",
                "33.45",  "33.5",  "33.55",  "33.6",  "33.65",  "33.7",
                "33.75",  "33.8",  "33.85",  "33.9",  "33.95",  "34.0",
                "34.05",  "34.1",  "34.15",  "34.2",  "34.25",  "34.3",
                "34.35",  "34.4",  "34.45",  "34.5",  "34.55",  "34.6",
                "34.65",  "34.7",  "34.75",  "34.8",  "34.85",  "34.9",
                "34.95",  "35.0",  "35.05",  "35.1",  "35.15",  "35.2",
                "35.25",  "35.3",  "35.35",  "35.4",  "35.45",  "35.5",
                "35.55",  "35.6",  "35.65",  "35.7",  "35.75",  "35.8",
                "35.85",  "35.9",  "35.95",  "36.0",  "36.05",  "36.1",
                "36.15",  "36.2",  "36.25",  "36.3",  "36.35",  "36.4",
                "36.45",  "36.5",  "36.55",  "36.6",  "36.65",  "36.7",
                "36.75",  "36.8",  "36.85",  "36.9",  "36.95",  "37.0",
                "37.05",  "37.1",  "37.15",  "37.2",  "37.25",  "37.3",
                "37.35",  "37.4",  "37.45",  "37.5",  "37.55",  "37.6",
                "37.65",  "37.7",  "37.75",  "37.8",  "37.85",  "37.9",
                "37.95",  "38.0",  "38.05",  "38.1",  "38.15",  "38.2",
                "38.25",  "38.3",  "38.35",  "38.4",  "38.45",  "38.5",
                "38.55",  "38.6",  "38.65",  "38.7",  "38.75",  "38.8",
                "38.85",  "38.9",  "38.95",  "39.0",  "39.05",  "39.1",
                "39.15",  "39.2",  "39.25",  "39.3",  "39.35",  "39.4",
                "39.45",  "39.5",  "39.55",  "39.6",  "39.65",  "39.7",
                "39.75",  "39.8",  "39.85",  "39.9",  "39.95",  "40.0",
                "40.05",  "40.1",  "40.15",  "40.2",  "40.25",  "40.3",
                "40.35",  "40.4",  "40.45",  "40.5",  "40.55",  "40.6",
                "40.65",  "40.7",  "40.75",  "40.8",  "40.85",  "40.9",
                "40.95",  "41.0",  "41.05",  "41.1",  "41.15",  "41.2",
                "41.25",  "41.3",  "41.35",  "41.4",  "41.45",  "41.5",
                "41.55",  "41.6",  "41.65",  "41.7",  "41.75",  "41.8",
                "41.85",  "41.9",  "41.95",  "42.0",  "42.05",  "42.1",
                "42.15",  "42.2",  "42.25",  "42.3",  "42.35",  "42.4",
                "42.45",  "42.5",  "42.55",  "42.6",  "42.65",  "42.7",
                "42.75",  "42.8",  "42.85",  "42.9",  "42.95",  "43.0",
                "43.05",  "43.1",  "43.15",  "43.2",  "43.25",  "43.3",
                "43.35",  "43.4",  "43.45",  "43.5",  "43.55",  "43.6",
                "43.65",  "43.7",  "43.75",  "43.8",  "43.85",  "43.9",
                "43.95",  "44.0",  "44.05",  "44.1",  "44.15",  "44.2",
                "44.25",  "44.3",  "44.35",  "44.4",  "44.45",  "44.5",
                "44.55",  "44.6",  "44.65",  "44.7",  "44.75",  "44.8",
                "44.85",  "44.9",  "44.95",  "45.0",  "45.05",  "45.1",
                "45.15",  "45.2",  "45.25",  "45.3",  "45.35",  "45.4",
                "45.45",  "45.5",  "45.55",  "45.6",  "45.65",  "45.7",
                "45.75",  "45.8",  "45.85",  "45.9",  "45.95",  "46.0",
                "46.05",  "46.1",  "46.15",  "46.2",  "46.25",  "46.3",
                "46.35",  "46.4",  "46.45",  "46.5",  "46.55",  "46.6",
                "46.65",  "46.7",  "46.75",  "46.8",  "46.85",  "46.9",
                "46.95",  "47.0",  "47.05",  "47.1",  "47.15",  "47.2",
                "47.25",  "47.3",  "47.35",  "47.4",  "47.45",  "47.5",
                "47.55",  "47.6",  "47.65",  "47.7",  "47.75",  "47.8",
                "47.85",  "47.9",  "47.95",  "48.0",  "48.05",  "48.1",
                "48.15",  "48.2",  "48.25",  "48.3",  "48.35",  "48.4",
                "48.45",  "48.5",  "48.55",  "48.6",  "48.65",  "48.7",
                "48.75",  "48.8",  "48.85",  "48.9",  "48.95",  "49.0",
                "49.05",  "49.1",  "49.15",  "49.2",  "49.25",  "49.3",
                "49.35",  "49.4",  "49.45",  "49.5",  "49.55",  "49.6",
                "49.65",  "49.7",  "49.75",  "49.8",  "49.85",  "49.9",
                "49.95",  "50.0",  "50.05",  "50.1",  "50.15",  "50.2",
                "50.25",  "50.3",  "50.35",  "50.4",  "50.45",  "50.5",
                "50.55",  "50.6",  "50.65",  "50.7",  "50.75",  "50.8",
                "50.85",  "50.9",  "50.95",  "51.0",  "51.05",  "51.1",
                "51.15",  "51.2",  "51.25",  "51.3",  "51.35",  "51.4",
                "51.45",  "51.5",  "51.55",  "51.6",  "51.65",  "51.7",
                "51.75",  "51.8",  "51.85",  "51.9",  "51.95",  "52.0",
                "52.05",  "52.1",  "52.15",  "52.2",  "52.25",  "52.3",
                "52.35",  "52.4",  "52.45",  "52.5",  "52.55",  "52.6",
                "52.65",  "52.7",  "52.75",  "52.8",  "52.85",  "52.9",
                "52.95",  "53.0",  "53.05",  "53.1",  "53.15",  "53.2",
                "53.25",  "53.3",  "53.35",  "53.4",  "53.45",  "53.5",
                "53.55",  "53.6",  "53.65",  "53.7",  "53.75",  "53.8",
                "53.85",  "53.9",  "53.95",  "54.0",  "54.05",  "54.1",
                "54.15",  "54.2",  "54.25",  "54.3",  "54.35",  "54.4",
                "54.45",  "54.5",  "54.55",  "54.6",  "54.65",  "54.7",
                "54.75",  "54.8",  "54.85",  "54.9",  "54.95",  "55.0",
                "55.05",  "55.1",  "55.15",  "55.2",  "55.25",  "55.3",
                "55.35",  "55.4",  "55.45",  "55.5",  "55.55",  "55.6",
                "55.65",  "55.7",  "55.75",  "55.8",  "55.85",  "55.9",
                "55.95",  "56.0",  "56.05",  "56.1",  "56.15",  "56.2",
                "56.25",  "56.3",  "56.35",  "56.4",  "56.45",  "56.5",
                "56.55",  "56.6",  "56.65",  "56.7",  "56.75",  "56.8",
                "56.85",  "56.9",  "56.95",  "57.0",  "57.05",  "57.1",
                "57.15",  "57.2",  "57.25",  "57.3",  "57.35",  "57.4",
                "57.45",  "57.5",  "57.55",  "57.6",  "57.65",  "57.7",
                "57.75",  "57.8",  "57.85",  "57.9",  "57.95",  "58.0",
                "58.05",  "58.1",  "58.15",  "58.2",  "58.25",  "58.3",
                "58.35",  "58.4",  "58.45",  "58.5",  "58.55",  "58.6",
                "58.65",  "58.7",  "58.75",  "58.8",  "58.85",  "58.9",
                "58.95",  "59.0",  "59.05",  "59.1",  "59.15",  "59.2",
                "59.25",  "59.3",  "59.35",  "59.4",  "59.45",  "59.5",
                "59.55",  "59.6",  "59.65",  "59.7",  "59.75",  "59.8",
                "59.85",  "59.9",  "59.95",  "60.0",  "60.1",   "60.2",
                "60.3",   "60.4",  "60.5",   "60.6",  "60.7",   "60.8",
                "60.9",   "61.0",  "61.1",   "61.2",  "61.3",   "61.4",
                "61.5",   "61.6",  "61.7",   "61.8",  "61.9",   "62.0",
                "62.1",   "62.2",  "62.3",   "62.4",  "62.5",   "62.6",
                "62.7",   "62.8",  "62.9",   "63.0",  "63.1",   "63.2",
                "63.3",   "63.4",  "63.5",   "63.6",  "63.7",   "63.8",
                "63.9",   "64.0",  "64.1",   "64.2",  "64.3",   "64.4",
                "64.5",   "64.6",  "64.7",   "64.8",  "64.9",   "65.0",
                "65.1",   "65.2",  "65.3",   "65.4",  "65.5",   "65.6",
                "65.7",   "65.8",  "65.9",   "66.0",  "66.1",   "66.2",
                "66.3",   "66.4",  "66.5",   "66.6",  "66.7",   "66.8",
                "66.9",   "67.0",  "67.1",   "67.2",  "67.3",   "67.4",
                "67.5",   "67.6",  "67.7",   "67.8",  "67.9",   "68.0",
                "68.1",   "68.2",  "68.3",   "68.4",  "68.5",   "68.6",
                "68.7",   "68.8",  "68.9",   "69.0",  "69.1",   "69.2",
                "69.3",   "69.4",  "69.5",   "69.6",  "69.7",   "69.8",
                "69.9",   "70.0",  "70.1",   "70.2",  "70.3",   "70.4",
                "70.5",   "70.6",  "70.7",   "70.8",  "70.9",   "71.0",
                "71.1",   "71.2",  "71.3",   "71.4",  "71.5",   "71.6",
                "71.7",   "71.8",  "71.9",   "72.0",  "72.1",   "72.2",
                "72.3",   "72.4",  "72.5",   "72.6",  "72.7",   "72.8",
                "72.9",   "73.0",  "73.1",   "73.2",  "73.3",   "73.4",
                "73.5",   "73.6",  "73.7",   "73.8",  "73.9",   "74.0",
                "74.1",   "74.2",  "74.3",   "74.4",  "74.5",   "74.6",
                "74.7",   "74.8",  "74.9",   "75.0",  "75.1",   "75.2",
                "75.3",   "75.4",  "75.5",   "75.6",  "75.7",   "75.8",
                "75.9",   "76.0",  "76.1",   "76.2",  "76.3",   "76.4",
                "76.5",   "76.6",  "76.7",   "76.8",  "76.9",   "77.0",
                "77.1",   "77.2",  "77.3",   "77.4",  "77.5",   "77.6",
                "77.7",   "77.8",  "77.9",   "78.0",  "78.1",   "78.2",
                "78.3",   "78.4",  "78.5",   "78.6",  "78.7",   "78.8",
                "78.9",   "79.0",  "79.1",   "79.2",  "79.3",   "79.4",
                "79.5",   "79.6",  "79.7",   "79.8",  "79.9",   "80.0",
                "80.1",   "80.2",  "80.3",   "80.4",  "80.5",   "80.6",
                "80.7",   "80.8",  "80.9",   "81.0",  "81.1",   "81.2",
                "81.3",   "81.4",  "81.5",   "81.6",  "81.7",   "81.8",
                "81.9",   "82.0",  "82.1",   "82.2",  "82.3",   "82.4",
                "82.5",   "82.6",  "82.7",   "82.8",  "82.9",   "83.0",
                "83.1",   "83.2",  "83.3",   "83.4",  "83.5",   "83.6",
                "83.7",   "83.8",  "83.9",   "84.0",  "84.1",   "84.2",
                "84.3",   "84.4",  "84.5",   "84.6",  "84.7",   "84.8",
                "84.9",   "85.0",  "85.1",   "85.2",  "85.3",   "85.4",
                "85.5",   "85.6",  "85.7",   "85.8",  "85.9",   "86.0",
                "86.1",   "86.2",  "86.3",   "86.4",  "86.5",   "86.6",
                "86.7",   "86.8",  "86.9",   "87.0",  "87.1",   "87.2",
                "87.3",   "87.4",  "87.5",   "87.6",  "87.7",   "87.8",
                "87.9",   "88.0",  "88.1",   "88.2",  "88.3",   "88.4",
                "88.5",   "88.6",  "88.7",   "88.8",  "88.9",   "89.0",
                "89.1",   "89.2",  "89.3",   "89.4",  "89.5",   "89.6",
                "89.7",   "89.8",  "89.9",   "90.0",  "90.1",   "90.2",
                "90.3",   "90.4",  "90.5",   "90.6",  "90.7",   "90.8",
                "90.9",   "91.0",  "91.1",   "91.2",  "91.3",   "91.4",
                "91.5",   "91.6",  "91.7",   "91.8",  "91.9",   "92.0",
                "92.1",   "92.2",  "92.3",   "92.4",  "92.5",   "92.6",
                "92.7",   "92.8",  "92.9",   "93.0",  "93.1",   "93.2",
                "93.3",   "93.4",  "93.5",   "93.6",  "93.7",   "93.8",
                "93.9",   "94.0",  "94.1",   "94.2",  "94.3",   "94.4",
                "94.5",   "94.6",  "94.7",   "94.8",  "94.9",   "95.0",
                "95.1",   "95.2",  "95.3",   "95.4",  "95.5",   "95.6",
                "95.7",   "95.8",  "95.9",   "96.0",  "96.1",   "96.2",
                "96.3",   "96.4",  "96.5",   "96.6",  "96.7",   "96.8",
                "96.9",   "97.0",  "97.1",   "97.2",  "97.3",   "97.4",
                "97.5",   "97.6",  "97.7",   "97.8",  "97.9",   "98.0",
                "98.1",   "98.2",  "98.3",   "98.4",  "98.5",   "98.6",
                "98.7",   "98.8",  "98.9",   "99.0",  "99.1",   "99.2",
                "99.3",   "99.4",  "99.5",   "99.6",  "99.7",   "99.8",
                "99.9",   "100.0",
            ],
        };
    }
);
has C => (
    is      => 'ro',
    default => sub {
        {   dist => [
                0,                    "0.00995033085316809",
                "0.0198026272961797", "0.0295588022415444",
                "0.0392207131532813", "0.048790164169432",
                "0.0582689081239758", "0.0676586484738149",
                "0.0769610411361284", "0.0861776962410524",
                "0.0953101798043249", "0.104360015324243",
                "0.113328685307003",  "0.122217632724249",
                "0.131028262406404",  "0.139761942375159",
                "0.148420005118273",  "0.157003748809665",
                "0.165514438477573",  "0.173953307123438",
                "0.182321556793955",  "0.19062035960865",
                "0.198850858745165",  "0.207014169384326",
                "0.215111379616945",  "0.22314355131421",
                "0.231111720963387",  "0.2390169004705",
                "0.246860077931526",  "0.254642218373581",
                "0.262364264467491",  "0.27002713721306",
                "0.27763173659828",   "0.285178942233662",
                "0.29266961396282",   "0.300104592450338",
                "0.307484699747961",  "0.314810739840034",
                "0.322083499169113",  "0.3293037471426",
                "0.336472236621213",  "0.343589704390077",
                "0.350656871613169",  "0.357674444271816",
                "0.364643113587909",  "0.371563556432483",
                "0.378436435720245",  "0.385262400790645",
                "0.392042087776024",  "0.398776119957368",
                "0.405465108108164",  "0.412109650826833",
                "0.418710334858185",  "0.425267735404344",
                "0.431782416425538",  "0.438254930931155",
                "0.444685821261446",  "0.451075619360217",
                "0.457424847038875",  "0.46373401623214",
                "0.470003629245736",  "0.476234178996372",
                "0.482426149244293",  "0.488580014818671",
                "0.494696241836107",  "0.500775287912489",
                "0.506817602368452",  "0.512823626428664",
                "0.518793793415168",  "0.524728528934982",
                "0.53062825106217",   "0.536493370514568",
                "0.542324290825362",  "0.548121408509688",
                "0.553885113226438",  "0.559615787935423",
                "0.56531380905006",   "0.570979546585738",
                "0.576613364303994",  "0.582215619852664",
                "0.587786664902119",  "0.593326845277734",
                "0.598836501088704",  "0.60431596685333",
                "0.609765571620894",  "0.615185639090233",
                "0.62057648772511",   "0.625938430866495",
                "0.631271776841858",  "0.636576829071551",
                "0.641853886172395",  "0.647103242058539",
                "0.65232518603969",   "0.657520002916794",
                "0.662687973075237",  "0.667829372575656",
                "0.672944473242426",  "0.678033542749897",
                "0.683096844706444",  "0.688134638736401",
                "0.693147180559945",  "0.698134722070984",
                "0.703097511413113",  "0.708035793053696",
                "0.712949807856125",  "0.717839793150317",
                "0.72270598280149",   "0.727548607277278",
                "0.732367893713227",  "0.73716406597672",
                "0.741937344729377",  "0.746687947487975",
                "0.751416088683921",  "0.756121979721334",
                "0.76080582903376",   "0.765467842139572",
                "0.770108221696074",  "0.774727167552368",
                "0.779324876800997",  "0.783901543828409",
                "0.78845736036427",   "0.792992515529661",
                "0.797507195884188",  "0.802001585472027",
                "0.806475865866949",  "0.810930216216329",
                "0.815364813284194",  "0.819779831493311",
                "0.824175442966349",  "0.828551817566148",
                "0.832909122935104",  "0.837247524533702",
                "0.841567185678219",  "0.845868267577609",
                "0.85015092936961",   "0.854415328156068",
                "0.858661619037519",  "0.86288995514704",
                "0.867100487683383",  "0.871293365943419",
                "0.8754687373539",    "0.879626747502564",
                "0.883767540168595",  "0.887891257352457",
                "0.89199803930511",   "0.896088024556636",
                "0.900161349944271",  "0.904218150639886",
                "0.908258560176891",  "0.912282710476616",
                "0.916290731874155",  "0.920282753143692",
                "0.924258901523332",  "0.928219302739429",
                "0.932164081030445",  "0.936093359170335",
                "0.940007258491471",  "0.943905898907129",
                "0.947789398933526",  "0.951657875711446",
                "0.955511445027436",  "0.959350221334602",
                "0.963174317773006",  "0.966983846189673",
                "0.970778917158225",  "0.974559639998131",
                "0.978326122793608",  "0.982078472412158",
                "0.985816794522765",  "0.989541193613748",
                "0.993251773010283",  "0.99694863489161",
                "1.00063188030791",   "1.00430160919687",
                "1.00795792039998",   "1.01160091167848",
                "1.01523067972906",   "1.01884732019925",
                "1.02245092770255",   "1.02604159583327",
                "1.02961941718116",   "1.03318448334565",
                "1.03673688495002",   "1.04027671165515",
                "1.04380405217311",   "1.04731899428056",
                "1.05082162483176",   "1.05431202977153",
                "1.05779029414785",   "1.06125650212434",
                "1.06471073699243",   "1.0681530811834",
                "1.07158361628019",   "1.07500242302898",
                "1.07840958135059",   "1.08180517035173",
                "1.08518926833597",   "1.08856195281461",
                "1.09192330051731",   "1.0952733874026",
                "1.09861228866811",   "1.1069110914828",
                "1.11514159061932",   "1.12330490125848",
                "1.1314021114911",    "1.13943428318836",
                "1.1447298858494",    "1.14740245283754",
                "1.15530763234465",   "1.16315080980568",
                "1.17093295024774",   "1.17865499634165",
                "1.18631786908722",   "1.19392246847243",
                "1.20146967410782",   "1.20896034583698",
                "1.21639532432449",   "1.22377543162212",
                "1.23110147171419",   "1.23837423104327",
                "1.24559447901676",   "1.25276296849537",
                "1.25988043626423",   "1.26694760348732",
                "1.27396517614597",   "1.28093384546206",
                "1.28785428830664",   "1.2947271675944",
                "1.3015531326648",    "1.30833281965018",
                "1.31506685183152",   "1.32175583998232",
                "1.32840038270099",   "1.33500106673234",
                "1.3415584672785",    "1.34807314829969",
                "1.35454566280531",   "1.3609765531356",
                "1.36736635123437",   "1.37371557891303",
                "1.3800247481063",    "1.38629436111989",
                "1.39252491087053",   "1.39871688111845",
                "1.40487074669283",   "1.41098697371026",
                "1.41706601978664",   "1.42310833424261",
                "1.42911435830282",   "1.43508452528932",
                "1.44101926080914",   "1.44691898293633",
                "1.45278410238872",   "1.45861502269952",
                "1.46441214038384",   "1.47017584510059",
                "1.47590651980958",   "1.48160454092422",
                "1.48727027845989",   "1.49290409617815",
                "1.49850635172682",   "1.50407739677627",
                "1.50961757715189",   "1.51512723296286",
                "1.52060669872748",   "1.52605630349505",
                "1.53147637096439",   "1.53686721959926",
                "1.54222916274065",   "1.54756250871601",
                "1.55286756094571",   "1.55814461804655",
                "1.56339397393269",   "1.56861591791385",
                "1.57381073479095",   "1.57897870494939",
                "1.58412010444981",   "1.58923520511658",
                "1.59432427462405",   "1.5993875765806",
                "1.60442537061056",   "1.6094379124341",
                "1.61938824328727",   "1.62924053973028",
                "1.63899671467564",   "1.64865862558738",
                "1.65822807660353",   "1.66770682055808",
                "1.67709656090792",   "1.68639895357023",
                "1.69561560867515",   "1.70474809223843",
                "1.71379792775834",   "1.7227665977411",
                "1.73165554515835",   "1.7404661748405",
                "1.74919985480926",   "1.75785791755237",
                "1.76644166124377",   "1.77495235091167",
                "1.78339121955754",   "1.79175946922805",
                "1.80005827204275",   "1.80828877117927",
                "1.81645208181843",   "1.82454929205105",
                "1.83258146374831",   "1.84054963339749",
                "1.8484548129046",    "1.85629799036563",
                "1.86408013080768",   "1.87180217690159",
                "1.87946504964716",   "1.88706964903238",
                "1.89461685466776",   "1.90210752639692",
                "1.90954250488444",   "1.91692261218206",
                "1.92424865227413",   "1.93152141160321",
                "1.9387416595767",    "1.94591014905531",
                "1.95302761682418",   "1.96009478404727",
                "1.96711235670592",   "1.97408102602201",
                "1.98100146886658",   "1.98787434815435",
                "1.99470031322475",   "2.00148000021012",
                "2.00821403239147",   "2.01490302054226",
                "2.02154756326093",   "2.02814824729229",
                "2.03470564783844",   "2.04122032885964",
                "2.04769284336526",   "2.05412373369555",
                "2.06051353179432",   "2.06686275947298",
                "2.07317192866624",   "2.07944154167984",
                "2.08567209143047",   "2.09186406167839",
                "2.09801792725277",   "2.10413415427021",
                "2.11021320034659",   "2.11625551480255",
                "2.12226153886276",   "2.12823170584927",
                "2.13416644136908",   "2.14006616349627",
                "2.14593128294867",   "2.15176220325946",
                "2.15755932094379",   "2.16332302566054",
                "2.16905370036952",   "2.17475172148416",
                "2.18041745901984",   "2.18605127673809",
                "2.19165353228676",   "2.19722457733622",
                "2.20276475771183",   "2.2082744135228",
                "2.21375387928743",   "2.21920348405499",
                "2.22462355152433",   "2.23001440015921",
                "2.2353763433006",    "2.24070968927596",
                "2.24601474150565",   "2.2512917986065",
                "2.25654115449264",   "2.26176309847379",
                "2.26695791535089",   "2.27212588550934",
                "2.27726728500976",   "2.28238238567653",
                "2.287471455184",     "2.29253475714054",
                "2.2975725511705",    "2.30258509299405",
            ],
            value => [
                1,       "1.01",  "1.02",     "1.03",  "1.04",  "1.05",
                "1.06",  "1.07",  "1.08",     "1.09",  "1.1",   "1.11",
                "1.12",  "1.13",  "1.14",     "1.15",  "1.16",  "1.17",
                "1.18",  "1.19",  "1.2",      "1.21",  "1.22",  "1.23",
                "1.24",  "1.25",  "1.26",     "1.27",  "1.28",  "1.29",
                "1.3",   "1.31",  "1.32",     "1.33",  "1.34",  "1.35",
                "1.36",  "1.37",  "1.38",     "1.39",  "1.4",   "1.41",
                "1.42",  "1.43",  "1.44",     "1.45",  "1.46",  "1.47",
                "1.48",  "1.49",  "1.5",      "1.51",  "1.52",  "1.53",
                "1.54",  "1.55",  "1.56",     "1.57",  "1.58",  "1.59",
                "1.6",   "1.61",  "1.62",     "1.63",  "1.64",  "1.65",
                "1.66",  "1.67",  "1.68",     "1.69",  "1.7",   "1.71",
                "1.72",  "1.73",  "1.74",     "1.75",  "1.76",  "1.77",
                "1.78",  "1.79",  "1.8",      "1.81",  "1.82",  "1.83",
                "1.84",  "1.85",  "1.86",     "1.87",  "1.88",  "1.89",
                "1.9",   "1.91",  "1.92",     "1.93",  "1.94",  "1.95",
                "1.96",  "1.97",  "1.98",     "1.99",  2,       "2.01",
                "2.02",  "2.03",  "2.04",     "2.05",  "2.06",  "2.07",
                "2.08",  "2.09",  "2.1",      "2.11",  "2.12",  "2.13",
                "2.14",  "2.15",  "2.16",     "2.17",  "2.18",  "2.19",
                "2.2",   "2.21",  "2.22",     "2.23",  "2.24",  "2.25",
                "2.26",  "2.27",  "2.28",     "2.29",  "2.3",   "2.31",
                "2.32",  "2.33",  "2.34",     "2.35",  "2.36",  "2.37",
                "2.38",  "2.39",  "2.4",      "2.41",  "2.42",  "2.43",
                "2.44",  "2.45",  "2.46",     "2.47",  "2.48",  "2.49",
                "2.5",   "2.51",  "2.52",     "2.53",  "2.54",  "2.55",
                "2.56",  "2.57",  "2.58",     "2.59",  "2.6",   "2.61",
                "2.62",  "2.63",  "2.64",     "2.65",  "2.66",  "2.67",
                "2.68",  "2.69",  "2.7",      "2.71",  "2.72",  "2.73",
                "2.74",  "2.75",  "2.76",     "2.77",  "2.78",  "2.79",
                "2.8",   "2.81",  "2.82",     "2.83",  "2.84",  "2.85",
                "2.86",  "2.87",  "2.88",     "2.89",  "2.9",   "2.91",
                "2.92",  "2.93",  "2.94",     "2.95",  "2.96",  "2.97",
                "2.98",  "2.99",  3,          "3.025", "3.05",  "3.075",
                "3.1",   "3.125", "3.141593", "3.15",  "3.175", "3.2",
                "3.225", "3.25",  "3.275",    "3.3",   "3.325", "3.35",
                "3.375", "3.4",   "3.425",    "3.45",  "3.475", "3.5",
                "3.525", "3.55",  "3.575",    "3.6",   "3.625", "3.65",
                "3.675", "3.7",   "3.725",    "3.75",  "3.775", "3.8",
                "3.825", "3.85",  "3.875",    "3.9",   "3.925", "3.95",
                "3.975", 4,       "4.025",    "4.05",  "4.075", "4.1",
                "4.125", "4.15",  "4.175",    "4.2",   "4.225", "4.25",
                "4.275", "4.3",   "4.325",    "4.35",  "4.375", "4.4",
                "4.425", "4.45",  "4.475",    "4.5",   "4.525", "4.55",
                "4.575", "4.6",   "4.625",    "4.65",  "4.675", "4.7",
                "4.725", "4.75",  "4.775",    "4.8",   "4.825", "4.85",
                "4.875", "4.9",   "4.925",    "4.95",  "4.975", 5,
                "5.05",  "5.1",   "5.15",     "5.2",   "5.25",  "5.3",
                "5.35",  "5.4",   "5.45",     "5.5",   "5.55",  "5.6",
                "5.65",  "5.7",   "5.75",     "5.8",   "5.85",  "5.9",
                "5.95",  6,       "6.05",     "6.1",   "6.15",  "6.2",
                "6.25",  "6.3",   "6.35",     "6.4",   "6.45",  "6.5",
                "6.55",  "6.6",   "6.65",     "6.7",   "6.75",  "6.8",
                "6.85",  "6.9",   "6.95",     7,       "7.05",  "7.1",
                "7.15",  "7.2",   "7.25",     "7.3",   "7.35",  "7.4",
                "7.45",  "7.5",   "7.55",     "7.6",   "7.65",  "7.7",
                "7.75",  "7.8",   "7.85",     "7.9",   "7.95",  8,
                "8.05",  "8.1",   "8.15",     "8.2",   "8.25",  "8.3",
                "8.35",  "8.4",   "8.45",     "8.5",   "8.55",  "8.6",
                "8.65",  "8.7",   "8.75",     "8.8",   "8.85",  "8.9",
                "8.95",  9,       "9.05",     "9.1",   "9.15",  "9.2",
                "9.25",  "9.3",   "9.35",     "9.4",   "9.45",  "9.5",
                "9.55",  "9.6",   "9.65",     "9.7",   "9.75",  "9.8",
                "9.85",  "9.9",   "9.95",     "10.0",
            ],

        };
    }
);

1;
__END__

=head1 NAME

Math::SlideRule::PickettPocket - N 3P-ES pocket slide rule

=head1 SYNOPSIS

Approximate a N 3P-ES pocket slide rule (incomplete).

    use Math::SlideRule::PickettPocket;
    my $sr = Math::SlideRule::PickettPocket->new();

    $sr->divide(75, 92);
    $sr->multiply(-1.1, 2.2, -3.3, 4.4);
    ... (and etc. see Math::SlideRule)

=head1 DESCRIPTION

A Pickett Model N 3P-ES pocket slide rule implementation, at present
only of the A/B and C/D scales, as used by B<multiply> and other
such methods from the parent class. See L<Math::SlideRule> for
details on those.

=head1 ATTRIBUTES

=over 4

=item B<A>

Double decade scale from 1..100. Manually built via C<gena> script
present in the distribution of this module.

=item B<C>

Scale from 1..100. Manually built via C<genc> script present in the
distribution of this module. (Minus the "P" value marked on the scale,
as I do not not what that value is, nor what its exact value is.)

=back

=head1 METHODS

Nothing beyond present in L<Math::SlideRule>.

=head1 BUGS

=head2 Reporting Bugs

If the bug is in the latest version, send a report to the author.
Patches that fix problems or add new features are welcome.

L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Math-SlideRule>

L<https://github.com/thrig/Math-SlideRule>

=head2 Known Issues

No known issues. (But hardly anything is implemented, so that's probably
a big issue.)

=head1 AUTHOR

thrig - Jeremy Mates (cpan:JMATES) C<< <jmates at cpan.org> >>

=head1 LICENSE AND COPYRIGHT

Copyright Jeremy Mates

This program is distributed under the (Revised) BSD License:
L<https://opensource.org/licenses/BSD-3-Clause>

=cut
