use strict;
use warnings;
use 5.6.1;  
use ExtUtils::MakeMaker;


my $github    = 'https://github.com/saiftynet/SCAD';
my $name      = 'CAD::OpenSCAD';

WriteMakefile
(
    NAME         => $name,
    VERSION_FROM => 'lib/CAD/OpenSCAD.pm',
    AUTHOR       => 'Saif Ahmed <saiftynet { at } gmail.com>',
    ABSTRACT     => 'Module to generate 3D Objects as .scad (OpenSCAD) files from Perl',
    LICENSE      => 'Perl',
    PREREQ_PM    => {
        'Object::Pad'            => '0.801',
    },
    META_MERGE   => {
		'meta-spec' => { version => 2 },
		resources => {
			repository => {
				  type => 'git',
				  url  => $github,
				  web  => $github,
			},
			bugtracker => {
				web  => "$github/issues",
				},
			homepage => "$github/wiki",
			},
        provides => {
            'CAD::OpenSCAD::Math' => {file => 'lib/CAD/OpenSCAD/Math.pm',},
            'CAD::OpenSCAD::Loft' => {file => 'lib/CAD/OpenSCAD/Loft.pm',},
            'CAD::OpenSCAD::GearMaker' => {file => 'lib/CAD/OpenSCAD/GearMaker.pm',},
            },
	},
    BUILD_REQUIRES => {
		
    },
    TEST_REQUIRES => {
		'Test::Simple' => '0',
		},
);
