# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153918;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"433137", "Söding",
"437235", "Gallneukirchen",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"435273", "Matrei\ am\ Brenner",
"435285", "Mayrhofen",
"436228", "Faistenau",
"434273", "Reifnitz",
"433623", "Bad\ Mitterndorf",
"434285", "Tröpolach",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"437471", "Neustadtl\ an\ der\ Donau",
"437956", "Unterweissenbach",
"435577", "Lustenau",
"432748", "Kilb",
"435336", "Alpbach",
"437676", "Ottnang\ am\ Hausruck",
"432527", "Wulzeshofen",
"435632", "Stanzach",
"437682", "Vöcklamarkt",
"432289", "Matzen",
"432742", "St\.\ Pölten",
"434247", "Afritz",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"434761", "Stockenboi",
"436478", "Zederhaus",
"432142", "Gattendorf",
"437562", "Windischgarsten",
"433356", "Markt\ Allhau",
"437221", "Hörsching",
"432258", "Alland",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"432849", "Schwarzenau",
"432854", "Kirchberg\ am\ Walde",
"436472", "Mauterndorf",
"432252", "Baden",
"432784", "Perschling",
"435634", "Elbigenalp",
"437684", "Frankenmarkt",
"436224", "Hintersee",
"437260", "Waldhausen",
"433611", "Johnsbach",
"432744", "Kasten\ bei\ Böheimkirchen",
"433463", "Stainz",
"432525", "Gnadendorf",
"432823", "Grossglobnitz",
"435449", "Fliess",
"433135", "Kalsdorf\ bei\ Graz",
"435287", "Tux",
"434873", "St\.\ Jakob\ in\ Defereggen",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432176", "Tadten",
"435583", "Lech",
"435575", "Langen\ bei\ Bregenz",
"432915", "Drosendorf\-Zissersdorf",
"433327", "St\.\ Michael\ im\ Burgenland",
"436474", "Tamsweg",
"432852", "Gmünd",
"437213", "Bad\ Leonfelden",
"432782", "Herzogenburg",
"432249", "Gross\-Enzersdorf",
"432254", "Ebreichsdorf",
"432556", "Grosskrut",
"432858", "Moorbad\ Harbach",
"434245", "Feistritz\ an\ der\ Drau",
"432144", "Deutsch\ Jahrndorf",
"437564", "Hinterstoder",
"437266", "Bad\ Kreuzen",
"435245", "Hinterriss",
"434847", "Obertilliach",
"437288", "Ulrichsberg",
"435238", "Zirl",
"432160", "Jois",
"435375", "Kössen",
"434238", "Eisenkappel\-Vellach",
"432766", "Kleinzell",
"435673", "Ehrwald",
"437282", "Neufelden",
"435232", "Kematen\ in\ Tirol",
"437754", "Waldzell",
"432689", "Hornstein",
"432713", "Spitz",
"432623", "Pottendorf",
"436417", "Hüttschlag",
"433184", "Wolfsberg\ im\ Schwarzautal",
"434232", "Völkermarkt",
"437276", "Peuerbach",
"433473", "Straden",
"432986", "Irnfritz",
"433854", "Langenwang",
"433849", "Vordernberg",
"437711", "Suben",
"433148", "Kainach\ bei\ Voitsberg",
"435512", "Egg",
"436433", "Dorfgastein",
"437259", "Sierning",
"437244", "Sattledt",
"435518", "Mellau",
"432166", "Parndorf",
"433142", "Voitsberg",
"436136", "Gosau",
"434234", "Ruden",
"433182", "Wildon",
"437586", "Pettenbach",
"437752", "Ried\ im\ Innkreis",
"436415", "Schwarzach\ im\ Pongau",
"433176", "Stubenberg",
"437284", "Oberkappel",
"435234", "Axams",
"436468", "Werfen",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"433579", "Pöls",
"437758", "Obernberg\ am\ Inn",
"432946", "Pulkau",
"436241", "St\.\ Koloman",
"436462", "Bischofshofen",
"433858", "Mitterdorf\ im\ Mürztal",
"435263", "Silz",
"433144", "Köflach",
"436219", "Obertrum\ am\ See",
"433159", "Bad\ Gleichenberg",
"437723", "Altheim",
"437242", "Wels",
"437613", "Laakirchen",
"432649", "Mönichkirchen",
"434263", "Hüttenberg",
"433170", "Fischbach",
"437666", "Attersee",
"432735", "Hadersdorf\ am\ Kamp",
"433852", "Mürzzuschlag",
"435514", "Bezau",
"437248", "Grieskirchen",
"433572", "Judenburg",
"43662", "Salzburg",
"432533", "Neusiedl\ an\ der\ Zaya",
"433457", "Gleinstätten",
"437211", "Reichenau\ im\ Mühlkreis",
"433882", "Mariazell",
"433586", "Mühlen",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"432237", "Gaaden",
"433578", "Obdach",
"437445", "Hollenstein\ an\ der\ Ybbs",
"433637", "Gams\ bei\ Hieflau",
"432684", "Schützen\ am\ Gebirge",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"437759", "Antiesenhofen",
"437744", "Munderfing",
"433158", "St\.\ Anna\ am\ Aigen",
"432266", "Stockerau",
"433461", "Trahütten",
"433613", "Admont",
"433844", "Kammern\ im\ Liesingtal",
"433859", "Mürzsteg",
"432648", "Hochneukirchen",
"436212", "Seekirchen\ am\ Wallersee",
"433362", "Grosspetersdorf",
"434732", "Gmünd\ in\ Kärnten",
"433152", "Feldbach",
"432213", "Lassee",
"437487", "Gresten",
"432642", "Aspangberg\-St\.\ Peter",
"437249", "Bad\ Schallerbach",
"437254", "Grossraming",
"433333", "Sebersdorf",
"432682", "Eisenstadt",
"435239", "Kühtai",
"437742", "Mattighofen",
"437289", "Rohrbach\ in\ Oberösterreich",
"433635", "Radmer",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"437223", "Enns",
"432688", "Steinbrunn",
"432956", "Ziersdorf",
"433455", "Arnfels",
"437748", "Eggelsberg",
"433574", "Pusterwald",
"434716", "Lesachtal",
"432235", "Maria\-Lanzendorf",
"433884", "Wegscheid",
"432644", "Grimmenstein",
"434710", "Oberdrauburg",
"437252", "Steyr",
"432813", "Arbesbach",
"433364", "Hannersdorf",
"437473", "Blindenmarkt",
"434734", "Rennweg",
"437485", "Gaming",
"436214", "Henndorf\ am\ Wallersee",
"433149", "Geistthal",
"433848", "Eisenerz",
"434271", "Steuerberg",
"434353", "Prebl",
"437258", "Bad\ Hall",
"435519", "Schröcken",
"435353", "Waidring",
"433842", "Leoben",
"436563", "Uttendorf",
"432758", "Pöggstall",
"434826", "Mörtschach",
"437946", "Gutau",
"435442", "Landeck",
"432637", "Grünbach\ am\ Schneeberg",
"435522", "Feldkirch",
"433684", "St\.\ Martin\ am\ Grimming",
"436277", "St\.\ Pantaleon",
"432752", "Melk",
"432572", "Mistelbach",
"432284", "Oberweiden",
"437416", "Wieselburg",
"435448", "Pettneu\ am\ Arlberg",
"433533", "Turrach",
"432876", "Els",
"432248", "Markgrafneusiedl",
"434855", "Assling",
"434785", "Ausserfragant",
"437434", "Haag",
"432666", "Reichenau",
"437735", "Gaspoltshofen",
"435553", "Raggal",
"434257", "Fürnitz",
"432242", "St\.\ Andrä\-Wördern",
"436547", "Kaprun",
"432613", "Deutschkreutz",
"432859", "Brand\-Nagelberg",
"432844", "Karlstein\ an\ der\ Thaya",
"436243", "Abtenau",
"4314", "Vienna",
"432723", "Rabenstein\ an\ der\ Pielach",
"436456", "Obertauern",
"433688", "Tauplitz",
"432276", "Reidling",
"432749", "Prinzersdorf",
"432282", "Gänserndorf",
"432754", "Loosdorf",
"432574", "Gaweinstal",
"436229", "Hof\ bei\ Salzburg",
"437713", "Schardenberg",
"433682", "Stainach",
"435226", "Neustift\ im\ Stubaital",
"432635", "Neunkirchen",
"437766", "Andorf",
"433386", "Grosssteinbach",
"432288", "Auersthal",
"435524", "Satteins",
"435444", "Ischgl",
"434226", "St\.\ Margareten\ im\ Rosental",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"434220", "Köttmannsdorf",
"432259", "Münchendorf",
"432244", "Langenzersdorf",
"432842", "Waidhofen\ an\ der\ Thaya",
"433866", "Breitenau\ am\ Hochlantsch",
"436479", "Muhr",
"435255", "Umhausen",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"435476", "Serfaus",
"432711", "Dürnstein",
"437432", "Strengberg",
"432621", "Sieggraben",
"434255", "Arnoldstein",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"437283", "Sarleinsbach",
"433177", "Puch\ bei\ Weiz",
"432712", "Aggsbach",
"434769", "Möllbrücke",
"433339", "Friedberg",
"436137", "Strobl",
"432622", "Wiener\ Neustadt",
"437587", "Wartberg\ an\ der\ Krems",
"435678", "Weissenbach\ am\ Lech",
"437229", "Traun",
"434233", "Griffen",
"432765", "Kaumberg",
"432718", "Lichtenau\ im\ Waldviertel",
"435376", "Thiersee",
"432947", "Theras",
"432841", "Vitis",
"432628", "Felixdorf",
"435672", "Reutte",
"432165", "Hainburg\ a\.d\.\ Donau",
"437614", "Vorchdorf",
"434264", "Klein\ St\.\ Paul",
"435264", "Mieming",
"437724", "Mauerkirchen",
"437479", "Ardagger",
"433143", "Krottendorf",
"433472", "Mureck",
"434359", "Reichenfels",
"435359", "Hochfilzen",
"432985", "Gars\ am\ Kamp",
"437667", "St\.\ Georgen\ im\ Attergau",
"436432", "Bad\ Hofgastein",
"435513", "Hittisau",
"432767", "Hohenberg",
"435674", "Bichlbach",
"432945", "Zellerndorf",
"436463", "Annaberg\-Lungötz",
"432624", "Ebenfurth",
"437277", "Waizenkirchen",
"436416", "Lend",
"433175", "Anger",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"4313", "Vienna",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"437753", "Eberschwang",
"436135", "Bad\ Goisern",
"432714", "Rossatz",
"433853", "Spital\ am\ Semmering",
"437728", "Schwand\ im\ Innkreis",
"436434", "Bad\ Gastein",
"433619", "Oppenberg",
"434215", "Liebenfels",
"433474", "Deutsch\ Goritz",
"437618", "Neukirchen\,\ Altmünster",
"434268", "Friesach",
"437665", "Unterach\ am\ Attersee",
"432736", "Paudorf",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"435262", "Telfs",
"435441", "See",
"432167", "Neusiedl\ am\ See",
"437722", "Braunau\ am\ Inn",
"437612", "Gmunden",
"437243", "Marchtrenk",
"434262", "Treibach",
"432824", "Allentsteig",
"435278", "Navis",
"434278", "Gnesau",
"436223", "Anthering",
"437683", "Frankenburg\ am\ Hausruck",
"437719", "Taufkirchen\ an\ der\ Pram",
"437675", "Ampflwang\ im\ Hausruckwald",
"435633", "Hägerau",
"432743", "Böheimkirchen",
"435335", "Hopfgarten\ im\ Brixental",
"433464", "Gross\ St\.\ Florian",
"4315", "Vienna",
"437251", "Schiedlberg",
"437955", "Königswiesen",
"433326", "Stegersbach",
"434286", "Weissbriach",
"435272", "Steinach\ am\ Brenner",
"432177", "Podersdorf\ am\ See",
"435286", "Ginzling",
"433622", "Bad\ Aussee",
"434272", "Pörtschach\ am\ Wörther\ See",
"437236", "Pregarten",
"434874", "Virgen",
"437230", "Altenberg\ bei\ Linz",
"435280", "Hochfügen",
"433112", "Gleisdorf",
"432557", "Bernhardsthal",
"437214", "Reichenthal",
"436473", "Mariapfarr",
"432253", "Oberwaltersdorf",
"434846", "Abfaltersbach",
"433355", "Stadtschlaining",
"437267", "Mönchdorf",
"433118", "Sinabelkirchen",
"437563", "Spital\ am\ Pyhrn",
"432143", "Kittsee",
"433624", "Pichl\-Kainisch",
"432916", "Riegersburg\,\ Hardegg",
"434274", "Velden\ am\ Wörther\ See",
"435576", "Hohenems",
"432175", "Apetlon",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"434872", "Huben",
"433151", "Gnas",
"432828", "Rappottenstein",
"435582", "Klösterle",
"433136", "Dobl",
"432641", "Kirchberg\ am\ Wechsel",
"435274", "Gries\ am\ Brenner",
"432526", "Stronsdorf",
"434240", "Bad\ Kleinkirchheim",
"433462", "Deutschlandsberg",
"432822", "Zwettl\,\ Lower\ Austria",
"435337", "Brixlegg",
"433357", "Pinkafeld",
"437218", "Grosstraberg",
"435246", "Achenkirch",
"437265", "Pabneukirchen",
"434246", "Radenthein",
"435559", "Brand",
"432853", "Schrems",
"437212", "Zwettl\ an\ der\ Rodl",
"432783", "Traismauer",
"432619", "Lackendorf",
"432555", "Herrnbaumgarten",
"433571", "Möderbrugg",
"433114", "Markt\ Hartmannsdorf",
"432753", "Gansbach",
"432573", "Wilfersdorf",
"433469", "St\.\ Oswald\ im\ Freiland",
"437714", "Esternberg",
"432875", "Grafenschlag",
"433532", "Murau",
"437415", "Altenmarkt\,\ Yspertal",
"432829", "Schweiggers",
"432277", "Zwentendorf",
"436457", "Flachau",
"434879", "St\.\ Veit\ in\ Defereggen",
"434227", "Ferlach",
"433387", "Söchau",
"435443", "Galtür",
"435523", "Götzis",
"4346", "Klagenfurt",
"437767", "Eggerding",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"437241", "Steinerkirchen\ an\ der\ Traun",
"434825", "Grosskirchheim",
"432612", "Oberpullendorf",
"433867", "Pernegg\ an\ der\ Mur",
"432243", "Klosterneuburg",
"437219", "Vorderweissenbach",
"436461", "Dienten\ am\ Hochkönig",
"435558", "Gaschurn",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437357", "Kleinreifling",
"432722", "Kirchberg\ an\ der\ Pielach",
"432618", "Markt\ St\.\ Martin",
"437736", "Pram",
"432665", "Prein\ an\ der\ Rax",
"435552", "Bludenz",
"432728", "Wienerbruck",
"437751", "St\.\ Martin\ im\ Innkreis",
"435477", "Tösens",
"434225", "Grafenstein",
"435279", "St\.\ Jodok\ am\ Brenner",
"433683", "Donnersbach",
"433385", "Ilz",
"437765", "Lambrechten",
"432636", "Puchberg\ am\ Schneeberg",
"433141", "Hirschegg",
"437718", "Waldkirchen\ am\ Wesen",
"435225", "Fulpmes",
"434279", "Sirnitz",
"437947", "Kefermarkt",
"432877", "Grainbrunn",
"432275", "Atzenbrugg",
"432283", "Angern\ an\ der\ March",
"433534", "Stadl\ an\ der\ Mur",
"436276", "Nussdorf\ am\ Haunsberg",
"437712", "Schärding",
"436455", "Untertauern",
"434256", "Nötsch\ im\ Gailtal",
"435554", "Sonntag",
"437281", "Aigen\ im\ Mühlkreis",
"432667", "Schwarzau\ im\ Gebirge",
"434231", "Mittertrixen",
"437433", "Wallsee",
"435475", "Feichten",
"433516", "Kleinlobming",
"435256", "Untergurgl",
"433119", "St\.\ Marein\ bei\ Graz",
"436244", "Golling\ an\ der\ Salzach",
"432630", "Ternitz",
"433865", "Kindberg",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"437355", "Weyer",
"432614", "Kleinwarasdorf",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"432843", "Dobersberg",
"437224", "St\.\ Florian",
"432538", "Velm\-Götzendorf",
"433334", "Kaindorf",
"435418", "Schönwies",
"433585", "St\.\ Lambrecht",
"433573", "Fohnsdorf",
"432532", "Zistersdorf",
"433883", "Terz",
"434717", "Steinfeld",
"432957", "Hohenwarth",
"435412", "Imst",
"433618", "Hohentauern",
"436213", "Oberhofen\ am\ Irrsee",
"433153", "Riegersburg",
"437729", "Neukirchen\ an\ der\ Enknach",
"437474", "Euratsfeld",
"434733", "Malta",
"433363", "Rechnitz",
"432643", "Lichtenegg",
"434269", "Flattnitz",
"432212", "Orth\ an\ der\ Donau",
"432814", "Langschlag",
"437619", "Kirchham",
"4319", "Vienna",
"433612", "Liezen",
"436564", "Krimml",
"435354", "Fieberbrunn",
"434354", "Preitenegg",
"432265", "Hausleiten",
"433587", "Schönberg\-Lachtal",
"434768", "Kleblach\-Lind",
"433338", "Lafnitz",
"432236", "Mödling",
"434715", "Kötschach\-Mauthen",
"435414", "Wenns",
"436235", "Thalgau",
"437228", "Kematen\ an\ der\ Krems",
"432955", "Grossweikersdorf",
"433456", "Fresing",
"432534", "Niedersulz",
"437480", "Langau\,\ Gaming",
"436471", "Tweng",
"432683", "Purbach\ am\ Neusiedler\ See",
"432719", "Dross",
"434762", "Spittal\ an\ der\ Drau",
"433332", "Hartberg",
"437743", "Maria\ Schmolln",
"433124", "Gratkorn",
"433636", "Wildalpen",
"432629", "Warth\,\ Lower\ Austria",
"432865", "Litschau",
"434352", "Wolfsberg",
"433614", "Rottenmann",
"432741", "Flinsbach",
"437478", "Oed\-Oehling",
"435352", "St\.\ Johann\ in\ Tirol",
"436221", "Koppl",
"436562", "Mittersill",
"432267", "Sierndorf",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"434358", "St\.\ Andrä",
"432214", "Kopfstetten",
"437253", "Wolfern",
"437486", "Lunz\ am\ See",
"432812", "Gross\ Gerungs",
"437472", "Amstetten",
"432230", "Schwadorf",
"435358", "Ellmau",
"437954", "St\.\ Georgen\ am\ Walde",
"437949", "Rainbach\ im\ Mühlkreis",
"434277", "Glanegg",
"432913", "Hötzelsdorf",
"435585", "Dalaas",
"435573", "Hörbranz",
"433133", "Nestelbach",
"434875", "Matrei\ in\ Osttirol",
"432172", "Frauenkirchen",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"432825", "Göpfritz\ an\ der\ Wild",
"437674", "Attnang\-Puchheim",
"433465", "Pölfing\-Brunn",
"435334", "Westendorf",
"433354", "Bernstein",
"435243", "Maurach",
"434243", "Bodensdorf",
"437262", "Perg",
"432786", "Oberwölbling",
"432856", "Weitra",
"437215", "Hellmonsödt",
"436484", "Lessach",
"437268", "Grein",
"433117", "Eggersdorf\ bei\ Graz",
"432552", "Poysdorf",
"432772", "Neulengbach",
"437672", "Vöcklabruck",
"432279", "Kirchberg\ am\ Wagram",
"432827", "Schönbach",
"435332", "Wörgl",
"432746", "Wilhelmsburg",
"436226", "Fuschl\ am\ See",
"433467", "Schwanberg",
"434275", "Ebene\ Reichenau",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432174", "Wallern\ im\ Burgenland",
"435338", "Kundl",
"433323", "Eberau",
"436470", "Atzmannsdorf",
"437952", "Weitersfelden",
"437233", "Feldkirchen\ an\ der\ Donau",
"434229", "Krumpendorf\ am\ Wörther\ See",
"434877", "Prägraten\ am\ Grossvenediger",
"435275", "Trins",
"435283", "Kaltenbach",
"432231", "Purkersdorf",
"432554", "Stützenhofen",
"432774", "Innermanzing",
"432256", "Leobersdorf",
"433358", "Litzelsdorf",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433115", "Studenzen",
"434843", "Ausservillgraten",
"437264", "Windhaag\ bei\ Perg",
"432146", "Nickelsdorf",
"433352", "Oberwart",
"437566", "Rosenau\ am\ Hengstpass",
"433631", "Unterlaussa",
"432764", "Hainfeld",
"437588", "Ried\ im\ Traunkreis",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"437240", "Sipbachzell",
"435677", "Vils",
"436466", "Werfenweng",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432942", "Retz",
"436132", "Bad\ Ischl",
"432627", "Pitten",
"437274", "Alkoven",
"437582", "Kirchdorf\ an\ der\ Krems",
"436413", "Wagrain",
"433172", "Weiz",
"432948", "Weitersfeld",
"432717", "Unter\-Meisling",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432269", "Niederfellabrunn",
"437750", "Andrichsfurt",
"437662", "Seewalchen\ am\ Attersee",
"433856", "Veitsch",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432733", "Schönberg\ am\ Kamp",
"435212", "Seefeld\ in\ Tirol",
"432984", "Eggenburg",
"432164", "Rohrau",
"437615", "Scharnstein",
"434265", "Weitensfeld\ im\ Gurktal",
"435265", "Nassereith",
"437246", "Gunskirchen",
"432625", "Bad\ Sauerbrunn",
"435510", "Damüls",
"437286", "Lembach\ im\ Mühlkreis",
"435236", "Gries\ im\ Sellrain",
"433174", "Birkfeld",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"437584", "Molln",
"436134", "Hallstatt",
"437272", "Eferding",
"434236", "Eberndorf",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"435373", "Ebbs",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"432944", "Haugsdorf",
"435675", "Tannheim",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437278", "Neukirchen\ am\ Walde",
"432762", "Lilienfeld",
"436541", "Saalbach",
"437617", "Traunkirchen",
"432988", "Neupölla",
"434267", "Metnitz",
"432631", "Pöttsching",
"433146", "Modriach",
"432162", "Bruck\ an\ der\ Leitha",
"437727", "Ach",
"434230", "Globasnitz",
"432982", "Horn",
"435214", "Leutasch",
"432168", "Mannersdorf\ am\ Leithagebirge",
"433475", "Hürth",
"434214", "Brückl",
"435516", "Doren",
"435230", "Sellrain",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437664", "Weyregg\ am\ Attersee",
"432952", "Hollabrunn",
"433584", "Neumarkt\ in\ Steiermark",
"432233", "Pressbaum",
"435417", "Roppen",
"437250", "Maria\ Neustift",
"433453", "Ehrenhausen",
"436232", "Mondsee",
"432769", "Türnitz",
"434712", "Greifenburg",
"437225", "Hargelsberg",
"432958", "Maissau",
"437746", "Friedburg",
"433127", "Peggau",
"432686", "Drassburg",
"433335", "Pöllau",
"432672", "Berndorf",
"434718", "Dellach",
"437279", "Haibach\ ob\ der\ Donau",
"433633", "Landl",
"432989", "Brunn\ an\ der\ Wild",
"436565", "Neukirchen\ am\ Grossvenediger",
"435355", "Jochberg",
"434355", "Gemmersdorf",
"433617", "Gaishorn\ am\ See",
"432862", "Heidenreichstein",
"433846", "Kalwang",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"437256", "Ternberg",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437483", "Oberndorf\ an\ der\ Melk",
"437231", "Herzogsdorf",
"432815", "Grossschönau",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432674", "Weissenbach\ an\ der\ Triesting",
"437227", "Neuhofen\ an\ der\ Krems",
"433125", "Übelbach",
"433179", "Passail",
"433588", "Katsch\ an\ der\ Mur",
"437443", "Ybbsitz",
"433337", "Vorau",
"434767", "Rothenthurn",
"433886", "Weichselboden",
"434714", "Dellach\ im\ Drautal",
"436234", "Zell\ am\ Moos",
"433576", "Bretstein",
"432954", "Göllersdorf",
"433582", "Scheifling",
"432949", "Niederfladnitz",
"433150", "Paldau",
"432535", "Hohenau\ an\ der\ March",
"432215", "Probstdorf",
"437477", "St\.\ Peter\ in\ der\ Au",
"436216", "Neumarkt\ am\ Wallersee",
"432268", "Grossmugl",
"434736", "Innerkrems",
"433366", "Kohfidisch",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432864", "Kautzen",
"435357", "Kirchberg\ in\ Tirol",
"432262", "Korneuburg",
"433615", "Trieben",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432278", "Absdorf",
"437762", "Raab",
"433686", "Haus",
"436458", "Hüttau",
"43512", "Innsbruck",
"434824", "Heiligenblut",
"433382", "Fürstenfeld",
"432633", "Markt\ Piesting",
"437944", "Sandl",
"435339", "Wildschönau",
"432272", "Tulln\ an\ der\ Donau",
"432874", "Martinsberg",
"436452", "Radstadt",
"434228", "Feistritz\ im\ Rosental",
"437414", "Weins\-Isperdorf",
"432286", "Obersiebenbrunn",
"433537", "St\.\ Georgen\ ob\ Murau",
"435557", "St\.\ Gallenkirch",
"434253", "St\.\ Jakob\ im\ Rosental",
"435472", "Prutz",
"432664", "Semmering",
"435253", "Längenfeld",
"433868", "Tragöss",
"433513", "Bischoffeld",
"433359", "Loipersdorf\-Kitzladen",
"436247", "Grossgmain",
"432617", "Drassmarkt",
"432846", "Raabs\ an\ der\ Thaya",
"436543", "Taxenbach",
"433862", "Bruck\ an\ der\ Mur",
"433680", "Donnersbachwald",
"436583", "Leogang",
"437412", "Ybbs\ an\ der\ Donau",
"432576", "Ernstbrunn",
"432756", "St\.\ Leonhard\ am\ Forst",
"437948", "Hirschbach\ im\ Mühlkreis",
"437717", "St\.\ Aegidi",
"432274", "Sieghartskirchen",
"433833", "Traboch",
"433535", "Krakaudorf",
"432872", "Ottenschlag",
"436454", "Mandling",
"432731", "Idolsberg",
"435446", "St\.\ Anton\ am\ Arlberg",
"434224", "Pischeldorf",
"435526", "Laterns",
"434822", "Winklern",
"437942", "Freistadt",
"437764", "Riedau",
"432878", "Traunstein",
"435224", "Wattens",
"436245", "Hallein",
"433864", "St\.\ Marein\ im\ Mürztal",
"432246", "Gerasdorf\ bei\ Wien",
"432725", "Frankenfels",
"43316", "Graz",
"432615", "Lutzmannsburg",
"437733", "Neumarkt\ im\ Hausruckkreis",
"434853", "Ainet",
"437269", "Baumgartenberg",
"434783", "Reisseck",
"435474", "Pfunds",
"432662", "Gloggnitz",
"436133", "Ebensee",
"436412", "St\.\ Johann\ im\ Pongau",
"437583", "Kremsmünster",
"437755", "Mettmach",
"4316", "Vienna",
"434237", "Miklauzhof",
"437287", "Peilstein\ im\ Mühlviertel",
"433173", "Ratten",
"433185", "Preding",
"436418", "Kleinarl",
"435374", "Walchsee",
"432943", "Obritz",
"437941", "Neumarkt\ im\ Mühlkreis",
"437245", "Lambach",
"435266", "Ötztal\-Bahnhof",
"433147", "Salla",
"432738", "Fels\ am\ Wagram",
"434266", "Strassburg",
"437616", "Grünau\ im\ Almtal",
"434213", "Launsdorf",
"437663", "Steinbach\ am\ Attersee",
"435517", "Riezlern",
"433855", "Krieglach",
"432732", "Krems\ an\ der\ Donau",
"435213", "Scharnitz",
"432239", "Breitenfurt\ bei\ Wien",
"435372", "Kufstein",
"436467", "Mühlbach\ am\ Hochkönig",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"435676", "Jungholz",
"433861", "Aflenz",
"437757", "Gurten",
"432716", "Gföhl",
"434235", "Bleiburg",
"436414", "Grossarl",
"437273", "Aschach\ an\ der\ Donau",
"437285", "Hofkirchen\ im\ Mühlkreis",
"432626", "Mattersburg",
"432734", "Langenlois",
"435515", "Au",
"432620", "Willendorf",
"432983", "Sigmundsherberg",
"432271", "Ried\ am\ Riederberg",
"433476", "Bad\ Radkersburg",
"433857", "Neuberg\ an\ der\ Mürz",
"437247", "Kematen\ am\ Innbach",
"433145", "Edelschrott",
"437489", "Purgstall\ an\ der\ Erlauf",
"432163", "Petronell\-Carnuntum",
"434221", "Gallizien",
"432522", "Laa\ an\ der\ Thaya",
"436227", "St\.\ Gilgen",
"433466", "Eibiswald",
"435578", "Höchst",
"432747", "Ober\-Grafendorf",
"436589", "Unken",
"432826", "Rastenfeld",
"4312", "Vienna",
"434876", "Kals\ am\ Grossglockner",
"432912", "Geras",
"435284", "Gerlos",
"437234", "Ottensheim",
"435572", "Dornbirn",
"433132", "Kumberg",
"434284", "Kirchbach",
"43732", "Linz",
"433324", "Strem",
"432173", "Gols",
"436477", "St\.\ Michael\ im\ Lungau",
"435248", "Steinberg\ am\ Rofan",
"432257", "Klausen\-Leopoldsdorf",
"437216", "Helfenberg",
"434248", "Treffen",
"432855", "Waldenstein",
"433581", "Oberwölz",
"432773", "Eichgraben",
"432147", "Zurndorf",
"435242", "Schwaz",
"434242", "Villach",
"433460", "Soboth",
"437263", "Bad\ Zell",
"434282", "Hermagor",
"435276", "Gschnitz",
"433134", "Heiligenkreuz\ am\ Waasen",
"433322", "Güssing",
"432639", "Bad\ Fischau",
"437953", "Liebenau",
"435574", "Bregenz",
"432914", "Japons",
"435282", "Zell\ am\ Ziller",
"434276", "Feldkirchen\ in\ Kärnten",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"437673", "Schwanenstadt",
"435635", "Elmen",
"4318", "Vienna",
"436225", "Eugendorf",
"433328", "Kukmirn",
"432745", "Pyhra",
"435333", "Söll",
"432524", "Kautendorf",
"435288", "Fügen",
"437238", "Mauthausen",
"434244", "Bad\ Bleiberg",
"434842", "Sillian",
"437565", "St\.\ Pankraz",
"432145", "Prellenkirchen",
"433353", "Oberschützen",
"435244", "Jenbach",
"436483", "Göriach",
"433116", "Kirchbach\ in\ Steiermark",
"436475", "Ramingstein",
"432255", "Deutsch\ Brodersdorf",
"434848", "Kartitsch",
"432951", "Guntersdorf",
"432857", "Bad\ Grosspertholz",
"436549", "Piesendorf",
"433834", "Wald\ am\ Schoberpass",
"432273", "Tulbing",
"432285", "Marchegg",
"436453", "Filzmoos",
"432577", "Asparn\ an\ der\ Zaya",
"436272", "Oberndorf\ bei\ Salzburg",
"432757", "Pöchlarn",
"437716", "Münzkirchen",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432638", "Winzendorf\-Muthmannsdorf",
"433329", "Jennersdorf",
"437763", "Kopfing\ im\ Innkreis",
"435223", "Hall\ in\ Tirol",
"437239", "Lichtenberg",
"436278", "Ostermiething",
"434223", "Maria\ Saal",
"433685", "Gröbming",
"435289", "Häusling",
"435447", "Flirsch",
"432632", "Pernitz",
"433383", "Burgau",
"437353", "Gaflenz",
"4317", "Vienna",
"432845", "Weikertschlag\ an\ der\ Thaya",
"434258", "Gummern",
"433863", "Turnau",
"436542", "Zell\ am\ See",
"432247", "Deutsch\-Wagram",
"434252", "Wernberg",
"435473", "Nauders",
"437435", "St\.\ Valentin",
"434784", "Mallnitz",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"436548", "Niedernsill",
"433512", "Knittelfeld",
"435252", "Oetz",
"436588", "Lofer",
"435579", "Alberschwende",
"437943", "Windhaag\ bei\ Freistadt",
"432634", "Gutenstein",
"436240", "Krispl",
"434823", "Tresdorf\,\ Rangersdorf",
"433687", "Schladming",
"435525", "Nenzing",
"432610", "Horitschon",
"435445", "Kappl",
"437413", "Marbach\ an\ der\ Donau",
"432287", "Strasshof\ an\ der\ Nordbahn",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"433536", "St\.\ Peter\ am\ Kammersberg",
"436274", "Lamprechtshausen",
"435550", "Thüringen",
"433832", "Kraubath\ an\ der\ Mur",
"432755", "Mank",
"432575", "Ladendorf",
"432873", "Kottes",
"433514", "Seckau",
"435254", "Sölden",
"437732", "Haag\ am\ Hausruck",
"436131", "Obertraun",
"434852", "Lienz",
"433171", "Gasen",
"435556", "Schruns",
"432663", "Schottwien",
"434782", "Obervellach",
"434254", "Faak\ am\ See",
"436544", "Rauris",
"432616", "Lockenhaus",
"432847", "Gross\-Siegharts",
"432726", "Puchenstuben",
"434858", "Nikolsdorf",
"432245", "Wolkersdorf\ im\ Weinviertel",
"436246", "Grödig",
"437444", "Opponitz",
"432238", "Kaltenleutgeben",
"433336", "Waldbach",
"434766", "Millstatt",
"432685", "Rust",
"432673", "Altenmarkt\ an\ der\ Triesting",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"437745", "Lochen",
"433632", "St\.\ Gallen",
"437226", "Wilhering",
"432953", "Nappersdorf",
"432232", "Fischamend",
"433577", "Zeltweg",
"433638", "Palfau",
"436233", "Oberwang",
"433452", "Leibnitz",
"434713", "Techendorf",
"432816", "Karlstift",
"437482", "Scheibbs",
"432647", "Krumbach\,\ Lower\ Austria",
"436217", "Mattsee",
"433157", "Kapfenstein",
"437476", "Aschbach\-Markt",
"437255", "Losenstein",
"437488", "Steinakirchen\ am\ Forst",
"435331", "Brandenberg",
"433845", "Mautern\ in\ Steiermark",
"434356", "Lavamünd",
"435356", "Kitzbühel",
"432863", "Eggern",
"436566", "Bramberg\ am\ Wildkogel",
"432536", "Drösing",
"433454", "Leutschach",
"437448", "Kematen\ an\ der\ Ybbs",
"433583", "Unzmarkt",
"433575", "St\.\ Johann\ am\ Tauern",
"433885", "Greith",
"432234", "Gramatneusiedl",
"433634", "Hieflau",
"433126", "Frohnleiten",
"437442", "Waidhofen\ an\ der\ Ybbs",
"437261", "Schönau\ im\ Mühlkreis",
"432687", "Siegendorf",
"437747", "Kirchberg\ bei\ Mattighofen",
"433616", "Selzthal",
"432263", "Grossrussbach",
"433847", "Trofaiach",
"432739", "Tiefenfucha",
"432645", "Wiesmath",
"433155", "Fehring",
"437484", "Göstling\ an\ der\ Ybbs",
"433365", "Deutsch\ Schützen\-Eisenberg",
"434735", "Kremsbrücke",
"436215", "Strasswalchen",
"437257", "Grünburg",
"432216", "Leopoldsdorf\ im\ Marchfelde",};
$areanames{de} = {"437232", "Sankt\ Martin\ im\ Mühlkreis",
"4318", "Wien",
"437565", "Sankt\ Pankraz",
"432857", "Bad\ Großpertholz",
"436227", "Sankt\ Gilgen",
"4312", "Wien",
"434876", "Kals\ am\ Großglockner",
"436477", "Sankt\ Michael\ im\ Lungau",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"436414", "Großarl",
"4316", "Wien",
"436412", "Sankt\ Johann\ im\ Pongau",
"434266", "Straßburg",
"433575", "Sankt\ Johann\ am\ Tauern",
"432263", "Großrußbach",
"436215", "Straßwalchen",
"433632", "Sankt\ Gallen",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"432647", "Krumbach\,\ Niederösterreich",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"432847", "Groß\-Siegharts",
"433834", "Wald\ am\ Schoberpaß",
"4317", "Wien",
"437435", "Sankt\ Valentin",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"434877", "Prägraten\ am\ Großvenediger",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"434843", "Außervillgraten",
"437566", "Rosenau\ am\ Hengstpaß",
"437954", "Sankt\ Georgen\ am\ Walde",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437717", "Sankt\ Aegidi",
"435446", "Sankt\ Anton\ am\ Arlberg",
"433864", "Sankt\ Marein\ im\ Mürztal",
"434783", "Reißeck",
"433537", "Sankt\ Georgen\ ob\ Murau",
"434253", "Sankt\ Jakob\ im\ Rosental",
"435557", "Sankt\ Gallenkirch",
"433868", "Tragöß",
"436247", "Großgmain",
"432617", "Draßmarkt",
"432674", "Weißenbach\ an\ der\ Triesting",
"432268", "Großmugl",
"437477", "Sankt\ Peter\ in\ der\ Au",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"432233", "Preßbaum",
"432686", "Draßburg",
"436565", "Neukirchen\ am\ Großvenediger",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"432815", "Großschönau",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432822", "Zwettl\-Niederösterreich",
"437218", "Großtraberg",
"433464", "Groß\ Sankt\ Florian",
"4315", "Wien",
"434286", "Weißbriach",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"4313", "Wien",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"435678", "Weißenbach\ am\ Lech",
"434264", "Klein\ Sankt\ Paul",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432955", "Großweikersdorf",
"432719", "Droß",
"432629", "Warth\,\ Niederösterreich",
"435352", "Sankt\ Johann\ in\ Tirol",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432812", "Groß\ Gerungs",
"434358", "Sankt\ Andrä",
"437224", "Sankt\ Florian",
"433585", "Sankt\ Lambrecht",
"4319", "Wien",
"435279", "Sankt\ Jodok\ am\ Brenner",
"436276", "Nußdorf\ am\ Haunsberg",
"433119", "Sankt\ Marein\ bei\ Graz",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"433469", "Sankt\ Oswald\ im\ Freiland",
"434879", "Sankt\ Veit\ in\ Defereggen",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"434825", "Großkirchheim",
"437219", "Vorderweißenbach",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"432618", "Markt\ Sankt\ Martin",
"437751", "Sankt\ Martin\ im\ Innkreis",
"436241", "Sankt\ Koloman",
"432823", "Großglobnitz",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"435449", "Fließ",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432249", "Groß\-Enzersdorf",
"432556", "Großkrut",
"435245", "Hinterriß",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"437956", "Unterweißenbach",
"432742", "Sankt\ Pölten",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"434226", "Sankt\ Margareten\ im\ Rosental",
"433386", "Großsteinbach",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"433684", "Sankt\ Martin\ am\ Grimming",
"436277", "Sankt\ Pantaleon",
"434785", "Außerfragant",
"432242", "Sankt\ Andrä\-Wördern",
"4314", "Wien",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"433158", "Sankt\ Anna\ am\ Aigen",
"433362", "Großpetersdorf",
"437254", "Großraming",
"432642", "Aspangberg\-Sankt\ Peter",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;