use strict;
use warnings;
use Test::More tests => 68;
use Digest::EdonR qw(edonr_384 edonr_384_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::EdonR->new(384)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            edonr_384_hex($data), $digest,
            "edonr_384_hex: $len bits of $msg"
        );
        ok(
            edonr_384($data) eq pack('H*', $digest),
            "edonr_384: $len bits of $msg"
        );
    }

    my $md = Digest::EdonR->new(384)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|CCD8E612B93A3F8C24867EB204C1DC3F2DE24BD54D92908C5F5A73C6A4DA14C8742A5FC3A6B5428658E85F0175DE95A7
00|B3EAF33E83C86633057C0ADFD2CDCB05DA72A43F6304F33EB4B2F253E180C30A71A80CE406D3D7EDF58BDB9D62D5C98B
C0|8FBAFCD648C2FD4F1F5591AAF684CF0617054159E61D7CB56FFBF1C65C48EB6F3BE75C0B8EF6265660150836688E6887
C0|16A38957EE2E7484D5B218B41284CB8FF6ECA795480414F883CD3A615D23516E42BD24A45E37E1C0ADEECF59FA1C29AE
80|5830768288FEF2C0B50EF5F41A0652D739C4D0A4740F530FC0FB7FF6A9D7FEA94E3DEEBFDC9631BC72A331DAB649F8D8
48|6E49F54F7033CE9A5ACCC41DC856DDD7D2F583C518CEE4DA072274776613D2C32271E9B853A70E1AE28130FF28C1D365
50|1F7DCD499CFCBE108C45AC21E5BD279BC71174C88EBA194FDD6E9C73363264BFCE4F827B551412B74864191EB5C7AC59
98|4120DEADABA8B5608768E3042F7FCD28A775E659C8964AB886D00171FE344DFFC11A950FBD7D19CFDF9F678ABDEB14A8
CC|4F52ECA66E41E613F76DFC7F15F1F56E444AD3192231A3BEC1F371568A1CA2C58EE5467881E45BABF43F343C5CB80B48
9800|8A31F859DDD3C20FC36CCAEC95CFE2B3A00002D042D7BF3BF3BA5103C88FF7ED8DC85C0562BF0181009F5C27D22BE96A
9D40|F3BD30F536897469210023250E1DBAE84D9594A461641EF2EDEF57B1B0369E5895DA86DE47A99AA9B55CA7A09C86D50F
AA80|ED059C23B24EA2635B2B56D4FF9A0CB891A41495DA4094E8CBDEA3E368362777A853CB3203F81E17A2B437E071B55A60
9830|DB9B2B03000135B01AF33BF96D062FA407BF34A008AAF81492B716AE1317BBADD5E58A31C4BE82764DF042D0E08ADB5D
5030|DC0E1FD0E18CBDA7566804269FCCDAA94F0D3D56E8E3C4D9CDE5FAA95D474CE1CD09D89264A1C3E781144203F499C30A
4D24|705ECBAB05F2F7DCFD7697AC60ABE98F0BFF03287D57588DB3EB7A167B94B0DE0683F244123AE244985436435CDCD7B1
CBDE|EFDB4EC03163B2906D01CD579167C37000C671701166A26838FB8C643C6F0D0B654037A8144F1FDD0DDF913D142AD3B4
41FB|7DCAD82164AF489480DE27B1B9F3C5C171456835FDC975982F9F94DB26E0206A635B1698B31C9857C0051DA0BED84BAE
4FF400|1EAC6A37DABD2A8E8748D5F5EF5CDCCAE79B70A491A538FA7DCA0250D75111484B80F37BD664AC7474FD0DB723EEFB90
FD0440|EB08FD8D88E90B9F9882BDA6A515122363A4C501B9E6178B85BCE2661EAAD436EAC8FCE1A306832A11D654A94A8084B4
424D00|3557D9D7C393F03E50D4E3DBE40A47A84D92E59F082059EDC7F8297E0FEE20911A4397A6AF896CFC5200D8035C3FE2C2
3FDEE0|ADDF73F2236671BBF6307AB50A416E1F51952D37BD72D26C2CC99ABD732FFDF24E8657AB17038603D4D12E93B1EAD69E
335768|0CD6D14CB99119EDAF889CBA074627FB4CF90CE6A8285837CFFB7B94ED8522B55120B5AE9B59C04B33FCD5E46093FA66
051E7C|3027295DF56B7F5FBCFBEB0096DA7BA981E1E61545846F1C455654357604EDDF398DE01F13BC3D849F49C9BFDE00AB56
717F8C|4DF03DE7F5CDDFFD81484A06198CB87899C45A6586117511541464BB669B5B6E51D546325C67C4980DE4BD9DF3280498
1F877C|18A9ECA72769A9DBB5A627CFE94C67313E564DF4EC354750CF5D1202C08B3B31866DF240C575D51BD0E12C6A212182A6
EB35CF80|DB011B6446F038160BA4EBC7555A3EFA38D9A910102FEB756AB69B63B66508D367DF3F2F4599B3E4D080FFAE73E40304
B406C480|F93E647A8D5DBB270277C2EAF6795D592BF0871A901A44F7C6AF429C212D69A1CEF36EA052C5CEB404330330790B520B
CEE88040|CCA4AEE202299099808905FEC884296D18A63B2EA98C38FCDF8C6E67A6458AD7201BFA094C2785B809F6F1AE94D9BB76
C584DB70|76D1FED6ACFE687DF074AD808C196DF491141A6FC34E737ADF83051931DD6ECAFD139D4D96C681D2206BCCBD5008B5AD
53587BC8|EF9B5457AFC2E0161F69061E22642689636A759982A681384AD932559092CEBFCE3C8CE4C57FD1BBB4F78CE6FF59CF01
69A305B0|0DFC6DB0ADBF3DB1F1DFDAE27F9E9042B5B4C8057C2C662661DFFA7C519EADC651852FEEE748CF21AD79CD40C6395420
C9375ECE|7B8318EA2769ACF0B66A4A9C9FFF0942FFC5A2BDDC6B1F011C2E37AF29D2FD29DAE671FB53AD241491A345DFF2AF8D7D
C1ECFDFC|EA2D04CD18645DCF9EADCF46211CEAAADBE687C0E8856C9FD53C4F0CB692BF1175021A3238BDFE66AB8CD6083C1B742F
8D73E8A280|8DCFB1BA0E2B2A48085C8374C9B71148166E7154FB6EBD76CD9FDF9DB618CC41447FA969894346060A8821DB8895484F
06F2522080|3FA24920AA47E9A547FF163C5D92C876D565AC1E47CEC4C5BF3BBE727F298EDC5C62219977A810C6C7F6E9AAB278B15F
3EF6C36F20|FAD62B640FFF9C7A968CB3D9AF4E0C093550F6F9B4398E28B8ACCEE59D63EC98F8F713EE32D6ED01119CEDA680E90725
0127A1D340|ABA55E8C76BDF200316979423A7E80C82C5DAE1F1A619A7AA336583C2A949D18E39BE80FC0316A091759AD0BF6D5F718
6A6AB6C210|5E0AC98FC39C494B34E665F10661F708EDF003673C305AF2B5932974456D02F0CFC72C50C8223EE823DF6DF963C0303C
AF3175E160|60D467A9DF3FE98E9F1B1D9986E51E03D78ABE4CEA50C4643393793B3C2F4576A5CCC307F0EF60DED61E5BB6F9C25F0C
B66609ED86|0154C3706359267F380132CAFA3C85282E9F486C894E14CCBF6CB71D87BF6FDEA20ED9E87346F8F80E2369721F67C98C
21F134AC57|0939490500619A6F74EE0025C9BE3C7A47AE2800E961958F51D43D98A5B0D40749804978ADB35CAD01119E01BC431A1F
3DC2AADFFC80|62AD8CC3E161A5249EBD078A3D1E18BF7875DEDCF2DDCAAFC76B2AC546E96819A76BB5E7B4FB8208D5ABEC9E60945707
9202736D2240|53E66246E60C2E646CC16FC34D240BD7CD7CFA2E78E19F7758489927B5C92C0824EBD874D810842AB395B94BF8B2E9DB
F219BD629820|88ED5B2BC2130D116495DDC9AA9152FB2D24688B3F7EE047C5FFD82C9D8FE53BFFE7BDE6F97A9F0BB83FA2AD0B514B17
F3511EE2C4B0|8C0B3BD2520365132A2FD8D2B1E0F616A2D8D9025E1234AF19D65F99D368E9C05135683B82C45AE7A43170D1B4F294D8
3ECAB6BF7720|C2E31268D208C7EE51221BFDD19E358A872CEC854262561DE7131B08892829E7F942BC2D88560E9CCFDE64F334773090
CD62F688F498|4DDCB5A7CA8FE962CBEEA751D338AE308C8DDB6603BF7B0802B0C04B39261479670492A42849FE7AB9E5BCD7C31CED40
C2CBAA33A9F8|1006BC0942CF29F2CF40E1FA811CD05374E779F9792275A5F5779550529E1F580393D7C9F601C611159188B39FDFB536
C6F50BB74E29|785F8102E922AAAFB4A15F3CCF2D2C4CD7B718E5F9A5F8FF04E5A35EA8F3E768D11C6F4E60C18437071D892D9DD206E2
79F1B4CCC62A00|1C2CAF41F3A45E5B0357F1F57BB782024EE23F7141DB5B4544EF35730F49967463A507A86A93CBEC02B464ADC85F2BE5
