/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.util.LangUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleSheetListImpl
implements StyleSheetList {
    private List<CSSStyleSheet> cssStyleSheets_;

    public List<CSSStyleSheet> getCSSStyleSheets() {
        if (this.cssStyleSheets_ == null) {
            this.cssStyleSheets_ = new ArrayList<CSSStyleSheet>();
        }
        return this.cssStyleSheets_;
    }

    public void setCSSStyleSheets(List<CSSStyleSheet> cssStyleSheets) {
        this.cssStyleSheets_ = cssStyleSheets;
    }

    @Override
    public int getLength() {
        return this.getCSSStyleSheets().size();
    }

    @Override
    public StyleSheet item(int index) {
        return this.getCSSStyleSheets().get(index);
    }

    public void add(CSSStyleSheet cssStyleSheet) {
        this.getCSSStyleSheets().add(cssStyleSheet);
    }

    public StyleSheet merge() {
        CSSStyleSheetImpl merged = new CSSStyleSheetImpl();
        CSSRuleListImpl cssRuleList = new CSSRuleListImpl();
        for (CSSStyleSheetImpl cSSStyleSheetImpl : this.getCSSStyleSheets()) {
            CSSMediaRuleImpl cssMediaRule = new CSSMediaRuleImpl(merged, null, cSSStyleSheetImpl.getMedia());
            cssMediaRule.setRuleList((CSSRuleListImpl)cSSStyleSheetImpl.getCssRules());
            cssRuleList.add(cssMediaRule);
        }
        merged.setCssRules(cssRuleList);
        merged.setMediaText("all");
        return merged;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StyleSheetList)) {
            return false;
        }
        StyleSheetList ssl = (StyleSheetList)obj;
        return this.equalsStyleSheets(ssl);
    }

    private boolean equalsStyleSheets(StyleSheetList ssl) {
        if (ssl == null || this.getLength() != ssl.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            StyleSheet styleSheet2;
            StyleSheet styleSheet1 = this.item(i);
            if (LangUtils.equals(styleSheet1, styleSheet2 = ssl.item(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.cssStyleSheets_);
        return hash;
    }
}

