use strict;
use warnings;
use Test::More;
use Digest::Groestl qw(groestl_256 groestl_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Groestl->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            groestl_256_hex($data), $digest,
            "groestl_256_hex: $len bits of $msg"
        );
        ok(
            groestl_256($data) eq pack('H*', $digest),
            "groestl_256: $len bits of $msg"
        );
    }

    my $md = Digest::Groestl->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|1a52d11d550039be16107f9c58db9ebcc417f16f736adb2502567119f0083467
00|de84b8979d9a7cdf4f6f7dc32f3da0bb6329f54e8c3754bc7fb44d86375a8e3b
C0|8c1cbe515a88c083c1c3c186954482f5aacb65799b95f2b3f6abb37a75b64e7b
C0|175fe52f16fb7babe367efc7e7bf0948b798dd117f8f707d726bd6efb9bbf239
80|bf12527e830ef0202c590e8ad0a239596ed9eeff1c2a03e2f3ebb59503ff2261
48|f0b8bceb19a1964e8a563403d2c41aefc2c6cf067998665a01494fbcc2141c15
50|176028217d574f9f7107946e249eae805f7dfd78f4c7ade78f63c8e6d6318f99
98|637da31b34a9e44b8aff31044d550a8d18b1ecede65ecc19089388fcc6a050ed
CC|15e2671f0eaf66c0de3093ab7b1e39dc68f945d7002fc5dfd52d60527e7228d1
9800|6588fb7812b1866ea53180266c49210827ab749193ed07be100c20546e98949e
9D40|bb20613cbbfbea1d547b621d509c88b9b88016e68b314a0436694e2b8708a1d6
AA80|973a0066beee283612a010edf316a58b119f536d04116a496f9b1b76979aec7f
9830|e7ea7d323d0bc3b7043e3857257c953aee3bd56d071f5cd69acf31e6d42e364e
5030|7b391962f7eb3c29ef37e0982fa1276020b62d9da5c9d3ba8923e631de652a65
4D24|366c51d8e27b38efede8b8c78e00926f08a31d804887cf74a4763620f33222ff
CBDE|d33d390c8eda24a0dbfc2fe3238c5ad2f4bfc974418d283b27519bac2d0c0012
41FB|846f1c22fc62b770de1782ef33414aa5baa44b690ebfb7d1bdcca8d2ac59c929
4FF400|2b894e32706adc1e21a554d3ad672b55da2b08f22c46277b796cb7deb3fde8fa
FD0440|4788aeb4b1c4da435bd8ef1272c3aecff62ceeedb24cb7748d5ae0781437bfb2
424D00|bafce1ca83a2c448ea035ffc601b0395c06abcce30083b7575d812b7e9523e61
3FDEE0|a4a9d589f60a42a819abba1f995c31c930bee6fb0d38951c02d74f4edb307734
335768|9593ae02aea483b60f25cd6370cbaeaed970f06d0ba2121854fec4e70c104de4
051E7C|ee38fe7e54eb46a0da4d61cb651f683de93270f9659f28ff0bfe5f3848aaba48
717F8C|c9d5a058a4ef918c98204892682f308010e71e7850833e0899e25dfb89152a55
1F877C|05fe7de2d8ce1770df766739f788037d0cf2ca7c2b7620835cc34f45b3fcf919
EB35CF80|7ed246fafbe421ea448e4b48818638ad49e66df4f329bef4f2465bde54f63429
B406C480|f60576e4967c708088cd8bf6c4309bddf0437d696e021648fb2decf5dfa53ebd
CEE88040|bc818f2d8152c3ceba6f08ed1bf915212cf1e8defef8c8af199ba022a5cdc53c
C584DB70|1bfd2285719a45c3ed100d96452553343239edd4a81a0270582a2abea305afa4
53587BC8|4d7329556c2ff5f1b81b17c1934bfa88a76851cc480e513e8d7c3d52ec9fbb4e
69A305B0|fffbae6c1551f17eb14b41aa6f872fe4f2742315a2ea4956e87de4648368f2ed
C9375ECE|1245cd57a239106cd7acf919fb9ce9d306f53a79ee5dd27f3cedd94671453ad4
C1ECFDFC|b5efd33ac395b5b003d7fbdde66197ae4ee6da86946f808f0f1f867f77c53fc8
8D73E8A280|84bfcd54db758efbc77a71a4d119dac60d0f2acfaf6995723cfd500b124b962e
06F2522080|934e7de031c6ec52476c65392c4915f3efe3c728ccbbb4153b8511d2522553f3
3EF6C36F20|5ff36bf9583127cff4b0fb70108611d07ff7b275456335ecff1a7aff7b07c081
0127A1D340|5829d8e11a2232b0140d01fa13f21162ac5189eefdb20e9fffb0d87f21dd7440
6A6AB6C210|c7d44a2bc21433255fcc691158cbf1baded56439666d36b7579b39e93061aa83
AF3175E160|ed49029d7795d0165e60db71b7d05401cc516018b0dcd91600b37bf863381ffa
B66609ED86|482970c71264d86f468615d1780c16a171a3956a4dfa804c270c5df3ea9beb9d
21F134AC57|ad5daa1673e9a9e476a843b12d39de4992ec9aa15fcf33ae094ba5aae6764742
3DC2AADFFC80|b2d55f6a690e0bdb683736b39c9c97dc369a19460f3ea5d136e7c9d4f3a98698
9202736D2240|2e4cf78c91be9ad70602d02acb8b899724f59315d49e4f9b2b7906979ac20796
F219BD629820|be7bf3501a6653e24d2e0edd7e306ceaa03097408f82850911f09e69e1c6972b
F3511EE2C4B0|17011d1e7967493f0c00608a4b787f26fe199f6a56375889e1d9aceae92c9612
3ECAB6BF7720|a7e0a987ed53697865d553b12411bbf6b3390057ae766c97e3f6e5018ba8146d
CD62F688F498|ae928b5a72f926ee1f51b7672fb8ee4a40ccce396859b661caabd66bb824b513
C2CBAA33A9F8|54ad8ffdba4c7d8c0464b2373282fa9de405dc657fb23b644d8480178bf8902c
C6F50BB74E29|dc545e6b3b1a1a8b15fefaa2799ff90fba664bd2a0466cdc327381af41760bf8
79F1B4CCC62A00|5d431f6ed6cc9e92802329e36e86048997e4a9f4b9872988670d979cbe7b075a
