package Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Yellow;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-05-06'; # DATE
our $DIST = 'Graphics-ColorNamesCMYK-ToutesLesCouleursCom'; # DIST
our $VERSION = '0.001'; # VERSION

our $NAMES_CMYK_TABLE = {
  'yellow' => 0x00006400, # 0,0,100,0
  'amber' => 0x00136406, # 0,19,100,6
  'aurore' => 0x00143e00, # 0,20,62,0
  'butter' => 0x00053706, # 0,5,55,6
  'fees butter' => 0x00042d00, # 0,4,45,0
  'wheat' => 0x00084f09, # 0,8,79,9
  'blonde' => 0x0011310b, # 0,17,49,11
  'golden button' => 0x000d5d01, # 0,13,93,1
  'bulle' => 0x000b2907, # 0,11,41,7
  'goose caca' => 0x00005e14, # 0,0,94,20
  'chamois' => 0x00082912, # 0,8,41,18
  'champagne' => 0x00041b02, # 0,4,27,2
  'chrome' => 0x07005f00, # 7,0,95,0
  'chrome' => 0x00006200, # 0,0,98,0
  'lemon' => 0x03004c00, # 3,0,76,0
  'fauve' => 0x00365f20, # 0,54,95,32
  'flave' => 0x0000220a, # 0,0,34,10
  'sulfur flower' => 0x00003a00, # 0,0,58,0
  'gamboge' => 0x00235e06, # 0,35,94,6
  'yellow aureolin' => 0x000c4806, # 0,12,72,6
  'yellow banana' => 0x000d6112, # 0,13,97,18
  'chickadee' => 0x04005f06, # 4,0,95,6
  'yellow chartreuse' => 0x0d006400, # 13,0,100,0
  'cobalt yellow' => 0x00066400, # 0,6,100,0
  'naples yellow' => 0x00061a00, # 0,6,26,0
  'golden yellow' => 0x000a6106, # 0,10,97,6
  'imperial yellow' => 0x000b4f00, # 0,11,79,0
  'yellow mimosa' => 0x00023900, # 0,2,57,0
  'yellow mustard' => 0x04006413, # 4,0,100,19
  'yellow nankin' => 0x00093903, # 0,9,57,3
  'yellow olive' => 0x00006432, # 0,0,100,50
  'yellow straw' => 0x000b4800, # 0,11,72,0
  'yellow chick' => 0x00083e03, # 0,8,62,3
  'corn' => 0x000d3600, # 0,13,54,0
  'march' => 0x000c4107, # 0,12,65,7
  'putty' => 0x0001131e, # 0,1,19,30
  'honey' => 0x00125f0f, # 0,18,95,15
  'yellow ocher' => 0x0016520d, # 0,22,82,13
  'red ochre' => 0x001f3a0d, # 0,31,58,13
  'or' => 0x00125e00, # 0,18,94,0
  'orpiment' => 0x00115901, # 0,17,89,1
  'camel hair' => 0x0022511d, # 0,34,81,29
  'cow tail 1' => 0x00082b18, # 0,8,43,24
  'cow tail 2' => 0x000a1f22, # 0,10,31,34
  'sand' => 0x0008190c, # 0,8,25,12
  'safran' => 0x000c5b05, # 0,12,91,5
  'sulfur' => 0x00003a00, # 0,0,58,0
  'topaz' => 0x00063602, # 0,6,54,2
  'vanilla' => 0x0008200c, # 0,8,32,12
  'venetian' => 0x001b4009, # 0,27,64,9
};


1;
# ABSTRACT: CMYK colors from http://toutes-les-couleurs.com/ (yellow)

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Yellow - CMYK colors from http://toutes-les-couleurs.com/ (yellow)

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNamesCMYK::ToutesLesCouleursCom::Yellow (from Perl distribution Graphics-ColorNamesCMYK-ToutesLesCouleursCom), released on 2024-05-06.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNamesCMYK-ToutesLesCouleursCom>.

=head1 SEE ALSO

Other C<Graphics::ColorNamesCMYK::ToutesLesCoulersCom::*> modules.

Other C<Graphics::ColorNamesCMYK::*> modules.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNamesCMYK-ToutesLesCouleursCom>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
