#########################################################################################
# Package        HiPi::Graphics::BitmapFont::MonoEPD102
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::MonoEPD102;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 102;
my $line_spacing = 0;
my $name = 'Mono 102';
my $space_width = 52;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 8, 
        'xoffset'  => 22, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 24, 
        'xoffset'  => 14, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0xFF, 0x00, 0xFF, ##  00000000        00000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 52, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0xF8, 0x01, 0xFC, 0x00, ##                        0000000          0000000      
            0x00, 0x00, 0x03, 0xF8, 0x01, 0xFC, 0x00, ##                        0000000          0000000      
            0x00, 0x00, 0x03, 0xF0, 0x01, 0xF8, 0x00, ##                        000000           000000       
            0x00, 0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, ##                       0000000          0000000       
            0x00, 0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, ##                       0000000          0000000       
            0x00, 0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, ##                       0000000          0000000       
            0x00, 0x00, 0x07, 0xE0, 0x03, 0xF0, 0x00, ##                       000000           000000        
            0x00, 0x00, 0x0F, 0xE0, 0x07, 0xF0, 0x00, ##                      0000000          0000000        
            0x00, 0x00, 0x0F, 0xE0, 0x07, 0xF0, 0x00, ##                      0000000          0000000        
            0x00, 0x00, 0x0F, 0xE0, 0x07, 0xF0, 0x00, ##                      0000000          0000000        
            0x00, 0x00, 0x0F, 0xC0, 0x07, 0xE0, 0x00, ##                      000000           000000         
            0x00, 0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, ##                     0000000          0000000         
            0x00, 0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, ##                     0000000          0000000         
            0x00, 0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, ##                     0000000          0000000         
            0x00, 0x00, 0x1F, 0x80, 0x0F, 0xC0, 0x00, ##                     000000           000000          
            0x00, 0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, ##                    0000000          0000000          
            0x00, 0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, ##                    0000000          0000000          
            0x00, 0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, ##                    0000000          0000000          
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       00000000000000000000000000000000000000000000000
            0x00, 0x00, 0xFE, 0x00, 0x7F, 0x00, 0x00, ##                  0000000          0000000            
            0x00, 0x00, 0xFE, 0x00, 0x7F, 0x00, 0x00, ##                  0000000          0000000            
            0x00, 0x00, 0xFC, 0x00, 0x7E, 0x00, 0x00, ##                  000000           000000             
            0x00, 0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, ##                 0000000          0000000             
            0x00, 0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, ##                 0000000          0000000             
            0x00, 0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, ##                 0000000          0000000             
            0x00, 0x01, 0xF8, 0x00, 0xFC, 0x00, 0x00, ##                 000000           000000              
            0x00, 0x03, 0xF8, 0x01, 0xFC, 0x00, 0x00, ##                0000000          0000000              
            0x00, 0x03, 0xF8, 0x01, 0xFC, 0x00, 0x00, ##                0000000          0000000              
            0x00, 0x03, 0xF8, 0x01, 0xFC, 0x00, 0x00, ##                0000000          0000000              
            0x00, 0x03, 0xF0, 0x01, 0xFC, 0x00, 0x00, ##                000000           0000000              
            0x00, 0x07, 0xF0, 0x01, 0xF8, 0x00, 0x00, ##               0000000           000000               
            0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, 0x00, ##               0000000          0000000               
            0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, 0x00, ##               0000000          0000000               
            0x00, 0x07, 0xF0, 0x03, 0xF8, 0x00, 0x00, ##               0000000          0000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000000000000000000000000000     
            0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, 0x00, ##             0000000          0000000                 
            0x00, 0x1F, 0x80, 0x0F, 0xC0, 0x00, 0x00, ##             000000           000000                  
            0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, 0x00, ##            0000000          0000000                  
            0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, 0x00, ##            0000000          0000000                  
            0x00, 0x3F, 0x80, 0x1F, 0xC0, 0x00, 0x00, ##            0000000          0000000                  
            0x00, 0x3F, 0x00, 0x1F, 0x80, 0x00, 0x00, ##            000000           000000                   
            0x00, 0x7F, 0x00, 0x3F, 0x80, 0x00, 0x00, ##           0000000          0000000                   
            0x00, 0x7F, 0x00, 0x3F, 0x80, 0x00, 0x00, ##           0000000          0000000                   
            0x00, 0x7F, 0x00, 0x3F, 0x80, 0x00, 0x00, ##           0000000          0000000                   
            0x00, 0x7E, 0x00, 0x3F, 0x00, 0x00, 0x00, ##           000000           000000                    
            0x00, 0xFE, 0x00, 0x7F, 0x00, 0x00, 0x00, ##          0000000          0000000                    
            0x00, 0xFE, 0x00, 0x7F, 0x00, 0x00, 0x00, ##          0000000          0000000                    
            0x00, 0xFE, 0x00, 0x7F, 0x00, 0x00, 0x00, ##          0000000          0000000                    
            0x00, 0xFC, 0x00, 0x7E, 0x00, 0x00, 0x00, ##          000000           000000                     
            0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, 0x00, ##         0000000          0000000                     
            0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, 0x00, ##         0000000          0000000                     
            0x01, 0xFC, 0x00, 0xFE, 0x00, 0x00, 0x00, ##         0000000          0000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x07, 0xFF, 0xE0, 0x00, ##               00000000000000            
            0x00, 0x7F, 0xFF, 0xFE, 0x00, ##           0000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, ##         0000000000000000000000000000    
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, ##        00000000000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xFF, 0xE0, ##      0000000000000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xFF, 0xE0, ##     00000000000000000000000000000000    
            0x1F, 0xFC, 0x78, 0x3F, 0xE0, ##     00000000000   0000     000000000    
            0x3F, 0xE0, 0x78, 0x07, 0xE0, ##    000000000      0000        000000    
            0x7F, 0xC0, 0x78, 0x00, 0xE0, ##   000000000       0000           000    
            0x7F, 0x80, 0x78, 0x00, 0x20, ##   00000000        0000             0    
            0x7F, 0x80, 0x78, 0x00, 0x00, ##   00000000        0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x00, 0x78, 0x00, 0x00, ##  00000000         0000                  
            0xFF, 0x80, 0x78, 0x00, 0x00, ##  000000000        0000                  
            0x7F, 0x80, 0x78, 0x00, 0x00, ##   00000000        0000                  
            0x7F, 0xC0, 0x78, 0x00, 0x00, ##   000000000       0000                  
            0x7F, 0xE0, 0x78, 0x00, 0x00, ##   0000000000      0000                  
            0x3F, 0xF8, 0x78, 0x00, 0x00, ##    00000000000    0000                  
            0x3F, 0xFF, 0xF8, 0x00, 0x00, ##    0000000000000000000                  
            0x1F, 0xFF, 0xFC, 0x00, 0x00, ##     0000000000000000000                 
            0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##      0000000000000000000000             
            0x07, 0xFF, 0xFF, 0xF8, 0x00, ##       000000000000000000000000          
            0x01, 0xFF, 0xFF, 0xFE, 0x00, ##         000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0x80, ##           000000000000000000000000      
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, ##              0000000000000000000000     
            0x00, 0x00, 0xFF, 0xFF, 0xE0, ##                  0000000000000000000    
            0x00, 0x00, 0x7F, 0xFF, 0xF0, ##                   0000000000000000000   
            0x00, 0x00, 0x78, 0x7F, 0xF8, ##                   0000    000000000000  
            0x00, 0x00, 0x78, 0x1F, 0xF8, ##                   0000      0000000000  
            0x00, 0x00, 0x78, 0x0F, 0xFC, ##                   0000       0000000000 
            0x00, 0x00, 0x78, 0x07, 0xFC, ##                   0000        000000000 
            0x00, 0x00, 0x78, 0x03, 0xFC, ##                   0000         00000000 
            0x00, 0x00, 0x78, 0x03, 0xFE, ##                   0000         000000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x01, 0xFE, ##                   0000          00000000
            0x00, 0x00, 0x78, 0x03, 0xFE, ##                   0000         000000000
            0x80, 0x00, 0x78, 0x03, 0xFC, ##  0                0000         00000000 
            0xE0, 0x00, 0x78, 0x07, 0xFC, ##  000              0000        000000000 
            0xF8, 0x00, 0x78, 0x0F, 0xF8, ##  00000            0000       000000000  
            0xFF, 0x00, 0x78, 0x1F, 0xF8, ##  00000000         0000      0000000000  
            0xFF, 0xF0, 0x78, 0x7F, 0xF0, ##  000000000000     0000    00000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000      
            0x1F, 0xFF, 0xFF, 0xFE, 0x00, ##     0000000000000000000000000000        
            0x03, 0xFF, 0xFF, 0xF8, 0x00, ##        00000000000000000000000          
            0x00, 0x1F, 0xFF, 0xC0, 0x00, ##             000000000000000             
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x78, 0x00, 0x00, ##                   0000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 50, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, ##            0000000                                 
            0x01, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##         0000000000000                              
            0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##       0000000000000000                             
            0x0F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##      0000000000000000000                           
            0x1F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##     000000000000000000000                          
            0x3F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##    0000000000000000000000                          
            0x3F, 0xE0, 0xFF, 0x80, 0x00, 0x00, 0x00, ##    000000000     000000000                         
            0x7F, 0x80, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##   00000000         00000000                        
            0x7F, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##   0000000           0000000                        
            0x7E, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##   000000             000000                        
            0xFE, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##  0000000             0000000                       
            0xFC, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  000000               000000                       
            0xFC, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  000000               000000                       
            0xFC, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  000000               000000                       
            0xFC, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  000000               000000                       
            0xFC, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  000000               000000                       
            0xFE, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##  0000000             0000000                       
            0x7E, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##   000000             000000                        
            0x7F, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##   0000000           0000000                        
            0x7F, 0x80, 0x3F, 0xC0, 0x00, 0x06, 0x00, ##   00000000         00000000                   00   
            0x3F, 0xE0, 0xFF, 0x80, 0x00, 0x1F, 0x00, ##    000000000     000000000                  00000  
            0x3F, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0x00, ##    0000000000000000000000                 0000000  
            0x1F, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0x00, ##     000000000000000000000              0000000000  
            0x0F, 0xFF, 0xFE, 0x00, 0x0F, 0xFE, 0x00, ##      0000000000000000000             00000000000   
            0x07, 0xFF, 0xF8, 0x00, 0x7F, 0xF8, 0x00, ##       0000000000000000            000000000000     
            0x01, 0xFF, 0xF0, 0x01, 0xFF, 0xE0, 0x00, ##         0000000000000           000000000000       
            0x00, 0x3F, 0x80, 0x07, 0xFF, 0x00, 0x00, ##            0000000            00000000000          
            0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                            000000000000            
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                          00000000000               
            0x00, 0x00, 0x07, 0xFF, 0x80, 0x00, 0x00, ##                       000000000000                 
            0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, ##                     000000000000                   
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##                   00000000000                      
            0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                000000000000                        
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##              00000000000                           
            0x00, 0x7F, 0xF8, 0x00, 0xFF, 0x00, 0x00, ##           000000000000           00000000          
            0x01, 0xFF, 0xE0, 0x07, 0xFF, 0xC0, 0x00, ##         000000000000          0000000000000        
            0x07, 0xFF, 0x00, 0x0F, 0xFF, 0xF0, 0x00, ##       00000000000            0000000000000000      
            0x3F, 0xFC, 0x00, 0x3F, 0xFF, 0xF8, 0x00, ##    000000000000            0000000000000000000     
            0x1F, 0xE0, 0x00, 0x7F, 0xFF, 0xFC, 0x00, ##     00000000              000000000000000000000    
            0x1F, 0x80, 0x00, 0x7F, 0xFF, 0xFE, 0x00, ##     000000                0000000000000000000000   
            0x1C, 0x00, 0x00, 0xFF, 0x81, 0xFF, 0x00, ##     000                  000000000      000000000  
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x7F, 0x00, ##                         00000000          0000000  
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0x80, ##                         0000000            0000000 
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x1F, 0x80, ##                         000000              000000 
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x1F, 0xC0, ##                        0000000              0000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, ##                        000000                000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, ##                        000000                000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, ##                        000000                000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, ##                        000000                000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xC0, ##                        000000                000000
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x1F, 0xC0, ##                        0000000              0000000
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x1F, 0x80, ##                         000000              000000 
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0x80, ##                         0000000            0000000 
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x7F, 0x80, ##                         00000000          00000000 
            0x00, 0x00, 0x00, 0xFF, 0x81, 0xFF, 0x00, ##                          000000000      000000000  
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, ##                           0000000000000000000000   
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x00, ##                           0000000000000000000000   
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF8, 0x00, ##                            0000000000000000000     
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF0, 0x00, ##                              0000000000000000      
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, ##                               00000000000000       
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                                  00000000          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 50, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##                     0000000000                     
            0x00, 0x00, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                  000000000000000000                
            0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##                000000000000000000000               
            0x00, 0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##              00000000000000000000000               
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##             000000000000000000000000               
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##             000000000000000000000000               
            0x00, 0x3F, 0xF0, 0x0F, 0xE0, 0x00, 0x00, ##            0000000000        0000000               
            0x00, 0x7F, 0xC0, 0x00, 0xE0, 0x00, 0x00, ##           000000000              000               
            0x00, 0x7F, 0x80, 0x00, 0x20, 0x00, 0x00, ##           00000000                 0               
            0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##           0000000                                  
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##          00000000                                  
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                   
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##          00000000                                  
            0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##           0000000                                  
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##           00000000                                 
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##           00000000                                 
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##            00000000                                
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##            00000000                                
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##            000000000                               
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##             000000000                              
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##              00000000                              
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##             0000000000                             
            0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##            000000000000                            
            0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##           00000000000000                           
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##          000000000000000                           
            0x01, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##         00000000000000000                          
            0x03, 0xFE, 0xFF, 0x80, 0x00, 0x00, 0x00, ##        000000000 000000000                         
            0x07, 0xFC, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##       000000000   000000000                        
            0x0F, 0xF8, 0x7F, 0xC0, 0x00, 0x3F, 0x80, ##      000000000    000000000                0000000 
            0x1F, 0xF0, 0x3F, 0xE0, 0x00, 0x3F, 0x80, ##     000000000      000000000               0000000 
            0x1F, 0xE0, 0x1F, 0xF0, 0x00, 0x3F, 0x80, ##     00000000        000000000              0000000 
            0x3F, 0xE0, 0x0F, 0xF8, 0x00, 0x3F, 0x80, ##    000000000         000000000             0000000 
            0x3F, 0xC0, 0x0F, 0xF8, 0x00, 0x3F, 0x80, ##    00000000          000000000             0000000 
            0x7F, 0x80, 0x07, 0xFC, 0x00, 0x3F, 0x80, ##   00000000            000000000            0000000 
            0x7F, 0x80, 0x03, 0xFE, 0x00, 0x3F, 0x80, ##   00000000             000000000           0000000 
            0x7F, 0x80, 0x01, 0xFE, 0x00, 0x3F, 0x80, ##   00000000              00000000           0000000 
            0xFF, 0x00, 0x01, 0xFF, 0x00, 0x3F, 0x80, ##  00000000               000000000          0000000 
            0xFF, 0x00, 0x00, 0xFF, 0x80, 0x3F, 0x00, ##  00000000                000000000         000000  
            0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x3F, 0x00, ##  00000000                 000000000        000000  
            0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x7F, 0x00, ##  00000000                 000000000       0000000  
            0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x7F, 0x00, ##  00000000                  000000000      0000000  
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x7E, 0x00, ##  00000000                   000000000     000000   
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0xFE, 0x00, ##  00000000                    000000000   0000000   
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0xFE, 0x00, ##  00000000                    000000000   0000000   
            0xFF, 0x80, 0x00, 0x07, 0xFD, 0xFC, 0x00, ##  000000000                    000000000 0000000    
            0xFF, 0x80, 0x00, 0x03, 0xFF, 0xFC, 0x00, ##  000000000                     0000000000000000    
            0x7F, 0x80, 0x00, 0x01, 0xFF, 0xF8, 0x00, ##   00000000                      00000000000000     
            0x7F, 0xC0, 0x00, 0x01, 0xFF, 0xF8, 0x00, ##   000000000                     00000000000000     
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##   000000000                      000000000000      
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##    000000000                      0000000000       
            0x3F, 0xF0, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##    0000000000                     0000000000       
            0x1F, 0xF8, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##     0000000000                    0000000000       
            0x0F, 0xFC, 0x00, 0x01, 0xFF, 0xF0, 0x00, ##      0000000000                 0000000000000      
            0x0F, 0xFF, 0x00, 0x07, 0xFF, 0xF8, 0x00, ##      000000000000             0000000000000000     
            0x07, 0xFF, 0xE0, 0x1F, 0xFF, 0xFC, 0x00, ##       00000000000000        0000000000000000000    
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##        0000000000000000000000000000000000000000    
            0x01, 0xFF, 0xFF, 0xFF, 0xF3, 0xFE, 0x00, ##         00000000000000000000000000000  000000000   
            0x00, 0x7F, 0xFF, 0xFF, 0xE1, 0xFF, 0x00, ##           00000000000000000000000000    000000000  
            0x00, 0x3F, 0xFF, 0xFF, 0x80, 0xFF, 0x80, ##            00000000000000000000000       000000000 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0xFF, 0xC0, ##               00000000000000000          0000000000
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                  00000000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 8, 
        'xoffset'  => 22, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 19, 
        'xoffset'  => 18, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xE0, ##              0000000
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0xFE, 0x00, ##          0000000    
            0x00, 0xFE, 0x00, ##          0000000    
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x03, 0xFC, 0x00, ##        00000000     
            0x03, 0xF8, 0x00, ##        0000000      
            0x07, 0xF8, 0x00, ##       00000000      
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF0, 0x00, ##       0000000       
            0x0F, 0xF0, 0x00, ##      00000000       
            0x0F, 0xE0, 0x00, ##      0000000        
            0x1F, 0xE0, 0x00, ##     00000000        
            0x1F, 0xE0, 0x00, ##     00000000        
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0xC0, 0x00, ##     0000000         
            0x3F, 0xC0, 0x00, ##    00000000         
            0x3F, 0xC0, 0x00, ##    00000000         
            0x3F, 0xC0, 0x00, ##    00000000         
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0xFF, 0x00, 0x00, ##  00000000           
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x7F, 0x80, 0x00, ##   00000000          
            0x3F, 0xC0, 0x00, ##    00000000         
            0x3F, 0xC0, 0x00, ##    00000000         
            0x3F, 0xC0, 0x00, ##    00000000         
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0xE0, 0x00, ##     00000000        
            0x1F, 0xE0, 0x00, ##     00000000        
            0x0F, 0xE0, 0x00, ##      0000000        
            0x0F, 0xF0, 0x00, ##      00000000       
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF8, 0x00, ##       00000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xFC, 0x00, ##        00000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x00, 0xFE, 0x00, ##          0000000    
            0x00, 0xFE, 0x00, ##          0000000    
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x0F, 0xE0, ##              0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 19, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, ##  0000000            
            0x7E, 0x00, 0x00, ##   000000            
            0x7F, 0x00, 0x00, ##   0000000           
            0x3F, 0x80, 0x00, ##    0000000          
            0x3F, 0x80, 0x00, ##    0000000          
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0xC0, 0x00, ##     0000000         
            0x0F, 0xE0, 0x00, ##      0000000        
            0x0F, 0xE0, 0x00, ##      0000000        
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF8, 0x00, ##       00000000      
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xFC, 0x00, ##        00000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xFE, 0x00, ##         00000000    
            0x00, 0xFE, 0x00, ##          0000000    
            0x00, 0xFE, 0x00, ##          0000000    
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xC0, ##             0000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x3F, 0x80, ##            0000000  
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0x7F, 0x00, ##           0000000   
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0xFE, 0x00, ##          0000000    
            0x01, 0xFE, 0x00, ##         00000000    
            0x01, 0xFC, 0x00, ##         0000000     
            0x01, 0xFC, 0x00, ##         0000000     
            0x03, 0xFC, 0x00, ##        00000000     
            0x03, 0xF8, 0x00, ##        0000000      
            0x07, 0xF8, 0x00, ##       00000000      
            0x07, 0xF0, 0x00, ##       0000000       
            0x07, 0xF0, 0x00, ##       0000000       
            0x0F, 0xE0, 0x00, ##      0000000        
            0x0F, 0xE0, 0x00, ##      0000000        
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0xC0, 0x00, ##     0000000         
            0x3F, 0x80, 0x00, ##    0000000          
            0x3F, 0x80, 0x00, ##    0000000          
            0x7F, 0x00, 0x00, ##   0000000           
            0x7E, 0x00, 0x00, ##   000000            
            0xFE, 0x00, 0x00, ##  0000000            
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 39, 
        'xoffset'  => 7, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x30, 0x00, 0x7C, 0x00, 0x18, ##    00             00000             00  
            0x3C, 0x00, 0x7C, 0x00, 0x78, ##    0000           00000           0000  
            0x7F, 0x00, 0x7C, 0x01, 0xFC, ##   0000000         00000         0000000 
            0xFF, 0x80, 0x7C, 0x03, 0xFE, ##  000000000        00000        000000000
            0x3F, 0xE0, 0x7C, 0x0F, 0xF8, ##    000000000      00000      000000000  
            0x0F, 0xF8, 0x7C, 0x3F, 0xE0, ##      000000000    00000    000000000    
            0x07, 0xFC, 0x7C, 0x7F, 0xC0, ##       000000000   00000   000000000     
            0x01, 0xFF, 0x7D, 0xFF, 0x00, ##         000000000 00000 000000000       
            0x00, 0x7F, 0xFF, 0xFC, 0x00, ##           000000000000000000000         
            0x00, 0x1F, 0xFF, 0xF0, 0x00, ##             00000000000000000           
            0x00, 0x07, 0xFF, 0xC0, 0x00, ##               0000000000000             
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000               
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000               
            0x00, 0x07, 0xFF, 0xC0, 0x00, ##               0000000000000             
            0x00, 0x1F, 0xFF, 0xF0, 0x00, ##             00000000000000000           
            0x00, 0x7F, 0xFF, 0xFC, 0x00, ##           000000000000000000000         
            0x01, 0xFF, 0x7D, 0xFF, 0x00, ##         000000000 00000 000000000       
            0x07, 0xFC, 0x7C, 0x7F, 0xC0, ##       000000000   00000   000000000     
            0x0F, 0xF8, 0x7C, 0x3F, 0xE0, ##      000000000    00000    000000000    
            0x3F, 0xE0, 0x7C, 0x0F, 0xF8, ##    000000000      00000      000000000  
            0xFF, 0x80, 0x7C, 0x03, 0xFE, ##  000000000        00000        000000000
            0x7F, 0x00, 0x7C, 0x01, 0xFC, ##   0000000         00000         0000000 
            0x3C, 0x00, 0x7C, 0x00, 0x78, ##    0000           00000           0000  
            0x30, 0x00, 0x7C, 0x00, 0x18, ##    00             00000             00  
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x7C, 0x00, 0x00, ##                   00000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 15, 
        'xoffset'  => 17, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFC, ##      0000000000 
            0x1F, 0xFC, ##     00000000000 
            0x1F, 0xF8, ##     0000000000  
            0x1F, 0xF8, ##     0000000000  
            0x3F, 0xF0, ##    0000000000   
            0x3F, 0xE0, ##    000000000    
            0x3F, 0xE0, ##    000000000    
            0x3F, 0xC0, ##    00000000     
            0x7F, 0xC0, ##   000000000     
            0x7F, 0x80, ##   00000000      
            0x7F, 0x80, ##   00000000      
            0x7F, 0x00, ##   0000000       
            0xFF, 0x00, ##  00000000       
            0xFE, 0x00, ##  0000000        
            0xFE, 0x00, ##  0000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 22, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 11, 
        'xoffset'  => 21, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 42, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##                                    00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000  
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000  
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000   
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000   
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000    
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000    
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000     
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000     
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##                              000000000     
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##                              00000000      
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000      
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000       
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000       
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000        
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000        
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                           00000000         
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                           00000000         
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                          00000000          
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                          00000000          
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, ##                         00000000           
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, ##                         00000000           
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, ##                        00000000            
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, ##                        00000000            
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, ##                       000000000            
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                       00000000             
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                       00000000             
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000              
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000              
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000               
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000               
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                  
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                  
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, ##                 000000000                  
            0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##                 00000000                   
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, ##                000000000                   
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, ##                00000000                    
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, ##                00000000                    
            0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##               00000000                     
            0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##               00000000                     
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##              00000000                      
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##              00000000                      
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                       
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                        
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                        
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##           000000000                        
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, ##           00000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                          
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                          
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                           
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                           
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##        00000000                            
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##        00000000                            
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, ##       00000000                             
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, ##       00000000                             
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##      00000000                              
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##      00000000                              
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                               
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                               
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                               
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                
            0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, ##               000000000000000             
            0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##             0000000000000000000           
            0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, ##           0000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x03, 0xFF, 0x80, 0xFF, 0xC0, 0x00, ##        00000000000       0000000000       
            0x03, 0xFE, 0x00, 0x3F, 0xE0, 0x00, ##        000000000           000000000      
            0x07, 0xFC, 0x00, 0x1F, 0xF0, 0x00, ##       000000000             000000000     
            0x0F, 0xF8, 0x00, 0x0F, 0xF0, 0x00, ##      000000000               00000000     
            0x0F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##      00000000                 00000000    
            0x0F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##      00000000                 00000000    
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0x80, 0x00, 0x01, 0xFE, 0x00, ##    0000000                      00000000  
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x3E, 0x00, 0x7F, 0x80, ##  00000000          00000          00000000
            0xFF, 0x00, 0x7F, 0x00, 0x7F, 0x80, ##  00000000         0000000         00000000
            0xFF, 0x00, 0xFF, 0x80, 0x7F, 0x80, ##  00000000        000000000        00000000
            0xFF, 0x01, 0xFF, 0xC0, 0x7F, 0x80, ##  00000000       00000000000       00000000
            0xFF, 0x01, 0xFF, 0xC0, 0x7F, 0x80, ##  00000000       00000000000       00000000
            0xFF, 0x01, 0xFF, 0xC0, 0x7F, 0x80, ##  00000000       00000000000       00000000
            0xFF, 0x01, 0xFF, 0xC0, 0x7F, 0x80, ##  00000000       00000000000       00000000
            0xFF, 0x01, 0xFF, 0xC0, 0x7F, 0x80, ##  00000000       00000000000       00000000
            0xFF, 0x00, 0xFF, 0x80, 0x7F, 0x80, ##  00000000        000000000        00000000
            0xFF, 0x00, 0x7F, 0x00, 0x7F, 0x80, ##  00000000         0000000         00000000
            0xFF, 0x00, 0x3E, 0x00, 0x7F, 0x80, ##  00000000          00000          00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0x7F, 0x00, 0x00, 0x00, 0xFF, 0x00, ##   0000000                        00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x3F, 0x80, 0x00, 0x01, 0xFE, 0x00, ##    0000000                      00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##     000000000                 00000000    
            0x0F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##      00000000                 00000000    
            0x0F, 0xF8, 0x00, 0x0F, 0xF0, 0x00, ##      000000000               00000000     
            0x07, 0xFC, 0x00, 0x1F, 0xF0, 0x00, ##       000000000             000000000     
            0x03, 0xFE, 0x00, 0x3F, 0xE0, 0x00, ##        000000000           000000000      
            0x03, 0xFF, 0x80, 0xFF, 0xE0, 0x00, ##        00000000000       00000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##           00000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##             0000000000000000000           
            0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, ##               000000000000000             
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 36, 
        'xoffset'  => 10, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000             
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000             
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000             
            0xFF, 0xF9, 0xFE, 0x00, 0x00, ##  0000000000000  00000000             
            0xFF, 0x01, 0xFE, 0x00, 0x00, ##  00000000       00000000             
            0xF0, 0x01, 0xFE, 0x00, 0x00, ##  0000           00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000             
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 39, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000                
            0x01, 0xFF, 0xFF, 0xC0, 0x00, ##         0000000000000000000             
            0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##     00000000000000000000000000          
            0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##   00000000000000000000000000000         
            0x7F, 0xFF, 0xFF, 0xFF, 0x00, ##   0000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0x80, ##   00000000000000000000000000000000      
            0x7F, 0xF8, 0x07, 0xFF, 0xC0, ##   000000000000        0000000000000     
            0x7F, 0x80, 0x00, 0xFF, 0xE0, ##   00000000               00000000000    
            0x7E, 0x00, 0x00, 0x7F, 0xE0, ##   000000                  0000000000    
            0x78, 0x00, 0x00, 0x3F, 0xF0, ##   0000                     0000000000   
            0x60, 0x00, 0x00, 0x1F, 0xF0, ##   00                        000000000   
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000  
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000   
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000   
            0x00, 0x00, 0x00, 0x3F, 0xF0, ##                            0000000000   
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000    
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000     
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000     
            0x00, 0x00, 0x01, 0xFF, 0x80, ##                         0000000000      
            0x00, 0x00, 0x03, 0xFF, 0x00, ##                        0000000000       
            0x00, 0x00, 0x03, 0xFF, 0x00, ##                        0000000000       
            0x00, 0x00, 0x07, 0xFE, 0x00, ##                       0000000000        
            0x00, 0x00, 0x0F, 0xFC, 0x00, ##                      0000000000         
            0x00, 0x00, 0x1F, 0xF8, 0x00, ##                     0000000000          
            0x00, 0x00, 0x3F, 0xF0, 0x00, ##                    0000000000           
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000            
            0x00, 0x00, 0x7F, 0xC0, 0x00, ##                   000000000             
            0x00, 0x00, 0xFF, 0xC0, 0x00, ##                  0000000000             
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000              
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000               
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000                
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000                 
            0x00, 0x1F, 0xF8, 0x00, 0x00, ##             0000000000                  
            0x00, 0x3F, 0xF0, 0x00, 0x00, ##            0000000000                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000                    
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                     
            0x00, 0xFF, 0x80, 0x00, 0x00, ##          000000000                      
            0x01, 0xFF, 0x00, 0x00, 0x00, ##         000000000                       
            0x03, 0xFE, 0x00, 0x00, 0x00, ##        000000000                        
            0x07, 0xFC, 0x00, 0x00, 0x00, ##       000000000                         
            0x0F, 0xFC, 0x00, 0x00, 0x00, ##      0000000000                         
            0x1F, 0xF8, 0x00, 0x00, 0x00, ##     0000000000                          
            0x3F, 0xF0, 0x00, 0x00, 0x00, ##    0000000000                           
            0x7F, 0xE0, 0x00, 0x00, 0x00, ##   0000000000                            
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                             
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFE, 0x00, 0x00, ##             000000000000                 
            0x03, 0xFF, 0xFF, 0xE0, 0x00, ##        000000000000000000000             
            0x3F, 0xFF, 0xFF, 0xF8, 0x00, ##    000000000000000000000000000           
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000         
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000        
            0x3F, 0xFF, 0xFF, 0xFF, 0x80, ##    0000000000000000000000000000000       
            0x3F, 0xF8, 0x03, 0xFF, 0xC0, ##    00000000000         000000000000      
            0x3F, 0x00, 0x00, 0x7F, 0xE0, ##    000000                 0000000000     
            0x38, 0x00, 0x00, 0x3F, 0xF0, ##    000                     0000000000    
            0x20, 0x00, 0x00, 0x1F, 0xF0, ##    0                        000000000    
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000   
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000   
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000   
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000   
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000   
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000   
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000    
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000     
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000      
            0x00, 0x00, 0x03, 0xFF, 0x80, ##                        00000000000       
            0x00, 0x1F, 0xFF, 0xFF, 0x00, ##             000000000000000000000        
            0x00, 0x1F, 0xFF, 0xFC, 0x00, ##             0000000000000000000          
            0x00, 0x1F, 0xFF, 0xE0, 0x00, ##             0000000000000000             
            0x00, 0x1F, 0xFF, 0xF8, 0x00, ##             000000000000000000           
            0x00, 0x1F, 0xFF, 0xFE, 0x00, ##             00000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x80, ##             0000000000000000000000       
            0x00, 0x00, 0x03, 0xFF, 0xC0, ##                        000000000000      
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000     
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000    
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000   
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, ##                                  00000000
            0x00, 0x00, 0x00, 0x01, 0xFF, ##                                 000000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000 
            0x00, 0x00, 0x00, 0x03, 0xFE, ##                                000000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000  
            0xC0, 0x00, 0x00, 0x0F, 0xFC, ##  00                          0000000000  
            0xF8, 0x00, 0x00, 0x1F, 0xF8, ##  00000                      0000000000   
            0xFE, 0x00, 0x00, 0x7F, 0xF8, ##  0000000                  000000000000   
            0xFF, 0xF0, 0x03, 0xFF, 0xF0, ##  000000000000          00000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  00000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000          
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, ##      000000000000000000000000            
            0x00, 0x3F, 0xFF, 0x00, 0x00, ##            00000000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##                            000000000         
            0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##                           0000000000         
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##                          00000000000         
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##                          00000000000         
            0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, ##                         000000000000         
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##                        0000000000000         
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##                        0000000000000         
            0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, ##                       00000000000000         
            0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, ##                       00000000000000         
            0x00, 0x00, 0x0F, 0xDF, 0xE0, 0x00, ##                      000000 00000000         
            0x00, 0x00, 0x1F, 0xDF, 0xE0, 0x00, ##                     0000000 00000000         
            0x00, 0x00, 0x1F, 0x9F, 0xE0, 0x00, ##                     000000  00000000         
            0x00, 0x00, 0x3F, 0x9F, 0xE0, 0x00, ##                    0000000  00000000         
            0x00, 0x00, 0x3F, 0x1F, 0xE0, 0x00, ##                    000000   00000000         
            0x00, 0x00, 0x7F, 0x1F, 0xE0, 0x00, ##                   0000000   00000000         
            0x00, 0x00, 0xFE, 0x1F, 0xE0, 0x00, ##                  0000000    00000000         
            0x00, 0x00, 0xFC, 0x1F, 0xE0, 0x00, ##                  000000     00000000         
            0x00, 0x01, 0xFC, 0x1F, 0xE0, 0x00, ##                 0000000     00000000         
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, ##                0000000      00000000         
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, ##                0000000      00000000         
            0x00, 0x07, 0xF0, 0x1F, 0xE0, 0x00, ##               0000000       00000000         
            0x00, 0x07, 0xE0, 0x1F, 0xE0, 0x00, ##               000000        00000000         
            0x00, 0x0F, 0xE0, 0x1F, 0xE0, 0x00, ##              0000000        00000000         
            0x00, 0x1F, 0xC0, 0x1F, 0xE0, 0x00, ##             0000000         00000000         
            0x00, 0x1F, 0xC0, 0x1F, 0xE0, 0x00, ##             0000000         00000000         
            0x00, 0x3F, 0x80, 0x1F, 0xE0, 0x00, ##            0000000          00000000         
            0x00, 0x7F, 0x80, 0x1F, 0xE0, 0x00, ##           00000000          00000000         
            0x00, 0x7F, 0x00, 0x1F, 0xE0, 0x00, ##           0000000           00000000         
            0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, ##          0000000            00000000         
            0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, ##          0000000            00000000         
            0x01, 0xFC, 0x00, 0x1F, 0xE0, 0x00, ##         0000000             00000000         
            0x03, 0xFC, 0x00, 0x1F, 0xE0, 0x00, ##        00000000             00000000         
            0x03, 0xF8, 0x00, 0x1F, 0xE0, 0x00, ##        0000000              00000000         
            0x07, 0xF0, 0x00, 0x1F, 0xE0, 0x00, ##       0000000               00000000         
            0x07, 0xF0, 0x00, 0x1F, 0xE0, 0x00, ##       0000000               00000000         
            0x0F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, ##      0000000                00000000         
            0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, ##     00000000                00000000         
            0x1F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, ##     0000000                 00000000         
            0x3F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, ##    00000000                 00000000         
            0x7F, 0x80, 0x00, 0x1F, 0xE0, 0x00, ##   00000000                  00000000         
            0x7F, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##   0000000                   00000000         
            0xFF, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##  00000000                   00000000         
            0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##  0000000                    00000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 38, 
        'xoffset'  => 7, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, ##    00000000000000000000000000000000    
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                            
            0x3F, 0xCF, 0xFC, 0x00, 0x00, ##    00000000  0000000000                
            0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##    000000000000000000000000            
            0x3F, 0xFF, 0xFF, 0xF0, 0x00, ##    00000000000000000000000000          
            0x3F, 0xFF, 0xFF, 0xFC, 0x00, ##    0000000000000000000000000000        
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000       
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000      
            0x3F, 0xC0, 0x1F, 0xFF, 0x80, ##    00000000         00000000000000     
            0x3C, 0x00, 0x03, 0xFF, 0xC0, ##    0000                000000000000    
            0x30, 0x00, 0x00, 0xFF, 0xE0, ##    00                    00000000000   
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000   
            0x00, 0x00, 0x00, 0x3F, 0xF0, ##                            0000000000  
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000  
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000 
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000 
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000 
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000 
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000 
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000 
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000 
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000 
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000  
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000  
            0x80, 0x00, 0x00, 0x3F, 0xE0, ##  0                         000000000   
            0xE0, 0x00, 0x00, 0xFF, 0xC0, ##  000                     0000000000    
            0xFC, 0x00, 0x01, 0xFF, 0xC0, ##  000000                 00000000000    
            0xFF, 0xC0, 0x0F, 0xFF, 0x80, ##  0000000000          0000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  00000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000          
            0x3F, 0xFF, 0xFF, 0x80, 0x00, ##    00000000000000000000000             
            0x01, 0xFF, 0xF8, 0x00, 0x00, ##         00000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                     00000000000           
            0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, ##                 00000000000000000000      
            0x00, 0x07, 0xFF, 0xFF, 0xF8, 0x00, ##               000000000000000000000000    
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000    
            0x00, 0x3F, 0xFF, 0xFF, 0xF8, 0x00, ##            000000000000000000000000000    
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000    
            0x00, 0xFF, 0xF0, 0x07, 0xF8, 0x00, ##          000000000000         00000000    
            0x01, 0xFF, 0xC0, 0x00, 0x78, 0x00, ##         00000000000               0000    
            0x03, 0xFF, 0x00, 0x00, 0x18, 0x00, ##        0000000000                   00    
            0x07, 0xFE, 0x00, 0x00, 0x00, 0x00, ##       0000000000                          
            0x07, 0xFC, 0x00, 0x00, 0x00, 0x00, ##       000000000                           
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##      000000000                            
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##      00000000                             
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##     000000000                             
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                              
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                              
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                               
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                               
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                               
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##   0000000          000000000              
            0xFF, 0x01, 0xFF, 0xFC, 0x00, 0x00, ##  00000000       000000000000000           
            0xFF, 0x07, 0xFF, 0xFF, 0x00, 0x00, ##  00000000     0000000000000000000         
            0xFF, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##  00000000    0000000000000000000000       
            0xFF, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, ##  00000000   000000000000000000000000      
            0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, ##  00000000  00000000000000000000000000     
            0xFF, 0x7F, 0xC0, 0x7F, 0xF8, 0x00, ##  00000000 000000000       000000000000    
            0xFF, 0xFF, 0x00, 0x1F, 0xF8, 0x00, ##  0000000000000000           0000000000    
            0xFF, 0xFC, 0x00, 0x07, 0xFC, 0x00, ##  00000000000000               000000000   
            0xFF, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##  0000000000000                 000000000  
            0xFF, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##  000000000000                  000000000  
            0xFF, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##  000000000000                   00000000  
            0xFF, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##  00000000000                    000000000 
            0xFF, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##  00000000000                     00000000 
            0xFF, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##  0000000000                      00000000 
            0xFF, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##  0000000000                      00000000 
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##  0000000000                       00000000
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##  0000000000                       00000000
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##  0000000000                       00000000
            0xFF, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##  0000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##    00000000                       00000000
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000 
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000 
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##    000000000                     00000000 
            0x1F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##     00000000                    000000000 
            0x1F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##     000000000                   00000000  
            0x0F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##      00000000                  000000000  
            0x0F, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##      000000000                 000000000  
            0x07, 0xFC, 0x00, 0x07, 0xFC, 0x00, ##       000000000               000000000   
            0x07, 0xFF, 0x00, 0x1F, 0xF8, 0x00, ##       00000000000           0000000000    
            0x03, 0xFF, 0xC0, 0x7F, 0xF8, 0x00, ##        000000000000       000000000000    
            0x01, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##         00000000000000000000000000000     
            0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          000000000000000000000000000      
            0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##           000000000000000000000000        
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000         
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000           
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000 
            0x00, 0x00, 0x00, 0x03, 0xFE, ##                                000000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000  
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000  
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000  
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000   
            0x00, 0x00, 0x00, 0x0F, 0xF8, ##                              000000000   
            0x00, 0x00, 0x00, 0x0F, 0xF0, ##                              00000000    
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000    
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000    
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000     
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000     
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000      
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000      
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000      
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000       
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000       
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000       
            0x00, 0x00, 0x00, 0xFF, 0x00, ##                          00000000        
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000        
            0x00, 0x00, 0x01, 0xFE, 0x00, ##                         00000000         
            0x00, 0x00, 0x03, 0xFE, 0x00, ##                        000000000         
            0x00, 0x00, 0x03, 0xFE, 0x00, ##                        000000000         
            0x00, 0x00, 0x03, 0xFC, 0x00, ##                        00000000          
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000          
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000          
            0x00, 0x00, 0x0F, 0xF8, 0x00, ##                      000000000           
            0x00, 0x00, 0x0F, 0xF8, 0x00, ##                      000000000           
            0x00, 0x00, 0x0F, 0xF0, 0x00, ##                      00000000            
            0x00, 0x00, 0x1F, 0xF0, 0x00, ##                     000000000            
            0x00, 0x00, 0x1F, 0xF0, 0x00, ##                     000000000            
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000             
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000             
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000              
            0x00, 0x00, 0x7F, 0xC0, 0x00, ##                   000000000              
            0x00, 0x00, 0x7F, 0xC0, 0x00, ##                   000000000              
            0x00, 0x00, 0x7F, 0x80, 0x00, ##                   00000000               
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000               
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000               
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000                
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                 
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                 
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                 
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000                  
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000                  
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000                  
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000                   
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000                   
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000                    
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000                    
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000                    
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                     
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                     
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                      
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                      
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000               
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, ##            000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        00000000000000000000000000000      
            0x07, 0xFF, 0x80, 0xFF, 0xF0, 0x00, ##       000000000000       000000000000     
            0x0F, 0xFC, 0x00, 0x1F, 0xF8, 0x00, ##      0000000000             0000000000    
            0x0F, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##      000000000               000000000    
            0x1F, 0xF0, 0x00, 0x07, 0xFC, 0x00, ##     000000000                 000000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x3F, 0xE0, 0x00, 0x03, 0xFE, 0x00, ##    000000000                   000000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x0F, 0xE0, 0x00, 0x03, 0xF8, 0x00, ##      0000000                   0000000    
            0x0F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##      00000000                 00000000    
            0x07, 0xF8, 0x00, 0x0F, 0xF0, 0x00, ##       00000000               00000000     
            0x03, 0xFC, 0x00, 0x1F, 0xE0, 0x00, ##        00000000             00000000      
            0x01, 0xFF, 0x80, 0xFF, 0xC0, 0x00, ##         0000000000       0000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, ##            000000000000000000000          
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##              000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##           000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x03, 0xFF, 0x00, 0x7F, 0xF0, 0x00, ##        0000000000         00000000000     
            0x07, 0xFC, 0x00, 0x1F, 0xF8, 0x00, ##       000000000             0000000000    
            0x0F, 0xF0, 0x00, 0x07, 0xFC, 0x00, ##      00000000                 000000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x80, 0x00, 0x00, 0xFF, 0x80, ##  000000000                       000000000
            0xFF, 0x80, 0x00, 0x00, 0xFF, 0x00, ##  000000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0xC0, 0x00, 0x01, 0xFF, 0x00, ##   000000000                     000000000 
            0x7F, 0xC0, 0x00, 0x01, 0xFF, 0x00, ##   000000000                     000000000 
            0x3F, 0xE0, 0x00, 0x03, 0xFE, 0x00, ##    000000000                   000000000  
            0x3F, 0xF0, 0x00, 0x07, 0xFE, 0x00, ##    0000000000                 0000000000  
            0x1F, 0xFC, 0x00, 0x1F, 0xFC, 0x00, ##     00000000000             00000000000   
            0x0F, 0xFF, 0x00, 0x7F, 0xF8, 0x00, ##      000000000000         000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        00000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##           00000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##             0000000000000000000           
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 41, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, ##                 0000000000                
            0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x00, ##             00000000000000000             
            0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x00, ##           000000000000000000000           
            0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##          000000000000000000000000         
            0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##        000000000000000000000000000        
            0x07, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##       00000000000000000000000000000       
            0x0F, 0xFF, 0x01, 0xFF, 0xE0, 0x00, ##      000000000000       000000000000      
            0x0F, 0xFC, 0x00, 0x7F, 0xF0, 0x00, ##      0000000000           00000000000     
            0x1F, 0xF0, 0x00, 0x1F, 0xF0, 0x00, ##     000000000               000000000     
            0x3F, 0xE0, 0x00, 0x0F, 0xF8, 0x00, ##    000000000                 000000000    
            0x3F, 0xE0, 0x00, 0x07, 0xF8, 0x00, ##    000000000                  00000000    
            0x3F, 0xC0, 0x00, 0x07, 0xFC, 0x00, ##    00000000                   000000000   
            0x7F, 0x80, 0x00, 0x03, 0xFC, 0x00, ##   00000000                     00000000   
            0x7F, 0x80, 0x00, 0x03, 0xFC, 0x00, ##   00000000                     00000000   
            0x7F, 0x80, 0x00, 0x01, 0xFE, 0x00, ##   00000000                      00000000  
            0xFF, 0x80, 0x00, 0x01, 0xFE, 0x00, ##  000000000                      00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000
            0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##  000000000                      0000000000
            0x7F, 0x80, 0x00, 0x01, 0xFF, 0x80, ##   00000000                      0000000000
            0x7F, 0x80, 0x00, 0x03, 0xFF, 0x80, ##   00000000                     00000000000
            0x7F, 0x80, 0x00, 0x03, 0xFF, 0x80, ##   00000000                     00000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFF, 0x80, ##    00000000                   000000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFF, 0x80, ##    00000000                   000000000000
            0x3F, 0xE0, 0x00, 0x0F, 0xFF, 0x80, ##    000000000                 0000000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFF, 0x80, ##     000000000               00000000000000
            0x0F, 0xF8, 0x00, 0x7F, 0xFF, 0x80, ##      000000000            0000000000000000
            0x0F, 0xFF, 0x01, 0xFF, 0x7F, 0x80, ##      000000000000       000000000 00000000
            0x07, 0xFF, 0xFF, 0xFE, 0x7F, 0x80, ##       00000000000000000000000000  00000000
            0x03, 0xFF, 0xFF, 0xFC, 0x7F, 0x80, ##        000000000000000000000000   00000000
            0x01, 0xFF, 0xFF, 0xF8, 0x7F, 0x80, ##         0000000000000000000000    00000000
            0x00, 0x7F, 0xFF, 0xF0, 0x7F, 0x80, ##           0000000000000000000     00000000
            0x00, 0x1F, 0xFF, 0xC0, 0x7F, 0x00, ##             000000000000000       0000000 
            0x00, 0x03, 0xFE, 0x00, 0xFF, 0x00, ##                000000000         00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000  
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000  
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000   
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000   
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000   
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000    
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##                              000000000    
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000     
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000     
            0x0C, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##      00                   0000000000      
            0x0F, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##      0000               00000000000       
            0x0F, 0xF0, 0x07, 0xFF, 0x80, 0x00, ##      00000000         000000000000        
            0x0F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##      0000000000000000000000000000         
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##      000000000000000000000000000          
            0x0F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##      00000000000000000000000000           
            0x0F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##      000000000000000000000000             
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##        00000000000000000000               
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##             00000000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 11, 
        'xoffset'  => 21, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 15, 
        'xoffset'  => 17, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x00, 0x00, ##                 
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFE, ##      00000000000
            0x0F, 0xFC, ##      0000000000 
            0x1F, 0xFC, ##     00000000000 
            0x1F, 0xF8, ##     0000000000  
            0x1F, 0xF8, ##     0000000000  
            0x1F, 0xF0, ##     000000000   
            0x3F, 0xE0, ##    000000000    
            0x3F, 0xE0, ##    000000000    
            0x3F, 0xC0, ##    00000000     
            0x3F, 0xC0, ##    00000000     
            0x3F, 0x80, ##    0000000      
            0x7F, 0x80, ##   00000000      
            0x7F, 0x00, ##   0000000       
            0x7F, 0x00, ##   0000000       
            0x7E, 0x00, ##   000000        
            0xFE, 0x00, ##  0000000        
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x08, ##                                              0
            0x00, 0x00, 0x00, 0x00, 0x00, 0x38, ##                                            000
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, ##                                         000000
            0x00, 0x00, 0x00, 0x00, 0x07, 0xF8, ##                                       00000000
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, ##                                    00000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, ##                                  0000000000000
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, ##                               0000000000000000
            0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF8, ##                             000000000000000000
            0x00, 0x00, 0x00, 0xFF, 0xFF, 0xF0, ##                          00000000000000000000 
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, ##                       00000000000000000000    
            0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x00, ##                     0000000000000000000       
            0x00, 0x00, 0xFF, 0xFF, 0xF0, 0x00, ##                  00000000000000000000         
            0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, ##                0000000000000000000            
            0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##             0000000000000000000               
            0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, ##           0000000000000000000                 
            0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##        0000000000000000000                    
            0x0F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##      000000000000000000                       
            0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##   0000000000000000000                         
            0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  00000000000000000                            
            0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, ##  00000000000000                               
            0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##  000000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                    
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  00000000000                                  
            0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, ##  00000000000000                               
            0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  00000000000000000                            
            0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##   000000000000000000                          
            0x1F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##     0000000000000000000                       
            0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##        0000000000000000000                    
            0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, ##           000000000000000000                  
            0x00, 0x1F, 0xFF, 0xFC, 0x00, 0x00, ##             0000000000000000000               
            0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, ##                0000000000000000000            
            0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, ##                  0000000000000000000          
            0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x00, ##                     0000000000000000000       
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, ##                       00000000000000000000    
            0x00, 0x00, 0x00, 0xFF, 0xFF, 0xE0, ##                          0000000000000000000  
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF8, ##                            0000000000000000000
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, ##                               0000000000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xF8, ##                                 00000000000000
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, ##                                    00000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##                                      000000000
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, ##                                         000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x78, ##                                           0000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x08, ##                                              0
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0                                            
            0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000                                          
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                       
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                     
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  00000000000                                  
            0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##  0000000000000                                
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000                             
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##  000000000000000000                           
            0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##   00000000000000000000                        
            0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##      00000000000000000000                     
            0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##         0000000000000000000                   
            0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, ##           00000000000000000000                
            0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##              0000000000000000000              
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000           
            0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, ##                   0000000000000000000         
            0x00, 0x00, 0x0F, 0xFF, 0xFE, 0x00, ##                      0000000000000000000      
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0x80, ##                         000000000000000000    
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0, ##                           0000000000000000000 
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF8, ##                              00000000000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xF8, ##                                 00000000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, ##                                   000000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##                                      000000000
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, ##                                    00000000000
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xF8, ##                                 00000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF8, ##                              00000000000000000
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                            000000000000000000 
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0xC0, ##                         0000000000000000000   
            0x00, 0x00, 0x0F, 0xFF, 0xFE, 0x00, ##                      0000000000000000000      
            0x00, 0x00, 0x3F, 0xFF, 0xF0, 0x00, ##                    000000000000000000         
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, ##                 0000000000000000000           
            0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##              0000000000000000000              
            0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x00, ##            0000000000000000000                
            0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##         0000000000000000000                   
            0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##      00000000000000000000                     
            0x3F, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##    0000000000000000000                        
            0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  0000000000000000000                          
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000                             
            0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, ##  00000000000000                               
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  00000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                    
            0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000                                       
            0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000                                         
            0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 33, 
        'xoffset'  => 11, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xF8, 0x00, 0x00, ##            00000000000            
            0x03, 0xFF, 0xFF, 0x00, 0x00, ##        000000000000000000         
            0x1F, 0xFF, 0xFF, 0xC0, 0x00, ##     00000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xF0, 0x00, ##   000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000   
            0xFF, 0xE0, 0x3F, 0xFE, 0x00, ##  00000000000       0000000000000  
            0xFE, 0x00, 0x07, 0xFE, 0x00, ##  0000000              0000000000  
            0xF8, 0x00, 0x03, 0xFF, 0x00, ##  00000                 0000000000 
            0xE0, 0x00, 0x01, 0xFF, 0x00, ##  000                    000000000 
            0xC0, 0x00, 0x00, 0xFF, 0x00, ##  00                      00000000 
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000
            0x00, 0x00, 0x00, 0xFF, 0x00, ##                          00000000 
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000 
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000 
            0x00, 0x00, 0x03, 0xFE, 0x00, ##                        000000000  
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000   
            0x00, 0x00, 0x0F, 0xFC, 0x00, ##                      0000000000   
            0x00, 0x00, 0x1F, 0xF8, 0x00, ##                     0000000000    
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000     
            0x00, 0x00, 0xFF, 0xE0, 0x00, ##                  00000000000      
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000       
            0x00, 0x03, 0xFF, 0x80, 0x00, ##                00000000000        
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000         
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000          
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000           
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000             
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 49, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                          0000000000               
            0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##                      000000000000000000           
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##                   00000000000000000000000         
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                 00000000000000000000000000        
            0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##                0000000000000000000000000000       
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##              00000000000000000000000000000000     
            0x00, 0x1F, 0xFF, 0x00, 0x7F, 0xF0, 0x00, ##             0000000000000         00000000000     
            0x00, 0x3F, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##            00000000000               000000000    
            0x00, 0x7F, 0xE0, 0x00, 0x07, 0xFC, 0x00, ##           0000000000                  000000000   
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFC, 0x00, ##          000000000                      0000000   
            0x01, 0xFF, 0x00, 0x00, 0x00, 0xFE, 0x00, ##         000000000                        0000000  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFE, 0x00, ##         00000000                         0000000  
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, ##        00000000                           0000000 
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x3F, 0x00, ##       00000000                             000000 
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x3F, 0x00, ##       0000000                              000000 
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x80, ##      0000000                               0000000
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x1F, 0x80, ##      0000000                                000000
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x80, ##     0000000                                 000000
            0x1F, 0xC0, 0x00, 0x0F, 0xF0, 0x1F, 0x80, ##     0000000                  00000000       000000
            0x1F, 0x80, 0x00, 0x7F, 0xFE, 0x1F, 0x80, ##     000000                00000000000000    000000
            0x3F, 0x80, 0x00, 0xFF, 0xFF, 0x1F, 0x80, ##    0000000               0000000000000000   000000
            0x3F, 0x00, 0x03, 0xFF, 0xFF, 0x9F, 0x80, ##    000000              0000000000000000000  000000
            0x3F, 0x00, 0x07, 0xFF, 0xFF, 0xDF, 0x80, ##    000000             000000000000000000000 000000
            0x7F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##   0000000            00000000000000000000000000000
            0x7E, 0x00, 0x1F, 0xFC, 0x0F, 0xFF, 0x80, ##   000000            00000000000      0000000000000
            0x7E, 0x00, 0x1F, 0xF0, 0x03, 0xFF, 0x80, ##   000000            000000000          00000000000
            0x7E, 0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x80, ##   000000           00000000              000000000
            0x7E, 0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x80, ##   000000           00000000              000000000
            0xFE, 0x00, 0x7F, 0x80, 0x00, 0x7F, 0x80, ##  0000000          00000000                00000000
            0xFC, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x80, ##  000000           0000000                  0000000
            0xFC, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x80, ##  000000           0000000                  0000000
            0xFC, 0x00, 0xFF, 0x00, 0x00, 0x3F, 0x80, ##  000000          00000000                  0000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, ##  000000          0000000                    000000
            0xFC, 0x00, 0xFF, 0x00, 0x00, 0x3F, 0x80, ##  000000          00000000                  0000000
            0xFC, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x80, ##  000000           0000000                  0000000
            0xFC, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x80, ##  000000           0000000                  0000000
            0xFE, 0x00, 0x7F, 0x80, 0x00, 0x7F, 0x80, ##  0000000          00000000                00000000
            0x7E, 0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x80, ##   000000           00000000              000000000
            0x7E, 0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x80, ##   000000           00000000              000000000
            0x7E, 0x00, 0x1F, 0xF0, 0x03, 0xFF, 0x80, ##   000000            000000000          00000000000
            0x7E, 0x00, 0x1F, 0xFC, 0x0F, 0xFF, 0x80, ##   000000            00000000000      0000000000000
            0x7F, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##   0000000            00000000000000000000000000000
            0x3F, 0x00, 0x07, 0xFF, 0xFF, 0xDF, 0x80, ##    000000             000000000000000000000 000000
            0x3F, 0x00, 0x03, 0xFF, 0xFF, 0x9F, 0x80, ##    000000              0000000000000000000  000000
            0x3F, 0x80, 0x01, 0xFF, 0xFF, 0x1F, 0x80, ##    0000000              00000000000000000   000000
            0x1F, 0x80, 0x00, 0x7F, 0xFE, 0x1F, 0x80, ##     000000                00000000000000    000000
            0x1F, 0xC0, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##     0000000                  00000000             
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##     0000000                                       
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##      0000000                                      
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##      0000000                                      
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, ##       0000000                                     
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##       00000000                                    
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##        00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##          00000000                                 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##           0000000000                              
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##            0000000000                             
            0x00, 0x1F, 0xFE, 0x00, 0x00, 0x80, 0x00, ##             000000000000                 0        
            0x00, 0x0F, 0xFF, 0xC0, 0x07, 0xC0, 0x00, ##              00000000000000           00000       
            0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##                0000000000000000000000000000       
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##                 0000000000000000000000000000      
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xE0, 0x00, ##                   00000000000000000000000000      
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, ##                     000000000000000000000000      
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                        00000000000000000000       
            0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                             00000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                 0000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##              000000000       00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, ##              00000000        00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF8, 0x00, 0x00, ##              00000000        000000000            
            0x00, 0x1F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##             000000000         00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xFC, 0x00, 0x00, ##             00000000          000000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##            000000000           00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, 0x00, ##            00000000            00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFE, 0x00, 0x00, ##            00000000            000000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0x80, 0x01, 0xFF, 0x00, 0x00, ##           00000000              000000000         
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x00, ##          000000000              000000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x00, 0x00, ##          000000000               00000000         
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##      000000000                      000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##      000000000                       00000000     
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     00000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##    000000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##    000000000                           00000000   
            0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    00000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   000000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##   000000000                             00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 41, 
        'xoffset'  => 7, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  0000000000000000000000000000000          
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  00000000000000000000000000000000000      
            0xFF, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##  00000000                000000000000     
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000    
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, ##  00000000                      00000000   
            0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, ##  00000000                      00000000   
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, ##  00000000                      00000000   
            0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, ##  00000000                      00000000   
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000    
            0xFF, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##  00000000                000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  00000000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  000000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  0000000000000000000000000000000          
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  00000000000000000000000000000000000      
            0xFF, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##  00000000                000000000000     
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000    
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x03, 0xFC, 0x00, ##  00000000                      00000000   
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##  00000000                       00000000  
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x00, ##  00000000                         0000000 
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000  
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000   
            0xFF, 0x00, 0x00, 0xFF, 0xFC, 0x00, ##  00000000                00000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  0000000000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##  00000000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  000000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000000000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000         
            0x00, 0x00, 0xFF, 0xFF, 0xF0, ##                  00000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                000000000000000000000000  
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, ##              0000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, ##             00000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xFF, ##            000000000000000000000000000000
            0x00, 0x7F, 0xF8, 0x03, 0xFF, ##           000000000000         0000000000
            0x00, 0xFF, 0xE0, 0x00, 0x7F, ##          00000000000              0000000
            0x01, 0xFF, 0x80, 0x00, 0x1F, ##         0000000000                  00000
            0x03, 0xFF, 0x00, 0x00, 0x07, ##        0000000000                     000
            0x07, 0xFE, 0x00, 0x00, 0x03, ##       0000000000                       00
            0x07, 0xFC, 0x00, 0x00, 0x01, ##       000000000                         0
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                               
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                              
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x07, 0xFC, 0x00, 0x00, 0x01, ##       000000000                         0
            0x07, 0xFE, 0x00, 0x00, 0x03, ##       0000000000                       00
            0x03, 0xFF, 0x00, 0x00, 0x07, ##        0000000000                     000
            0x01, 0xFF, 0x80, 0x00, 0x1F, ##         0000000000                  00000
            0x00, 0xFF, 0xE0, 0x00, 0x7F, ##          00000000000              0000000
            0x00, 0x7F, 0xF8, 0x03, 0xFF, ##           000000000000         0000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xFF, ##            000000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, ##             00000000000000000000000000000
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, ##              0000000000000000000000000000
            0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                000000000000000000000000  
            0x00, 0x00, 0xFF, 0xFF, 0xF0, ##                  00000000000000000000    
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##  00000000000000000000                     
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##  000000000000000000000000                 
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  000000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  000000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000         
            0xFF, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##  00000000          000000000000000        
            0xFF, 0x00, 0x03, 0xFF, 0xC0, 0x00, ##  00000000              000000000000       
            0xFF, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##  00000000                00000000000      
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000     
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000     
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, ##  00000000                        00000000 
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000     
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000     
            0xFF, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##  00000000                00000000000      
            0xFF, 0x00, 0x03, 0xFF, 0xC0, 0x00, ##  00000000              000000000000       
            0xFF, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##  00000000          000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  0000000000000000000000000000000          
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  000000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##  000000000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##  00000000000000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 38, 
        'xoffset'  => 10, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000   
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 42, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##                      00000000000           
            0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, ##                  0000000000000000000       
            0x00, 0x03, 0xFF, 0xFF, 0xF8, 0x00, ##                00000000000000000000000     
            0x00, 0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##              000000000000000000000000000   
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x00, ##             00000000000000000000000000000  
            0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##            000000000000000000000000000000  
            0x00, 0x7F, 0xF8, 0x03, 0xFF, 0x00, ##           000000000000         0000000000  
            0x00, 0xFF, 0xE0, 0x00, 0x7F, 0x00, ##          00000000000              0000000  
            0x01, 0xFF, 0x80, 0x00, 0x3F, 0x00, ##         0000000000                 000000  
            0x03, 0xFF, 0x00, 0x00, 0x0F, 0x00, ##        0000000000                    0000  
            0x07, 0xFE, 0x00, 0x00, 0x07, 0x00, ##       0000000000                      000  
            0x07, 0xFC, 0x00, 0x00, 0x03, 0x00, ##       000000000                        00  
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##      000000000                             
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##      000000000                             
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##     000000000                              
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##     000000000                              
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                               
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                               
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                               
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                 
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xC0, ##  000000000                00000000000000000
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##  000000000                         00000000
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##  000000000                         00000000
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##   00000000                         00000000
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000
            0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, ##    000000000                       00000000
            0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, ##    000000000                       00000000
            0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, ##    000000000                       00000000
            0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xC0, ##     000000000                      00000000
            0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xC0, ##     000000000                      00000000
            0x0F, 0xF0, 0x00, 0x00, 0x3F, 0xC0, ##      00000000                      00000000
            0x0F, 0xF8, 0x00, 0x00, 0x3F, 0xC0, ##      000000000                     00000000
            0x07, 0xFC, 0x00, 0x00, 0x3F, 0xC0, ##       000000000                    00000000
            0x07, 0xFC, 0x00, 0x00, 0x3F, 0xC0, ##       000000000                    00000000
            0x03, 0xFE, 0x00, 0x00, 0x3F, 0xC0, ##        000000000                   00000000
            0x01, 0xFF, 0x80, 0x00, 0x3F, 0xC0, ##         0000000000                 00000000
            0x00, 0xFF, 0xC0, 0x00, 0xFF, 0xC0, ##          0000000000              0000000000
            0x00, 0xFF, 0xF8, 0x07, 0xFF, 0xC0, ##          0000000000000        0000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, ##           000000000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, ##             000000000000000000000000000000 
            0x00, 0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##              000000000000000000000000000   
            0x00, 0x03, 0xFF, 0xFF, 0xF8, 0x00, ##                00000000000000000000000     
            0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, ##                  0000000000000000000       
            0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##                      00000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 35, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 35, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##             000000000000000000000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000 
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000 
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000 
            0x80, 0x00, 0x00, 0x3F, 0xC0, ##  0                         00000000 
            0xE0, 0x00, 0x00, 0x7F, 0xC0, ##  000                      000000000 
            0xF0, 0x00, 0x00, 0x7F, 0x80, ##  0000                     00000000  
            0xFC, 0x00, 0x00, 0xFF, 0x80, ##  000000                  000000000  
            0xFF, 0x00, 0x01, 0xFF, 0x00, ##  00000000               000000000   
            0xFF, 0xE0, 0x0F, 0xFF, 0x00, ##  00000000000         000000000000   
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000      
            0x3F, 0xFF, 0xFF, 0xF0, 0x00, ##    00000000000000000000000000       
            0x07, 0xFF, 0xFF, 0x80, 0x00, ##       00000000000000000000          
            0x00, 0x3F, 0xFC, 0x00, 0x00, ##            000000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 46, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##  00000000                          0000000000  
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##  00000000                         0000000000   
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0xE0, ##  00000000                        00000000000   
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0xC0, ##  00000000                       00000000000    
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000     
            0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, ##  00000000                      0000000000      
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000       
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000        
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000         
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000          
            0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##  00000000                 0000000000           
            0xFF, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##  00000000                0000000000            
            0xFF, 0x00, 0x01, 0xFF, 0x80, 0x00, ##  00000000               0000000000             
            0xFF, 0x00, 0x03, 0xFF, 0x00, 0x00, ##  00000000              0000000000              
            0xFF, 0x00, 0x07, 0xFE, 0x00, 0x00, ##  00000000             0000000000               
            0xFF, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##  00000000            0000000000                
            0xFF, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##  00000000           0000000000                 
            0xFF, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##  00000000          0000000000                  
            0xFF, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##  00000000         0000000000                   
            0xFF, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##  00000000        00000000000                   
            0xFF, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##  00000000       00000000000                    
            0xFF, 0x01, 0xFF, 0x80, 0x00, 0x00, ##  00000000       0000000000                     
            0xFF, 0x03, 0xFF, 0x00, 0x00, 0x00, ##  00000000      0000000000                      
            0xFF, 0x07, 0xFE, 0x00, 0x00, 0x00, ##  00000000     0000000000                       
            0xFF, 0x0F, 0xFC, 0x00, 0x00, 0x00, ##  00000000    0000000000                        
            0xFF, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##  00000000   0000000000                         
            0xFF, 0x3F, 0xF0, 0x00, 0x00, 0x00, ##  00000000  0000000000                          
            0xFF, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##  00000000 000000000000                         
            0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##  0000000000000000000000                        
            0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##  0000000000000000000000                        
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##  00000000000000000000000                       
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##  000000000000000000000000                      
            0xFF, 0xFD, 0xFF, 0x00, 0x00, 0x00, ##  00000000000000 000000000                      
            0xFF, 0xF8, 0xFF, 0x80, 0x00, 0x00, ##  0000000000000   000000000                     
            0xFF, 0xF0, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000    0000000000                    
            0xFF, 0xE0, 0x7F, 0xC0, 0x00, 0x00, ##  00000000000      000000000                    
            0xFF, 0xC0, 0x7F, 0xE0, 0x00, 0x00, ##  0000000000       0000000000                   
            0xFF, 0x80, 0x3F, 0xF0, 0x00, 0x00, ##  000000000         0000000000                  
            0xFF, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##  00000000           000000000                  
            0xFF, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##  00000000           0000000000                 
            0xFF, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##  00000000            0000000000                
            0xFF, 0x00, 0x07, 0xFE, 0x00, 0x00, ##  00000000             0000000000               
            0xFF, 0x00, 0x07, 0xFE, 0x00, 0x00, ##  00000000             0000000000               
            0xFF, 0x00, 0x03, 0xFF, 0x00, 0x00, ##  00000000              0000000000              
            0xFF, 0x00, 0x01, 0xFF, 0x80, 0x00, ##  00000000               0000000000             
            0xFF, 0x00, 0x01, 0xFF, 0x80, 0x00, ##  00000000               0000000000             
            0xFF, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##  00000000                0000000000            
            0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##  00000000                 0000000000           
            0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##  00000000                 0000000000           
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000          
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000         
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000         
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000        
            0xFF, 0x00, 0x00, 0x0F, 0xFE, 0x00, ##  00000000                    00000000000       
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, ##  00000000                      0000000000      
            0xFF, 0x00, 0x00, 0x03, 0xFF, 0x80, ##  00000000                      00000000000     
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000     
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##  00000000                        0000000000    
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0xE0, ##  00000000                        00000000000   
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##  00000000                         0000000000   
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##  00000000                          0000000000  
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xF8, ##  00000000                          00000000000 
            0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##  00000000                           0000000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 40, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  0000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xF8, ##  000000000000                     000000000000
            0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xF8, ##  000000000000                     000000000000
            0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xF8, ##  000000000000                     000000000000
            0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xF8, ##  0000000000000                   0000000000000
            0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xF8, ##  0000000000000                   0000000000000
            0xFF, 0xF8, 0x00, 0x00, 0xFF, 0xF8, ##  0000000000000                   0000000000000
            0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xF8, ##  00000000000000                 00000000000000
            0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xF8, ##  00000000000000                 00000000000000
            0xFF, 0xFC, 0x00, 0x01, 0xFF, 0xF8, ##  00000000000000                 00000000000000
            0xFF, 0x7E, 0x00, 0x03, 0xF7, 0xF8, ##  00000000 000000               000000 00000000
            0xFF, 0x7E, 0x00, 0x03, 0xF7, 0xF8, ##  00000000 000000               000000 00000000
            0xFF, 0x7E, 0x00, 0x03, 0xF7, 0xF8, ##  00000000 000000               000000 00000000
            0xFF, 0x3F, 0x00, 0x07, 0xE7, 0xF8, ##  00000000  000000             000000  00000000
            0xFF, 0x3F, 0x00, 0x07, 0xE7, 0xF8, ##  00000000  000000             000000  00000000
            0xFF, 0x3F, 0x00, 0x07, 0xE7, 0xF8, ##  00000000  000000             000000  00000000
            0xFF, 0x1F, 0x80, 0x0F, 0xC7, 0xF8, ##  00000000   000000           000000   00000000
            0xFF, 0x1F, 0x80, 0x0F, 0xC7, 0xF8, ##  00000000   000000           000000   00000000
            0xFF, 0x1F, 0x80, 0x0F, 0xC7, 0xF8, ##  00000000   000000           000000   00000000
            0xFF, 0x0F, 0xC0, 0x1F, 0x87, 0xF8, ##  00000000    000000         000000    00000000
            0xFF, 0x0F, 0xC0, 0x1F, 0x87, 0xF8, ##  00000000    000000         000000    00000000
            0xFF, 0x0F, 0xC0, 0x1F, 0x87, 0xF8, ##  00000000    000000         000000    00000000
            0xFF, 0x07, 0xE0, 0x3F, 0x07, 0xF8, ##  00000000     000000       000000     00000000
            0xFF, 0x07, 0xE0, 0x3F, 0x07, 0xF8, ##  00000000     000000       000000     00000000
            0xFF, 0x07, 0xE0, 0x3F, 0x07, 0xF8, ##  00000000     000000       000000     00000000
            0xFF, 0x03, 0xF0, 0x7E, 0x07, 0xF8, ##  00000000      000000     000000      00000000
            0xFF, 0x03, 0xF0, 0x7E, 0x07, 0xF8, ##  00000000      000000     000000      00000000
            0xFF, 0x03, 0xF0, 0xFE, 0x07, 0xF8, ##  00000000      000000    0000000      00000000
            0xFF, 0x01, 0xF8, 0xFC, 0x07, 0xF8, ##  00000000       000000   000000       00000000
            0xFF, 0x01, 0xF8, 0xFC, 0x07, 0xF8, ##  00000000       000000   000000       00000000
            0xFF, 0x01, 0xF9, 0xFC, 0x07, 0xF8, ##  00000000       000000  0000000       00000000
            0xFF, 0x00, 0xFD, 0xF8, 0x07, 0xF8, ##  00000000        000000 000000        00000000
            0xFF, 0x00, 0xFD, 0xF8, 0x07, 0xF8, ##  00000000        000000 000000        00000000
            0xFF, 0x00, 0xFF, 0xF8, 0x07, 0xF8, ##  00000000        0000000000000        00000000
            0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xF8, ##  00000000         00000000000         00000000
            0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xF8, ##  00000000         00000000000         00000000
            0xFF, 0x00, 0x7F, 0xF0, 0x07, 0xF8, ##  00000000         00000000000         00000000
            0xFF, 0x00, 0x3F, 0xE0, 0x07, 0xF8, ##  00000000          000000000          00000000
            0xFF, 0x00, 0x3F, 0xE0, 0x07, 0xF8, ##  00000000          000000000          00000000
            0xFF, 0x00, 0x3F, 0xE0, 0x07, 0xF8, ##  00000000          000000000          00000000
            0xFF, 0x00, 0x1F, 0xC0, 0x07, 0xF8, ##  00000000           0000000           00000000
            0xFF, 0x00, 0x1F, 0xC0, 0x07, 0xF8, ##  00000000           0000000           00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xF8, ##  00000000                             00000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xE0, 0x00, 0x00, 0xFF, ##  00000000000                     00000000
            0xFF, 0xE0, 0x00, 0x00, 0xFF, ##  00000000000                     00000000
            0xFF, 0xF0, 0x00, 0x00, 0xFF, ##  000000000000                    00000000
            0xFF, 0xF0, 0x00, 0x00, 0xFF, ##  000000000000                    00000000
            0xFF, 0xF0, 0x00, 0x00, 0xFF, ##  000000000000                    00000000
            0xFF, 0xF8, 0x00, 0x00, 0xFF, ##  0000000000000                   00000000
            0xFF, 0xF8, 0x00, 0x00, 0xFF, ##  0000000000000                   00000000
            0xFF, 0xFC, 0x00, 0x00, 0xFF, ##  00000000000000                  00000000
            0xFF, 0xFC, 0x00, 0x00, 0xFF, ##  00000000000000                  00000000
            0xFF, 0xFC, 0x00, 0x00, 0xFF, ##  00000000000000                  00000000
            0xFF, 0xFE, 0x00, 0x00, 0xFF, ##  000000000000000                 00000000
            0xFF, 0xFE, 0x00, 0x00, 0xFF, ##  000000000000000                 00000000
            0xFF, 0xFF, 0x00, 0x00, 0xFF, ##  0000000000000000                00000000
            0xFF, 0x7F, 0x00, 0x00, 0xFF, ##  00000000 0000000                00000000
            0xFF, 0x7F, 0x00, 0x00, 0xFF, ##  00000000 0000000                00000000
            0xFF, 0x3F, 0x80, 0x00, 0xFF, ##  00000000  0000000               00000000
            0xFF, 0x3F, 0x80, 0x00, 0xFF, ##  00000000  0000000               00000000
            0xFF, 0x1F, 0xC0, 0x00, 0xFF, ##  00000000   0000000              00000000
            0xFF, 0x1F, 0xC0, 0x00, 0xFF, ##  00000000   0000000              00000000
            0xFF, 0x1F, 0xE0, 0x00, 0xFF, ##  00000000   00000000             00000000
            0xFF, 0x0F, 0xE0, 0x00, 0xFF, ##  00000000    0000000             00000000
            0xFF, 0x0F, 0xE0, 0x00, 0xFF, ##  00000000    0000000             00000000
            0xFF, 0x07, 0xF0, 0x00, 0xFF, ##  00000000     0000000            00000000
            0xFF, 0x07, 0xF0, 0x00, 0xFF, ##  00000000     0000000            00000000
            0xFF, 0x07, 0xF8, 0x00, 0xFF, ##  00000000     00000000           00000000
            0xFF, 0x03, 0xF8, 0x00, 0xFF, ##  00000000      0000000           00000000
            0xFF, 0x03, 0xF8, 0x00, 0xFF, ##  00000000      0000000           00000000
            0xFF, 0x01, 0xFC, 0x00, 0xFF, ##  00000000       0000000          00000000
            0xFF, 0x01, 0xFC, 0x00, 0xFF, ##  00000000       0000000          00000000
            0xFF, 0x01, 0xFE, 0x00, 0xFF, ##  00000000       00000000         00000000
            0xFF, 0x00, 0xFE, 0x00, 0xFF, ##  00000000        0000000         00000000
            0xFF, 0x00, 0xFE, 0x00, 0xFF, ##  00000000        0000000         00000000
            0xFF, 0x00, 0x7F, 0x00, 0xFF, ##  00000000         0000000        00000000
            0xFF, 0x00, 0x7F, 0x00, 0xFF, ##  00000000         0000000        00000000
            0xFF, 0x00, 0x7F, 0x80, 0xFF, ##  00000000         00000000       00000000
            0xFF, 0x00, 0x3F, 0x80, 0xFF, ##  00000000          0000000       00000000
            0xFF, 0x00, 0x3F, 0x80, 0xFF, ##  00000000          0000000       00000000
            0xFF, 0x00, 0x1F, 0xC0, 0xFF, ##  00000000           0000000      00000000
            0xFF, 0x00, 0x1F, 0xC0, 0xFF, ##  00000000           0000000      00000000
            0xFF, 0x00, 0x1F, 0xE0, 0xFF, ##  00000000           00000000     00000000
            0xFF, 0x00, 0x0F, 0xE0, 0xFF, ##  00000000            0000000     00000000
            0xFF, 0x00, 0x0F, 0xE0, 0xFF, ##  00000000            0000000     00000000
            0xFF, 0x00, 0x07, 0xF0, 0xFF, ##  00000000             0000000    00000000
            0xFF, 0x00, 0x07, 0xF0, 0xFF, ##  00000000             0000000    00000000
            0xFF, 0x00, 0x07, 0xF8, 0xFF, ##  00000000             00000000   00000000
            0xFF, 0x00, 0x03, 0xF8, 0xFF, ##  00000000              0000000   00000000
            0xFF, 0x00, 0x03, 0xF8, 0xFF, ##  00000000              0000000   00000000
            0xFF, 0x00, 0x01, 0xFC, 0xFF, ##  00000000               0000000  00000000
            0xFF, 0x00, 0x01, 0xFC, 0xFF, ##  00000000               0000000  00000000
            0xFF, 0x00, 0x00, 0xFE, 0xFF, ##  00000000                0000000 00000000
            0xFF, 0x00, 0x00, 0xFE, 0xFF, ##  00000000                0000000 00000000
            0xFF, 0x00, 0x00, 0xFF, 0xFF, ##  00000000                0000000000000000
            0xFF, 0x00, 0x00, 0x7F, 0xFF, ##  00000000                 000000000000000
            0xFF, 0x00, 0x00, 0x7F, 0xFF, ##  00000000                 000000000000000
            0xFF, 0x00, 0x00, 0x3F, 0xFF, ##  00000000                  00000000000000
            0xFF, 0x00, 0x00, 0x3F, 0xFF, ##  00000000                  00000000000000
            0xFF, 0x00, 0x00, 0x3F, 0xFF, ##  00000000                  00000000000000
            0xFF, 0x00, 0x00, 0x1F, 0xFF, ##  00000000                   0000000000000
            0xFF, 0x00, 0x00, 0x1F, 0xFF, ##  00000000                   0000000000000
            0xFF, 0x00, 0x00, 0x0F, 0xFF, ##  00000000                    000000000000
            0xFF, 0x00, 0x00, 0x0F, 0xFF, ##  00000000                    000000000000
            0xFF, 0x00, 0x00, 0x0F, 0xFF, ##  00000000                    000000000000
            0xFF, 0x00, 0x00, 0x07, 0xFF, ##  00000000                     00000000000
            0xFF, 0x00, 0x00, 0x07, 0xFF, ##  00000000                     00000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 42, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, ##               0000000000000000             
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##             00000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##           000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000       
            0x03, 0xFF, 0xC0, 0xFF, 0xF0, 0x00, ##        000000000000      000000000000      
            0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x00, ##        0000000000          0000000000      
            0x07, 0xFC, 0x00, 0x0F, 0xF8, 0x00, ##       000000000              000000000     
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x1F, 0xE0, 0x00, 0x01, 0xFE, 0x00, ##     00000000                    00000000   
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000  
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##   000000000                      00000000  
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, ##   00000000                        00000000 
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, ##  000000000                        00000000 
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, ##  000000000                        00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x80, ##   00000000                       000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##   000000000                      00000000  
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x1F, 0xE0, 0x00, 0x01, 0xFE, 0x00, ##     00000000                    00000000   
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x07, 0xFC, 0x00, 0x0F, 0xF8, 0x00, ##       000000000              000000000     
            0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x00, ##        0000000000          0000000000      
            0x03, 0xFF, 0xC0, 0xFF, 0xF0, 0x00, ##        000000000000      000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##           000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##             00000000000000000000           
            0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, ##               0000000000000000             
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 40, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000     
            0xFF, 0x00, 0x03, 0xFF, 0xF0, ##  00000000              00000000000000    
            0xFF, 0x00, 0x00, 0x7F, 0xF8, ##  00000000                 000000000000   
            0xFF, 0x00, 0x00, 0x1F, 0xF8, ##  00000000                   0000000000   
            0xFF, 0x00, 0x00, 0x0F, 0xFC, ##  00000000                    0000000000  
            0xFF, 0x00, 0x00, 0x07, 0xFC, ##  00000000                     000000000  
            0xFF, 0x00, 0x00, 0x07, 0xFE, ##  00000000                     0000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFF, ##  00000000                      0000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x01, 0xFF, ##  00000000                       000000000
            0xFF, 0x00, 0x00, 0x03, 0xFF, ##  00000000                      0000000000
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000 
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000 
            0xFF, 0x00, 0x00, 0x07, 0xFE, ##  00000000                     0000000000 
            0xFF, 0x00, 0x00, 0x07, 0xFE, ##  00000000                     0000000000 
            0xFF, 0x00, 0x00, 0x0F, 0xFC, ##  00000000                    0000000000  
            0xFF, 0x00, 0x00, 0x1F, 0xFC, ##  00000000                   00000000000  
            0xFF, 0x00, 0x00, 0x7F, 0xF8, ##  00000000                 000000000000   
            0xFF, 0x00, 0x03, 0xFF, 0xF0, ##  00000000              00000000000000    
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 42, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##                  0000000000                
            0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, ##               0000000000000000             
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##             00000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##           00000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000       
            0x03, 0xFF, 0xC0, 0xFF, 0xF0, 0x00, ##        000000000000      000000000000      
            0x03, 0xFF, 0x00, 0x3F, 0xF0, 0x00, ##        0000000000          0000000000      
            0x07, 0xFC, 0x00, 0x0F, 0xF8, 0x00, ##       000000000              000000000     
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x1F, 0xF0, 0x00, 0x03, 0xFC, 0x00, ##     000000000                  00000000    
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x1F, 0xE0, 0x00, 0x01, 0xFE, 0x00, ##     00000000                    00000000   
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000  
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##   000000000                      00000000  
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, ##   00000000                        00000000 
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, ##  000000000                        00000000 
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x80, ##   00000000                       000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##   000000000                      000000000 
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x00, ##    00000000                      00000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##    000000000                    000000000  
            0x1F, 0xE0, 0x00, 0x01, 0xFE, 0x00, ##     00000000                    00000000   
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x1F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##     000000000                  000000000   
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x0F, 0xF8, 0x00, 0x07, 0xFC, 0x00, ##      000000000                000000000    
            0x07, 0xFC, 0x00, 0x0F, 0xF8, 0x00, ##       000000000              000000000     
            0x03, 0xFF, 0x00, 0x3F, 0xF8, 0x00, ##        0000000000          00000000000     
            0x03, 0xFF, 0xC0, 0xFF, 0xF0, 0x00, ##        000000000000      000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0x80, 0x00, ##           000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000          
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000           
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, ##                  0000000000000000          
            0x00, 0x00, 0x01, 0xFF, 0x80, 0x00, ##                         0000000000         
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##                          0000000000        
            0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##                           0000000000       
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000      
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##                             0000000000     
            0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##                              0000000000    
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000    
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##                                0000000     
            0x00, 0x00, 0x00, 0x01, 0xE0, 0x00, ##                                 0000       
            0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, ##                                  00        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 46, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##  000000000000000000000000                      
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  0000000000000000000000000000                  
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  000000000000000000000000000000                
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000             
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000            
            0xFF, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##  00000000              0000000000000           
            0xFF, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##  00000000                000000000000          
            0xFF, 0x00, 0x00, 0x3F, 0xF8, 0x00, ##  00000000                  00000000000         
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000         
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000        
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000       
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000         
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000         
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000          
            0xFF, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##  00000000                 00000000000          
            0xFF, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##  00000000              0000000000000           
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  000000000000000000000000000000000             
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  00000000000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000                 
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  000000000000000000000000000                   
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  00000000000000000000000000000                 
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  0000000000000000000000000000000               
            0xFF, 0x00, 0x0F, 0xFF, 0x00, 0x00, ##  00000000            000000000000              
            0xFF, 0x00, 0x03, 0xFF, 0x80, 0x00, ##  00000000              00000000000             
            0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##  00000000                000000000             
            0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##  00000000                 000000000            
            0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##  00000000                 0000000000           
            0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##  00000000                  000000000           
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000          
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000          
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000         
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000         
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000        
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000       
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000      
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000000                       000000000      
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000     
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000     
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  00000000                         000000000    
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  00000000                         000000000    
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##  00000000                          000000000   
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##  00000000                          000000000   
            0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                           000000000  
            0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                           000000000  
            0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##  00000000                            000000000 
            0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##  00000000                            000000000 
            0xFF, 0x00, 0x00, 0x00, 0x07, 0xFC, ##  00000000                             000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##              000000000000000000000        
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, ##            00000000000000000000000000     
            0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##          00000000000000000000000000000    
            0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##         000000000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       00000000000000000000000000000000    
            0x0F, 0xFF, 0x80, 0x3F, 0xF8, 0x00, ##      0000000000000         00000000000    
            0x0F, 0xFC, 0x00, 0x03, 0xF8, 0x00, ##      0000000000                0000000    
            0x1F, 0xF0, 0x00, 0x00, 0xF8, 0x00, ##     000000000                    00000    
            0x3F, 0xE0, 0x00, 0x00, 0x38, 0x00, ##    000000000                       000    
            0x3F, 0xC0, 0x00, 0x00, 0x08, 0x00, ##    00000000                          0    
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                
            0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  0000000000                               
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  00000000000                              
            0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##   00000000000                             
            0x7F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##   0000000000000                           
            0x7F, 0xFF, 0x80, 0x00, 0x00, 0x00, ##   0000000000000000                        
            0x3F, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##    0000000000000000000                    
            0x1F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##     00000000000000000000000               
            0x1F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##     00000000000000000000000000            
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##      000000000000000000000000000          
            0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##        000000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFF, 0xF0, 0x00, ##           000000000000000000000000000     
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##             00000000000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0xFC, 0x00, ##                000000000000000000000000   
            0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, ##                    00000000000000000000   
            0x00, 0x00, 0x03, 0xFF, 0xFE, 0x00, ##                        00000000000000000  
            0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, ##                            0000000000000  
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, ##                              000000000000 
            0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, ##                               00000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x80, ##                                 0000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000 
            0x40, 0x00, 0x00, 0x00, 0xFF, 0x00, ##   0                              00000000 
            0x70, 0x00, 0x00, 0x01, 0xFE, 0x00, ##   000                           00000000  
            0x78, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   0000                         000000000  
            0x7F, 0x00, 0x00, 0x07, 0xFC, 0x00, ##   0000000                     000000000   
            0x7F, 0xC0, 0x00, 0x1F, 0xFC, 0x00, ##   000000000                 00000000000   
            0x7F, 0xFC, 0x00, 0xFF, 0xF8, 0x00, ##   0000000000000          0000000000000    
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##   00000000000000000000000000000000000     
            0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##   0000000000000000000000000000000000      
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##     00000000000000000000000000000         
            0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##         0000000000000000000000            
            0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, ##              0000000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 48, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, ##  00000000                        00000000
            0x7F, 0x00, 0x00, 0x00, 0xFE, ##   0000000                        0000000 
            0x7F, 0x00, 0x00, 0x00, 0xFE, ##   0000000                        0000000 
            0x7F, 0x00, 0x00, 0x00, 0xFE, ##   0000000                        0000000 
            0x7F, 0x80, 0x00, 0x01, 0xFE, ##   00000000                      00000000 
            0x7F, 0x80, 0x00, 0x01, 0xFE, ##   00000000                      00000000 
            0x3F, 0xC0, 0x00, 0x03, 0xFC, ##    00000000                    00000000  
            0x3F, 0xC0, 0x00, 0x03, 0xFC, ##    00000000                    00000000  
            0x1F, 0xE0, 0x00, 0x0F, 0xF8, ##     00000000                 000000000   
            0x1F, 0xF8, 0x00, 0x1F, 0xF8, ##     0000000000              0000000000   
            0x0F, 0xFF, 0x00, 0xFF, 0xF0, ##      000000000000        000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xE0, ##       000000000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFF, 0xC0, ##        0000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0x80, ##         00000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFE, 0x00, ##           0000000000000000000000         
            0x00, 0x1F, 0xFF, 0xF8, 0x00, ##             000000000000000000           
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 48, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0x80, 0x00, 0x00, 0x01, 0xFF, ##   00000000                              000000000
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, ##   000000000                             000000000
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, ##   000000000                            000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, ##   000000000                            000000000 
            0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFE, ##    00000000                            000000000 
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFC, ##    000000000                           00000000  
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, ##    000000000                          000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFC, ##     00000000                          000000000  
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, ##     000000000                         000000000  
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, ##     000000000                         00000000   
            0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, ##     000000000                        000000000   
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, ##      00000000                        000000000   
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, ##      000000000                       00000000    
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, ##      000000000                       00000000    
            0x07, 0xF8, 0x00, 0x00, 0x1F, 0xF0, ##       00000000                      000000000    
            0x07, 0xF8, 0x00, 0x00, 0x1F, 0xE0, ##       00000000                      00000000     
            0x07, 0xFC, 0x00, 0x00, 0x1F, 0xE0, ##       000000000                     00000000     
            0x03, 0xFC, 0x00, 0x00, 0x3F, 0xE0, ##        00000000                    000000000     
            0x03, 0xFC, 0x00, 0x00, 0x3F, 0xE0, ##        00000000                    000000000     
            0x03, 0xFC, 0x00, 0x00, 0x3F, 0xC0, ##        00000000                    00000000      
            0x03, 0xFE, 0x00, 0x00, 0x3F, 0xC0, ##        000000000                   00000000      
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, ##         00000000                  000000000      
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0x80, ##         00000000                  00000000       
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0x80, ##         00000000                  00000000       
            0x00, 0xFF, 0x00, 0x00, 0x7F, 0x80, ##          00000000                 00000000       
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, ##          00000000                000000000       
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, ##          00000000                00000000        
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x00, ##          000000000               00000000        
            0x00, 0x7F, 0x80, 0x00, 0xFF, 0x00, ##           00000000               00000000        
            0x00, 0x7F, 0x80, 0x01, 0xFE, 0x00, ##           00000000              00000000         
            0x00, 0x7F, 0x80, 0x01, 0xFE, 0x00, ##           00000000              00000000         
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, ##            00000000             00000000         
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, ##            00000000             00000000         
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, ##            00000000            00000000          
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, ##            00000000            00000000          
            0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, ##             00000000           00000000          
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, ##             00000000          00000000           
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, ##             00000000          00000000           
            0x00, 0x0F, 0xE0, 0x07, 0xF8, 0x00, ##              0000000          00000000           
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, ##              00000000         00000000           
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, ##              00000000        00000000            
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, ##              00000000        00000000            
            0x00, 0x07, 0xF0, 0x0F, 0xF0, 0x00, ##               0000000        00000000            
            0x00, 0x07, 0xF8, 0x0F, 0xE0, 0x00, ##               00000000       0000000             
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, ##               00000000      00000000             
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, ##                0000000      00000000             
            0x00, 0x03, 0xFC, 0x1F, 0xC0, 0x00, ##                00000000     0000000              
            0x00, 0x03, 0xFC, 0x1F, 0xC0, 0x00, ##                00000000     0000000              
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, ##                00000000    00000000              
            0x00, 0x01, 0xFC, 0x3F, 0xC0, 0x00, ##                 0000000    00000000              
            0x00, 0x01, 0xFE, 0x3F, 0x80, 0x00, ##                 00000000   0000000               
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, ##                 00000000  00000000               
            0x00, 0x00, 0xFE, 0x7F, 0x80, 0x00, ##                  0000000  00000000               
            0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, ##                  0000000  0000000                
            0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, ##                  00000000 0000000                
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, ##                   000000000000000                
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, ##                   000000000000000                
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                   00000000000000                 
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                   00000000000000                 
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, ##                    0000000000000                 
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                     00000000000                  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                     00000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 52, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                                    00000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##  000000000                                   00000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##  000000000                                   00000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##   00000000                                   00000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##   00000000                                  000000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##   00000000                                  000000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                                  00000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                                  00000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                                  00000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                                  00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##    00000000                                 00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##    00000000                                 00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##    00000000                                 00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                                00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                                00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                                00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                                00000000  
            0x1F, 0xC0, 0x03, 0xFE, 0x00, 0x3F, 0xC0, ##     0000000            000000000           00000000  
            0x1F, 0xE0, 0x07, 0xFE, 0x00, 0x3F, 0xC0, ##     00000000          0000000000           00000000  
            0x1F, 0xE0, 0x07, 0xFE, 0x00, 0x3F, 0xC0, ##     00000000          0000000000           00000000  
            0x1F, 0xE0, 0x07, 0xFE, 0x00, 0x3F, 0x80, ##     00000000          0000000000           0000000   
            0x1F, 0xE0, 0x07, 0xFE, 0x00, 0x7F, 0x80, ##     00000000          0000000000          00000000   
            0x1F, 0xE0, 0x07, 0xFF, 0x00, 0x7F, 0x80, ##     00000000          00000000000         00000000   
            0x1F, 0xE0, 0x0F, 0xFF, 0x00, 0x7F, 0x80, ##     00000000         000000000000         00000000   
            0x0F, 0xE0, 0x0F, 0xFF, 0x00, 0x7F, 0x80, ##      0000000         000000000000         00000000   
            0x0F, 0xE0, 0x0F, 0xFF, 0x00, 0x7F, 0x80, ##      0000000         000000000000         00000000   
            0x0F, 0xE0, 0x0F, 0xFF, 0x80, 0x7F, 0x00, ##      0000000         0000000000000        0000000    
            0x0F, 0xF0, 0x0F, 0xDF, 0x80, 0x7F, 0x00, ##      00000000        000000 000000        0000000    
            0x0F, 0xF0, 0x1F, 0xDF, 0x80, 0x7F, 0x00, ##      00000000       0000000 000000        0000000    
            0x0F, 0xF0, 0x1F, 0x9F, 0x80, 0x7F, 0x00, ##      00000000       000000  000000        0000000    
            0x07, 0xF0, 0x1F, 0x9F, 0x80, 0xFF, 0x00, ##       0000000       000000  000000       00000000    
            0x07, 0xF0, 0x1F, 0x9F, 0xC0, 0xFF, 0x00, ##       0000000       000000  0000000      00000000    
            0x07, 0xF0, 0x1F, 0x8F, 0xC0, 0xFF, 0x00, ##       0000000       000000   000000      00000000    
            0x07, 0xF0, 0x3F, 0x0F, 0xC0, 0xFE, 0x00, ##       0000000      000000    000000      0000000     
            0x07, 0xF0, 0x3F, 0x0F, 0xC0, 0xFE, 0x00, ##       0000000      000000    000000      0000000     
            0x07, 0xF8, 0x3F, 0x0F, 0xC0, 0xFE, 0x00, ##       00000000     000000    000000      0000000     
            0x07, 0xF8, 0x3F, 0x07, 0xE0, 0xFE, 0x00, ##       00000000     000000     000000     0000000     
            0x03, 0xF8, 0x7F, 0x07, 0xE0, 0xFE, 0x00, ##        0000000    0000000     000000     0000000     
            0x03, 0xF8, 0x7E, 0x07, 0xE0, 0xFE, 0x00, ##        0000000    000000      000000     0000000     
            0x03, 0xF8, 0x7E, 0x07, 0xE1, 0xFE, 0x00, ##        0000000    000000      000000    00000000     
            0x03, 0xF8, 0x7E, 0x07, 0xE1, 0xFC, 0x00, ##        0000000    000000      000000    0000000      
            0x03, 0xF8, 0x7E, 0x03, 0xF1, 0xFC, 0x00, ##        0000000    000000       000000   0000000      
            0x03, 0xF8, 0xFC, 0x03, 0xF1, 0xFC, 0x00, ##        0000000   000000        000000   0000000      
            0x03, 0xF8, 0xFC, 0x03, 0xF1, 0xFC, 0x00, ##        0000000   000000        000000   0000000      
            0x01, 0xFC, 0xFC, 0x03, 0xF1, 0xFC, 0x00, ##         0000000  000000        000000   0000000      
            0x01, 0xFC, 0xFC, 0x01, 0xF9, 0xFC, 0x00, ##         0000000  000000         000000  0000000      
            0x01, 0xFC, 0xFC, 0x01, 0xF9, 0xFC, 0x00, ##         0000000  000000         000000  0000000      
            0x01, 0xFD, 0xF8, 0x01, 0xFB, 0xF8, 0x00, ##         0000000 000000          000000 0000000       
            0x01, 0xFD, 0xF8, 0x01, 0xFB, 0xF8, 0x00, ##         0000000 000000          000000 0000000       
            0x01, 0xFD, 0xF8, 0x00, 0xFB, 0xF8, 0x00, ##         0000000 000000           00000 0000000       
            0x01, 0xFD, 0xF8, 0x00, 0xFF, 0xF8, 0x00, ##         0000000 000000           0000000000000       
            0x00, 0xFD, 0xF0, 0x00, 0xFF, 0xF8, 0x00, ##          000000 00000            0000000000000       
            0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF8, 0x00, ##          000000000000            0000000000000       
            0x00, 0xFF, 0xF0, 0x00, 0xFF, 0xF0, 0x00, ##          000000000000            000000000000        
            0x00, 0xFF, 0xF0, 0x00, 0x7F, 0xF0, 0x00, ##          000000000000             00000000000        
            0x00, 0xFF, 0xF0, 0x00, 0x7F, 0xF0, 0x00, ##          000000000000             00000000000        
            0x00, 0xFF, 0xE0, 0x00, 0x7F, 0xF0, 0x00, ##          00000000000              00000000000        
            0x00, 0x7F, 0xE0, 0x00, 0x7F, 0xF0, 0x00, ##           0000000000              00000000000        
            0x00, 0x7F, 0xE0, 0x00, 0x3F, 0xF0, 0x00, ##           0000000000               0000000000        
            0x00, 0x7F, 0xE0, 0x00, 0x3F, 0xF0, 0x00, ##           0000000000               0000000000        
            0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, ##           000000000                000000000         
            0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, ##           000000000                000000000         
            0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, ##           000000000                000000000         
            0x00, 0x7F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, ##           000000000                 00000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 51, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0x80, ##     000000000                            000000000  
            0x0F, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##      000000000                          000000000   
            0x0F, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##      000000000                          000000000   
            0x07, 0xFC, 0x00, 0x00, 0x03, 0xFE, 0x00, ##       000000000                        000000000    
            0x07, 0xFC, 0x00, 0x00, 0x07, 0xFC, 0x00, ##       000000000                       000000000     
            0x03, 0xFE, 0x00, 0x00, 0x07, 0xFC, 0x00, ##        000000000                      000000000     
            0x01, 0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##         000000000                    000000000      
            0x01, 0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##         000000000                    000000000      
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xF0, 0x00, ##          000000000                  000000000       
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                 000000000        
            0x00, 0x7F, 0xC0, 0x00, 0x3F, 0xE0, 0x00, ##           000000000                000000000        
            0x00, 0x3F, 0xE0, 0x00, 0x7F, 0xC0, 0x00, ##            000000000              000000000         
            0x00, 0x3F, 0xE0, 0x00, 0x7F, 0x80, 0x00, ##            000000000              00000000          
            0x00, 0x1F, 0xF0, 0x00, 0xFF, 0x80, 0x00, ##             000000000            000000000          
            0x00, 0x1F, 0xF0, 0x01, 0xFF, 0x00, 0x00, ##             000000000           000000000           
            0x00, 0x0F, 0xF8, 0x01, 0xFE, 0x00, 0x00, ##              000000000          00000000            
            0x00, 0x07, 0xF8, 0x03, 0xFE, 0x00, 0x00, ##               00000000         000000000            
            0x00, 0x07, 0xFC, 0x03, 0xFC, 0x00, 0x00, ##               000000000        00000000             
            0x00, 0x03, 0xFE, 0x07, 0xFC, 0x00, 0x00, ##                000000000      000000000             
            0x00, 0x01, 0xFE, 0x07, 0xF8, 0x00, 0x00, ##                 00000000      00000000              
            0x00, 0x01, 0xFF, 0x0F, 0xF0, 0x00, 0x00, ##                 000000000    00000000               
            0x00, 0x00, 0xFF, 0x1F, 0xF0, 0x00, 0x00, ##                  00000000   000000000               
            0x00, 0x00, 0xFF, 0x9F, 0xE0, 0x00, 0x00, ##                  000000000  00000000                
            0x00, 0x00, 0x7F, 0xBF, 0xC0, 0x00, 0x00, ##                   00000000 00000000                 
            0x00, 0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x00, ##                    0000000000000000                 
            0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, ##                    000000000000000                  
            0x00, 0x00, 0x1F, 0xFF, 0x80, 0x00, 0x00, ##                     00000000000000                  
            0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, ##                     0000000000000                   
            0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, ##                      00000000000                    
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                    
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, 0x00, ##                       000000000                     
            0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, ##                      00000000000                    
            0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, ##                     0000000000000                   
            0x00, 0x00, 0x1F, 0xFF, 0x00, 0x00, 0x00, ##                     0000000000000                   
            0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, ##                    000000000000000                  
            0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, 0x00, ##                    000000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0xC0, 0x00, 0x00, ##                   00000000000000000                 
            0x00, 0x00, 0xFF, 0xBF, 0xE0, 0x00, 0x00, ##                  000000000 000000000                
            0x00, 0x00, 0xFF, 0x9F, 0xE0, 0x00, 0x00, ##                  000000000  00000000                
            0x00, 0x01, 0xFF, 0x0F, 0xF0, 0x00, 0x00, ##                 000000000    00000000               
            0x00, 0x03, 0xFE, 0x0F, 0xF0, 0x00, 0x00, ##                000000000     00000000               
            0x00, 0x03, 0xFE, 0x07, 0xF8, 0x00, 0x00, ##                000000000      00000000              
            0x00, 0x07, 0xFC, 0x07, 0xFC, 0x00, 0x00, ##               000000000       000000000             
            0x00, 0x07, 0xFC, 0x03, 0xFC, 0x00, 0x00, ##               000000000        00000000             
            0x00, 0x0F, 0xF8, 0x03, 0xFE, 0x00, 0x00, ##              000000000         000000000            
            0x00, 0x1F, 0xF0, 0x01, 0xFE, 0x00, 0x00, ##             000000000           00000000            
            0x00, 0x1F, 0xF0, 0x01, 0xFF, 0x00, 0x00, ##             000000000           000000000           
            0x00, 0x3F, 0xE0, 0x00, 0xFF, 0x80, 0x00, ##            000000000             000000000          
            0x00, 0x7F, 0xC0, 0x00, 0x7F, 0x80, 0x00, ##           000000000               00000000          
            0x00, 0x7F, 0xC0, 0x00, 0x7F, 0xC0, 0x00, ##           000000000               000000000         
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xC0, 0x00, ##          000000000                 00000000         
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                 000000000        
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##         000000000                   000000000       
            0x03, 0xFE, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##        000000000                    000000000       
            0x03, 0xFE, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##        000000000                     000000000      
            0x07, 0xFC, 0x00, 0x00, 0x07, 0xF8, 0x00, ##       000000000                       00000000      
            0x0F, 0xFC, 0x00, 0x00, 0x07, 0xFC, 0x00, ##      0000000000                       000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x03, 0xFE, 0x00, ##      000000000                         000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##     000000000                          000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##     000000000                           000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    000000000                            000000000   
            0x7F, 0xE0, 0x00, 0x00, 0x00, 0xFF, 0x80, ##   0000000000                             000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                               000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                                000000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 48, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, ##  000000000                              000000000
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFF, ##   000000000                            0000000000
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, ##   000000000                            000000000 
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, ##    000000000                          000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, ##    000000000                          000000000  
            0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, ##     000000000                        000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, ##     000000000                        000000000   
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, ##      000000000                      000000000    
            0x07, 0xF8, 0x00, 0x00, 0x1F, 0xE0, ##       00000000                      00000000     
            0x07, 0xFC, 0x00, 0x00, 0x3F, 0xE0, ##       000000000                    000000000     
            0x03, 0xFE, 0x00, 0x00, 0x3F, 0xC0, ##        000000000                   00000000      
            0x03, 0xFE, 0x00, 0x00, 0x7F, 0xC0, ##        000000000                  000000000      
            0x01, 0xFF, 0x00, 0x00, 0xFF, 0x80, ##         000000000                000000000       
            0x01, 0xFF, 0x00, 0x00, 0xFF, 0x80, ##         000000000                000000000       
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, ##          000000000              000000000        
            0x00, 0x7F, 0x80, 0x01, 0xFE, 0x00, ##           00000000              00000000         
            0x00, 0x7F, 0xC0, 0x03, 0xFE, 0x00, ##           000000000            000000000         
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, ##            00000000            00000000          
            0x00, 0x3F, 0xE0, 0x07, 0xFC, 0x00, ##            000000000          000000000          
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, ##             00000000          00000000           
            0x00, 0x0F, 0xF0, 0x0F, 0xF8, 0x00, ##              00000000        000000000           
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, ##              00000000        00000000            
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, ##               00000000      00000000             
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, ##               00000000      00000000             
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, ##                00000000    00000000              
            0x00, 0x03, 0xFE, 0x7F, 0xC0, 0x00, ##                000000000  000000000              
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, ##                 00000000  00000000               
            0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, ##                  00000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, ##                  0000000000000000                
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                   00000000000000                 
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                   00000000000000                 
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                  
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     0000000000                   
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 43, 
        'xoffset'  => 7, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   00000000000000000000000000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x80, ##                                 0000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000   
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000    
            0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, ##                               0000000000    
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000     
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##                              000000000      
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##                             0000000000      
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000       
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000       
            0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##                            000000000        
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##                           000000000         
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##                          0000000000         
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, ##                          000000000          
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, ##                         000000000           
            0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, ##                        0000000000           
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, ##                        000000000            
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, ##                       000000000             
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, ##                       000000000             
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##                      000000000              
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     0000000000              
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000               
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                    000000000                
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                   000000000                 
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                  
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                  
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, ##                 000000000                   
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, ##                000000000                    
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, ##                000000000                    
            0x00, 0x07, 0xFC, 0x00, 0x00, 0x00, ##               000000000                     
            0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##               00000000                      
            0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##              000000000                      
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##             000000000                       
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##             000000000                       
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, ##            000000000                        
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##           000000000                         
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##           000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                          
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                           
            0x01, 0xFF, 0x00, 0x00, 0x00, 0x00, ##         000000000                           
            0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, ##        000000000                            
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##        00000000                             
            0x07, 0xFC, 0x00, 0x00, 0x00, 0x00, ##       000000000                             
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##      000000000                              
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##      000000000                              
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##     000000000                               
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                                
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 18, 
        'xoffset'  => 20, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0x00, 0x00, ##  00000000          
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 42, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    000000000                               
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                               
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                               
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##      00000000                              
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##      00000000                              
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, ##       00000000                             
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, ##       00000000                             
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##        00000000                            
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##        00000000                            
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                           
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                           
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                          
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          00000000                          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, ##           00000000                         
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, ##           00000000                         
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                        
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                        
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                       
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                       
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##              00000000                      
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##              00000000                      
            0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##               00000000                     
            0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##               00000000                     
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, ##                00000000                    
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, ##                00000000                    
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, ##                000000000                   
            0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##                 00000000                   
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, ##                 000000000                  
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                  
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                  
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                 
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000               
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000               
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000              
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                      00000000              
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                       00000000             
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                       00000000             
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, ##                       000000000            
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, ##                        00000000            
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, ##                        00000000            
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, ##                         00000000           
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, ##                         00000000           
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                          00000000          
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                          00000000          
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                           00000000         
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                           00000000         
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000        
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000        
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000       
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000       
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000      
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##                              00000000      
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##                              000000000     
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000     
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000     
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000    
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000    
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000   
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000   
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000  
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000  
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000 
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##                                    00000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 18, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0x00, 0x3F, 0xC0, ##            00000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0xFF, 0xFF, 0xC0, ##  000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 46, 
        'xoffset'  => 3, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                     00000000                   
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##                    0000000000                  
            0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##                   000000000000                 
            0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, ##                   0000000000000                
            0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, ##                  000000000000000               
            0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, ##                 0000000000000000               
            0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, ##                000000000000000000              
            0x00, 0x07, 0xFE, 0xFF, 0x80, 0x00, ##               0000000000 000000000             
            0x00, 0x07, 0xFC, 0x7F, 0xC0, 0x00, ##               000000000   000000000            
            0x00, 0x0F, 0xF8, 0x7F, 0xE0, 0x00, ##              000000000    0000000000           
            0x00, 0x1F, 0xF0, 0x3F, 0xE0, 0x00, ##             000000000      000000000           
            0x00, 0x3F, 0xE0, 0x1F, 0xF0, 0x00, ##            000000000        000000000          
            0x00, 0x7F, 0xC0, 0x0F, 0xF8, 0x00, ##           000000000          000000000         
            0x00, 0x7F, 0x80, 0x07, 0xFC, 0x00, ##           00000000            000000000        
            0x00, 0xFF, 0x00, 0x03, 0xFE, 0x00, ##          00000000              000000000       
            0x01, 0xFE, 0x00, 0x01, 0xFE, 0x00, ##         00000000                00000000       
            0x03, 0xFC, 0x00, 0x00, 0xFF, 0x00, ##        00000000                  00000000      
            0x07, 0xFC, 0x00, 0x00, 0x7F, 0x80, ##       000000000                   00000000     
            0x0F, 0xF8, 0x00, 0x00, 0x3F, 0xC0, ##      000000000                     00000000    
            0x0F, 0xF0, 0x00, 0x00, 0x1F, 0xE0, ##      00000000                       00000000   
            0x1F, 0xE0, 0x00, 0x00, 0x0F, 0xE0, ##     00000000                         0000000   
            0x3F, 0xC0, 0x00, 0x00, 0x0F, 0xF0, ##    00000000                          00000000  
            0x7F, 0x80, 0x00, 0x00, 0x07, 0xF8, ##   00000000                            00000000 
            0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC, ##  00000000                              00000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 44, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 20, 
        'xoffset'  => 12, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, ##  000000000           
            0x7F, 0x80, 0x00, ##   00000000           
            0x3F, 0xC0, 0x00, ##    00000000          
            0x1F, 0xE0, 0x00, ##     00000000         
            0x0F, 0xF0, 0x00, ##      00000000        
            0x07, 0xF0, 0x00, ##       0000000        
            0x07, 0xF8, 0x00, ##       00000000       
            0x03, 0xFC, 0x00, ##        00000000      
            0x01, 0xFE, 0x00, ##         00000000     
            0x00, 0xFE, 0x00, ##          0000000     
            0x00, 0x7F, 0x00, ##           0000000    
            0x00, 0x3F, 0x80, ##            0000000   
            0x00, 0x1F, 0xC0, ##             0000000  
            0x00, 0x1F, 0xC0, ##             0000000  
            0x00, 0x0F, 0xE0, ##              0000000 
            0x00, 0x07, 0xF0, ##               0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 39, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFF, 0x80, 0x00, ##               000000000000              
            0x00, 0xFF, 0xFF, 0xF8, 0x00, ##          000000000000000000000          
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000        
            0x0F, 0xFF, 0xFF, 0xFF, 0x00, ##      0000000000000000000000000000       
            0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##      000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xE0, ##      0000000000000000000000000000000    
            0x0F, 0xFC, 0x00, 0xFF, 0xF0, ##      0000000000          000000000000   
            0x0F, 0xE0, 0x00, 0x3F, 0xF0, ##      0000000               0000000000   
            0x0F, 0x00, 0x00, 0x0F, 0xF8, ##      0000                    000000000  
            0x0C, 0x00, 0x00, 0x07, 0xF8, ##      00                       00000000  
            0x00, 0x00, 0x00, 0x07, 0xFC, ##                               000000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x03, 0xFF, 0xFF, 0xFE, ##                0000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xFE, ##            00000000000000000000000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xFE, ##          0000000000000000000000000000000
            0x03, 0xFF, 0xFF, 0xFF, 0xFE, ##        000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFE, ##       0000000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xFE, ##      00000000000000000000000000000000000
            0x1F, 0xFF, 0x00, 0x01, 0xFE, ##     0000000000000               00000000
            0x3F, 0xF8, 0x00, 0x01, 0xFE, ##    00000000000                  00000000
            0x3F, 0xE0, 0x00, 0x01, 0xFE, ##    000000000                    00000000
            0x7F, 0xC0, 0x00, 0x01, 0xFE, ##   000000000                     00000000
            0x7F, 0x80, 0x00, 0x01, 0xFE, ##   00000000                      00000000
            0x7F, 0x80, 0x00, 0x01, 0xFE, ##   00000000                      00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000
            0xFF, 0x00, 0x00, 0x03, 0xFE, ##  00000000                      000000000
            0xFF, 0x00, 0x00, 0x07, 0xFE, ##  00000000                     0000000000
            0xFF, 0x00, 0x00, 0x07, 0xFE, ##  00000000                     0000000000
            0xFF, 0x80, 0x00, 0x0F, 0xFE, ##  000000000                   00000000000
            0x7F, 0x80, 0x00, 0x1F, 0xFE, ##   00000000                  000000000000
            0x7F, 0xC0, 0x00, 0x3F, 0xFE, ##   000000000                0000000000000
            0x7F, 0xC0, 0x00, 0x7F, 0xFE, ##   000000000               00000000000000
            0x3F, 0xF0, 0x00, 0xFF, 0xFE, ##    0000000000            000000000000000
            0x3F, 0xFC, 0x07, 0xFD, 0xFE, ##    000000000000       000000000 00000000
            0x1F, 0xFF, 0xFF, 0xF9, 0xFE, ##     00000000000000000000000000  00000000
            0x0F, 0xFF, 0xFF, 0xF1, 0xFE, ##      000000000000000000000000   00000000
            0x07, 0xFF, 0xFF, 0xE1, 0xFE, ##       0000000000000000000000    00000000
            0x03, 0xFF, 0xFF, 0xC1, 0xFE, ##        00000000000000000000     00000000
            0x00, 0xFF, 0xFF, 0x01, 0xFE, ##          0000000000000000       00000000
            0x00, 0x1F, 0xF8, 0x00, 0x00, ##             0000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0xFF, 0x80, 0x00, ##  00000000        000000000              
            0xFF, 0x03, 0xFF, 0xF0, 0x00, ##  00000000      00000000000000           
            0xFF, 0x0F, 0xFF, 0xFC, 0x00, ##  00000000    000000000000000000         
            0xFF, 0x1F, 0xFF, 0xFE, 0x00, ##  00000000   00000000000000000000        
            0xFF, 0x3F, 0xFF, 0xFF, 0x00, ##  00000000  0000000000000000000000       
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000      
            0xFF, 0xFF, 0x01, 0xFF, 0xC0, ##  0000000000000000       00000000000     
            0xFF, 0xFC, 0x00, 0x7F, 0xE0, ##  00000000000000           0000000000    
            0xFF, 0xF8, 0x00, 0x3F, 0xE0, ##  0000000000000             000000000    
            0xFF, 0xF0, 0x00, 0x1F, 0xF0, ##  000000000000               000000000   
            0xFF, 0xE0, 0x00, 0x0F, 0xF0, ##  00000000000                 00000000   
            0xFF, 0xE0, 0x00, 0x0F, 0xF8, ##  00000000000                 000000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xE0, 0x00, 0x0F, 0xF8, ##  00000000000                 000000000  
            0xFF, 0xE0, 0x00, 0x0F, 0xF0, ##  00000000000                 00000000   
            0xFF, 0xF0, 0x00, 0x1F, 0xF0, ##  000000000000               000000000   
            0xFF, 0xF8, 0x00, 0x3F, 0xE0, ##  0000000000000             000000000    
            0xFF, 0xFC, 0x00, 0x7F, 0xE0, ##  00000000000000           0000000000    
            0xFF, 0xFF, 0x01, 0xFF, 0xC0, ##  0000000000000000       00000000000     
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000      
            0xFF, 0x3F, 0xFF, 0xFF, 0x00, ##  00000000  0000000000000000000000       
            0xFF, 0x1F, 0xFF, 0xFE, 0x00, ##  00000000   00000000000000000000        
            0xFF, 0x0F, 0xFF, 0xFC, 0x00, ##  00000000    000000000000000000         
            0xFF, 0x03, 0xFF, 0xF0, 0x00, ##  00000000      00000000000000           
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 37, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF8, 0x00, ##                    00000000000        
            0x00, 0x03, 0xFF, 0xFF, 0x80, ##                0000000000000000000    
            0x00, 0x0F, 0xFF, 0xFF, 0xE0, ##              00000000000000000000000  
            0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##            000000000000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, ##           0000000000000000000000000000
            0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##         000000000000000000000000000000
            0x03, 0xFF, 0xE0, 0x0F, 0xF8, ##        0000000000000         000000000
            0x07, 0xFF, 0x00, 0x01, 0xF8, ##       00000000000               000000
            0x07, 0xFE, 0x00, 0x00, 0x78, ##       0000000000                  0000
            0x0F, 0xF8, 0x00, 0x00, 0x18, ##      000000000                      00
            0x1F, 0xF0, 0x00, 0x00, 0x08, ##     000000000                        0
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                         
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                          
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                           
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                           
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                             
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                            
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                           
            0x3F, 0xC0, 0x00, 0x00, 0x00, ##    00000000                           
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                          
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                         
            0x1F, 0xF0, 0x00, 0x00, 0x08, ##     000000000                        0
            0x0F, 0xF8, 0x00, 0x00, 0x18, ##      000000000                      00
            0x07, 0xFE, 0x00, 0x00, 0x78, ##       0000000000                  0000
            0x07, 0xFF, 0x00, 0x01, 0xF8, ##       00000000000               000000
            0x03, 0xFF, 0xE0, 0x0F, 0xF8, ##        0000000000000         000000000
            0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##         000000000000000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, ##           0000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##            000000000000000000000000000
            0x00, 0x0F, 0xFF, 0xFF, 0xE0, ##              00000000000000000000000  
            0x00, 0x03, 0xFF, 0xFF, 0x80, ##                0000000000000000000    
            0x00, 0x00, 0x3F, 0xF8, 0x00, ##                    00000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 39, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x03, 0xFE, 0x01, 0xFE, ##                000000000        00000000
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x3F, 0xC0, 0x00, 0x0F, 0xFE, ##    00000000                  00000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x7F, 0xC0, 0x00, 0x07, 0xFE, ##   000000000                   0000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x3F, 0xC0, 0x00, 0x0F, 0xFE, ##    00000000                  00000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 42, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000               
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000            
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##              00000000000000000000          
            0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##            000000000000000000000000        
            0x00, 0x7F, 0xFF, 0xFF, 0xE0, 0x00, ##           00000000000000000000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##         00000000000000000000000000000      
            0x03, 0xFF, 0xC0, 0x3F, 0xF8, 0x00, ##        000000000000        00000000000     
            0x03, 0xFF, 0x00, 0x0F, 0xFC, 0x00, ##        0000000000            0000000000    
            0x07, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##       000000000                00000000    
            0x0F, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##      000000000                  00000000   
            0x1F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##     000000000                   00000000   
            0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##     00000000                     00000000  
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##    000000000                     00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##    00000000                       00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##    00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, ##   00000000                        00000000 
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0x80, ##   00000000                         0000000 
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##   00000000                         00000000
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##   00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##  00000000                          00000000
            0xFF, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##  00000000                          00000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                  
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, ##   0000000                                  
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                 
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, ##    0000000                                 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     00000000                               
            0x1F, 0xF0, 0x00, 0x00, 0x01, 0x00, ##     000000000                           0  
            0x0F, 0xF8, 0x00, 0x00, 0x07, 0x00, ##      000000000                        000  
            0x07, 0xFC, 0x00, 0x00, 0x1F, 0x00, ##       000000000                     00000  
            0x07, 0xFF, 0x00, 0x00, 0xFF, 0x00, ##       00000000000                00000000  
            0x03, 0xFF, 0xE0, 0x0F, 0xFF, 0x00, ##        0000000000000         000000000000  
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##         000000000000000000000000000000000  
            0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, ##           0000000000000000000000000000000  
            0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##            000000000000000000000000000000  
            0x00, 0x0F, 0xFF, 0xFF, 0xFC, 0x00, ##              00000000000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, ##                000000000000000000000       
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 37, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xFF, 0xF8, ##                         00000000000000
            0x00, 0x00, 0x0F, 0xFF, 0xF8, ##                      00000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xF8, ##                    0000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xF8, ##                   00000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xF8, ##                  000000000000000000000
            0x00, 0x01, 0xFF, 0xFF, 0xF8, ##                 0000000000000000000000
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000            
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000              
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000               
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000               
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 39, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x3F, 0xE0, 0x00, 0x07, 0xFE, ##    000000000                  0000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x7F, 0xC0, 0x00, 0x07, 0xFE, ##   000000000                   0000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0xC0, 0x00, 0x07, 0xFE, ##   000000000                   0000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x3F, 0xE0, 0x00, 0x07, 0xFE, ##    000000000                  0000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x03, 0xFE, 0x01, 0xFE, ##                000000000        00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x03, 0xFC, ##                                00000000 
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000  
            0x00, 0x00, 0x00, 0x07, 0xF8, ##                               00000000  
            0x06, 0x00, 0x00, 0x0F, 0xF0, ##       00                     00000000   
            0x07, 0xC0, 0x00, 0x1F, 0xF0, ##       00000                 000000000   
            0x07, 0xF8, 0x00, 0x7F, 0xE0, ##       00000000            0000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xC0, ##       00000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0x80, ##       0000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000       
            0x07, 0xFF, 0xFF, 0xFE, 0x00, ##       00000000000000000000000000        
            0x03, 0xFF, 0xFF, 0xF8, 0x00, ##        00000000000000000000000          
            0x00, 0x3F, 0xFF, 0xE0, 0x00, ##            00000000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 36, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                            
            0xFF, 0x00, 0x7F, 0xC0, 0x00, ##  00000000         000000000          
            0xFF, 0x03, 0xFF, 0xF8, 0x00, ##  00000000      000000000000000       
            0xFF, 0x07, 0xFF, 0xFC, 0x00, ##  00000000     00000000000000000      
            0xFF, 0x1F, 0xFF, 0xFE, 0x00, ##  00000000   00000000000000000000     
            0xFF, 0x3F, 0xFF, 0xFF, 0x00, ##  00000000  0000000000000000000000    
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000   
            0xFF, 0x7F, 0x03, 0xFF, 0x80, ##  00000000 0000000      00000000000   
            0xFF, 0xF8, 0x00, 0xFF, 0xC0, ##  0000000000000           0000000000  
            0xFF, 0xF0, 0x00, 0x7F, 0xC0, ##  000000000000             000000000  
            0xFF, 0xE0, 0x00, 0x3F, 0xE0, ##  00000000000               000000000 
            0xFF, 0xE0, 0x00, 0x1F, 0xE0, ##  00000000000                00000000 
            0xFF, 0xC0, 0x00, 0x1F, 0xE0, ##  0000000000                 00000000 
            0xFF, 0x80, 0x00, 0x1F, 0xE0, ##  000000000                  00000000 
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x1F, 0xFF, 0xFE, 0x00, 0x00, ##     00000000000000000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000                
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 25, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x00, 0x00, 0x00, 0x00, ##                           
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x0F, 0xFF, 0xFF, 0x80, ##      000000000000000000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0x7F, 0x80, ##                   00000000
            0x00, 0x00, 0xFF, 0x00, ##                  00000000 
            0x00, 0x00, 0xFF, 0x00, ##                  00000000 
            0x00, 0x00, 0xFF, 0x00, ##                  00000000 
            0x00, 0x01, 0xFF, 0x00, ##                 000000000 
            0x00, 0x03, 0xFE, 0x00, ##                000000000  
            0x00, 0x0F, 0xFE, 0x00, ##              00000000000  
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000   
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000     
            0xFF, 0xFF, 0xE0, 0x00, ##  0000000000000000000      
            0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000        
            0xFF, 0xFE, 0x00, 0x00, ##  000000000000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 41, 
        'xoffset'  => 10, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000                                 
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000   
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000     
            0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##  00000000                  000000000      
            0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##  00000000                 000000000       
            0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##  00000000                000000000        
            0xFF, 0x00, 0x01, 0xFF, 0x00, 0x00, ##  00000000               000000000         
            0xFF, 0x00, 0x03, 0xFE, 0x00, 0x00, ##  00000000              000000000          
            0xFF, 0x00, 0x07, 0xFC, 0x00, 0x00, ##  00000000             000000000           
            0xFF, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##  00000000            000000000            
            0xFF, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##  00000000           000000000             
            0xFF, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##  00000000          000000000              
            0xFF, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##  00000000         000000000               
            0xFF, 0x00, 0xFF, 0x80, 0x00, 0x00, ##  00000000        000000000                
            0xFF, 0x01, 0xFF, 0x00, 0x00, 0x00, ##  00000000       000000000                 
            0xFF, 0x03, 0xFE, 0x00, 0x00, 0x00, ##  00000000      000000000                  
            0xFF, 0x07, 0xFC, 0x00, 0x00, 0x00, ##  00000000     000000000                   
            0xFF, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##  00000000    000000000                    
            0xFF, 0x3F, 0xF0, 0x00, 0x00, 0x00, ##  00000000  0000000000                     
            0xFF, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##  00000000 00000000000                     
            0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##  00000000000000000000                     
            0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##  000000000000000000000                    
            0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##  0000000000000000000000                   
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##  00000000000000000000000                  
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##  00000000000000000000000                  
            0xFF, 0xF9, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000  000000000                 
            0xFF, 0xE1, 0xFF, 0x80, 0x00, 0x00, ##  00000000000    0000000000                
            0xFF, 0xC0, 0xFF, 0x80, 0x00, 0x00, ##  0000000000      000000000                
            0xFF, 0x80, 0x7F, 0xC0, 0x00, 0x00, ##  000000000        000000000               
            0xFF, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##  00000000          000000000              
            0xFF, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##  00000000          0000000000             
            0xFF, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##  00000000           000000000             
            0xFF, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##  00000000            000000000            
            0xFF, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##  00000000            0000000000           
            0xFF, 0x00, 0x07, 0xFC, 0x00, 0x00, ##  00000000             000000000           
            0xFF, 0x00, 0x03, 0xFE, 0x00, 0x00, ##  00000000              000000000          
            0xFF, 0x00, 0x01, 0xFF, 0x00, 0x00, ##  00000000               000000000         
            0xFF, 0x00, 0x01, 0xFF, 0x80, 0x00, ##  00000000               0000000000        
            0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##  00000000                000000000        
            0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##  00000000                 000000000       
            0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##  00000000                 0000000000      
            0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##  00000000                  0000000000     
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000     
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000    
            0xFF, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  00000000                    0000000000   
            0xFF, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  00000000                     000000000   
            0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  00000000                      000000000  
            0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00, ##  00000000                      0000000000 
            0xFF, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  00000000                       0000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 37, 
        'xoffset'  => 7, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  00000000000000000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000               
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000              
            0x00, 0x03, 0xFF, 0x80, 0x00, ##                00000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xF8, ##                 0000000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xF8, ##                  000000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xF8, ##                   00000000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xF8, ##                    0000000000000000000
            0x00, 0x00, 0x0F, 0xFF, 0xF8, ##                      00000000000000000
            0x00, 0x00, 0x03, 0xFF, 0xF8, ##                        000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 43, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xC0, 0x07, 0xF0, 0x00, ##              000000           0000000       
            0xFE, 0x3F, 0xF0, 0x1F, 0xFC, 0x00, ##  0000000   0000000000       00000000000     
            0xFE, 0x7F, 0xFC, 0x3F, 0xFE, 0x00, ##  0000000  0000000000000    0000000000000    
            0xFE, 0xFF, 0xFC, 0x7F, 0xFF, 0x00, ##  0000000 00000000000000   000000000000000   
            0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, ##  00000000000000000000000  0000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000  
            0xFF, 0xC1, 0xFF, 0xF0, 0x7F, 0x80, ##  0000000000     0000000000000     00000000  
            0xFF, 0x80, 0xFF, 0xE0, 0x3F, 0xC0, ##  000000000       00000000000       00000000 
            0xFF, 0x00, 0x7F, 0xC0, 0x1F, 0xC0, ##  00000000         000000000         0000000 
            0xFF, 0x00, 0x7F, 0xC0, 0x1F, 0xC0, ##  00000000         000000000         0000000 
            0xFF, 0x00, 0x7F, 0xC0, 0x1F, 0xC0, ##  00000000         000000000         0000000 
            0xFE, 0x00, 0x3F, 0xC0, 0x0F, 0xC0, ##  0000000           00000000          000000 
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0xFE, 0x00, 0x3F, 0x80, 0x0F, 0xE0, ##  0000000           0000000           0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 36, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xC0, 0x00, ##                   000000000          
            0xFF, 0x03, 0xFF, 0xF8, 0x00, ##  00000000      000000000000000       
            0xFF, 0x07, 0xFF, 0xFC, 0x00, ##  00000000     00000000000000000      
            0xFF, 0x1F, 0xFF, 0xFE, 0x00, ##  00000000   00000000000000000000     
            0xFF, 0x3F, 0xFF, 0xFF, 0x00, ##  00000000  0000000000000000000000    
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000   
            0xFF, 0x7F, 0x03, 0xFF, 0x80, ##  00000000 0000000      00000000000   
            0xFF, 0xF8, 0x00, 0xFF, 0xC0, ##  0000000000000           0000000000  
            0xFF, 0xF0, 0x00, 0x7F, 0xC0, ##  000000000000             000000000  
            0xFF, 0xE0, 0x00, 0x3F, 0xE0, ##  00000000000               000000000 
            0xFF, 0xE0, 0x00, 0x1F, 0xE0, ##  00000000000                00000000 
            0xFF, 0xC0, 0x00, 0x1F, 0xE0, ##  0000000000                 00000000 
            0xFF, 0x80, 0x00, 0x1F, 0xE0, ##  000000000                  00000000 
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000               
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, ##            000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        00000000000000000000000000000      
            0x07, 0xFF, 0x80, 0xFF, 0xF0, 0x00, ##       000000000000       000000000000     
            0x0F, 0xFE, 0x00, 0x3F, 0xF8, 0x00, ##      00000000000           00000000000    
            0x0F, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##      000000000               000000000    
            0x1F, 0xF0, 0x00, 0x07, 0xFC, 0x00, ##     000000000                 000000000   
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x3F, 0xE0, 0x00, 0x03, 0xFE, 0x00, ##    000000000                   000000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0x7F, 0x80, ##  00000000                         00000000
            0xFF, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000000                        000000000
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x7F, 0x80, 0x00, 0x00, 0xFF, 0x00, ##   00000000                       00000000 
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xC0, 0x00, 0x01, 0xFE, 0x00, ##    00000000                     00000000  
            0x3F, 0xE0, 0x00, 0x03, 0xFE, 0x00, ##    000000000                   000000000  
            0x1F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##     00000000                   00000000   
            0x1F, 0xF0, 0x00, 0x07, 0xFC, 0x00, ##     000000000                 000000000   
            0x0F, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##      000000000               000000000    
            0x0F, 0xFC, 0x00, 0x3F, 0xF8, 0x00, ##      0000000000            00000000000    
            0x07, 0xFF, 0x80, 0xFF, 0xF0, 0x00, ##       000000000000       000000000000     
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        00000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         000000000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, ##            000000000000000000000          
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000              
            0xFF, 0x03, 0xFF, 0xF0, 0x00, ##  00000000      00000000000000           
            0xFF, 0x0F, 0xFF, 0xFC, 0x00, ##  00000000    000000000000000000         
            0xFF, 0x1F, 0xFF, 0xFE, 0x00, ##  00000000   00000000000000000000        
            0xFF, 0x3F, 0xFF, 0xFF, 0x00, ##  00000000  0000000000000000000000       
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000      
            0xFF, 0xFF, 0x01, 0xFF, 0xC0, ##  0000000000000000       00000000000     
            0xFF, 0xFC, 0x00, 0x7F, 0xE0, ##  00000000000000           0000000000    
            0xFF, 0xF8, 0x00, 0x3F, 0xE0, ##  0000000000000             000000000    
            0xFF, 0xF0, 0x00, 0x1F, 0xF0, ##  000000000000               000000000   
            0xFF, 0xE0, 0x00, 0x0F, 0xF0, ##  00000000000                 00000000   
            0xFF, 0xE0, 0x00, 0x0F, 0xF8, ##  00000000000                 000000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0x80, 0x00, 0x03, 0xFC, ##  000000000                     00000000 
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xC0, 0x00, 0x07, 0xF8, ##  0000000000                   00000000  
            0xFF, 0xE0, 0x00, 0x07, 0xF8, ##  00000000000                  00000000  
            0xFF, 0xE0, 0x00, 0x0F, 0xF0, ##  00000000000                 00000000   
            0xFF, 0xF0, 0x00, 0x1F, 0xF0, ##  000000000000               000000000   
            0xFF, 0xF8, 0x00, 0x3F, 0xE0, ##  0000000000000             000000000    
            0xFF, 0xFC, 0x00, 0x7F, 0xE0, ##  00000000000000           0000000000    
            0xFF, 0xFF, 0x01, 0xFF, 0xC0, ##  0000000000000000       00000000000     
            0xFF, 0x7F, 0xFF, 0xFF, 0x80, ##  00000000 000000000000000000000000      
            0xFF, 0x7F, 0xFF, 0xFF, 0x00, ##  00000000 00000000000000000000000       
            0xFF, 0x3F, 0xFF, 0xFE, 0x00, ##  00000000  000000000000000000000        
            0xFF, 0x0F, 0xFF, 0xFC, 0x00, ##  00000000    000000000000000000         
            0xFF, 0x07, 0xFF, 0xF0, 0x00, ##  00000000     000000000000000           
            0xFF, 0x00, 0xFF, 0x80, 0x00, ##  00000000        000000000              
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 39, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x3F, 0xC0, 0x00, 0x0F, 0xFE, ##    00000000                  00000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0xFF, 0x00, 0x00, 0x01, 0xFE, ##  00000000                       00000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0x80, 0x00, 0x03, 0xFE, ##   00000000                     000000000
            0x7F, 0xC0, 0x00, 0x07, 0xFE, ##   000000000                   0000000000
            0x3F, 0xC0, 0x00, 0x07, 0xFE, ##    00000000                   0000000000
            0x3F, 0xC0, 0x00, 0x0F, 0xFE, ##    00000000                  00000000000
            0x1F, 0xE0, 0x00, 0x0F, 0xFE, ##     00000000                 00000000000
            0x1F, 0xF0, 0x00, 0x1F, 0xFE, ##     000000000               000000000000
            0x0F, 0xF8, 0x00, 0x3F, 0xFE, ##      000000000             0000000000000
            0x0F, 0xFC, 0x00, 0x7F, 0xFE, ##      0000000000           00000000000000
            0x07, 0xFF, 0x01, 0xFF, 0xFE, ##       00000000000       0000000000000000
            0x03, 0xFF, 0xFF, 0xFD, 0xFE, ##        000000000000000000000000 00000000
            0x01, 0xFF, 0xFF, 0xF9, 0xFE, ##         0000000000000000000000  00000000
            0x00, 0xFF, 0xFF, 0xF1, 0xFE, ##          00000000000000000000   00000000
            0x00, 0x7F, 0xFF, 0xE1, 0xFE, ##           000000000000000000    00000000
            0x00, 0x1F, 0xFF, 0x81, 0xFE, ##             00000000000000      00000000
            0x00, 0x03, 0xFE, 0x01, 0xFE, ##                000000000        00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x01, 0xFE, ##                                 00000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 34, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x1F, 0xF8, 0x00, ##  00000000           0000000000     
            0xFF, 0x00, 0xFF, 0xFF, 0x80, ##  00000000        00000000000000000 
            0xFF, 0x03, 0xFF, 0xFF, 0xC0, ##  00000000      00000000000000000000
            0xFF, 0x0F, 0xFF, 0xFF, 0xC0, ##  00000000    0000000000000000000000
            0xFF, 0x1F, 0xFF, 0xFF, 0xC0, ##  00000000   00000000000000000000000
            0xFF, 0x3F, 0xFF, 0xFF, 0xC0, ##  00000000  000000000000000000000000
            0xFF, 0x7F, 0xE0, 0x1F, 0xC0, ##  00000000 0000000000        0000000
            0xFF, 0x7F, 0x00, 0x03, 0xC0, ##  00000000 0000000              0000
            0xFF, 0xFC, 0x00, 0x00, 0xC0, ##  00000000000000                  00
            0xFF, 0xF8, 0x00, 0x00, 0x40, ##  0000000000000                    0
            0xFF, 0xF0, 0x00, 0x00, 0x00, ##  000000000000                      
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                       
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                       
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                        
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                        
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                         
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                         
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                         
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 35, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xFF, 0x00, 0x00, ##              000000000000           
            0x00, 0x7F, 0xFF, 0xF8, 0x00, ##           00000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000   
            0x07, 0xFF, 0xFF, 0xFF, 0x80, ##       0000000000000000000000000000  
            0x0F, 0xFF, 0xFF, 0xFF, 0x80, ##      00000000000000000000000000000  
            0x1F, 0xFF, 0xFF, 0xFF, 0x80, ##     000000000000000000000000000000  
            0x3F, 0xFC, 0x00, 0xFF, 0x80, ##    000000000000          000000000  
            0x3F, 0xE0, 0x00, 0x1F, 0x80, ##    000000000                000000  
            0x7F, 0xC0, 0x00, 0x03, 0x80, ##   000000000                    000  
            0x7F, 0x80, 0x00, 0x00, 0x80, ##   00000000                       0  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                          
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                         
            0xFF, 0xE0, 0x00, 0x00, 0x00, ##  00000000000                        
            0x7F, 0xFC, 0x00, 0x00, 0x00, ##   0000000000000                     
            0x7F, 0xFF, 0x80, 0x00, 0x00, ##   0000000000000000                  
            0x3F, 0xFF, 0xFE, 0x00, 0x00, ##    000000000000000000000            
            0x1F, 0xFF, 0xFF, 0xC0, 0x00, ##     00000000000000000000000         
            0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##      0000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFC, 0x00, ##       0000000000000000000000000     
            0x01, 0xFF, 0xFF, 0xFE, 0x00, ##         000000000000000000000000    
            0x00, 0x7F, 0xFF, 0xFF, 0x00, ##           00000000000000000000000   
            0x00, 0x07, 0xFF, 0xFF, 0x80, ##               00000000000000000000  
            0x00, 0x00, 0x7F, 0xFF, 0xC0, ##                   00000000000000000 
            0x00, 0x00, 0x07, 0xFF, 0xC0, ##                       0000000000000 
            0x00, 0x00, 0x01, 0xFF, 0xC0, ##                         00000000000 
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0x00, 0x00, 0x00, 0x3F, 0xC0, ##                            00000000 
            0xC0, 0x00, 0x00, 0x3F, 0xC0, ##  00                        00000000 
            0xF8, 0x00, 0x00, 0x7F, 0xC0, ##  00000                    000000000 
            0xFE, 0x00, 0x01, 0xFF, 0x80, ##  0000000                0000000000  
            0xFF, 0xE0, 0x0F, 0xFF, 0x00, ##  00000000000         000000000000   
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##  00000000000000000000000000000000   
            0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000    
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000      
            0x7F, 0xFF, 0xFF, 0xF0, 0x00, ##   000000000000000000000000000       
            0x07, 0xFF, 0xFF, 0x80, 0x00, ##       00000000000000000000          
            0x00, 0x3F, 0xFC, 0x00, 0x00, ##            000000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 38, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000                 
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000                
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000                
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000               
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000              
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000            
            0x00, 0x01, 0xFF, 0xFF, 0xFC, ##                 00000000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xFC, ##                  0000000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xFC, ##                   000000000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xFC, ##                    00000000000000000000
            0x00, 0x00, 0x0F, 0xFF, 0xFC, ##                      000000000000000000
            0x00, 0x00, 0x01, 0xFF, 0xFC, ##                         000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 36, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                   000000000
            0xFF, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                   000000000
            0xFF, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                   000000000
            0x7F, 0x80, 0x00, 0x1F, 0xF0, ##   00000000                  000000000
            0x7F, 0x80, 0x00, 0x3F, 0xF0, ##   00000000                 0000000000
            0x7F, 0x80, 0x00, 0x7F, 0xF0, ##   00000000                00000000000
            0x7F, 0xC0, 0x00, 0x7F, 0xF0, ##   000000000               00000000000
            0x3F, 0xE0, 0x00, 0xFF, 0xF0, ##    000000000             000000000000
            0x3F, 0xF0, 0x01, 0xFF, 0xF0, ##    0000000000           0000000000000
            0x3F, 0xFC, 0x0F, 0xEF, 0xF0, ##    000000000000      0000000 00000000
            0x1F, 0xFF, 0xFF, 0xEF, 0xF0, ##     000000000000000000000000 00000000
            0x0F, 0xFF, 0xFF, 0xCF, 0xF0, ##      0000000000000000000000  00000000
            0x07, 0xFF, 0xFF, 0x8F, 0xF0, ##       00000000000000000000   00000000
            0x03, 0xFF, 0xFE, 0x0F, 0xF0, ##        00000000000000000     00000000
            0x01, 0xFF, 0xFC, 0x0F, 0xF0, ##         000000000000000      00000000
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF0, ##  000000000                           00000000
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##   00000000                          000000000
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xE0, ##   000000000                         00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##    00000000                        000000000 
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x1F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, ##     00000000                       00000000  
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##     00000000                      000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x80, ##      00000000                     00000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, ##       00000000                   00000000    
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x03, 0xFC, 0x00, 0x01, 0xFE, 0x00, ##        00000000                 00000000     
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x01, 0xFE, 0x00, 0x03, 0xFC, 0x00, ##         00000000               00000000      
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x00, 0xFF, 0x00, 0x07, 0xF8, 0x00, ##          00000000             00000000       
            0x00, 0xFF, 0x00, 0x0F, 0xF0, 0x00, ##          00000000            00000000        
            0x00, 0x7F, 0x00, 0x0F, 0xF0, 0x00, ##           0000000            00000000        
            0x00, 0x7F, 0x80, 0x0F, 0xF0, 0x00, ##           00000000           00000000        
            0x00, 0x7F, 0x80, 0x1F, 0xE0, 0x00, ##           00000000          00000000         
            0x00, 0x3F, 0x80, 0x1F, 0xE0, 0x00, ##            0000000          00000000         
            0x00, 0x3F, 0xC0, 0x1F, 0xC0, 0x00, ##            00000000         0000000          
            0x00, 0x3F, 0xC0, 0x3F, 0xC0, 0x00, ##            00000000        00000000          
            0x00, 0x1F, 0xC0, 0x3F, 0xC0, 0x00, ##             0000000        00000000          
            0x00, 0x1F, 0xE0, 0x3F, 0x80, 0x00, ##             00000000       0000000           
            0x00, 0x1F, 0xE0, 0x7F, 0x80, 0x00, ##             00000000      00000000           
            0x00, 0x0F, 0xF0, 0x7F, 0x80, 0x00, ##              00000000     00000000           
            0x00, 0x0F, 0xF0, 0xFF, 0x00, 0x00, ##              00000000    00000000            
            0x00, 0x0F, 0xF0, 0xFF, 0x00, 0x00, ##              00000000    00000000            
            0x00, 0x07, 0xF8, 0xFF, 0x00, 0x00, ##               00000000   00000000            
            0x00, 0x07, 0xF9, 0xFE, 0x00, 0x00, ##               00000000  00000000             
            0x00, 0x07, 0xF9, 0xFE, 0x00, 0x00, ##               00000000  00000000             
            0x00, 0x03, 0xFD, 0xFE, 0x00, 0x00, ##                00000000 00000000             
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000              
            0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, ##                 000000000000000              
            0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, ##                 000000000000000              
            0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##                 00000000000000               
            0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, ##                  0000000000000               
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 52, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, ##  00000000                                     0000000
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                                    00000000
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##   0000000                                    00000000
            0x7F, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##   0000000                                    00000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##   00000000                                   0000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                                  00000000 
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##    0000000                                  00000000 
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##    0000000                                  00000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##    00000000                                 0000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##    00000000                                 0000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                                00000000  
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##     0000000                                00000000  
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0x80, ##     0000000                                0000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x80, ##     00000000                               0000000   
            0x1F, 0xE0, 0x01, 0xFC, 0x00, 0x3F, 0x80, ##     00000000            0000000            0000000   
            0x0F, 0xE0, 0x03, 0xFC, 0x00, 0x7F, 0x80, ##      0000000           00000000           00000000   
            0x0F, 0xE0, 0x03, 0xFC, 0x00, 0x7F, 0x80, ##      0000000           00000000           00000000   
            0x0F, 0xE0, 0x03, 0xFC, 0x00, 0x7F, 0x00, ##      0000000           00000000           0000000    
            0x0F, 0xF0, 0x03, 0xFE, 0x00, 0x7F, 0x00, ##      00000000          000000000          0000000    
            0x07, 0xF0, 0x07, 0xFE, 0x00, 0xFF, 0x00, ##       0000000         0000000000         00000000    
            0x07, 0xF0, 0x07, 0xFE, 0x00, 0xFF, 0x00, ##       0000000         0000000000         00000000    
            0x07, 0xF0, 0x07, 0xFF, 0x00, 0xFE, 0x00, ##       0000000         00000000000        0000000     
            0x07, 0xF8, 0x0F, 0xFF, 0x00, 0xFE, 0x00, ##       00000000       000000000000        0000000     
            0x07, 0xF8, 0x0F, 0xDF, 0x00, 0xFE, 0x00, ##       00000000       000000 00000        0000000     
            0x03, 0xF8, 0x0F, 0x9F, 0x01, 0xFE, 0x00, ##        0000000       00000  00000       00000000     
            0x03, 0xF8, 0x0F, 0x9F, 0x81, 0xFC, 0x00, ##        0000000       00000  000000      0000000      
            0x03, 0xF8, 0x1F, 0x8F, 0x81, 0xFC, 0x00, ##        0000000      000000   00000      0000000      
            0x03, 0xFC, 0x1F, 0x8F, 0x81, 0xFC, 0x00, ##        00000000     000000   00000      0000000      
            0x01, 0xFC, 0x1F, 0x0F, 0xC1, 0xFC, 0x00, ##         0000000     00000    000000     0000000      
            0x01, 0xFC, 0x1F, 0x0F, 0xC3, 0xFC, 0x00, ##         0000000     00000    000000    00000000      
            0x01, 0xFC, 0x3F, 0x07, 0xC3, 0xF8, 0x00, ##         0000000    000000     00000    0000000       
            0x01, 0xFC, 0x3E, 0x07, 0xC3, 0xF8, 0x00, ##         0000000    00000      00000    0000000       
            0x00, 0xFE, 0x3E, 0x07, 0xE3, 0xF8, 0x00, ##          0000000   00000      000000   0000000       
            0x00, 0xFE, 0x7E, 0x03, 0xE7, 0xF8, 0x00, ##          0000000  000000       00000  00000000       
            0x00, 0xFE, 0x7E, 0x03, 0xE7, 0xF0, 0x00, ##          0000000  000000       00000  0000000        
            0x00, 0xFE, 0x7C, 0x03, 0xE7, 0xF0, 0x00, ##          0000000  00000        00000  0000000        
            0x00, 0xFF, 0x7C, 0x03, 0xF7, 0xF0, 0x00, ##          00000000 00000        000000 0000000        
            0x00, 0x7F, 0xFC, 0x01, 0xF7, 0xF0, 0x00, ##           0000000000000         00000 0000000        
            0x00, 0x7F, 0xF8, 0x01, 0xFF, 0xE0, 0x00, ##           000000000000          000000000000         
            0x00, 0x7F, 0xF8, 0x01, 0xFF, 0xE0, 0x00, ##           000000000000          000000000000         
            0x00, 0x7F, 0xF8, 0x00, 0xFF, 0xE0, 0x00, ##           000000000000           00000000000         
            0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xE0, 0x00, ##            0000000000            00000000000         
            0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xE0, 0x00, ##            0000000000            00000000000         
            0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xC0, 0x00, ##            0000000000            0000000000          
            0x00, 0x3F, 0xF0, 0x00, 0x7F, 0xC0, 0x00, ##            0000000000             000000000          
            0x00, 0x1F, 0xE0, 0x00, 0x7F, 0xC0, 0x00, ##             00000000              000000000          
            0x00, 0x1F, 0xE0, 0x00, 0x7F, 0xC0, 0x00, ##             00000000              000000000          
            0x00, 0x1F, 0xE0, 0x00, 0x3F, 0x80, 0x00, ##             00000000               0000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 46, 
        'xoffset'  => 3, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x3F, 0xE0, 0x00, 0x00, 0x1F, 0xF0, ##    000000000                        000000000  
            0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xE0, ##     000000000                       00000000   
            0x0F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, ##      00000000                      000000000   
            0x0F, 0xF8, 0x00, 0x00, 0x7F, 0xC0, ##      000000000                    000000000    
            0x07, 0xFC, 0x00, 0x00, 0xFF, 0x80, ##       000000000                  000000000     
            0x03, 0xFE, 0x00, 0x00, 0xFF, 0x00, ##        000000000                 00000000      
            0x01, 0xFE, 0x00, 0x01, 0xFF, 0x00, ##         00000000                000000000      
            0x01, 0xFF, 0x00, 0x03, 0xFE, 0x00, ##         000000000              000000000       
            0x00, 0xFF, 0x80, 0x03, 0xFC, 0x00, ##          000000000             00000000        
            0x00, 0x7F, 0x80, 0x07, 0xF8, 0x00, ##           00000000            00000000         
            0x00, 0x3F, 0xC0, 0x0F, 0xF8, 0x00, ##            00000000          000000000         
            0x00, 0x3F, 0xE0, 0x1F, 0xF0, 0x00, ##            000000000        000000000          
            0x00, 0x1F, 0xF0, 0x1F, 0xE0, 0x00, ##             000000000       00000000           
            0x00, 0x0F, 0xF0, 0x3F, 0xC0, 0x00, ##              00000000      00000000            
            0x00, 0x07, 0xF8, 0x7F, 0xC0, 0x00, ##               00000000    000000000            
            0x00, 0x07, 0xFC, 0x7F, 0x80, 0x00, ##               000000000   00000000             
            0x00, 0x03, 0xFE, 0xFF, 0x00, 0x00, ##                000000000 00000000              
            0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, ##                 00000000000000000              
            0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, ##                  000000000000000               
            0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, ##                  00000000000000                
            0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##                   000000000000                 
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                 
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                  
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                 
            0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##                   000000000000                 
            0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, ##                  00000000000000                
            0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, ##                  000000000000000               
            0x00, 0x01, 0xFF, 0xFF, 0x00, 0x00, ##                 00000000000000000              
            0x00, 0x03, 0xFE, 0xFF, 0x00, 0x00, ##                000000000 00000000              
            0x00, 0x07, 0xFC, 0xFF, 0x80, 0x00, ##               000000000  000000000             
            0x00, 0x07, 0xF8, 0x7F, 0xC0, 0x00, ##               00000000    000000000            
            0x00, 0x0F, 0xF0, 0x3F, 0xE0, 0x00, ##              00000000      000000000           
            0x00, 0x1F, 0xF0, 0x1F, 0xE0, 0x00, ##             000000000       00000000           
            0x00, 0x3F, 0xE0, 0x1F, 0xF0, 0x00, ##            000000000        000000000          
            0x00, 0x3F, 0xC0, 0x0F, 0xF8, 0x00, ##            00000000          000000000         
            0x00, 0x7F, 0xC0, 0x07, 0xFC, 0x00, ##           000000000           000000000        
            0x00, 0xFF, 0x80, 0x03, 0xFC, 0x00, ##          000000000             00000000        
            0x01, 0xFF, 0x00, 0x03, 0xFE, 0x00, ##         000000000              000000000       
            0x01, 0xFE, 0x00, 0x01, 0xFF, 0x00, ##         00000000                000000000      
            0x03, 0xFE, 0x00, 0x00, 0xFF, 0x80, ##        000000000                 000000000     
            0x07, 0xFC, 0x00, 0x00, 0xFF, 0x80, ##       000000000                  000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x7F, 0xC0, ##      000000000                    000000000    
            0x0F, 0xF8, 0x00, 0x00, 0x3F, 0xE0, ##      000000000                     000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x1F, 0xF0, ##     000000000                       000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x1F, 0xF0, ##    000000000                        000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x0F, 0xF8, ##   000000000                          000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x07, 0xFC, ##   000000000                           000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 44, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                            00000000
            0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##  00000000                           000000000
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0xC0, ##    00000000                       000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x80, ##     00000000                     000000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##      000000000                  00000000     
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x03, 0xFC, 0x00, 0x07, 0xF8, 0x00, ##        00000000               00000000       
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x00, 0xFF, 0x00, 0x0F, 0xF0, 0x00, ##          00000000            00000000        
            0x00, 0xFF, 0x00, 0x0F, 0xF0, 0x00, ##          00000000            00000000        
            0x00, 0xFF, 0x00, 0x0F, 0xF0, 0x00, ##          00000000            00000000        
            0x00, 0x7F, 0x80, 0x1F, 0xE0, 0x00, ##           00000000          00000000         
            0x00, 0x7F, 0x80, 0x1F, 0xE0, 0x00, ##           00000000          00000000         
            0x00, 0x7F, 0x80, 0x3F, 0xC0, 0x00, ##           00000000         00000000          
            0x00, 0x3F, 0xC0, 0x3F, 0xC0, 0x00, ##            00000000        00000000          
            0x00, 0x3F, 0xC0, 0x3F, 0xC0, 0x00, ##            00000000        00000000          
            0x00, 0x1F, 0xE0, 0x7F, 0x80, 0x00, ##             00000000      00000000           
            0x00, 0x1F, 0xE0, 0x7F, 0x80, 0x00, ##             00000000      00000000           
            0x00, 0x1F, 0xE0, 0x7F, 0x00, 0x00, ##             00000000      0000000            
            0x00, 0x0F, 0xF0, 0xFF, 0x00, 0x00, ##              00000000    00000000            
            0x00, 0x0F, 0xF0, 0xFF, 0x00, 0x00, ##              00000000    00000000            
            0x00, 0x07, 0xF0, 0xFE, 0x00, 0x00, ##               0000000    0000000             
            0x00, 0x07, 0xF9, 0xFE, 0x00, 0x00, ##               00000000  00000000             
            0x00, 0x07, 0xF9, 0xFC, 0x00, 0x00, ##               00000000  0000000              
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000              
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000              
            0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##                 00000000000000               
            0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##                 00000000000000               
            0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##                 00000000000000               
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                 
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                  
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                  
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                    00000000                  
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                   
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                   
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                    
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                    
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                  00000000                    
            0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##                 00000000                     
            0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, ##                 00000000                     
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, ##                00000000                      
            0x00, 0x07, 0xFC, 0x00, 0x00, 0x00, ##               000000000                      
            0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##              000000000                       
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##             0000000000                       
            0x1F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##     00000000000000000                        
            0x1F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##     00000000000000000                        
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                         
            0x1F, 0xFF, 0x80, 0x00, 0x00, 0x00, ##     00000000000000                           
            0x1F, 0xFF, 0x00, 0x00, 0x00, 0x00, ##     0000000000000                            
            0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##     0000000000                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 36, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xF0, ##   00000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x3F, 0xF0, ##                            0000000000
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000 
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000  
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000   
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x03, 0xFE, 0x00, ##                        000000000     
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000      
            0x00, 0x00, 0x0F, 0xF8, 0x00, ##                      000000000       
            0x00, 0x00, 0x1F, 0xF0, 0x00, ##                     000000000        
            0x00, 0x00, 0x1F, 0xF0, 0x00, ##                     000000000        
            0x00, 0x00, 0x3F, 0xE0, 0x00, ##                    000000000         
            0x00, 0x00, 0x7F, 0xC0, 0x00, ##                   000000000          
            0x00, 0x00, 0xFF, 0x80, 0x00, ##                  000000000           
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000           
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000            
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000             
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000              
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000               
            0x00, 0x1F, 0xF8, 0x00, 0x00, ##             0000000000               
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000                
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                 
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                  
            0x00, 0xFF, 0x80, 0x00, 0x00, ##          000000000                   
            0x00, 0xFF, 0x80, 0x00, 0x00, ##          000000000                   
            0x01, 0xFF, 0x00, 0x00, 0x00, ##         000000000                    
            0x03, 0xFE, 0x00, 0x00, 0x00, ##        000000000                     
            0x07, 0xFC, 0x00, 0x00, 0x00, ##       000000000                      
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                       
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                       
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                        
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                         
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                          
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                          
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                           
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 34, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000
            0x00, 0x00, 0x1F, 0xFF, 0xC0, ##                     000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xC0, ##                   00000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                  000000000000000000
            0x00, 0x01, 0xFF, 0xFF, 0xC0, ##                 0000000000000000000
            0x00, 0x01, 0xFF, 0xFF, 0xC0, ##                 0000000000000000000
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000        
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000           
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000              
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000               
            0x01, 0xFF, 0xE0, 0x00, 0x00, ##         000000000000               
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000                
            0xFF, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000000                  
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                    
            0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000                    
            0xFF, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000000                  
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000                
            0x01, 0xFF, 0xC0, 0x00, 0x00, ##         00000000000                
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000               
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000              
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000              
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000           
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000        
            0x00, 0x01, 0xFF, 0xFF, 0xC0, ##                 0000000000000000000
            0x00, 0x01, 0xFF, 0xFF, 0xC0, ##                 0000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                  000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xC0, ##                   00000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0xC0, ##                     000000000000000
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 8, 
        'xoffset'  => 23, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 33, 
        'xoffset'  => 10, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                        
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                    
            0xFF, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000000                 
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000               
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000               
            0x01, 0xFF, 0xE0, 0x00, 0x00, ##         000000000000              
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000          
            0x00, 0x03, 0xFF, 0xC0, 0x00, ##                000000000000       
            0x00, 0x01, 0xFF, 0xFF, 0x80, ##                 000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0x80, ##                   0000000000000000
            0x00, 0x00, 0x1F, 0xFF, 0x80, ##                     00000000000000
            0x00, 0x00, 0x1F, 0xFF, 0x80, ##                     00000000000000
            0x00, 0x00, 0x7F, 0xFF, 0x80, ##                   0000000000000000
            0x00, 0x01, 0xFF, 0xFF, 0x80, ##                 000000000000000000
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000       
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000          
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000             
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000              
            0x01, 0xFF, 0xE0, 0x00, 0x00, ##         000000000000              
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000               
            0xFF, 0xFF, 0xC0, 0x00, 0x00, ##  000000000000000000               
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                  
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                    
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x08, ##           00000000                           0
            0x03, 0xFF, 0xF0, 0x00, 0x00, 0x18, ##        00000000000000                       00
            0x0F, 0xFF, 0xFE, 0x00, 0x00, 0x38, ##      0000000000000000000                   000
            0x1F, 0xFF, 0xFF, 0x00, 0x00, 0x78, ##     000000000000000000000                 0000
            0x7F, 0xFF, 0xFF, 0xE0, 0x01, 0xF8, ##   00000000000000000000000000            000000
            0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xF8, ##  00000000000000000000000000000       000000000
            0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000       00000000000000000000000000000
            0xFC, 0x00, 0x1F, 0xFF, 0xFF, 0xF0, ##  000000             0000000000000000000000000 
            0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##  0000                  00000000000000000000   
            0xE0, 0x00, 0x00, 0xFF, 0xFF, 0x80, ##  000                     00000000000000000    
            0xC0, 0x00, 0x00, 0x3F, 0xFE, 0x00, ##  00                        0000000000000      
            0x80, 0x00, 0x00, 0x07, 0xF0, 0x00, ##  0                            0000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 8, 
        'xoffset'  => 22, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 36, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x7F, 0xF8, 0x00, ##                   000000000000       
            0x00, 0x03, 0xFF, 0xFF, 0x80, ##                0000000000000000000   
            0x00, 0x0F, 0xFF, 0xFF, 0xF0, ##              000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xF0, ##           000000000000000000000000000
            0x01, 0xFF, 0xFF, 0xFF, 0xF0, ##         00000000000000000000000000000
            0x03, 0xFF, 0xC7, 0x87, 0xF0, ##        000000000000   0000    0000000
            0x03, 0xFF, 0x07, 0x80, 0xF0, ##        0000000000     0000       0000
            0x07, 0xFC, 0x07, 0x80, 0x30, ##       000000000       0000         00
            0x0F, 0xF8, 0x07, 0x80, 0x00, ##      000000000        0000           
            0x1F, 0xF0, 0x07, 0x80, 0x00, ##     000000000         0000           
            0x1F, 0xF0, 0x07, 0x80, 0x00, ##     000000000         0000           
            0x3F, 0xE0, 0x07, 0x80, 0x00, ##    000000000          0000           
            0x3F, 0xC0, 0x07, 0x80, 0x00, ##    00000000           0000           
            0x3F, 0xC0, 0x07, 0x80, 0x00, ##    00000000           0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x00, 0x07, 0x80, 0x00, ##  00000000             0000           
            0xFF, 0x80, 0x07, 0x80, 0x00, ##  000000000            0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0x7F, 0x80, 0x07, 0x80, 0x00, ##   00000000            0000           
            0x7F, 0xC0, 0x07, 0x80, 0x00, ##   000000000           0000           
            0x7F, 0xC0, 0x07, 0x80, 0x00, ##   000000000           0000           
            0x3F, 0xC0, 0x07, 0x80, 0x00, ##    00000000           0000           
            0x3F, 0xE0, 0x07, 0x80, 0x00, ##    000000000          0000           
            0x1F, 0xF0, 0x07, 0x80, 0x00, ##     000000000         0000           
            0x1F, 0xF8, 0x07, 0x80, 0x00, ##     0000000000        0000           
            0x0F, 0xFC, 0x07, 0x80, 0x10, ##      0000000000       0000          0
            0x07, 0xFE, 0x07, 0x80, 0x70, ##       0000000000      0000        000
            0x07, 0xFF, 0x07, 0x81, 0xF0, ##       00000000000     0000      00000
            0x03, 0xFF, 0xE7, 0x8F, 0xF0, ##        0000000000000  0000   00000000
            0x01, 0xFF, 0xFF, 0xFF, 0xF0, ##         00000000000000000000000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xF0, ##          0000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xF0, ##            00000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xF0, ##             0000000000000000000000000
            0x00, 0x07, 0xFF, 0xFF, 0x80, ##               00000000000000000000   
            0x00, 0x00, 0xFF, 0xFC, 0x00, ##                  00000000000000      
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x07, 0x80, 0x00, ##                       0000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##                         00000000000       
            0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x00, ##                      000000000000000000   
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x00, ##                    0000000000000000000000 
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x00, ##                   00000000000000000000000 
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, ##                 0000000000000000000000000 
            0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x00, ##                00000000000000000000000000 
            0x00, 0x03, 0xFF, 0xC0, 0x7F, 0x00, ##                000000000000       0000000 
            0x00, 0x07, 0xFE, 0x00, 0x0F, 0x00, ##               0000000000             0000 
            0x00, 0x07, 0xFC, 0x00, 0x03, 0x00, ##               000000000                00 
            0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##              000000000                    
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##              00000000                     
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##             000000000                     
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                      
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                      
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                      
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, ##            000000000                      
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x00, ##            00000000                       
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x08, 0x00, 0x00, 0x00, 0x00, ##      0                                  
            0x1C, 0x00, 0x00, 0x00, 0x30, ##     000                            00   
            0x3C, 0x00, 0x00, 0x00, 0x78, ##    0000                           0000  
            0x7E, 0x00, 0x00, 0x00, 0xFC, ##   000000                         000000 
            0xFF, 0x00, 0x00, 0x01, 0xFC, ##  00000000                       0000000 
            0x3F, 0x80, 0xFE, 0x03, 0xF8, ##    0000000       0000000       0000000  
            0x1F, 0xC7, 0xFF, 0xC7, 0xF0, ##     0000000   0000000000000   0000000   
            0x0F, 0xFF, 0xFF, 0xFF, 0xE0, ##      0000000000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xC0, ##       00000000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFF, 0x80, ##        000000000000000000000000000      
            0x01, 0xFF, 0x01, 0xFF, 0x00, ##         000000000       000000000       
            0x01, 0xFC, 0x00, 0x7F, 0x00, ##         0000000           0000000       
            0x01, 0xF8, 0x00, 0x3F, 0x00, ##         000000             000000       
            0x03, 0xF0, 0x00, 0x1F, 0x80, ##        000000               000000      
            0x03, 0xE0, 0x00, 0x0F, 0x80, ##        00000                 00000      
            0x03, 0xE0, 0x00, 0x0F, 0x80, ##        00000                 00000      
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x07, 0xC0, 0x00, 0x07, 0xC0, ##       00000                   00000     
            0x03, 0xE0, 0x00, 0x0F, 0x80, ##        00000                 00000      
            0x03, 0xE0, 0x00, 0x0F, 0x80, ##        00000                 00000      
            0x03, 0xF0, 0x00, 0x1F, 0x80, ##        000000               000000      
            0x01, 0xF8, 0x00, 0x3F, 0x00, ##         000000             000000       
            0x01, 0xFC, 0x00, 0x7F, 0x00, ##         0000000           0000000       
            0x01, 0xFF, 0x01, 0xFF, 0x00, ##         000000000       000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0x80, ##        000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xC0, ##       00000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xE0, ##      0000000000000000000000000000000    
            0x1F, 0xC7, 0xFF, 0xC7, 0xF0, ##     0000000   0000000000000   0000000   
            0x3F, 0x80, 0xFE, 0x03, 0xF8, ##    0000000       0000000       0000000  
            0x7F, 0x00, 0x00, 0x01, 0xFE, ##   0000000                       00000000
            0x7E, 0x00, 0x00, 0x00, 0xFC, ##   000000                         000000 
            0x3C, 0x00, 0x00, 0x00, 0x78, ##    0000                           0000  
            0x18, 0x00, 0x00, 0x00, 0x30, ##     00                             00   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x80, ##  000000000                              0000000000
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   000000000                            000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFE, 0x00, ##    000000000                          0000000000  
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     000000000                         000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##     000000000                        0000000000   
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      000000000                       000000000    
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##      000000000                      000000000     
            0x07, 0xFC, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##       000000000                     000000000     
            0x07, 0xFC, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##       000000000                    000000000      
            0x03, 0xFE, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##        000000000                   00000000       
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000       
            0x01, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##         000000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x00, ##          000000000              000000000         
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x3F, 0xC0, 0x03, 0xFE, 0x00, 0x00, ##            00000000            000000000          
            0x00, 0x3F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##            000000000           00000000           
            0x00, 0x1F, 0xE0, 0x07, 0xFC, 0x00, 0x00, ##             00000000          000000000           
            0x00, 0x1F, 0xF0, 0x0F, 0xF8, 0x00, 0x00, ##             000000000        000000000            
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, ##              00000000        00000000             
            0x00, 0x0F, 0xF8, 0x1F, 0xF0, 0x00, 0x00, ##              000000000      000000000             
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x1F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x00, ##     0000000000000000000    00000000000000000000   
            0x1F, 0xFF, 0xFC, 0x3F, 0xFF, 0xFC, 0x00, ##     0000000000000000000    00000000000000000000   
            0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFC, 0x00, ##     00000000000000000000  000000000000000000000   
            0x1F, 0xFF, 0xFF, 0x7F, 0xFF, 0xFC, 0x00, ##     000000000000000000000 000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##     0000000000000000000000000000000000000000000   
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##                     0000000000                    
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##                     0000000000                    
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##     0000000000000000000000000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##     0000000000000000000000000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##     0000000000000000000000000000000000000000000   
            0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##     0000000000000000000000000000000000000000000   
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 8, 
        'xoffset'  => 23, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0x00, ##          
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0xFF, ##  00000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 36, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000            
            0x00, 0x3F, 0xFF, 0xF8, 0x00, ##            0000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0x00, ##          000000000000000000000000    
            0x01, 0xFF, 0xFF, 0xFF, 0x00, ##         0000000000000000000000000    
            0x03, 0xFF, 0xFF, 0xFF, 0x00, ##        00000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0x00, ##       000000000000000000000000000    
            0x0F, 0xFF, 0x00, 0xFF, 0x00, ##      000000000000        00000000    
            0x0F, 0xFC, 0x00, 0x1F, 0x00, ##      0000000000             00000    
            0x0F, 0xF0, 0x00, 0x03, 0x00, ##      00000000                  00    
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                        
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                         
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                         
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                         
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                         
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                        
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                        
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                       
            0x0F, 0xFC, 0x00, 0x00, 0x00, ##      0000000000                      
            0x07, 0xFE, 0x00, 0x00, 0x00, ##       0000000000                     
            0x07, 0xFF, 0x80, 0x00, 0x00, ##       000000000000                   
            0x03, 0xFF, 0xC0, 0x00, 0x00, ##        000000000000                  
            0x00, 0xFF, 0xF0, 0x00, 0x00, ##          000000000000                
            0x01, 0xFF, 0xFC, 0x00, 0x00, ##         000000000000000              
            0x07, 0xFF, 0xFF, 0x00, 0x00, ##       0000000000000000000            
            0x0F, 0xFF, 0xFF, 0x80, 0x00, ##      000000000000000000000           
            0x1F, 0xE3, 0xFF, 0xE0, 0x00, ##     00000000   0000000000000         
            0x3F, 0xC1, 0xFF, 0xF0, 0x00, ##    00000000     0000000000000        
            0x3F, 0x80, 0x7F, 0xFC, 0x00, ##    0000000        0000000000000      
            0x7F, 0x00, 0x1F, 0xFE, 0x00, ##   0000000           000000000000     
            0x7F, 0x00, 0x0F, 0xFF, 0x00, ##   0000000            000000000000    
            0xFE, 0x00, 0x03, 0xFF, 0x80, ##  0000000               00000000000   
            0xFE, 0x00, 0x00, 0xFF, 0xC0, ##  0000000                 0000000000  
            0xFE, 0x00, 0x00, 0x7F, 0xE0, ##  0000000                  0000000000 
            0xFE, 0x00, 0x00, 0x3F, 0xE0, ##  0000000                   000000000 
            0xFE, 0x00, 0x00, 0x1F, 0xE0, ##  0000000                    00000000 
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0x7F, 0x80, 0x00, 0x07, 0xF0, ##   00000000                    0000000
            0x7F, 0xC0, 0x00, 0x07, 0xF0, ##   000000000                   0000000
            0x7F, 0xE0, 0x00, 0x07, 0xF0, ##   0000000000                  0000000
            0x3F, 0xF0, 0x00, 0x07, 0xF0, ##    0000000000                 0000000
            0x1F, 0xFC, 0x00, 0x07, 0xF0, ##     00000000000               0000000
            0x0F, 0xFE, 0x00, 0x0F, 0xE0, ##      00000000000             0000000 
            0x07, 0xFF, 0x80, 0x0F, 0xE0, ##       000000000000           0000000 
            0x03, 0xFF, 0xC0, 0x1F, 0xC0, ##        000000000000         0000000  
            0x01, 0xFF, 0xF0, 0x3F, 0xC0, ##         0000000000000      00000000  
            0x00, 0x7F, 0xFC, 0x7F, 0x80, ##           0000000000000   00000000   
            0x00, 0x3F, 0xFF, 0xFF, 0x00, ##            0000000000000000000000    
            0x00, 0x0F, 0xFF, 0xFE, 0x00, ##              0000000000000000000     
            0x00, 0x03, 0xFF, 0xF8, 0x00, ##                000000000000000       
            0x00, 0x01, 0xFF, 0xF0, 0x00, ##                 0000000000000        
            0x00, 0x00, 0x7F, 0xF8, 0x00, ##                   000000000000       
            0x00, 0x00, 0x1F, 0xFC, 0x00, ##                     00000000000      
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x07, 0xFF, 0x00, ##                       00000000000    
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0xFF, 0x80, ##                          000000000   
            0x08, 0x00, 0x01, 0xFF, 0x00, ##      0                  000000000    
            0x0F, 0x00, 0x03, 0xFF, 0x00, ##      0000              0000000000    
            0x0F, 0xF0, 0x0F, 0xFE, 0x00, ##      00000000        00000000000     
            0x0F, 0xFF, 0xFF, 0xFE, 0x00, ##      000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFC, 0x00, ##      00000000000000000000000000      
            0x0F, 0xFF, 0xFF, 0xF8, 0x00, ##      0000000000000000000000000       
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, ##      00000000000000000000000         
            0x01, 0xFF, 0xFF, 0x80, 0x00, ##         000000000000000000           
            0x00, 0x1F, 0xFC, 0x00, 0x00, ##             00000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 25, 
        'xoffset'  => 14, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0xFF, 0x00, 0x7F, 0x80, ##  00000000         00000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 52, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                     
            0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, ##                   000000000000000000                 
            0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##                 0000000000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##               00000000000000000000000000             
            0x00, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x00, ##             0000000000          0000000000           
            0x00, 0x3F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##            00000000                00000000          
            0x00, 0x7F, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##           0000000                    0000000         
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, ##          000000                        000000        
            0x01, 0xF8, 0x00, 0x00, 0x01, 0xF8, 0x00, ##         000000                          000000       
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x7C, 0x00, ##        00000                              00000      
            0x07, 0xC0, 0x03, 0xFF, 0x00, 0x3E, 0x00, ##       00000            0000000000          00000     
            0x0F, 0x80, 0x1F, 0xFF, 0xF0, 0x1F, 0x00, ##      00000          00000000000000000       00000    
            0x0F, 0x80, 0x7F, 0xFF, 0xF8, 0x1F, 0x00, ##      00000        00000000000000000000      00000    
            0x1F, 0x01, 0xFF, 0xFF, 0xF8, 0x0F, 0x80, ##     00000       0000000000000000000000       00000   
            0x1E, 0x03, 0xFE, 0x01, 0xF8, 0x07, 0x80, ##     0000       000000000        000000        0000   
            0x3E, 0x07, 0xF8, 0x00, 0x18, 0x07, 0xC0, ##    00000      00000000              00        00000  
            0x3C, 0x07, 0xF0, 0x00, 0x00, 0x03, 0xC0, ##    0000       0000000                          0000  
            0x7C, 0x0F, 0xE0, 0x00, 0x00, 0x03, 0xE0, ##   00000      0000000                           00000 
            0x78, 0x1F, 0xC0, 0x00, 0x00, 0x01, 0xE0, ##   0000      0000000                             0000 
            0x78, 0x1F, 0x80, 0x00, 0x00, 0x01, 0xE0, ##   0000      000000                              0000 
            0x78, 0x1F, 0x80, 0x00, 0x00, 0x01, 0xE0, ##   0000      000000                              0000 
            0xF0, 0x3F, 0x80, 0x00, 0x00, 0x00, 0xF0, ##  0000      0000000                               0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, ##  0000      000000                                0000
            0xF0, 0x1F, 0x80, 0x00, 0x00, 0x00, 0xF0, ##  0000       000000                               0000
            0x78, 0x1F, 0x80, 0x00, 0x00, 0x01, 0xE0, ##   0000      000000                              0000 
            0x78, 0x1F, 0xC0, 0x00, 0x00, 0x01, 0xE0, ##   0000      0000000                             0000 
            0x78, 0x0F, 0xC0, 0x00, 0x00, 0x01, 0xE0, ##   0000       000000                             0000 
            0x7C, 0x0F, 0xE0, 0x00, 0x00, 0x03, 0xE0, ##   00000      0000000                           00000 
            0x3C, 0x07, 0xF8, 0x00, 0x18, 0x03, 0xC0, ##    0000       00000000              00         0000  
            0x3E, 0x03, 0xFE, 0x00, 0xF8, 0x07, 0xC0, ##    00000       000000000         00000        00000  
            0x1E, 0x01, 0xFF, 0xFF, 0xF8, 0x07, 0x80, ##     0000        0000000000000000000000        0000   
            0x1F, 0x00, 0x7F, 0xFF, 0xF8, 0x0F, 0x80, ##     00000         00000000000000000000       00000   
            0x0F, 0x80, 0x1F, 0xFF, 0xF0, 0x1F, 0x00, ##      00000          00000000000000000       00000    
            0x0F, 0xC0, 0x03, 0xFF, 0x00, 0x3F, 0x00, ##      000000            0000000000          000000    
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x00, ##       000000                               00000     
            0x03, 0xF0, 0x00, 0x00, 0x00, 0xFC, 0x00, ##        000000                            000000      
            0x01, 0xF8, 0x00, 0x00, 0x01, 0xF8, 0x00, ##         000000                          000000       
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, ##          000000                        000000        
            0x00, 0x7F, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##           0000000                    0000000         
            0x00, 0x3F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##            00000000                00000000          
            0x00, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x00, ##             0000000000          0000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##               00000000000000000000000000             
            0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##                 0000000000000000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, ##                   000000000000000000                 
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 29, 
        'xoffset'  => 11, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000          
            0x07, 0xFF, 0xFC, 0x00, ##       00000000000000000       
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000     
            0x1F, 0xFF, 0xFF, 0x80, ##     0000000000000000000000    
            0x1F, 0xFF, 0xFF, 0xC0, ##     00000000000000000000000   
            0x1F, 0x80, 0x7F, 0xE0, ##     000000        0000000000  
            0x1C, 0x00, 0x0F, 0xE0, ##     000              0000000  
            0x10, 0x00, 0x07, 0xF0, ##     0                 0000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000 
            0x00, 0x00, 0x03, 0xF0, ##                        000000 
            0x00, 0x00, 0x01, 0xF8, ##                         000000
            0x00, 0x00, 0x01, 0xF8, ##                         000000
            0x00, 0x00, 0x01, 0xF8, ##                         000000
            0x00, 0x3F, 0xFF, 0xF8, ##            0000000000000000000
            0x01, 0xFF, 0xFF, 0xF8, ##         0000000000000000000000
            0x07, 0xFF, 0xFF, 0xF8, ##       000000000000000000000000
            0x1F, 0xFF, 0xFF, 0xF8, ##     00000000000000000000000000
            0x3F, 0xFF, 0xFF, 0xF8, ##    000000000000000000000000000
            0x3F, 0xF0, 0x01, 0xF8, ##    0000000000           000000
            0x7F, 0x80, 0x01, 0xF8, ##   00000000              000000
            0x7E, 0x00, 0x01, 0xF8, ##   000000                000000
            0xFE, 0x00, 0x01, 0xF8, ##  0000000                000000
            0xFC, 0x00, 0x01, 0xF8, ##  000000                 000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x03, 0xF8, ##  000000                0000000
            0xFC, 0x00, 0x07, 0xF8, ##  000000               00000000
            0xFC, 0x00, 0x07, 0xF8, ##  000000               00000000
            0xFE, 0x00, 0x0F, 0xF8, ##  0000000             000000000
            0x7F, 0x00, 0x3F, 0xF8, ##   0000000          00000000000
            0x7F, 0xC0, 0xFF, 0xF8, ##   000000000      0000000000000
            0x3F, 0xFF, 0xFD, 0xF8, ##    00000000000000000000 000000
            0x1F, 0xFF, 0xF9, 0xF8, ##     000000000000000000  000000
            0x0F, 0xFF, 0xF1, 0xF8, ##      0000000000000000   000000
            0x07, 0xFF, 0xC1, 0xF8, ##       0000000000000     000000
            0x00, 0xFF, 0x00, 0x00, ##          00000000             
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x00, 0x00, 0x00, 0x00, ##                               
            0x7F, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 39, 
        'xoffset'  => 5, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x10, 0x00, 0x02, ##                     0                  0
            0x00, 0x00, 0x30, 0x00, 0x06, ##                    00                 00
            0x00, 0x00, 0x70, 0x00, 0x0E, ##                   000                000
            0x00, 0x00, 0xF0, 0x00, 0x1E, ##                  0000               0000
            0x00, 0x01, 0xF0, 0x00, 0x3E, ##                 00000              00000
            0x00, 0x03, 0xF0, 0x00, 0x7E, ##                000000             000000
            0x00, 0x0F, 0xF0, 0x00, 0xFE, ##              00000000            0000000
            0x00, 0x1F, 0xF0, 0x01, 0xFE, ##             000000000           00000000
            0x00, 0x3F, 0xE0, 0x07, 0xFC, ##            000000000          000000000 
            0x00, 0x7F, 0xC0, 0x0F, 0xF8, ##           000000000          000000000  
            0x00, 0xFF, 0x80, 0x1F, 0xF0, ##          000000000          000000000   
            0x01, 0xFF, 0x00, 0x3F, 0xE0, ##         000000000          000000000    
            0x03, 0xFE, 0x00, 0x7F, 0xC0, ##        000000000          000000000     
            0x07, 0xFC, 0x00, 0xFF, 0x80, ##       000000000          000000000      
            0x1F, 0xF8, 0x01, 0xFF, 0x00, ##     0000000000          000000000       
            0x3F, 0xF0, 0x03, 0xFE, 0x00, ##    0000000000          000000000        
            0x7F, 0xC0, 0x07, 0xFC, 0x00, ##   000000000           000000000         
            0xFF, 0x80, 0x0F, 0xF0, 0x00, ##  000000000           00000000           
            0xFF, 0x00, 0x1F, 0xE0, 0x00, ##  00000000           00000000            
            0xFE, 0x00, 0x1F, 0xE0, 0x00, ##  0000000            00000000            
            0xFF, 0x00, 0x1F, 0xF0, 0x00, ##  00000000           000000000           
            0xFF, 0xC0, 0x0F, 0xF8, 0x00, ##  0000000000          000000000          
            0x3F, 0xE0, 0x07, 0xFC, 0x00, ##    000000000          000000000         
            0x1F, 0xF0, 0x03, 0xFE, 0x00, ##     000000000          000000000        
            0x0F, 0xF8, 0x01, 0xFF, 0x00, ##      000000000          000000000       
            0x07, 0xFC, 0x00, 0xFF, 0x80, ##       000000000          000000000      
            0x03, 0xFE, 0x00, 0x7F, 0xC0, ##        000000000          000000000     
            0x01, 0xFF, 0x00, 0x3F, 0xE0, ##         000000000          000000000    
            0x00, 0xFF, 0x80, 0x0F, 0xF0, ##          000000000           00000000   
            0x00, 0x7F, 0xE0, 0x07, 0xFC, ##           0000000000          000000000 
            0x00, 0x1F, 0xF0, 0x03, 0xFE, ##             000000000          000000000
            0x00, 0x0F, 0xF0, 0x01, 0xFE, ##              00000000           00000000
            0x00, 0x07, 0xF0, 0x00, 0xFE, ##               0000000            0000000
            0x00, 0x03, 0xF0, 0x00, 0x7E, ##                000000             000000
            0x00, 0x01, 0xF0, 0x00, 0x3E, ##                 00000              00000
            0x00, 0x00, 0xF0, 0x00, 0x1E, ##                  0000               0000
            0x00, 0x00, 0x70, 0x00, 0x0E, ##                   000                000
            0x00, 0x00, 0x30, 0x00, 0x06, ##                    00                 00
            0x00, 0x00, 0x10, 0x00, 0x02, ##                     0                  0
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 22, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 52, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                     
            0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, ##                   000000000000000000                 
            0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##                 0000000000000000000000               
            0x00, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##               00000000000000000000000000             
            0x00, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x00, ##             0000000000          0000000000           
            0x00, 0x3F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##            00000000                00000000          
            0x00, 0x7F, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##           0000000                    0000000         
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, ##          000000                        000000        
            0x01, 0xF8, 0x00, 0x00, 0x01, 0xF8, 0x00, ##         000000                          000000       
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x7C, 0x00, ##        00000                              00000      
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x3E, 0x00, ##       00000                                00000     
            0x0F, 0x81, 0xFF, 0xFE, 0x00, 0x1F, 0x00, ##      00000      0000000000000000            00000    
            0x0F, 0x81, 0xFF, 0xFF, 0xC0, 0x1F, 0x00, ##      00000      0000000000000000000         00000    
            0x1F, 0x01, 0xFF, 0xFF, 0xF0, 0x0F, 0x80, ##     00000       000000000000000000000        00000   
            0x1E, 0x01, 0xF8, 0x07, 0xF8, 0x07, 0x80, ##     0000        000000        00000000        0000   
            0x3E, 0x01, 0xF8, 0x01, 0xF8, 0x07, 0xC0, ##    00000        000000          000000        00000  
            0x3C, 0x01, 0xF8, 0x00, 0xFC, 0x03, 0xC0, ##    0000         000000           000000        0000  
            0x7C, 0x01, 0xF8, 0x00, 0xFC, 0x03, 0xE0, ##   00000         000000           000000        00000 
            0x78, 0x01, 0xF8, 0x00, 0xFC, 0x01, 0xE0, ##   0000          000000           000000         0000 
            0x78, 0x01, 0xF8, 0x00, 0xFC, 0x01, 0xE0, ##   0000          000000           000000         0000 
            0x78, 0x01, 0xF8, 0x00, 0xFC, 0x01, 0xE0, ##   0000          000000           000000         0000 
            0xF0, 0x01, 0xF8, 0x01, 0xFC, 0x00, 0xF0, ##  0000           000000          0000000          0000
            0xF0, 0x01, 0xF8, 0x01, 0xF8, 0x00, 0xF0, ##  0000           000000          000000           0000
            0xF0, 0x01, 0xF8, 0x07, 0xF0, 0x00, 0xF0, ##  0000           000000        0000000            0000
            0xF0, 0x01, 0xFF, 0xFF, 0xE0, 0x00, 0xF0, ##  0000           00000000000000000000             0000
            0xF0, 0x01, 0xFF, 0xFF, 0x80, 0x00, 0xF0, ##  0000           000000000000000000               0000
            0xF0, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0xF0, ##  0000           0000000000000000                 0000
            0xF0, 0x01, 0xF8, 0x3F, 0x00, 0x00, 0xF0, ##  0000           000000     000000                0000
            0xF0, 0x01, 0xF8, 0x1F, 0x80, 0x00, 0xF0, ##  0000           000000      000000               0000
            0xF0, 0x01, 0xF8, 0x0F, 0xC0, 0x00, 0xF0, ##  0000           000000       000000              0000
            0xF0, 0x01, 0xF8, 0x07, 0xE0, 0x00, 0xF0, ##  0000           000000        000000             0000
            0x78, 0x01, 0xF8, 0x07, 0xE0, 0x01, 0xE0, ##   0000          000000        000000            0000 
            0x78, 0x01, 0xF8, 0x03, 0xF0, 0x01, 0xE0, ##   0000          000000         000000           0000 
            0x78, 0x01, 0xF8, 0x03, 0xF8, 0x01, 0xE0, ##   0000          000000         0000000          0000 
            0x7C, 0x01, 0xF8, 0x01, 0xF8, 0x03, 0xE0, ##   00000         000000          000000         00000 
            0x3C, 0x01, 0xF8, 0x00, 0xFC, 0x03, 0xC0, ##    0000         000000           000000        0000  
            0x3E, 0x01, 0xF8, 0x00, 0xFC, 0x07, 0xC0, ##    00000        000000           000000       00000  
            0x1E, 0x01, 0xF8, 0x00, 0x7E, 0x07, 0x80, ##     0000        000000            000000      0000   
            0x1F, 0x01, 0xF8, 0x00, 0x7F, 0x0F, 0x80, ##     00000       000000            0000000    00000   
            0x0F, 0x81, 0xF8, 0x00, 0x3F, 0x1F, 0x00, ##      00000      000000             000000   00000    
            0x0F, 0xC0, 0x00, 0x00, 0x00, 0x3F, 0x00, ##      000000                                000000    
            0x07, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x00, ##       000000                               00000     
            0x03, 0xF0, 0x00, 0x00, 0x00, 0xFC, 0x00, ##        000000                            000000      
            0x01, 0xF8, 0x00, 0x00, 0x01, 0xF8, 0x00, ##         000000                          000000       
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, ##          000000                        000000        
            0x00, 0x7F, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##           0000000                    0000000         
            0x00, 0x3F, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##            00000000                00000000          
            0x00, 0x1F, 0xF8, 0x01, 0xFF, 0x80, 0x00, ##             0000000000          0000000000           
            0x00, 0x07, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##               00000000000000000000000000             
            0x00, 0x01, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##                 0000000000000000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, ##                   000000000000000000                 
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 25, 
        'xoffset'  => 13, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 27, 
        'xoffset'  => 13, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x80, 0x00, ##            0000000          
            0x01, 0xFF, 0xF0, 0x00, ##         0000000000000       
            0x03, 0xFF, 0xF8, 0x00, ##        000000000000000      
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000    
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000   
            0x1F, 0xE0, 0xFF, 0x00, ##     00000000     00000000   
            0x3F, 0x80, 0x3F, 0x80, ##    0000000         0000000  
            0x7E, 0x00, 0x1F, 0xC0, ##   000000            0000000 
            0x7E, 0x00, 0x0F, 0xC0, ##   000000             000000 
            0x7C, 0x00, 0x07, 0xC0, ##   00000               00000 
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xF8, 0x00, 0x03, 0xE0, ##  00000                 00000
            0xF8, 0x00, 0x03, 0xE0, ##  00000                 00000
            0xF8, 0x00, 0x03, 0xE0, ##  00000                 00000
            0xF8, 0x00, 0x03, 0xE0, ##  00000                 00000
            0xF8, 0x00, 0x03, 0xE0, ##  00000                 00000
            0xF8, 0x00, 0x07, 0xE0, ##  00000                000000
            0x7C, 0x00, 0x07, 0xC0, ##   00000               00000 
            0x7C, 0x00, 0x0F, 0xC0, ##   00000              000000 
            0x7E, 0x00, 0x0F, 0xC0, ##   000000             000000 
            0x3F, 0x00, 0x3F, 0x80, ##    000000          0000000  
            0x3F, 0xC0, 0xFF, 0x00, ##    00000000      00000000   
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000   
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000    
            0x07, 0xFF, 0xF8, 0x00, ##       0000000000000000      
            0x01, 0xFF, 0xF0, 0x00, ##         0000000000000       
            0x00, 0x3F, 0x80, 0x00, ##            0000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 24, 
        'xoffset'  => 14, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x03, 0xFE, 0x00, ##        000000000         
            0x3F, 0xFF, 0xC0, ##    0000000000000000      
            0xFF, 0xFF, 0xF0, ##  00000000000000000000    
            0xFF, 0xFF, 0xF8, ##  000000000000000000000   
            0xFE, 0x07, 0xFC, ##  0000000      000000000  
            0xF0, 0x00, 0xFE, ##  0000            0000000 
            0xC0, 0x00, 0x7E, ##  00               000000 
            0x00, 0x00, 0x7F, ##                   0000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x3F, ##                    000000
            0x00, 0x00, 0x7E, ##                   000000 
            0x00, 0x00, 0x7E, ##                   000000 
            0x00, 0x00, 0xFC, ##                  000000  
            0x00, 0x01, 0xFC, ##                 0000000  
            0x00, 0x03, 0xF8, ##                0000000   
            0x00, 0x03, 0xF0, ##                000000    
            0x00, 0x07, 0xE0, ##               000000     
            0x00, 0x0F, 0xC0, ##              000000      
            0x00, 0x1F, 0x80, ##             000000       
            0x00, 0x3F, 0x80, ##            0000000       
            0x00, 0x7F, 0x00, ##           0000000        
            0x00, 0xFE, 0x00, ##          0000000         
            0x01, 0xFC, 0x00, ##         0000000          
            0x03, 0xF8, 0x00, ##        0000000           
            0x07, 0xF0, 0x00, ##       0000000            
            0x0F, 0xE0, 0x00, ##      0000000             
            0x1F, 0xC0, 0x00, ##     0000000              
            0x3F, 0x80, 0x00, ##    0000000               
            0x7F, 0x00, 0x00, ##   0000000                
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0xFF, 0xFF, 0xFF, ##  000000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 25, 
        'xoffset'  => 14, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x07, 0xFF, 0x00, 0x00, ##       00000000000         
            0x7F, 0xFF, 0xE0, 0x00, ##   000000000000000000      
            0x7F, 0xFF, 0xF0, 0x00, ##   0000000000000000000     
            0x7F, 0xFF, 0xFC, 0x00, ##   000000000000000000000   
            0x7E, 0x03, 0xFC, 0x00, ##   000000       00000000   
            0x60, 0x00, 0xFE, 0x00, ##   00             0000000  
            0x00, 0x00, 0x7F, 0x00, ##                   0000000 
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x00, 0x00, 0x7E, 0x00, ##                   000000  
            0x00, 0x00, 0x7E, 0x00, ##                   000000  
            0x00, 0x00, 0xFC, 0x00, ##                  000000   
            0x00, 0x03, 0xF8, 0x00, ##                0000000    
            0x01, 0xFF, 0xE0, 0x00, ##         000000000000      
            0x01, 0xFF, 0x80, 0x00, ##         0000000000        
            0x01, 0xFF, 0xF0, 0x00, ##         0000000000000     
            0x01, 0xFF, 0xFC, 0x00, ##         000000000000000   
            0x00, 0x03, 0xFE, 0x00, ##                000000000  
            0x00, 0x00, 0xFF, 0x00, ##                  00000000 
            0x00, 0x00, 0x7F, 0x00, ##                   0000000 
            0x00, 0x00, 0x3F, 0x80, ##                    0000000
            0x00, 0x00, 0x1F, 0x80, ##                     000000
            0x00, 0x00, 0x1F, 0x80, ##                     000000
            0x00, 0x00, 0x1F, 0x80, ##                     000000
            0x00, 0x00, 0x1F, 0x80, ##                     000000
            0x00, 0x00, 0x1F, 0x80, ##                     000000
            0x00, 0x00, 0x3F, 0x80, ##                    0000000
            0x00, 0x00, 0x3F, 0x00, ##                    000000 
            0x80, 0x00, 0x7F, 0x00, ##  0                0000000 
            0xF0, 0x01, 0xFE, 0x00, ##  0000           00000000  
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000   
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000    
            0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000     
            0x3F, 0xFF, 0x80, 0x00, ##    000000000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 21, 
        'xoffset'  => 20, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, ##              00000000 
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x7F, 0xC0, ##           000000000   
            0x00, 0x7F, 0x80, ##           00000000    
            0x00, 0xFF, 0x00, ##          00000000     
            0x01, 0xFE, 0x00, ##         00000000      
            0x01, 0xFC, 0x00, ##         0000000       
            0x03, 0xF8, 0x00, ##        0000000        
            0x07, 0xF0, 0x00, ##       0000000         
            0x0F, 0xE0, 0x00, ##      0000000          
            0x0F, 0xE0, 0x00, ##      0000000          
            0x1F, 0xC0, 0x00, ##     0000000           
            0x3F, 0x80, 0x00, ##    0000000            
            0x7F, 0x00, 0x00, ##   0000000             
            0x7E, 0x00, 0x00, ##   000000              
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 42, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##  00000000                    00000000      
            0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  00000000                   000000000      
            0xFF, 0x80, 0x00, 0x1F, 0xF0, 0x00, ##  000000000                  000000000      
            0xFF, 0x80, 0x00, 0x1F, 0xF0, 0x00, ##  000000000                  000000000      
            0xFF, 0x80, 0x00, 0x3F, 0xF0, 0x00, ##  000000000                 0000000000      
            0xFF, 0xC0, 0x00, 0x3F, 0xF0, 0x00, ##  0000000000                0000000000      
            0xFF, 0xC0, 0x00, 0x7F, 0xF0, 0x00, ##  0000000000               00000000000      
            0xFF, 0xE0, 0x00, 0xFF, 0xF0, 0x00, ##  00000000000             000000000000      
            0xFF, 0xF0, 0x01, 0xFF, 0xF8, 0x00, ##  000000000000           00000000000000     
            0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xC0, ##  00000000000000       000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFE, 0xFF, 0xFF, 0xF7, 0xFF, 0xC0, ##  0000000 00000000000000000000 0000000000000
            0xFE, 0x7F, 0xFF, 0xE3, 0xFF, 0xC0, ##  0000000  000000000000000000   000000000000
            0xFE, 0x3F, 0xFF, 0xC3, 0xFF, 0xC0, ##  0000000   0000000000000000    000000000000
            0xFE, 0x0F, 0xFF, 0x81, 0xFF, 0xC0, ##  0000000     0000000000000      00000000000
            0xFE, 0x03, 0xFC, 0x00, 0x7E, 0x00, ##  0000000       00000000           000000   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 39, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xFF, 0xFE, ##                 000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFE, ##             0000000000000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xFE, ##           000000000000000000000000000000
            0x01, 0xFF, 0xFF, 0xFF, 0xFE, ##         00000000000000000000000000000000
            0x03, 0xFF, 0xFF, 0xFF, 0xFE, ##        000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0x80, 0x7E, ##       00000000000000000000        000000
            0x0F, 0xFF, 0xFF, 0x80, 0x7E, ##      000000000000000000000        000000
            0x1F, 0xFF, 0xFF, 0x80, 0x7E, ##     0000000000000000000000        000000
            0x3F, 0xFF, 0xFF, 0x80, 0x7E, ##    00000000000000000000000        000000
            0x3F, 0xFF, 0xFF, 0x80, 0x7E, ##    00000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0xFF, 0xFF, 0xFF, 0x80, 0x7E, ##  0000000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0x7F, 0xFF, 0xFF, 0x80, 0x7E, ##   000000000000000000000000        000000
            0x3F, 0xFF, 0xFF, 0x80, 0x7E, ##    00000000000000000000000        000000
            0x1F, 0xFF, 0xFF, 0x80, 0x7E, ##     0000000000000000000000        000000
            0x1F, 0xFF, 0xFF, 0x80, 0x7E, ##     0000000000000000000000        000000
            0x0F, 0xFF, 0xFF, 0x80, 0x7E, ##      000000000000000000000        000000
            0x07, 0xFF, 0xFF, 0x80, 0x7E, ##       00000000000000000000        000000
            0x03, 0xFF, 0xFF, 0x80, 0x7E, ##        0000000000000000000        000000
            0x00, 0xFF, 0xFF, 0x80, 0x7E, ##          00000000000000000        000000
            0x00, 0x7F, 0xFF, 0x80, 0x7E, ##           0000000000000000        000000
            0x00, 0x0F, 0xFF, 0x80, 0x7E, ##              0000000000000        000000
            0x00, 0x00, 0xFF, 0x80, 0x7E, ##                  000000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x1F, 0x80, 0x7E, ##                     000000        000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 11, 
        'xoffset'  => 21, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 17, 
        'xoffset'  => 17, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0xF8, 0x00, ##          00000    
            0x00, 0xFC, 0x00, ##          000000   
            0x00, 0x7C, 0x00, ##           00000   
            0x00, 0x7E, 0x00, ##           000000  
            0x00, 0x3F, 0x00, ##            000000 
            0x00, 0x3F, 0x00, ##            000000 
            0x00, 0x1F, 0x00, ##             00000 
            0x00, 0x1F, 0x80, ##             000000
            0x00, 0x1F, 0x80, ##             000000
            0x00, 0x1F, 0x80, ##             000000
            0x00, 0x3F, 0x80, ##            0000000
            0xC0, 0x7F, 0x80, ##  00       00000000
            0xFF, 0xFF, 0x00, ##  0000000000000000 
            0xFF, 0xFF, 0x00, ##  0000000000000000 
            0xFF, 0xFE, 0x00, ##  000000000000000  
            0xFF, 0xFC, 0x00, ##  00000000000000   
            0x3F, 0xE0, 0x00, ##    000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 25, 
        'xoffset'  => 15, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x0F, 0xFF, 0x00, 0x00, ##      000000000000         
            0xFF, 0xFF, 0x00, 0x00, ##  0000000000000000         
            0xFF, 0xFF, 0x00, 0x00, ##  0000000000000000         
            0xFF, 0xFF, 0x00, 0x00, ##  0000000000000000         
            0xFF, 0xFF, 0x00, 0x00, ##  0000000000000000         
            0xF0, 0x3F, 0x00, 0x00, ##  0000      000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x00, 0x3F, 0x00, 0x00, ##            000000         
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000
            0x7F, 0xFF, 0xFF, 0x80, ##   000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 32, 
        'xoffset'  => 10, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x7F, 0x80, 0x01, 0xFE, ##   00000000              00000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0xFF, 0x00, 0x00, 0xFE, ##  00000000                0000000 
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0x7F, ##  0000000                  0000000
            0xFE, 0x00, 0x00, 0xFF, ##  0000000                 00000000
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x00, 0x00, 0xFE, ##   0000000                0000000 
            0x7F, 0x80, 0x01, 0xFE, ##   00000000              00000000 
            0x3F, 0x80, 0x01, 0xFC, ##    0000000              0000000  
            0x3F, 0xC0, 0x03, 0xFC, ##    00000000            00000000  
            0x1F, 0xE0, 0x07, 0xF8, ##     00000000          00000000   
            0x0F, 0xF8, 0x1F, 0xF0, ##      000000000      000000000    
            0x07, 0xFF, 0xFF, 0xE0, ##       0000000000000000000000     
            0x03, 0xFF, 0xFF, 0xC0, ##        00000000000000000000      
            0x01, 0xFF, 0xFF, 0x80, ##         000000000000000000       
            0x00, 0x7F, 0xFE, 0x00, ##           00000000000000         
            0x00, 0x0F, 0xF0, 0x00, ##              00000000            
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x00, 0x00, 0x00, 0x00, ##                                  
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000  
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000  
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000  
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000  
            0x7F, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x80, 0x00, 0x10, 0x00, 0x00, ##  0                  0                   
            0xC0, 0x00, 0x18, 0x00, 0x00, ##  00                 00                  
            0xE0, 0x00, 0x1C, 0x00, 0x00, ##  000                000                 
            0xF0, 0x00, 0x1F, 0x00, 0x00, ##  0000               00000               
            0xF8, 0x00, 0x1F, 0x80, 0x00, ##  00000              000000              
            0xFC, 0x00, 0x1F, 0xC0, 0x00, ##  000000             0000000             
            0xFF, 0x00, 0x1F, 0xE0, 0x00, ##  00000000           00000000            
            0xFF, 0x80, 0x1F, 0xF0, 0x00, ##  000000000          000000000           
            0x7F, 0xC0, 0x0F, 0xF8, 0x00, ##   000000000          000000000          
            0x3F, 0xE0, 0x07, 0xFC, 0x00, ##    000000000          000000000         
            0x1F, 0xF0, 0x03, 0xFE, 0x00, ##     000000000          000000000        
            0x0F, 0xF8, 0x01, 0xFF, 0x00, ##      000000000          000000000       
            0x07, 0xFC, 0x00, 0xFF, 0x80, ##       000000000          000000000      
            0x03, 0xFE, 0x00, 0x3F, 0xE0, ##        000000000           000000000    
            0x01, 0xFF, 0x80, 0x1F, 0xF0, ##         0000000000          000000000   
            0x00, 0x7F, 0xC0, 0x0F, 0xF8, ##           000000000          000000000  
            0x00, 0x3F, 0xE0, 0x07, 0xFC, ##            000000000          000000000 
            0x00, 0x1F, 0xF0, 0x03, 0xFE, ##             000000000          000000000
            0x00, 0x0F, 0xF0, 0x01, 0xFE, ##              00000000           00000000
            0x00, 0x07, 0xF0, 0x00, 0xFE, ##               0000000            0000000
            0x00, 0x0F, 0xF0, 0x01, 0xFE, ##              00000000           00000000
            0x00, 0x3F, 0xF0, 0x03, 0xFE, ##            0000000000          000000000
            0x00, 0x7F, 0xC0, 0x07, 0xFC, ##           000000000           000000000 
            0x00, 0xFF, 0x80, 0x1F, 0xF0, ##          000000000          000000000   
            0x01, 0xFF, 0x00, 0x3F, 0xE0, ##         000000000          000000000    
            0x03, 0xFE, 0x00, 0x7F, 0xC0, ##        000000000          000000000     
            0x07, 0xFC, 0x00, 0xFF, 0x80, ##       000000000          000000000      
            0x0F, 0xF8, 0x01, 0xFF, 0x00, ##      000000000          000000000       
            0x1F, 0xF0, 0x03, 0xFE, 0x00, ##     000000000          000000000        
            0x7F, 0xE0, 0x07, 0xFC, 0x00, ##   0000000000          000000000         
            0xFF, 0x80, 0x0F, 0xF8, 0x00, ##  000000000           000000000          
            0xFF, 0x00, 0x1F, 0xF0, 0x00, ##  00000000           000000000           
            0xFE, 0x00, 0x1F, 0xE0, 0x00, ##  0000000            00000000            
            0xFC, 0x00, 0x1F, 0x80, 0x00, ##  000000             000000              
            0xF8, 0x00, 0x1F, 0x00, 0x00, ##  00000              00000               
            0xF0, 0x00, 0x1E, 0x00, 0x00, ##  0000               0000                
            0xE0, 0x00, 0x1C, 0x00, 0x00, ##  000                000                 
            0xC0, 0x00, 0x18, 0x00, 0x00, ##  00                 00                  
            0x80, 0x00, 0x10, 0x00, 0x00, ##  0                  0                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 47, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##         000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1E, 0x07, 0xE0, 0x00, 0x00, 0x00, ##     0000      000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000000000000000                    
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000000000000000                    
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x0C, ##      00000000000000000000000                 00 
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0xFC, ##      00000000000000000000000             000000 
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##                                      0000000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, ##                                  000000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFE, ##                              0000000000000000000
            0x00, 0x00, 0x00, 0xFF, 0xFF, 0xE0, ##                          0000000000000000000    
            0x00, 0x00, 0x1F, 0xFF, 0xFE, 0x00, ##                     00000000000000000000        
            0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, ##                 00000000000000000000            
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##             00000000000000000000                
            0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##         00000000000000000000                    
            0x1F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##     0000000000000000000                         
            0x7F, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##   00000000000000000                             
            0x7F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##   0000000000000                                 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0x80, ##   000000000                        0000000      
            0x7C, 0x00, 0x00, 0x00, 0x7F, 0x80, ##   00000                           00000000      
            0x40, 0x00, 0x00, 0x00, 0xFF, 0x80, ##   0                              000000000      
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000      
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x80, ##                                 0000000000      
            0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, ##                                00000000000      
            0x00, 0x00, 0x00, 0x03, 0xDF, 0x80, ##                                0000 000000      
            0x00, 0x00, 0x00, 0x07, 0xDF, 0x80, ##                               00000 000000      
            0x00, 0x00, 0x00, 0x0F, 0x9F, 0x80, ##                              00000  000000      
            0x00, 0x00, 0x00, 0x0F, 0x1F, 0x80, ##                              0000   000000      
            0x00, 0x00, 0x00, 0x1F, 0x1F, 0x80, ##                             00000   000000      
            0x00, 0x00, 0x00, 0x3E, 0x1F, 0x80, ##                            00000    000000      
            0x00, 0x00, 0x00, 0x3C, 0x1F, 0x80, ##                            0000     000000      
            0x00, 0x00, 0x00, 0x7C, 0x1F, 0x80, ##                           00000     000000      
            0x00, 0x00, 0x00, 0xF8, 0x1F, 0x80, ##                          00000      000000      
            0x00, 0x00, 0x00, 0xF0, 0x1F, 0x80, ##                          0000       000000      
            0x00, 0x00, 0x01, 0xF0, 0x1F, 0x80, ##                         00000       000000      
            0x00, 0x00, 0x03, 0xE0, 0x1F, 0x80, ##                        00000        000000      
            0x00, 0x00, 0x03, 0xC0, 0x1F, 0x80, ##                        0000         000000      
            0x00, 0x00, 0x07, 0xC0, 0x1F, 0x80, ##                       00000         000000      
            0x00, 0x00, 0x0F, 0x80, 0x1F, 0x80, ##                      00000          000000      
            0x00, 0x00, 0x0F, 0x00, 0x1F, 0x80, ##                      0000           000000      
            0x00, 0x00, 0x1F, 0x00, 0x1F, 0x80, ##                     00000           000000      
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##                     000000000000000000000000000 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##                     000000000000000000000000000 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##                     000000000000000000000000000 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##                     000000000000000000000000000 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##                     000000000000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 47, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##         000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##     0000000000000000                            
            0x1E, 0x07, 0xE0, 0x00, 0x00, 0x00, ##     0000      000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                            
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000000000000000                    
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000000000000000                    
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x04, ##      00000000000000000000000                  0 
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x7C, ##      00000000000000000000000              00000 
            0x00, 0x00, 0x00, 0x00, 0x07, 0xFC, ##                                       000000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xFE, ##                                   00000000000000
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, ##                               000000000000000000
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0, ##                           0000000000000000000   
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x00, ##                       0000000000000000000       
            0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, ##                   0000000000000000000           
            0x00, 0x07, 0xFF, 0xFF, 0x00, 0x00, ##               0000000000000000000               
            0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, ##           0000000000000000000                   
            0x07, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##       0000000000000000000                       
            0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##   0000000000000000000                           
            0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, ##   000000000000000                               
            0x7F, 0xF0, 0x00, 0x0F, 0xF8, 0x00, ##   00000000000                000000000          
            0x7F, 0x00, 0x00, 0xFF, 0xFF, 0x00, ##   0000000                0000000000000000       
            0x70, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##   000                  00000000000000000000     
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xE0, ##                        000000000000000000000    
            0x00, 0x00, 0x03, 0xF0, 0x0F, 0xF0, ##                        000000        00000000   
            0x00, 0x00, 0x03, 0xC0, 0x03, 0xF8, ##                        0000            0000000  
            0x00, 0x00, 0x02, 0x00, 0x01, 0xF8, ##                        0                000000  
            0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                         0000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, ##                                          000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, ##                                          000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, ##                                          000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, ##                                          000000 
            0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                         0000000 
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, ##                                         000000  
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, ##                                        0000000  
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, ##                                        000000   
            0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, ##                                       000000    
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, ##                                      000000     
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, ##                                     000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000       
            0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, ##                                   000000        
            0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                                  000000         
            0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, ##                                 000000          
            0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                                000000           
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##                               000000            
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##                              000000             
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##                             000000              
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##                            000000               
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                           000000                
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##                          000000                 
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000                  
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                        000000000000000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                        000000000000000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                        000000000000000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                        000000000000000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                        000000000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 46, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##          00000000000                           
            0x0F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##      000000000000000000                        
            0x0F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##      0000000000000000000                       
            0x0F, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##      000000000000000000000                     
            0x0F, 0x80, 0x7F, 0x80, 0x00, 0x00, ##      00000        00000000                     
            0x0C, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##      00             0000000                    
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                    
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                    
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                     
            0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##            00000000000000                      
            0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##            000000000000                        
            0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##            00000000000                         
            0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##            00000000000000                      
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                   00000000                     
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                    
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                   
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000                  
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000                   
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000                   
            0x18, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##     00              00000000                   
            0x1F, 0x80, 0x7F, 0xC0, 0x00, 0x00, ##     000000        000000000                    
            0x1F, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##     0000000000000000000000                     
            0x1F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##     000000000000000000000                      
            0x1F, 0xFF, 0xFC, 0x00, 0x00, 0x78, ##     0000000000000000000                   0000 
            0x01, 0xFF, 0xC0, 0x00, 0x07, 0xF8, ##         00000000000                   00000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xFC, ##                                   0000000000000
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFC, ##                              000000000000000000
            0x00, 0x00, 0x00, 0xFF, 0xFF, 0xE0, ##                          0000000000000000000   
            0x00, 0x00, 0x0F, 0xFF, 0xFE, 0x00, ##                      0000000000000000000       
            0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, ##                  0000000000000000000           
            0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##              0000000000000000000               
            0x00, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##          0000000000000000000                   
            0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##     00000000000000000000                       
            0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  0000000000000000000                           
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                               
            0xFF, 0xE0, 0x00, 0x00, 0x7F, 0x00, ##  00000000000                      0000000      
            0x7E, 0x00, 0x00, 0x00, 0xFF, 0x00, ##   000000                         00000000      
            0x60, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   00                            000000000      
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000      
            0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, ##                                0000000000      
            0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, ##                               00000000000      
            0x00, 0x00, 0x00, 0x07, 0xBF, 0x00, ##                               0000 000000      
            0x00, 0x00, 0x00, 0x0F, 0xBF, 0x00, ##                              00000 000000      
            0x00, 0x00, 0x00, 0x1F, 0x3F, 0x00, ##                             00000  000000      
            0x00, 0x00, 0x00, 0x1E, 0x3F, 0x00, ##                             0000   000000      
            0x00, 0x00, 0x00, 0x3E, 0x3F, 0x00, ##                            00000   000000      
            0x00, 0x00, 0x00, 0x7C, 0x3F, 0x00, ##                           00000    000000      
            0x00, 0x00, 0x00, 0x7C, 0x3F, 0x00, ##                           00000    000000      
            0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, ##                          00000     000000      
            0x00, 0x00, 0x01, 0xF0, 0x3F, 0x00, ##                         00000      000000      
            0x00, 0x00, 0x01, 0xF0, 0x3F, 0x00, ##                         00000      000000      
            0x00, 0x00, 0x03, 0xE0, 0x3F, 0x00, ##                        00000       000000      
            0x00, 0x00, 0x07, 0xC0, 0x3F, 0x00, ##                       00000        000000      
            0x00, 0x00, 0x07, 0xC0, 0x3F, 0x00, ##                       00000        000000      
            0x00, 0x00, 0x0F, 0x80, 0x3F, 0x00, ##                      00000         000000      
            0x00, 0x00, 0x1F, 0x00, 0x3F, 0x00, ##                     00000          000000      
            0x00, 0x00, 0x1F, 0x00, 0x3F, 0x00, ##                     00000          000000      
            0x00, 0x00, 0x3E, 0x00, 0x3F, 0x00, ##                    00000           000000      
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##                    000000000000000000000000000 
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##                    000000000000000000000000000 
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##                    000000000000000000000000000 
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##                    000000000000000000000000000 
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF8, ##                    000000000000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##                                    000000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 34, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000           
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000            
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000             
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000              
            0x00, 0x3F, 0xF0, 0x00, 0x00, ##            0000000000              
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000               
            0x00, 0xFF, 0xC0, 0x00, 0x00, ##          0000000000                
            0x01, 0xFF, 0x80, 0x00, 0x00, ##         0000000000                 
            0x03, 0xFF, 0x00, 0x00, 0x00, ##        0000000000                  
            0x07, 0xFE, 0x00, 0x00, 0x00, ##       0000000000                   
            0x0F, 0xFC, 0x00, 0x00, 0x00, ##      0000000000                    
            0x1F, 0xF8, 0x00, 0x00, 0x00, ##     0000000000                     
            0x3F, 0xF0, 0x00, 0x00, 0x00, ##    0000000000                      
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                       
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                        
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                        
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                         
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                          
            0xFF, 0x80, 0x00, 0x00, 0x40, ##  000000000                        0
            0x7F, 0x80, 0x00, 0x00, 0xC0, ##   00000000                       00
            0x7F, 0xC0, 0x00, 0x03, 0xC0, ##   000000000                    0000
            0x7F, 0xE0, 0x00, 0x0F, 0xC0, ##   0000000000                 000000
            0x3F, 0xF0, 0x00, 0x3F, 0xC0, ##    0000000000              00000000
            0x3F, 0xFE, 0x03, 0xFF, 0xC0, ##    0000000000000       000000000000
            0x1F, 0xFF, 0xFF, 0xFF, 0xC0, ##     0000000000000000000000000000000
            0x0F, 0xFF, 0xFF, 0xFF, 0xC0, ##      000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0x80, ##       0000000000000000000000000000 
            0x01, 0xFF, 0xFF, 0xFC, 0x00, ##         00000000000000000000000    
            0x00, 0x7F, 0xFF, 0xF0, 0x00, ##           0000000000000000000      
            0x00, 0x0F, 0xFE, 0x00, 0x00, ##              00000000000           
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '192' => {    # 'À'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                00000000                           
            0x00, 0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                 00000000                          
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                  0000000                          
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, ##                   0000000                         
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, ##                   00000000                        
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, ##                    0000000                        
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##                     0000000                       
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##                      0000000                      
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                        000000                     
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##                        0000000                    
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, ##                         0000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                 0000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##              000000000       00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, ##              00000000        00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF8, 0x00, 0x00, ##              00000000        000000000            
            0x00, 0x1F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##             000000000         00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xFC, 0x00, 0x00, ##             00000000          000000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##            000000000           00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, 0x00, ##            00000000            00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFE, 0x00, 0x00, ##            00000000            000000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0x80, 0x01, 0xFF, 0x00, 0x00, ##           00000000              000000000         
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x00, ##          000000000              000000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x00, 0x00, ##          000000000               00000000         
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##      000000000                      000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##      000000000                       00000000     
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     00000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##    000000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##    000000000                           00000000   
            0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    00000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   000000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##   000000000                             00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '193' => {    # 'Á'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                             0000000               
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                            00000000               
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                           00000000                
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                          00000000                 
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                  
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, ##                         0000000                   
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##                        0000000                    
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##                       00000000                    
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##                      0000000                      
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##                     0000000                       
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, ##                     000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                 0000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##              000000000       00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, ##              00000000        00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF8, 0x00, 0x00, ##              00000000        000000000            
            0x00, 0x1F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##             000000000         00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xFC, 0x00, 0x00, ##             00000000          000000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##            000000000           00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, 0x00, ##            00000000            00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFE, 0x00, 0x00, ##            00000000            000000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0x80, 0x01, 0xFF, 0x00, 0x00, ##           00000000              000000000         
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x00, ##          000000000              000000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x00, 0x00, ##          000000000               00000000         
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##      000000000                      000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##      000000000                       00000000     
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     00000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##    000000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##    000000000                           00000000   
            0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    00000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   000000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##   000000000                             00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '194' => {    # 'Â'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                      00000000                     
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##                     0000000000                    
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, 0x00, ##                  0000000  0000000                 
            0x00, 0x01, 0xFC, 0x3F, 0x80, 0x00, 0x00, ##                 0000000    0000000                
            0x00, 0x01, 0xF8, 0x1F, 0xC0, 0x00, 0x00, ##                 000000      0000000               
            0x00, 0x03, 0xF0, 0x0F, 0xC0, 0x00, 0x00, ##                000000        000000               
            0x00, 0x07, 0xE0, 0x07, 0xE0, 0x00, 0x00, ##               000000          000000              
            0x00, 0x0F, 0xE0, 0x03, 0xF0, 0x00, 0x00, ##              0000000           000000             
            0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x00, ##              000000             000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                    000000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                   00000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                  0000000000000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x7F, 0x80, 0x00, 0x00, ##                 00000000  00000000                
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                 0000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x3F, 0xC0, 0x00, 0x00, ##                00000000    00000000               
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##               00000000      00000000              
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##              000000000       00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF0, 0x00, 0x00, ##              00000000        00000000             
            0x00, 0x0F, 0xF0, 0x0F, 0xF8, 0x00, 0x00, ##              00000000        000000000            
            0x00, 0x1F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##             000000000         00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xF8, 0x00, 0x00, ##             00000000          00000000            
            0x00, 0x1F, 0xE0, 0x07, 0xFC, 0x00, 0x00, ##             00000000          000000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##            000000000           00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFC, 0x00, 0x00, ##            00000000            00000000           
            0x00, 0x3F, 0xC0, 0x03, 0xFE, 0x00, 0x00, ##            00000000            000000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##           000000000             00000000          
            0x00, 0x7F, 0x80, 0x01, 0xFF, 0x00, 0x00, ##           00000000              000000000         
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0x00, 0x00, ##          000000000              000000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x00, 0x00, ##          000000000               00000000         
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          00000000                000000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##         000000000                 00000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##        000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##       00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##      000000000                      000000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##      000000000                       00000000     
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      00000000                        000000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     000000000                         00000000    
            0x1F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     00000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##    000000000                          000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##    000000000                           00000000   
            0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    00000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##   000000000                            000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##   000000000                             00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000000                              000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '195' => {    # 'Ã'
        'width'    => 50, 
        'xoffset'  => 1, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFC, 0x00, 0x3E, 0x00, 0x00, ##                  000000            00000           
            0x00, 0x03, 0xFF, 0x80, 0x3E, 0x00, 0x00, ##                00000000000         00000           
            0x00, 0x07, 0xFF, 0xE0, 0x7E, 0x00, 0x00, ##               00000000000000      000000           
            0x00, 0x0F, 0xFF, 0xF8, 0xFE, 0x00, 0x00, ##              00000000000000000   0000000           
            0x00, 0x0F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##              00000000000000000000000000            
            0x00, 0x1F, 0xC7, 0xFF, 0xFC, 0x00, 0x00, ##             0000000   00000000000000000            
            0x00, 0x1F, 0x81, 0xFF, 0xF8, 0x00, 0x00, ##             000000      00000000000000             
            0x00, 0x1F, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##             00000         00000000000              
            0x00, 0x1F, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##             00000            000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                    
            0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, ##                     000000000000                   
            0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, ##                     000000000000                   
            0x00, 0x00, 0x1F, 0xFE, 0x00, 0x00, 0x00, ##                     000000000000                   
            0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##                    00000000000000                  
            0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##                    00000000000000                  
            0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##                    00000000000000                  
            0x00, 0x00, 0x3F, 0xFF, 0x00, 0x00, 0x00, ##                    00000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, ##                   0000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, ##                   0000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, ##                   0000000000000000                 
            0x00, 0x00, 0xFF, 0x3F, 0xC0, 0x00, 0x00, ##                  00000000  00000000                
            0x00, 0x00, 0xFF, 0x3F, 0xC0, 0x00, 0x00, ##                  00000000  00000000                
            0x00, 0x00, 0xFF, 0x3F, 0xC0, 0x00, 0x00, ##                  00000000  00000000                
            0x00, 0x01, 0xFF, 0x3F, 0xE0, 0x00, 0x00, ##                 000000000  000000000               
            0x00, 0x01, 0xFE, 0x1F, 0xE0, 0x00, 0x00, ##                 00000000    00000000               
            0x00, 0x01, 0xFE, 0x1F, 0xE0, 0x00, 0x00, ##                 00000000    00000000               
            0x00, 0x01, 0xFE, 0x1F, 0xE0, 0x00, 0x00, ##                 00000000    00000000               
            0x00, 0x03, 0xFC, 0x0F, 0xF0, 0x00, 0x00, ##                00000000      00000000              
            0x00, 0x03, 0xFC, 0x0F, 0xF0, 0x00, 0x00, ##                00000000      00000000              
            0x00, 0x03, 0xFC, 0x0F, 0xF0, 0x00, 0x00, ##                00000000      00000000              
            0x00, 0x07, 0xFC, 0x0F, 0xF8, 0x00, 0x00, ##               000000000      000000000             
            0x00, 0x07, 0xF8, 0x07, 0xF8, 0x00, 0x00, ##               00000000        00000000             
            0x00, 0x07, 0xF8, 0x07, 0xF8, 0x00, 0x00, ##               00000000        00000000             
            0x00, 0x0F, 0xF8, 0x07, 0xFC, 0x00, 0x00, ##              000000000        000000000            
            0x00, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x00, ##              00000000          00000000            
            0x00, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x00, ##              00000000          00000000            
            0x00, 0x0F, 0xF0, 0x03, 0xFC, 0x00, 0x00, ##              00000000          00000000            
            0x00, 0x1F, 0xF0, 0x03, 0xFE, 0x00, 0x00, ##             000000000          000000000           
            0x00, 0x1F, 0xE0, 0x01, 0xFE, 0x00, 0x00, ##             00000000            00000000           
            0x00, 0x1F, 0xE0, 0x01, 0xFE, 0x00, 0x00, ##             00000000            00000000           
            0x00, 0x3F, 0xE0, 0x01, 0xFF, 0x00, 0x00, ##            000000000            000000000          
            0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x00, 0x00, ##            00000000              00000000          
            0x00, 0x3F, 0xC0, 0x00, 0xFF, 0x00, 0x00, ##            00000000              00000000          
            0x00, 0x7F, 0xC0, 0x00, 0xFF, 0x80, 0x00, ##           000000000              000000000         
            0x00, 0x7F, 0xC0, 0x00, 0xFF, 0x80, 0x00, ##           000000000              000000000         
            0x00, 0x7F, 0x80, 0x00, 0x7F, 0x80, 0x00, ##           00000000                00000000         
            0x00, 0x7F, 0x80, 0x00, 0x7F, 0xC0, 0x00, ##           00000000                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                000000000        
            0x00, 0xFF, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##          00000000                  00000000        
            0x00, 0xFF, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##          00000000                  00000000        
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         000000000                  000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         000000000000000000000000000000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         000000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        00000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        00000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##        00000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##       0000000000000000000000000000000000000000     
            0x07, 0xFC, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##       000000000                      000000000     
            0x07, 0xF8, 0x00, 0x00, 0x07, 0xF8, 0x00, ##       00000000                        00000000     
            0x07, 0xF8, 0x00, 0x00, 0x07, 0xF8, 0x00, ##       00000000                        00000000     
            0x0F, 0xF8, 0x00, 0x00, 0x07, 0xFC, 0x00, ##      000000000                        000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##      00000000                         000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##      00000000                          00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##     000000000                          000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##     000000000                          000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##     00000000                            00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    000000000                            000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    000000000                            000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    000000000                            000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0x00, ##    00000000                              00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0x80, ##   000000000                              000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0x80, ##   000000000                              000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0xFF, 0x80, ##   000000000                              000000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '196' => {    # 'Ä'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x01, 0xFF, 0x7F, 0xC0, 0x00, 0x00, ##                 000000000 000000000               
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x03, 0xFE, 0x3F, 0xE0, 0x00, 0x00, ##                000000000   000000000              
            0x00, 0x03, 0xFC, 0x3F, 0xE0, 0x00, 0x00, ##                00000000    000000000              
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x07, 0xFC, 0x1F, 0xF0, 0x00, 0x00, ##               000000000     000000000             
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF8, 0x0F, 0xF8, 0x00, 0x00, ##              000000000       000000000            
            0x00, 0x0F, 0xF8, 0x0F, 0xF8, 0x00, 0x00, ##              000000000       000000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x1F, 0xF0, 0x07, 0xFC, 0x00, 0x00, ##             000000000         000000000           
            0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##             00000000           00000000           
            0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##             00000000           00000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFE, 0x00, 0x00, ##            000000000           000000000          
            0x00, 0x3F, 0xE0, 0x03, 0xFE, 0x00, 0x00, ##            000000000           000000000          
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##            00000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFF, 0x00, 0x00, ##           000000000             000000000         
            0x00, 0x7F, 0xC0, 0x01, 0xFF, 0x00, 0x00, ##           000000000             000000000         
            0x00, 0x7F, 0x80, 0x00, 0xFF, 0x00, 0x00, ##           00000000               00000000         
            0x00, 0x7F, 0x80, 0x00, 0xFF, 0x00, 0x00, ##           00000000               00000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x80, 0x00, ##          000000000               000000000        
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x80, 0x00, ##          000000000               000000000        
            0x00, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##          00000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         000000000                 000000000       
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         000000000                 000000000       
            0x01, 0xFE, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##         00000000                   00000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x07, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##       00000000                       00000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      000000000                       000000000    
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      000000000                       000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##      00000000                         00000000    
            0x0F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##      00000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     000000000                         000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     000000000                         000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##     00000000                           00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x00, ##   00000000                               00000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '197' => {    # 'Å'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                  00000000000000000                
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                 0000000000000000000               
            0x00, 0x01, 0xFC, 0x1F, 0xC0, 0x00, 0x00, ##                 0000000     0000000               
            0x00, 0x03, 0xF0, 0x07, 0xE0, 0x00, 0x00, ##                000000         000000              
            0x00, 0x03, 0xE0, 0x03, 0xE0, 0x00, 0x00, ##                00000           00000              
            0x00, 0x07, 0xE0, 0x03, 0xF0, 0x00, 0x00, ##               000000           000000             
            0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               00000             00000             
            0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               00000             00000             
            0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               00000             00000             
            0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               00000             00000             
            0x00, 0x07, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               00000             00000             
            0x00, 0x07, 0xE0, 0x03, 0xF0, 0x00, 0x00, ##               000000           000000             
            0x00, 0x03, 0xE0, 0x03, 0xE0, 0x00, 0x00, ##                00000           00000              
            0x00, 0x03, 0xF0, 0x07, 0xE0, 0x00, 0x00, ##                000000         000000              
            0x00, 0x03, 0xFC, 0x1F, 0xC0, 0x00, 0x00, ##                00000000     0000000               
            0x00, 0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                 0000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                  00000000000000000                
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                   000000000000000                 
            0x00, 0x00, 0x7F, 0x7F, 0x00, 0x00, 0x00, ##                   0000000 0000000                 
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x00, 0xFF, 0x7F, 0x80, 0x00, 0x00, ##                  00000000 00000000                
            0x00, 0x00, 0xFE, 0x3F, 0x80, 0x00, 0x00, ##                  0000000   0000000                
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x01, 0xFE, 0x3F, 0xC0, 0x00, 0x00, ##                 00000000   00000000               
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x03, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                00000000     00000000              
            0x00, 0x03, 0xF8, 0x0F, 0xE0, 0x00, 0x00, ##                0000000       0000000              
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x07, 0xF8, 0x0F, 0xF0, 0x00, 0x00, ##               00000000       00000000             
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x0F, 0xF0, 0x07, 0xF8, 0x00, 0x00, ##              00000000         00000000            
            0x00, 0x1F, 0xF0, 0x07, 0xFC, 0x00, 0x00, ##             000000000         000000000           
            0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##             00000000           00000000           
            0x00, 0x1F, 0xE0, 0x03, 0xFC, 0x00, 0x00, ##             00000000           00000000           
            0x00, 0x3F, 0xE0, 0x03, 0xFE, 0x00, 0x00, ##            000000000           000000000          
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##            00000000             00000000          
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##            00000000             00000000          
            0x00, 0x3F, 0xC0, 0x01, 0xFE, 0x00, 0x00, ##            00000000             00000000          
            0x00, 0x7F, 0xC0, 0x01, 0xFF, 0x00, 0x00, ##           000000000             000000000         
            0x00, 0x7F, 0x80, 0x00, 0xFF, 0x00, 0x00, ##           00000000               00000000         
            0x00, 0x7F, 0x80, 0x00, 0xFF, 0x00, 0x00, ##           00000000               00000000         
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0x80, 0x00, ##          000000000               000000000        
            0x00, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##          00000000                 00000000        
            0x00, 0xFF, 0x00, 0x00, 0x7F, 0x80, 0x00, ##          00000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         000000000                 000000000       
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         000000000                 000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##         00000000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##        0000000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       000000000000000000000000000000000000000     
            0x07, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##       00000000                       00000000     
            0x07, 0xF8, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##       00000000                       00000000     
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      000000000                       000000000    
            0x0F, 0xF8, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##      000000000                       000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x07, 0xF8, 0x00, ##      00000000                         00000000    
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     000000000                         000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     000000000                         000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x03, 0xFC, 0x00, ##     00000000                           00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000000                           000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x01, 0xFE, 0x00, ##    00000000                             00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x01, 0xFF, 0x00, ##   000000000                             000000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x00, ##   00000000                               00000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000000                               000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '198' => {    # 'Æ'
        'width'    => 50, 
        'xoffset'  => 0, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, ##                   000000000000000000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, ##                   000000000000000000000000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xC0, ##                   000000000000000000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                  0000000000000000000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                  0000000000000000000000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                  0000000000000000000000000000000000
            0x00, 0x00, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                  000000     00000000               
            0x00, 0x01, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                 0000000     00000000               
            0x00, 0x01, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                 0000000     00000000               
            0x00, 0x01, 0xFC, 0x1F, 0xE0, 0x00, 0x00, ##                 0000000     00000000               
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##                0000000      00000000               
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##                0000000      00000000               
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##                0000000      00000000               
            0x00, 0x03, 0xF8, 0x1F, 0xE0, 0x00, 0x00, ##                0000000      00000000               
            0x00, 0x07, 0xF0, 0x1F, 0xE0, 0x00, 0x00, ##               0000000       00000000               
            0x00, 0x07, 0xF0, 0x1F, 0xE0, 0x00, 0x00, ##               0000000       00000000               
            0x00, 0x07, 0xF0, 0x1F, 0xE0, 0x00, 0x00, ##               0000000       00000000               
            0x00, 0x07, 0xF0, 0x1F, 0xE0, 0x00, 0x00, ##               0000000       00000000               
            0x00, 0x0F, 0xE0, 0x1F, 0xE0, 0x00, 0x00, ##              0000000        00000000               
            0x00, 0x0F, 0xE0, 0x1F, 0xE0, 0x00, 0x00, ##              0000000        00000000               
            0x00, 0x0F, 0xE0, 0x1F, 0xE0, 0x00, 0x00, ##              0000000        00000000               
            0x00, 0x1F, 0xE0, 0x1F, 0xE0, 0x00, 0x00, ##             00000000        00000000               
            0x00, 0x1F, 0xC0, 0x1F, 0xE0, 0x00, 0x00, ##             0000000         00000000               
            0x00, 0x1F, 0xC0, 0x1F, 0xE0, 0x00, 0x00, ##             0000000         00000000               
            0x00, 0x1F, 0xC0, 0x1F, 0xE0, 0x00, 0x00, ##             0000000         00000000               
            0x00, 0x3F, 0xC0, 0x1F, 0xFF, 0xFF, 0x00, ##            00000000         000000000000000000000  
            0x00, 0x3F, 0x80, 0x1F, 0xFF, 0xFF, 0x00, ##            0000000          000000000000000000000  
            0x00, 0x3F, 0x80, 0x1F, 0xFF, 0xFF, 0x00, ##            0000000          000000000000000000000  
            0x00, 0x7F, 0x80, 0x1F, 0xFF, 0xFF, 0x00, ##           00000000          000000000000000000000  
            0x00, 0x7F, 0x80, 0x1F, 0xFF, 0xFF, 0x00, ##           00000000          000000000000000000000  
            0x00, 0x7F, 0x00, 0x1F, 0xFF, 0xFF, 0x00, ##           0000000           000000000000000000000  
            0x00, 0x7F, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##           0000000           00000000               
            0x00, 0xFF, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##          00000000           00000000               
            0x00, 0xFF, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##          00000000           00000000               
            0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##          0000000            00000000               
            0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##          0000000            00000000               
            0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##         00000000            00000000               
            0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##         00000000            00000000               
            0x01, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##         00000000            00000000               
            0x03, 0xFC, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##        00000000             00000000               
            0x03, 0xFC, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##        00000000             00000000               
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##        00000000000000000000000000000               
            0x03, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##        00000000000000000000000000000               
            0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##       000000000000000000000000000000               
            0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##       000000000000000000000000000000               
            0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##       000000000000000000000000000000               
            0x0F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      0000000000000000000000000000000               
            0x0F, 0xF0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##      00000000               00000000               
            0x0F, 0xF0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##      00000000               00000000               
            0x0F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##      0000000                00000000               
            0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##     00000000                00000000               
            0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##     00000000                00000000               
            0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##     00000000                00000000               
            0x1F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##     0000000                 00000000               
            0x3F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##    00000000                 00000000               
            0x3F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##    00000000                 00000000               
            0x3F, 0xC0, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##    00000000                 00000000               
            0x7F, 0x80, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##   00000000                  00000000000000000000000
            0x7F, 0x80, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##   00000000                  00000000000000000000000
            0x7F, 0x80, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##   00000000                  00000000000000000000000
            0x7F, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##   0000000                   00000000000000000000000
            0xFF, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##  00000000                   00000000000000000000000
            0xFF, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, ##  00000000                   00000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '199' => {    # 'Ç'
        'width'    => 40, 
        'xoffset'  => 6, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000         
            0x00, 0x00, 0xFF, 0xFF, 0xF0, ##                  00000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                000000000000000000000000  
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, ##              0000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, ##             00000000000000000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0xFF, ##            000000000000000000000000000000
            0x00, 0x7F, 0xF8, 0x03, 0xFF, ##           000000000000         0000000000
            0x00, 0xFF, 0xE0, 0x00, 0x7F, ##          00000000000              0000000
            0x01, 0xFF, 0x80, 0x00, 0x1F, ##         0000000000                  00000
            0x03, 0xFF, 0x00, 0x00, 0x07, ##        0000000000                     000
            0x07, 0xFE, 0x00, 0x00, 0x03, ##       0000000000                       00
            0x07, 0xFC, 0x00, 0x00, 0x00, ##       000000000                          
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                               
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x3F, 0xE0, 0x00, 0x00, 0x00, ##    000000000                             
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                            
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                           
            0x07, 0xFC, 0x00, 0x00, 0x00, ##       000000000                          
            0x07, 0xFE, 0x00, 0x00, 0x03, ##       0000000000                       00
            0x03, 0xFF, 0x00, 0x00, 0x07, ##        0000000000                     000
            0x01, 0xFF, 0x80, 0x00, 0x1F, ##         0000000000                  00000
            0x00, 0xFF, 0xE0, 0x00, 0x7F, ##          00000000000              0000000
            0x00, 0xFF, 0xF8, 0x03, 0xFF, ##          0000000000000         0000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xFF, ##           0000000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, ##             00000000000000000000000000000
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, ##              0000000000000000000000000000
            0x00, 0x03, 0xFF, 0xFF, 0xFC, ##                000000000000000000000000  
            0x00, 0x00, 0xFF, 0xFF, 0xF0, ##                  00000000000000000000    
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000         
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000          
            0x00, 0x00, 0x00, 0x7C, 0x00, ##                           00000          
            0x00, 0x00, 0x00, 0x7E, 0x00, ##                           000000         
            0x00, 0x00, 0x00, 0x3F, 0x00, ##                            000000        
            0x00, 0x00, 0x00, 0x3F, 0x00, ##                            000000        
            0x00, 0x00, 0x00, 0x1F, 0x80, ##                             000000       
            0x00, 0x00, 0x00, 0x1F, 0x80, ##                             000000       
            0x00, 0x00, 0x00, 0x1F, 0x80, ##                             000000       
            0x00, 0x00, 0x00, 0x1F, 0x80, ##                             000000       
            0x00, 0x00, 0x00, 0x3F, 0x80, ##                            0000000       
            0x00, 0x01, 0xC0, 0x7F, 0x80, ##                 000       00000000       
            0x00, 0x01, 0xFF, 0xFF, 0x00, ##                 00000000000000000        
            0x00, 0x01, 0xFF, 0xFF, 0x00, ##                 00000000000000000        
            0x00, 0x01, 0xFF, 0xFE, 0x00, ##                 0000000000000000         
            0x00, 0x01, 0xFF, 0xFC, 0x00, ##                 000000000000000          
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '200' => {    # 'È'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                       
            0x00, 0x7F, 0x80, 0x00, 0x00, ##           00000000                      
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                     
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000                    
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                    
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000                   
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000                  
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000                 
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000                 
            0x00, 0x00, 0xFE, 0x00, 0x00, ##                  0000000                
            0x00, 0x00, 0x7F, 0x00, 0x00, ##                   0000000               
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '201' => {    # 'É'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xF0, 0x00, ##                      00000000           
            0x00, 0x00, 0x0F, 0xE0, 0x00, ##                      0000000            
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000            
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000             
            0x00, 0x00, 0x7F, 0x80, 0x00, ##                   00000000              
            0x00, 0x00, 0xFF, 0x00, 0x00, ##                  00000000               
            0x00, 0x00, 0xFE, 0x00, 0x00, ##                  0000000                
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000                 
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000                  
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000                   
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '202' => {    # 'Ê'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, ##                000000000                
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000               
            0x00, 0x0F, 0xFF, 0x00, 0x00, ##              000000000000               
            0x00, 0x1F, 0xFF, 0x80, 0x00, ##             00000000000000              
            0x00, 0x3F, 0x9F, 0xC0, 0x00, ##            0000000  0000000             
            0x00, 0x3F, 0x0F, 0xE0, 0x00, ##            000000    0000000            
            0x00, 0x7E, 0x07, 0xF0, 0x00, ##           000000      0000000           
            0x00, 0xFC, 0x03, 0xF8, 0x00, ##          000000        0000000          
            0x01, 0xF8, 0x01, 0xF8, 0x00, ##         000000          000000          
            0x03, 0xF8, 0x00, 0xFC, 0x00, ##        0000000           000000         
            0x03, 0xF0, 0x00, 0x7E, 0x00, ##        000000             000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '203' => {    # 'Ë'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x03, 0xFC, 0x01, 0xFE, 0x00, ##        00000000         00000000        
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  00000000000000000000000000000000000000 
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000000000000000000  
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '204' => {    # 'Ì'
        'width'    => 35, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x00, 0x00, 0x00, ##          00000000                   
            0x00, 0x7F, 0x80, 0x00, 0x00, ##           00000000                  
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                 
            0x00, 0x1F, 0xC0, 0x00, 0x00, ##             0000000                 
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000                
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000               
            0x00, 0x03, 0xF0, 0x00, 0x00, ##                000000               
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000              
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000             
            0x00, 0x00, 0xFE, 0x00, 0x00, ##                  0000000            
            0x00, 0x00, 0x7E, 0x00, 0x00, ##                   000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '205' => {    # 'Í'
        'width'    => 35, 
        'xoffset'  => 9, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0xE0, 0x00, ##                      0000000        
            0x00, 0x00, 0x1F, 0xE0, 0x00, ##                     00000000        
            0x00, 0x00, 0x3F, 0xC0, 0x00, ##                    00000000         
            0x00, 0x00, 0x3F, 0x80, 0x00, ##                    0000000          
            0x00, 0x00, 0x7F, 0x00, 0x00, ##                   0000000           
            0x00, 0x00, 0xFE, 0x00, 0x00, ##                  0000000            
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000             
            0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000             
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000               
            0x00, 0x07, 0xE0, 0x00, 0x00, ##               000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                     
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000000000000000000000000000000
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, #