/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.ibm;

import java.util.Vector;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;
import net.sf.antcontrib.cpptasks.gcc.GccLibrarian;

public final class XlcLinker
extends AbstractLdLinker {
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] discardFiles = new String[0];
    private static final XlcLinker instance = new XlcLinker("ld", objFiles, discardFiles, "", "");
    private static final XlcLinker dllLinker = new XlcLinker("ld", objFiles, discardFiles, "lib", ".so");

    private XlcLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix) {
        super(command, "-qversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, null);
    }

    public static XlcLinker getInstance() {
        return instance;
    }

    public void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (debug) {
            // empty if block
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-bdynamic");
            args.addElement("-G");
            args.addElement("-bnoentry");
            args.addElement("-bexpall");
            args.addElement("-lc_r");
        }
    }

    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return GccLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }
}

