#!/usr/bin/perl

package eBay::API::XML::DataType::SellerPaymentPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SellerPaymentPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SellerPaymentPreferencesType

=head1 DESCRIPTION

Defines the values that make up the seller's preferences.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SellerPaymentPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::Enum::DisplayPayNowButtonCodeType;
use eBay::API::XML::DataType::Enum::UPSRateOptionCodeType;


my @gaProperties = ( [ 'AlwaysUseThisPaymentAddress', 'xs:boolean', '', '', '' ]
	, [ 'DefaultPayPalEmailAddress', 'xs:string', '', '', '' ]
	, [ 'DisplayPayNowButton', 'ns:DisplayPayNowButtonCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisplayPayNowButtonCodeType', '' ]
	, [ 'PayPalAlwaysOn', 'xs:boolean', '', '', '' ]
	, [ 'PayPalPreferred', 'xs:boolean', '', '', '' ]
	, [ 'SellerPaymentAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'UPSRateOption', 'ns:UPSRateOptionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::UPSRateOptionCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlwaysUseThisPaymentAddress()

Indicates whether the seller wants all transactions
with eBay to use the address specified in SellerPaymentAddress.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setAlwaysUseThisPaymentAddress {
  my $self = shift;
  $self->{'AlwaysUseThisPaymentAddress'} = shift
}

=head2 isAlwaysUseThisPaymentAddress()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isAlwaysUseThisPaymentAddress {
  my $self = shift;
  return $self->{'AlwaysUseThisPaymentAddress'};
}


=head2 setDefaultPayPalEmailAddress()

Specifies the default email address the seller uses for receiving PayPal payments.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setDefaultPayPalEmailAddress {
  my $self = shift;
  $self->{'DefaultPayPalEmailAddress'} = shift
}

=head2 getDefaultPayPalEmailAddress()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getDefaultPayPalEmailAddress {
  my $self = shift;
  return $self->{'DefaultPayPalEmailAddress'};
}


=head2 setDisplayPayNowButton()

Determines whether the Pay Now button should always be displayed 
for the user's listings.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:DisplayPayNowButtonCodeType'

=cut

sub setDisplayPayNowButton {
  my $self = shift;
  $self->{'DisplayPayNowButton'} = shift
}

=head2 getDisplayPayNowButton()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:DisplayPayNowButtonCodeType'

=cut

sub getDisplayPayNowButton {
  my $self = shift;
  return $self->{'DisplayPayNowButton'};
}


=head2 setPayPalAlwaysOn()

Indicates whether PayPal is always accepted for the seller's listings.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setPayPalAlwaysOn {
  my $self = shift;
  $self->{'PayPalAlwaysOn'} = shift
}

=head2 isPayPalAlwaysOn()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isPayPalAlwaysOn {
  my $self = shift;
  return $self->{'PayPalAlwaysOn'};
}


=head2 setPayPalPreferred()

Specifies whether a seller wants to let buyers know that PayPal payments
are preferred.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setPayPalPreferred {
  my $self = shift;
  $self->{'PayPalPreferred'} = shift
}

=head2 isPayPalPreferred()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isPayPalPreferred {
  my $self = shift;
  return $self->{'PayPalPreferred'};
}


=head2 setSellerPaymentAddress()

Specifies the address the seller uses to receive payments from buyers.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:AddressType'

=cut

sub setSellerPaymentAddress {
  my $self = shift;
  $self->{'SellerPaymentAddress'} = shift
}

=head2 getSellerPaymentAddress()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:AddressType'

=cut

sub getSellerPaymentAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerPaymentAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setUPSRateOption()

Specifies the type of United Postal Service rates to use.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:UPSRateOptionCodeType'

=cut

sub setUPSRateOption {
  my $self = shift;
  $self->{'UPSRateOption'} = shift
}

=head2 getUPSRateOption()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:UPSRateOptionCodeType'

=cut

sub getUPSRateOption {
  my $self = shift;
  return $self->{'UPSRateOption'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
