#!/usr/bin/perl

package eBay::API::XML::Call::GetChallengeToken;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetChallengeToken.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetChallengeToken

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetChallengeToken inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetChallengeToken::GetChallengeTokenRequestType;
use eBay::API::XML::Call::GetChallengeToken::GetChallengeTokenResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetChallengeToken';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetChallengeToken::GetChallengeTokenRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetChallengeToken::GetChallengeTokenResponseType';
}

#
# input properties
#



#
# output properties
#

=head2 getAudioChallengeURL()

The URL of the audio clip your application should provide for sight-impaired users.
The audio clip corresponds to the image.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getAudioChallengeURL {
   my $self = shift;
   return $self->getResponseDataType()->getAudioChallengeURL();
}

=head2 getChallengeToken()

Botblock token that is used to validate that the user is a human and not a bot.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getChallengeToken {
   my $self = shift;
   return $self->getResponseDataType()->getChallengeToken();
}

=head2 getImageChallengeURL()

The URL of the image your application should display to
the user for a botblock challenge.

  Returned: Always
#    Returns: 'xs:string'

=cut
       
sub getImageChallengeURL {
   my $self = shift;
   return $self->getResponseDataType()->getImageChallengeURL();
}





1;   
