package Locales::DB::Territory::ff;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::ff::VERSION = '0.09';

$Locales::DB::Territory::ff::cldr_version = '2.0';

%Locales::DB::Territory::ff::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Anndoora',
    'ae'  => "Emiraat\ Araab\ Denntuɗe",
    'af'  => 'Afganistaan',
    'ag'  => "Antiguwaa\ e\ Barbudaa",
    'ai'  => 'Anngiyaa',
    'al'  => 'Albanii',
    'am'  => 'Armenii',
    'an'  => "Antiiye\ Nederlanndeeje",
    'ao'  => 'Anngolaa',
    'aq'  => 'Antarctica',
    'ar'  => 'Arjantiin',
    'as'  => "Samowa\ Amerik",
    'at'  => 'Otiriis',
    'au'  => 'Ostaraalii',
    'aw'  => 'Aruuba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Ajerbayjaan',
    'ba'  => "Bosnii\ Hersegowiin",
    'bb'  => 'Barbadoos',
    'bd'  => 'Banglaadees',
    'be'  => 'Beljik',
    'bf'  => "Burkibaa\ Faaso",
    'bg'  => 'Bulgarii',
    'bh'  => 'Bahreyn',
    'bi'  => 'Burunndi',
    'bj'  => 'Benee',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermudaa',
    'bn'  => 'Burnaay',
    'bo'  => 'Boliwii',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Beresiil',
    'bs'  => 'Bahamaas',
    'bt'  => 'Butaan',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswaana',
    'by'  => 'Belaruus',
    'bz'  => 'Beliise',
    'ca'  => 'Kanadaa',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Ndenndaandi\ Demokaraasiire\ Konngo",
    'cf'  => "Ndenndaandi\ Santarafrik",
    'cg'  => 'Konngo',
    'ch'  => 'Suwiis',
    'ci'  => 'Kodduwaar',
    'ck'  => "Duuɗe\ Kuuk",
    'cl'  => 'Cilii',
    'cm'  => 'Kameruun',
    'cn'  => 'Siin',
    'co'  => 'Kolombiya',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Kosta\ Rikaa",
    'cs'  => "Serbii\ e\ Montenegoroo",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Kubaa',
    'cv'  => "Duuɗe\ Kap\ Weer",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Siipar',
    'cz'  => "Ndenndaandi\ Cek",
    'dd'  => "East\ Germany",
    'de'  => 'Almaañ',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Jibutii',
    'dk'  => 'Danmark',
    'dm'  => 'Dominika',
    'do'  => "Ndenndanndi\ Dominika",
    'dz'  => 'Alaseri',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ekuwatoor',
    'ee'  => 'Estoni',
    'eg'  => 'Ejipt',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eriteree',
    'es'  => 'Espaañ',
    'et'  => 'Ecoppi',
    'eu'  => "European\ Union",
    'fi'  => 'Fenland',
    'fj'  => 'Fijji',
    'fk'  => "Duuɗe\ Falkland",
    'fm'  => 'Mikoronesii',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Farayse',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gaboo',
    'gb'  => "Laamateeri\ Rentundi",
    'gd'  => 'Garnaad',
    'ge'  => 'Jeorgii',
    'gf'  => "Giyaan\ Farayse",
    'gg'  => 'Guernsey',
    'gh'  => 'Ganaa',
    'gi'  => 'Jibraltaar',
    'gl'  => 'Gorwendland',
    'gm'  => 'Gammbi',
    'gn'  => 'Gine',
    'gp'  => 'Gwaadalup',
    'gq'  => "Ginee\ Ekuwaatoriyaal",
    'gr'  => 'Gerees',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Gwaatemalaa',
    'gu'  => 'Guwam',
    'gw'  => "Gine\-Bisaawo",
    'gy'  => 'Giyaan',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Onnduraas',
    'hr'  => 'Korwasii',
    'ht'  => 'Haytii',
    'hu'  => 'Onngiri',
    'ic'  => "Canary\ Islands",
    'id'  => 'Enndonesii',
    'ie'  => 'Irlannda',
    'il'  => "Israa\'iila",
    'im'  => "Isle\ of\ Man",
    'in'  => 'Enndo',
    'io'  => "Keeriindi\ britaani\ to\ maayo\ enndo",
    'iq'  => 'Iraak',
    'ir'  => 'Iraan',
    'is'  => 'Islannda',
    'it'  => 'Itali',
    'je'  => 'Jersey',
    'jm'  => 'Jamayka',
    'jo'  => 'Jordani',
    'jp'  => 'Sapoo',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Keñaa',
    'kg'  => 'Kirgistaan',
    'kh'  => 'Kambodso',
    'ki'  => 'Kiribari',
    'km'  => 'Komoor',
    'kn'  => "Sent\ Kits\ e\ Newis",
    'kp'  => "Koree\ Rewo",
    'kr'  => "Koree\ Worgo",
    'kw'  => 'Kuweyti',
    'ky'  => "Duuɗe\ Kaymaa",
    'kz'  => 'Kasakstaan',
    'la'  => 'Lawoos',
    'lb'  => 'Libaa',
    'lc'  => "Sent\ Lusiyaa",
    'li'  => 'Lincenstayn',
    'lk'  => "Siri\ Lanka",
    'lr'  => 'Liberiyaa',
    'ls'  => 'Lesoto',
    'lt'  => 'Lituaanii',
    'lu'  => 'Liksembuur',
    'lv'  => 'Letonii',
    'ly'  => 'Libi',
    'ma'  => 'Maruk',
    'mc'  => 'Monaakoo',
    'md'  => 'Moldawii',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagaskaar',
    'mh'  => "Duuɗe\ Marsaal",
    'mi'  => "Midway\ Islands",
    'mk'  => 'Meceduwaan',
    'ml'  => 'Maali',
    'mm'  => 'Miyamaar',
    'mn'  => 'Monngolii',
    'mo'  => 'Macau',
    'mp'  => "Duuɗe\ Mariyaana\ Rewo",
    'mq'  => 'Martinik',
    'mr'  => 'Muritani',
    'ms'  => 'Monseraat',
    'mt'  => 'Malte',
    'mu'  => 'Moriis',
    'mv'  => 'Maldiiwe',
    'mw'  => 'Malaawi',
    'mx'  => 'Meksik',
    'my'  => 'Malesii',
    'mz'  => 'Mosammbik',
    'na'  => 'Namibii',
    'nc'  => "Nuwel\ Kaledonii",
    'ne'  => 'Nijeer',
    'nf'  => "Duuɗe\ Norfolk",
    'ng'  => 'Nijeriyaa',
    'ni'  => 'Nikaraguwaa',
    'nl'  => 'Nederlannda',
    'no'  => 'Norwees',
    'np'  => 'Nepaal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nawuru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niuwe',
    'nz'  => "Nuwel\ Selannda",
    'om'  => 'Omaan',
    'pa'  => 'Panamaa',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Polinesii\ Farayse",
    'pg'  => "Papuwaa\ Nuwel\ Gine",
    'ph'  => 'Filipiin',
    'pk'  => 'Pakistaan',
    'pl'  => 'Poloñ',
    'pm'  => "See\ Piyeer\ e\ Mikeloo",
    'pn'  => 'Pitkern',
    'pr'  => "Porto\ Rikoo",
    'ps'  => "Palestiin\ Sisjordani\ e\ Gaasaa",
    'pt'  => 'Purtugaal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palawu',
    'py'  => 'Paraguwaay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Kataar',
    'qo'  => "Outlying\ Oceania",
    're'  => 'Rewiñoo',
    'ro'  => 'Rumanii',
    'rs'  => 'Serbia',
    'ru'  => 'Riisii',
    'rw'  => 'Ruwanndaa',
    'sa'  => "Arabii\ Sawdit",
    'sb'  => "Duuɗe\ Solomon",
    'sc'  => 'Seysel',
    'sd'  => 'Sudaan',
    'se'  => 'Suweed',
    'sg'  => 'Sinngapuur',
    'sh'  => "Sent\ Helen",
    'si'  => 'Slowenii',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slowakii',
    'sl'  => "Seraa\ liyon",
    'sm'  => "See\ Maree",
    'sn'  => 'Senegaal',
    'so'  => 'Somalii',
    'sr'  => 'Surinaam',
    'st'  => "Sawo\ Tome\ e\ Perensipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salwador",
    'sy'  => 'Sirii',
    'sz'  => 'Swaasilannda',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Duuɗe\ Turke\ e\ Keikoos",
    'td'  => 'Caad',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togoo',
    'th'  => 'Taylannda',
    'tj'  => 'Tajikistaan',
    'tk'  => 'Tokelaaw',
    'tl'  => "Timoor\ Fuɗnaange",
    'tm'  => 'Turkmenistaan',
    'tn'  => 'Tunisii',
    'to'  => 'Tonngaa',
    'tr'  => 'Turkii',
    'tt'  => "Tirnidaad\ e\ Tobaago",
    'tv'  => 'Tuwaluu',
    'tw'  => 'Taywaan',
    'tz'  => 'Tansanii',
    'ua'  => 'Ukereen',
    'ug'  => 'Unganndaa',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => "Dowlaaji\ Dentuɗi\ Amerik",
    'uy'  => 'Uruguwaay',
    'uz'  => 'Usbekistaan',
    'va'  => "Dowla\ Waticaan",
    'vc'  => "See\ Weesaa\ e\ Garnadiin",
    'vd'  => "North\ Vietnam",
    've'  => 'Wenesuwelaa',
    'vg'  => "duuɗe\ kecce\ britanii",
    'vi'  => "Duuɗe\ Kecce\ Amerik",
    'vn'  => 'Wiyetnaam',
    'vu'  => 'Wanuwaatuu',
    'wf'  => "Walis\ e\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samowaa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayoot',
    'za'  => "Afrik\ bŋ\ Worgo",
    'zm'  => 'Sammbi',
    'zw'  => 'Simbaabuwe',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::ff::name_to_code = (
    'afganistaan'                               => 'af',
    'africa'                                    => '002',
    'afrikbŋworgo'                             => 'za',
    'ajerbayjaan'                               => 'az',
    'alaseri'                                   => 'dz',
    'albanii'                                   => 'al',
    'almaañ'                                   => 'de',
    'americas'                                  => '019',
    'anndoora'                                  => 'ad',
    'anngiyaa'                                  => 'ai',
    'anngolaa'                                  => 'ao',
    'antarctica'                                => 'aq',
    'antiguwaaebarbudaa'                        => 'ag',
    'antiiyenederlanndeeje'                     => 'an',
    'arabiisawdit'                              => 'sa',
    'arjantiin'                                 => 'ar',
    'armenii'                                   => 'am',
    'aruuba'                                    => 'aw',
    'ascensionisland'                           => 'ac',
    'asia'                                      => 142,
    'australiaandnewzealand'                    => '053',
    'bahamaas'                                  => 'bs',
    'bahreyn'                                   => 'bh',
    'banglaadees'                               => 'bd',
    'barbadoos'                                 => 'bb',
    'belaruus'                                  => 'by',
    'beliise'                                   => 'bz',
    'beljik'                                    => 'be',
    'benee'                                     => 'bj',
    'beresiil'                                  => 'br',
    'bermudaa'                                  => 'bm',
    'boliwii'                                   => 'bo',
    'bosniihersegowiin'                         => 'ba',
    'botswaana'                                 => 'bw',
    'bouvetisland'                              => 'bv',
    'britishantarcticterritory'                 => 'bq',
    'bulgarii'                                  => 'bg',
    'burkibaafaaso'                             => 'bf',
    'burnaay'                                   => 'bn',
    'burunndi'                                  => 'bi',
    'butaan'                                    => 'bt',
    'caad'                                      => 'td',
    'canaryislands'                             => 'ic',
    'cantonandenderburyislands'                 => 'ct',
    'caribbean'                                 => '029',
    'centralamerica'                            => '013',
    'centralasia'                               => 143,
    'ceutaandmelilla'                           => 'ea',
    'channelislands'                            => 830,
    'christmasisland'                           => 'cx',
    'cilii'                                     => 'cl',
    'clippertonisland'                          => 'cp',
    'cocoskeelingislands'                       => 'cc',
    'commonwealthofindependentstates'           => 172,
    'czechoslovakia'                            => 200,
    'danmark'                                   => 'dk',
    'diegogarcia'                               => 'dg',
    'dominika'                                  => 'dm',
    'dowlaajidentuɗiamerik'                    => 'us',
    'dowlawaticaan'                             => 'va',
    'dronningmaudland'                          => 'nq',
    'duuɗefalkland'                            => 'fk',
    'duuɗekapweer'                             => 'cv',
    'duuɗekaymaa'                              => 'ky',
    'duuɗekecceamerik'                         => 'vi',
    'duuɗekeccebritanii'                       => 'vg',
    'duuɗekuuk'                                => 'ck',
    'duuɗemariyaanarewo'                       => 'mp',
    'duuɗemarsaal'                             => 'mh',
    'duuɗenorfolk'                             => 'nf',
    'duuɗesolomon'                             => 'sb',
    'duuɗeturkeekeikoos'                       => 'tc',
    'easternafrica'                             => '014',
    'easternasia'                               => '030',
    'easterneurope'                             => 151,
    'eastgermany'                               => 'dd',
    'ecoppi'                                    => 'et',
    'ejipt'                                     => 'eg',
    'ekuwatoor'                                 => 'ec',
    'elsalwador'                                => 'sv',
    'emiraataraabdenntuɗe'                     => 'ae',
    'enndo'                                     => 'in',
    'enndonesii'                                => 'id',
    'eriteree'                                  => 'er',
    'espaañ'                                   => 'es',
    'estoni'                                    => 'ee',
    'europe'                                    => 150,
    'europeanunion'                             => 'eu',
    'farayse'                                   => 'fr',
    'faroeislands'                              => 'fo',
    'fenland'                                   => 'fi',
    'fijji'                                     => 'fj',
    'filipiin'                                  => 'ph',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'frenchsouthernterritories'                 => 'tf',
    'gaboo'                                     => 'ga',
    'gammbi'                                    => 'gm',
    'ganaa'                                     => 'gh',
    'garnaad'                                   => 'gd',
    'gerees'                                    => 'gr',
    'gine'                                      => 'gn',
    'ginebisaawo'                               => 'gw',
    'gineeekuwaatoriyaal'                       => 'gq',
    'giyaan'                                    => 'gy',
    'giyaanfarayse'                             => 'gf',
    'gorwendland'                               => 'gl',
    'guernsey'                                  => 'gg',
    'guwam'                                     => 'gu',
    'gwaadalup'                                 => 'gp',
    'gwaatemalaa'                               => 'gt',
    'haytii'                                    => 'ht',
    'heardislandandmcdonaldislands'             => 'hm',
    'hongkong'                                  => 'hk',
    'iraak'                                     => 'iq',
    'iraan'                                     => 'ir',
    'irlannda'                                  => 'ie',
    'islannda'                                  => 'is',
    'isleofman'                                 => 'im',
    'israaiila'                                 => 'il',
    'itali'                                     => 'it',
    'jamayka'                                   => 'jm',
    'jeorgii'                                   => 'ge',
    'jersey'                                    => 'je',
    'jibraltaar'                                => 'gi',
    'jibutii'                                   => 'dj',
    'johnstonisland'                            => 'jt',
    'jordani'                                   => 'jo',
    'kambodso'                                  => 'kh',
    'kameruun'                                  => 'cm',
    'kanadaa'                                   => 'ca',
    'kasakstaan'                                => 'kz',
    'kataar'                                    => 'qa',
    'keeriindibritaanitomaayoenndo'             => 'io',
    'keñaa'                                    => 'ke',
    'kirgistaan'                                => 'kg',
    'kiribari'                                  => 'ki',
    'kodduwaar'                                 => 'ci',
    'kolombiya'                                 => 'co',
    'komoor'                                    => 'km',
    'konngo'                                    => 'cg',
    'koreerewo'                                 => 'kp',
    'koreeworgo'                                => 'kr',
    'korwasii'                                  => 'hr',
    'kostarikaa'                                => 'cr',
    'kubaa'                                     => 'cu',
    'kuweyti'                                   => 'kw',
    'laamateerirentundi'                        => 'gb',
    'latinamerica'                              => 419,
    'lawoos'                                    => 'la',
    'lesoto'                                    => 'ls',
    'letonii'                                   => 'lv',
    'libaa'                                     => 'lb',
    'liberiyaa'                                 => 'lr',
    'libi'                                      => 'ly',
    'liksembuur'                                => 'lu',
    'lincenstayn'                               => 'li',
    'lituaanii'                                 => 'lt',
    'maali'                                     => 'ml',
    'macau'                                     => 'mo',
    'madagaskaar'                               => 'mg',
    'malaawi'                                   => 'mw',
    'maldiiwe'                                  => 'mv',
    'malesii'                                   => 'my',
    'malte'                                     => 'mt',
    'martinik'                                  => 'mq',
    'maruk'                                     => 'ma',
    'mayoot'                                    => 'yt',
    'meceduwaan'                                => 'mk',
    'meksik'                                    => 'mx',
    'melanesia'                                 => '054',
    'metropolitanfrance'                        => 'fx',
    'micronesianregion'                         => '057',
    'middleafrica'                              => '017',
    'midwayislands'                             => 'mi',
    'mikoronesii'                               => 'fm',
    'miyamaar'                                  => 'mm',
    'moldawii'                                  => 'md',
    'monaakoo'                                  => 'mc',
    'monngolii'                                 => 'mn',
    'monseraat'                                 => 'ms',
    'montenegro'                                => 'me',
    'moriis'                                    => 'mu',
    'mosammbik'                                 => 'mz',
    'muritani'                                  => 'mr',
    'namibii'                                   => 'na',
    'nawuru'                                    => 'nr',
    'ndenndaandicek'                            => 'cz',
    'ndenndaandidemokaraasiirekonngo'           => 'cd',
    'ndenndaandisantarafrik'                    => 'cf',
    'ndenndanndidominika'                       => 'do',
    'nederlannda'                               => 'nl',
    'nepaal'                                    => 'np',
    'neutralzone'                               => 'nt',
    'nijeer'                                    => 'ne',
    'nijeriyaa'                                 => 'ng',
    'nikaraguwaa'                               => 'ni',
    'niuwe'                                     => 'nu',
    'northamerica'                              => '003',
    'northernafrica'                            => '015',
    'northernamerica'                           => '021',
    'northerneurope'                            => 154,
    'northvietnam'                              => 'vd',
    'norwees'                                   => 'no',
    'nuwelkaledonii'                            => 'nc',
    'nuwelselannda'                             => 'nz',
    'oceania'                                   => '009',
    'omaan'                                     => 'om',
    'onnduraas'                                 => 'hn',
    'onngiri'                                   => 'hu',
    'ostaraalii'                                => 'au',
    'otiriis'                                   => 'at',
    'outlyingoceania'                           => 'qo',
    'pacificislandstrustterritory'              => 'pc',
    'pakistaan'                                 => 'pk',
    'palawu'                                    => 'pw',
    'palestiinsisjordaniegaasaa'                => 'ps',
    'panamaa'                                   => 'pa',
    'panamacanalzone'                           => 'pz',
    'papuwaanuwelgine'                          => 'pg',
    'paraguwaay'                                => 'py',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'pitkern'                                   => 'pn',
    'polinesiifarayse'                          => 'pf',
    'poloñ'                                    => 'pl',
    'polynesia'                                 => '061',
    'portorikoo'                                => 'pr',
    'purtugaal'                                 => 'pt',
    'rewiñoo'                                  => 're',
    'riisii'                                    => 'ru',
    'rumanii'                                   => 'ro',
    'ruwanndaa'                                 => 'rw',
    "saintbarth\Ã\©lemy"                      => 'bl',
    'saintmartin'                               => 'mf',
    'sammbi'                                    => 'zm',
    'samowaa'                                   => 'ws',
    'samowaamerik'                              => 'as',
    'sapoo'                                     => 'jp',
    'sawotomeeperensipe'                        => 'st',
    'seemaree'                                  => 'sm',
    'seepiyeeremikeloo'                         => 'pm',
    'seeweesaaegarnadiin'                       => 'vc',
    'senegaal'                                  => 'sn',
    'senthelen'                                 => 'sh',
    'sentkitsenewis'                            => 'kn',
    'sentlusiyaa'                               => 'lc',
    'seraaliyon'                                => 'sl',
    'serbia'                                    => 'rs',
    'serbiiemontenegoroo'                       => 'cs',
    'seysel'                                    => 'sc',
    'siin'                                      => 'cn',
    'siipar'                                    => 'cy',
    'simbaabuwe'                                => 'zw',
    'sinngapuur'                                => 'sg',
    'sirii'                                     => 'sy',
    'sirilanka'                                 => 'lk',
    'slowakii'                                  => 'sk',
    'slowenii'                                  => 'si',
    'somalii'                                   => 'so',
    'southamerica'                              => '005',
    'southcentralasia'                          => '062',
    'southeasternasia'                          => '035',
    'southernafrica'                            => '018',
    'southernasia'                              => '034',
    'southerneurope'                            => '039',
    'southgeorgiaandthesouthsandwichislands'    => 'gs',
    'sudaan'                                    => 'sd',
    'surinaam'                                  => 'sr',
    'suweed'                                    => 'se',
    'suwiis'                                    => 'ch',
    'svalbardandjanmayen'                       => 'sj',
    'swaasilannda'                              => 'sz',
    'tajikistaan'                               => 'tj',
    'tansanii'                                  => 'tz',
    'taylannda'                                 => 'th',
    'taywaan'                                   => 'tw',
    'timoorfuɗnaange'                          => 'tl',
    'tirnidaadetobaago'                         => 'tt',
    'togoo'                                     => 'tg',
    'tokelaaw'                                  => 'tk',
    'tonngaa'                                   => 'to',
    'tristandacunha'                            => 'ta',
    'tunisii'                                   => 'tn',
    'turkii'                                    => 'tr',
    'turkmenistaan'                             => 'tm',
    'tuwaluu'                                   => 'tv',
    "u\.s\.minoroutlyingislands"                => 'um',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'ukereen'                                   => 'ua',
    'unganndaa'                                 => 'ug',
    'unionofsovietsocialistrepublics'           => 'su',
    'unknownregion'                             => 'zz',
    'uruguwaay'                                 => 'uy',
    'usbekistaan'                               => 'uz',
    'wakeisland'                                => 'wk',
    'walisefutuna'                              => 'wf',
    'wanuwaatuu'                                => 'vu',
    'wenesuwelaa'                               => 've',
    'westernafrica'                             => '011',
    'westernasia'                               => 145,
    'westerneurope'                             => 155,
    'westernsahara'                             => 'eh',
    'wiyetnaam'                                 => 'vn',
    'world'                                     => '001',
    'yemen'                                     => 'ye',
    "\Ã\landislands"                         => 'ax',
);

1;

