/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FloatingPointContentCommand;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXFloatingPoint;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataNumericElement;
import com.dickimawbooks.texparserlib.latex.datatool.DatumType;
import com.dickimawbooks.texparserlib.latex.datatool.Julian;
import java.io.IOException;

public class DataRealElement
extends AbstractTeXObject
implements DataNumericElement,
Expandable {
    protected double value;
    protected TeXObject original;

    public DataRealElement() {
        this(0.0);
    }

    public DataRealElement(Number number) {
        this(number.doubleValue());
    }

    public DataRealElement(TeXNumber teXNumber) {
        this(teXNumber.doubleValue());
    }

    public DataRealElement(double d) {
        this.value = d;
    }

    public DataRealElement(double d, TeXObject teXObject) {
        this.value = d;
        this.original = teXObject;
    }

    @Override
    public Object clone() {
        return new DataRealElement(this.value, this.original == null ? null : (TeXObject)this.original.clone());
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public TeXObject getTeXValue(TeXParser teXParser) {
        return new TeXFloatingPoint(this.doubleValue());
    }

    @Override
    public TeXObject getContent(TeXParser teXParser) {
        if (this.original == null) {
            return new TeXFloatingPoint(this.doubleValue());
        }
        return this.original;
    }

    @Override
    public TeXObject getCurrencySymbol() {
        return null;
    }

    @Override
    public Julian getJulian() {
        return null;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += (double)numerical.number(teXParser);
        this.original = null;
    }

    @Override
    public void divide(int n) {
        this.value /= (double)n;
        this.original = null;
    }

    @Override
    public void multiply(int n) {
        this.value *= (double)n;
        this.original = null;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.intValue();
    }

    @Override
    public byte getDataType() {
        return 2;
    }

    @Override
    public DatumType getDatumType() {
        return DatumType.DECIMAL;
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (teXParser.isStack(this.original)) {
            return (TeXObjectList)this.original.clone();
        }
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList2 = teXParserListener.createStack();
        if (this.original == null) {
            teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_decimal_value:n"));
            teXObjectList2.add(new TeXFloatingPoint(this.doubleValue()));
        } else {
            teXObjectList2.add((TeXObject)this.original.clone());
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandfully(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return teXParser.getListener().createString(this.format());
    }

    @Override
    public String format() {
        if (this.original == null) {
            return "" + this.value;
        }
        return this.original.format();
    }

    @Override
    public String toString(TeXParser teXParser) {
        if (this.original == null) {
            return "" + this.value;
        }
        return this.original.toString(teXParser);
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(this.toString(teXParser));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        if (this.original == null) {
            TeXObjectList teXObjectList2 = teXParserListener.createStack();
            teXObjectList2.add(teXParserListener.getControlSequence("__texparser_fmt_decimal_value:n"));
            teXObjectList2.add(new TeXFloatingPoint(this.doubleValue()));
            TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
        } else {
            TeXParserUtils.process(this.original, teXParser, teXObjectList);
        }
    }

    public String toString() {
        return String.format("%s[value=%f,original=%s]", this.getClass().getSimpleName(), this.value, this.original);
    }

    @Override
    public ControlSequence createControlSequence(String string) {
        return new FloatingPointContentCommand(string, this.value);
    }
}

