---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, biffer, annuler,
              barrer, simplifier une équation, enseignement des mathématiques
---

# Comment biffer des termes dans une expression mathématique ?

Barrer (ou "biffer") des termes permet d'expliquer le comportement 
d'expressions ou d'équations (souvent à des fins pédagogiques). 

Si ce qui suit évoque les mathématiques, vous pouvez aussi vous tourner
vers la question "[](/3_composition/texte/mots/barrer_des_mots)" pour faire 
de même sur du texte.


## Avec l'extension <ctanpkg:amssymb>, pour un symbole

Pour barrer un symbole mathématique, vous pourrez utiliser la commande `\not`,
pour marquer la négation. Il existe de nombreux caractères barrés définis 
dans l'extension <ctanpkg:amssymb>, comme par exemple `\notin`, `\nleq` 
ou `\lneq`.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{amssymb}

\begin{document}
Il faut noter la différence entre
$a \not\in A$ et $a \notin A$.

Pour dire \emph{strictement supérieur} en insistant sur le \emph{strictement},
vous pouvez utiliser le symbole $\gneq$.
\end{document}
```


## Avec l'extension <ctanpkg:cancel>, pour des expressions

Depuis 2013, l'extension <ctanpkg:cancel>, de Donald Arseneau, fournit 
plusieurs commandes pour le faire :

- `\cancel{⟨expression⟩}` trace un trait diagonal sur l’`⟨expression⟩` 
  (de gauche à droite et de bas en haut) ;
- `\bcancel{⟨expression⟩}` trace un trait diagonal inversé sur l’`⟨expression⟩`
  (de gauche à droite et de haut en bas) ;
- `\xcancel{⟨expression⟩}` coche l’`⟨expression⟩` en cumulant les effets 
  des deux commandes précédentes ;
- `\cancelto{⟨valeur⟩}{⟨expression⟩}` barre l’`⟨expression⟩` d'une flèche 
  pointant vers la `⟨valeur⟩` de cette expression.

Voici des exemples d'application :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage{cancel}

\begin{document}
\begin{align*}
(a-b)(a+b) &= a^2 + \cancel{ab} - \cancel{ba} - b^2   \\
           &= a^2 + \bcancel{ab} - \bcancel{ba} - b^2 \\
           &= a^2 + \xcancel{ab} - \xcancel{ba} - b^2 \\
           &= a^2 + \xcancel{ab - ba} - b^2           \\
           &= a^2 + \cancelto{0}{ab - ba} - b^2       \\
           &= a^2 - b^2
\end{align*}
\end{document}
```

La [documentation](texdoc:cancel) de l'extension propose quelques options 
supplémentaires pour régler un peu plus finement ces marques.

N'oubliez pas que vous pouvez aussi égayer vos formules avec des couleurs.
En combinant l'extension <ctanpkg:cancel> avec <ctanpkg:xcolor>, 
vous pouvez aider votre lecteur à suivre les termes d'une étape 
à l'autre :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{cancel}
  \usepackage{color}

  \newcommand{\red}{\color{red}}

\begin{document}
\[
  \frac{ {\red a} b }{ b } 
  = \frac{ {\red a} \cancel{b} }{ \cancel{b} }
  = {\red a}
\]
\end{document}
```


:::{sources}
- [Cancelling terms in maths expressions](faquk:FAQ-cancellation)
- [LaTeX pour les enseignants](https://www.editions-ellipses.fr/accueil/378-latex-pour-les-enseignants-9782340036710.html), 
  Nicolas Poulain, Ellipses (2020), 226 pages. ISBN : 9782340036710
:::