---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, communication, correspondance
              mailing, liste de diffusion, courrier, communication d'entreprise
---

# Comment faire des références dans une lettre ?

## Avec la classe <ctanpkg:lettre>

Avec la classe <ctanpkg:lettre>, il existe les commandes `\Nref`, 
pour les références de l'expéditeur et `\Vref` pour celles du destinataire :

```
\documentclass[french]{lettre}
  \usepackage[T1]{fontenc}    % Encodage T1 
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)

\begin{document}
\begin{letter}{le destinataire}

\address{Mme Marie-Paule \textsc{Kluth}}
\notelephone\nofax\nolieu\nodate
\signature{MPK}
\Vref{A VOUS}
\Nref{DE MOI}

 \opening{Cher ami,}

   Texte....

   \closing{Sincèrement.}
   \encl{Pièces jointes :}
   \cc{copie à Totor}
\end{letter}
\end{document}
```


## Avec l'extension <ctanpkg:e-french>

L'extension <ctanpkg:e-french>, basée sur les travaux de Bernard Gaulle, 
offre également les commandes `\yourref` et `\ourref` :

```
\documentclass[a4paper,french]{letter}
  \usepackage[T1]{fontenc}    % Encodage T1 
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{efrench}
  
  \signature{Ma signature}

\begin{document}
\yourref{mon texte}
\ourref{mon autre texte}
\begin{letter}{le destinataire}
   \opening{Cher Monsieur,}

   Texte...
   \closing{Salutations}
   \encl{pieces jointes}
   \cc{copie à M. Totor}
\end{letter}
\end{document}
```