# pLaTeX2e cheat sheet

This is a translation to Japanese of Winston Chang's LaTeX cheat sheet (a reference sheet for writing scientific papers). It has been adapted to Japanese standards using pLaTeX, and also attached additional information of "standard LaTeX" (especially about math-mode).

# pLaTeX2e チートシート

pLaTeX2e でよく用いられる命令を2ページの PDF にまとめたチートシート（コマンド一覧）です．英語版の [LaTeX2e Cheat Sheet](http://www.stdout.org/~winston/latex/) を基に作成を開始しましたが，pLaTeX2e 版独自の改良を多数加えています．

## 編集方針

原版から，以下のような方針で変更を行っています．

* 紙面の許す限り網羅性を重視
* 説明は最小限度（LaTeX の基本は既知と仮定）
* 統一感のあるデザイン（ソースは構造化）
* 使用頻度の高い命令を優先
* 同じ効果の命令が複数ある場合は綴りが短いものを優先
* 「標準」以外のものは原則扱わない
* TeX の外部プログラムについては言及程度に留める

## 配布場所など

* PDF ファイル
	* <https://wtsnjp.com/pdf/platexsheet.pdf>
	* <https://wtsnjp.com/pdf/platexsheet-jsclasses.pdf>
* CTAN パッケージ：<https://www.ctan.org/pkg/platexcheat>
* GitHub リポジトリ：<https://github.com/wtsnjp/platexcheat>

PDF ファイルは最新版のみの配布です．それ以外はソースから各自タイプセットしてください（v1.1 以降は [h-kitagawa/plistings](https://github.com/h-kitagawa/plistings) が必要なので注意）．GitHub でのコメント・プルリクエスト歓迎です．Twitter で作者に連絡いただいても構いません．

## ライセンス

本パッケージには [MIT ライセンス](./LICENSE)が適用されます.

---

Takuto ASAKURA ([wtsnjp](https://twitter.com/wtsnjp))
