; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- -tailcallopt | FileCheck %s

; With -tailcallopt, CodeGen guarantees a tail call optimization
; for all of these.

declare fastcc i32 @tailcallee(i32 %a1, i32 %a2, i32 %a3, i32 %a4)

define dso_local fastcc i32 @tailcaller(i32 %in1, i32 %in2) nounwind {
; CHECK-LABEL: tailcaller:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subl $16, %esp
; CHECK-NEXT:    movl %ecx, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl %edx, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    jmp tailcallee@PLT # TAILCALL
entry:
  %tmp11 = tail call fastcc i32 @tailcallee(i32 %in1, i32 %in2, i32 %in1, i32 %in2)
  ret i32 %tmp11
}

declare fastcc ptr @alias_callee()

define fastcc noalias ptr @noalias_caller() nounwind {
; CHECK-LABEL: noalias_caller:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp alias_callee@PLT # TAILCALL
  %p = tail call fastcc ptr @alias_callee()
  ret ptr %p
}

declare fastcc noalias ptr @noalias_callee()

define dso_local fastcc ptr @alias_caller() nounwind {
; CHECK-LABEL: alias_caller:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp noalias_callee@PLT # TAILCALL
  %p = tail call fastcc noalias ptr @noalias_callee()
  ret ptr %p
}

declare fastcc i32 @i32_callee()

define dso_local fastcc i32 @ret_undef() nounwind {
; CHECK-LABEL: ret_undef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp i32_callee@PLT # TAILCALL
  %p = tail call fastcc i32 @i32_callee()
  ret i32 undef
}

declare fastcc void @does_not_return()

define dso_local fastcc i32 @noret() nounwind {
; CHECK-LABEL: noret:
; CHECK:       # %bb.0:
; CHECK-NEXT:    jmp does_not_return@PLT # TAILCALL
  tail call fastcc void @does_not_return()
  unreachable
}

define dso_local fastcc void @void_test(i32, i32, i32, i32) {
; CHECK-LABEL: void_test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    subl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %esi, -8
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    jmp void_test # TAILCALL
  entry:
   tail call fastcc void @void_test( i32 %0, i32 %1, i32 %2, i32 %3)
   ret void
}

define dso_local fastcc i1 @i1test(i32, i32, i32, i32) {
; CHECK-LABEL: i1test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    pushl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    subl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset %esi, -8
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %esi
; CHECK-NEXT:    movl %esi, {{[0-9]+}}(%esp)
; CHECK-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; CHECK-NEXT:    addl $8, %esp
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    popl %esi
; CHECK-NEXT:    .cfi_def_cfa_offset 4
; CHECK-NEXT:    jmp i1test # TAILCALL
  entry:
  %4 = tail call fastcc i1 @i1test( i32 %0, i32 %1, i32 %2, i32 %3)
  ret i1 %4
}
