/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.utility;

import com.hankcs.hanlp.dictionary.CoreBiGramTableDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Map;
import java.util.Set;

public class MathUtility {
    public static int sum(int ... var) {
        int sum = 0;
        for (int x : var) {
            sum += x;
        }
        return sum;
    }

    public static float sum(float ... var) {
        float sum = 0.0f;
        for (float x : var) {
            sum += x;
        }
        return sum;
    }

    public static double percentage(double current, double total) {
        return current / total * 100.0;
    }

    public static double average(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum / (double)array.length;
    }

    public static void normalizeExp(Map<String, Double> predictionScores) {
        Set<Map.Entry<String, Double>> entrySet = predictionScores.entrySet();
        double max = Double.NEGATIVE_INFINITY;
        for (Map.Entry<String, Double> entry : entrySet) {
            max = Math.max(max, entry.getValue());
        }
        double sum = 0.0;
        for (Map.Entry<String, Double> entry : entrySet) {
            Double value = Math.exp(entry.getValue() - max);
            entry.setValue(value);
            sum += value.doubleValue();
        }
        if (sum != 0.0) {
            for (Map.Entry<String, Double> entry : entrySet) {
                predictionScores.put(entry.getKey(), entry.getValue() / sum);
            }
        }
    }

    public static void normalizeExp(double[] predictionScores) {
        int i;
        double max = Double.NEGATIVE_INFINITY;
        for (double value : predictionScores) {
            max = Math.max(max, value);
        }
        double sum = 0.0;
        for (i = 0; i < predictionScores.length; ++i) {
            predictionScores[i] = Math.exp(predictionScores[i] - max);
            sum += predictionScores[i];
        }
        if (sum != 0.0) {
            i = 0;
            while (i < predictionScores.length) {
                int n = i++;
                predictionScores[n] = predictionScores[n] / sum;
            }
        }
    }

    public static double calculateWeight(Vertex from, Vertex to) {
        int fFrom = from.getAttribute().totalFrequency;
        int fBigram = CoreBiGramTableDictionary.getBiFrequency(from.wordID, to.wordID);
        int fTo = to.getAttribute().totalFrequency;
        return -Math.log(0.9 * (Predefine.myu * (double)fBigram / (double)(fFrom + 1) + 1.0 - Predefine.myu) + 0.09999999999999998 * (double)fTo / (double)Predefine.TOTAL_FREQUENCY);
    }
}

