/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.RoutingTableIncrementalDiff;
import org.opensearch.cluster.routing.StringKeyDiffProvider;
import org.opensearch.cluster.routing.remote.RemoteRoutingTableService;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.remote.RemoteWritableEntityStore;
import org.opensearch.common.remote.RemoteWriteableEntityBlobStore;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteStateTransferException;
import org.opensearch.gateway.remote.model.RemoteRoutingTableBlobStore;
import org.opensearch.gateway.remote.routingtable.RemoteIndexRoutingTable;
import org.opensearch.gateway.remote.routingtable.RemoteRoutingTableDiff;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class InternalRemoteRoutingTableService
extends AbstractLifecycleComponent
implements RemoteRoutingTableService {
    private static final Logger logger = LogManager.getLogger(InternalRemoteRoutingTableService.class);
    private final Settings settings;
    private final Supplier<RepositoriesService> repositoriesService;
    private Compressor compressor;
    private RemoteWritableEntityStore<IndexRoutingTable, RemoteIndexRoutingTable> remoteIndexRoutingTableStore;
    private RemoteWritableEntityStore<Diff<RoutingTable>, RemoteRoutingTableDiff> remoteRoutingTableDiffStore;
    private final ClusterSettings clusterSettings;
    private BlobStoreRepository blobStoreRepository;
    private final ThreadPool threadPool;
    private final String clusterName;

    public InternalRemoteRoutingTableService(Supplier<RepositoriesService> repositoriesService, Settings settings, ClusterSettings clusterSettings, ThreadPool threadpool, String clusterName) {
        assert (RemoteStoreNodeAttribute.isRemoteRoutingTableConfigured(settings)) : "Remote routing table is not enabled";
        this.repositoriesService = repositoriesService;
        this.settings = settings;
        this.threadPool = threadpool;
        this.clusterName = clusterName;
        this.clusterSettings = clusterSettings;
    }

    @Override
    public List<IndexRoutingTable> getIndicesRouting(RoutingTable routingTable) {
        return new ArrayList<IndexRoutingTable>(routingTable.indicesRouting().values());
    }

    @Override
    public StringKeyDiffProvider<IndexRoutingTable> getIndicesRoutingMapDiff(RoutingTable before, RoutingTable after) {
        return new RoutingTableIncrementalDiff(before, after);
    }

    @Override
    public void getAsyncIndexRoutingWriteAction(String clusterUUID, long term, long version, IndexRoutingTable indexRouting, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        RemoteIndexRoutingTable remoteIndexRoutingTable = new RemoteIndexRoutingTable(indexRouting, clusterUUID, this.compressor, term, version);
        ActionListener completionListener = ActionListener.wrap(resp -> latchedActionListener.onResponse(remoteIndexRoutingTable.getUploadedMetadata()), ex -> latchedActionListener.onFailure(new RemoteStateTransferException("Exception in writing index to remote store: " + indexRouting.getIndex().toString(), (Throwable)ex)));
        this.remoteIndexRoutingTableStore.writeAsync(remoteIndexRoutingTable, (ActionListener<Void>)completionListener);
    }

    @Override
    public void getAsyncIndexRoutingDiffWriteAction(String clusterUUID, long term, long version, StringKeyDiffProvider<IndexRoutingTable> routingTableDiff, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        RemoteRoutingTableDiff remoteRoutingTableDiff = new RemoteRoutingTableDiff((RoutingTableIncrementalDiff)routingTableDiff, clusterUUID, this.compressor, term, version);
        ActionListener completionListener = ActionListener.wrap(resp -> latchedActionListener.onResponse(remoteRoutingTableDiff.getUploadedMetadata()), ex -> latchedActionListener.onFailure(new RemoteStateTransferException("Exception in writing index routing diff to remote store", (Throwable)ex)));
        this.remoteRoutingTableDiffStore.writeAsync(remoteRoutingTableDiff, (ActionListener<Void>)completionListener);
    }

    @Override
    public List<ClusterMetadataManifest.UploadedIndexMetadata> getAllUploadedIndicesRouting(ClusterMetadataManifest previousManifest, List<ClusterMetadataManifest.UploadedIndexMetadata> indicesRoutingUploaded, List<String> indicesRoutingToDelete) {
        Map allUploadedIndicesRouting = previousManifest.getIndicesRouting().stream().collect(Collectors.toMap(ClusterMetadataManifest.UploadedIndexMetadata::getIndexName, Function.identity()));
        indicesRoutingUploaded.forEach(uploadedIndexRouting -> allUploadedIndicesRouting.put(uploadedIndexRouting.getIndexName(), uploadedIndexRouting));
        indicesRoutingToDelete.forEach(allUploadedIndicesRouting::remove);
        return new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>(allUploadedIndicesRouting.values());
    }

    @Override
    public void getAsyncIndexRoutingReadAction(String clusterUUID, String uploadedFilename, LatchedActionListener<IndexRoutingTable> latchedActionListener) {
        ActionListener actionListener = ActionListener.wrap(latchedActionListener::onResponse, latchedActionListener::onFailure);
        RemoteIndexRoutingTable remoteIndexRoutingTable = new RemoteIndexRoutingTable(uploadedFilename, clusterUUID, this.compressor);
        this.remoteIndexRoutingTableStore.readAsync(remoteIndexRoutingTable, (ActionListener<IndexRoutingTable>)actionListener);
    }

    @Override
    public void getAsyncIndexRoutingTableDiffReadAction(String clusterUUID, String uploadedFilename, LatchedActionListener<Diff<RoutingTable>> latchedActionListener) {
        ActionListener actionListener = ActionListener.wrap(latchedActionListener::onResponse, latchedActionListener::onFailure);
        RemoteRoutingTableDiff remoteRoutingTableDiff = new RemoteRoutingTableDiff(uploadedFilename, clusterUUID, this.compressor);
        this.remoteRoutingTableDiffStore.readAsync(remoteRoutingTableDiff, (ActionListener<Diff<RoutingTable>>)actionListener);
    }

    @Override
    public List<ClusterMetadataManifest.UploadedIndexMetadata> getUpdatedIndexRoutingTableMetadata(List<String> updatedIndicesRouting, List<ClusterMetadataManifest.UploadedIndexMetadata> allIndicesRouting) {
        return updatedIndicesRouting.stream().map(idx -> {
            Optional<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadataOptional = allIndicesRouting.stream().filter(idx2 -> idx2.getIndexName().equals(idx)).findFirst();
            assert (uploadedIndexMetadataOptional.isPresent());
            return uploadedIndexMetadataOptional.get();
        }).collect(Collectors.toList());
    }

    protected void doClose() throws IOException {
        if (this.blobStoreRepository != null) {
            IOUtils.close((Closeable)((Object)this.blobStoreRepository));
        }
    }

    protected void doStart() {
        assert (RemoteStoreNodeAttribute.isRemoteRoutingTableConfigured(this.settings)) : "Remote routing table is not enabled";
        String remoteStoreRepo = RemoteStoreNodeAttribute.getRoutingTableRepoName(this.settings);
        assert (remoteStoreRepo != null) : "Remote routing table repository is not configured";
        Repository repository = this.repositoriesService.get().repository(remoteStoreRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        this.blobStoreRepository = (BlobStoreRepository)repository;
        this.compressor = this.blobStoreRepository.getCompressor();
        this.remoteIndexRoutingTableStore = new RemoteRoutingTableBlobStore<IndexRoutingTable, RemoteIndexRoutingTable>(new BlobStoreTransferService(this.blobStoreRepository.blobStore(), this.threadPool), this.blobStoreRepository, this.clusterName, this.threadPool, "remote_state_read", this.clusterSettings);
        this.remoteRoutingTableDiffStore = new RemoteWriteableEntityBlobStore<Diff<RoutingTable>, RemoteRoutingTableDiff>(new BlobStoreTransferService(this.blobStoreRepository.blobStore(), this.threadPool), this.blobStoreRepository, this.clusterName, this.threadPool, "remote_state_read", "cluster-state");
    }

    protected void doStop() {
    }

    @Override
    public void deleteStaleIndexRoutingPaths(List<String> stalePaths) throws IOException {
        try {
            logger.debug(() -> "Deleting stale index routing files from remote - " + String.valueOf(stalePaths));
            this.blobStoreRepository.blobStore().blobContainer(BlobPath.cleanPath()).deleteBlobsIgnoringIfNotExists(stalePaths);
        }
        catch (IOException e) {
            logger.error(() -> new ParameterizedMessage("Failed to delete some stale index routing paths from {}", (Object)stalePaths), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deleteStaleIndexRoutingDiffPaths(List<String> stalePaths) throws IOException {
        try {
            logger.debug(() -> "Deleting stale index routing diff files from remote - " + String.valueOf(stalePaths));
            this.blobStoreRepository.blobStore().blobContainer(BlobPath.cleanPath()).deleteBlobsIgnoringIfNotExists(stalePaths);
        }
        catch (IOException e) {
            logger.error(() -> new ParameterizedMessage("Failed to delete some stale index routing diff paths from {}", (Object)stalePaths), (Throwable)e);
            throw e;
        }
    }
}

