/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial3d.Geo3DPointDistanceComparator;
import org.apache.lucene.spatial3d.geom.GeoDistanceShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;

final class Geo3DPointSortField
extends SortField {
    final GeoDistanceShape distanceShape;
    final PlanetModel planetModel;

    Geo3DPointSortField(String field, PlanetModel planetModel, GeoDistanceShape distanceShape) {
        super(field, SortField.Type.CUSTOM);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (distanceShape == null) {
            throw new IllegalArgumentException("distanceShape must not be null");
        }
        this.distanceShape = distanceShape;
        this.planetModel = planetModel;
        this.setMissingValue(Double.POSITIVE_INFINITY);
    }

    public FieldComparator<?> getComparator(int numHits, Pruning pruning) {
        return new Geo3DPointDistanceComparator(this.getField(), this.planetModel, this.distanceShape, numHits);
    }

    public Double getMissingValue() {
        return (Double)super.getMissingValue();
    }

    public void setMissingValue(Object missingValue) {
        if (!Double.valueOf(Double.POSITIVE_INFINITY).equals(missingValue)) {
            throw new IllegalArgumentException("Missing value can only be Double.POSITIVE_INFINITY (missing values last), but got " + String.valueOf(missingValue));
        }
        this.missingValue = missingValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = this.distanceShape.hashCode();
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Geo3DPointSortField other = (Geo3DPointSortField)((Object)obj);
        return this.distanceShape.equals(other.distanceShape);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<distanceShape:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" shape=");
        builder.append(this.distanceShape);
        if (Double.POSITIVE_INFINITY != this.getMissingValue()) {
            builder.append(" missingValue=").append(this.getMissingValue());
        }
        builder.append('>');
        return builder.toString();
    }
}

