/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import org.tribuo.math.la.DenseSparseMatrix;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.MatrixIterator;
import org.tribuo.math.la.MatrixTuple;
import org.tribuo.math.la.SGDVector;
import org.tribuo.math.la.SparseVector;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorTuple;
import org.tribuo.math.util.VectorNormalizer;

public class DenseMatrix
implements Matrix {
    private static final long serialVersionUID = 1L;
    private static final double DELTA = 1.0E-10;
    protected final double[][] values;
    protected final int dim1;
    protected final int dim2;
    private final int[] shape;
    private final int numElements;

    public DenseMatrix(int dim1, int dim2) {
        this.values = new double[dim1][dim2];
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.shape = new int[]{dim1, dim2};
        this.numElements = dim1 * dim2;
    }

    public DenseMatrix(DenseMatrix other) {
        this.values = new double[other.values.length][];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new double[other.values[i].length];
            for (int j = 0; j < this.values[i].length; ++j) {
                this.values[i][j] = other.get(i, j);
            }
        }
        this.dim1 = other.dim1;
        this.dim2 = other.dim2;
        this.shape = new int[]{this.dim1, this.dim2};
        this.numElements = this.dim1 * this.dim2;
    }

    public DenseMatrix(Matrix other) {
        this.dim1 = other.getDimension1Size();
        this.dim2 = other.getDimension2Size();
        this.values = new double[this.dim1][this.dim2];
        for (MatrixTuple t : other) {
            this.values[t.i][t.j] = t.value;
        }
        this.shape = new int[]{this.dim1, this.dim2};
        this.numElements = this.dim1 * this.dim2;
    }

    DenseMatrix(double[][] values) {
        this.values = values;
        this.dim1 = values.length;
        this.dim2 = values[0].length;
        this.shape = new int[]{this.dim1, this.dim2};
        this.numElements = this.dim1 * this.dim2;
    }

    public static DenseMatrix createDenseMatrix(double[][] values) {
        double[][] newValues = new double[values.length][];
        int sizeCounter = -1;
        for (int i = 0; i < newValues.length; ++i) {
            if (sizeCounter == -1) {
                sizeCounter = values[i].length;
            }
            if (sizeCounter != values[i].length) {
                throw new IllegalArgumentException("DenseMatrix must not be ragged. Expected dim2 = " + sizeCounter + ", but found " + values[i].length + " at index " + i);
            }
            newValues[i] = Arrays.copyOf(values[i], values[i].length);
        }
        return new DenseMatrix(newValues);
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public Tensor reshape(int[] newShape) {
        int sum = Tensor.shapeSum(newShape);
        if (sum != this.numElements) {
            throw new IllegalArgumentException("Invalid shape " + Arrays.toString(newShape) + ", expected something with " + this.numElements + " elements.");
        }
        if (newShape.length == 2) {
            DenseMatrix matrix = new DenseMatrix(newShape[0], newShape[1]);
            for (int a = 0; a < this.numElements; ++a) {
                int oldI = a % this.dim1;
                int oldJ = a % this.dim2;
                int i = a % newShape[0];
                int j = a / newShape[0];
                matrix.set(i, j, this.get(oldI, oldJ));
            }
            return matrix;
        }
        if (newShape.length == 1) {
            DenseVector vector = new DenseVector(this.numElements);
            int a = 0;
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    vector.set(a, this.get(i, j));
                    ++a;
                }
            }
            return vector;
        }
        throw new IllegalArgumentException("Only supports 1 or 2 dimensional tensors.");
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this);
    }

    @Override
    public double get(int i, int j) {
        return this.values[i][j];
    }

    public DenseVector gatherAcrossDim1(int[] elements) {
        if (elements.length != this.dim2) {
            throw new IllegalArgumentException("Invalid number of elements to gather, must select one per value of dim2");
        }
        double[] outputValues = new double[this.dim2];
        for (int i = 0; i < elements.length; ++i) {
            outputValues[i] = this.values[elements[i]][i];
        }
        return new DenseVector(outputValues);
    }

    public DenseVector gatherAcrossDim2(int[] elements) {
        if (elements.length != this.dim1) {
            throw new IllegalArgumentException("Invalid number of elements to gather, must select one per value of dim1");
        }
        double[] outputValues = new double[this.dim1];
        for (int i = 0; i < elements.length; ++i) {
            outputValues[i] = this.values[i][elements[i]];
        }
        return new DenseVector(outputValues);
    }

    public DenseMatrix transpose() {
        double[][] newValues = new double[this.dim2][this.dim1];
        for (int i = 0; i < this.dim1; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                newValues[j][i] = this.get(i, j);
            }
        }
        return new DenseMatrix(newValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DenseMatrix)) {
            return false;
        }
        DenseMatrix that = (DenseMatrix)o;
        if (this.dim1 == that.dim1 && this.dim2 == that.dim2 && this.numElements == that.numElements && Arrays.equals(this.getShape(), that.getShape())) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (!(Math.abs(this.get(i, j) - that.get(i, j)) > 1.0E-10)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hash(this.dim1, this.dim2, this.numElements);
        result = 31 * result + Arrays.hashCode((Object[])this.values);
        result = 31 * result + Arrays.hashCode(this.getShape());
        return result;
    }

    @Override
    public void set(int i, int j, double value) {
        this.values[i][j] = value;
    }

    @Override
    public int getDimension1Size() {
        return this.dim1;
    }

    @Override
    public int getDimension2Size() {
        return this.dim2;
    }

    @Override
    public DenseVector leftMultiply(SGDVector input) {
        if (input.size() == this.dim2) {
            double[] output = new double[this.dim1];
            if (input instanceof DenseVector) {
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < this.dim2; ++j) {
                        int n = i;
                        output[n] = output[n] + this.get(i, j) * input.get(j);
                    }
                }
            } else {
                for (VectorTuple tuple : input) {
                    for (int i = 0; i < output.length; ++i) {
                        int n = i;
                        output[n] = output[n] + this.values[i][tuple.index] * tuple.value;
                    }
                }
            }
            return new DenseVector(output);
        }
        throw new IllegalArgumentException("input.size() != dim2, input.size() = " + input.size() + ", dim1,dim2 = " + this.dim1 + "," + this.dim2);
    }

    @Override
    public DenseVector rightMultiply(SGDVector input) {
        if (input.size() == this.dim1) {
            double[] output = new double[this.dim2];
            if (input instanceof DenseVector) {
                for (int i = 0; i < this.dim1; ++i) {
                    double curValue = input.get(i);
                    for (int j = 0; j < this.dim2; ++j) {
                        int n = j;
                        output[n] = output[n] + this.get(i, j) * curValue;
                    }
                }
            } else {
                for (VectorTuple tuple : input) {
                    for (int i = 0; i < output.length; ++i) {
                        int n = i;
                        output[n] = output[n] + this.values[tuple.index][i] * tuple.value;
                    }
                }
            }
            return new DenseVector(output);
        }
        throw new IllegalArgumentException("input.size() != dim1");
    }

    @Override
    public DenseMatrix matrixMultiply(Matrix other) {
        if (this.dim2 == other.getDimension1Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim1][otherDense.dim2];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDense.dim2; ++j) {
                        output[i][j] = this.columnRowDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim2 = otherSparse.getDimension2Size();
                double[][] output = new double[this.dim1][otherDim2];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDim2; ++j) {
                        output[i][j] = this.columnRowDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, this.shape=" + Arrays.toString(this.shape) + ", other.shape = " + Arrays.toString(other.getShape()));
    }

    @Override
    public DenseMatrix matrixMultiply(Matrix other, boolean transposeThis, boolean transposeOther) {
        if (transposeThis && transposeOther) {
            return this.matrixMultiplyTransposeBoth(other);
        }
        if (transposeThis) {
            return this.matrixMultiplyTransposeThis(other);
        }
        if (transposeOther) {
            return this.matrixMultiplyTransposeOther(other);
        }
        return this.matrixMultiply(other);
    }

    private DenseMatrix matrixMultiplyTransposeBoth(Matrix other) {
        if (this.dim1 == other.getDimension2Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim2][otherDense.dim1];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDense.dim1; ++j) {
                        output[i][j] = this.rowColumnDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim1 = otherSparse.getDimension1Size();
                double[][] output = new double[this.dim2][otherDim1];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDim1; ++j) {
                        output[i][j] = this.rowColumnDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, this.shape=" + Arrays.toString(this.shape) + ", other.shape = " + Arrays.toString(other.getShape()));
    }

    private DenseMatrix matrixMultiplyTransposeThis(Matrix other) {
        if (this.dim1 == other.getDimension1Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim2][otherDense.dim2];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDense.dim2; ++j) {
                        output[i][j] = this.columnColumnDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim2 = otherSparse.getDimension2Size();
                double[][] output = new double[this.dim2][otherDim2];
                for (int i = 0; i < this.dim2; ++i) {
                    for (int j = 0; j < otherDim2; ++j) {
                        output[i][j] = this.columnColumnDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, this.shape=" + Arrays.toString(this.shape) + ", other.shape = " + Arrays.toString(other.getShape()));
    }

    private DenseMatrix matrixMultiplyTransposeOther(Matrix other) {
        if (this.dim2 == other.getDimension2Size()) {
            if (other instanceof DenseMatrix) {
                DenseMatrix otherDense = (DenseMatrix)other;
                double[][] output = new double[this.dim1][otherDense.dim1];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDense.dim1; ++j) {
                        output[i][j] = this.rowRowDot(i, j, otherDense);
                    }
                }
                return new DenseMatrix(output);
            }
            if (other instanceof DenseSparseMatrix) {
                DenseSparseMatrix otherSparse = (DenseSparseMatrix)other;
                int otherDim1 = otherSparse.getDimension1Size();
                double[][] output = new double[this.dim1][otherDim1];
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < otherDim1; ++j) {
                        output[i][j] = this.rowRowDot(i, j, otherSparse);
                    }
                }
                return new DenseMatrix(output);
            }
            throw new IllegalArgumentException("Unknown matrix type " + other.getClass().getName());
        }
        throw new IllegalArgumentException("Invalid matrix dimensions, this.shape=" + Arrays.toString(this.shape) + ", other.shape = " + Arrays.toString(other.getShape()));
    }

    private double columnRowDot(int rowIndex, int otherColIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim2; ++i) {
            sum += this.get(rowIndex, i) * other.get(i, otherColIndex);
        }
        return sum;
    }

    private double rowColumnDot(int colIndex, int otherRowIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            sum += this.get(i, colIndex) * other.get(otherRowIndex, i);
        }
        return sum;
    }

    private double columnColumnDot(int colIndex, int otherColIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            sum += this.get(i, colIndex) * other.get(i, otherColIndex);
        }
        return sum;
    }

    private double rowRowDot(int rowIndex, int otherRowIndex, Matrix other) {
        double sum = 0.0;
        for (int i = 0; i < this.dim2; ++i) {
            sum += this.get(rowIndex, i) * other.get(otherRowIndex, i);
        }
        return sum;
    }

    @Override
    public DenseVector rowSum() {
        double[] rowSum = new double[this.dim1];
        for (int i = 0; i < this.dim1; ++i) {
            double tmp = 0.0;
            for (int j = 0; j < this.dim2; ++j) {
                tmp += this.values[i][j];
            }
            rowSum[i] = tmp;
        }
        return new DenseVector(rowSum);
    }

    @Override
    public void rowScaleInPlace(DenseVector scalingCoefficients) {
        for (int i = 0; i < this.dim1; ++i) {
            double scalar = scalingCoefficients.get(i);
            int j = 0;
            while (j < this.dim2) {
                double[] dArray = this.values[i];
                int n = j++;
                dArray[n] = dArray[n] * scalar;
            }
        }
    }

    @Override
    public void add(int i, int j, double value) {
        double[] dArray = this.values[i];
        int n = j;
        dArray[n] = dArray[n] + value;
    }

    public void addAcrossDim1(int[] indices, double value) {
        if (indices.length != this.dim2) {
            throw new IllegalArgumentException("Invalid number of elements to add, must select one per value of dim2");
        }
        int i = 0;
        while (i < indices.length) {
            double[] dArray = this.values[indices[i]];
            int n = i++;
            dArray[n] = dArray[n] + value;
        }
    }

    public void addAcrossDim2(int[] indices, double value) {
        if (indices.length != this.dim1) {
            throw new IllegalArgumentException("Invalid number of elements to indices, must select one per value of dim1");
        }
        for (int i = 0; i < indices.length; ++i) {
            double[] dArray = this.values[i];
            int n = indices[i];
            dArray[n] = dArray[n] + value;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void intersectAndAddInPlace(Tensor other, DoubleUnaryOperator f) {
        if (!(other instanceof Matrix)) throw new IllegalArgumentException("Adding a non-Matrix to a Matrix");
        Matrix otherMat = (Matrix)other;
        if (this.dim1 != otherMat.getDimension1Size() || this.dim2 != otherMat.getDimension2Size()) throw new IllegalArgumentException("Matrices are not the same size, this(" + this.dim1 + "," + this.dim2 + "), other(" + otherMat.getDimension1Size() + "," + otherMat.getDimension2Size() + ")");
        if (otherMat instanceof DenseMatrix) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    double[] dArray = this.values[i];
                    int n = j;
                    dArray[n] = dArray[n] + f.applyAsDouble(otherMat.get(i, j));
                }
            }
            return;
        } else {
            for (MatrixTuple tuple : otherMat) {
                double[] dArray = this.values[tuple.i];
                int n = tuple.j;
                dArray[n] = dArray[n] + f.applyAsDouble(tuple.value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void hadamardProductInPlace(Tensor other, DoubleUnaryOperator f) {
        if (!(other instanceof Matrix)) throw new IllegalArgumentException("Adding a non-Matrix to a Matrix");
        Matrix otherMat = (Matrix)other;
        if (this.dim1 != otherMat.getDimension1Size() || this.dim2 != otherMat.getDimension2Size()) throw new IllegalArgumentException("Matrices are not the same size, this(" + this.dim1 + "," + this.dim2 + "), other(" + otherMat.getDimension1Size() + "," + otherMat.getDimension2Size() + ")");
        if (otherMat instanceof DenseMatrix) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    double[] dArray = this.values[i];
                    int n = j;
                    dArray[n] = dArray[n] * f.applyAsDouble(otherMat.get(i, j));
                }
            }
            return;
        } else {
            for (MatrixTuple tuple : otherMat) {
                double[] dArray = this.values[tuple.i];
                int n = tuple.j;
                dArray[n] = dArray[n] * f.applyAsDouble(tuple.value);
            }
        }
    }

    @Override
    public void foreachInPlace(DoubleUnaryOperator f) {
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                this.values[i][j] = f.applyAsDouble(this.values[i][j]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void broadcastIntersectAndAddInPlace(SGDVector input, boolean broadcastOverDim1) {
        if (input instanceof DenseVector) {
            if (broadcastOverDim1) {
                if (input.size() != this.dim2) throw new IllegalArgumentException("Input vector must have dimension equal to dim 2, input.size() = " + input.size() + ", dim2 = " + this.dim2);
                for (int i = 0; i < this.dim1; ++i) {
                    for (int j = 0; j < this.dim2; ++j) {
                        double[] dArray = this.values[i];
                        int n = j;
                        dArray[n] = dArray[n] + input.get(j);
                    }
                }
                return;
            } else {
                if (input.size() != this.dim1) throw new IllegalArgumentException("Input vector must have dimension equal to dim 1, input.size() = " + input.size() + ", dim1 = " + this.dim1);
                for (int i = 0; i < this.dim1; ++i) {
                    double ith = input.get(i);
                    int j = 0;
                    while (j < this.dim2) {
                        double[] dArray = this.values[i];
                        int n = j++;
                        dArray[n] = dArray[n] + ith;
                    }
                }
            }
            return;
        } else {
            if (!(input instanceof SparseVector)) throw new IllegalArgumentException("Input vector was neither dense nor sparse.");
            if (broadcastOverDim1) {
                if (input.size() != this.dim2) throw new IllegalArgumentException("Input vector must have dimension equal to dim 2, input.size() = " + input.size() + ", dim2 = " + this.dim2);
                for (int i = 0; i < this.dim1; ++i) {
                    for (VectorTuple v : input) {
                        double[] dArray = this.values[i];
                        int n = v.index;
                        dArray[n] = dArray[n] + v.value;
                    }
                }
                return;
            } else {
                if (input.size() != this.dim1) throw new IllegalArgumentException("Input vector must have dimension equal to dim 1, input.size() = " + input.size() + ", dim1 = " + this.dim1);
                for (VectorTuple v : input) {
                    int j = 0;
                    while (j < this.dim2) {
                        double[] dArray = this.values[v.index];
                        int n = j++;
                        dArray[n] = dArray[n] + v.value;
                    }
                }
            }
        }
    }

    @Override
    public int numActiveElements(int row) {
        return this.dim2;
    }

    @Override
    public DenseVector getRow(int i) {
        return new DenseVector(this.values[i]);
    }

    public DenseVector getColumn(int index) {
        double[] output = new double[this.dim1];
        for (int i = 0; i < this.dim1; ++i) {
            output[i] = this.values[i][index];
        }
        return new DenseVector(output);
    }

    public double rowSum(int rowIndex) {
        double[] row = this.values[rowIndex];
        double sum = 0.0;
        for (int i = 0; i < row.length; ++i) {
            sum += row[i];
        }
        return sum;
    }

    public double columnSum(int columnIndex) {
        double sum = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            sum += this.values[i][columnIndex];
        }
        return sum;
    }

    @Override
    public double twoNorm() {
        double output = 0.0;
        for (int i = 0; i < this.dim1; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                double value = this.get(i, j);
                output += value * value;
            }
        }
        return Math.sqrt(output);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DenseMatrix(dim1=");
        buffer.append(this.dim1);
        buffer.append(",dim2=");
        buffer.append(this.dim2);
        buffer.append(",values=\n");
        for (int i = 0; i < this.dim1; ++i) {
            buffer.append("\trow ");
            buffer.append(i);
            buffer.append(" [");
            for (int j = 0; j < this.dim2; ++j) {
                if (this.values[i][j] < 0.0) {
                    buffer.append(String.format("%.15f", this.values[i][j]));
                } else {
                    buffer.append(String.format(" %.15f", this.values[i][j]));
                }
                buffer.append(",");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append("];\n");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public MatrixIterator iterator() {
        return new DenseMatrixIterator(this);
    }

    public void normalizeRows(VectorNormalizer normalizer) {
        for (int i = 0; i < this.dim1; ++i) {
            normalizer.normalizeInPlace(this.values[i]);
        }
    }

    public DenseVector columnSum() {
        double[] columnSum = new double[this.dim2];
        for (int i = 0; i < this.dim1; ++i) {
            for (int j = 0; j < this.dim2; ++j) {
                int n = j;
                columnSum[n] = columnSum[n] + this.values[i][j];
            }
        }
        return new DenseVector(columnSum);
    }

    private class DenseMatrixIterator
    implements MatrixIterator {
        private final DenseMatrix matrix;
        private final MatrixTuple tuple;
        private int i;
        private int j;

        public DenseMatrixIterator(DenseMatrix matrix) {
            this.matrix = matrix;
            this.tuple = new MatrixTuple();
            this.i = 0;
            this.j = 0;
        }

        @Override
        public MatrixTuple getReference() {
            return this.tuple;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.matrix.dim1 && this.j < this.matrix.dim2;
        }

        @Override
        public MatrixTuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Off the end of the iterator.");
            }
            this.tuple.i = this.i;
            this.tuple.j = this.j;
            this.tuple.value = this.matrix.values[this.i][this.j];
            if (this.j < DenseMatrix.this.dim2 - 1) {
                ++this.j;
            } else {
                ++this.i;
                this.j = 0;
            }
            return this.tuple;
        }
    }
}

