/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.util.Map;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.remote.metadata.client.DataObjectRequest;

public class PutDataObjectRequest
extends DataObjectRequest {
    private final boolean overwriteIfExists;
    private final ToXContentObject dataObject;

    public PutDataObjectRequest(String index, String id, String tenantId, boolean overwriteIfExists, ToXContentObject dataObject) {
        super(index, id, tenantId);
        this.overwriteIfExists = overwriteIfExists;
        this.dataObject = dataObject;
    }

    public boolean overwriteIfExists() {
        return this.overwriteIfExists;
    }

    public ToXContentObject dataObject() {
        return this.dataObject;
    }

    @Override
    public boolean isWriteRequest() {
        return true;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DataObjectRequest.Builder<Builder> {
        private boolean overwriteIfExists = true;
        private ToXContentObject dataObject = null;

        public Builder overwriteIfExists(boolean overwriteIfExists) {
            this.overwriteIfExists = overwriteIfExists;
            return this;
        }

        public Builder dataObject(ToXContentObject dataObject) {
            this.dataObject = dataObject;
            return this;
        }

        public Builder dataObject(Map<String, Object> dataObjectMap) {
            this.dataObject = (builder, params) -> builder.map(dataObjectMap);
            return this;
        }

        public PutDataObjectRequest build() {
            return new PutDataObjectRequest(this.index, this.id, this.tenantId, this.overwriteIfExists, this.dataObject);
        }
    }
}

