/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluatorImpl;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.RestLayerPrivilegesEvaluator;
import org.opensearch.security.user.User;

public class RestLayerPrivilegesEvaluatorImpl
implements RestLayerPrivilegesEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluatorImpl privilegesEvaluator;

    public RestLayerPrivilegesEvaluatorImpl(PrivilegesEvaluatorImpl privilegesEvaluator) {
        this.privilegesEvaluator = privilegesEvaluator;
    }

    @Override
    public PrivilegesEvaluatorResponse evaluate(User user, String routeName, Set<String> actions) {
        PrivilegesEvaluationContext context = this.privilegesEvaluator.createContext(user, routeName);
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (isDebugEnabled) {
            this.log.debug("Evaluate permissions for {}", (Object)user);
            this.log.debug("Action: {}", actions);
            this.log.debug("Mapped roles: {}", (Object)context.getMappedRoles().toString());
        }
        PrivilegesEvaluatorResponse result = this.privilegesEvaluator.getActionPrivileges().hasAnyClusterPrivilege(context, actions);
        if (!result.allowed) {
            this.log.info("No permission match for {} [Action [{}]] [RolesChecked {}]. No permissions for {}", (Object)user, (Object)routeName, context.getMappedRoles(), result.getMissingPrivileges());
        }
        return result;
    }
}

