/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.ExecutionContexts;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryLocal;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.TrieImpl;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.utils.Log;

public class TMemoryGlobal
extends ExecutionContexts
implements TMemory {
    private final Map<String, TValue> globalVariables = new HashMap<String, TValue>();
    private final TrieImpl variables = new TrieImpl();

    @Override
    public TValue getVariable(String varname) {
        return this.globalVariables.get(varname);
    }

    @Override
    public void dumpDebug(String message) {
        Log.error("[MemGlobal] Start of memory_dump " + message);
        this.dumpMemoryInternal();
        Log.error("[MemGlobal] End of memory_dump");
    }

    void dumpMemoryInternal() {
        Log.error("[MemGlobal] Number of variable(s) : " + this.globalVariables.size());
        for (Map.Entry<String, TValue> ent : new TreeMap<String, TValue>(this.globalVariables).entrySet()) {
            String name = ent.getKey();
            TValue value = ent.getValue();
            Log.error("[MemGlobal] " + name + " = " + value);
        }
    }

    @Override
    public void putVariable(String varname, TValue value, TVariableScope scope, StringLocated location) throws EaterException {
        Log.info("[MemGlobal] Setting " + varname);
        if (scope == TVariableScope.LOCAL) {
            throw new EaterException("Cannot use local variable here", location);
        }
        this.globalVariables.put(varname, value);
        this.variables.add(varname);
    }

    @Override
    public void removeVariable(String varname) {
        this.globalVariables.remove(varname);
        this.variables.remove(varname);
    }

    @Override
    public boolean isEmpty() {
        return this.globalVariables.isEmpty();
    }

    @Override
    public Set<String> variablesNames() {
        return Collections.unmodifiableSet(this.globalVariables.keySet());
    }

    @Override
    public Trie variablesNames3() {
        return this.variables;
    }

    @Override
    public TMemory forkFromGlobal(Map<String, TValue> input) {
        return new TMemoryLocal(this, input);
    }
}

