/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.net.jdbc.TNSAddress.Description;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public NavDescription(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) {
        sBuf.setLength(0);
        sBuf.append("(DESCRIPTION=");
        ConnectDescription desc = cs.newConnectDescription();
        if (this.SDU != null) {
            desc.setSdu(this.getIntValue(this.SDU, desc.getSdu()));
        }
        if (this.TDU != null) {
            desc.setTdu(this.getIntValue(this.TDU, desc.getTdu()));
        }
        if (this.connectTimeout != null) {
            desc.setConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.connectTimeout, true, desc.getConnectTimeout()));
        }
        if (this.transportTimeout != null) {
            desc.setTransportConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.transportTimeout, true, desc.getTransportConnectTimeout()));
        }
        if (this.retryCount != null) {
            cs.retryCount = this.getIntValue(this.retryCount, cs.retryCount);
            desc.setRetryCount(cs.retryCount);
        }
        if (this.delayInMillis != -1) {
            desc.setDelayInMillis(this.delayInMillis);
        }
        if (!this.failover) {
            sBuf.append("(FAILOVER=false)");
        }
        if (this.netConnectionIdPrefix != null) {
            desc.setConnectionIdPrefix(this.netConnectionIdPrefix);
        }
        if (this.checksumClient != null) {
            desc.setChecksumClient(this.checksumClient);
        }
        if (this.checksumClientTypes != null) {
            desc.setChecksumClientTypes(this.checksumClientTypes);
        }
        if (this.encryptionClient != null) {
            desc.setEncryptionClient(this.encryptionClient);
        }
        if (this.encryptionClientTypes != null) {
            desc.setEncryptionClientTypes(this.encryptionClientTypes);
        }
        if (this.allowWeakCrypto != null) {
            desc.setAllowWeakCrypto(this.allowWeakCrypto);
        }
        cs.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, cs)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
                for (int i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(cs);
                }
            } else {
                this.setConnectionOption(cs, sBuf);
            }
            this.closeNVPair(cs);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i3 = 0; i3 < this.activeChildren.size(); ++i3) {
                ((NavSchemaObject)this.activeChildren.elementAt(i3)).navigate(cs, sBuf);
            }
            this.closeNVPair(cs);
        }
        if (this.expireTime != null) {
            desc.setExpireTime(this.getIntValue(this.expireTime, -1));
        }
        if (this.loadBalance) {
            cs.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
        desc.setTokenAuthentication(this.tokenAuthentication);
        desc.setTokenLocation(this.tokenLocation);
        desc.setPasswordAuthentication(this.passwordAuthentication);
        desc.setOciIamUrl(this.ociIamUrl);
        desc.setOciTenancy(this.ociTenancy);
        desc.setOciCompartment(this.ociCompartment);
        desc.setOciDatabase(this.ociDatabase);
        cs.closeDescription();
    }

    public void closeNVPair(ConnStrategy cs) {
        if (cs.currentDescription() == null) {
            return;
        }
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption connOpt : cOpts) {
            if (this.sourceRoute) {
                connOpt.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            if (this.connectData == null) {
                this.connectData = "(SERVICE_NAME=)";
            }
            connOpt.conn_data.append("(CONNECT_DATA=");
            connOpt.conn_data.append("(CID=(PROGRAM=");
            connOpt.conn_data.append(cs.getProgramName());
            connOpt.conn_data.append(")(HOST=__jdbc__)(USER=");
            connOpt.conn_data.append(cs.getOSUsername());
            connOpt.conn_data.append("))");
            connOpt.conn_data.append(this.connectData);
            connOpt.conn_data.append(")");
            if (this.SID != null) {
                connOpt.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOpt.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOpt.instance_name = this.instanceName;
            }
            if (this.sslServerCertDN != null) {
                connOpt.sslServerCertDN = this.sslServerCertDN;
            }
            if (this.myWalletDirectory != null) {
                connOpt.walletDirectory = this.myWalletDirectory;
            }
            if (this.sslServerDNMatch != null) {
                connOpt.sslServerDNMatch = this.sslServerDNMatch;
            }
            if (this.sslAllowWeakDNMatch != null) {
                connOpt.sslAllowWeakDNMatch = this.sslAllowWeakDNMatch;
            }
            if (this.useTcpFastOpen != null) {
                connOpt.useTcpFastOpen = this.useTcpFastOpen;
            }
            connOpt.conn_data.append(")");
            connOpt.done = true;
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
    }

    private int getIntValue(String stringInt, int defaultValue) {
        try {
            return Integer.parseInt(stringInt);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    private boolean backwardCompatibilityCase(Vector children, ConnStrategy cs) {
        if (children.size() == 1 && ((NavSchemaObject)children.elementAt(0)).isA() == 1 && !((NavAddressList)children.elementAt((int)0)).sourceRoute) {
            NavAddressList addrl = (NavAddressList)children.elementAt(0);
            int numChildren = addrl.getChildrenSize();
            if (numChildren == 0) {
                return false;
            }
            for (int i2 = 0; i2 < numChildren; ++i2) {
                if (addrl.getChildrenType(i2) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy cs, StringBuffer sBuf) {
        sBuf.append("(ADDRESS_LIST=");
        NavAddressList addrl = (NavAddressList)this.children.elementAt(0);
        NavAddress first = addrl.getChild(0);
        int numChildren = addrl.getChildrenSize();
        first.navigate(cs, sBuf);
        for (int i2 = 1; i2 < numChildren; ++i2) {
            addrl.getChild(i2).addToString(cs);
        }
        cs.currentDescription().getConnectOptions().get((int)0).conn_data.append(")");
    }

    static {
        try {
            $$$methodRef$$$6 = NavDescription.class.getDeclaredConstructor(SchemaObjectFactoryInterface.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NavDescription.class.getDeclaredMethod("setConnectionOption", ConnStrategy.class, StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NavDescription.class.getDeclaredMethod("backwardCompatibilityCase", Vector.class, ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NavDescription.class.getDeclaredMethod("getIntValue", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NavDescription.class.getDeclaredMethod("addToString", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NavDescription.class.getDeclaredMethod("closeNVPair", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NavDescription.class.getDeclaredMethod("navigate", ConnStrategy.class, StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

