/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.TypePattern;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.RecordComponentBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class RecordPattern
extends TypePattern {
    public Pattern[] patterns;
    public TypeReference type;
    int thenInitStateIndex1 = -1;
    int thenInitStateIndex2 = -1;
    BranchLabel guardedElseTarget;
    private TypeBinding expectedType;

    public RecordPattern(TypeReference type, int sourceStart, int sourceEnd) {
        this.type = type;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    @Override
    public TypeReference getType() {
        return this.type;
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding castType, TypeBinding expressionType, TypeBinding match, boolean isNarrowing) {
        if (!castType.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, castType, expressionType, match, isNarrowing);
        }
        return super.checkUnsafeCast(scope, castType, expressionType, match, isNarrowing);
    }

    @Override
    public LocalVariableBinding[] bindingsWhenTrue() {
        LocalVariableBinding[] variables = NO_VARIABLES;
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            variables = LocalVariableBinding.merge(variables, p.bindingsWhenTrue());
            ++n2;
        }
        return variables;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.thenInitStateIndex1 = currentScope.methodScope().recordInitializationStates(flowInfo);
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            flowInfo = p.analyseCode(currentScope, flowContext, flowInfo);
            ++n2;
        }
        flowInfo = flowInfo.safeInitsWhenTrue();
        this.thenInitStateIndex2 = currentScope.methodScope().recordInitializationStates(flowInfo);
        return flowInfo;
    }

    @Override
    public boolean coversType(TypeBinding t) {
        if (TypeBinding.equalsEquals(t, this.resolvedType)) {
            return this.isTotalTypeNode;
        }
        if (!t.isRecord()) {
            return false;
        }
        RecordComponentBinding[] components = t.components();
        if (components == null || components.length != this.patterns.length) {
            return false;
        }
        int i = 0;
        while (i < components.length) {
            Pattern p = this.patterns[i];
            RecordComponentBinding componentBinding = components[i];
            if (!p.coversType(componentBinding.type)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public TypeBinding expectedType() {
        return this.expectedType;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding expressionType;
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.type.bits |= 0x40000000;
        this.resolvedType = this.type.resolveType(scope);
        if (!this.resolvedType.isRecord()) {
            scope.problemReporter().unexpectedTypeinRecordPattern(this.resolvedType, this.type);
            return this.resolvedType;
        }
        if (this.resolvedType.components().length != this.patterns.length) {
            scope.problemReporter().recordPatternSignatureMismatch(this.resolvedType, this);
            this.resolvedType = null;
            return null;
        }
        LocalVariableBinding[] bindings = NO_VARIABLES;
        Object[] objectArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = objectArray[n2];
            p.resolveTypeWithBindings(bindings, scope);
            bindings = LocalVariableBinding.merge(bindings, p.bindingsWhenTrue());
            ++n2;
        }
        objectArray = bindings;
        n = bindings.length;
        n2 = 0;
        while (n2 < n) {
            Object binding = objectArray[n2];
            ((LocalVariableBinding)binding).useFlag = 1;
            ++n2;
        }
        if (this.resolvedType.isRawType() && (expressionType = this.expectedType()) instanceof ReferenceBinding) {
            ReferenceBinding binding = this.inferRecordParameterization(scope, (ReferenceBinding)expressionType);
            if (binding == null || !binding.isValidBinding()) {
                scope.problemReporter().cannotInferRecordPatternTypes(this);
                this.resolvedType = null;
                return null;
            }
            this.resolvedType = binding;
        }
        if (this.resolvedType == null || !this.resolvedType.isValidBinding()) {
            return this.resolvedType;
        }
        this.isTotalTypeNode = super.coversType(this.resolvedType);
        RecordComponentBinding[] components = this.resolvedType.capture(scope, this.sourceStart, this.sourceEnd).components();
        int i = 0;
        while (i < components.length) {
            Pattern p1 = this.patterns[i];
            if (p1 instanceof TypePattern) {
                TypeBinding expressionType2;
                TypePattern tp = (TypePattern)p1;
                RecordComponentBinding componentBinding = components[i];
                if ((p1.getType() == null || p1.getType().isTypeNameVar(scope)) && tp.local.binding != null) {
                    tp.local.binding.type = componentBinding.type;
                }
                if (p1.isPatternTypeCompatible(expressionType2 = componentBinding.type, scope)) {
                    p1.isTotalTypeNode = p1.coversType(componentBinding.type);
                    MethodBinding[] methods = this.resolvedType.getMethods(componentBinding.name);
                    if (methods != null && methods.length > 0) {
                        p1.accessorMethod = methods[0];
                    }
                }
                this.isTotalTypeNode &= p1.isTotalTypeNode;
            }
            ++i;
        }
        return this.resolvedType;
    }

    private ReferenceBinding inferRecordParameterization(BlockScope scope, ReferenceBinding proposedMatchingType) {
        InferenceContext18 freshInferenceContext = new InferenceContext18(scope);
        try {
            ReferenceBinding referenceBinding = freshInferenceContext.inferRecordPatternParameterization(this, scope, proposedMatchingType);
            return referenceBinding;
        }
        finally {
            freshInferenceContext.cleanUp();
        }
    }

    @Override
    public boolean isAlwaysTrue() {
        return false;
    }

    @Override
    public boolean dominates(Pattern p) {
        if (!this.resolvedType.isValidBinding()) {
            return false;
        }
        if (!super.coversType(p.resolvedType)) {
            return false;
        }
        if (p instanceof RecordPattern) {
            RecordPattern rp = (RecordPattern)p;
            if (this.patterns.length != rp.patterns.length) {
                return false;
            }
            int i = 0;
            while (i < this.patterns.length) {
                if (!this.patterns[i].dominates(rp.patterns[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void generateOptimizedBoolean(BlockScope currentScope, CodeStream codeStream, BranchLabel trueLabel, BranchLabel falseLabel) {
        codeStream.checkcast(this.resolvedType);
        ArrayList<ExceptionLabel> labels = new ArrayList<ExceptionLabel>();
        int i = 0;
        int length = this.patterns.length;
        while (i < length) {
            boolean lastComponent;
            Pattern p = this.patterns[i];
            boolean bl = lastComponent = i == length - 1;
            if (!lastComponent) {
                codeStream.dup();
            }
            ExceptionLabel exceptionLabel = new ExceptionLabel(codeStream, TypeBinding.wellKnownType(currentScope, 21));
            exceptionLabel.placeStart();
            codeStream.invoke((byte)-74, p.accessorMethod.original(), this.resolvedType, null);
            exceptionLabel.placeEnd();
            labels.add(exceptionLabel);
            if (TypeBinding.notEquals(p.accessorMethod.original().returnType.erasure(), p.accessorMethod.returnType.erasure())) {
                codeStream.checkcast(p.accessorMethod.returnType);
            }
            if (p instanceof RecordPattern || !p.isTotalTypeNode) {
                codeStream.dup();
                codeStream.instance_of(p.resolvedType);
                BranchLabel target = falseLabel != null ? falseLabel : new BranchLabel(codeStream);
                BranchLabel innerTruthLabel = new BranchLabel(codeStream);
                codeStream.ifne(innerTruthLabel);
                int pops = 1;
                Pattern current = p;
                RecordPattern outer = this;
                while (outer != null) {
                    RecordPattern rp;
                    if (current.index != outer.patterns.length - 1) {
                        ++pops;
                    }
                    current = outer;
                    Pattern pattern = outer.getEnclosingPattern();
                    RecordPattern recordPattern = outer = pattern instanceof RecordPattern ? (rp = (RecordPattern)pattern) : null;
                }
                while (pops > 1) {
                    codeStream.pop2();
                    pops -= 2;
                }
                if (pops > 0) {
                    codeStream.pop();
                }
                codeStream.goto_(target);
                innerTruthLabel.place();
            }
            p.generateOptimizedBoolean(currentScope, codeStream, trueLabel, falseLabel);
            ++i;
        }
        if (labels.size() > 0) {
            BlockScope trapScope = codeStream.accessorExceptionTrapScopes.peek();
            List<ExceptionLabel> eLabels = codeStream.patternAccessorMap.get(trapScope);
            if (eLabels == null || eLabels.isEmpty()) {
                eLabels = labels;
            } else {
                eLabels.addAll(labels);
            }
            codeStream.patternAccessorMap.put(trapScope, eLabels);
        }
        if (this.thenInitStateIndex2 != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex2);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex2);
        }
    }

    @Override
    public void suspendVariables(CodeStream codeStream, BlockScope scope) {
        codeStream.removeNotDefinitelyAssignedVariables(scope, this.thenInitStateIndex1);
    }

    @Override
    public void resumeVariables(CodeStream codeStream, BlockScope scope) {
        codeStream.addDefinitelyAssignedVariables(scope, this.thenInitStateIndex2);
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            Pattern[] patternArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                p.traverse(visitor, scope);
                ++n2;
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append(this.type).append('(');
        if (this.patterns != null) {
            int i = 0;
            while (i < this.patterns.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.patterns[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        return output;
    }
}

